/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.Attribute;
import gov.nasa.gsfc.spdf.cdfj.AttributeEntry;
import gov.nasa.gsfc.spdf.cdfj.BaseVarContainer;
import gov.nasa.gsfc.spdf.cdfj.ByteVarContainer;
import gov.nasa.gsfc.spdf.cdfj.CDFCore;
import gov.nasa.gsfc.spdf.cdfj.CDFFactory;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.DoubleArray;
import gov.nasa.gsfc.spdf.cdfj.DoubleVarContainer;
import gov.nasa.gsfc.spdf.cdfj.FloatVarContainer;
import gov.nasa.gsfc.spdf.cdfj.GlobalAttribute;
import gov.nasa.gsfc.spdf.cdfj.IntVarContainer;
import gov.nasa.gsfc.spdf.cdfj.LongArray;
import gov.nasa.gsfc.spdf.cdfj.LongVarContainer;
import gov.nasa.gsfc.spdf.cdfj.ShortVarContainer;
import gov.nasa.gsfc.spdf.cdfj.StringArray;
import gov.nasa.gsfc.spdf.cdfj.StringVarContainer;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import gov.nasa.gsfc.spdf.cdfj.VariableDataBuffer;
import gov.nasa.gsfc.spdf.cdfj.VariableDataLocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

abstract class CDFImpl
implements Serializable {
    public static final int GDR_RECORD = 2;
    public static final int FLAGS_MAJORITY_MASK = 1;
    public static final int ROW_MAJOR = 1;
    public static final int VXR_RECORD_TYPE = 6;
    public static final int VVR_RECORD_TYPE = 7;
    public static final int CVVR_RECORD_TYPE = 13;
    public static final String STRINGDELIMITER = new String("\\N ");
    int offset_NEXT_VDR;
    int offset_NEXT_ADR;
    int offset_ATTR_NAME;
    int offset_SCOPE;
    int offset_AgrEDRHead;
    int offset_AzEDRHead;
    int offset_NEXT_AEDR;
    int offset_ENTRYNUM;
    int offset_ATTR_DATATYPE;
    int offset_ATTR_NUM_ELEMENTS;
    int offset_VALUE;
    int offset_VAR_NAME;
    int offset_VAR_NUM_ELEMENTS;
    int offset_NUM;
    int offset_FLAGS;
    int offset_sRecords;
    int offset_BLOCKING_FACTOR;
    int offset_VAR_DATATYPE;
    int offset_zNumDims;
    int offset_FIRST_VXR;
    int offset_NEXT_VXR;
    int offset_NENTRIES;
    int offset_NUSED;
    int offset_FIRST;
    int offset_RECORD_TYPE;
    int offset_RECORDS;
    int offset_CSIZE;
    int offset_CDATA;
    int version;
    int release;
    int encoding;
    int flags;
    int increment;
    transient ByteOrder byteOrder;
    boolean bigEndian;
    long GDROffset;
    long rVDRHead;
    long zVDRHead;
    long ADRHead;
    int numberOfRVariables;
    int numberOfAttributes;
    int numberOfZVariables;
    int[] rDimSizes;
    int lastLeapSecondId;
    transient ByteBuffer buf;
    protected String[] varNames;
    protected Hashtable variableTable;
    Hashtable attributeTable;
    protected CDFCore thisCDF;
    protected CDFFactory.CDFSource source;
    protected CDFFactory.ProcessingOption processingOption;

    protected CDFImpl(ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
    }

    protected ByteBuffer getRecord(long l) {
        ByteBuffer byteBuffer = this.buf.duplicate();
        byteBuffer.position((int)l);
        return byteBuffer.slice();
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public boolean rowMajority() {
        return (this.flags & 1) == 1;
    }

    protected Hashtable variables() {
        int n;
        if (this.variableTable != null) {
            return this.variableTable;
        }
        int[] nArray = new int[]{(int)this.zVDRHead, (int)this.rVDRHead};
        String[] stringArray = new String[]{"z", "r"};
        Hashtable<String, CDFVariable> hashtable = new Hashtable<String, CDFVariable>();
        Vector<String> vector = new Vector<String>();
        block0: for (n = 0; n < 2; ++n) {
            long l = nArray[n];
            if (l == 0L) continue;
            ByteBuffer byteBuffer = this.getRecord(l);
            while (true) {
                byteBuffer.position(this.offset_NEXT_VDR);
                long l2 = this.longInt(byteBuffer);
                CDFVariable cDFVariable = new CDFVariable(l, stringArray[n]);
                String string = cDFVariable.getName();
                vector.add(string);
                hashtable.put(string, cDFVariable);
                if (l2 == 0L) continue block0;
                l = l2;
                byteBuffer = this.getRecord(l);
            }
        }
        this.varNames = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            this.varNames[n] = (String)vector.elementAt(n);
        }
        this.variableTable = hashtable;
        return hashtable;
    }

    public String[] getVariableNames() {
        String[] stringArray = new String[this.varNames.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.varNames[i];
        }
        return stringArray;
    }

    public Variable getVariable(String string) {
        return (Variable)this.variableTable.get(string);
    }

    public String[] getVariableNames(String string) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.varNames.length; ++i) {
            String string2;
            Vector vector2 = (Vector)this.getAttribute(this.varNames[i], "VAR_TYPE");
            if (vector2 == null || vector2.size() == 0 || !(string2 = (String)vector2.elementAt(0)).equals(string)) continue;
            vector.add(this.varNames[i]);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public String[] globalAttributeNames() {
        Object object;
        Vector<String> vector = new Vector<String>();
        if (this.attributeTable == null) {
            return new String[0];
        }
        Set set = this.attributeTable.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object = (CDFAttribute)this.attributeTable.get(iterator.next());
            if (!((CDFAttribute)object).isGlobal()) continue;
            vector.add(((CDFAttribute)object).name);
        }
        object = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            object[i] = (String)vector.elementAt(i);
        }
        return object;
    }

    public String[] variableAttributeNames(String string) {
        CDFVariable cDFVariable = (CDFVariable)this.variableTable.get(string);
        if (cDFVariable == null) {
            return null;
        }
        String[] stringArray = new String[cDFVariable.attributes.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            AttributeEntry attributeEntry = (AttributeEntry)cDFVariable.attributes.elementAt(i);
            stringArray[i] = attributeEntry.getAttributeName();
        }
        return stringArray;
    }

    public Object getAttribute(String string) {
        if (this.attributeTable == null) {
            return null;
        }
        CDFAttribute cDFAttribute = (CDFAttribute)this.attributeTable.get(string);
        if (cDFAttribute == null) {
            return null;
        }
        if (!cDFAttribute.isGlobal()) {
            return null;
        }
        if (cDFAttribute.gEntries.size() == 0) {
            return null;
        }
        AttributeEntry attributeEntry = (AttributeEntry)cDFAttribute.gEntries.elementAt(0);
        if (attributeEntry.isStringType()) {
            String[] stringArray = new String[cDFAttribute.gEntries.size()];
            for (int i = 0; i < cDFAttribute.gEntries.size(); ++i) {
                attributeEntry = (AttributeEntry)cDFAttribute.gEntries.elementAt(i);
                stringArray[i] = (String)attributeEntry.getValue();
            }
            return stringArray;
        }
        return attributeEntry.getValue();
    }

    public GlobalAttribute getGlobalAttribute(String string) throws Throwable {
        if (this.attributeTable == null) {
            throw new Throwable("No attribute named " + string);
        }
        final CDFAttribute cDFAttribute = (CDFAttribute)this.attributeTable.get(string);
        if (cDFAttribute == null) {
            throw new Throwable("No attribute named " + string);
        }
        if (!cDFAttribute.isGlobal()) {
            throw new Throwable("No global attribute named " + string);
        }
        return new GlobalAttribute(){

            @Override
            public String getName() {
                return cDFAttribute.getName();
            }

            @Override
            public boolean isGlobal() {
                return true;
            }

            @Override
            public int getNum() {
                return cDFAttribute.num;
            }

            @Override
            public int getEntryCount() {
                return cDFAttribute.gEntries.size();
            }

            @Override
            public Object getEntry(int n) {
                if (n > cDFAttribute.gEntries.size()) {
                    return null;
                }
                if (n < 0) {
                    return null;
                }
                AttributeEntry attributeEntry = (AttributeEntry)cDFAttribute.gEntries.elementAt(n);
                return attributeEntry.getValue();
            }

            @Override
            public boolean isStringType(int n) throws Throwable {
                if (n < 0 || n > cDFAttribute.gEntries.size()) {
                    throw new Throwable("Invalid attribute index");
                }
                AttributeEntry attributeEntry = (AttributeEntry)cDFAttribute.gEntries.elementAt(n);
                return attributeEntry.isStringType();
            }

            @Override
            public boolean isLongType(int n) throws Throwable {
                if (n < 0 || n > cDFAttribute.gEntries.size()) {
                    throw new Throwable("Invalid attribute index");
                }
                AttributeEntry attributeEntry = (AttributeEntry)cDFAttribute.gEntries.elementAt(n);
                return attributeEntry.isLongType();
            }
        };
    }

    public Object getAttribute(String string, String string2) {
        CDFVariable cDFVariable = (CDFVariable)this.variableTable.get(string);
        if (cDFVariable == null) {
            return null;
        }
        Vector vector = cDFVariable.attributes;
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < vector.size(); ++i) {
            AttributeEntry attributeEntry = (AttributeEntry)vector.elementAt(i);
            if (!attributeEntry.getAttributeName().equals(string2)) continue;
            vector2.add(attributeEntry.getValue());
        }
        return vector2;
    }

    public Vector getAttributeEntries(String string) throws Throwable {
        if (this.attributeTable == null) {
            throw new Throwable("No attribute named " + string);
        }
        CDFAttribute cDFAttribute = (CDFAttribute)this.attributeTable.get(string);
        if (cDFAttribute == null) {
            throw new Throwable("No attribute named " + string);
        }
        if (!cDFAttribute.isGlobal()) {
            throw new Throwable("No global attribute named " + string);
        }
        return cDFAttribute.gEntries;
    }

    public Vector getAttributeEntries(String string, String string2) {
        CDFVariable cDFVariable = (CDFVariable)this.variableTable.get(string);
        if (cDFVariable == null) {
            return null;
        }
        Vector vector = cDFVariable.attributes;
        Vector<AttributeEntry> vector2 = new Vector<AttributeEntry>();
        for (int i = 0; i < vector.size(); ++i) {
            AttributeEntry attributeEntry = (AttributeEntry)vector.elementAt(i);
            if (!attributeEntry.getAttributeName().equals(string2)) continue;
            vector2.add(attributeEntry);
        }
        return vector2;
    }

    Variable getCDFVariable(String string, int n) {
        Set set = this.variableTable.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            CDFVariable cDFVariable = (CDFVariable)this.variableTable.get(iterator.next());
            if (!cDFVariable.vtype.equals(string) || cDFVariable.number != n) continue;
            return cDFVariable;
        }
        return null;
    }

    Hashtable attributes() {
        if (this.attributeTable != null) {
            return this.attributeTable;
        }
        long l = this.ADRHead;
        if (l == 0L) {
            return null;
        }
        Hashtable<String, CDFAttribute> hashtable = new Hashtable<String, CDFAttribute>();
        ByteBuffer byteBuffer = this.getRecord(l);
        while (true) {
            byteBuffer.position(this.offset_NEXT_ADR);
            long l2 = this.longInt(byteBuffer);
            CDFAttribute cDFAttribute = new CDFAttribute(l);
            CDFAttribute cDFAttribute2 = hashtable.put(cDFAttribute.getName(), cDFAttribute);
            if (cDFAttribute2 != null) {
                System.out.println("possibly duplicate attribute " + cDFAttribute.getName());
            }
            if (l2 == 0L) break;
            l = l2;
            byteBuffer = this.getRecord(l);
        }
        this.attributeTable = hashtable;
        return hashtable;
    }

    Object getPadValue(Variable variable) {
        return variable.getPadValue(true);
    }

    Object getFillValue(Variable variable) {
        Vector vector = (Vector)this.getAttribute(variable.getName(), "FILLVAL");
        int n = variable.getType();
        if (vector.size() != 0) {
            if (vector.get(0).getClass().getComponentType() == Double.TYPE) {
                double d = ((double[])vector.get(0))[0];
                if (DataTypes.typeCategory[n] == 5) {
                    return new long[]{0L, (long)d};
                }
                return new double[]{0.0, d};
            }
            long l = ((long[])vector.get(0))[0];
            if (DataTypes.typeCategory[n] == 5) {
                return new long[]{0L, l};
            }
            return new double[]{0.0, l};
        }
        if (DataTypes.typeCategory[n] == 5) {
            return new long[]{Long.MIN_VALUE, 0L};
        }
        return new double[]{Double.NEGATIVE_INFINITY, 0.0};
    }

    ByteBuffer positionBuffer(Variable variable, long l, int n) {
        ByteBuffer byteBuffer;
        if (!variable.isCompressed()) {
            byteBuffer = this.getValueBuffer(l);
        } else {
            int n2 = variable.getDataItemSize();
            byteBuffer = this.getValueBuffer(l, n2, n);
        }
        byteBuffer.order(this.getByteOrder());
        return byteBuffer;
    }

    public ByteBuffer getValueBuffer(long l) {
        ByteBuffer byteBuffer = this.getRecord(l);
        byteBuffer.position(this.offset_RECORDS);
        return byteBuffer;
    }

    public ByteBuffer getValueBuffer(long l, int n, int n2) {
        ByteBuffer byteBuffer = this.getRecord(l);
        if (byteBuffer.getInt(this.offset_RECORD_TYPE) == 7) {
            byteBuffer.position(this.offset_RECORDS);
            return byteBuffer;
        }
        int n3 = this.lowOrderInt(byteBuffer, this.offset_CSIZE);
        byte[] byArray = new byte[n3];
        byteBuffer.position(this.offset_CDATA);
        byteBuffer.get(byArray);
        byte[] byArray2 = new byte[n * n2];
        int n4 = 0;
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
            int n5 = 0;
            for (int i = byArray2.length; i > 0 && (n4 = gZIPInputStream.read(byArray2, n5, i)) != -1; i -= n4) {
                n5 += n4;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString() + " at offset " + l);
            System.out.println("Trying to get data as uncompressed");
            return this.getValueBuffer(l);
        }
        if (n4 < 0) {
            return null;
        }
        return ByteBuffer.wrap(byArray2);
    }

    public int[] variableDimensions(String string) {
        Variable variable = (Variable)this.variableTable.get(string);
        if (variable == null) {
            return null;
        }
        int[] nArray = variable.getDimensions();
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray2, 0, nArray, 0, nArray.length);
        return nArray2;
    }

    protected abstract long longInt(ByteBuffer var1);

    protected abstract int lowOrderInt(ByteBuffer var1);

    protected abstract int lowOrderInt(ByteBuffer var1, int var2);

    protected abstract String getString(long var1);

    protected String getString(long l, int n) {
        return this.getString(this.getRecord(l), n);
    }

    protected String getString(ByteBuffer byteBuffer, int n) {
        int n2;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n; ++n2) {
            byArray[n2] = byteBuffer.get();
            if (byArray[n2] == 0) break;
        }
        return new String(byArray, 0, n2);
    }

    public static Object getNumberAttribute(int n, int n2, ByteBuffer byteBuffer, ByteOrder byteOrder) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.order(byteOrder);
        int n3 = n2;
        if (n == 32) {
            n3 = 2 * n2;
        }
        long[] lArray = null;
        double[] dArray = null;
        long l = DataTypes.longInt[n];
        boolean bl = false;
        try {
            if (n > 20 || n < 10) {
                if (DataTypes.typeCategory[n] == 5) {
                    lArray = new long[n3];
                    bl = true;
                } else {
                    dArray = new double[n3];
                }
                for (int i = 0; i < n3; ++i) {
                    Number number = (Number)DataTypes.method[n].invoke((Object)byteBuffer2, new Object[0]);
                    if (!bl) {
                        dArray[i] = number.doubleValue();
                    }
                    if (!bl) continue;
                    lArray[i] = number.longValue();
                }
            } else {
                dArray = new double[n3];
                for (int i = 0; i < n2; ++i) {
                    Number number = (Number)DataTypes.method[n].invoke((Object)byteBuffer2, new Object[0]);
                    int n4 = number.intValue();
                    dArray[i] = n4 >= 0 ? (double)n4 : (double)(l + (long)n4);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("getNumberAttribute: " + byteBuffer);
            System.out.println("type: " + n);
            exception.printStackTrace();
            return null;
        }
        if (bl) {
            return lArray;
        }
        return dArray;
    }

    protected void setByteOrder(ByteOrder byteOrder) {
        this.bigEndian = byteOrder.equals(ByteOrder.BIG_ENDIAN);
    }

    protected void setByteOrder(boolean bl) {
        this.byteOrder = bl ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.setByteOrder(this.byteOrder);
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    protected void setBuffer(ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
    }

    protected ByteBuffer getBuffer() {
        return this.buf;
    }

    public void extractBytes(int n, byte[] byArray, int n2, int n3) {
        ((ByteBuffer)this.buf.duplicate().position(n)).get(byArray, n2, n3);
    }

    protected int getRecordOffset() {
        return this.offset_RECORDS;
    }

    protected void setSource(CDFFactory.CDFSource cDFSource) {
        this.source = cDFSource;
    }

    public CDFFactory.CDFSource getSource() {
        return this.source;
    }

    protected void setOption(CDFFactory.ProcessingOption processingOption) {
        this.processingOption = processingOption;
    }

    public double[] get1D(String string) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        if (!variable.isCompatible(Double.TYPE)) {
            throw new Throwable("Variable " + string + " cannot be " + "converted to double, or the conversion may result in loss of " + "precision. Use get1D(" + string + ", Boolean.TRUE) for " + "string type. Otherwise use get1D(" + string + ", false");
        }
        return variable.asDoubleArray();
    }

    public double[] getOneD(String string, boolean bl) throws Throwable {
        CDFVariable cDFVariable = (CDFVariable)this.getVariable(string);
        if (cDFVariable == null) {
            throw new Throwable("No such variable: " + string);
        }
        if (!cDFVariable.isCompatible(Double.TYPE)) {
            throw new Throwable("Variable " + string + " cannot be " + "converted to double, or the conversion may result in loss of " + "precision. Use getOneD(" + string + ", Boolean.TRUE) for " + "string type. Otherwise use get1D(" + string + ", false");
        }
        TargetAttribute targetAttribute = new TargetAttribute(false, bl);
        return cDFVariable.asDoubleArray(targetAttribute, null);
    }

    public byte[] get1D(String string, Boolean bl) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        int n = variable.getType();
        if (!DataTypes.isStringType(n)) {
            throw new Throwable("Variable " + string + " is not a string variable");
        }
        return variable.asByteArray(null);
    }

    public byte[] getOneD(String string, Boolean bl, boolean bl2) throws Throwable {
        CDFVariable cDFVariable = (CDFVariable)this.getVariable(string);
        if (cDFVariable == null) {
            throw new Throwable("No such variable: " + string);
        }
        int n = cDFVariable.getType();
        if (!DataTypes.isStringType(n)) {
            throw new Throwable("Variable " + string + " is not a string variable");
        }
        return cDFVariable.asByteArray(null, bl2);
    }

    public Object get1D(String string, boolean bl) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        int n = variable.getType();
        if (DataTypes.isStringType(n)) {
            return variable.asByteArray(null);
        }
        if (bl && DataTypes.isLongType(n)) {
            return variable.asLongArray(null);
        }
        return variable.asDoubleArray();
    }

    public Object get1D(String string, int n) throws Throwable {
        return this.get1D(string, n, -1);
    }

    public Object get1D(String string, int n, int n2) throws Throwable {
        int[] nArray;
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        int n3 = variable.getType();
        if (n2 >= 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = n;
            nArray = nArray2;
            nArray2[1] = n2;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = n;
        }
        int[] nArray4 = nArray;
        if (DataTypes.isLongType(n3)) {
            return variable.asLongArray(nArray4);
        }
        if (DataTypes.isStringType(n3)) {
            return variable.asByteArray(nArray4);
        }
        return variable.asDoubleArray(nArray4);
    }

    public Object get(String string) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        if (DataTypes.isStringType(variable.getType())) {
            VDataContainer.CString cString = variable.getStringContainer(null);
            cString.run();
            StringArray stringArray = (StringArray)cString.asArray();
            return stringArray.array();
        }
        VDataContainer.CDouble cDouble = variable.getDoubleContainer(null, false);
        cDouble.run();
        DoubleArray doubleArray = cDouble.asArray();
        return doubleArray.array();
    }

    public Object getLong(String string) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        if (!DataTypes.isLongType(variable.getType())) {
            throw new Throwable("getLong method appropriate for TT2000 and INT8 types. ");
        }
        VDataContainer.CLong cLong = variable.getLongContainer(null);
        cLong.run();
        LongArray longArray = cLong.asArray();
        return longArray.array();
    }

    public Object get(String string, int n) throws Throwable {
        return this.get(string, new int[]{n});
    }

    public Object get(String string, int[] nArray) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        if (DataTypes.isStringType(variable.getType())) {
            throw new Throwable("Function not supported for string variables");
        }
        DoubleVarContainer doubleVarContainer = new DoubleVarContainer(this, variable, null, false, ByteOrder.nativeOrder());
        doubleVarContainer.run();
        return doubleVarContainer.asArrayElement(nArray);
    }

    public Object get(String string, int n, int n2) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        if (DataTypes.isStringType(variable.getType())) {
            throw new Throwable("Function not supported for string variables");
        }
        DoubleVarContainer doubleVarContainer = new DoubleVarContainer(this, variable, null, false, ByteOrder.nativeOrder());
        doubleVarContainer.run();
        return doubleVarContainer.asArrayElement(n, n2);
    }

    public Object get(String string, int n, int n2, int n3) throws Throwable {
        return this.get(string, n, n2, new int[]{n3});
    }

    public Object get(String string, int n, int n2, int[] nArray) throws Throwable {
        DoubleVarContainer doubleVarContainer = this.getRangeBuffer(string, n, n2);
        return doubleVarContainer.asArrayElement(nArray);
    }

    public Object getPoint(String string, int n) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        if (DataTypes.isStringType(variable.getType())) {
            VDataContainer.CString cString = variable.getStringContainer(null);
            cString.run();
            StringArray stringArray = (StringArray)cString.asArray();
            return stringArray.array();
        }
        DoubleVarContainer doubleVarContainer = new DoubleVarContainer(this, variable, new int[]{n}, false, ByteOrder.nativeOrder());
        doubleVarContainer.run();
        return doubleVarContainer.asArray().array();
    }

    public Object getRange(String string, int n, int n2, boolean bl) throws Throwable {
        DoubleVarContainer doubleVarContainer = this.getRangeBuffer(string, n, n2);
        if (bl) {
            return doubleVarContainer.as1DArray();
        }
        return doubleVarContainer.asArray().array();
    }

    public Object getRange(String string, int n, int n2) throws Throwable {
        return this.getRange(string, n, n2, false);
    }

    public Object getRangeOneD(String string, int n, int n2, boolean bl) throws Throwable {
        DoubleVarContainer doubleVarContainer = this.getRangeBuffer(string, n, n2);
        return doubleVarContainer.asOneDArray(bl);
    }

    DoubleVarContainer getRangeBuffer(String string, int n, int n2) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        if (DataTypes.isStringType(variable.getType())) {
            throw new Throwable("Function not supported for string variables");
        }
        int[] nArray = new int[]{n, n2};
        DoubleVarContainer doubleVarContainer = new DoubleVarContainer(this, variable, nArray, false, ByteOrder.nativeOrder());
        doubleVarContainer.run();
        return doubleVarContainer;
    }

    public Object getRange(String string, int n, int n2, int n3) throws Throwable {
        return this.getRange(string, n, n2, new int[]{n3});
    }

    public Object getRange(String string, int n, int n2, int[] nArray) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        if (DataTypes.isStringType(variable.getType())) {
            throw new Throwable("Function not supported for string variables");
        }
        DoubleVarContainer doubleVarContainer = this.getRangeBuffer(string, n, n2);
        return doubleVarContainer.asArrayElement(nArray);
    }

    public boolean isCompatible(String string, Class clazz) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        return variable.isCompatible(clazz);
    }

    public byte[] getByteArray(String string, int[] nArray) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        return variable.asByteArray(nArray);
    }

    public double[] getDoubleArray(String string, int[] nArray) throws Throwable {
        return this.getDoubleArray(string, nArray, true);
    }

    public double[] getDoubleArray(String string, int[] nArray, boolean bl) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        return variable.asDoubleArray(bl, nArray);
    }

    public float[] getFloatArray(String string, int[] nArray) throws Throwable {
        return this.getFloatArray(string, nArray, true);
    }

    public float[] getFloatArray(String string, int[] nArray, boolean bl) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        return variable.asFloatArray(bl, nArray);
    }

    public int[] getIntArray(String string, int[] nArray) throws Throwable {
        return this.getIntArray(string, nArray, true);
    }

    public int[] getIntArray(String string, int[] nArray, boolean bl) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        return variable.asIntArray(bl, nArray);
    }

    public long[] getLongArray(String string, int[] nArray) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        return variable.asLongArray(nArray);
    }

    public short[] getShortArray(String string, int[] nArray) throws Throwable {
        return this.getShortArray(string, nArray, true);
    }

    public short[] getShortArray(String string, int[] nArray, boolean bl) throws Throwable {
        Variable variable = this.getVariable(string);
        if (variable == null) {
            throw new Throwable("No such variable: " + string);
        }
        return variable.asShortArray(bl, nArray);
    }

    public static TargetAttribute targetAttributeInstance(boolean bl, boolean bl2) {
        return new TargetAttribute(bl, bl2);
    }

    static class TargetAttribute {
        public final boolean preserve;
        public final boolean columnMajor;

        TargetAttribute(boolean bl, boolean bl2) {
            this.preserve = bl;
            this.columnMajor = bl2;
        }
    }

    public class DataLocator
    implements VariableDataLocator,
    Serializable {
        private transient ByteBuffer _buf;
        private int numberOfValues;
        private boolean compressed;
        protected Vector locations = new Vector();

        protected DataLocator(ByteBuffer byteBuffer, int n, boolean bl) {
            this._buf = byteBuffer;
            this.numberOfValues = n;
            this.compressed = bl;
            this._buf.position(CDFImpl.this.offset_FIRST_VXR);
            long l = CDFImpl.this.longInt(this._buf);
            ByteBuffer byteBuffer2 = CDFImpl.this.getRecord(l);
            Vector vector = this._getLocations(byteBuffer2);
            this.registerNodes(byteBuffer2, vector);
        }

        public boolean isReallyCompressed() {
            return this.compressed;
        }

        @Override
        public long[][] getLocations() {
            long[][] lArray = new long[this.locations.size()][3];
            for (int i = 0; i < this.locations.size(); ++i) {
                long[] lArray2 = (long[])this.locations.elementAt(i);
                lArray[i][0] = lArray2[0];
                lArray[i][1] = lArray2[1];
                lArray[i][2] = lArray2[2];
            }
            return lArray;
        }

        Vector _getLocations(ByteBuffer byteBuffer) {
            Vector<long[]> vector = new Vector<long[]>();
            while (true) {
                byteBuffer.position(CDFImpl.this.offset_NEXT_VXR);
                long l = CDFImpl.this.longInt(byteBuffer);
                byteBuffer.position(CDFImpl.this.offset_NENTRIES);
                int n = byteBuffer.getInt();
                byteBuffer.position(CDFImpl.this.offset_NUSED);
                int n2 = byteBuffer.getInt();
                byteBuffer.position(CDFImpl.this.offset_FIRST);
                ByteBuffer byteBuffer2 = byteBuffer.slice();
                byteBuffer.position(CDFImpl.this.offset_FIRST + n * 4);
                ByteBuffer byteBuffer3 = byteBuffer.slice();
                byteBuffer.position(CDFImpl.this.offset_FIRST + 2 * n * 4);
                ByteBuffer byteBuffer4 = byteBuffer.slice();
                for (int i = 0; i < n2; ++i) {
                    long l2 = byteBuffer2.getInt();
                    long l3 = byteBuffer3.getInt();
                    if (l3 > (long)(this.numberOfValues - 1)) {
                        l3 = this.numberOfValues - 1;
                    }
                    long l4 = CDFImpl.this.longInt(byteBuffer4);
                    vector.add(new long[]{l2, l3, l4});
                }
                if (l == 0L) break;
                byteBuffer = CDFImpl.this.getRecord(l);
            }
            return vector;
        }

        void registerNodes(ByteBuffer byteBuffer, Vector vector) {
            int n = 7;
            if (this.compressed) {
                n = 13;
            }
            for (int i = 0; i < vector.size(); ++i) {
                long[] lArray = (long[])vector.elementAt(i);
                ByteBuffer byteBuffer2 = CDFImpl.this.getRecord(lArray[2]);
                if (byteBuffer2.getInt(CDFImpl.this.offset_RECORD_TYPE) == 6) {
                    Vector vector2 = this._getLocations(byteBuffer2);
                    this.registerNodes(byteBuffer2, vector2);
                    continue;
                }
                this.locations.add(lArray);
            }
        }

        public Vector getLocationsAsVector() {
            Vector<long[]> vector = new Vector<long[]>();
            long[][] lArray = this.getLocations();
            for (int i = 0; i < this.locations.size(); ++i) {
                vector.add(lArray[i]);
            }
            return vector;
        }
    }

    public class CDFVariable
    implements Serializable,
    Variable {
        int DIMENSION_VARIES = -1;
        public Vector attributes = new Vector();
        String name;
        public int number;
        String vtype;
        int flags;
        int sRecords;
        int type;
        int numberOfElements;
        protected int numberOfValues;
        public int[] dimensions;
        public boolean[] varies;
        public Object padValue;
        long offset;
        boolean completed = false;
        transient ByteBuffer _buf;
        int dataItemSize;
        int blockingFactor;
        DataLocator locator;
        boolean recordGap = false;

        public CDFVariable(long l, String string) {
            int n;
            this.offset = l;
            this.vtype = string;
            this._buf = CDFImpl.this.getRecord(l);
            this.name = CDFImpl.this.getString(l + (long)CDFImpl.this.offset_VAR_NAME);
            this._buf.position(CDFImpl.this.offset_VAR_NUM_ELEMENTS);
            this.numberOfElements = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_NUM);
            this.number = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_FLAGS);
            this.flags = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_sRecords);
            this.sRecords = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_BLOCKING_FACTOR);
            this.blockingFactor = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_VAR_DATATYPE);
            this.type = this._buf.getInt();
            this.numberOfValues = this._buf.getInt() + 1;
            this._buf.position(CDFImpl.this.offset_zNumDims);
            if (string.equals("r")) {
                this.dimensions = CDFImpl.this.rDimSizes;
            }
            if (string.equals("z")) {
                this.dimensions = new int[this._buf.getInt()];
                for (n = 0; n < this.dimensions.length; ++n) {
                    this.dimensions[n] = this._buf.getInt();
                }
            }
            this.varies = new boolean[this.dimensions.length];
            for (n = 0; n < this.dimensions.length; ++n) {
                this.varies[n] = this._buf.getInt() == this.DIMENSION_VARIES;
            }
            if (this.type == 32) {
                this.dimensions = new int[]{2};
            }
            if (this.type == 32) {
                this.varies = new boolean[]{true};
            }
            this.dataItemSize = DataTypes.size[this.type];
            this.padValue = null;
            n = this.getDataItemSize() / this.dataItemSize;
            Object object = DataTypes.defaultPad(this.type);
            if (DataTypes.isStringType(this.type)) {
                int n2;
                byte[] byArray = new byte[this.numberOfElements];
                if (this.padValueSpecified()) {
                    this._buf.get(byArray);
                    for (n2 = 0; n2 < this.numberOfElements; ++n2) {
                        if (byArray[n2] > 0) continue;
                        byArray[n2] = 32;
                    }
                } else {
                    for (n2 = 0; n2 < this.numberOfElements; ++n2) {
                        byArray[n2] = (Byte)object;
                    }
                }
                object = new String(byArray);
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = (String)object;
                }
                this.padValue = stringArray;
            } else {
                if (this.padValueSpecified()) {
                    object = CDFImpl.getNumberAttribute(this.type, 1, this._buf, CDFImpl.this.byteOrder);
                }
                if (DataTypes.isLongType(this.type)) {
                    long[] lArray = new long[n];
                    lArray[0] = this.padValueSpecified() ? ((long[])object)[0] : (Long)object;
                    for (int i = 1; i < n; ++i) {
                        lArray[i] = lArray[0];
                    }
                    this.padValue = lArray;
                } else {
                    double[] dArray = new double[n];
                    dArray[0] = this.padValueSpecified() ? ((double[])object)[0] : (Double)object;
                    for (int i = 1; i < n; ++i) {
                        dArray[i] = dArray[0];
                    }
                    this.padValue = dArray;
                }
            }
            if (DataTypes.isStringType(this.type)) {
                this.dataItemSize *= this.numberOfElements;
            }
        }

        synchronized void complete() {
            if (this.completed) {
                return;
            }
            if (this.numberOfValues > 0) {
                this.locator = new DataLocator(this._buf, this.numberOfValues, (this.flags & 4) != 0);
                this.checkContinuity();
            }
            this.completed = true;
        }

        boolean isComplete() {
            return this.completed;
        }

        void checkContinuity() {
            if (this.numberOfValues == 0) {
                return;
            }
            long[][] lArray = this.locator.getLocations();
            long l = lArray[0][0] - 1L;
            for (int i = 0; i < lArray.length; ++i) {
                if (lArray[i][0] != l + 1L) {
                    this.recordGap = true;
                    break;
                }
                l = lArray[i][1];
            }
            if (this.recordGap && this.sRecords == 0) {
                System.out.println("Variable " + this.name + " is missing " + "records. This is not consistent with sRecords = 0");
            }
        }

        @Override
        public boolean isTypeR() {
            return this.vtype.equals("r");
        }

        @Override
        public boolean missingRecordValueIsPrevious() {
            return this.sRecords == 2;
        }

        @Override
        public boolean missingRecordValueIsPad() {
            return this.sRecords == 1;
        }

        @Override
        public boolean isMissingRecords() {
            if (!this.completed) {
                this.complete();
            }
            return this.recordGap;
        }

        @Override
        public VariableDataLocator getLocator() {
            if (!this.completed) {
                this.complete();
            }
            return this.locator;
        }

        @Override
        public VariableDataBuffer[] getDataBuffers(boolean bl) throws Throwable {
            if (!this.completed) {
                this.complete();
            }
            if (!bl && (this.flags & 4) != 0) {
                throw new Throwable("Function not supported for compressed variables ");
            }
            long[][] lArray = this.locator.getLocations();
            Vector<VariableDataBuffer> vector = new Vector<VariableDataBuffer>();
            int n = this.getDataItemSize();
            for (int i = 0; i < lArray.length; ++i) {
                int n2 = (int)lArray[i][0];
                int n3 = (int)lArray[i][1];
                ByteBuffer byteBuffer = CDFImpl.this.getRecord(lArray[i][2]);
                int n4 = (n3 - n2 + 1) * n;
                boolean bl2 = false;
                if (!this.isCompressed()) {
                    byteBuffer.position(CDFImpl.this.offset_RECORDS);
                } else if (byteBuffer.getInt(CDFImpl.this.offset_RECORD_TYPE) == 7) {
                    byteBuffer.position(CDFImpl.this.offset_RECORDS);
                } else {
                    bl2 = true;
                    byteBuffer.position(CDFImpl.this.offset_CDATA);
                    n4 = CDFImpl.this.lowOrderInt(byteBuffer, CDFImpl.this.offset_CSIZE);
                }
                ByteBuffer byteBuffer2 = byteBuffer.slice();
                byteBuffer2.order(CDFImpl.this.getByteOrder());
                byteBuffer2.limit(n4);
                vector.add(new VariableDataBuffer(n2, n3, byteBuffer2, bl2));
            }
            VariableDataBuffer[] variableDataBufferArray = new VariableDataBuffer[vector.size()];
            vector.toArray(variableDataBufferArray);
            return variableDataBufferArray;
        }

        @Override
        public VariableDataBuffer[] getDataBuffers() throws Throwable {
            return this.getDataBuffers(false);
        }

        @Override
        public boolean rowMajority() {
            return CDFImpl.this.rowMajority();
        }

        @Override
        public boolean recordVariance() {
            return (this.flags & 1) != 0;
        }

        public boolean padValueSpecified() {
            return (this.flags & 2) != 0;
        }

        @Override
        public boolean isCompressed() {
            if (!this.completed) {
                this.complete();
            }
            if (this.locator == null) {
                return false;
            }
            return this.locator.isReallyCompressed();
        }

        @Override
        public Object getPadValue() {
            if (this.padValue == null) {
                return null;
            }
            if (DataTypes.isStringType(this.type)) {
                return this.padValue;
            }
            return this.getPadValue(false);
        }

        @Override
        public Object getPadValue(boolean bl) {
            if (this.padValue == null) {
                return null;
            }
            if (DataTypes.isStringType(this.type)) {
                return this.padValue;
            }
            if (this.padValue.getClass().getComponentType() == Long.TYPE) {
                long[] lArray = (long[])this.padValue;
                if (bl) {
                    long[] lArray2 = new long[lArray.length];
                    System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
                    return lArray2;
                }
                double[] dArray = new double[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    dArray[i] = lArray[i];
                }
                return dArray;
            }
            double[] dArray = (double[])this.padValue;
            double[] dArray2 = new double[dArray.length];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            return dArray2;
        }

        @Override
        public CDFImpl getCDF() {
            return CDFImpl.this;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public int getBlockingFactor() {
            return this.blockingFactor;
        }

        @Override
        public int getEffectiveRank() {
            int n = 0;
            for (int i = 0; i < this.dimensions.length; ++i) {
                if (!this.varies[i] || this.dimensions[i] == 1) continue;
                ++n;
            }
            return n;
        }

        @Override
        public int[] getEffectiveDimensions() {
            int n = this.getEffectiveRank();
            if (n == 0) {
                return new int[0];
            }
            int[] nArray = new int[n];
            int n2 = 0;
            for (int i = 0; i < this.dimensions.length; ++i) {
                if (!this.varies[i] || this.dimensions[i] == 1) continue;
                nArray[n2++] = this.dimensions[i];
            }
            return nArray;
        }

        @Override
        public int getDataItemSize() {
            int n = this.dataItemSize;
            for (int i = 0; i < this.dimensions.length; ++i) {
                if (!this.varies[i]) continue;
                n *= this.dimensions[i];
            }
            return n;
        }

        @Override
        public int getNumberOfElements() {
            return this.numberOfElements;
        }

        @Override
        public int getNumberOfValues() {
            return this.numberOfValues;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public int[] getDimensions() {
            int[] nArray = new int[this.dimensions.length];
            System.arraycopy(this.dimensions, 0, nArray, 0, this.dimensions.length);
            return nArray;
        }

        @Override
        public int[] getRecordRange() {
            if (!this.completed) {
                this.complete();
            }
            if (this.locator == null) {
                return null;
            }
            long[][] lArray = this.locator.getLocations();
            return new int[]{(int)lArray[0][0], (int)lArray[lArray.length - 1][1]};
        }

        @Override
        public boolean[] getVarys() {
            boolean[] blArray = new boolean[this.varies.length];
            System.arraycopy(this.varies, 0, blArray, 0, this.varies.length);
            return blArray;
        }

        public ByteBuffer getBuffer() throws Throwable {
            return this.getBuffer(Double.TYPE, null, false, ByteOrder.nativeOrder());
        }

        public ByteBuffer getBuffer(int[] nArray) throws Throwable {
            return this.getBuffer(Double.TYPE, nArray, false, ByteOrder.nativeOrder());
        }

        @Override
        public ByteBuffer getBuffer(Class clazz, int[] nArray, boolean bl, ByteOrder byteOrder) throws Throwable {
            if (!this.completed) {
                this.complete();
            }
            if (clazz == Byte.TYPE) {
                ByteVarContainer byteVarContainer = new ByteVarContainer(CDFImpl.this, this, nArray);
                byteVarContainer.run();
                return byteVarContainer.getBuffer();
            }
            if (clazz == Double.TYPE && DoubleVarContainer.isCompatible(this.type, bl)) {
                DoubleVarContainer doubleVarContainer = new DoubleVarContainer(CDFImpl.this, this, nArray, bl, byteOrder);
                doubleVarContainer.run();
                return doubleVarContainer.getBuffer();
            }
            if (clazz == Float.TYPE && FloatVarContainer.isCompatible(this.type, bl)) {
                FloatVarContainer floatVarContainer = new FloatVarContainer(CDFImpl.this, this, nArray, bl, byteOrder);
                floatVarContainer.run();
                return floatVarContainer.getBuffer();
            }
            if (clazz == Integer.TYPE && IntVarContainer.isCompatible(this.type, bl)) {
                IntVarContainer intVarContainer = new IntVarContainer(CDFImpl.this, this, nArray, bl, byteOrder);
                intVarContainer.run();
                return intVarContainer.getBuffer();
            }
            if (clazz == Short.TYPE && ShortVarContainer.isCompatible(this.type, bl)) {
                ShortVarContainer shortVarContainer = new ShortVarContainer(CDFImpl.this, this, nArray, bl, byteOrder);
                shortVarContainer.run();
                return shortVarContainer.getBuffer();
            }
            if (clazz == Long.TYPE && LongVarContainer.isCompatible(this.type, bl)) {
                LongVarContainer longVarContainer = new LongVarContainer(CDFImpl.this, this, nArray, byteOrder);
                longVarContainer.run();
                return longVarContainer.getBuffer();
            }
            throw new Throwable("Inconsistent constraints for this variable");
        }

        @Override
        public boolean isCompatible(Class clazz) {
            return BaseVarContainer.isCompatible(this.getType(), true, clazz);
        }

        @Override
        public boolean isCompatible(Class clazz, boolean bl) {
            return BaseVarContainer.isCompatible(this.getType(), bl, clazz);
        }

        @Override
        public VDataContainer.CByte getByteContainer(int[] nArray) throws Throwable {
            if (ByteVarContainer.isCompatible(this.type, true)) {
                return new ByteVarContainer(CDFImpl.this, this, nArray);
            }
            throw new Throwable("Variable " + this.getName() + " cannot return " + "VDataContainer.CByte.");
        }

        @Override
        public byte[] asByteArray(int[] nArray) throws Throwable {
            if (ByteVarContainer.isCompatible(this.type, true)) {
                ByteVarContainer byteVarContainer = new ByteVarContainer(CDFImpl.this, this, nArray);
                byteVarContainer.run();
                return byteVarContainer.as1DArray();
            }
            throw new Throwable("Variable " + this.getName() + " cannot return " + "byte[].");
        }

        @Override
        public byte[] asByteArray() throws Throwable {
            return this.asByteArray(null);
        }

        public byte[] asByteArray(int[] nArray, boolean bl) throws Throwable {
            if (ByteVarContainer.isCompatible(this.type, true)) {
                ByteVarContainer byteVarContainer = new ByteVarContainer(CDFImpl.this, this, nArray);
                byteVarContainer.run();
                return byteVarContainer.asOneDArray(bl);
            }
            throw new Throwable("Variable " + this.getName() + " cannot return " + "byte[].");
        }

        @Override
        public VDataContainer.CString getStringContainer(int[] nArray) throws Throwable {
            if (StringVarContainer.isCompatible(this.type, true)) {
                return new StringVarContainer(CDFImpl.this, this, nArray);
            }
            throw new Throwable("Variable " + this.getName() + " cannot return " + "VDataContainer.CString.");
        }

        @Override
        public VDataContainer.CFloat getFloatContainer(int[] nArray, boolean bl, ByteOrder byteOrder) throws Throwable {
            if (FloatVarContainer.isCompatible(this.type, bl)) {
                return new FloatVarContainer(CDFImpl.this, this, nArray, bl, ByteOrder.nativeOrder());
            }
            throw new Throwable("Variable " + this.getName() + " cannot return " + "VDataContainer.Float.");
        }

        @Override
        public VDataContainer.CFloat getFloatContainer(int[] nArray, boolean bl) throws Throwable {
            return this.getFloatContainer(nArray, bl, ByteOrder.nativeOrder());
        }

        @Override
        public float[] asFloatArray(boolean bl, int[] nArray) throws Throwable {
            VDataContainer.CFloat cFloat;
            try {
                cFloat = this.getFloatContainer(nArray, bl, ByteOrder.nativeOrder());
            }
            catch (Throwable throwable) {
                throw new Throwable("Variable " + this.getName() + " cannot return " + "float[].");
            }
            cFloat.run();
            return cFloat.as1DArray();
        }

        @Override
        public float[] asFloatArray() throws Throwable {
            return this.asFloatArray(false, null);
        }

        @Override
        public float[] asFloatArray(int[] nArray) throws Throwable {
            return this.asFloatArray(false, nArray);
        }

        @Override
        public VDataContainer.CDouble getDoubleContainer(int[] nArray, boolean bl, ByteOrder byteOrder) throws Throwable {
            if (DoubleVarContainer.isCompatible(this.type, bl)) {
                return new DoubleVarContainer(CDFImpl.this, this, nArray, bl, ByteOrder.nativeOrder());
            }
            throw new Throwable("Variable " + this.getName() + " cannot return " + "VDataContainer.CDouble.");
        }

        @Override
        public VDataContainer.CDouble getDoubleContainer(int[] nArray, boolean bl) throws Throwable {
            return this.getDoubleContainer(nArray, bl, ByteOrder.nativeOrder());
        }

        @Override
        public double[] asDoubleArray(boolean bl, int[] nArray) throws Throwable {
            TargetAttribute targetAttribute = new TargetAttribute(bl, false);
            return this.asDoubleArray(targetAttribute, nArray);
        }

        public double[] asDoubleArray(TargetAttribute targetAttribute, int[] nArray) throws Throwable {
            VDataContainer.CDouble cDouble;
            try {
                cDouble = this.getDoubleContainer(nArray, targetAttribute.preserve, ByteOrder.nativeOrder());
            }
            catch (Throwable throwable) {
                throw new Throwable("Variable " + this.getName() + " cannot return " + "double[].");
            }
            cDouble.run();
            return cDouble.asOneDArray(targetAttribute.columnMajor);
        }

        @Override
        public double[] asDoubleArray() throws Throwable {
            return this.asDoubleArray(false, null);
        }

        @Override
        public double[] asDoubleArray(int[] nArray) throws Throwable {
            return this.asDoubleArray(false, nArray);
        }

        @Override
        public VDataContainer.CLong getLongContainer(int[] nArray, ByteOrder byteOrder) throws Throwable {
            if (LongVarContainer.isCompatible(this.type, true)) {
                return new LongVarContainer(CDFImpl.this, this, nArray, ByteOrder.nativeOrder());
            }
            throw new Throwable("Variable " + this.getName() + " cannot return " + "VDataContainer.CLong.");
        }

        @Override
        public VDataContainer.CLong getLongContainer(int[] nArray) throws Throwable {
            return this.getLongContainer(nArray, ByteOrder.nativeOrder());
        }

        long[] asLongArray(boolean bl, int[] nArray) throws Throwable {
            VDataContainer.CLong cLong;
            try {
                cLong = this.getLongContainer(nArray, ByteOrder.nativeOrder());
            }
            catch (Throwable throwable) {
                throw new Throwable("Variable " + this.getName() + " cannot return " + "long[].");
            }
            cLong.run();
            return cLong.as1DArray();
        }

        @Override
        public long[] asLongArray() throws Throwable {
            return this.asLongArray(false, null);
        }

        @Override
        public long[] asLongArray(int[] nArray) throws Throwable {
            return this.asLongArray(false, nArray);
        }

        @Override
        public VDataContainer.CInt getIntContainer(int[] nArray, boolean bl, ByteOrder byteOrder) throws Throwable {
            if (IntVarContainer.isCompatible(this.type, bl)) {
                return new IntVarContainer(CDFImpl.this, this, nArray, bl, ByteOrder.nativeOrder());
            }
            throw new Throwable("Variable " + this.getName() + " cannot return " + "VDataContainer.CInt.");
        }

        @Override
        public VDataContainer.CInt getIntContainer(int[] nArray, boolean bl) throws Throwable {
            return this.getIntContainer(nArray, bl, ByteOrder.nativeOrder());
        }

        @Override
        public int[] asIntArray(boolean bl, int[] nArray) throws Throwable {
            VDataContainer.CInt cInt;
            try {
                cInt = this.getIntContainer(nArray, bl, ByteOrder.nativeOrder());
            }
            catch (Throwable throwable) {
                throw new Throwable("Variable " + this.getName() + " cannot return " + "int[].");
            }
            cInt.run();
            return cInt.as1DArray();
        }

        @Override
        public int[] asIntArray() throws Throwable {
            return this.asIntArray(true, null);
        }

        @Override
        public int[] asIntArray(int[] nArray) throws Throwable {
            return this.asIntArray(true, nArray);
        }

        @Override
        public VDataContainer.CShort getShortContainer(int[] nArray, boolean bl, ByteOrder byteOrder) throws Throwable {
            if (ShortVarContainer.isCompatible(this.type, bl)) {
                return new ShortVarContainer(CDFImpl.this, this, nArray, bl, ByteOrder.nativeOrder());
            }
            throw new Throwable("Variable " + this.getName() + " cannot return " + "VDataContainer.CShort.");
        }

        @Override
        public VDataContainer.CShort getShortContainer(int[] nArray, boolean bl) throws Throwable {
            return this.getShortContainer(nArray, bl, ByteOrder.nativeOrder());
        }

        @Override
        public short[] asShortArray(boolean bl, int[] nArray) throws Throwable {
            VDataContainer.CShort cShort;
            try {
                cShort = this.getShortContainer(nArray, bl, ByteOrder.nativeOrder());
            }
            catch (Throwable throwable) {
                throw new Throwable("Variable " + this.getName() + " cannot return " + "short[].");
            }
            cShort.run();
            return cShort.as1DArray();
        }

        @Override
        public short[] asShortArray() throws Throwable {
            return this.asShortArray(true, null);
        }

        @Override
        public short[] asShortArray(int[] nArray) throws Throwable {
            return this.asShortArray(true, nArray);
        }

        @Override
        public Vector getElementCount() {
            int[] nArray = this.getDimensions();
            Vector<Integer> vector = new Vector<Integer>();
            for (int i = 0; i < nArray.length; ++i) {
                if (!this.getVarys()[i]) continue;
                vector.add(new Integer(nArray[i]));
            }
            return vector;
        }
    }

    public class CDFAttributeEntry
    implements AttributeEntry,
    Serializable {
        transient ByteBuffer _buf;
        int variableNumber;
        int type;
        int nelement;
        String attribute;
        String stringValue;
        String[] stringValues = null;
        Object value;

        public CDFAttributeEntry(ByteBuffer byteBuffer, String string) {
            this.attribute = string;
            this._buf = byteBuffer.duplicate();
            this._buf.position(CDFImpl.this.offset_ENTRYNUM);
            this.variableNumber = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_ATTR_DATATYPE);
            this.type = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_ATTR_NUM_ELEMENTS);
            this.nelement = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_VALUE);
            if (this.type > 50) {
                int n;
                byte[] byArray = new byte[this.nelement];
                for (n = 0; n < this.nelement; ++n) {
                    byArray[n] = this._buf.get();
                    if (byArray[n] == 0) break;
                }
                this.stringValue = new String(byArray, 0, n);
                this._buf.position(CDFImpl.this.offset_ATTR_NUM_ELEMENTS + 4);
                int n2 = this._buf.getInt();
                if (n2 > 1) {
                    this.stringValues = new String[n2];
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    while ((n3 = this.stringValue.indexOf(STRINGDELIMITER, n4)) != -1) {
                        this.stringValues[n5] = this.stringValue.substring(n4, n3);
                        n4 += this.stringValues[n5].length() + STRINGDELIMITER.length();
                        ++n5;
                    }
                    this.stringValues[n5] = this.stringValue.substring(n4);
                } else {
                    this.stringValues = null;
                }
            } else {
                this.value = CDFImpl.getNumberAttribute(this.type, this.nelement, this._buf, CDFImpl.this.byteOrder);
            }
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public int getNumberOfElements() {
            return this.nelement;
        }

        @Override
        public boolean isLongType() {
            return DataTypes.typeCategory[this.type] == 5;
        }

        @Override
        public boolean isStringType() {
            return DataTypes.isStringType(this.type);
        }

        @Override
        public Object getValue() {
            return this.isStringType() ? (this.stringValues != null ? this.stringValues : this.stringValue) : this.value;
        }

        @Override
        public String getAttributeName() {
            return this.attribute;
        }

        @Override
        public int getVariableNumber() {
            return this.variableNumber;
        }

        @Override
        public boolean isSameAs(AttributeEntry attributeEntry) {
            if (this.getType() != attributeEntry.getType()) {
                return false;
            }
            if (this.getNumberOfElements() != attributeEntry.getNumberOfElements()) {
                return false;
            }
            if (this.isStringType() != attributeEntry.isStringType()) {
                return false;
            }
            if (this.isStringType()) {
                if (this.stringValues != null) {
                    Object object = attributeEntry.getValue();
                    if (!object.getClass().isArray()) {
                        return false;
                    }
                    Object[] objectArray = this.stringValues;
                    Object[] objectArray2 = (String[])object;
                    return Arrays.equals(objectArray, objectArray2);
                }
                return this.stringValue.equals(attributeEntry.getValue());
            }
            if (this.isLongType() != attributeEntry.isLongType()) {
                return false;
            }
            if (this.isLongType()) {
                return Arrays.equals((long[])this.value, (long[])attributeEntry.getValue());
            }
            return Arrays.equals((double[])this.value, (double[])attributeEntry.getValue());
        }
    }

    class CDFAttribute
    implements Serializable,
    Attribute {
        String name;
        int scope;
        int num;
        Vector zEntries = new Vector();
        Vector gEntries = new Vector();

        public CDFAttribute(long l) {
            this.name = CDFImpl.this.getString(l + (long)CDFImpl.this.offset_ATTR_NAME);
            ByteBuffer byteBuffer = CDFImpl.this.getRecord(l);
            byteBuffer.position(CDFImpl.this.offset_SCOPE);
            this.scope = byteBuffer.getInt();
            this.num = byteBuffer.getInt();
            byteBuffer.position(CDFImpl.this.offset_AgrEDRHead);
            long l2 = CDFImpl.this.longInt(byteBuffer);
            if (l2 > 0L) {
                this.gEntries = this.getAttributeEntries(l2);
                if (this.scope == 2 || this.scope == 4) {
                    this.linkToVariables(this.gEntries, "r");
                }
            }
            byteBuffer.position(CDFImpl.this.offset_AzEDRHead);
            l2 = CDFImpl.this.longInt(byteBuffer);
            if (l2 > 0L) {
                this.zEntries = this.getAttributeEntries(l2);
                this.linkToVariables(this.zEntries, "z");
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Vector getAttributeEntries(long l) {
            if (l == 0L) {
                return null;
            }
            Vector<CDFAttributeEntry> vector = new Vector<CDFAttributeEntry>();
            ByteBuffer byteBuffer = CDFImpl.this.getRecord(l);
            while (true) {
                byteBuffer.position(CDFImpl.this.offset_NEXT_AEDR);
                long l2 = CDFImpl.this.longInt(byteBuffer);
                byteBuffer.position(0);
                CDFAttributeEntry cDFAttributeEntry = new CDFAttributeEntry(byteBuffer, this.name);
                vector.add(cDFAttributeEntry);
                if (l2 == 0L) break;
                byteBuffer = CDFImpl.this.getRecord(l2);
            }
            return vector;
        }

        public void linkToVariables(Vector vector, String string) {
            for (int i = 0; i < vector.size(); ++i) {
                AttributeEntry attributeEntry = (AttributeEntry)vector.elementAt(i);
                CDFVariable cDFVariable = (CDFVariable)CDFImpl.this.getCDFVariable(string, attributeEntry.getVariableNumber());
                if (cDFVariable == null) {
                    System.out.println("An attribute entry for " + attributeEntry.getAttributeName() + " of type " + string + " links to variable number " + attributeEntry.getVariableNumber() + ".");
                    System.out.println("Variable whose number is " + attributeEntry.getVariableNumber() + " was not found.");
                    continue;
                }
                cDFVariable.attributes.add(attributeEntry);
            }
        }

        @Override
        public boolean isGlobal() {
            return this.scope != 2 && this.scope != 4;
        }
    }
}

