#******************************************************************************
# Copyright 1996-2013 United States Government as represented by the
# Administrator of the National Aeronautics and Space Administration.
# All Rights Reserved.
#*****************************************************************************/

package CDF;

require Exporter;
require DynaLoader;
use AutoLoader;
use Data::Dumper;

@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
	AHUFF_COMPRESSION
	ALPHAOSF1_DECODING
	ALPHAOSF1_ENCODING
	ALPHAVMSd_DECODING
	ALPHAVMSd_ENCODING
	ALPHAVMSg_DECODING
	ALPHAVMSg_ENCODING
	ALPHAVMSi_DECODING
	ALPHAVMSi_ENCODING
        ARM_BIG_DECODING
        ARM_BIG_ENCODING
        ARM_LITTLE_DECODING
        ARM_LITTLE_ENCODING
	ATTR_
	ATTR_EXISTANCE_
	ATTR_EXISTENCE_
	ATTR_EXISTS
	ATTR_MAXENTRY_
	ATTR_MAXgENTRY_
	ATTR_MAXrENTRY_
	ATTR_MAXzENTRY_
	ATTR_NAME_
	ATTR_NAME_TRUNC
	ATTR_NUMBER_
	ATTR_NUMENTRIES_
	ATTR_NUMgENTRIES_
	ATTR_NUMrENTRIES_
	ATTR_NUMzENTRIES_
	ATTR_SCOPE_
	BAD_ALLOCATE_RECS
	BAD_ARGUMENT
	BAD_ATTR_NAME
	BAD_ATTR_NUM
	BAD_BLOCKING_FACTOR
	BAD_CACHE_SIZE
	BAD_CHECKSUM
	BAD_CDFSTATUS
	BAD_CDF_EXTENSION
	BAD_CDF_ID
	BAD_CDF_NAME
	BAD_COMPRESSION_PARM
	BAD_DATA_TYPE
	BAD_DECODING
	BAD_DIM_COUNT
	BAD_DIM_INDEX
	BAD_DIM_INTERVAL
	BAD_DIM_SIZE
	BAD_ENCODING
	BAD_ENTRY_NUM
	BAD_EXTEND_RECS
	BAD_FNC_OR_ITEM
	BAD_FORMAT
	BAD_INITIAL_RECS
	BAD_MAJORITY
	BAD_MALLOC
	BAD_NEGtoPOSfp0_MODE
	BAD_NUM_DIMS
	BAD_NUM_ELEMS
	BAD_NUM_VARS
	BAD_READONLY_MODE
	BAD_REC_COUNT
	BAD_REC_INTERVAL
	BAD_REC_NUM
	BAD_SCOPE
	BAD_SCRATCH_DIR
	BAD_SPARSEARRAYS_PARM
	BAD_VAR_NAME
	BAD_VAR_NUM
	BAD_zMODE
	CANNOT_ALLOCATE_RECORDS
	CANNOT_CHANGE
	CANNOT_COMPRESS
	CANNOT_SPARSEARRAYS
	CANNOT_SPARSERECORDS
	CDF_
	CDF_ACCESS_
	CDF_BYTE
	CDF_CACHESIZE_
	CDF_CHAR
	CDF_CHECKSUM_
	CDF_CLOSE_ERROR
	CDF_COMPRESSION_
	CDF_COPYRIGHT_
	CDF_CREATE_ERROR
	CDF_DECODING_
	CDF_DELETE_ERROR
	CDF_DIMCOUNTS_
	CDF_DIMINDICES_
	CDF_DIMINTERVALS_
	CDF_DIMSIZES_
	CDF_DOUBLE
	CDF_ENCODING_
	CDF_EPOCH
	CDF_EPOCH16
	CDF_EXISTS
	CDF_FLOAT
	CDF_FORMAT_
	CDF_INCREMENT_
	CDF_INFO_
	CDF_INT1
	CDF_INT2
	CDF_INT4
	CDF_INT8
	CDF_INTERNAL_ERROR
	CDF_LEAPSECONDLASTUPDATED_
	CDF_MAJORITY_
	CDF_MAXREC_
	CDF_MAX_DIMS
	CDF_MAX_PARMS
	CDF_MIN_DIMS
	CDF_NAME_
	CDF_NAME_TRUNC
	CDF_NEGtoPOSfp0_MODE_
	CDF_NUMATTRS_
	CDF_NUMDIMS_
	CDF_NUMVARS_
	CDF_NUMgATTRS_
	CDF_NUMrVARS_
	CDF_NUMvATTRS_
	CDF_NUMzVARS_
	CDF_OK
	CDF_OPEN_ERROR
	CDF_READONLY_MODE_
	CDF_READ_ERROR
	CDF_REAL4
	CDF_REAL8
	CDF_RECCOUNT_
	CDF_RECINTERVAL_
	CDF_RECNUMBER_
	CDF_RELEASE_
	CDF_SCRATCHDIR_
	CDF_STATUS_
	CDF_TIME_TT2000
	CDF_UCHAR
	CDF_UINT1
	CDF_UINT2
	CDF_UINT4
	CDF_VERSION_
	CDF_WARN
	CDF_WRITE_ERROR
	CDF_zMODE_
	CDFwithSTATS_
	CHECKSUM_
	CHECKSUM_ERROR
	CHECKSUM_NOT_ALLOWED
	CLOSE_
	COLUMN_MAJOR
	COL_MAJOR
	COMPRESSION_ERROR
	COMPRESS_CACHESIZE_
	CONFIRM_
	CORRUPTED_V2_CDF
	CORRUPTED_V3_CDF
	CREATE_
	CURgENTRY_EXISTENCE_
	CURrENTRY_EXISTENCE_
	CURzENTRY_EXISTENCE_
	BACKWARDFILEon
	BACKWARDFILEoff
	VALIDATEFILEon
	VALIDATEFILEoff
	DATATYPE_SIZE_
	DECOMPRESSION_ERROR
	DECSTATION_DECODING
	DECSTATION_ENCODING
	DELETE_
	DID_NOT_COMPRESS
	EMPTY_COMPRESSED_CDF
	END_OF_VAR
	ENTRY_
	ENTRY_DATATYPE_
	ENTRY_DATA_
	ENTRY_NUMELEMS_
	EPOCH_STRING_LEN
	EPOCH1_STRING_LEN
	EPOCH2_STRING_LEN
	EPOCH3_STRING_LEN
	EPOCH4_STRING_LEN
	EPOCH16_STRING_LEN
	EPOCH16_1_STRING_LEN
	EPOCH16_2_STRING_LEN
	EPOCH16_3_STRING_LEN
	EPOCH16_4_STRING_LEN
	EPOCHx_FORMAT_MAX
	EPOCHx_STRING_MAX
	FORCED_PARAMETER
	GET_
	GLOBAL_SCOPE
	GLOBAL_SCOPE_ASSUMED
	GZIP_COMPRESSION
	HOST_DECODING
	HOST_ENCODING
	HP_DECODING
	HP_ENCODING
	HUFF_COMPRESSION
        IA64VMSi_DECODING
        IA64VMSi_ENCODING
        IA64VMSd_DECODING
        IA64VMSd_ENCODING
        IA64VMSg_DECODING
        IA64VMSg_ENCODING
	IBMPC_DECODING
	IBMPC_ENCODING
	IBMRS_DECODING
	IBMRS_ENCODING
	IBM_PC_OVERFLOW
	ILLEGAL_EPOCH_VALUE
	ILLEGAL_FOR_SCOPE
	ILLEGAL_IN_zMODE
	ILLEGAL_ON_V1_CDF
	ILLEGAL_TT2000_VALUE
	IS_A_NETCDF
	LIB_COPYRIGHT_
	LIB_INCREMENT_
	LIB_RELEASE_
	LIB_VERSION_
	LIB_subINCREMENT_
	MAC_DECODING
	MAC_ENCODING
	MD5_CHECKSUM
	MIPSEB_ENCODING
	MIPSEL_ENCODING
	MULTI_FILE
	MULTI_FILE_FORMAT
	NA_FOR_VARIABLE
	NEGATIVE_FP_ZERO
	NEGtoPOSfp0off
	NEGtoPOSfp0on
	NETWORK_DECODING
	NETWORK_ENCODING
	NOT_A_CDF_OR_NOT_SUPPORTED
	NOVARY
	NO_ATTR_SELECTED
	NO_CDF_SELECTED
	NO_CHECKSUM
	NO_COMPRESSION
	NO_DELETE_ACCESS
	NO_ENTRY_SELECTED
	NO_MORE_ACCESS
	NO_PADVALUE_SPECIFIED
	NO_SPARSEARRAYS
	NO_SPARSERECORDS
	NO_STATUS_SELECTED
	NO_SUCH_ATTR
	NO_SUCH_CDF
	NO_SUCH_ENTRY
	NO_SUCH_RECORD
	NO_SUCH_VAR
	NO_VARS_IN_CDF
	NO_VAR_SELECTED
	NO_WRITE_ACCESS
	NONE_CHECKSUM
	NULL_
	NeXT_DECODING
	NeXT_ENCODING
	OPEN_
	OPTIMAL_ENCODING_TREES
	PAD_SPARSERECORDS
	PRECEEDING_RECORDS_ALLOCATED
	PREV_SPARSERECORDS
	PUT_
	READONLYoff
	READONLYon
	READ_ONLY_DISTRIBUTION
	READ_ONLY_MODE
	RESERVED_CDFID
	RESERVED_CDFSTATUS
	RLE_COMPRESSION
	RLE_OF_ZEROs
	ROW_MAJOR
	SCRATCH_CREATE_ERROR
	SCRATCH_DELETE_ERROR
	SCRATCH_READ_ERROR
	SCRATCH_WRITE_ERROR
	SELECT_
	SGi_DECODING
	SGi_ENCODING
	SINGLE_FILE
	SINGLE_FILE_FORMAT
	SOME_ALREADY_ALLOCATED
	STAGE_CACHESIZE_
	STATUS_TEXT_
	STRINGDELIMITER
	SUN_DECODING
	SUN_ENCODING
	TOO_MANY_PARMS
	TOO_MANY_VARS
	TTT2000_0_STRING_LEN
	TTT2000_1_STRING_LEN
	TTT2000_2_STRING_LEN
	TTT2000_3_STRING_LEN
	TTT2000_4_STRING_LEN
	UNKNOWN_COMPRESSION
	UNKNOWN_SPARSENESS
	UNSUPPORTED_OPERATION
	VARIABLE_SCOPE
	VARIABLE_SCOPE_ASSUMED
	VARY
	VAR_
	VAR_ALREADY_CLOSED
	VAR_CLOSE_ERROR
	VAR_CREATE_ERROR
	VAR_DATASPEC_
	VAR_DATATYPE_
	VAR_DATA_
	VAR_DELETE_ERROR
	VAR_DIMVARYS_
	VAR_EXISTS
	VAR_EXTENDRECS_
	VAR_FILLVALUE_
	VAR_HYPERDATA_
	VAR_INITIALRECS_
	VAR_MAXREC_
	VAR_NAME_
	VAR_NAME_TRUNC
	VAR_NUMBER_
	VAR_NUMELEMS_
	VAR_OPEN_ERROR
	VAR_READ_ERROR
	VAR_RECVARY_
	VAR_SEQDATA_
	VAR_SEQPOS_
	VAR_WRITE_ERROR
	VAX_DECODING
	VAX_ENCODING
	VIRTUAL_RECORD_DATA
	gENTRY_
	gENTRY_DATASPEC_
	gENTRY_DATATYPE_
	gENTRY_DATA_
	gENTRY_EXISTANCE_
	gENTRY_EXISTENCE_
	gENTRY_NUMELEMS_
	rENTRY_
	rENTRY_DATASPEC_
	rENTRY_DATATYPE_
	rENTRY_DATA_
	rENTRY_EXISTANCE_
	rENTRY_EXISTENCE_
	rENTRY_NAME_
	rENTRY_NUMELEMS_
	rENTRY_NUMSTRINGS_
	rENTRY_STRINGSDATA_
	rVAR_
	rVAR_ALLOCATEBLOCK_
	rVAR_ALLOCATEDFROM_
	rVAR_ALLOCATEDTO_
	rVAR_ALLOCATERECS_
	rVAR_BLOCKINGFACTOR_
	rVAR_CACHESIZE_
	rVAR_COMPRESSION_
	rVAR_DATASPEC_
	rVAR_DATATYPE_
	rVAR_DATA_
	rVAR_DIMVARYS_
	rVAR_EXISTANCE_
	rVAR_EXISTENCE_
	rVAR_EXTENDRECS_
	rVAR_HYPERDATA_
	rVAR_INITIALRECS_
	rVAR_MAXREC_
	rVAR_MAXallocREC_
	rVAR_NAME_
	rVAR_NUMBER_
	rVAR_NUMELEMS_
	rVAR_NUMRECS_
	rVAR_NUMallocRECS_
	rVAR_PADVALUE_
	rVAR_RECORDS_
	rVAR_RECORDS_RENUMBER_
	rVAR_RECVARY_
	rVAR_RESERVEPERCENT_
	rVAR_SEQDATA_
	rVAR_SEQPOS_
	rVAR_SPARSEARRAYS_
	rVAR_SPARSERECORDS_
	rVAR_nINDEXENTRIES_
	rVAR_nINDEXLEVELS_
	rVAR_nINDEXRECORDS_
	rVARs_CACHESIZE_
	rVARs_DIMCOUNTS_
	rVARs_DIMINDICES_
	rVARs_DIMINTERVALS_
	rVARs_DIMSIZES_
	rVARs_MAXREC_
	rVARs_NUMDIMS_
	rVARs_RECCOUNT_
	rVARs_RECDATA_
	rVARs_RECINTERVAL_
	rVARs_RECNUMBER_
	zENTRY_
	zENTRY_DATASPEC_
	zENTRY_DATATYPE_
	zENTRY_DATA_
	zENTRY_EXISTANCE_
	zENTRY_EXISTENCE_
	zENTRY_NAME_
	zENTRY_NUMELEMS_
	zENTRY_NUMSTRINGS_
	zENTRY_STRINGSDATA_
	zMODEoff
	zMODEon1
	zMODEon2
	zVAR_
	zVAR_ALLOCATEBLOCK_
	zVAR_ALLOCATEDFROM_
	zVAR_ALLOCATEDTO_
	zVAR_ALLOCATERECS_
	zVAR_BLOCKINGFACTOR_
	zVAR_CACHESIZE_
	zVAR_COMPRESSION_
	zVAR_DATASPEC_
	zVAR_DATATYPE_
	zVAR_DATA_
	zVAR_DIMCOUNTS_
	zVAR_DIMINDICES_
	zVAR_DIMINTERVALS_
	zVAR_DIMSIZES_
	zVAR_DIMVARYS_
	zVAR_EXISTANCE_
	zVAR_EXISTENCE_
	zVAR_EXTENDRECS_
	zVAR_HYPERDATA_
	zVAR_INITIALRECS_
	zVAR_MAXREC_
	zVAR_MAXallocREC_
	zVAR_NAME_
	zVAR_NUMBER_
	zVAR_NUMDIMS_
	zVAR_NUMELEMS_
	zVAR_NUMRECS_
	zVAR_NUMallocRECS_
	zVAR_PADVALUE_
	zVAR_RECCOUNT_
	zVAR_RECINTERVAL_
	zVAR_RECNUMBER_
	zVAR_RECORDS_
	zVAR_RECORDS_RENUMBER_
	zVAR_RECVARY_
	zVAR_RESERVEPERCENT_
	zVAR_SEQDATA_
	zVAR_SEQPOS_
	zVAR_SPARSEARRAYS_
	zVAR_SPARSERECORDS_
	zVAR_nINDEXENTRIES_
	zVAR_nINDEXLEVELS_
	zVAR_nINDEXRECORDS_
	zVARs_CACHESIZE_
	zVARs_MAXREC_
	zVARs_RECDATA_
	zVARs_RECNUMBER_
);
sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    local($constname);
    ($constname = $AUTOLOAD) =~ s/.*:://;
    $val = constant($constname);
    if ($! != 0) {
	if ($! =~ /Invalid/i) {
	  $AutoLoader::AUTOLOAD = $AUTOLOAD;
	  goto &AutoLoader::AUTOLOAD;
	}
	else {
	  ($pack,$file,$line) = caller;
	  die "You have not defined CDF macro $constname at $file line $line";
	}
    }
    eval "sub $AUTOLOAD { $val }";
    goto &$AUTOLOAD;
}

bootstrap CDF;

# Preloaded methods go here.

# Autoload methods go after __END__, and are processed by the autosplit program.

1;
__END__

#############################################################################
#
#  Perl interface to CDF's internal interface CDFlib
#
#  Usage:
#     $status = CDFlib(&CREATE_, &CDF_, $CDFpath, ..., &NULL_);
#
#   Translation from the C internal interface:
#  	All variables passed by value are Perl Scalars
#              $status = CDFlib(&PUT_, &CDF_MAJORITY_, $majorty, &NULL_);
#  	All variables passed as Perl Reference to Scalars are to have values 
#       	returned
#              $status = CDFlib(&GET_, &CDF_MAJORITY_, \$majority, &NULL_);
#  	All arrays are passed by reference, regardless of whether they are 
#		returned
#  	All macro constants defined in cdf.h need to have a & prepended
#
#############################################################################
#
#   The names of the XSUB are based on the number of and datatype of the 
#   calling arguments, except for a few special cases. Used in the CDF 
#   interface is specified
#   data 
#   type  input output description 
#   ----- ----- ------ ---------------------------------------
#   array   a     1    used for long array (passed by reference) as long 
#                      varname[];
#   void 1  b     2    used for reference to an array of values as void *buffer;
#   char    c     3    used for single char as char varname; or char *varname;
#   CDFid   d     4    used for type CDFid as CDFid id; or CDFid *id; 
#                      (actually a type of void *)  
#   long    l     5    used for type long as long varname; or long *varname;
#   string  s     6    used for multiple chars as char *varname; 
#   void 2  v     7    used for reference to a single value passed as 
#                      void *value;
#
#  The letters are used for input paraneters and numbers for output
#  (The reason for doing this is to eliminate conflicts on platforms that
#   only use all upper or lower cases letters, eg PC and VMS.)
#  Parameters expecting returned values are scalar references from a Perl 
#  script calling to this package. They are dereferenced in this package
#
#############################################################################

sub CDFlib {
	use strict;
	my $operation = shift;
	my $status;

#operation (Function) block  Labelled to avoid messy elsif construct	
FCN: {
	return &CDF_OK if ($operation == &NULL_);
	
#############################################################################
# CLOSE
#############################################################################

	if ($operation == &CLOSE_) {
	  for (;;) {
	    my $item = shift;
	    if ($item == &CDF_ || $item == &rVAR_ || $item == &zVAR_) {
	 	 $status = CDFlibnone($operation, $item);
	    } else {
	      unshift (@_, $item);
	      last FCN;
	    } #end if
	    return $status if ($status != &CDF_OK);
	  } #end for
	} #end if CLOSE_
	
#############################################################################
# CONFIRM
#############################################################################

	if ($operation == &CONFIRM_) {
	  for (;;) {
	    my $item = shift;
	    if ($item == &ATTR_ || $item == &CDF_CACHESIZE_ || 
		$item == &CDF_DECODING_ ||
		$item == &CDF_NEGtoPOSfp0_MODE_ || 
		$item == &CDF_READONLY_MODE_ || $item == &CDF_STATUS_ || 
		$item == &CDF_zMODE_ || $item == &COMPRESS_CACHESIZE_ || 
		$item == &gENTRY_ || $item == &rENTRY_ || 
		$item == &rVAR_ || $item == &rVAR_CACHESIZE_ || 
		$item == &rVAR_RESERVEPERCENT_ || 
		$item == &rVARs_RECCOUNT_ || $item == &rVARs_RECINTERVAL_ || 
		$item == &rVARs_RECNUMBER_ || $item == &STAGE_CACHESIZE_ || 
		$item == &zENTRY_ || $item == &zVAR_ || 
		$item == &zVAR_CACHESIZE_ || $item == &zVAR_RECCOUNT_ || 
		$item == &zVAR_RECINTERVAL_ || $item == &zVAR_RECNUMBER_ || 
                $item == &rVARs_CACHESIZE_ || $item == &zVARs_CACHESIZE_ || 
		$item == &zVAR_RESERVEPERCENT_ ) {
		   my $LongRef = shift;
		   $status = CDFlib5($operation, $item, $$LongRef);

	    } elsif ($item == &ATTR_EXISTENCE_ || $item == &zVAR_EXISTENCE_ ||
		     $item == &rVAR_EXISTENCE_) {
			my $String = shift;
			$status = CDFlibs($operation, $item, $String);

	    } elsif ($item == &CDF_NAME_) {
			my $StringRef = shift;
			$status = CDFlib6($operation, $item, $$StringRef);

	    } elsif ($item == &CDF_ACCESS_ || $item == &CURgENTRY_EXISTENCE_ || 
		     $item == &CURrENTRY_EXISTENCE_ || 
		     $item == &CURzENTRY_EXISTENCE_ || 
		     $item == &rVAR_PADVALUE_ || $item == &zVAR_PADVALUE_ ||
		     $item == &CDF_CHECKSUM_) {
			$status = CDFlibnone($operation, $item);

	    } elsif ($item == &gENTRY_EXISTENCE_ || 
		     $item == &rENTRY_EXISTENCE_ || 
		     $item == &zENTRY_EXISTENCE_) {
			my $Long = shift;
			$status = CDFlibl($operation, $item, $Long);

	    } elsif ($item == &rVAR_SEQPOS_ || $item == &zVAR_SEQPOS_) {
			my $LongRef = shift;
			my $LongArrayRef = shift;
			$status = CDFlib51($operation, $item, $$LongRef, 
					   $LongArrayRef);
	    } elsif ($item == &rVARs_DIMCOUNTS_ || 
		     $item == &rVARs_DIMINDICES_ || 
		     $item == &rVARs_DIMINTERVALS_ || 
		     $item == &zVAR_DIMCOUNTS_ || 
		     $item == &zVAR_DIMINDICES_ || 
		     $item == &zVAR_DIMINTERVALS_) {
			my $LongArrayRef = shift;
			$status = CDFlib1($operation, $item, $LongArrayRef);

	    } elsif ($item == &CDF_) {
			my $CDFidRef = shift;
			$status = CDFlib4($operation, $item, $$CDFidRef);

	    } else {
			unshift (@_, $item);
			last FCN;
	  	   } #end if
	    return $status if ($status != &CDF_OK);
	  } #end for
	} #end if CONFIRM_
	
#############################################################################
# CREATE
#############################################################################

	if ($operation == &CREATE_) {
	  for (;;) {
		my $item = shift;
		if ($item == &ATTR_) {
			my $String = shift;
			my $Long = shift;
			my $LongRef = shift;
			$status = CDFCreateAttr($operation, $item, $String, 
						$Long, $$LongRef);
		} elsif ($item == &CDF_) {
			my $String = shift;
			my $Long = shift;
			my $ArrayRef = shift;
			my $CDFidRef = shift;
			$status = CDFCreateCDF($operation, $item, $String, 
					       $Long, $ArrayRef, $$CDFidRef);
		} elsif ($item == &rVAR_) {
			my $String = shift;
			my $Long = shift;
			my $Long1 = shift;
			my $Long2 = shift;
			my $ArrayRef = shift;
			my $LongRef = shift;
			$status = CDFCreateRvar($operation, $item, $String, 
						$Long, $Long1, $Long2, 
						$ArrayRef, $$LongRef);
		} elsif ($item == &zVAR_) {
			my $String = shift;
			my $Long = shift;
			my $Long1 = shift;
			my $Long2 = shift;
			my $ArrayRef = shift;
			my $Long3 = shift;
			my $ArrayRef1 = shift;
			my $LongRef = shift;
			$status = CDFCreateZvar($operation, $item, $String, 
						$Long, $Long1, $Long2, 
						$ArrayRef, $Long3, $ArrayRef1, 
						$$LongRef);
		} else {
			unshift (@_, $item);
			last FCN;
		} #end if
		return $status if ($status != &CDF_OK);
	   } #end for
	} #end if CREATE_
	
#############################################################################
# DELETE
#############################################################################
	
	if ($operation == &DELETE_) {
	   for (;;) {
		my $item = shift;
		if ($item == &ATTR_ || $item == &CDF_ || $item == &gENTRY_ || 
		    $item == &rENTRY_ || $item == &rVAR_ || 
		    $item == &zENTRY_ || $item == &zVAR_) {
			$status = CDFlibnone($operation, $item);

		} elsif ($item == &rVAR_RECORDS_ || $item == &zVAR_RECORDS_ ||
                         $item == &rVAR_RECORDS_RENUMBER_ ||
                         $item == &zVAR_RECORDS_RENUMBER_) {
			my $Long1 = shift;
			my $Long2 = shift;
			$status = CDFlibll($operation, $item, $Long1, $Long2);
 
		} else {
			unshift (@_, $item);
			last FCN;
		} #end if
		return $status if ($status != &CDF_OK);
	   } #end for
	} #end if DELETE_

#############################################################################
# GET
#############################################################################
	
	if ($operation == &GET_) {
	   for (;;) {
		my $item = shift;
		if ($item == &ATTR_MAXgENTRY_ || $item == &ATTR_MAXrENTRY_ || 
		    $item == &ATTR_MAXzENTRY_ || $item == &ATTR_NUMgENTRIES_ || 
		    $item == &ATTR_NUMrENTRIES_ || 
		    $item == &ATTR_NUMzENTRIES_ ||
		    $item == &ATTR_SCOPE_ || $item == &CDF_ENCODING_ || 
		    $item == &CDF_FORMAT_ || $item == &CDF_INCREMENT_ || 
		    $item == &CDF_MAJORITY_ || $item == &CDF_NUMATTRS_ ||
		    $item == &CDF_NUMgATTRS_ ||
		    $item == &CDF_NUMrVARS_ || $item == &CDF_NUMvATTRS_ || 
		    $item == &CDF_NUMzVARS_ || $item == &CDF_RELEASE_ || 
		    $item == &CDF_VERSION_ || $item == &gENTRY_DATATYPE_ ||
		    $item == &gENTRY_NUMELEMS_ || $item == &LIB_INCREMENT_ || 
		    $item == &LIB_RELEASE_ || $item == &LIB_VERSION_ || 
		    $item == &rENTRY_DATATYPE_ || $item == &rENTRY_NUMELEMS_ ||
		    $item == &rENTRY_NUMSTRINGS_ ||
		    $item == &rVAR_BLOCKINGFACTOR_ || 
		    $item == &rVAR_DATATYPE_ ||
		    $item == &rVAR_MAXallocREC_ || $item == &rVAR_MAXREC_ || 
		    $item == &rVAR_nINDEXENTRIES_ || 
		    $item == &rVAR_nINDEXLEVELS_ ||
		    $item == &rVAR_nINDEXRECORDS_ || 
		    $item == &rVAR_NUMallocRECS_ ||
		    $item == &rVAR_NUMELEMS_ || $item == &rVAR_NUMRECS_ ||
		    $item == &rVAR_RECVARY_ || $item == &rVAR_SPARSERECORDS_ || 
		    $item == &rVARs_MAXREC_ || $item == &rVARs_NUMDIMS_ || 
		    $item == &zENTRY_DATATYPE_ || $item == &zENTRY_NUMELEMS_ ||
		    $item == &zENTRY_NUMSTRINGS_ ||
		    $item == &zVAR_BLOCKINGFACTOR_ || 
		    $item == &zVAR_DATATYPE_ || 
		    $item == &zVAR_MAXallocREC_ || $item == &zVAR_MAXREC_ || 
		    $item == &zVAR_nINDEXENTRIES_ || 
		    $item == &zVAR_nINDEXLEVELS_ ||
		    $item == &zVAR_nINDEXRECORDS_ || 
		    $item == &zVAR_NUMallocRECS_ ||
		    $item == &zVAR_NUMDIMS_ || $item == &zVAR_NUMELEMS_ || 
		    $item == &zVAR_NUMRECS_ ||
		    $item == &CDF_LEAPSECONDLASTUPDATED_ ||
		    $item == &zVAR_RECVARY_ || $item == &zVAR_SPARSERECORDS_ ||
		    $item == &zVARs_MAXREC_ || $item == &CDF_CHECKSUM_) {
			my $LongRef = shift;
			$status = CDFlib5($operation, $item, $$LongRef);

		} elsif ($item == &ATTR_NAME_ || $item == &CDF_COPYRIGHT_ || 
		         $item == &LIB_COPYRIGHT_ || 
		         $item == &rVAR_NAME_ || $item == &STATUS_TEXT_ ||
		         $item == &zVAR_NAME_) {
			my $StringRef = shift;
			$status = CDFlib6($operation, $item, $$StringRef);

		} elsif ($item == &LIB_subINCREMENT_) {
			my $CharRef = shift;
			$status = CDFlib3($operation, $item, $$CharRef);

		} elsif ($item == &ATTR_NUMBER_ || $item == &rVAR_NUMBER_ || 
		         $item == &zVAR_NUMBER_) {
			my $String = shift;
			my $LongRef = shift;
			$status = CDFlibs5($operation, $item, $String, 
					   $$LongRef);

		} elsif ($item == &DATATYPE_SIZE_ || 
			 $item == &rVAR_ALLOCATEDFROM_ ||
			 $item == &rVAR_ALLOCATEDTO_ || 
			 $item == &zVAR_ALLOCATEDFROM_ ||
			 $item == &zVAR_ALLOCATEDTO_) {
			my $Long = shift;
			my $LongRef = shift;
			$status = CDFlibl5($operation, $item, $Long, $$LongRef);

		} elsif ($item == &gENTRY_DATA_ || $item == &rENTRY_DATA_ || 
		         $item == &rVAR_DATA_ || $item == &rVAR_PADVALUE_ || 
		         $item == &rVAR_SEQDATA_ || $item == &zENTRY_DATA_ ||
		         $item == &zVAR_DATA_ || $item == &zVAR_PADVALUE_ || 
			 $item == &zVAR_SEQDATA_) { 
                        my $VoidRef = shift;
			if (ref($VoidRef) eq "SCALAR") {
                          $status = CDFlib7($operation, $item, $VoidRef);
			} else {
			  $status = CDFlib7A($operation, $item, $VoidRef);
			}

		} elsif ($item == &rENTRY_STRINGSDATA_ || 
		         $item == &zENTRY_STRINGSDATA_) {
                        my $VoidRef = shift;
			$status = CDFlib8A($operation, $item, $VoidRef);

		} elsif ($item == &rVAR_HYPERDATA_ || 
			 $item == &zVAR_HYPERDATA_) {
			my $VoidArrayRef = shift;
			$status = CDFlib2($operation, $item, $VoidArrayRef);

		} elsif ($item == &rVAR_DIMVARYS_ || 
			 $item == &rVARs_DIMSIZES_ || 
		         $item == &zVAR_DIMSIZES_ || $item == &zVAR_DIMVARYS_) {
#if called for a 0 dimension z variable, a 0 is returned
# to be more Perlish, an undef would be more appropriate
			my $LongArrayRef = shift;
			$status = CDFlib1($operation, $item, $LongArrayRef);

		} elsif ($item == &rVARs_RECDATA_ || $item == &zVARs_RECDATA_) {
			my $Long = shift;
			my $LongArrayRef = shift;
			my $VoidArrayRef = shift;
			$status = CDFlibla2($operation, $item, $Long, 
					    $LongArrayRef, $VoidArrayRef);

		} elsif ($item == &CDF_COMPRESSION_ || 
			 $item == &rVAR_COMPRESSION_ ||
			 $item == &rVAR_SPARSEARRAYS_ || 
			 $item == &zVAR_COMPRESSION_ ||
			 $item == &zVAR_SPARSEARRAYS_) {
			my $Long1Ref = shift;
			my $LongArrayRef = shift;
			my $Long2Ref = shift;
			$status = CDFlib515($operation, $item, $$Long1Ref, 
					    $LongArrayRef, $$Long2Ref);

		} elsif ($item == &CDF_INFO_) {
			my $String = shift;
			my $Long1Ref = shift;
			my $LongArrayRef = shift;
			my $Long2Ref = shift;
			my $Long3Ref = shift;
			$status = CDFlibs5155($operation, $item, $String, 
					      $$Long1Ref, $LongArrayRef, 
					      $$Long2Ref, $$Long3Ref);

		} else {
			unshift (@_, $item);
			last FCN;
		} #end if
		return $status if ($status != &CDF_OK);
	   } #end for
	} #end if GET_

	
#############################################################################
# OPEN
#############################################################################
	
	if ($operation == &OPEN_) {
	   for (;;) {
		my $item = shift;
		if ($item == &CDF_) {
		  my $String = shift;
		  my $CDFidRef = shift;
		  $status = CDFlibs4($operation, $item, $String, $$CDFidRef);
		} else {
		  unshift (@_, $item);
		  last FCN;
		} #end if
		return $status if ($status != &CDF_OK);
	   } #end for
	} #end if OPEN_

#############################################################################
# PUT
#############################################################################
	
	if ($operation == &PUT_) {
	   for (;;) {
		my $item = shift;
		if ($item == &ATTR_NAME_ || $item == &rVAR_NAME_ || 
		    $item == &zVAR_NAME_) {
			my $String = shift;
			$status = CDFlibs($operation, $item, $String);

		} elsif ($item == &ATTR_SCOPE_ || $item == &CDF_ENCODING_ || 
		         $item == &CDF_FORMAT_ || $item == &CDF_MAJORITY_ || 
		         $item == &rVAR_ALLOCATERECS_ || 
			 $item == &rVAR_BLOCKINGFACTOR_ ||
		         $item == &rVAR_INITIALRECS_ || 
			 $item == &rVAR_RECVARY_ || 
			 $item == &rVAR_SPARSERECORDS_ ||
		         $item == &zVAR_ALLOCATERECS_ || 
			 $item == &zVAR_BLOCKINGFACTOR_ || 
		         $item == &zVAR_INITIALRECS_ || 
			 $item == &zVAR_RECVARY_ ||
			 $item == &zVAR_SPARSERECORDS_ || 
			 $item == &CDF_LEAPSECONDLASTUPDATED_ ||
			 $item == &CDF_CHECKSUM_) {
			my $Long = shift;
			$status = CDFlibl($operation, $item, $Long);

		} elsif ($item == &gENTRY_DATA_ || $item == &rENTRY_DATA_  || 
		         $item == &zENTRY_DATA_) {
			my $Long1 = shift;
			my $Long2 = shift;
			my $VoidData = shift;
			if ((($Long1 != &CDF_CHAR && $Long1 != &CDF_UCHAR) &&
			    ($Long2 != 1)) || ref($VoidData) eq "ARRAY") {
			  $status = CDFliblla($operation, $item, $Long1,
					      $Long2, $VoidData);
			} else {
			  $status = CDFlibllv($operation, $item, $Long1, 
					      $Long2, $VoidData);
			}

		} elsif ($item == &rENTRY_STRINGSDATA_  ||
                         $item == &zENTRY_STRINGSDATA_) {
			my $VoidData = shift;
                        my $Long1;
                        $Long1 = scalar(@$VoidData);
			$status = CDFlib8B($operation, $item, $Long1,
					   $VoidData);

		} elsif ($item == &gENTRY_DATASPEC_ || 
			 $item == &rENTRY_DATASPEC_ ||
		         $item == &rVAR_DATASPEC_ || 
			 $item == &zENTRY_DATASPEC_ || 
		         $item == &zVAR_DATASPEC_ || 
			 $item == &rVAR_ALLOCATEBLOCK_ ||
			 $item == &zVAR_ALLOCATEBLOCK_) {
			my $Long = shift;
			my $Long1 = shift;
			$status = CDFlibll($operation, $item, $Long, $Long1);

		} elsif ($item == &rVAR_DATA_ || $item == &rVAR_PADVALUE_ || 
			 $item == &rVAR_SEQDATA_ || $item == &zVAR_DATA_ ||
			 $item == &zVAR_PADVALUE_ || $item == &zVAR_SEQDATA_) {
			my $VoidRef = shift;
			if (ref($VoidRef) eq "ARRAY") {
			  $status = CDFliba($operation, $item, $VoidRef);
			} else {
			  $status = CDFlibv($operation, $item, $VoidRef);
			}
                } elsif ($item == &rVAR_HYPERDATA_ ||
                         $item == &zVAR_HYPERDATA_ ) {
                        my $VoidArrayRef = shift;
                        $status = CDFlibb($operation, $item, $VoidArrayRef);

		} elsif ($item == &rVAR_DIMVARYS_ || $item == &zVAR_DIMVARYS_) {
			my $LongArrayRef = shift;
			$status = CDFliba($operation, $item, $LongArrayRef);

		} elsif ($item == &rVARs_RECDATA_ || $item == &zVARs_RECDATA_) {
			my $Long = shift;
			my $LongArrayRef = shift;
			my $VoidArrayRef= shift;
			$status = CDFliblab($operation, $item, $Long, 
					    $LongArrayRef, $VoidArrayRef);

		} elsif ($item == &CDF_COMPRESSION_ || 
			 $item == &rVAR_COMPRESSION_ ||
			 $item == &zVAR_COMPRESSION_ || 
			 $item == &rVAR_SPARSEARRAYS_ ||
			 $item == &zVAR_SPARSEARRAYS_) {
			my $Long = shift;
			my $LongArrayRef = shift;
			$status = CDFlibla($operation, $item, $Long, 
					   $LongArrayRef);

		} else {
			unshift (@_, $item);
			last FCN;
		} #end if
		return $status if ($status != &CDF_OK);
	   } #end for
	} #end if PUT_

#############################################################################
# SELECT
#############################################################################

	if ($operation == &SELECT_) {
	   for (;;) {
		my $item = shift;
		if ($item == &ATTR_ || $item == &CDF_CACHESIZE_ || 
		    $item == &CDF_DECODING_ ||
		    $item == &CDF_NEGtoPOSfp0_MODE_ || 
		    $item == &CDF_READONLY_MODE_ || 
		    $item == &CDF_STATUS_ || $item == &CDF_zMODE_ || 
		    $item == &COMPRESS_CACHESIZE_ || $item == &gENTRY_ || 
		    $item == &rENTRY_ || $item == &rVAR_ || 
		    $item == &rVAR_CACHESIZE_ || 
		    $item == &rVAR_RESERVEPERCENT_ || 
		    $item == &rVARs_CACHESIZE_ ||
		    $item == &rVARs_RECCOUNT_ || 
		    $item == &rVARs_RECINTERVAL_ || 
		    $item == &rVARs_RECNUMBER_ ||
		    $item == &STAGE_CACHESIZE_ || 
		    $item == &zENTRY_ || $item == &zVAR_ || 
		    $item == &zVAR_CACHESIZE_ || 
		    $item == &zVAR_RECCOUNT_ || $item == &zVAR_RECINTERVAL_ || 
		    $item == &zVAR_RECNUMBER_ || 
		    $item == &zVAR_RESERVEPERCENT_ ||
		    $item == &zVARs_CACHESIZE_ || $item == &zVARs_RECNUMBER_) {
			my $Long = shift;
			$status = CDFlibl($operation, $item, $Long);

		} elsif ($item == &ATTR_NAME_ || $item == &CDF_SCRATCHDIR_ || 
			 $item == &rENTRY_NAME_ || $item == &rVAR_NAME_ || 
			 $item == &zENTRY_NAME_ || $item == &zVAR_NAME_) {
			my $String = shift;
			$status = CDFlibs($operation, $item, $String);

		} elsif ($item == &CDF_) {
#the CDFid datatype is void *. It becomes an IV in the XSUB 
			my $CDFid = shift;
			$status = CDFlibd($operation, $item, $CDFid);

		} elsif ($item == &rVAR_SEQPOS_ || $item == &zVAR_SEQPOS_) {
			my $Long = shift;
			my $LongArrayRef = shift;
			$status = CDFlibla($operation, $item, $Long, 
					   $LongArrayRef);

		} elsif ($item == &rVARs_DIMCOUNTS_ || 
			 $item == &rVARs_DIMINDICES_ || 
		         $item == &rVARs_DIMINTERVALS_ || 
			 $item == &zVAR_DIMCOUNTS_ || 
		         $item == &zVAR_DIMINDICES_ || 
			 $item == &zVAR_DIMINTERVALS_) {
			my $LongArrayRef = shift;
			$status = CDFliba($operation, $item, $LongArrayRef);

		} else {
			unshift (@_, $item);
			last FCN;
		} #end if
		return $status if ($status != &CDF_OK);
	   } #end for
	} #end if SELECT_
	
#unknown operation 
	return &BAD_FNC_OR_ITEM;
}#end FCN

#continue with next command
$status = CDF::CDFlib (@_);

} #end sub CDFlib

sub CDFcreate {
        use strict;
        my $path = shift;
	my $numDims = shift;
	my $dimSizesRef = shift;
	my $encoding = shift;
	my $majority = shift;
	my $id = shift;
        my $status;
        $status = CDFcreateX( $path, $numDims, $dimSizesRef, $encoding,
			      $majority, $$id);
	return $status;
} #end sub CDFcreate

sub CDFopen {
        use strict;
        my $path = shift;
        my $id = shift;
	my $status;
        $status = CDFopenX( $path, $$id);
        return $status;
}#end sub CDFopen
 
sub CDFdoc {
        use strict;
        my $id = shift;
	my $version = shift;
	my $release = shift;
	my $text = shift;
	my $status;
        $status = CDFdocX( $id, $$version, $$release, $$text);
        return $status;
}#end sub CDFdoc

sub CDFinquire {
        use strict;
        my $id = shift;
	my $numDims = shift;
        my $dimSizesRef = shift;
        my $encoding = shift;
        my $majority = shift;
        my $maxRec = shift;
        my $numVars = shift;
        my $numAttrs = shift;
        my $status;
        $status = CDFinquireX( $id, $$numDims, $dimSizesRef, $$encoding, 
			       $$majority, $$maxRec, $$numVars, $$numAttrs);
        return $status;
}#end sub CDFinquire

sub CDFclose {
        use strict;
        my $id = shift;
	my $status;
        $status = CDFcloseX( $id);
        return $status;
}#end sub CDFclose

sub CDFdelete {
        use strict;
        my $id = shift;
	my $status;
        $status = CDFdeleteX( $id);
        return $status;
}#end sub CDFdelete

sub CDFerror {
        use strict;
        my $stat = shift;
	my $text = shift;
	my $status;
        $status = CDFerrorX( $stat, $$text);
        return $status;
}#end sub CDFerror

sub CDFattrCreate {
        use strict;
        my $id = shift;
        my $attrName = shift;
        my $attrScope = shift;
        my $attrNum = shift;
        my $status;
        $status = CDFattrCreateX( $id, $attrName, $attrScope, $$attrNum);
        return $status;
}#end sub CDFattrCreate

sub CDFattrNum {
        use strict;
        my $id = shift;
        my $attrName = shift;
        my $status;
        $status = CDFattrNumX( $id, $attrName);
	return $status;
}#end sub CDFattrNum

sub CDFattrRename {
        use strict;
        my $id = shift;
        my $attrNum = shift;
        my $attrName = shift;
        my $status;
        $status = CDFattrRenameX( $id, $attrNum, $attrName);
        return $status;
}#end sub CDFattrRename

sub CDFattrInquire {
        use strict;
        my $id = shift;
        my $attrNum = shift;
        my $attrName = shift;
        my $attrScope = shift;
        my $maxEntry = shift;
        my $status;
        $status = CDFattrInquireX( $id, $attrNum, $$attrName, $$attrScope, 
				   $$maxEntry );
        return $status;
}#end sub CDFattrInquire

sub CDFattrEntryInquire {
        use strict;
        my $id = shift;
        my $attrNum = shift;
        my $entryNum = shift;
	my $dataType = shift;
	my $numElems = shift;
        my $status;
        $status = CDFattrEntryInquireX( $id, $attrNum, $entryNum, $$dataType,
				        $$numElems);
        return $status;
}#end sub CDFattrEntryInquire

sub CDFattrGet {
        use strict;
        my $id = shift;
        my $attrNum = shift;
        my $entryNum = shift;
        my $value = shift;
        my $status;
	if (ref($value) eq "SCALAR") {
          $status = CDFattrGetX( $id, $attrNum, $entryNum, $value);
	} else {
	  $status = CDFattrGetXA( $id, $attrNum, $entryNum, $value);
	}
        return $status;
}#end sub CDFattrGet

sub CDFattrPut {
        use strict;
        my $id = shift;
        my $attrNum = shift;
        my $entryNum = shift;
        my $dataType = shift;
        my $numElems = shift;
	my $value = shift;
        my $status;
	if (ref($value) eq "SCALAR") {
          $status = CDFattrPutX( $id, $attrNum, $entryNum, $dataType, $numElems,
			         $value);
	} else {
	  $status = CDFattrPutXA( $id, $attrNum, $entryNum, $dataType, $numElems,
				  $value);
	}
        return $status;
}#end sub CDFattrPut

sub CDFvarCreate {
        use strict;
        my $id = shift;
        my $varName = shift;
        my $dataType = shift;
        my $numElements = shift;
        my $recVary = shift;
        my $dimVarysRef = shift;
        my $varNum = shift;
        my $status;
        $status = CDFvarCreateX( $id, $varName, $dataType, $numElements, 
				 $recVary, $dimVarysRef, $$varNum);
        return $status;
}#end sub CDFvarCreate

sub CDFvarNum {
        use strict;
        my $id = shift;
        my $varName = shift;
        my $varNum;
        $varNum = CDFvarNumX( $id, $varName);
        return $varNum;
}#end sub CDFvarNum

sub CDFvarRename {
        use strict;
        my $id = shift;
        my $varNum = shift;
        my $varName = shift;
        my $status;
        $status = CDFvarRenameX( $id, $varNum, $varName);
        return $status;
}#end sub CDFvarRename

sub CDFvarInquire {
        use strict;
        my $id = shift;
        my $varNum = shift;
        my $varName = shift;
        my $dataType = shift;
        my $numElements = shift;
        my $recVary = shift;
        my $dimVarysRef = shift;
        my $status;
        $status = CDFvarInquireX( $id, $varNum, $$varName, $$dataType, 
				  $$numElements, $$recVary, $dimVarysRef);
        return $status;
}#end sub CDFvarInquire

sub CDFvarPut {
        use strict;
        my $id = shift;
        my $varNum = shift;
        my $recNum = shift;
        my $indicesRef = shift;
        my $value = shift;
        my $status;
        if (ref($value) eq "SCALAR") {
          $status = CDFvarPutX( $id, $varNum, $recNum, $indicesRef, $value);
	} else {
	  $status = CDFvarPutXA( $id, $varNum, $recNum, $indicesRef, $value);
	}
        return $status;
}#end sub CDFvarPut

sub CDFvarGet {
        use strict;
        my $id = shift;
        my $varNum = shift;
        my $recNum = shift;
        my $indicesRef = shift;
        my $value = shift;
        my $status;
        if (ref($value) eq "SCALAR") {
          $status = CDFvarGetX( $id, $varNum, $recNum, $indicesRef, $value);
	} else {
	  $status = CDFvarGetXA( $id, $varNum, $recNum, $indicesRef, $value);
	}
        return $status;
}#end sub CDFvarGet

sub CDFvHpPut {
        use strict;
        my $id = shift;
        my $varNum = shift;
        my $recStart = shift;
        my $recCount = shift;
        my $recInterval = shift;
        my $dimStartRef = shift;
        my $dimCountRef = shift;
        my $dimIntervalRef = shift;
	my $buffer = shift;
        my $status;
        $status = CDFvHpPutX( $id, $varNum, $recStart, $recCount, 
				   $recInterval, $dimStartRef, $dimCountRef, 
				   $dimIntervalRef, $buffer);
        return $status;
}#end sub CDFvHpPut

sub CDFvHpGet {
        use strict;
        my $id = shift;
        my $varNum = shift;
        my $recStart = shift;
        my $recCount = shift;
        my $recInterval = shift;
        my $dimStartRef = shift;
        my $dimCountRef = shift;
        my $dimIntervalRef = shift;
        my $buffer = shift;
        my $status;
        $status = CDFvHpGetX( $id, $varNum, $recStart, $recCount,
                                   $recInterval, $dimStartRef, $dimCountRef,
                                   $dimIntervalRef, $buffer);
        return $status;
}#end sub CDFvHpGet

sub CDFvarClose {
	use strict;
	my $id = shift;
	my $varNum = shift;
	my $status;
	$status = CDFvarCloseX( $id, $varNum);
	return $status;
}#end sub CDFvarClose

sub CDFsetFileBackward {
        use strict;
        my $flag = shift;
        CDFsetFileBackwardX( $flag);
}#end sub CDFsetFileBackward

sub CDFgetFileBackward {
        use strict; 
        my $flag;
        $flag = CDFgetFileBackwardX();
        return $flag;
}#end sub CDFgetFileBackward
        
sub CDFsetChecksum {
        use strict;
        my $id = shift;
        my $chksum = shift;
        my $status;
        $status = CDFsetChecksumX($id, $chksum);
        return $status;
}#end sub CDFsetChecksum

sub CDFgetChecksum {
        use strict;
        my $id = shift;
        my $chksum = shift;
        my $status;
        $status = CDFgetChecksumX($id, $$chksum);
        return $status;
}#end sub CDFgetChecksum

sub CDFsetValidate {
        use strict;
        my $validateX = shift;
        CDFsetValidateX($validateX);
}#end sub CDFsetValidate

sub CDFgetValidate {
        use strict;
        my $validateX;
        $validateX = CDFgetValidateX();
        return $validateX;
}#end sub CDFgetValidate

sub computeEPOCH {
        my $year = shift;
        my $month = shift;
        my $day = shift;
        my $hour = shift;
        my $minute = shift;
        my $second = shift;
        my $milsec = shift;
	if (ref($year) ne "ARRAY") {
          return computeEPOCHX ($year, $month, $day, $hour, $minute, $second,
	     		        $milsec); 
	} else {
	  my @values;
	  my @years = @$year;
	  my @months = @$month;
	  my @days = @$day;
	  my @hours = @$hour;
	  my @minutes = @$minute;
	  my @seconds = @$second;
	  my @milsecs = @$milsec;
	  $#values = $#years;
	  for (my $i = 0; $i <= $#years; $i++) {
            $values[$i] = computeEPOCHX ($years[$i], $months[$i], $days[$i],
					 $hours[$i], $minutes[$i], $seconds[$i],
					 $milsecs[$i]);
	  }
          return @values;
	}
}#end sub computeEPOCH

sub toParseEPOCH {
        use strict;
        my $epochString = shift;
        my $len;
        if (ref($epochString) ne "ARRAY") {
          return parseEPOCHX ($epochString);
        } else {
          my @values;
          my @strs = @$epochString;
          $#values = $#strs;
          for (my $i = 0; $i <= $#strs; $i++) {
            $values[$i] =  parseEPOCHX ($strs[$i]);
          }
          return @values;
        }
}#end sub toParseEPOCH

sub toParseEPOCH16 {
        use strict;
        my $epochString = shift;
        my $epoch = shift;
        return parseEPOCH16X($epochString, $epoch);
}#end sub toParseEPOCH16

sub parseEPOCH {
        use strict;
        my $epochString = shift;
	if (ref($epochString) ne "ARRAY") {
          return parseEPOCHX ($epochString);
	} else {
	  my @values;
	  my @strs = @$epochString;
	  $#values = $#strs;
	  for (my $i = 0; $i <= $#strs; $i++) {
            $values[$i] = parseEPOCHX ($strs[$i]);
	  }
          return @values;
	}
}#end sub parseEPOCH

sub toEncodeEPOCH {
        my $epoch = $_[0];
        my $style = $_[1];
	my $stra = $_[2];
        if ($style < 0 || $style > 4) {
          $style = 4;
        }
	if (ref($epoch) ne "ARRAY") {
          if ($style == 0) {
            encodeEPOCH ($epoch, $_[2]);
          } elsif ($style == 1) {
            encodeEPOCH1 ($epoch, $_[2]);
          } elsif ($style == 2) {
            encodeEPOCH2 ($epoch, $_[2]);
          } elsif ($style == 3) {
            encodeEPOCH3 ($epoch, $_[2]);
          } else {
            encodeEPOCH4 ($epoch, $_[2]);
          }
	} else {
	  my @t1 = @$epoch;
	  my ($i, $astr);
	  for ($i=0; $i <= $#t1; $i++) {
            if ($style == 0) {
              encodeEPOCH ($t1[$i], $astr);
            } elsif ($style == 1) {
              encodeEPOCH1 ($t1[$i], $astr);
            } elsif ($style == 2) {
              encodeEPOCH2 ($t1[$i], $astr);
            } elsif ($style == 3) {
              encodeEPOCH3 ($t1[$i], $astr);
            } else {
              encodeEPOCH4 ($t1[$i], $astr);
            }
	    $$stra[$i] = $astr;
	  }
	}
}#end sub toEncodeEPOCH

sub toEncodeEPOCH16 {
        my $epoch = $_[0];
        my $style = $_[1];
	my $stra = $_[2];
        if ($style < 0 || $style > 4) {
         $style = 4;
        }
        if ($style == 0) {
            encodeEPOCH16 ($epoch, $_[2]);
        } elsif ($style == 1) {
            encodeEPOCH16_1 ($epoch, $_[2]);
        } elsif ($style == 2) {
            encodeEPOCH16_2 ($epoch, $_[2]);
        } elsif ($style == 3) {
            encodeEPOCH16_3 ($epoch, $_[2]);
        } else {
            encodeEPOCH16_4 ($epoch, $_[2]);
        }
}#end sub toEncodeEPOCH16

sub EPOCHtoUnixTime {
        my $epoch = $_[0];
	my $unixTime = $_[1];
	if (ref($epoch) ne "ARRAY") {
          my (@epochs, @times);
          $epochs[0] = $epoch;
          EPOCHtoUnixTimeX (\@epochs, \@times);
          $_[1] = $times[0];
	} else {
          EPOCHtoUnixTimeX ($epoch, $unixTime);
	}
}#end sub EPOCHtoUnixTime

sub EPOCH16toUnixTime {
        my $epoch = $_[0];
	my $unixTime = $_[1];
	if (ref($epoch) ne "ARRAY") {
          my @epochs;
          $epochs[0] = $epoch;
          $epochs[1] = 0;
          EPOCH16toUnixTimeX (\@epochs, $unixTime);
          $_[1] = $times[0];
	} else {
          EPOCH16toUnixTimeX ($epoch, $unixTime);
	}
}#end sub EPOCH16toUnixTime

sub TT2000toUnixTime {
        my $epoch = $_[0];
	my $unixTime = $_[1];
	if (ref($epoch) ne "ARRAY") {
          my (@epochs, @times);
          $epochs[0] = $epoch;
          TT2000toUnixTimeX (\@epochs, \@times);
          $_[1] = $times[0];
	} else {
          TT2000toUnixTimeX ($epoch, $unixTime);
	}
}#end sub TT2000toUnixTime

sub UnixTimetoEPOCH {
        my $epoch = $_[1];
	my $unixTime = $_[0];
	if (ref($unixTime) ne "ARRAY") {
          my (@epochs, @times);
          $times[0] = $unixTime;
          UnixTimetoEPOCHX (\@times, \@epochs);
          $_[1] = $epochs[0];
	} else {
          UnixTimetoEPOCHX ($unixTime, $epoch);
	}
}#end sub UnixTimetoEPOCH

sub UnixTimetoEPOCH16 {
        my $epoch = $_[1];
	my $unixTime = $_[0];
	if (ref($unixTime) ne "ARRAY") {
          my @times;
          $times[0] = $unixTime;
          UnixTimetoEPOCH16X (\@times, $epoch);
          $_[1] = \@epochs;
	} else {
          UnixTimetoEPOCH16X ($unixTime, $epoch);
	}
}#end sub UnixTimetoEPOCH16

sub UnixTimetoTT2000 {
        my $epoch = $_[1];
	my $unixTime = $_[0];
	if (ref($unixTime) ne "ARRAY") {
          my (@epochs, @times);
          $times[0] = $unixTime;
          UnixTimetoTT2000X (\@times, \@epochs);
          $_[1] = $epochs[0];
	} else {
          UnixTimetoTT2000X ($unixTime, $epoch);
	}
}#end sub UnixTimetoTT2000

sub encodeEPOCH {
        my $epoch = $_[0];
	my $stra = $_[1];
	if (ref($epoch) ne "ARRAY") {
          encodeEPOCHX ($epoch, $_[1]);
	} else {
	  my @t1 = @$epoch;
	  my ($i, $astr);
	  for ($i=0; $i <= $#t1; $i++) {
            encodeEPOCHX ($t1[$i], $astr);
	    $$stra[$i] = $astr;
	  }
	}
}#end sub encodeEPOCH

sub computeTT2000 {
        use strict;
        use Math::BigInt;
        my $year = shift;
        my $month = shift;
        my $day = shift;
        my $hour = shift;
        my $minute = shift;
        my $second = shift;
        my $milsec = shift;
        my $micsec = shift;
        my $nansec = shift;
	if (ref($year) ne "ARRAY") {
          my $tt2000Str;
          computeTT2000X ($year, $month, $day, $hour, $minute, $second, $milsec,
                          $micsec, $nansec, $tt2000Str); 
          return Math::BigInt->new($tt2000Str);
	} else {
	  my @values;
	  my @years = @$year;
	  my @months = @$month;
	  my @days = @$day;
	  my @hours = @$hour;
	  my @minutes = @$minute;
	  my @seconds = @$second;
	  my @milsecs = @$milsec;
	  my @micsecs = @$micsec;
	  my @nansecs = @$nansec;
	  $#values = $#years;
	  my $value;
	  for (my $i = 0; $i <= $#years; $i++) {
            computeTT2000X ($years[$i], $months[$i], $days[$i], $hours[$i],
			    $minutes[$i], $seconds[$i], $milsecs[$i],
                            $micsecs[$i], $nansecs[$i], $value); 
            $values[$i] = Math::BigInt->new($value);
	  }
          return @values;
	}
}#end sub computeTT2000

sub toParseTT2000 {
        my $tt2000String = shift;
        return parseTT2000 ($tt2000String);
}#end sub toParseTT2000

sub parseTT2000 {
        use strict;
        use Math::BigInt;
        my $tt2000String = shift;
	if (ref($tt2000String) ne "ARRAY") {
          my $tt2000Str;
          parseTT2000X ($tt2000String, $tt2000Str);
          my $tt2000 = Math::BigInt->new($tt2000Str);
          return $tt2000;
	} else {
	  my @values;
	  my @strs = @$tt2000String;
	  $#values = $#strs;
	  my $value;
	  for (my $i = 0; $i <= $#strs; $i++) {
            parseTT2000X ($strs[$i], $value);
            $values[$i] = Math::BigInt->new($value);
	  }
          return @values;
	}
}#end sub parseTT2000

sub toEncodeTT2000 {
        use strict;
        my $tt2000 = $_[0];
	my $stra = $_[2];
        my $format = $_[1];
        if ($format < 0 || $format > 4) {
          $format = 3;
        }
	if (ref($tt2000) ne "ARRAY") {
          encodeTT2000X ($tt2000, $_[2], $format);
	} else {
	  my @t1 = @$tt2000;
	  # my @t2 = @$stra;
	  # $#t2 = $#t1;
	  my ($i, $astr);
	  for ($i=0; $i <= $#t1; $i++) {
            encodeTT2000X ($t1[$i], $astr, $format);
	    $$stra[$i] = $astr;
	  }
	}
}#end sub toEncodeTT2000

sub encodeTT2000 {
        use strict;
        my $tt2000 = $_[0];
	my $stra = $_[1];
        my $format;
        if (scalar(@_) == 3) {
          $format = $_[2];
        } else {
          $format = 3;
        }
	if (ref($tt2000) ne "ARRAY") {
          encodeTT2000X ($tt2000, $_[1], $format);
	} else {
	  my @t1 = @$tt2000;
	  # my @t2 = @$stra;
	  # $#t2 = $#t1;
	  my ($i, $astr);
	  for ($i=0; $i <= $#t1; $i++) {
            encodeTT2000X ($t1[$i], $astr, $format);
	    $$stra[$i] = $astr;
	  }
	}
}#end sub encodeTT2000

sub leapsecondsinfo {
        use strict;
        my $debug;
        if (scalar(@_) == 1) {
          my $value;
          $value = shift;
          $debug = int($value);
        } else {
          $debug = 0;
        }
        leapsecondsinfoX ($debug);
}#end sub leapseonds_infoX

sub CDFgetGlobalMetaData {
        use strict;
        my @args = @_;
        my $cdf = $args[0];
        my @globals = ();
        my $enteredGlobals = -1;
        my $metaEncoding = 1;
        if (scalar(@_) > 1) {
          my $haveGlobals = $args[1];
          if (ref($haveGlobals) eq "ARRAY") {
            if ($#$haveGlobals == -1) {
              $enteredGlobals = -1;
            } else {
              @globals = @$haveGlobals;
              $enteredGlobals = $#globals + 1;
            }
          } else {
            if (!(defined $haveGlobals)) {
              $enteredGlobals = -1;
            } else {
              if ($haveGlobals ne "ALL") {
                @globals = split(',', $haveGlobals);
                $enteredGlobals = $#globals + 1;
              } else {
                $enteredGlobals = -1;
              }
            }
          }
        }
        if (scalar(@_) > 2) {
          $metaEncoding = $args[2];
          if ($metaEncoding != 0) {
            $metaEncoding = 1;
          }
        }
        my $id = ();
        my ($toClose, $status, $cdfName, $numAttrs, $i, $scope, $attrName);
        my %metax = ();
        $toClose = 0;
        if ($cdf =~ /^\d+$/) {
          $status = CDFlib(&SELECT_, &CDF_, $cdf,
                           &NULL_);
          if ($status != &CDF_OK) {
            $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                             &NULL_);
            $toClose = 1;
          } else {
            $id = $cdf;
          }
        } else {
          $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                           &NULL_);
          $toClose = 1;
        }
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        $status = CDFlib (&GET_, &CDF_NUMATTRS_, \$numAttrs,
                          &NULL_);
        if ($status != &CDF_OK) {
          return ($status, %metax);
        }
        my $found;
        for ($i = 0; $i < $numAttrs; $i++) {
          $status = CDFlib(&SELECT_, &ATTR_, $i,
                           &GET_, &ATTR_SCOPE_, \$scope,
                                  &ATTR_NAME_, \$attrName,
                           &NULL_);
          if ($scope != &GLOBAL_SCOPE) {
            next;
          } else {
            $found = 1;
            if ($enteredGlobals != -1) {
              $found = 0;
              my $l;
              for ($l = 0; $l < $enteredGlobals; $l++) {
                if ($globals[$l] =~ /^\d+$/) {
                  if ($i == $globals[$l]) {
                    $found = 1;
                    last;
                  }
                } else {
                  if ($attrName eq $globals[$l]) {
                    $found = 1;
                    last;
                  }
                }
              }
            }
          }
          if ($found == 0) {
            next;
          } else {
            my $maxEntry;
            $status = CDFlib(&GET_, &ATTR_MAXgENTRY_, \$maxEntry,
                             &NULL_);
            if ($status != &CDF_OK || $maxEntry < 0) {
              next;
            } else {
              my ($j, $dataType, $numElems, $entry);
              my %meta2 = ();
              for ($j = 0; $j <= $maxEntry; $j++) {
                my @entry2 = ();
                $status = CDFlib(&SELECT_, &gENTRY_, $j,
                                 &GET_, &gENTRY_DATATYPE_, \$dataType,
                                        &gENTRY_NUMELEMS_, \$numElems,
                                 &NULL_);
                if ($status != &CDF_OK) {
                  next;
                } 
                if ($dataType == &CDF_EPOCH16 || ($numElems > 1 &&
                                                  ($dataType != &CDF_CHAR &&
                                                   $dataType != &CDF_UCHAR))) {
                  $status = CDFlib(&GET_, &gENTRY_DATA_, \@entry2,
                                   &NULL_);
                } else {
                  $status = CDFlib(&GET_, &gENTRY_DATA_, \$entry,
                                   &NULL_);
                }
                if ($metaEncoding == 1) {
                  if ($dataType == &CDF_EPOCH) {
                    if ($numElems == 1) {
                      my $epoch;
                      toEncodeEPOCH ($entry, 4, $epoch);
                      $meta2{$j} = $epoch;
                    } else {
                      my @epoch;
                      toEncodeEPOCH (@entry2, 4, \@epoch);
                      $meta2{$j} = \@epoch;
                    }
                  } elsif ($dataType == &CDF_EPOCH16) {
                    if ($numElems == 1) {
                      my $epoch2;
                      toEncodeEPOCH16 (\@entry2, 4, $epoch2);
                      $meta2{$j} = $epoch2;
                    } else {
                      my @epoch2;
                      toEncodeEPOCH16 (\@entry2, 4, \@epoch2);
                      $meta2{$j} = \@epoch2;
                    }
                  } elsif ($dataType == &CDF_TIME_TT2000) {
                    if ($numElems == 1) {
                      my $epoch;
                      toEncodeTT2000 ($entry, 3, $epoch);
                      $meta2{$j} = $epoch;
                    } else {
                      my @epoch2;
                      toEncodeTT2000 (\@entry2, 3, \@epoch2);
                      $meta2{$j} = \@epoch2;
                    }
                  } else {
                    if ($dataType == &CDF_CHAR || $dataType == &CDF_UCHAR ||
                        $numElems == 1) {
                      $meta2{$j} = $entry;
                    } else {
                      $meta2{$j} = \@entry2;
                    }
                  }
                } else {
                  if ($dataType == &CDF_EPOCH16 || ($dataType != &CDF_CHAR &&
                                                    $dataType != &CDF_UCHAR &&
                                                    $numElems > 1)) {
                    $meta2{$j} = \@entry2;
                  } else {
                    $meta2{$j} = $entry;
                  }
                }
              }
              $metax{$attrName} = {%meta2};
            }
          }
        }
        if ($toClose == 1) {
          $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
        }
        $status = &CDF_OK;
        return ($status, %metax);
}#end sub CDFgetGlobalMetaData

sub CDFgetVarMetaData {
        use strict;
        my @args = @_;
        my $cdf = $args[0];
        my $var = $args[1];
        my $metaEncoding;
        if (scalar(@_) > 2) {
          $metaEncoding = $args[2];
        } else {
          $metaEncoding = 1;
        }
        my $id = ();
        my ($toClose, $varName, $varNum, $numElems, $status, $numAttrs,$zMode);
        $toClose = 0;
        my %metax = ();
        if ($cdf =~ /^\d+$/) {
          $status = CDFlib(&SELECT_, &CDF_, $cdf,
                           &NULL_);
          if ($status != &CDF_OK) {
            $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                             &NULL_);
            $toClose = 1;
          }
        } else {
          $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                           &NULL_);
          $toClose = 1;
        }
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        $status = CDFlib(&CONFIRM_, &CDF_zMODE_, \$zMode,
                         &GET_, &CDF_NUMATTRS_, \$numAttrs,
                         &SELECT_, &CDF_zMODE_, &zMODEon2,
                         &NULL_);
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        my $check = 0;
        if ($var =~ /^\d+$/) {
          $varNum = $var;
          $status = CDFlib(&SELECT_, &zVAR_, $varNum,
                           &GET_, &zVAR_NAME_, \$varName,
                           &NULL_);
          if ($status == &CDF_OK) {
            $check++;
          }
        } 
        if ($check == 0) {
          $varName = $var;
          $status = CDFlib(&GET_, &zVAR_NUMBER_, $varName, \$varNum,
                           &NULL_);
          if ($status != &CDF_OK) {
            if ($toClose == 1) {
              $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
            }
            return (&BAD_VAR_NAME, ());
          }
        }
        $status = CDFlib (&SELECT_, &zVAR_, $varNum,
                                    &zENTRY_, $varNum,
                          &NULL_);
        if ($status != &CDF_OK) {
          if ($toClose == 1) {
            $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
          }
          return ($status, ());
        }
        my ($i, $scope, $attrName, $entry, $dataType);
        for ($i = 0; $i < $numAttrs; $i++) {
          my @entry2 = ();
          $status = CDFlib(&SELECT_, &ATTR_, $i,
                           &GET_, &ATTR_SCOPE_, \$scope,
                                  &ATTR_NAME_, \$attrName,
                           &NULL_);
          if ($scope == &GLOBAL_SCOPE) {
            next;
          } else {
            $status = CDFlib(&SELECT_, &zENTRY_, $varNum,
                             &GET_, &zENTRY_DATATYPE_, \$dataType,
                                    &zENTRY_NUMELEMS_, \$numElems,
                             &NULL_);
            if ($status != &CDF_OK) {
              next;
            }
            if ($dataType == &CDF_EPOCH16 || ($dataType != &CDF_CHAR &&
                                              $dataType != &CDF_UCHAR &&
                                              $numElems > 1)) {
              $status = CDFlib(&GET_, &zENTRY_DATA_, \@entry2,
                               &NULL_);
            } else {
              $status = CDFlib(&GET_, &zENTRY_DATA_, \$entry,
                               &NULL_);
            }
            if ($metaEncoding == 1) {
              if ($dataType == &CDF_EPOCH) {
                if ($numElems == 1) {
                  my $epoch;
                  toEncodeEPOCH ($entry, 4, $epoch);
                  $metax{$attrName} = $epoch;
                } else {
                  my @epoch;
                  toEncodeEPOCH (\@entry2, 4, \@epoch);
                  $metax{$attrName} = \@epoch;
                }
              } elsif ($dataType == &CDF_EPOCH16) {
                if ($numElems == 1) {
                  my $epoch2;
                  toEncodeEPOCH16 (\@entry2, 4, $epoch2);
                  $metax{$attrName} = $epoch2;
                } else {
                  my @epoch2;
                  my ($jj, $ep16String);
                  my @ep16;
                  for ($jj = 0; $jj < $numElems; ++$jj) {
                    $ep16[0] = $entry2[2*$jj];
                    $ep16[1] = $entry2[2*$jj+1];
                    toEncodeEPOCH16 (\@ep16, 4, $ep16String);
                    $epoch2[$jj] = $ep16String;
                  }
#                  toEncodeEPOCH16 (\@entry2, 4, \@epoch2);
                  $metax{$attrName} = \@epoch2;
                }
              } elsif ($dataType == &CDF_TIME_TT2000) {
                if ($numElems == 1) {
                  my $epoch;
                  toEncodeTT2000 ($entry, 3, $epoch);
                  $metax{$attrName} = $epoch;
                } else {
                  my @epoch;
                  toEncodeTT2000 (\@entry2, 3, \@epoch);
                  $metax{$attrName} = \@epoch;
                }
              } else {
                if ($numElems == 1 || ($dataType == &CDF_CHAR ||
                                       $dataType == &CDF_UCHAR)) {
                  $metax{$attrName} = $entry;
                } else {
                  $metax{$attrName} = \@entry2;
                }
              }
            } else {
              if ($dataType == &CDF_EPOCH16 || ($dataType != &CDF_CHAR &&
                                                $dataType != &CDF_UCHAR &&
                                                $numElems > 1)) {
                $metax{$attrName} = \@entry2;
              } else {
                $metax{$attrName} = $entry;
              }
            }
          }
        }
        if ($toClose == 1) {
          $status = CDFlib (&CLOSE_, &CDF_, &NULL_);
        } else {
          $status = CDFlib (&SELECT_, &CDF_zMODE_, $zMode,
                            &NULL_);
        }
        return (&CDF_OK, %metax);
}#end sub CDFgetVarMetaData

sub CDFgetLIBInfo {
        use strict;
        my $id;
        my ($status, $year, $month, $day);
        my ($lib_ver, $lib_rel, $lib_inc);
        my %libInfo;
        $status = CDFlib(&GET_, &LIB_VERSION_, \$lib_ver,
                                &LIB_RELEASE_, \$lib_rel,
                                &LIB_INCREMENT_, \$lib_inc,
                         &NULL_);
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        $libInfo{"LIB_VERSION"} = $lib_ver.".".$lib_rel.".".$lib_inc;
        leapsecondsinfoY ($year, $month, $day);
        $libInfo{"LATEST_LEAPSECOND_IN_TABLE"} = $year*10000+$month*100+$day;
        return (&CDF_OK, %libInfo);
}#end sub CDFgetLIBInfo

sub CDFgetCDFInfo {
        use strict;
        my $cdf = shift;
        my $id = ();
        my ($toClose, $numrVars, $numzVars, $status, $numgAttrs, $numvAttrs);
        my ($majority, $format, $encoding, $release, $version, $increment);
        my ($lastleap, $cdfName);
        my %cdfInfo;
        $toClose = 0;
        if ($cdf =~ /^\d+$/) {
          $status = CDFlib(&SELECT_, &CDF_, $cdf,
                           &NULL_);
          if ($status != &CDF_OK) {
            $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                             &NULL_);
            $toClose = 1;
          }
        } else {
          $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                           &NULL_);
          $toClose = 1;
        }
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        $status = CDFlib(&GET_, &CDF_NUMrVARS_, \$numrVars,
                                &CDF_NUMzVARS_, \$numzVars,
                                &CDF_NUMgATTRS_, \$numgAttrs,
                                &CDF_NUMvATTRS_, \$numvAttrs,
                                &CDF_ENCODING_, \$encoding,
                                &CDF_FORMAT_, \$format,
                                &CDF_MAJORITY_, \$majority,
                                &CDF_RELEASE_, \$release,
                                &CDF_VERSION_, \$version,
                                &CDF_INCREMENT_, \$increment,
                                &CDF_LEAPSECONDLASTUPDATED_, \$lastleap,
                          &NULL_);
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        if ($toClose == 1) {
          $cdfInfo{"NAME"} = $cdf;
        }
        $cdfInfo{"FORMAT"} = getFormat($format);
        $cdfInfo{"MAJORITY"} = getMajority($majority);
        $cdfInfo{"ENCODING"} = getEncoding($encoding);
        $cdfInfo{"CDF_VERSION"} = $version.".".$release.".".$increment;
        $cdfInfo{"BASED_LEAPSECOND_LAST_UPDATED"} = $lastleap;
        $cdfInfo{"NUMrVARS"} = $numrVars;
        $cdfInfo{"NUMzVARS"} = $numzVars;
        $cdfInfo{"NUMgATTRS"} = $numgAttrs;
        $cdfInfo{"NUMvATTRS"} = $numvAttrs;
        if ($toClose == 1) {
          $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
        }
        return (&CDF_OK, %cdfInfo);
}#end sub CDFgetCDFInfo

sub CDFgetVarInfo {
        use strict;
        my @args = @_;
        my $cdf = $args[0];
        my $var = $args[1];
        my $id = ();
        my ($toClose, $varNum, $status, $dataType, $numElems);
        my ($numDims, $recVary, $maxRec, $varName, $zMode);
        my (@dimSizes, @dimVarys);
        my %varInfo;
        $toClose = 0;
        if ($cdf =~ /^\d+$/) {
          $status = CDFlib(&SELECT_, &CDF_, $cdf,
                           &NULL_);
          if ($status != &CDF_OK) {
            $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                             &NULL_);
            $toClose = 1;
          }
        } else {
          $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                           &NULL_);
          $toClose = 1;
        }
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        $status = CDFlib(&CONFIRM_, &CDF_zMODE_, \$zMode,
                         &SELECT_, &CDF_zMODE_, &zMODEon2,
                         &NULL_);
        if ($status != &CDF_OK) {
          if ($toClose == 1) {
            $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
          }
          return ($status, ());
        }
        my $check = 0;
        if ($var =~ /^\d+$/) {
          $varNum = $var;
          $status = CDFlib(&SELECT_, &zVAR_, $varNum,
                           &GET_, &zVAR_NAME_, \$varName,
                           &NULL_);
          if ($status == &CDF_OK) {
            $check++;
          }
        }
        if ($check == 0) {
          $varName = $var;
          $status = CDFlib(&GET_, &zVAR_NUMBER_, $varName, \$varNum,
                           &NULL_);
          if ($status != &CDF_OK) {
            if ($toClose == 1) {
              $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
            }
            return (&BAD_VAR_NAME, ());
          }
        }
        $status = CDFlib (&SELECT_, &zVAR_, $varNum,
                          &GET_, &zVAR_DATATYPE_, \$dataType,
                                 &zVAR_NUMELEMS_, \$numElems,
                                 &zVAR_NUMDIMS_, \$numDims,
                                 &zVAR_DIMSIZES_, \@dimSizes,
                                 &zVAR_DIMVARYS_, \@dimVarys,
                                 &zVAR_RECVARY_, \$recVary,
                                 &zVAR_MAXREC_, \$maxRec,
                          &NULL_);
        if ($status != &CDF_OK) {
          if ($toClose == 1) {
            $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
          }
          return ($status, ());
        }
        $varInfo{"DataType"} = getStringDataType($dataType);
        $varInfo{"NumElems"} = $numElems;
        $varInfo{"NumDims"} = $numDims;
        if ($numDims > 0) {
          my $i; my %indices;
          for ($i = 0; $i < $numDims; $i++) {
            $varInfo{"DimSizes"}{$i} = $dimSizes[$i];
          }
          for ($i = 0; $i < $numDims; $i++) {
            $varInfo{"DimVarys"}{$i} = $dimVarys[$i]==0?"False":"True";
          }
        }
        $varInfo{"RecVary"} = $recVary==0?"False":"True";
        $varInfo{"VarName"} = $varName;
        $varInfo{"MaxRec"} = $maxRec;
        if ($toClose == 1) {
          $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
        } else {
          $status = CDFlib (&SELECT_, &CDF_zMODE_, $zMode,
                            &NULL_);
        }
        return (&CDF_OK, %varInfo);
}#end sub CDFgetVarInfo

sub CDFgetVarAllData {
        use strict;
        my @args = @_;
        my $cdf = $args[0];
        my $var = $args[1];
        my $id = ();
        my ($matrix, $varNum, $status, $maxRec, $numDims, $varName, $dataType);
        my (@dimSizes, @dimIndices, @dimIntervals);
        my ($toClose, $zMode);
        my (@values, @outData);
        $toClose = 0;
        $matrix = 0;
        my $dataEncoding = 0;
        if (scalar(@_) > 2) {
          $dataEncoding = $args[2];
        }
        if (scalar(@_) > 3) {
          $matrix = $args[3];
        }

        if ($cdf =~ /^\d+$/) {
          $status = CDFlib(&SELECT_, &CDF_, $cdf,
                           &NULL_);
          if ($status != &CDF_OK) {
            $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                             &NULL_);
            $toClose = 1;
          }
        } else {
          $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                           &NULL_);
          $toClose = 1;
        }
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        $status = CDFlib(&CONFIRM_, &CDF_zMODE_, \$zMode,
                         &SELECT_, &CDF_zMODE_, &zMODEon2,
                         &NULL_);
        if ($status != &CDF_OK) {
          if ($toClose == 1) {
            $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
          }
          return ($status, ());
        }
        my $check = 0;
        if ($var =~ /^\d+$/) {
          $varNum = $var;
          $status = CDFlib(&SELECT_, &zVAR_, $varNum,
                           &GET_, &zVAR_NAME_, \$varName,
                           &NULL_);
          if ($status == &CDF_OK) {
            $check++;
          }
        }
        if ($check == 0) {
          $varName = $var;
          $status = CDFlib(&GET_, &zVAR_NUMBER_, $varName, \$varNum,
                           &NULL_);
          if ($status != &CDF_OK) {
            if ($toClose == 1) {
              $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
            }
            return (&BAD_VAR_NAME, ());
          }
        }
        $status = CDFlib (&SELECT_, &zVAR_, $varNum,
                          &GET_, &zVAR_DIMSIZES_, \@dimSizes,
                                 &zVAR_MAXREC_, \$maxRec,
                                 &zVAR_NUMDIMS_, \$numDims,
                                 &zVAR_DATATYPE_, \$dataType,
                          &NULL_);
        if ($status == &CDF_OK && $maxRec > -1) {
          my $i;
          if ($numDims > 0) {
            for ($i = 0; $i < $numDims; ++$i) {
              $dimIndices[$i] = 0;
              $dimIntervals[$i] = 1;
            }
          } else {
              $dimIndices[0] = 0;
              $dimIntervals[0] = 1;
          }
          $status = CDFlib (&SELECT_, &zVAR_RECNUMBER_, 0,
                                      &zVAR_RECCOUNT_, ($maxRec + 1),
                                      &zVAR_RECINTERVAL_, 1,
                                      &zVAR_DIMINDICES_, \@dimIndices,
                                      &zVAR_DIMCOUNTS_, \@dimSizes,
                                      &zVAR_DIMINTERVALS_, \@dimIntervals,
                            &NULL_);
          $status = CDFlib2(&GET_, &zVAR_HYPERDATA_,\@values);
          if ($dataEncoding == 1) {
            if ($dataType == &CDF_EPOCH) {
              toEncodeEPOCH(\@values, 4, \@outData);
            } elsif ($dataType == &CDF_TIME_TT2000) {
              toEncodeTT2000(\@values, 3, \@outData);
            } elsif ($dataType == &CDF_EPOCH16) {
              my @ep16;
              my $ep16String;
              for ($i = 0; $i <= $maxRec; ++$i) {
                $ep16[0] = $values[2*$i];
                $ep16[1] = $values[2*$i+1];
                toEncodeEPOCH16(\@ep16, 3, $ep16String);
                $outData[$i] = $ep16String;
              }
            } else {
              @outData = @values;
            }
          } else {
            @outData = @values;
          }

          if ($status >= &CDF_OK && $matrix == 1) {
            if ($dataType == &CDF_EPOCH16) {
              if ($numDims == 0) {
                $dimSizes[0] = 2;
              } else {
                push @dimSizes, 2;
              }
              $numDims++;
            }
            my $numRecs = $maxRec + 1;
            if ($numDims > 0) {
              if ($numRecs > 1) {
                unshift @dimSizes, $numRecs;
              }
              my $matrix = make_matrix(\@dimSizes, \@outData);
              @outData = @$matrix;
            }
          }
        } else {
          @outData = ();
        }
        if ($toClose == 1) {
          $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
        } else {
          $status = CDFlib (&SELECT_, &CDF_zMODE_, $zMode,
                            &NULL_);
        }
        return ($status, @outData);
}#end sub CDFgetVarAllData

sub make_matrix {
  my ($dims_ref, $flat_ref) = @_;
  my @dims        = @$dims_ref;
  my $current_dim = shift @dims;
  my $result      = [];
  return [ splice @$flat_ref, 0, $current_dim ] unless @dims;
  for ( 1 .. $current_dim ) {
    push @$result, make_matrix( \@dims, $flat_ref );
  }
  return $result;
}#end sub make_matrix

sub getStringDataType {
  my $cdfDataType = shift;
  my $cDataType;
  if ($cdfDataType == &CDF_BYTE) {
    $cDataType = "CDF_BYTE";
  } elsif ($cdfDataType == &CDF_CHAR) {
    $cDataType = "CDF_CHAR";
  } elsif ($cdfDataType == &CDF_UCHAR) {
    $cDataType = "CDF_UCHAR";
  } elsif ($cdfDataType == &CDF_INT1) {
    $cDataType = "CDF_INT1";
  } elsif ($cdfDataType == &CDF_UINT1) {
    $cDataType = "CDF_UINT1";
  } elsif ($cdfDataType == &CDF_INT2) {
    $cDataType = "CDF_INT2";
  } elsif ($cdfDataType == &CDF_UINT2) {
    $cDataType = "CDF_UINT2";
  } elsif ($cdfDataType == &CDF_INT4) {
    $cDataType = "CDF_INT4";
  } elsif ($cdfDataType == &CDF_UINT4) {
    $cDataType = "CDF_UINT4";
  } elsif ($cdfDataType == &CDF_INT8) {
    $cDataType = "CDF_INT8";
  } elsif ($cdfDataType == &CDF_REAL4) {
    $cDataType = "CDF_REAL4";
  } elsif ($cdfDataType == &CDF_FLOAT) {
    $cDataType = "CDF_FLOAT";
  } elsif ($cdfDataType == &CDF_REAL8) {
    $cDataType = "CDF_REAL8";
  } elsif ($cdfDataType == &CDF_DOUBLE) {
    $cDataType = "CDF_DOUBLE";
  } elsif ($cdfDataType == &CDF_EPOCH) {
    $cDataType = "CDF_EPOCH";
  } elsif ($cdfDataType == &CDF_EPOCH16) {
    $cDataType = "CDF_EPOCH16";
  } elsif ($cdfDataType == &CDF_TIME_TT2000) {
    $cDataType = "CDF_TIME_TT2000";
  } else {
    $cDataType = "UNKNOWN";
  }
  return $cDataType;
}

sub getEncoding {
  my $encoding = shift;
  my @cEncoding = (" ", "NETWORK", "SUN", "VAX", "DECSTATION", "SGi",
                   "IBMPC", "IBMRS", "HOST", "PPC", " ", "HP",
                   "NeXT", "ALPHAOSF1", "ALPHAVMSd", "ALPHAVMSg",
                   "ALPHAVMSi", "ARM_LITTLE", "ARM_BIG", "IA64VMSi",
                   "IA64VMSd", "IA64VMSg");
  return $cEncoding[$encoding];
}

sub getMajority {
  my $major = shift;
  my @cMajor = ("", "ROW", "COLUMN");
  return $cMajor[$major];
}

sub getFormat {
  my $format = shift;
  my @cFormat = ("", "SINGLE", "MULTI");
  return $cFormat[$format];
}


