using System;
using System.Runtime.InteropServices;
using CDF;

public class CDFLeapSecondsInfo : CDFAPIs {
	
   unsafe public static void Main(string[] args) {
     bool dump = false;
     string table = null;
     double[,] lt;
     int fileStatus;
     int year, month, day;
     int ix, rows;
     if (args.Length == 1) {
       string option = args[0];
       if (option.ToLower().Equals("dump")) dump = true;
     }
     Console.WriteLine ("Info for CDF leap second table...");
     try {
       table = CDFgetLeapSecondsTableEnvVar();
     } catch (CDFException ex) {
       table = null;
     }
     fileStatus = CDFgetLeapSecondsTableStatus();
     if (table == null) {
       Console.WriteLine ("Environment Variable: CDF_LEAPSECONDSTABLE is NOT defined....");
       Console.WriteLine ("Thus, the hard-coded table is used.");
     } else {
       if (fileStatus == 0) {
         Console.WriteLine ("Environment Variable: CDF_LEAPSECONDSTABLE is defined as: "+table);
         Console.WriteLine ("                      but the file is invalid...."); 
         Console.WriteLine ("Thus, the hard-coded table is used.");
       } else
         Console.WriteLine ("CDF's leap seconds table is based on the file: "+table);
     }
     CDFgetLastDateinLeapSecondsTable (out year, out month, out day);
     Console.WriteLine ("The last date a leap second was added to the table is: "+year+"-"+(month<10?"0":"")+month+"-"+(day<10?"0":"")+day);
     if (dump) {
       lt = (double [,]) CDFgetLeapSecondsTableObject();
       rows = CDFgetRowsinLeapSecondsTable();
       Console.WriteLine ("    \t     \t     \t  Leap \t\t  Drift\t\t  Drift");
       Console.WriteLine ("Year\tMonth\t  Day\tSeconds\t\t     1 \t\t     2");
       for (ix = 0; ix < rows; ++ix) {
         if (ix < 5) 
           Console.WriteLine (""+lt[ix,0]+"\t  "+lt[ix,1]+"\t  "+lt[ix,2]+"\t"+lt[ix,3]+"\t "+lt[ix,4]+"\t\t"+lt[ix,5]);
         else if (ix < 14)
           Console.WriteLine (""+lt[ix,0]+"\t  "+lt[ix,1]+"\t  "+lt[ix,2]+"\t"+lt[ix,3]+"\t\t "+lt[ix,4]+"\t\t"+lt[ix,5]);
         else
           Console.WriteLine (""+lt[ix,0]+"\t  "+lt[ix,1]+"\t  "+lt[ix,2]+"\t"+lt[ix,3]+"\t\t "+lt[ix,4]+"\t\t   "+lt[ix,5]);

       }
     }
   }
}

