using System;
using System.Runtime.InteropServices;
using CDF;

public class Qst2cEpoch : CDFAPIs {

unsafe public static void Main() {
int     year=2001,month=10,day=1,hour=12,minute=10,second=20,msec=100;
int     yearOut,monthOut,dayOut,hourOut,minuteOut,secondOut,msecOut;
double epoch, epochSave;
string  encodeText;

/******************************************************************************
* Display title.
******************************************************************************/

Console.WriteLine("Testing C# interface for CDF_EPOCH ...");
try {
epoch = computeEPOCH(year,month,day,hour,minute,second,msec);

epochSave = epoch;

encodeEPOCH(epoch, out encodeText);
Console.WriteLine("encodeEPOCH: "+encodeText);
encodeEPOCHx(epoch,"<dom.02>-<month>-<year> <hour>:<min>:<sec>.<fos>",
             out encodeText);
Console.WriteLine("encodeEPOCHx: "+encodeText);
encodeEPOCH1(epoch,out encodeText);
Console.WriteLine("1. encodeEPOCH1: "+encodeText);
epoch = parseEPOCH1(encodeText);
encodeEPOCH1(epoch,out encodeText);
Console.WriteLine("2. parseEPOCH1:  "+encodeText);

epoch = epochSave;
encodeEPOCH2(epoch,out encodeText);
Console.WriteLine("3. encodeEPOCH2: "+encodeText);
epoch = parseEPOCH2(encodeText);
encodeEPOCH2(epoch,out encodeText);
Console.WriteLine("4. parseEPOCH2:  "+encodeText);

epoch = epochSave;
encodeEPOCH3(epoch,out encodeText);
Console.WriteLine("5. encodeEPOCH3: "+encodeText);
epoch = parseEPOCH3(encodeText);
encodeEPOCH3(epoch,out encodeText);
Console.WriteLine("6. parseEPOCH3:  "+encodeText);

epoch = epochSave;
encodeEPOCH4(epoch,out encodeText);
Console.WriteLine("7. encodeEPOCH4: "+encodeText);
epoch = parseEPOCH4(encodeText);
encodeEPOCH4(epoch,out encodeText);
Console.WriteLine("8. parseEPOCH4:  "+encodeText);

epoch = epochSave;

EPOCHbreakdown(epoch,&yearOut,&monthOut,&dayOut,&hourOut,
	       &minuteOut,&secondOut,&msecOut);
if(year != yearOut) Quit("9.2a");
if(month != monthOut) Quit("9.3a");
if(day != dayOut) Quit("9.4a");
if(hour != hourOut) Quit("9.5a");
if(minute != minuteOut) Quit("9.6a");
if(second != secondOut) Quit("9.7a");
if(msec != msecOut) Quit("9.8a");

} catch (CDFException ex) {
  Console.WriteLine("Error: "+ex);
}
}


/******************************************************************************
* Quit
******************************************************************************/

unsafe static void Quit(string where)
{
  Console.WriteLine("Aborting at "+where);
}

}


