
Imports System
Imports System.Runtime.InteropServices
Imports CDF

Public Class Qst2cTT2000
	Inherits CDFAPIs

	Public Shared Sub Main()
		Dim id As Long = 0
		'
		' Display title.
		'
		Console.WriteLine("Testing VB interface for CDF_TT2000 ...")

		Dim status As Integer
		Dim varnum As Integer
		Dim variance As Integer = VARY
		Dim dimSizes As Integer() = New Integer(0) {0}, _
		    dimVary As Integer() = New Integer(0) {VARY}
		Dim indices As Integer() = New Integer(0) {0}, _
		    counts As Integer() = New Integer(0) {1}, _
		    intervals As Integer() = New Integer(0) {1}

		Dim tt2000 As Long() = New Long(7) {}, _
		    mm As Long() = New Long(7) {}
		Dim year1 As Double = 2008, month1 As Double = 12, _
		    day1 As Double = 31, hour1 As Double = 23, _
		    minute1 As Double = 59, second1 As Double = 57, _
			msec1 As Double = 100, usec1 As Double = 200, _
		    nsec1 As Double = 300
		Dim year As Double = 2008, month As Double = 12, _
		    day As Double = 31, hour As Double = 23, _
		    minute As Double = 59, second As Double = 57, _
		    msec As Double = 100, usec As Double = 200, _
		    nsec As Double = 300
		Dim yearOut As Double, monthOut As Double, dayOut As Double, _
		    hourOut As Double, minuteOut As Double, _
		    secondOut As Double, msecOut As Double, usecOut As Double, _
		    nsecOut As Double
		Dim ix As Integer
		Dim tt2000String As String

		Dim int8 As Long(,) = New Long(2, 1) {}
		Dim int8o As Long(,) = New Long(2, 1) {}
		Dim nn As Long

		'
		' Create CDF.
		'

		Try
		   status = CDFcreate("TEST", 0, dimSizes, IBMPC_ENCODING, _
				      ROW_MAJOR, id)
		Catch ex As CDFException
			status = ex.CDFgetCurrentStatus()
			If status < CDF_OK Then
				If status = CDF_EXISTS Then
					status = CDFopen("TEST", id)
					If status < CDF_OK Then
						QuitCDF("1.0", status)
					End If

					status = CDFdeleteCDF(id)
					If status < CDF_OK Then
						QuitCDF("1.1", status)
					End If
					status = CDFcreate("TEST", 0, _
							dimSizes, _
							IBMPC_ENCODING, _
							ROW_MAJOR, id)
					If status < CDF_OK Then
						QuitCDF("6.0", status)
					End If
				End If
			End If
		End Try
		'
		' Create variables.
		'

		Try
			status = CDFcreatezVar(id, "myTT2000", _
					CDF_TIME_TT2000, 1, 0, dimSizes, _
					variance, dimVary, varnum)
			If status < CDF_OK Then
				QuitCDF("7.0", status)
			End If

			dimSizes(0) = 2

			status = CDFcreatezVar(id, "myINT8", CDF_INT8, _
					1, 1, dimSizes, _
					variance, dimVary, varnum)
			If status < CDF_OK Then
				QuitCDF("7.1", status)
			End If

			'
			' PUT to variables.
			'


			tt2000(0) = computeTT2000(year, month, day, hour, minute, second, _
				msec, usec, nsec)
			If tt2000(0) = ILLEGAL_TT2000_VALUE Then
				QuitCDF("9.0", TT2000_TIME_ERROR)
			End If
			For ix = 1 To 7
				tt2000(ix) = tt2000(0) + CLng(ix) * 1000000000
			Next

			varnum = CDFgetVarNum(id, "myTT2000")
			status = CDFhyperPutzVarData(id, varnum, 0, 8, 1, indices, _
				counts, intervals, tt2000)

			If status < CDF_OK Then
				QuitCDF("10.0", status)
			End If

			'
			' HyperGET from variables.
			'

			status = CDFhyperGetzVarData(id, varnum, 0, 8, 1, indices, _
				counts, intervals, mm)

			If status < CDF_OK Then
				QuitCDF("11.0", status)
			End If

			For ix = 0 To 7
			   TT2000breakdown(mm(ix), yearOut, _
					   monthOut, dayOut, _
					   hourOut, minuteOut, _
					   secondOut, msecOut, _
					   usecOut, nsecOut)
			   If year <> yearOut Then
					QuitCDF("11.1", status)
			   End If
			   If month <> monthOut Then
					QuitCDF("11.2", status)
			   End If
			   If day <> dayOut Then
					QuitCDF("11.3", status)
			   End If
			   If hour <> hourOut Then
					QuitCDF("11.4", status)
			   End If
			   If minute <> minuteOut Then
					QuitCDF("11.5", status)
			   End If
			   If second <> secondOut Then
					QuitCDF("11.6", status)
			   End If
			   If msec <> msecOut Then
					QuitCDF("11.7", status)
			   End If
			   If usec <> usecOut Then
					QuitCDF("11.8", status)
			   End If
			   If nsec <> nsecOut Then
					QuitCDF("11.9", status)
			   End If
			   second += 1
			   If second > 60 Then
					year = 2009
					month = 1
					day = 1
					hour = 0
					minute = 0
					second = 0
			   End If
			Next

			varnum = CDFgetVarNum(id, "myINT8")
			nn = 88888888888L
			For ix = 0 To 2
				int8(ix, 0) = nn
				int8(ix, 1) = -nn
				nn += 1
			Next

			counts(0) = 2
			status = CDFhyperPutzVarData(id, varnum, 0, 3, 1, indices, _
				counts, intervals, int8)

			If status < CDF_OK Then
				QuitCDF("12.0", status)
			End If

			status = CDFhyperGetzVarData(id, varnum, 0, 3, 1, indices, _
				counts, intervals, int8o)

			If status < CDF_OK Then
				QuitCDF("13.0", status)
			End If

			nn = 88888888888L
			For ix = 0 To 2
				If int8o(ix, 0) <> nn Then
					QuitCDF("14.0", status)
				End If
				

				If int8o(ix, 1) <> -nn Then
					QuitCDF("14.1", status)
				End If
				

				nn += 1
			Next

			'
			' Close CDF.
			'


			status = CDFcloseCDF(id)
			If status < CDF_OK Then
				QuitCDF("26.2", status)
			End If

			'
			' Re-open the CDF.
			'


			status = CDFopen("TEST", id)

			If status < CDF_OK Then
				QuitCDF("30.1", status)
			End If
			varnum = CDFvarNum(id, "myTT2000")
			If varnum < CDF_OK Then
				QuitCDF("31.1", status)
			End If
			'
			' HyperGET from variables.
			'

			status = CDFhyperGetzVarData(id, varnum, 0, 8, 1, indices, _
				counts, intervals, mm)

			If status < CDF_OK Then
				QuitCDF("32.1", status)
			End If

			For ix = 0 To 7
			   TT2000breakdown(mm(ix), yearOut, monthOut, dayOut, hourOut, minuteOut, _
					secondOut, msecOut, usecOut, nsecOut)
			   encodeTT2000(mm(ix), tt2000String, 3)
			   Console.WriteLine("TT2000: {0} -> {1}",mm(ix), tt2000String)
			   If year1 <> yearOut Then
					QuitCDF("33.1", status)
			   End If
			   If month1 <> monthOut Then
					QuitCDF("33.2", status)
			   End If
			   If day1 <> dayOut Then
					QuitCDF("33.3", status)
			   End If
			   If hour1 <> hourOut Then
					QuitCDF("33.4", status)
			   End If
			   If minute1 <> minuteOut Then
					QuitCDF("33.5", status)
			   End If
			   If second1 <> secondOut Then
					QuitCDF("33.6", status)
			   End If
			   If msec1 <> msecOut Then
					QuitCDF("33.7", status)
			   End If
			   If usec1 <> usecOut Then
					QuitCDF("33.8", status)
			   End If
			   If nsec1 <> nsecOut Then
					QuitCDF("33.9", status)
		   	   End If
			   second1 += 1
			   If second1 > 60 Then
					year1 += 1
					month1 = 1
					day1 = 1
					hour1 = 0
					minute1 = 0
					second1 = 0
			   End If
			Next

			'
			' Close CDF.
			'


			status = CDFcloseCDF(id)
			If status < CDF_OK Then
				QuitCDF("26.2", status)
			End If


			'
			' Test for invalid time.
			'


			Dim dummy As [String]
			encodeTT2000(DUMMY_TT2000_VALUE, dummy)
			Console.WriteLine(" {0} is {1}", DUMMY_TT2000_VALUE,dummy)
			Dim att2000 As Long = parseTT2000("9999-12-31T23:59:59.999999999")


			Console.WriteLine("9999-12-31T23:59:59.999999999 is: {0}", att2000)
		Catch ex As CDFException
			Console.WriteLine("Error: " + ex.toString())
		End Try

	End Sub


	Private Shared Sub QuitCDF(where As String, status As Integer)
		Console.WriteLine("Aborting at " + where)
		Dim text As String
		If status < CDF_OK Then
			CDF.CDFAPIs.CDFgetStatusText(status, text)
			Console.WriteLine("Error..." + text)
		End If
	End Sub

End Class

