/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import gov.nasa.gsfc.spdf.cdfj.ADR;
import gov.nasa.gsfc.spdf.cdfj.AEDR;
import gov.nasa.gsfc.spdf.cdfj.ArrayAttribute;
import gov.nasa.gsfc.spdf.cdfj.CDFDataType;
import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFTimeType;
import gov.nasa.gsfc.spdf.cdfj.CDR;
import gov.nasa.gsfc.spdf.cdfj.DataContainer;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.GDR;
import gov.nasa.gsfc.spdf.cdfj.GlobalAttributeEntry;
import gov.nasa.gsfc.spdf.cdfj.SparseRecordOption;
import gov.nasa.gsfc.spdf.cdfj.VDR;
import gov.nasa.gsfc.spdf.cdfj.VariableAttributeEntry;
import gov.nasa.gsfc.spdf.cdfj.VariableDataBuffer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;

public class GenericWriter {
    LinkedHashMap<String, ADR> attributes = new LinkedHashMap();
    LinkedHashMap<String, Vector<AEDR>> attributeEntries = new LinkedHashMap();
    LinkedHashMap<String, VDR> variableDescriptors = new LinkedHashMap();
    int lastLeapSecondId = -1;
    CDR cdr = new CDR();
    GDR gdr = new GDR();
    public final boolean rowMajority;
    LinkedHashMap<String, DataContainer> dataContainers = new LinkedHashMap();
    boolean needDigest = false;

    public GenericWriter() {
        this(true);
    }

    public GenericWriter(boolean bl) {
        this.rowMajority = bl;
    }

    ADR getAttribute(String string, boolean bl) {
        return this.getAttribute(string, bl, true);
    }

    ADR getAttribute(String string, boolean bl, boolean bl2) {
        ADR aDR = this.attributes.get(string);
        if (aDR != null) {
            return this.attributes.get(string);
        }
        if (!bl2) {
            return null;
        }
        aDR = new ADR();
        aDR.setScope(bl ? 1 : 2);
        aDR.name = string;
        int n = this.attributes.size();
        aDR.setNum(n);
        this.attributes.put(string, aDR);
        return aDR;
    }

    public void addGlobalAttributeEntry(String string, Object object) throws CDFException.WriterError {
        this.addGlobalAttributeEntry(string, null, object);
    }

    public void addGlobalAttributeEntry(String string, CDFDataType cDFDataType, Object object) throws CDFException.WriterError {
        GlobalAttributeEntry globalAttributeEntry;
        ADR aDR = this.getAttribute(string, true);
        Vector<AEDR> vector = this.attributeEntries.get(string);
        if (vector == null) {
            vector = new Vector();
            this.attributeEntries.put(string, vector);
        }
        int n = cDFDataType == null ? -1 : cDFDataType.getValue();
        try {
            globalAttributeEntry = new GlobalAttributeEntry(aDR, n, object);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
        globalAttributeEntry.setNum(aDR.ngrEntries);
        aDR.mAXgrEntry = aDR.ngrEntries++;
        vector.add(globalAttributeEntry);
    }

    Vector<VariableAttributeEntry> findVariableAttributeEntries(String string, String string2) throws CDFException.WriterError {
        VDR vDR = this.variableDescriptors.get(string);
        if (vDR == null) {
            throw new CDFException.WriterError("Variable " + string + " has not been defined.");
        }
        Vector<VariableAttributeEntry> vector = new Vector<VariableAttributeEntry>();
        Vector<AEDR> vector2 = this.attributeEntries.get(string2);
        if (vector2 == null) {
            return vector;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            VariableAttributeEntry variableAttributeEntry;
            try {
                variableAttributeEntry = (VariableAttributeEntry)vector2.get(i);
            }
            catch (Exception exception) {
                continue;
            }
            if (variableAttributeEntry.getNum() != vDR.getNum()) continue;
            vector.add(variableAttributeEntry);
        }
        return vector;
    }

    public void setVariableAttributeEntry(String string, String string2, Object object) throws CDFException.WriterError {
        this.setVariableAttributeEntry(string, string2, null, object);
    }

    public void setVariableAttributeEntry(String string, String string2, CDFDataType cDFDataType, Object object) throws CDFException.WriterError {
        Vector<VariableAttributeEntry> vector = this.findVariableAttributeEntries(string, string2);
        if (vector.size() > 0) {
            if (!object.getClass().isArray() && object.getClass() != String.class) {
                throw new CDFException.WriterError("Value should be numeric array or a String.");
            }
            for (int i = 0; i < vector.size(); ++i) {
                this.attributeEntries.get(string2).remove(vector.get(i));
            }
            ADR aDR = this.getAttribute(string2, false);
            --aDR.nzEntries;
        }
        this.addVariableAttributeEntry(string, string2, cDFDataType, object);
    }

    public void addVariableAttributeEntry(String string, String string2, Object object) throws CDFException.WriterError {
        this.addVariableAttributeEntry(string, string2, null, object);
    }

    public void addVariableAttributeEntry(String string, String string2, CDFDataType cDFDataType, Object object) throws CDFException.WriterError {
        VariableAttributeEntry variableAttributeEntry;
        int n;
        VDR vDR = this.variableDescriptors.get(string);
        if (vDR == null) {
            throw new CDFException.WriterError("Variable " + string + " has not been defined.");
        }
        Vector<VariableAttributeEntry> vector = this.findVariableAttributeEntries(string, string2);
        if (vector.size() == 0) {
            if (!this.attributeEntries.containsKey(string2)) {
                this.attributeEntries.put(string2, new Vector());
            }
        } else if (object.getClass() != String.class && DataTypes.isStringType(n = vector.get((int)(vector.size() - 1)).dataType)) {
            throw new CDFException.WriterError("Only String values can be added");
        }
        ADR aDR = this.getAttribute(string2, false);
        int n2 = cDFDataType == null ? -1 : cDFDataType.getValue();
        try {
            variableAttributeEntry = new VariableAttributeEntry(aDR, n2, object);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
        variableAttributeEntry.setNum(vDR.getNum());
        this.attributeEntries.get(string2).add(variableAttributeEntry);
        if (vDR.getNum() > aDR.mAXzEntry) {
            aDR.mAXzEntry = vDR.getNum();
        }
        ++aDR.nzEntries;
    }

    public boolean hasTimeVariable(String string) throws CDFException.WriterError {
        VDR vDR = this.variableDescriptors.get(string);
        if (vDR == null) {
            throw new CDFException.WriterError("Variable " + string + " has not been defined yet.");
        }
        return this.findVariableAttributeEntries(string, "DEPEND_0").size() == 0;
    }

    public void defineTimeVariable(String string, CDFTimeType cDFTimeType) throws CDFException.WriterError {
        this.defineVariable(string, CDFDataType.getType(cDFTimeType), new int[0]);
    }

    public void defineTimeSeries(String string, CDFDataType cDFDataType, int[] nArray) throws CDFException.WriterError {
        this.defineTimeSeries(string, cDFDataType, nArray, "Epoch");
    }

    public void defineTimeSeries(String string, CDFDataType cDFDataType, int[] nArray, String string2) throws CDFException.WriterError {
        this.defineVariable(string, cDFDataType, nArray);
        VDR vDR = this.variableDescriptors.get(string);
        VDR vDR2 = this.variableDescriptors.get(string2);
        if (vDR2 == null) {
            throw new CDFException.WriterError("TimeVariable " + string2 + " does not exist.");
        }
        this.addVariableAttributeEntry(string, "DEPEND_0", string2);
    }

    public void defineCompressedTimeSeries(String string, CDFDataType cDFDataType, int[] nArray, String string2, CDFTimeType cDFTimeType) throws CDFException.WriterError {
        this.defineTimeSeries(string, cDFDataType, nArray, string2, cDFTimeType, true);
    }

    public void defineTimeSeries(String string, CDFDataType cDFDataType, int[] nArray, String string2, CDFTimeType cDFTimeType, boolean bl) throws CDFException.WriterError {
        if (!bl) {
            this.defineVariable(string, cDFDataType, nArray);
        }
        if (bl) {
            this.defineCompressedVariable(string, cDFDataType, nArray);
        }
        VDR vDR = this.variableDescriptors.get(string);
        VDR vDR2 = this.variableDescriptors.get(string2);
        if (vDR2 != null) {
            throw new CDFException.WriterError("TimeVariable " + string2 + " already exists.");
        }
        this.defineTimeVariable(string2, cDFTimeType);
        this.addVariableAttributeEntry(string, "DEPEND_0", string2);
    }

    public void defineVariable(String string, CDFDataType cDFDataType, int[] nArray) throws CDFException.WriterError {
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        this.defineVariable(string, cDFDataType, nArray, 1);
    }

    public void defineStringVariable(String string, int[] nArray, int n) throws CDFException.WriterError {
        this.defineVariable(string, CDFDataType.CHAR, nArray, n);
    }

    public void defineVariable(String string, CDFDataType cDFDataType, int[] nArray, int n) throws CDFException.WriterError {
        if (cDFDataType != CDFDataType.CHAR && n > 1) {
            throw new CDFException.WriterError("incompatible size for type " + cDFDataType);
        }
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        this.defineVariable(string, cDFDataType, nArray, blArray, true, false, null, n);
    }

    public void defineCompressedVariable(String string, CDFDataType cDFDataType, int[] nArray) throws CDFException.WriterError {
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        this.defineCompressedVariable(string, cDFDataType, nArray, 1);
    }

    public void defineCompressedStringVariable(String string, int[] nArray, int n) throws CDFException.WriterError {
        this.defineCompressedVariable(string, CDFDataType.CHAR, nArray, n);
    }

    public void defineCompressedVariable(String string, CDFDataType cDFDataType, int[] nArray, int n) throws CDFException.WriterError {
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        this.defineVariable(string, cDFDataType, nArray, blArray, true, true, null, n);
    }

    public void addNRVString(String string, String string2) throws CDFException.WriterError {
        this.addNRVVariable(string, CDFDataType.CHAR, new int[0], string2.length(), string2);
    }

    public void addNRVVariable(String string, CDFDataType cDFDataType, Object object) throws CDFException.WriterError {
        this.addNRVVariable(string, cDFDataType, new int[0], 1, object);
    }

    public void addNRVVariable(String string, CDFDataType cDFDataType, int[] nArray, Object object) throws CDFException.WriterError {
        if (cDFDataType == CDFDataType.CHAR) {
            throw new CDFException.WriterError("Invalid method for string type. Use addNRVVariable(name, dataType, dim, size, value)");
        }
        this.addNRVVariable(string, cDFDataType, nArray, 1, object);
    }

    public void addNRVVariable(String string, CDFDataType cDFDataType, int[] nArray, int n, Object object) throws CDFException.WriterError {
        if (cDFDataType != CDFDataType.CHAR && n > 1) {
            throw new CDFException.WriterError("incompatible size for type " + cDFDataType);
        }
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = true;
        }
        this.defineVariable(string, cDFDataType, nArray, blArray, false, false, null, n);
        if (nArray.length > 0 || cDFDataType == CDFDataType.EPOCH16) {
            try {
                this.addData(string, AArray.getPoint(object));
            }
            catch (Throwable throwable) {
                throw new CDFException.WriterError(throwable.getMessage());
            }
        } else {
            this.dispatch(string, object);
        }
    }

    public void defineNRVVariable(String string, CDFDataType cDFDataType, int[] nArray, int n) throws CDFException.WriterError {
        int n2;
        boolean[] blArray = new boolean[nArray.length];
        for (n2 = 0; n2 < blArray.length; ++n2) {
            blArray[n2] = true;
        }
        n2 = cDFDataType == CDFDataType.CHAR ? n : 1;
        this.defineVariable(string, cDFDataType, nArray, blArray, false, false, null, n2);
    }

    public void defineVariable(String string, CDFDataType cDFDataType, int[] nArray, boolean[] blArray, boolean bl, boolean bl2, Object object) throws CDFException.WriterError {
        this.defineVariable(string, cDFDataType, nArray, blArray, bl, bl2, object, 1, SparseRecordOption.NONE);
    }

    public void defineVariable(String string, CDFDataType cDFDataType, int[] nArray, boolean[] blArray, boolean bl, boolean bl2, Object object, SparseRecordOption sparseRecordOption) throws CDFException.WriterError {
        this.defineVariable(string, cDFDataType, nArray, blArray, bl, bl2, object, 1, sparseRecordOption);
    }

    public void defineStringVariable(String string, int[] nArray, boolean[] blArray, boolean bl, boolean bl2, Object object, int n) throws CDFException.WriterError {
        this.defineVariable(string, CDFDataType.CHAR, nArray, blArray, bl, bl2, object, n, SparseRecordOption.NONE);
    }

    public void defineStringVariable(String string, int[] nArray, boolean[] blArray, boolean bl, boolean bl2, Object object, int n, SparseRecordOption sparseRecordOption) throws CDFException.WriterError {
        this.defineVariable(string, CDFDataType.CHAR, nArray, blArray, bl, bl2, object, n, sparseRecordOption);
    }

    public void defineVariable(String string, CDFDataType cDFDataType, int[] nArray, boolean[] blArray, boolean bl, boolean bl2, Object object, int n) throws CDFException.WriterError {
        this.defineVariable(string, cDFDataType, nArray, blArray, bl, bl2, object, n, SparseRecordOption.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineVariable(String string, CDFDataType cDFDataType, int[] nArray, boolean[] blArray, boolean bl, boolean bl2, Object object, int n, SparseRecordOption sparseRecordOption) throws CDFException.WriterError {
        Object object2 = nArray;
        synchronized (nArray) {
            int n2;
            int[] nArray2 = new int[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray2[n2] = nArray[n2];
            }
            // ** MonitorExit[var12_10] (shouldn't be in output)
            object2 = blArray;
            synchronized (blArray) {
                Class<?> clazz;
                boolean[] blArray2 = new boolean[blArray.length];
                for (n2 = 0; n2 < blArray.length; ++n2) {
                    blArray2[n2] = blArray[n2];
                }
                // ** MonitorExit[var12_10] (shouldn't be in output)
                if (cDFDataType == CDFDataType.EPOCH16 && nArray.length > 0) {
                    throw new CDFException.WriterError("Only scalar variables of type EPOCH16 are supported.");
                }
                object2 = this.variableDescriptors.get(string);
                if (object2 != null) {
                    throw new CDFException.WriterError("Variable " + string + " exists already.");
                }
                Object object3 = null;
                if (object != null) {
                    clazz = object.getClass();
                    if (!clazz.isArray()) {
                        object3 = Array.newInstance(clazz, 1);
                        Array.set(object3, 0, object);
                    } else {
                        object3 = object;
                    }
                }
                try {
                    object2 = new VDR(string, cDFDataType.getValue(), nArray, blArray, bl, bl2, object3, n, sparseRecordOption);
                }
                catch (Throwable throwable) {
                    throw new CDFException.WriterError(throwable.getMessage());
                }
                ((VDR)object2).setNum(this.variableDescriptors.size());
                this.variableDescriptors.put(string, (VDR)object2);
                clazz = new DataContainer((VDR)object2, this.rowMajority);
                this.dataContainers.put(string, (DataContainer)((Object)clazz));
                return;
            }
        }
    }

    HashMap<String, VDR> getVariableDescriptors() {
        return this.variableDescriptors;
    }

    DataContainer getContainer(String string, Object object) throws CDFException.WriterError {
        ArrayAttribute arrayAttribute = null;
        try {
            arrayAttribute = new ArrayAttribute(object);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
        if (arrayAttribute.getDimensions().length != 1) {
            throw new CDFException.WriterError("data must be a 1 dimensional array. ");
        }
        DataContainer dataContainer = this.dataContainers.get(string);
        if (dataContainer == null) {
            throw new CDFException.WriterError("Variable " + string + " is not defined.");
        }
        return dataContainer;
    }

    public void addOneD(String string, Object object) throws CDFException.WriterError {
        DataContainer dataContainer = this.getContainer(string, object);
        try {
            dataContainer.addData(object, null, true, false);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public void addOneD(String string, Object object, boolean bl) throws CDFException.WriterError {
        DataContainer dataContainer = this.getContainer(string, object);
        try {
            dataContainer.addData(object, null, true, bl);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public void addOneD(String string, Object object, int[] nArray) throws CDFException.WriterError {
        DataContainer dataContainer = this.getContainer(string, object);
        try {
            dataContainer.addData(object, nArray, true, false);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public void addOneD(String string, Object object, int[] nArray, boolean bl) throws CDFException.WriterError {
        DataContainer dataContainer = this.getContainer(string, object);
        try {
            dataContainer.addData(object, nArray, true, bl);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public void addData(String string, Object object) throws CDFException.WriterError {
        DataContainer dataContainer = this.dataContainers.get(string);
        if (dataContainer == null) {
            throw new CDFException.WriterError("Variable " + string + " is not defined.");
        }
        try {
            dataContainer.addData(object, null, false, false);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public void addData(String string, Object object, boolean bl) throws CDFException.WriterError {
        DataContainer dataContainer = this.dataContainers.get(string);
        if (dataContainer == null) {
            throw new CDFException.WriterError("Variable " + string + " is not defined.");
        }
        try {
            dataContainer.addData(object, null, false, bl);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public void addData(String string, Object object, int[] nArray) throws CDFException.WriterError {
        DataContainer dataContainer = this.dataContainers.get(string);
        if (dataContainer == null) {
            throw new CDFException.WriterError("Variable " + string + " is not defined.");
        }
        try {
            dataContainer.addData(object, nArray, false, false);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public void addData(String string, Object object, int[] nArray, boolean bl) throws CDFException.WriterError {
        DataContainer dataContainer = this.dataContainers.get(string);
        if (dataContainer == null) {
            throw new CDFException.WriterError("Variable " + string + " is not defined.");
        }
        try {
            dataContainer.addData(object, nArray, false, bl);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    void addBuffer(String string, VariableDataBuffer variableDataBuffer) throws CDFException.WriterError {
        DataContainer dataContainer = this.dataContainers.get(string);
        if (dataContainer == null) {
            throw new CDFException.WriterError("Variable " + string + " is not defined.");
        }
        try {
            dataContainer.addData(variableDataBuffer.getBuffer(), new int[]{variableDataBuffer.getFirstRecord(), variableDataBuffer.getLastRecord()}, false, false);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public void setMD5Needed(boolean bl) {
        this.needDigest = bl;
    }

    long getSize() {
        Collection<Object> collection;
        Object object;
        long l = this.cdr.getSize();
        l += (long)this.gdr.getSize();
        Set<String> set = this.attributes.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            object = this.attributes.get(iterator.next());
            l += (long)((ADR)object).getSize();
        }
        object = this.attributeEntries.keySet();
        Iterator<String> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            collection = this.attributeEntries.get(iterator2.next());
            for (int i = 0; i < ((Vector)collection).size(); ++i) {
                l += (long)((AEDR)((Vector)collection).get(i)).getSize();
            }
        }
        collection = this.dataContainers.keySet();
        Iterator<String> iterator3 = collection.iterator();
        boolean bl = true;
        DataContainer dataContainer = null;
        while (iterator3.hasNext()) {
            DataContainer dataContainer2 = this.dataContainers.get(iterator3.next());
            dataContainer2.position = l;
            if (bl) {
                this.gdr.setZVDRHead(l);
                bl = false;
            } else {
                dataContainer.getVDR().setVDRNext(dataContainer2.position);
            }
            dataContainer = dataContainer2;
            l += (long)dataContainer2.getSize();
        }
        return l;
    }

    public void write(String string) throws IOException {
        Vector<AEDR> vector = this.attributeEntries.get("cdfj_source");
        if (vector != null && new String(vector.get((int)0).values).equals(string)) {
            System.out.println("overwriting " + string);
            this.write(string, true);
            return;
        }
        this.write(string, false);
    }

    public boolean write(String string, boolean bl) throws IOException {
        AEDR aEDR;
        int n;
        Vector<AEDR> vector;
        Object object;
        Object object2;
        ByteBuffer byteBuffer;
        if (this.lastLeapSecondId != -1) {
            this.gdr.setLastLeapSecondId(this.lastLeapSecondId);
        }
        long l = this.getSize();
        if (this.needDigest) {
            l += 32L;
        }
        RandomAccessFile randomAccessFile = null;
        FileChannel fileChannel = null;
        if (l > Integer.MAX_VALUE) {
            randomAccessFile = new RandomAccessFile(new File(string), "rw");
            fileChannel = randomAccessFile.getChannel();
            this.write(fileChannel, l);
            randomAccessFile.close();
            return true;
        }
        if (this.isWindows()) {
            byteBuffer = ByteBuffer.allocate((int)l);
        } else if (bl) {
            byteBuffer = ByteBuffer.allocateDirect((int)l);
        } else {
            randomAccessFile = new RandomAccessFile(new File(string), "rw");
            fileChannel = randomAccessFile.getChannel();
            byteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, l);
        }
        this.cdr.setRowMajority(this.rowMajority);
        this.cdr.setMD5Needed(this.needDigest);
        byteBuffer.put(this.cdr.get());
        this.gdr.position = byteBuffer.position();
        byteBuffer.position((int)(this.gdr.position + (long)this.gdr.getSize()));
        Set<String> set = this.attributes.keySet();
        Iterator<String> iterator = set.iterator();
        boolean bl2 = true;
        Object object3 = null;
        while (iterator.hasNext()) {
            object2 = this.attributes.get(iterator.next());
            object = ((ADR)object2).name;
            ((ADR)object2).position = byteBuffer.position();
            byteBuffer.position((int)(((ADR)object2).position + (long)((ADR)object2).getSize()));
            vector = this.attributeEntries.get(object);
            for (n = 0; n < vector.size(); ++n) {
                aEDR = vector.get(n);
                aEDR.position = byteBuffer.position();
                if (n == 0) {
                    if (((ADR)object2).scope == 1) {
                        ((ADR)object2).setAgrEDRHead(aEDR.position);
                    } else {
                        ((ADR)object2).setAzEDRHead(aEDR.position);
                    }
                } else {
                    vector.get(n - 1).setAEDRNext(aEDR.position);
                }
                byteBuffer.position(byteBuffer.position() + aEDR.getSize());
            }
            if (bl2) {
                this.gdr.setADRHead(((ADR)object2).position);
                bl2 = false;
            } else if (object3 != null) {
                ((ADR)object3).setADRNext(((ADR)object2).position);
            }
            object3 = object2;
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = this.attributes.get(iterator.next());
            object = ((ADR)object2).name;
            byteBuffer.position((int)((ADR)object2).position);
            byteBuffer.put(((ADR)object2).get());
            vector = this.attributeEntries.get(object);
            for (n = 0; n < vector.size(); ++n) {
                aEDR = vector.get(n);
                byteBuffer.position((int)aEDR.position);
                byteBuffer.put(aEDR.get());
            }
        }
        object2 = this.dataContainers.keySet();
        object = object2.iterator();
        vector = byteBuffer;
        while (object.hasNext()) {
            DataContainer dataContainer = this.dataContainers.get(object.next());
            vector = dataContainer.update((ByteBuffer)((Object)vector));
        }
        byteBuffer.position((int)this.gdr.position);
        this.gdr.setEof(byteBuffer.limit());
        this.gdr.setNumAttr(this.attributes.size());
        this.gdr.setNzVars(this.dataContainers.size());
        byteBuffer.put(this.gdr.get());
        ByteBuffer byteBuffer2 = null;
        if (this.needDigest) {
            byteBuffer.position(0);
            byteBuffer2 = this.getDigest(byteBuffer);
        }
        if (byteBuffer2 != null) {
            ((ByteBuffer)((Object)vector)).put(byteBuffer2);
        }
        if (this.isWindows()) {
            this.writeWin(string, byteBuffer);
        } else {
            if (bl) {
                randomAccessFile = new RandomAccessFile(new File(string), "rw");
                fileChannel = randomAccessFile.getChannel();
                byteBuffer.position(0);
                fileChannel.write(byteBuffer);
            }
            fileChannel.force(true);
            randomAccessFile.close();
        }
        return true;
    }

    ByteBuffer getDigest(ByteBuffer byteBuffer) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        int n = byteBuffer.position();
        byte[] byArray = new byte[0x100000];
        while (byteBuffer.remaining() > 0) {
            int n2 = byteBuffer.remaining();
            if (n2 > byArray.length) {
                n2 = byArray.length;
            }
            byteBuffer.get(byArray, 0, n2);
            messageDigest.update(byArray, 0, n2);
        }
        byteBuffer.position(n);
        return ByteBuffer.wrap(messageDigest.digest());
    }

    void dispatch(String string, Object object) throws CDFException.WriterError {
        Class<?> clazz = object.getClass();
        if (clazz == String.class) {
            this.addData(string, new String[]{(String)object});
            return;
        }
        Number number = (Number)object;
        if (clazz == Byte.class) {
            this.addData(string, new byte[]{number.byteValue()});
            return;
        }
        if (clazz == Short.class) {
            this.addData(string, new short[]{number.shortValue()});
            return;
        }
        if (clazz == Integer.class) {
            this.addData(string, new int[]{number.intValue()});
            return;
        }
        if (clazz == Double.class) {
            this.addData(string, new double[]{number.doubleValue()});
            return;
        }
        if (clazz == Float.class) {
            this.addData(string, new float[]{number.floatValue()});
            return;
        }
        if (clazz == Long.class) {
            this.addData(string, new long[]{number.longValue()});
            return;
        }
        throw new CDFException.WriterError("Unrecognized type " + clazz);
    }

    public void setLastLeapSecondId(int n) {
        this.lastLeapSecondId = n;
    }

    void write(FileChannel fileChannel, long l) throws IOException {
        AEDR aEDR;
        int n;
        Vector<AEDR> vector;
        Object object;
        Object object2;
        this.cdr.setRowMajority(this.rowMajority);
        this.cdr.setMD5Needed(this.needDigest);
        fileChannel.write(this.cdr.get());
        this.gdr.position = fileChannel.position();
        fileChannel.position(this.gdr.position + (long)this.gdr.getSize());
        Set<String> set = this.attributes.keySet();
        Iterator<String> iterator = set.iterator();
        boolean bl = true;
        Object object3 = null;
        while (iterator.hasNext()) {
            object2 = this.attributes.get(iterator.next());
            object = ((ADR)object2).name;
            ((ADR)object2).position = fileChannel.position();
            fileChannel.position(((ADR)object2).position + (long)((ADR)object2).getSize());
            vector = this.attributeEntries.get(object);
            for (n = 0; n < vector.size(); ++n) {
                aEDR = vector.get(n);
                aEDR.position = fileChannel.position();
                if (n == 0) {
                    if (((ADR)object2).scope == 1) {
                        ((ADR)object2).setAgrEDRHead(aEDR.position);
                    } else {
                        ((ADR)object2).setAzEDRHead(aEDR.position);
                    }
                } else {
                    vector.get(n - 1).setAEDRNext(aEDR.position);
                }
                fileChannel.position(fileChannel.position() + (long)aEDR.getSize());
            }
            if (bl) {
                this.gdr.setADRHead(((ADR)object2).position);
                bl = false;
            } else if (object3 != null) {
                ((ADR)object3).setADRNext(((ADR)object2).position);
            }
            object3 = object2;
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = this.attributes.get(iterator.next());
            object = ((ADR)object2).name;
            fileChannel.position(((ADR)object2).position);
            fileChannel.write(((ADR)object2).get());
            vector = this.attributeEntries.get(object);
            for (n = 0; n < vector.size(); ++n) {
                aEDR = vector.get(n);
                fileChannel.position(aEDR.position);
                fileChannel.write(aEDR.get());
            }
        }
        object2 = this.dataContainers.keySet();
        object = object2.iterator();
        while (object.hasNext()) {
            vector = this.dataContainers.get(object.next());
            ((DataContainer)((Object)vector)).update(fileChannel);
        }
        fileChannel.position(this.gdr.position);
        this.gdr.setEof(fileChannel.size());
        this.gdr.setNumAttr(this.attributes.size());
        this.gdr.setNzVars(this.dataContainers.size());
        fileChannel.write(this.gdr.get());
        fileChannel.position(fileChannel.size());
        if (this.needDigest) {
            this.getDigest(fileChannel);
        }
    }

    void getDigest(FileChannel fileChannel) throws IOException {
        int n;
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        byte[] byArray = new byte[0x100000];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        fileChannel.position(0L);
        for (long i = fileChannel.size(); i > 0L; i -= (long)n) {
            long l = i;
            if (l > (long)byArray.length) {
                l = byArray.length;
            }
            byteBuffer.position(0);
            byteBuffer.limit((int)l);
            n = fileChannel.read(byteBuffer);
            if (n == -1) {
                throw new IOException("Unexpected end of data");
            }
            messageDigest.update(byArray, 0, n);
        }
        fileChannel.write(ByteBuffer.wrap(messageDigest.digest()));
    }

    void writeWin(String string, ByteBuffer byteBuffer) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        byte[] byArray = byteBuffer.array();
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("win");
    }
}

