/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class ByteBufferURLReader {
    InputStream is;
    boolean eof = false;
    public int total;
    public int len = -1;
    Chunk chunk = new Chunk();
    byte[] block = this.chunk.getBlock();
    FileChannel cacheFileChannel;
    ByteBuffer buffer;

    public ByteBufferURLReader(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        this.len = uRLConnection.getContentLength();
        if (this.len >= 0) {
            this.chunk.setLength(this.len);
        }
        this.is = uRLConnection.getInputStream();
        boolean bl = uRL.getPath().trim().endsWith(".gz");
        if (bl) {
            this.is = new GZIPInputStream(this.is);
        }
    }

    public ByteBufferURLReader(URL uRL, Chunk chunk) throws IOException {
        this(uRL);
        this.setChunk(chunk);
    }

    public ByteBufferURLReader(URL uRL, FileChannel fileChannel, Chunk chunk) throws IOException {
        this(uRL, chunk);
        this.cacheFileChannel = fileChannel;
        this.buffer = chunk.allocateBuffer();
    }

    public ByteBufferURLReader(URL uRL, FileChannel fileChannel) throws IOException {
        this(uRL);
        this.cacheFileChannel = fileChannel;
        this.buffer = this.chunk.allocateBuffer();
    }

    public void setChunk(Chunk chunk) {
        this.chunk = chunk;
        this.block = chunk.getBlock();
    }

    public ByteBuffer getBuffer() throws IOException {
        Vector<ByteBuffer> vector = new Vector<ByteBuffer>();
        while (!this.eof) {
            if (this.cacheFileChannel == null) {
                vector.add(this.read());
                continue;
            }
            this.transfer();
        }
        if (this.cacheFileChannel != null) {
            long l = this.cacheFileChannel.position();
            FileChannel.MapMode mapMode = FileChannel.MapMode.READ_ONLY;
            return this.cacheFileChannel.map(mapMode, 0L, l);
        }
        if (vector.size() == 1) {
            ByteBuffer byteBuffer = (ByteBuffer)vector.get(0);
            return byteBuffer.asReadOnlyBuffer();
        }
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            ByteBuffer byteBuffer = (ByteBuffer)vector.get(i);
            n += byteBuffer.remaining();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        for (int i = 0; i < vector.size(); ++i) {
            ByteBuffer byteBuffer2 = (ByteBuffer)vector.get(i);
            byteBuffer.put(byteBuffer2);
        }
        byteBuffer.position(0);
        return byteBuffer.asReadOnlyBuffer();
    }

    public ByteBuffer read() throws IOException {
        ByteBuffer byteBuffer = this.chunk.allocateBuffer();
        this._read(byteBuffer);
        return byteBuffer;
    }

    public void transfer() throws IOException {
        this._read(this.buffer);
        this.cacheFileChannel.write(this.buffer);
    }

    private void _read(ByteBuffer byteBuffer) throws IOException {
        int n = 0;
        byteBuffer.position(0);
        byteBuffer.limit(byteBuffer.capacity());
        if (byteBuffer.capacity() < 2 * this.block.length) {
            int n2;
            for (int i = 0; i < byteBuffer.capacity(); ++i) {
                n2 = this.is.read();
                if (n2 == -1) {
                    throw new IOException("Premature end of data");
                }
                byteBuffer.put((byte)n2);
            }
            n2 = this.is.read(this.block);
            if (n2 != -1) {
                throw new IOException("Unread data remains");
            }
            this.total = n = byteBuffer.capacity();
            this.eof = true;
        } else {
            int n3;
            while ((n3 = this.is.read(this.block)) != -1) {
                byteBuffer.put(this.block, 0, n3);
                this.total += n3;
                if (this.len == byteBuffer.capacity() || (n += n3) < this.chunk.chunkSize) continue;
            }
            if (n3 == -1) {
                this.eof = true;
            }
            if (this.eof && this.len >= 0 && this.total != this.len) {
                throw new IOException("Mismatched length " + this.total + " expected: " + this.len);
            }
            byteBuffer.limit(byteBuffer.position());
        }
        byteBuffer.position(0);
    }

    public boolean endOfFile() {
        return this.eof;
    }

    public static class Chunk {
        int chunkSize = 0x100000;
        int blockSize = 65536;
        int len = -1;

        public Chunk() {
        }

        public Chunk(int n, int n2) throws Throwable {
            if (n2 < n) {
                throw new Throwable("Chunk size must be >= block size");
            }
            this.blockSize = n;
            this.chunkSize = n2;
        }

        void setLength(int n) {
            this.len = n;
        }

        ByteBuffer allocateBuffer() {
            int n = this.chunkSize + this.blockSize;
            if (this.len < 0) {
                return ByteBuffer.allocateDirect(n);
            }
            if (this.len > n) {
                return ByteBuffer.allocateDirect(n);
            }
            return ByteBuffer.allocateDirect(this.len);
        }

        byte[] getBlock() {
            return new byte[this.blockSize];
        }
    }
}

