/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.ArrayAttribute;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public abstract class AArray {
    ArrayAttribute aa;
    Object o;
    int dim;
    boolean rowMajority = true;

    public AArray(Object object) throws Throwable {
        this(object, true);
    }

    public AArray(Object object, boolean bl) throws Throwable {
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new Throwable("AArray: Object " + object + " is not an array");
        }
        this.o = object;
        this.aa = new ArrayAttribute(object);
        this.dim = this.aa.getDimensions().length;
        this.rowMajority = bl;
    }

    public abstract Object array();

    public int[] getDimensions() {
        return this.aa.getDimensions();
    }

    ByteBuffer allocate(int n) {
        int n2 = n;
        int[] nArray = this.aa.getDimensions();
        for (int i = 0; i < nArray.length; ++i) {
            n2 *= nArray[i];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    public ByteBuffer buffer(int n) throws Throwable {
        if (this.aa.getType() == String.class) {
            return this.buffer(String.class, n);
        }
        return this.buffer();
    }

    public ByteBuffer buffer() throws Throwable {
        if (this.aa.getType() == String.class) {
            throw new Throwable("Invalid call for String type");
        }
        return this.buffer(this.aa.getType(), 0);
    }

    public ByteBuffer buffer(Class<?> clazz) throws Throwable {
        return this.buffer(clazz, 0);
    }

    public abstract ByteBuffer buffer(Class<?> var1, int var2) throws Throwable;

    public boolean validateDimensions(int[] nArray) {
        return Arrays.equals(nArray, this.aa.getDimensions());
    }

    public static Object getPoint(Object object) throws Throwable {
        ArrayAttribute arrayAttribute = new ArrayAttribute(object);
        int[] nArray = arrayAttribute.getDimensions();
        Object object2 = null;
        if (nArray.length == 1) {
            object2 = Array.newInstance(arrayAttribute.getType(), 1, nArray[0]);
        }
        if (nArray.length == 2) {
            object2 = Array.newInstance(arrayAttribute.getType(), 1, nArray[0], nArray[1]);
        }
        if (nArray.length == 3) {
            object2 = Array.newInstance(arrayAttribute.getType(), 1, nArray[0], nArray[1], nArray[2]);
        }
        if (nArray.length == 4) {
            object2 = Array.newInstance(arrayAttribute.getType(), 1, nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        if (object2 == null) {
            return null;
        }
        Array.set(object2, 0, object);
        return object2;
    }
}

