/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDF2Impl;
import gov.nasa.gsfc.spdf.cdfj.CDF3Impl;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.CDFUrl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.zip.GZIPInputStream;

public final class CDFFactory {
    public static final long CDF3_MAGIC = -3606538872298602497L;
    public static final long CDF3_COMPRESSED_MAGIC = -3606538868862746623L;
    public static final long CDF2_MAGIC = -3606820347275313153L;
    public static final long CDF2_MAGIC_DOT5 = 0xFFFF0000FFFFL;
    static Map cdfMap = Collections.synchronizedMap(new WeakHashMap());
    static Long maxMappedMemory;

    private CDFFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CDFImpl getCDF(byte[] byArray) throws Throwable {
        byte[] byArray2 = byArray;
        synchronized (byArray) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
            byteBuffer.put(byArray);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            byteBuffer.flip();
            return CDFFactory.getVersion(byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CDFImpl getCDF(ByteBuffer byteBuffer) throws Throwable {
        ByteBuffer byteBuffer2;
        ByteBuffer byteBuffer3 = byteBuffer;
        synchronized (byteBuffer3) {
            ByteBuffer byteBuffer4 = ByteBuffer.allocateDirect(byteBuffer.remaining());
            byteBuffer4.put(byteBuffer);
            byteBuffer4.position(0);
            byteBuffer2 = byteBuffer4.asReadOnlyBuffer();
            byteBuffer2.order(byteBuffer.order());
        }
        return CDFFactory.getVersion(byteBuffer2);
    }

    static CDFImpl getVersion(ByteBuffer byteBuffer) throws Throwable {
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        long l = longBuffer.get();
        if (l == -3606538872298602497L) {
            return new CDF3Impl(byteBuffer);
        }
        if (l == -3606538868862746623L) {
            ByteBuffer byteBuffer2 = CDFFactory.uncompressed(byteBuffer, 3);
            return new CDF3Impl(byteBuffer2);
        }
        if (l == 0xFFFF0000FFFFL) {
            int n = byteBuffer.getInt(24);
            return new CDF2Impl(byteBuffer, n);
        }
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        if (shortBuffer.get() == -12814 && shortBuffer.get() == 24578) {
            short s = shortBuffer.get();
            if (s == 0) {
                if (shortBuffer.get() == -1) {
                    return new CDF2Impl(byteBuffer, 6);
                }
            } else if (s == -13108 && shortBuffer.get() == 1) {
                ByteBuffer byteBuffer3 = CDFFactory.uncompressed(byteBuffer, 2);
                return new CDF2Impl(byteBuffer3, 6);
            }
        }
        return null;
    }

    public static CDFImpl getCDF(String string) throws Throwable {
        return CDFFactory.getCDF(string, false);
    }

    static CDFImpl getCDF(String string, final boolean bl) throws Throwable {
        CDFFactory.clean();
        File file = new File(string);
        final String string2 = file.getPath();
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        fileInputStream.close();
        CDFImpl cDFImpl = CDFFactory.getVersion(mappedByteBuffer);
        cDFImpl.setOption(new ProcessingOption(){

            public String missingRecordOption() {
                if (bl) {
                    return "accept";
                }
                return "reject";
            }
        });
        cDFImpl.setSource(new CDFSource(){

            @Override
            public String getName() {
                return string2;
            }

            @Override
            public boolean isFile() {
                return true;
            }
        });
        cdfMap.put(cDFImpl, string2);
        return cDFImpl;
    }

    static CDFImpl getCDF(URL uRL) throws Throwable {
        int n;
        int n2;
        final String string = uRL.toString();
        URLConnection uRLConnection = new CDFUrl(uRL).openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (n2 = uRLConnection.getContentLength(); n2 > 0; n2 -= n) {
            n = inputStream.read(byArray, n3, n2);
            n3 += n;
        }
        CDFImpl cDFImpl = CDFFactory.getCDF(byArray);
        cDFImpl.setSource(new CDFSource(){

            @Override
            public String getName() {
                return string;
            }

            @Override
            public boolean isFile() {
                return false;
            }
        });
        return cDFImpl;
    }

    static ByteBuffer uncompressed(ByteBuffer byteBuffer, int n) {
        int n2;
        byte[] byArray;
        int n3 = 28;
        if (n == 3) {
            n3 = 40;
        }
        int n4 = byteBuffer.getInt(8) - 20;
        if (n == 3) {
            n4 = (int)(byteBuffer.getLong(8) - 32L);
        }
        int n5 = byteBuffer.getInt(20);
        if (n == 3) {
            n5 = (int)byteBuffer.getLong(28);
        }
        byte[] byArray2 = new byte[n5 + 8];
        byteBuffer.get(byArray2, 0, 8);
        if (!byteBuffer.hasArray()) {
            byArray = new byte[n4];
            byteBuffer.position(n3);
            byteBuffer.get(byArray);
            n2 = 0;
        } else {
            byArray = byteBuffer.array();
            n2 = n3;
        }
        int n6 = 0;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n2, n4);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            int n7 = 8;
            for (int i = byArray2.length - 8; i > 0 && (n6 = gZIPInputStream.read(byArray2, n7, i)) != -1; i -= n6) {
                n7 += n6;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            return null;
        }
        if (n6 < 0) {
            return null;
        }
        return ByteBuffer.wrap(byArray2);
    }

    private static long mappedMemoryUsed() {
        if (cdfMap.size() == 0) {
            return 0L;
        }
        Set set = cdfMap.keySet();
        Iterator iterator = set.iterator();
        long l = 0L;
        while (iterator.hasNext()) {
            l += (long)((CDFImpl)iterator.next()).getBuffer().limit();
        }
        return l;
    }

    public static void setMaxMappedMemory(long l) {
        if (maxMappedMemory != null && maxMappedMemory > l) {
            return;
        }
        maxMappedMemory = new Long(l);
    }

    public static void clean() {
        if (maxMappedMemory != null && CDFFactory.mappedMemoryUsed() > maxMappedMemory) {
            System.gc();
        }
    }

    public static class CDFSource {
        public String getName() {
            return "";
        }

        public boolean isFile() {
            return false;
        }

        public boolean isURL() {
            return false;
        }

        public boolean isByteArray() {
            return false;
        }

        public boolean isByteBuffer() {
            return false;
        }
    }

    public static class ProcessingOption {
        String missingRecordsOption() {
            return "reject";
        }
    }
}

