/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.Extractor;
import gov.nasa.gsfc.spdf.cdfj.MetaData;
import gov.nasa.gsfc.spdf.cdfj.Stride;
import gov.nasa.gsfc.spdf.cdfj.TimeInstantModel;
import gov.nasa.gsfc.spdf.cdfj.TimeSeries;
import gov.nasa.gsfc.spdf.cdfj.TimeSeriesX;
import gov.nasa.gsfc.spdf.cdfj.TimeUtil;
import gov.nasa.gsfc.spdf.cdfj.TimeVariableFactory;
import gov.nasa.gsfc.spdf.cdfj.TimeVariableX;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.TimeZone;

public class TSExtractor
extends Extractor {
    static Calendar cal;

    public static double[][] getTimeSeries0(MetaData metaData, Variable variable, Boolean bl, double[] dArray) throws Throwable {
        return TSExtractor.getTimeSeries(metaData, variable, null, bl, dArray);
    }

    public static double[][] getTimeSeries1(MetaData metaData, Variable variable, Integer n, Boolean bl, double[] dArray) throws Throwable {
        return TSExtractor.getTimeSeries(metaData, variable, n, bl, dArray);
    }

    public static double[][] getTimeSeries(MetaData metaData, Variable variable, Integer n, Boolean bl, double[] dArray) throws Throwable {
        double[] dArray2;
        Object object;
        Number number;
        int n2;
        if (variable.getNumberOfValues() == 0) {
            return null;
        }
        boolean bl2 = bl;
        int[] nArray = null;
        TimeVariableFactory.CDFTimeVariable cDFTimeVariable = TimeVariableFactory.getTimeVariable(metaData, variable.getName());
        double[] dArray3 = cDFTimeVariable.getTimes();
        if (dArray3 == null) {
            return null;
        }
        boolean bl3 = false;
        int n3 = variable.getType();
        int n4 = n2 = n == null ? 0 : n;
        if (DataTypes.typeCategory[n3] == 5) {
            bl3 = true;
            number = new Long(((long[])TSExtractor.getPadValue(metaData.thisCDF, variable))[n2]);
        } else {
            number = new Double(((double[])TSExtractor.getPadValue(metaData.thisCDF, variable))[n2]);
        }
        Object object2 = null;
        Object[] objectArray = null;
        if (dArray == null) {
            Object object3 = object2 = n == null ? Extractor.getSeries0(metaData.thisCDF, variable) : Extractor.getElement1(metaData.thisCDF, variable, n);
            if (variable.isMissingRecords()) {
                object = variable.getLocator().getLocations();
                objectArray = TSExtractor.filterPad(object2, dArray3, number, (long[][])object, 0);
            } else {
                objectArray = new Object[]{dArray3, (double[])object2};
            }
        } else {
            nArray = TSExtractor.getRecordRange(metaData, variable, dArray);
            if (nArray == null) {
                return null;
            }
            object2 = n == null ? TSExtractor.getRange0(metaData.thisCDF, variable, new Integer(nArray[0]), new Integer(nArray[1])) : TSExtractor.getRangeForElement1(metaData.thisCDF, variable, new Integer(nArray[0]), new Integer(nArray[1]), n);
            dArray2 = new double[Array.getLength(object2)];
            int n5 = nArray[0];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray2[i] = dArray3[n5++];
            }
            if (variable.isMissingRecords()) {
                long[][] lArray = variable.getLocator().getLocations();
                objectArray = TSExtractor.filterPad(object2, dArray2, number, lArray, nArray[0]);
            } else {
                objectArray = new Object[]{dArray2, (double[])object2};
            }
        }
        dArray2 = (double[])objectArray[0];
        if (!bl2) {
            double[] dArray4 = TSExtractor.castToDouble(objectArray[1], bl3);
            return new double[][]{dArray2, dArray4};
        }
        object = Extractor.getFillValue(metaData.thisCDF, variable);
        boolean bl4 = true;
        Number number2 = null;
        if (object.getClass().getComponentType() == Double.TYPE) {
            boolean bl5 = bl4 = ((double[])object)[0] == 0.0;
            if (bl4) {
                number2 = new Double(((double[])object)[1]);
            }
        } else {
            boolean bl6 = bl4 = ((long[])object)[0] == 0L;
            if (bl4) {
                number2 = new Long(((long[])object)[1]);
            }
        }
        if (!bl4) {
            double[] dArray5 = TSExtractor.castToDouble(objectArray[1], bl3);
            return new double[][]{dArray2, dArray5};
        }
        return TSExtractor.filterFill(dArray2, objectArray[1], number2);
    }

    static int[] getRecordRange(MetaData metaData, Variable variable, double[] dArray) {
        return TSExtractor.getRecordRange(metaData, variable, dArray, null);
    }

    static int[] getRecordRange(MetaData metaData, Variable variable, double[] dArray, TimeInstantModel timeInstantModel) {
        try {
            TimeVariableFactory.CDFTimeVariable cDFTimeVariable = TimeVariableFactory.getTimeVariable(metaData, variable.getName());
            return cDFTimeVariable.getRecordRange(dArray);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static double[][] filterFill(double[] dArray, double[] dArray2, double d, int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < dArray2.length; ++n2) {
            if (dArray2[n2] == d) continue;
            ++n3;
        }
        double[][] dArray3 = new double[2][n3];
        n2 = 0;
        for (int i = 0; i < dArray2.length; ++i) {
            if (dArray2[i] == d) continue;
            dArray3[0][n2] = dArray[i + n];
            dArray3[1][n2] = dArray2[i];
            ++n2;
        }
        return dArray3;
    }

    public static double[][] filterFill(double[] dArray, Object object, Number number) {
        double[][] dArray2;
        int n = 0;
        if (object.getClass().getComponentType() == Long.TYPE) {
            int n2;
            long l = number.longValue();
            long[] lArray = (long[])object;
            for (n2 = 0; n2 < lArray.length; ++n2) {
                if (lArray[n2] == l) continue;
                ++n;
            }
            dArray2 = new double[2][n];
            n2 = 0;
            for (int i = 0; i < lArray.length; ++i) {
                if (lArray[i] == l) continue;
                dArray2[0][n2] = dArray[i];
                dArray2[1][n2] = lArray[i];
                ++n2;
            }
        } else {
            int n3;
            if (object.getClass().getComponentType() != Double.TYPE) {
                return null;
            }
            double d = number.doubleValue();
            double[] dArray3 = (double[])object;
            for (n3 = 0; n3 < dArray3.length; ++n3) {
                if (dArray3[n3] == d) continue;
                ++n;
            }
            dArray2 = new double[2][n];
            n3 = 0;
            for (int i = 0; i < dArray3.length; ++i) {
                if (dArray3[i] == d) continue;
                dArray2[0][n3] = dArray[i];
                dArray2[1][n3] = dArray3[i];
                ++n3;
            }
        }
        return dArray2;
    }

    static Object[] filterPad(Object object, double[] dArray, Number number, long[][] lArray, int n) {
        RecordSensor recordSensor = new RecordSensor(lArray);
        if (object.getClass().getComponentType() == Double.TYPE) {
            double d = number.doubleValue();
            double[] dArray2 = (double[])object;
            int n2 = 0;
            for (int i = 0; i < dArray2.length; ++i) {
                if (recordSensor.hasRecord(n + i) || dArray2[i] != d) continue;
                ++n2;
            }
            if (n2 == 0) {
                return new Object[]{dArray, dArray2};
            }
            double[] dArray3 = new double[dArray2.length - n2];
            double[] dArray4 = new double[dArray2.length - n2];
            int n3 = 0;
            for (int i = 0; i < dArray2.length; ++i) {
                if (!recordSensor.hasRecord(n + i) && dArray2[i] == d) continue;
                dArray3[n3] = dArray2[i];
                dArray4[n3] = dArray[i];
                ++n3;
            }
            return new Object[]{dArray4, dArray3};
        }
        if (object.getClass().getComponentType() != Long.TYPE) {
            return null;
        }
        long l = number.longValue();
        long[] lArray2 = (long[])object;
        int n4 = 0;
        for (int i = 0; i < lArray2.length; ++i) {
            if (recordSensor.hasRecord(n + i) || lArray2[i] != l) continue;
            ++n4;
        }
        if (n4 == 0) {
            return new Object[]{dArray, lArray2};
        }
        long[] lArray3 = new long[lArray2.length - n4];
        double[] dArray5 = new double[lArray2.length - n4];
        int n5 = 0;
        for (int i = 0; i < lArray2.length; ++i) {
            if (!recordSensor.hasRecord(n + i) && lArray2[i] == l) continue;
            lArray3[n5] = lArray2[i];
            dArray5[n5] = dArray[i];
            ++n5;
        }
        return new Object[]{dArray5, lArray3};
    }

    public static double[][] getSampledTimeSeries0(MetaData metaData, Variable variable, Boolean bl, double[] dArray, int[] nArray) throws Throwable {
        return TSExtractor.getSampledTimeSeries(metaData, variable, null, bl, dArray, nArray);
    }

    public static double[][] getSampledTimeSeries1(MetaData metaData, Variable variable, Integer n, Boolean bl, double[] dArray, int[] nArray) throws Throwable {
        return TSExtractor.getSampledTimeSeries(metaData, variable, n, bl, dArray, nArray);
    }

    public static double[][] getSampledTimeSeries(MetaData metaData, Variable variable, Integer n, Boolean bl, double[] dArray, int[] nArray) throws Throwable {
        double[] dArray2;
        if (variable.getNumberOfValues() == 0) {
            return null;
        }
        boolean bl2 = bl;
        int[] nArray2 = null;
        TimeVariableFactory.CDFTimeVariable cDFTimeVariable = TimeVariableFactory.getTimeVariable(metaData, variable.getName());
        double[] dArray3 = cDFTimeVariable.getTimes();
        if (dArray3 == null) {
            return null;
        }
        Stride stride = new Stride(nArray);
        if (dArray == null) {
            dArray2 = n == null ? (double[])TSExtractor.getSeries0(metaData.thisCDF, variable, stride) : TSExtractor.getElement1(metaData.thisCDF, variable, n, stride);
        } else {
            nArray2 = TSExtractor.getRecordRange(metaData, variable, dArray);
            if (nArray2 == null) {
                return null;
            }
            dArray2 = n == null ? (double[])TSExtractor.getRange0(metaData.thisCDF, variable, new Integer(nArray2[0]), new Integer(nArray2[1]), stride) : (double[])TSExtractor.getRangeForElement1(metaData.thisCDF, variable, new Integer(nArray2[0]), new Integer(nArray2[1]), n, stride);
        }
        int n2 = stride.getStride();
        double[] dArray4 = (double[])TSExtractor.getFillValue(metaData.thisCDF, variable);
        if (!bl2 || dArray4[0] != 0.0) {
            if (dArray == null) {
                if (n2 == 1) {
                    return new double[][]{dArray3, dArray2};
                }
                double[] dArray5 = new double[dArray2.length];
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray5[i] = dArray3[i * n2];
                }
                return new double[][]{dArray5, dArray2};
            }
            double[] dArray6 = new double[dArray2.length];
            if (n2 == 1) {
                System.arraycopy(dArray3, nArray2[0], dArray6, 0, dArray2.length);
                return new double[][]{dArray6, dArray2};
            }
            int n3 = nArray2[0];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray6[i] = dArray3[n3 + i * n2];
            }
            return new double[][]{dArray6, dArray2};
        }
        if (dArray == null) {
            if (n2 == 1) {
                return TSExtractor.filterFill(dArray3, dArray2, dArray4[1], 0);
            }
            double[] dArray7 = new double[dArray2.length];
            for (int i = 0; i < dArray2.length; ++i) {
                dArray7[i] = dArray3[i * n2];
            }
            return TSExtractor.filterFill(dArray7, dArray2, dArray4[1], 0);
        }
        double[] dArray8 = new double[dArray2.length];
        if (n2 == 1) {
            System.arraycopy(dArray3, nArray2[0], dArray8, 0, dArray2.length);
            return TSExtractor.filterFill(dArray8, dArray2, dArray4[1], 0);
        }
        int n4 = nArray2[0];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray8[i] = dArray3[n4 + i * n2];
        }
        return TSExtractor.filterFill(dArray8, dArray2, dArray4[1], 0);
    }

    public static TimeSeries getTimeSeriesObject0(MetaData metaData, Variable variable, Boolean bl, double[] dArray, TimeInstantModel timeInstantModel) throws Throwable {
        return new GeneralTimeSeries(metaData, variable, null, bl, dArray, timeInstantModel);
    }

    public static TimeSeries getTimeSeriesObject1(MetaData metaData, Variable variable, Integer n, Boolean bl, double[] dArray, TimeInstantModel timeInstantModel) throws Throwable {
        return new GeneralTimeSeries(metaData, variable, n, bl, dArray, timeInstantModel);
    }

    public static String identifier() {
        return "TSExtractor";
    }

    public static Method getMethod(Variable variable, String string, int n) throws Throwable {
        return TSExtractor.getMethod(variable, string, n, false);
    }

    static Method getMethod(Variable variable, String string, int n, boolean bl) throws Throwable {
        if (variable == null) {
            throw new Throwable("Internal error. Null variable encountered in call to TSExtractor.getMethod()");
        }
        int n2 = variable.getEffectiveRank();
        if (n2 != n) {
            throw new Throwable("Called method is not appropriate for variables of effective rank " + n2);
        }
        if (bl && variable.isMissingRecords()) {
            System.out.println("Variable " + variable.getName() + " has gaps." + " Sampled time series code is being tested. Feature is not " + " currently available if the variable has gaps.");
            return null;
        }
        Method method = TSExtractor.getMethod(variable, string);
        if (method == null) {
            throw new Throwable("get" + string + " not " + "implemented for " + variable.getName());
        }
        return method;
    }

    public static long getTime(int[] nArray) {
        int n;
        int[] nArray2 = new int[6];
        for (n = 0; n < 3; ++n) {
            nArray2[n] = nArray[n];
        }
        nArray2[1] = nArray2[1] - 1;
        for (n = 3; n < 6; ++n) {
            nArray2[n] = 0;
        }
        n = nArray.length;
        if (n >= 4) {
            nArray2[3] = nArray[3];
            if (n >= 5) {
                nArray2[4] = nArray[4];
                if (n >= 6) {
                    nArray2[5] = nArray[5];
                }
            }
        }
        cal.clear();
        cal.set(nArray2[0], nArray2[1], nArray2[2], nArray2[3], nArray2[4], nArray2[5]);
        cal.set(14, n > 6 ? nArray[6] : 0);
        return cal.getTimeInMillis();
    }

    public static double getTime(MetaData metaData, String string, int[] nArray) throws Throwable {
        boolean bl = TimeVariableFactory.getTimeVariable(metaData, string).isTT2000();
        long l = TSExtractor.getTime(nArray);
        return bl ? TimeUtil.milliSecondSince1970(l) : (double)l;
    }

    public static double[] getOverlap(MetaData metaData, double[] dArray, String string, int[] nArray, int[] nArray2) throws Throwable {
        double d;
        double[] dArray2 = new double[]{Double.MIN_VALUE, Double.MAX_VALUE};
        if (nArray != null) {
            if (nArray.length < 3) {
                throw new Throwable("incomplete start time definition.");
            }
            d = TSExtractor.getTime(metaData, string, nArray);
            if (d > dArray[1]) {
                throw new Throwable("Start time is beyond end of data");
            }
            dArray2[0] = d < dArray[0] ? dArray[0] : d;
        } else {
            dArray2[0] = dArray[0];
        }
        if (nArray2 != null) {
            if (nArray2.length < 3) {
                throw new Throwable("incomplete stop time definition.");
            }
            d = TSExtractor.getTime(metaData, string, nArray2);
            if (d < dArray[0]) {
                throw new Throwable("Stop time is before start of data");
            }
            if (d < dArray2[0]) {
                throw new Throwable("Stop time is before start time");
            }
            dArray2[1] = d;
        } else {
            dArray2[1] = dArray[1];
        }
        return dArray2;
    }

    static {
        try {
            Class<?> clazz = Class.forName("gov.nasa.gsfc.spdf.cdfj.Variable");
            Class<?> clazz2 = Class.forName("gov.nasa.gsfc.spdf.cdfj.MetaData");
            Class<?> clazz3 = Class.forName("gov.nasa.gsfc.spdf.cdfj.TSExtractor");
            Class<?> clazz4 = Class.forName("gov.nasa.gsfc.spdf.cdfj.TimeInstantModel");
            double[] dArray = new double[]{};
            int[] nArray = new int[]{};
            Class[][] classArray = new Class[][]{{clazz2, clazz, Boolean.class, dArray.getClass()}, {clazz2, clazz, Integer.class, Boolean.class, dArray.getClass()}, null, null};
            TSExtractor.addFunction("TimeSeries", clazz3, classArray);
            classArray = new Class[][]{{clazz2, clazz, Boolean.class, dArray.getClass(), nArray.getClass()}, {clazz2, clazz, Integer.class, Boolean.class, dArray.getClass(), nArray.getClass()}, null, null};
            TSExtractor.addFunction("SampledTimeSeries", clazz3, classArray);
            classArray = new Class[][]{{clazz2, clazz, Boolean.class, dArray.getClass(), clazz4}, {clazz2, clazz, Integer.class, Boolean.class, dArray.getClass(), clazz4}, null, null};
            TSExtractor.addFunction("TimeSeriesObject", clazz3, classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }

    static class RecordSensor {
        long[][] locations;
        int last = 0;

        RecordSensor(long[][] lArray) {
            this.locations = lArray;
        }

        boolean hasRecord(int n) {
            for (int i = this.last; i < this.locations.length; ++i) {
                if ((long)n < this.locations[i][0] || (long)n > this.locations[i][1]) continue;
                this.last = i;
                return true;
            }
            return false;
        }
    }

    public static class GeneralTimeSeriesX
    implements TimeSeriesX {
        final TimeInstantModel tspec;
        final TimeVariableX tv;
        final String vname;
        final CDFImpl thisCDF;
        final double[] timeRange;
        final boolean oned;
        final boolean columnMajor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GeneralTimeSeriesX(MetaData metaData, Variable variable, Boolean bl, double[] dArray, TimeInstantModel timeInstantModel, boolean bl2, boolean bl3) throws Throwable {
            boolean bl4 = bl;
            if (timeInstantModel != null) {
                TimeInstantModel timeInstantModel2 = timeInstantModel;
                synchronized (timeInstantModel2) {
                    this.tspec = (TimeInstantModel)timeInstantModel.clone();
                }
            } else {
                this.tspec = null;
            }
            this.vname = variable.getName();
            this.tv = TimeVariableFactory.getTimeVariable(metaData, this.vname);
            this.thisCDF = metaData.thisCDF;
            this.timeRange = dArray;
            this.oned = bl2;
            this.columnMajor = bl3;
        }

        @Override
        public double[] getTimes() throws CDFException.ReaderError {
            try {
                if (this.timeRange == null) {
                    return this.tv.getTimes(this.tspec);
                }
                return this.tv.getTimes(this.timeRange, this.tspec);
            }
            catch (Throwable throwable) {
                throw new CDFException.ReaderError(throwable.getMessage());
            }
        }

        @Override
        public Object getValues() throws CDFException.ReaderError {
            try {
                if (this.timeRange == null) {
                    return this.oned ? (Object)this.thisCDF.getOneD(this.vname, this.columnMajor) : this.thisCDF.get(this.vname);
                }
                int[] nArray = this.tv.getRecordRange(this.timeRange);
                if (nArray == null) {
                    throw new CDFException.ReaderError("no data");
                }
                if (!this.oned) {
                    return this.thisCDF.getRange(this.vname, nArray[0], nArray[1]);
                }
                return this.thisCDF.getRangeOneD(this.vname, nArray[0], nArray[1], this.columnMajor);
            }
            catch (Throwable throwable) {
                throw new CDFException.ReaderError(throwable.getMessage());
            }
        }

        @Override
        public TimeInstantModel getTimeInstantModel() {
            return this.tspec;
        }

        @Override
        public boolean isOneD() {
            return this.oned;
        }

        @Override
        public boolean isColumnMajor() {
            return this.columnMajor;
        }
    }

    public static class GeneralTimeSeries
    implements TimeSeries {
        double[] vdata;
        double[] times;
        TimeInstantModel tspec;
        double[][] filtered = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GeneralTimeSeries(MetaData metaData, Variable variable, Integer n, Boolean bl, double[] dArray, TimeInstantModel timeInstantModel) throws Throwable {
            Object object;
            boolean bl2 = bl;
            int[] nArray = null;
            if (timeInstantModel != null) {
                object = timeInstantModel;
                synchronized (object) {
                    this.tspec = (TimeInstantModel)timeInstantModel.clone();
                }
            }
            object = TimeVariableFactory.getTimeVariable(metaData, variable.getName());
            this.times = object.getTimes(this.tspec);
            if (this.times == null) {
                throw new Throwable("times not available for " + variable.getName());
            }
            boolean bl3 = false;
            int n2 = variable.getType();
            if (DataTypes.typeCategory[n2] == 5) {
                bl3 = true;
            }
            Object object2 = null;
            if (dArray == null) {
                object2 = n == null ? Extractor.getSeries0(metaData.thisCDF, variable) : Extractor.getElement1(metaData.thisCDF, variable, n);
            } else {
                nArray = TSExtractor.getRecordRange(metaData, variable, dArray, timeInstantModel);
                if (nArray == null) {
                    throw new Throwable("no record range");
                }
                object2 = n == null ? Extractor.getRange0(metaData.thisCDF, variable, new Integer(nArray[0]), new Integer(nArray[1])) : Extractor.getRangeForElement1(metaData.thisCDF, variable, new Integer(nArray[0]), new Integer(nArray[1]), n);
            }
            this.vdata = Extractor.castToDouble(object2, bl3);
            if (!bl2) {
                if (dArray != null) {
                    double[] dArray2 = new double[this.vdata.length];
                    System.arraycopy(this.times, nArray[0], dArray2, 0, this.vdata.length);
                    this.times = dArray2;
                }
            } else {
                int n3;
                double[] dArray3 = (double[])Extractor.getFillValue(metaData.thisCDF, variable);
                int n4 = n3 = dArray != null ? nArray[0] : 0;
                if (dArray3[0] != 0.0) {
                    double[] dArray4 = new double[this.vdata.length];
                    System.arraycopy(this.times, n3, dArray4, 0, this.vdata.length);
                    this.times = dArray4;
                } else {
                    this.filtered = TSExtractor.filterFill(this.times, this.vdata, dArray3[1], n3);
                }
            }
        }

        @Override
        public double[] getTimes() {
            return this.filtered != null ? this.filtered[0] : this.times;
        }

        public double[] getValues() {
            return this.filtered != null ? this.filtered[1] : this.vdata;
        }

        @Override
        public TimeInstantModel getTimeInstantModel() {
            return this.tspec;
        }
    }
}

