/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.BaseVarContainer;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.IntArray;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public final class IntVarContainer
extends BaseVarContainer
implements VDataContainer.CInt {
    final int[] ipad;

    public IntVarContainer(CDFImpl cDFImpl, Variable variable, int[] nArray, boolean bl, ByteOrder byteOrder) throws IllegalAccessException, InvocationTargetException, Throwable {
        super(cDFImpl, variable, nArray, bl, byteOrder, Integer.TYPE);
        Object object = this.thisCDF.getPadValue(variable);
        double[] dArray = (double[])object;
        this.ipad = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.ipad[i] = (int)dArray[i];
        }
    }

    public IntVarContainer(CDFImpl cDFImpl, Variable variable, int[] nArray, boolean bl) throws IllegalAccessException, InvocationTargetException, Throwable {
        this(cDFImpl, variable, nArray, bl, ByteOrder.nativeOrder());
    }

    @Override
    ByteBuffer allocateBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4 * n);
        byteBuffer.order(this.order);
        return byteBuffer;
    }

    @Override
    public Object allocateDataArray(int n) {
        return new int[n];
    }

    @Override
    void doMissing(int n, ByteBuffer byteBuffer, Object object, int n2) {
        int n3;
        int[] nArray = (int[])object;
        int[] nArray2 = null;
        try {
            nArray2 = n2 < 0 ? this.ipad : this.var.asIntArray(new int[]{n2});
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println("Should not see this.");
        }
        int n4 = byteBuffer.position();
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        for (int i = n; i > 0; i -= n3) {
            n3 = i;
            if (n3 * this.elements > nArray.length) {
                n3 = nArray.length / this.elements;
            }
            int n5 = 0;
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < this.elements; ++k) {
                    nArray[n5++] = nArray2[k];
                }
            }
            intBuffer.put(nArray, 0, n3 * this.elements);
            n4 += 4 * n3 * this.elements;
        }
        byteBuffer.position(n4);
    }

    @Override
    void doData(ByteBuffer byteBuffer, int n, int n2, int n3, ByteBuffer byteBuffer2, Object object) throws Throwable {
        int[] nArray = (int[])object;
        int n4 = byteBuffer2.position();
        IntBuffer intBuffer = byteBuffer2.asIntBuffer();
        switch (DataTypes.typeCategory[n]) {
            case 2: {
                int n5;
                if (n == 1 || n == 41) {
                    int n6;
                    for (n5 = 0; n5 < n3; n5 += n6 / n2) {
                        n6 = (n3 - n5) * n2;
                        if (n6 > nArray.length) {
                            n6 = nArray.length;
                        }
                        for (int i = 0; i < n6; ++i) {
                            nArray[i] = byteBuffer.get();
                        }
                        intBuffer.put(nArray, 0, n6);
                        n4 += 4 * n6;
                    }
                    byteBuffer2.position(n4);
                    break;
                }
                if (n == 2) {
                    int n7 = byteBuffer.position();
                    ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                    while (n5 < n3) {
                        int n8 = (n3 - n5) * n2;
                        if (n8 > nArray.length) {
                            n8 = nArray.length;
                        }
                        for (int i = 0; i < n8; ++i) {
                            nArray[i] = shortBuffer.get();
                        }
                        n7 += 2 * n8;
                        intBuffer.put(nArray, 0, n8);
                        n4 += 4 * n8;
                        n5 += n8 / n2;
                    }
                    byteBuffer.position(n7);
                    byteBuffer2.position(n4);
                    break;
                }
                if (n == 4) {
                    int n9 = byteBuffer.position();
                    IntBuffer intBuffer2 = byteBuffer.asIntBuffer();
                    while (n5 < n3) {
                        int n10 = (n3 - n5) * n2;
                        if (n10 > nArray.length) {
                            n10 = nArray.length;
                        }
                        intBuffer2.get(nArray, 0, n10);
                        n9 += 4 * n10;
                        intBuffer.put(nArray, 0, n10);
                        n4 += 4 * n10;
                        n5 += n10 / n2;
                    }
                    byteBuffer.position(n9);
                    byteBuffer2.position(n4);
                    break;
                }
            }
            case 3: {
                int n5;
                if (n == 11) {
                    while (n5 < n3) {
                        int n11 = (n3 - n5) * n2;
                        if (n11 > nArray.length) {
                            n11 = nArray.length;
                        }
                        for (int i = 0; i < n11; ++i) {
                            int n12 = byteBuffer.get();
                            nArray[i] = n12 < 0 ? n12 + 256 : n12;
                        }
                        intBuffer.put(nArray, 0, n11);
                        n4 += 4 * n11;
                        n5 += n11 / n2;
                    }
                    byteBuffer2.position(n4);
                    break;
                }
                if (n == 12) {
                    int n13 = byteBuffer.position();
                    ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
                    while (n5 < n3) {
                        int n14 = (n3 - n5) * n2;
                        if (n14 > nArray.length) {
                            n14 = nArray.length;
                        }
                        for (int i = 0; i < n14; ++i) {
                            int n15 = shortBuffer.get();
                            nArray[i] = n15 < 0 ? n15 + 65536 : n15;
                        }
                        n13 += 2 * n14;
                        intBuffer.put(nArray, 0, n14);
                        n4 += 4 * n14;
                        n5 += n14 / n2;
                    }
                    byteBuffer.position(n13);
                    byteBuffer2.position(n4);
                    break;
                }
                if (n == 14) {
                    int n16 = byteBuffer.position();
                    IntBuffer intBuffer3 = byteBuffer.asIntBuffer();
                    while (n5 < n3) {
                        int n17 = (n3 - n5) * n2;
                        if (n17 > nArray.length) {
                            n17 = nArray.length;
                        }
                        intBuffer3.get(nArray, 0, n17);
                        n16 += 4 * n17;
                        intBuffer.put(nArray, 0, n17);
                        n4 += 4 * n17;
                        n5 += n17 / n2;
                    }
                    byteBuffer.position(n16);
                    byteBuffer2.position(n4);
                    break;
                }
            }
            default: {
                throw new Throwable("Unrecognized type " + n);
            }
        }
    }

    public static boolean isCompatible(int n, boolean bl) {
        return IntVarContainer.isCompatible(n, bl, Integer.TYPE);
    }

    public Object _asArray() throws Throwable {
        int n = this.var.getEffectiveRank();
        if (n > 4) {
            throw new Throwable("Rank > 4 not supported yet.");
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            return null;
        }
        int n2 = byteBuffer.remaining() / 4;
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        int n3 = -1;
        switch (n) {
            case 0: {
                Object object;
                int[] nArray = new int[n2];
                intBuffer.get(nArray);
                if (this.singlePoint) {
                    Integer n4;
                    object = n4;
                    n4 = new Integer(nArray[0]);
                } else {
                    object = nArray;
                }
                return object;
            }
            case 1: {
                int n5 = (Integer)this.var.getElementCount().elementAt(0);
                n3 = n2 / n5;
                int[][] nArray = new int[n3][n5];
                for (int i = 0; i < n3; ++i) {
                    intBuffer.get(nArray[i]);
                }
                return this.singlePoint ? (Object)nArray[0] : nArray;
            }
            case 2: {
                int n6 = (Integer)this.var.getElementCount().elementAt(0);
                int n7 = (Integer)this.var.getElementCount().elementAt(1);
                n3 = n2 / (n6 * n7);
                int[][][] nArray = new int[n3][n6][n7];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n6; ++j) {
                            intBuffer.get(nArray[i][j]);
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n7; ++j) {
                            for (int k = 0; k < n6; ++k) {
                                nArray[i][k][j] = intBuffer.get();
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)nArray[0] : nArray;
            }
            case 3: {
                int n8 = (Integer)this.var.getElementCount().elementAt(0);
                int n9 = (Integer)this.var.getElementCount().elementAt(1);
                int n10 = (Integer)this.var.getElementCount().elementAt(2);
                n3 = n2 / (n8 * n9 * n10);
                int[][][][] nArray = new int[n3][n8][n9][n10];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n8; ++j) {
                            for (int k = 0; k < n9; ++k) {
                                intBuffer.get(nArray[i][j][k]);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n10; ++j) {
                            for (int k = 0; k < n9; ++k) {
                                for (int i2 = 0; i2 < n8; ++i2) {
                                    nArray[i][i2][k][j] = intBuffer.get();
                                }
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)nArray[0] : nArray;
            }
            case 4: {
                int n11 = (Integer)this.var.getElementCount().elementAt(0);
                int n12 = (Integer)this.var.getElementCount().elementAt(1);
                int n13 = (Integer)this.var.getElementCount().elementAt(2);
                int n14 = (Integer)this.var.getElementCount().elementAt(3);
                n3 = n2 / (n11 * n12 * n13 * n14);
                int[][][][][] nArray = new int[n3][n11][n12][n13][n14];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n11; ++j) {
                            for (int k = 0; k < n12; ++k) {
                                for (int i3 = 0; i3 < n13; ++i3) {
                                    intBuffer.get(nArray[i][j][k][i3]);
                                }
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n14; ++j) {
                            for (int k = 0; k < n13; ++k) {
                                for (int i4 = 0; i4 < n12; ++i4) {
                                    for (int i5 = 0; i5 < n11; ++i5) {
                                        nArray[i][i5][i4][k][j] = intBuffer.get();
                                    }
                                }
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)nArray[0] : nArray;
            }
        }
        throw new Throwable("Internal error");
    }

    public void fillArray(int[] nArray, int n, int n2, int n3) throws Throwable {
        if (this.buffers.size() == 0) {
            throw new Throwable("buffer not available");
        }
        int n4 = (n3 - n2 + 1) * this.elements;
        ByteBuffer byteBuffer = this.getBuffer();
        int n5 = (n2 - this.getRecordRange()[0]) * this.elements * this.getLength();
        byteBuffer.position(n5);
        byteBuffer.asIntBuffer().get(nArray, n, n4);
    }

    @Override
    public int[] as1DArray() {
        return (int[])super.as1DArray();
    }

    @Override
    public int[] asOneDArray() {
        return (int[])super.asOneDArray(true);
    }

    @Override
    public int[] asOneDArray(boolean bl) {
        return (int[])super.asOneDArray(bl);
    }

    @Override
    public IntArray asArray() throws Throwable {
        return new IntArray(this._asArray());
    }
}

