/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import gov.nasa.gsfc.spdf.cdfj.ArrayAttribute;
import gov.nasa.gsfc.spdf.cdfj.ByteArray;
import gov.nasa.gsfc.spdf.cdfj.CDFDataType;
import gov.nasa.gsfc.spdf.cdfj.CDFTimeType;
import gov.nasa.gsfc.spdf.cdfj.CPR;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.DoubleArray;
import gov.nasa.gsfc.spdf.cdfj.FloatArray;
import gov.nasa.gsfc.spdf.cdfj.IntArray;
import gov.nasa.gsfc.spdf.cdfj.LongArray;
import gov.nasa.gsfc.spdf.cdfj.ShortArray;
import gov.nasa.gsfc.spdf.cdfj.StringArray;
import gov.nasa.gsfc.spdf.cdfj.SupportedTypes;
import gov.nasa.gsfc.spdf.cdfj.VDR;
import gov.nasa.gsfc.spdf.cdfj.VXR;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;

public class DataContainer {
    VDR vdr;
    VXR vxr;
    Vector<Integer> firstRecords = new Vector();
    Vector<Integer> lastRecords = new Vector();
    Vector<ByteBuffer> bufs = new Vector();
    Vector<Integer> points = new Vector();
    protected long position;
    static final int VVR_PREAMBLE = 12;
    static final int CVVR_PREAMBLE = 24;
    final boolean rowMajority;
    final int CXR_MAX_ENTRIES = 6;
    CPR cpr;
    DataContainer timeContainer;
    Vector<Integer> _firstRecords;
    Vector<Integer> _lastRecords;
    Vector<ByteBuffer> _bufs;
    Boolean phantom = null;
    Boolean _doNotCompress = null;
    boolean doNotCompress = false;
    long[] locs;
    VXR[] vxrs;

    public DataContainer(VDR vDR) {
        this(vDR, true);
    }

    public DataContainer(VDR vDR, boolean bl) {
        this.vdr = vDR;
        this.vxr = new VXR();
        this.rowMajority = bl;
    }

    public VDR getVDR() {
        return this.vdr;
    }

    public VXR getVXR() {
        return this.vxr;
    }

    void setTimeContainer(DataContainer dataContainer) {
        this.timeContainer = dataContainer;
    }

    void addPhantomEntry() {
        if (this.phantom != null) {
            return;
        }
        this.firstRecords.add(new Integer(-1));
        this.lastRecords.add(new Integer(-1));
        this.bufs.add(null);
        this.phantom = Boolean.TRUE;
    }

    public void addData(Object object, int[] nArray, boolean bl) throws Throwable {
        this.addData(object, nArray, bl, false);
    }

    void addData(Object object, int[] nArray, boolean bl, boolean bl2) throws Throwable {
        int n;
        Object object2;
        int n2;
        int n3;
        int n4;
        ByteBuffer byteBuffer = null;
        if (ByteBuffer.class.isAssignableFrom(object.getClass())) {
            byteBuffer = (ByteBuffer)object;
            if (DataTypes.size[this.vdr.dataType] > 1 && byteBuffer.order() != ByteOrder.LITTLE_ENDIAN) {
                throw new Throwable("For data types of size > 1, supplied buffer must be in LITTLE_ENDIAN order");
            }
            if (this.vdr.isCompressed()) {
                if (nArray == null) {
                    throw new Throwable("Record range must be specified since " + this.vdr.getName() + "is to be stored as compressed.");
                }
                if (this._doNotCompress == null) {
                    this.doNotCompress = nArray.length == 2;
                    this._doNotCompress = new Boolean(this.doNotCompress);
                } else if (this.doNotCompress && nArray.length > 2 || !this.doNotCompress && nArray.length == 2) {
                    String string = "compressed";
                    if (!this.doNotCompress) {
                        string = "uncompressed";
                    }
                    throw new Throwable("Changing compression mode of input. Previous = " + string + ".");
                }
            }
        } else if (!object.getClass().isArray()) {
            throw new Throwable("supplied object not an array");
        }
        int n5 = n4 = nArray == null ? 0 : nArray[0];
        if (this.lastRecords.size() > 0) {
            n3 = -1;
            n3 = this.timeContainer != null ? this.timeContainer.getLastRecord(this.lastRecords.size() - 1) : this.getLastRecord();
            if (nArray == null) {
                n4 = n3 + 1;
                n2 = this.getLastRecord() + 1;
                if (n4 - n2 > 0 && this.vdr.sRecords == 0) {
                    System.out.println("Gap: " + n2 + " - " + n4 + " for " + this.vdr.getName());
                    throw new Throwable(" SparseRecordOption must be set. There are  missing records between files for " + this.vdr.getName());
                }
            } else {
                if (nArray[0] <= n3) {
                    throw new Throwable("first record " + nArray[0] + " must follow the last seen record " + n3);
                }
                if (nArray[0] > n3 + 1 && this.vdr.sRecords == 0) {
                    throw new Throwable("Specified start of the range " + nArray[0] + " does not follow " + "last record " + n3 + " immediately." + " SparseRecordOption must be set if the CDF is missing" + " records");
                }
            }
        } else if (n4 != 0 && this.vdr.sRecords == 0) {
            throw new Throwable("SparseRecordOption must be set if the CDF is missing records");
        }
        n3 = 0;
        n2 = 0;
        int n6 = -1;
        if (n3 == 0 && byteBuffer != null) {
            if (nArray == null) {
                n2 = byteBuffer.remaining() / DataTypes.size[this.vdr.dataType];
                n6 = n4 + (n2 /= this.vdr.itemsPerPoint) - 1;
            } else {
                n6 = nArray[1];
                n2 = n6 - n4 + 1;
            }
            this.firstRecords.add(new Integer(n4));
            this.lastRecords.add(new Integer(n6));
            this.bufs.add(byteBuffer);
            this.points.add(new Integer(n2));
            return;
        }
        ArrayAttribute arrayAttribute = new ArrayAttribute(object);
        if (!bl) {
            n2 = Array.getLength(object);
            if (nArray != null && n2 != nArray[1] - nArray[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            object2 = null;
            if (this.vdr.dataType == 32) {
                object2 = new Vector();
                ((Vector)object2).add(new Integer(2));
            } else {
                object2 = this.vdr.efdim;
            }
            if (((Vector)object2).size() > 0) {
                int[] nArray2 = new int[1 + ((Vector)object2).size()];
                nArray2[0] = n2;
                for (n = 0; n < ((Vector)object2).size(); ++n) {
                    nArray2[n + 1] = (Integer)((Vector)object2).get(n);
                }
                if (!Arrays.equals(arrayAttribute.getDimensions(), nArray2)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < nArray2.length; ++i) {
                        stringBuffer.append("," + nArray2[i]);
                    }
                    StringBuffer stringBuffer2 = new StringBuffer("");
                    int[] nArray3 = arrayAttribute.getDimensions();
                    for (int i = 0; i < nArray3.length; ++i) {
                        stringBuffer2.append("," + nArray3[i]);
                    }
                    throw new Throwable("Dimension mismatch, expected: " + stringBuffer + " found " + stringBuffer2 + ".");
                }
            }
            n6 = n4 + n2 - 1;
            byteBuffer = this.addJavaArray(object, this.vdr.dataType, bl2);
            if (byteBuffer != null) {
                n3 = 1;
            }
        }
        if (n3 == 0 && (this.vdr.dataType == 1 || bl2 && this.vdr.dataType == 11 || this.vdr.dataType > 50 && arrayAttribute.getType() == Byte.TYPE)) {
            object2 = (byte[])object;
            n2 = ((byte[])object2).length / this.vdr.itemsPerPoint;
            if (nArray != null && n2 != nArray[1] - nArray[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            byteBuffer = ByteBuffer.wrap((byte[])object2);
            n6 = n4 + n2 - 1;
            n3 = 1;
        }
        if (n3 == 0 && (this.vdr.dataType == 2 || bl2 && this.vdr.dataType == 12)) {
            object2 = (short[])object;
            n2 = ((byte[])object2).length / this.vdr.itemsPerPoint;
            if (nArray != null && n2 != nArray[1] - nArray[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            n6 = n4 + n2 - 1;
            byteBuffer = ByteBuffer.allocateDirect(2 * ((byte[])object2).length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                byteBuffer.asShortBuffer().put((short[])object2);
            } else {
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    byteBuffer.putShort((short)object2[i]);
                }
                byteBuffer.position(0);
            }
            n3 = 1;
        }
        if (n3 == 0 && (this.vdr.dataType == 4 || bl2 && this.vdr.dataType == 14)) {
            object2 = (int[])object;
            n2 = ((byte[])object2).length / this.vdr.itemsPerPoint;
            if (nArray != null && n2 != nArray[1] - nArray[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            n6 = n4 + n2 - 1;
            byteBuffer = ByteBuffer.allocateDirect(4 * ((byte[])object2).length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                byteBuffer.asIntBuffer().put((int[])object2);
            } else {
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    byteBuffer.putInt((int)object2[i]);
                }
                byteBuffer.position(0);
            }
            n3 = 1;
        }
        if (n3 == 0 && (this.vdr.dataType == 21 || this.vdr.dataType == 44)) {
            object2 = (float[])object;
            n2 = ((byte[])object2).length / this.vdr.itemsPerPoint;
            if (nArray != null && n2 != nArray[1] - nArray[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            n6 = n4 + n2 - 1;
            byteBuffer = ByteBuffer.allocateDirect(4 * ((Object)object2).length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                byteBuffer.asFloatBuffer().put((float[])object2);
            } else {
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    byteBuffer.putFloat((float)object2[i]);
                }
                byteBuffer.position(0);
            }
            n3 = 1;
        }
        if (n3 == 0 && (this.vdr.dataType == 22 || this.vdr.dataType == 45 || this.vdr.dataType == 31 || this.vdr.dataType == 32)) {
            object2 = (double[])object;
            n2 = ((byte[])object2).length / this.vdr.itemsPerPoint;
            if (nArray != null && n2 != nArray[1] - nArray[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            n6 = n4 + n2 - 1;
            byteBuffer = ByteBuffer.allocateDirect(8 * ((Object)object2).length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                byteBuffer.asDoubleBuffer().put((double[])object2);
            } else {
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    byteBuffer.putDouble((double)object2[i]);
                }
                byteBuffer.position(0);
            }
            n3 = 1;
        }
        if (n3 == 0 && (this.vdr.dataType == 33 || this.vdr.dataType == 8)) {
            object2 = (long[])object;
            n2 = ((byte[])object2).length / this.vdr.itemsPerPoint;
            if (nArray != null && n2 != nArray[1] - nArray[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            n6 = n4 + n2 - 1;
            byteBuffer = ByteBuffer.allocateDirect(8 * ((Object)object2).length);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                byteBuffer.asLongBuffer().put((long[])object2);
            } else {
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    byteBuffer.putLong((long)object2[i]);
                }
                byteBuffer.position(0);
            }
            n3 = 1;
        }
        if (n3 == 0 && this.vdr.dataType > 50) {
            object2 = (String[])object;
            n2 = ((byte[])object2).length * this.vdr.numElems / this.vdr.itemsPerPoint;
            if (nArray != null && n2 != nArray[1] - nArray[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            n6 = n4 + n2 - 1;
            byteBuffer = ByteBuffer.allocateDirect(this.vdr.numElems * ((Object)object2).length);
            for (int i = 0; i < ((Object)object2).length; ++i) {
                n = ((String)object2[i]).length();
                if (n > this.vdr.numElems) {
                    throw new Throwable("String " + (String)object2[i] + " is longer than the length of variable.");
                }
                byte[] byArray = ((String)object2[i]).getBytes();
                byteBuffer.put(byArray);
                for (int j = 0; j < this.vdr.numElems - byArray.length; ++j) {
                    byteBuffer.put((byte)32);
                }
            }
            byteBuffer.position(0);
            n3 = 1;
        }
        if (n3 == 0) {
            if (bl2) {
                throw new Throwable("Unsupported data type.");
            }
            if (this.vdr.dataType > 10 && this.vdr.dataType < 20) {
                throw new Throwable("Possible incompatibility for unsigned. Use relax = true to force acceptance");
            }
        }
        if (this.phantom == Boolean.TRUE) {
            this.firstRecords.clear();
            this.lastRecords.clear();
            this.bufs.clear();
            this.phantom = Boolean.FALSE;
        }
        this.firstRecords.add(new Integer(n4));
        this.lastRecords.add(new Integer(n6));
        this.bufs.add(byteBuffer);
        this.points.add(new Integer(n2));
    }

    public int getSize() {
        int n;
        int n2;
        int n3 = this.vdr.getSize();
        if (this.vdr.isCompressed()) {
            this.cpr = new CPR();
            this.cpr.position = this.position + (long)n3;
            this.vdr.setCPROffset(this.cpr.position);
            n3 += this.cpr.getSize();
        }
        if (this.bufs.size() > 0) {
            n2 = -1;
            for (n = this.bufs.size() - 1; n >= 0; --n) {
                if (this.bufs.get(n) == null) continue;
                n2 = this.lastRecords.get(n);
                break;
            }
            if (n2 < 0) {
                return n3;
            }
        } else {
            return n3;
        }
        this.vdr.setMaxRec(n2);
        this.vdr.setVXRHead(this.position + (long)n3);
        this._firstRecords = new Vector();
        this._lastRecords = new Vector();
        this._bufs = new Vector();
        if (this.timeContainer == null) {
            for (n2 = 0; n2 < this.bufs.size(); ++n2) {
                if (this.bufs.get(n2) == null) continue;
                this._firstRecords.add(this.firstRecords.get(n2));
                this._lastRecords.add(this.lastRecords.get(n2));
                this._bufs.add(this.bufs.get(n2));
            }
        } else {
            for (n2 = 0; n2 < this.bufs.size(); ++n2) {
                if (this.bufs.get(n2) == null) continue;
                n = this.firstRecords.get(n2);
                if (n < this.timeContainer.firstRecords.get(n2)) {
                    n = this.timeContainer.firstRecords.get(n2);
                }
                this._firstRecords.add(n);
                this._lastRecords.add(n + this.lastRecords.get(n2) - this.firstRecords.get(n2));
                this._bufs.add(this.bufs.get(n2));
            }
        }
        n2 = this._bufs.size() / 6;
        n = this._bufs.size() - n2 * 6;
        if (n > 0) {
            ++n2;
        } else {
            n = 6;
        }
        this.vxrs = new VXR[n2];
        this.locs = new long[this._bufs.size()];
        int n4 = 0;
        long l = -1L;
        for (int i = 0; i < this.vxrs.length; ++i) {
            int n5;
            int n6;
            l = this.position + (long)n3;
            this.vxrs[i] = new VXR();
            int n7 = 6;
            if (i == this.vxrs.length - 1) {
                n7 = n;
            }
            this.vxrs[i].numEntries = n7;
            n3 += this.vxrs[i].getSize();
            if (!this.vdr.isCompressed()) {
                for (n6 = 0; n6 < n7; ++n6) {
                    this.locs[n4] = this.position + (long)n3;
                    n5 = 12 + this._bufs.get(n4).limit();
                    n3 += n5;
                    ++n4;
                }
            } else {
                this.vdr.setBlockingFactor(this.getBlockingFactor());
                if (this.doNotCompress) {
                    for (n6 = 0; n6 < n7; ++n6) {
                        this.locs[n4] = this.position + (long)n3;
                        n5 = 24 + this._bufs.get(n4).limit();
                        n3 += n5;
                        ++n4;
                    }
                    return n3;
                }
                for (n6 = 0; n6 < n7; ++n6) {
                    this.locs[n4] = this.position + (long)n3;
                    ByteBuffer byteBuffer = this._bufs.get(n4);
                    byte[] byArray = null;
                    if (byteBuffer.hasArray()) {
                        byArray = byteBuffer.array();
                    } else {
                        byArray = new byte[byteBuffer.remaining()];
                        byteBuffer.get(byArray);
                        this._bufs.setElementAt(null, n4);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
                    try {
                        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                        gZIPOutputStream.write(byArray, 0, byArray.length);
                        gZIPOutputStream.finish();
                        byteArrayOutputStream.flush();
                        byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
                        this._bufs.setElementAt(byteBuffer, n4);
                        int n8 = 24 + byteBuffer.limit();
                        n3 += n8;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    ++n4;
                }
            }
            if (i == this.vxrs.length - 1) continue;
            this.vxrs[i].setVXRNext(this.position + (long)n3);
        }
        if (this.vxrs.length > 1) {
            this.vdr.setVXRTail(l);
        }
        return n3;
    }

    public ByteBuffer update(ByteBuffer byteBuffer) {
        byteBuffer.position((int)this.position);
        byteBuffer.put(this.vdr.get());
        if (this.vdr.isCompressed()) {
            byteBuffer.put(this.cpr.get());
        }
        if (this._bufs == null) {
            return byteBuffer;
        }
        int n = 0;
        if (this._bufs.size() > 0) {
            for (int i = 0; i < this.vxrs.length; ++i) {
                int n2;
                int n3;
                byteBuffer.put(this.vxrs[i].get());
                for (n3 = 0; n3 < this.vxrs[i].numEntries; ++n3) {
                    n2 = this._firstRecords.get(n + n3);
                    byteBuffer.putInt(n2);
                }
                for (n3 = 0; n3 < this.vxrs[i].numEntries; ++n3) {
                    n2 = this._lastRecords.get(n + n3);
                    byteBuffer.putInt(n2);
                }
                for (n3 = 0; n3 < this.vxrs[i].numEntries; ++n3) {
                    byteBuffer.putLong(this.locs[n + n3]);
                }
                if (!this.vdr.isCompressed()) {
                    for (n3 = 0; n3 < this.vxrs[i].numEntries; ++n3) {
                        byteBuffer.putLong(12 + this._bufs.get(n + n3).limit());
                        byteBuffer.putInt(7);
                        byteBuffer.put(this._bufs.get(n + n3));
                    }
                } else {
                    for (n3 = 0; n3 < this.vxrs[i].numEntries; ++n3) {
                        ByteBuffer byteBuffer2 = this._bufs.get(n + n3);
                        byteBuffer.putLong(24 + byteBuffer2.limit());
                        byteBuffer.putInt(13);
                        byteBuffer.putInt(0);
                        byteBuffer.putLong(byteBuffer2.limit());
                        byteBuffer.put(byteBuffer2);
                    }
                }
                n += this.vxrs[i].numEntries;
            }
        }
        return byteBuffer;
    }

    int getBlockingFactor() {
        int n = -1;
        for (int i = 0; i < this.points.size(); ++i) {
            int n2 = this.points.get(i);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public ByteBuffer addJavaArray(Object object, int n, boolean bl) throws Throwable {
        boolean bl2;
        AArray aArray;
        ArrayAttribute arrayAttribute = new ArrayAttribute(object);
        Class<?> clazz = arrayAttribute.getType();
        CDFDataType cDFDataType = SupportedTypes.cdfType(n);
        if (cDFDataType == null) {
            throw new Throwable("Internal error.");
        }
        if (clazz == Long.TYPE) {
            aArray = new LongArray(object, this.rowMajority);
            boolean bl3 = bl2 = cDFDataType == CDFDataType.INT8 || cDFDataType == CDFDataType.TT2000;
            if (bl2) {
                return aArray.buffer();
            }
            if (cDFDataType == CDFDataType.UINT4) {
                return aArray.buffer(Integer.TYPE);
            }
        }
        if (clazz == Double.TYPE) {
            aArray = new DoubleArray(object, this.rowMajority);
            boolean bl4 = bl2 = cDFDataType == CDFDataType.DOUBLE || cDFDataType == CDFDataType.EPOCH || cDFDataType == CDFDataType.EPOCH16;
            if (bl2) {
                return aArray.buffer();
            }
            if (cDFDataType == CDFDataType.FLOAT) {
                return aArray.buffer(Float.TYPE);
            }
        }
        if (clazz == Float.TYPE) {
            aArray = new FloatArray(object, this.rowMajority);
            if (cDFDataType == CDFDataType.FLOAT) {
                return aArray.buffer();
            }
        }
        if (clazz == Integer.TYPE) {
            aArray = new IntArray(object, this.rowMajority);
            if (cDFDataType == CDFDataType.INT4) {
                return aArray.buffer();
            }
            if (cDFDataType == CDFDataType.UINT2) {
                return aArray.buffer(Short.TYPE);
            }
            if (bl && cDFDataType == CDFDataType.UINT4) {
                return aArray.buffer();
            }
        }
        if (clazz == Short.TYPE) {
            aArray = new ShortArray(object, this.rowMajority);
            if (cDFDataType == CDFDataType.INT2) {
                return aArray.buffer();
            }
            if (cDFDataType == CDFDataType.UINT1) {
                return aArray.buffer(Byte.TYPE);
            }
            if (bl & cDFDataType == CDFDataType.UINT2) {
                return aArray.buffer();
            }
        }
        if (clazz == Byte.TYPE) {
            aArray = new ByteArray(object, this.rowMajority);
            if (cDFDataType == CDFDataType.INT1) {
                return aArray.buffer();
            }
            if (bl & cDFDataType == CDFDataType.UINT1) {
                return aArray.buffer();
            }
        }
        if (clazz == String.class) {
            aArray = new StringArray(object, this.rowMajority);
            if (cDFDataType == CDFDataType.CHAR) {
                return aArray.buffer(this.vdr.numElems);
            }
        }
        return null;
    }

    int getLastRecord() {
        return this.getLastRecord(this.lastRecords.size() - 1);
    }

    int getLastRecord(int n) {
        int n2 = n;
        if (n2 < 0) {
            return -1;
        }
        while (n2 >= 0) {
            int n3 = this.lastRecords.get(n2);
            if (n3 >= 0) {
                return n3;
            }
            --n2;
        }
        return -1;
    }

    boolean timeOrderOK(Object object) {
        int n = this.bufs.size() - 1;
        if (n < 0) {
            return true;
        }
        ByteBuffer byteBuffer = null;
        while ((byteBuffer = this.bufs.get(n)) == null && n != 0) {
            --n;
        }
        if (byteBuffer == null) {
            return true;
        }
        if (CDFTimeType.TT2000.getValue() == this.vdr.dataType) {
            return ((long[])object)[0] > byteBuffer.getLong(byteBuffer.limit());
        }
        if (CDFTimeType.EPOCH16.getValue() == this.vdr.dataType) {
            double[] dArray = (double[])object;
            double[] dArray2 = new double[]{byteBuffer.getDouble(byteBuffer.limit() - 16), byteBuffer.getDouble(byteBuffer.limit() - 8)};
            if (dArray[0] > dArray2[0]) {
                return true;
            }
            if (dArray[0] < dArray2[0]) {
                return false;
            }
            return dArray[1] > dArray2[1];
        }
        double[] dArray = (double[])object;
        return dArray[0] > byteBuffer.getDouble(byteBuffer.limit() - 8);
    }

    public void update(FileChannel fileChannel) throws IOException {
        fileChannel.position(this.position);
        fileChannel.write(this.vdr.get());
        if (this.vdr.isCompressed()) {
            fileChannel.write(this.cpr.get());
        }
        if (this._bufs == null) {
            return;
        }
        int n = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
        if (this._bufs.size() > 0) {
            for (int i = 0; i < this.vxrs.length; ++i) {
                int n2;
                int n3;
                fileChannel.write(this.vxrs[i].get());
                for (n3 = 0; n3 < this.vxrs[i].numEntries; ++n3) {
                    n2 = this._firstRecords.get(n + n3);
                    this.writeInt(fileChannel, byteBuffer2, n2);
                }
                for (n3 = 0; n3 < this.vxrs[i].numEntries; ++n3) {
                    n2 = this._lastRecords.get(n + n3);
                    this.writeInt(fileChannel, byteBuffer2, n2);
                }
                for (n3 = 0; n3 < this.vxrs[i].numEntries; ++n3) {
                    this.writeLong(fileChannel, byteBuffer, this.locs[n + n3]);
                }
                if (!this.vdr.isCompressed()) {
                    for (n3 = 0; n3 < this.vxrs[i].numEntries; ++n3) {
                        this.writeLong(fileChannel, byteBuffer, 12 + this._bufs.get(n + n3).limit());
                        this.writeInt(fileChannel, byteBuffer2, 7);
                        fileChannel.write(this._bufs.get(n + n3));
                    }
                } else {
                    for (n3 = 0; n3 < this.vxrs[i].numEntries; ++n3) {
                        ByteBuffer byteBuffer3 = this._bufs.get(n + n3);
                        this.writeLong(fileChannel, byteBuffer, 24 + byteBuffer3.limit());
                        this.writeInt(fileChannel, byteBuffer2, 13);
                        this.writeInt(fileChannel, byteBuffer2, 0);
                        this.writeLong(fileChannel, byteBuffer, byteBuffer3.limit());
                        fileChannel.write(byteBuffer3);
                    }
                }
                n += this.vxrs[i].numEntries;
            }
        }
    }

    void writeInt(FileChannel fileChannel, ByteBuffer byteBuffer, int n) throws IOException {
        byteBuffer.position(0);
        byteBuffer.putInt(n);
        byteBuffer.position(0);
        fileChannel.write(byteBuffer);
    }

    void writeLong(FileChannel fileChannel, ByteBuffer byteBuffer, long l) throws IOException {
        byteBuffer.position(0);
        byteBuffer.putLong(l);
        byteBuffer.position(0);
        fileChannel.write(byteBuffer);
    }
}

