/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AttributeEntry;
import gov.nasa.gsfc.spdf.cdfj.CDFDataType;
import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFTimeType;
import gov.nasa.gsfc.spdf.cdfj.DataContainer;
import gov.nasa.gsfc.spdf.cdfj.GenericReader;
import gov.nasa.gsfc.spdf.cdfj.GenericWriter;
import gov.nasa.gsfc.spdf.cdfj.ReaderFactory;
import gov.nasa.gsfc.spdf.cdfj.SelectedVariableCollection;
import gov.nasa.gsfc.spdf.cdfj.SparseRecordOption;
import gov.nasa.gsfc.spdf.cdfj.SupportedTypes;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import gov.nasa.gsfc.spdf.cdfj.VariableDataBuffer;
import java.io.File;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CDFWriter
extends GenericWriter {
    Hashtable variableMap = new Hashtable();
    Hashtable gamap = new Hashtable();
    SelectedVariableCollection vcol = new Selector();
    static Logger anonymousLogger;
    static Logger logger;
    static List<String> doNotCheckListGlobal;

    public CDFWriter(boolean bl) {
        super(bl);
    }

    public CDFWriter(GenericReader genericReader) throws CDFException.WriterError, CDFException.ReaderError {
        super(genericReader.rowMajority());
        try {
            this._addCDF(genericReader);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public CDFWriter(String string) throws CDFException.WriterError, CDFException.ReaderError {
        super(false);
        GenericReader genericReader = this.getFileReader(string);
        try {
            this._addCDF(genericReader);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public CDFWriter(String[] stringArray) throws CDFException.WriterError, CDFException.ReaderError {
        this(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            this.addCDF(stringArray[i]);
        }
    }

    public CDFWriter(URL uRL) throws CDFException.WriterError, CDFException.ReaderError {
        super(false);
        GenericReader genericReader = null;
        try {
            genericReader = new GenericReader(uRL);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
        try {
            this._addCDF(genericReader);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public CDFWriter(URL[] uRLArray) throws CDFException.WriterError, CDFException.ReaderError {
        this(uRLArray[0]);
        for (int i = 1; i < uRLArray.length; ++i) {
            this.addCDF(uRLArray[i]);
        }
    }

    public CDFWriter(String string, SelectedVariableCollection selectedVariableCollection) throws CDFException.WriterError, CDFException.ReaderError {
        super(false);
        GenericReader genericReader = this.getFileReader(string);
        try {
            this._addCDF(genericReader, this.variableNames(genericReader, selectedVariableCollection));
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public CDFWriter(String[] stringArray, SelectedVariableCollection selectedVariableCollection) throws CDFException.WriterError, CDFException.ReaderError {
        this(stringArray[0], selectedVariableCollection);
        for (int i = 1; i < stringArray.length; ++i) {
            this.addCDF(stringArray[i]);
        }
    }

    public CDFWriter(URL uRL, SelectedVariableCollection selectedVariableCollection) throws CDFException.WriterError, CDFException.ReaderError {
        super(false);
        GenericReader genericReader = null;
        try {
            genericReader = new GenericReader(uRL);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
        try {
            this._addCDF(genericReader, this.variableNames(genericReader, selectedVariableCollection));
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public CDFWriter(URL[] uRLArray, SelectedVariableCollection selectedVariableCollection) throws CDFException.WriterError, CDFException.ReaderError {
        this(uRLArray[0], selectedVariableCollection);
        for (int i = 1; i < uRLArray.length; ++i) {
            this.addCDF(uRLArray[i]);
        }
    }

    String[] variableNames(GenericReader genericReader, SelectedVariableCollection selectedVariableCollection) throws CDFException.ReaderError {
        String[] stringArray;
        if (selectedVariableCollection == null) {
            stringArray = genericReader.getVariableNames();
            for (int i = 0; i < stringArray.length; ++i) {
                this.vcol.add(stringArray[i], genericReader.isCompressed(stringArray[i]), this.sparseRecordOption(genericReader, stringArray[i]));
            }
        } else {
            stringArray = this.getSelected(genericReader, selectedVariableCollection);
        }
        return stringArray;
    }

    public CDFWriter(String string, boolean bl) throws CDFException.WriterError, CDFException.ReaderError {
        super(bl);
        GenericReader genericReader = this.getFileReader(string);
        try {
            this._addCDF(genericReader);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    GenericReader getFileReader(String string) throws CDFException.ReaderError {
        GenericReader genericReader = null;
        File file = new File(string);
        if (!file.exists()) {
            throw new CDFException.ReaderError("file " + string + " does not exist.");
        }
        try {
            long l = file.length();
            if (l > Integer.MAX_VALUE) {
                genericReader = ReaderFactory.getReader(string);
            } else {
                if (this.isWindows()) {
                    return ReaderFactory.getReader(string, true);
                }
                genericReader = new GenericReader(string);
            }
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
        return genericReader;
    }

    public CDFWriter(String[] stringArray, boolean bl) throws CDFException.WriterError, CDFException.ReaderError {
        this(stringArray[0], bl);
        for (int i = 1; i < stringArray.length; ++i) {
            this.addCDF(stringArray[i]);
        }
    }

    public CDFWriter(URL uRL, boolean bl) throws CDFException.WriterError, CDFException.ReaderError {
        super(bl);
        GenericReader genericReader = null;
        try {
            genericReader = new GenericReader(uRL);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
        try {
            this._addCDF(genericReader);
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public CDFWriter(URL[] uRLArray, boolean bl) throws CDFException.WriterError, CDFException.ReaderError {
        this(uRLArray[0], bl);
        for (int i = 1; i < uRLArray.length; ++i) {
            this.addCDF(uRLArray[i]);
        }
    }

    public CDFWriter(String string, boolean bl, SelectedVariableCollection selectedVariableCollection) throws CDFException.WriterError, CDFException.ReaderError {
        super(bl);
        GenericReader genericReader = this.getFileReader(string);
        try {
            this._addCDF(genericReader, this.variableNames(genericReader, selectedVariableCollection));
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public CDFWriter(String[] stringArray, boolean bl, SelectedVariableCollection selectedVariableCollection) throws CDFException.WriterError, CDFException.ReaderError {
        this(stringArray[0], bl, selectedVariableCollection);
        for (int i = 1; i < stringArray.length; ++i) {
            this.addCDF(stringArray[i]);
        }
    }

    public CDFWriter(URL uRL, boolean bl, SelectedVariableCollection selectedVariableCollection) throws CDFException.WriterError, CDFException.ReaderError {
        super(bl);
        GenericReader genericReader = null;
        try {
            genericReader = new GenericReader(uRL);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
        try {
            this._addCDF(genericReader, this.variableNames(genericReader, selectedVariableCollection));
        }
        catch (Throwable throwable) {
            throw new CDFException.WriterError(throwable.getMessage());
        }
    }

    public CDFWriter(URL[] uRLArray, boolean bl, SelectedVariableCollection selectedVariableCollection) throws CDFException.WriterError, CDFException.ReaderError {
        this(uRLArray[0], bl, selectedVariableCollection);
        for (int i = 1; i < uRLArray.length; ++i) {
            this.addCDF(uRLArray[i]);
        }
    }

    public void addCDF(String string) throws CDFException.WriterError, CDFException.ReaderError {
        GenericReader genericReader = this.getFileReader(string);
        this.addCDF(genericReader);
    }

    public void addCDF(URL uRL) throws CDFException.WriterError, CDFException.ReaderError {
        GenericReader genericReader = null;
        try {
            genericReader = new GenericReader(uRL);
        }
        catch (Throwable throwable) {
            throw new CDFException.ReaderError(throwable.getMessage());
        }
        this.addCDF(genericReader);
    }

    private void _addCDF(GenericReader genericReader, String[] stringArray) throws CDFException.WriterError, CDFException.ReaderError {
        String string;
        int n;
        this.checkLastLeapSecondId(genericReader);
        this.copyGlobalAttributes(genericReader);
        this.addGlobalAttributeEntry("cdfj_source", genericReader.getSource());
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            this.copyVariableAttributes(genericReader, string);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!genericReader.recordVariance(stringArray[n]) || genericReader.isTimeType(stringArray[n])) continue;
            try {
                string = genericReader.getTimeVariableName(stringArray[n]);
            }
            catch (Throwable throwable) {
                string = null;
            }
            if (string == null) continue;
            DataContainer dataContainer = (DataContainer)this.dataContainers.get(stringArray[n]);
            if (genericReader.getNumberOfValues(stringArray[n]) != genericReader.getNumberOfValues(string)) continue;
            dataContainer.setTimeContainer((DataContainer)this.dataContainers.get(string));
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (genericReader.getNumberOfValues(stringArray[n]) == 0) {
                ((DataContainer)this.dataContainers.get(stringArray[n])).addPhantomEntry();
            } else {
                this.copyVariableData(genericReader, stringArray[n]);
            }
            this.vcol.add(stringArray[n], genericReader.isCompressed(stringArray[n]), this.sparseRecordOption(genericReader, stringArray[n]));
        }
    }

    private void _addCDF(GenericReader genericReader) throws Throwable {
        String[] stringArray = genericReader.getVariableNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.vcol.add(stringArray[i], genericReader.isCompressed(stringArray[i]));
        }
        this._addCDF(genericReader, stringArray);
    }

    void copyGlobalAttributes(GenericReader genericReader) throws CDFException.ReaderError, CDFException.WriterError {
        String[] stringArray = genericReader.globalAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Vector<AttributeEntry> vector = null;
            try {
                vector = genericReader.getAttributeEntries(stringArray[i]);
            }
            catch (Throwable throwable) {
                throw new CDFException.ReaderError(throwable.getMessage());
            }
            this.gamap.put(stringArray[i], vector);
            for (int j = 0; j < vector.size(); ++j) {
                AttributeEntry attributeEntry = vector.get(j);
                this.addGlobalAttributeEntry(stringArray[i], SupportedTypes.cdfType(attributeEntry.getType()), attributeEntry.getValue());
            }
        }
    }

    void copyVariableAttributes(GenericReader genericReader, String string) throws CDFException.ReaderError, CDFException.WriterError {
        boolean bl = this.vcol.isCompressed(string);
        SparseRecordOption sparseRecordOption = this.vcol.getSparseRecordOption(string);
        CDFDataType cDFDataType = SupportedTypes.cdfType(genericReader.getType(string));
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("ctype", cDFDataType);
        hashtable.put("compressed", bl);
        hashtable.put("dimensions", genericReader.getDimensions(string));
        hashtable.put("varys", genericReader.getVarys(string));
        hashtable.put("variance", genericReader.recordVariance(string));
        hashtable.put("padValue", genericReader.getPadValue(string, true));
        hashtable.put("numberOfElements", genericReader.getNumberOfElements(string));
        int[] nArray = genericReader.getDimensions(string);
        boolean[] blArray = genericReader.getVarys(string);
        if (cDFDataType == CDFDataType.EPOCH16) {
            nArray = new int[]{};
            blArray = new boolean[]{};
        }
        try {
            this.defineVariable(string, cDFDataType, nArray, blArray, genericReader.recordVariance(string), bl, genericReader.getPadValue(string, true), genericReader.getNumberOfElements(string), sparseRecordOption);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CDFException.WriterError("Failed to define " + string);
        }
        Hashtable<String, Vector<AttributeEntry>> hashtable2 = new Hashtable<String, Vector<AttributeEntry>>();
        String[] stringArray = genericReader.variableAttributeNames(string);
        for (int i = 0; i < stringArray.length; ++i) {
            Vector<AttributeEntry> vector = null;
            try {
                vector = genericReader.getAttributeEntries(string, stringArray[i]);
            }
            catch (Throwable throwable) {
                throw new CDFException.ReaderError(throwable.getMessage());
            }
            hashtable2.put(stringArray[i], vector);
            AttributeEntry attributeEntry = vector.get(0);
            cDFDataType = SupportedTypes.cdfType(attributeEntry.getType());
            this.setVariableAttributeEntry(string, stringArray[i], cDFDataType, attributeEntry.getValue());
            for (int j = 1; j < vector.size(); ++j) {
                attributeEntry = vector.get(j);
                cDFDataType = SupportedTypes.cdfType(genericReader.getType(string));
                this.addVariableAttributeEntry(string, stringArray[i], cDFDataType, attributeEntry.getValue());
            }
        }
        hashtable.put("amap", hashtable2);
        this.variableMap.put(string, hashtable);
    }

    void copyVariableData(GenericReader genericReader, String string) throws CDFException.ReaderError, CDFException.WriterError {
        if (genericReader.getByteOrder() == ByteOrder.LITTLE_ENDIAN && genericReader.rowMajority() == this.rowMajority) {
            VariableDataBuffer[] variableDataBufferArray = null;
            try {
                Variable variable = genericReader.thisCDF.getVariable(string);
                variableDataBufferArray = variable.getDataBuffers(true);
            }
            catch (Throwable throwable) {
                throw new CDFException.ReaderError(throwable.getMessage());
            }
            for (int i = 0; i < variableDataBufferArray.length; ++i) {
                ByteBuffer byteBuffer = variableDataBufferArray[i].getBuffer();
                this.addBuffer(string, variableDataBufferArray[i]);
            }
        } else {
            VDataContainer vDataContainer = null;
            try {
                vDataContainer = this.getContainer(genericReader, string);
            }
            catch (Throwable throwable) {
                throw new CDFException.ReaderError(throwable.getMessage());
            }
            vDataContainer.run();
            int[] nArray = new int[]{0, genericReader.getNumberOfValues(string) - 1, 1};
            DataContainer dataContainer = (DataContainer)this.dataContainers.get(string);
            if (dataContainer != null) {
                int n = dataContainer.getLastRecord();
                System.out.println("last: " + n);
                if (n >= 0) {
                    nArray[0] = nArray[0] + ++n;
                    nArray[1] = nArray[1] + n;
                }
            }
            System.out.println("rr: " + nArray[0] + "," + nArray[1]);
            if (genericReader.rowMajority() == this.rowMajority) {
                this.addData(string, (Object)vDataContainer.getBuffer(), nArray);
            } else {
                this.addOneD(string, vDataContainer.asOneDArray(!this.rowMajority), nArray, true);
            }
        }
    }

    public void addCDF(GenericReader genericReader) throws CDFException.ReaderError, CDFException.WriterError {
        this.checkLastLeapSecondId(genericReader);
        this.checkGlobalAttributes(genericReader);
        List list = this.getTimeVariableList(genericReader);
        String[] stringArray = this.vcol.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Hashtable hashtable = (Hashtable)this.variableMap.get(string);
            if (!((Boolean)hashtable.get("variance")).booleanValue()) continue;
            if (list.contains(string)) {
                DataContainer dataContainer = (DataContainer)this.dataContainers.get(string);
                if (genericReader.getNumberOfValues(string) > 0) {
                    Object object;
                    try {
                        object = genericReader.isCompatible(string, Double.TYPE) ? genericReader.getOneDArray(string, "double", new int[]{0, 0}, true, !this.rowMajority) : genericReader.getOneDArray(string, "long", new int[]{0, 0}, true, !this.rowMajority);
                    }
                    catch (Throwable throwable) {
                        throw new CDFException.WriterError(throwable.getMessage());
                    }
                    if (!dataContainer.timeOrderOK(object)) {
                        throw new CDFException.WriterError("Time Backup -Time of first record for variable " + string + " of CDF " + genericReader.thisCDF.getSource().getName() + " starts before the end of previous CDF");
                    }
                }
            }
            if (genericReader.getNumberOfValues(string) <= 0) continue;
            this.copyVariableData(genericReader, string);
        }
    }

    List getTimeVariableList(GenericReader genericReader) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.vcol.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            try {
                string = genericReader.getTimeVariableName(stringArray[i]);
            }
            catch (Throwable throwable) {
                string = null;
            }
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    void checkGlobalAttributes(GenericReader genericReader) throws CDFException.ReaderError, CDFException.WriterError {
        String[] stringArray = genericReader.globalAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Vector vector = (Vector)this.gamap.get(stringArray[i]);
            Vector<AttributeEntry> vector2 = null;
            try {
                vector2 = genericReader.getAttributeEntries(stringArray[i]);
            }
            catch (Throwable throwable) {
                throw new CDFException.ReaderError(throwable.getMessage());
            }
            for (int j = 0; j < vector2.size(); ++j) {
                AttributeEntry attributeEntry;
                AttributeEntry attributeEntry2 = vector2.get(j);
                boolean bl = false;
                for (int k = 0; k < vector.size() && !(bl = (attributeEntry = (AttributeEntry)vector.get(k)).isSameAs(attributeEntry2)); ++k) {
                }
                if (bl || doNotCheckListGlobal.contains(stringArray[i])) continue;
                logger.info("Global attribute entry for attribute " + stringArray[i] + " not in base," + " or differs from the value in base.");
            }
        }
    }

    void updateVariableAttributes(GenericReader genericReader, String string) throws Throwable {
        String[] stringArray = genericReader.variableAttributeNames(string);
        Hashtable hashtable = (Hashtable)this.variableMap.get(string);
        this.validateVariableProperties(genericReader, string);
        Hashtable hashtable2 = (Hashtable)hashtable.get("amap");
        for (int i = 0; i < stringArray.length; ++i) {
            Vector<AttributeEntry> vector = genericReader.getAttributeEntries(string, stringArray[i]);
            Vector vector2 = (Vector)hashtable2.get(stringArray[i]);
            for (int j = 0; j < vector.size(); ++j) {
                AttributeEntry attributeEntry;
                AttributeEntry attributeEntry2 = vector.get(j);
                boolean bl = false;
                for (int k = 0; k < vector2.size() && !(bl |= (attributeEntry = (AttributeEntry)vector2.get(k)).isSameAs(attributeEntry2)); ++k) {
                }
                if (bl) continue;
                logger.info("Attribute entry for attribute " + stringArray[i] + " for variable " + string + " not in base.");
            }
        }
    }

    void validateVariableProperties(GenericReader genericReader, String string) throws Throwable {
        boolean bl;
        Hashtable hashtable = (Hashtable)this.variableMap.get(string);
        boolean bl2 = genericReader.isCompressed(string);
        boolean bl3 = bl = (CDFDataType)hashtable.get("ctype") != SupportedTypes.cdfType(genericReader.getType(string));
        if (!bl) {
            boolean bl4 = bl = !Arrays.equals((int[])hashtable.get("dimensions"), genericReader.getDimensions(string));
        }
        if (!bl) {
            boolean bl5 = bl = !Arrays.equals((boolean[])hashtable.get("varys"), genericReader.getVarys(string));
        }
        if (!bl) {
            boolean bl6 = bl = ((Boolean)hashtable.get("variance")).booleanValue() != genericReader.recordVariance(string);
        }
        if (!bl) {
            boolean bl7 = bl = ((Integer)hashtable.get("numberOfElements")).intValue() != genericReader.getNumberOfElements(string);
        }
        if (bl) {
            throw new Throwable("Properties of variable " + string + "do not match.");
        }
    }

    boolean isTimeType(int n) {
        boolean bl = CDFTimeType.EPOCH.getValue() == n;
        bl |= CDFTimeType.EPOCH16.getValue() == n;
        return bl |= CDFTimeType.TT2000.getValue() == n;
    }

    String[] getSelected(GenericReader genericReader, SelectedVariableCollection selectedVariableCollection) throws CDFException.ReaderError {
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        String[] stringArray2 = selectedVariableCollection.getNames();
        while (n < stringArray2.length) {
            String string = stringArray2[n];
            logger.info("requested: " + string);
            if (!this.hasVariable(genericReader, string)) {
                logger.info(string + " not found in original." + " ignoring.");
                ++n;
                continue;
            }
            if (!vector.contains(string)) {
                vector.add(string);
                this.vcol.add(string, selectedVariableCollection.isCompressed(string), selectedVariableCollection.getSparseRecordOption(string));
            }
            Vector vector2 = CDFWriter.getDependent(genericReader, string);
            for (int i = 0; i < vector2.size(); ++i) {
                String string2 = (String)vector2.get(i);
                if (vector.contains(string2)) continue;
                vector.add(string2);
                boolean bl = genericReader.isCompressed(string2);
                SparseRecordOption sparseRecordOption = this.sparseRecordOption(genericReader, string);
                if (selectedVariableCollection.hasVariable(string2)) {
                    bl = selectedVariableCollection.isCompressed(string2);
                    sparseRecordOption = selectedVariableCollection.getSparseRecordOption(string);
                }
                this.vcol.add(string2, bl, sparseRecordOption);
                logger.info("added: " + vector2.get(i));
            }
            ++n;
        }
        if (vector.size() == 0) {
            logger.info("No valid variables selected.");
            return new String[0];
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    static Vector getDependent(GenericReader genericReader, String string) throws CDFException.ReaderError {
        String[] stringArray = genericReader.variableAttributeNames(string);
        Vector vector = new Vector();
        if (stringArray == null) {
            return vector;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("DEPEND_")) continue;
            vector.add(((Vector)genericReader.getAttribute(string, stringArray[i])).get(0));
        }
        return vector;
    }

    public static SelectedVariableCollection selectorInstance() {
        return new Selector();
    }

    boolean hasVariable(GenericReader genericReader, String string) {
        String[] stringArray = genericReader.getVariableNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    String getTimeVariableName(GenericReader genericReader, String string) {
        String string2;
        try {
            string2 = genericReader.getTimeVariableName(string);
        }
        catch (Throwable throwable) {
            logger.info(throwable.toString());
            string2 = null;
        }
        return string2;
    }

    VDataContainer getContainer(GenericReader genericReader, String string) throws Throwable {
        VDataContainer vDataContainer = null;
        CDFDataType cDFDataType = SupportedTypes.cdfType(genericReader.getType(string));
        Variable variable = genericReader.thisCDF.getVariable(string);
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        if (cDFDataType == CDFDataType.INT1 || cDFDataType == CDFDataType.UINT1) {
            vDataContainer = variable.getByteContainer(null);
        }
        if (cDFDataType == CDFDataType.INT2) {
            vDataContainer = variable.getShortContainer(null, true, byteOrder);
        }
        if (cDFDataType == CDFDataType.INT4) {
            vDataContainer = variable.getIntContainer(null, true, byteOrder);
        }
        if (cDFDataType == CDFDataType.UINT2) {
            vDataContainer = variable.getShortContainer(null, false, byteOrder);
        }
        if (cDFDataType == CDFDataType.UINT4) {
            vDataContainer = variable.getIntContainer(null, false, byteOrder);
        }
        if (cDFDataType == CDFDataType.FLOAT) {
            vDataContainer = variable.getFloatContainer(null, true, byteOrder);
        }
        if (cDFDataType == CDFDataType.DOUBLE || cDFDataType == CDFDataType.EPOCH || cDFDataType == CDFDataType.EPOCH16) {
            vDataContainer = variable.getDoubleContainer(null, true, byteOrder);
        }
        if (cDFDataType == CDFDataType.TT2000 || cDFDataType == CDFDataType.INT8) {
            vDataContainer = variable.getLongContainer(null, byteOrder);
        }
        if (cDFDataType == CDFDataType.CHAR) {
            vDataContainer = variable.getStringContainer(null);
        }
        return vDataContainer;
    }

    public void setLogger(Logger logger) {
        if (logger == null) {
            return;
        }
        CDFWriter.logger = logger;
    }

    public static void setLoggerLevel(Level level) {
        if (logger == anonymousLogger) {
            logger.setLevel(level);
        }
    }

    public static void addToDoNotCheckList(String string) {
        if (doNotCheckListGlobal.contains(string)) {
            return;
        }
        doNotCheckListGlobal.add(string);
    }

    public static void removeFromDoNotCheckList(String string) {
        if (!doNotCheckListGlobal.contains(string)) {
            return;
        }
        doNotCheckListGlobal.remove(string);
    }

    public String[] attributesInDoNotCheckList() {
        String[] stringArray = new String[doNotCheckListGlobal.size()];
        doNotCheckListGlobal.toArray(stringArray);
        return stringArray;
    }

    SparseRecordOption sparseRecordOption(GenericReader genericReader, String string) throws CDFException.ReaderError {
        if (genericReader.missingRecordValueIsPad(string)) {
            return SparseRecordOption.PADDED;
        }
        if (genericReader.missingRecordValueIsPrevious(string)) {
            return SparseRecordOption.PREVIOUS;
        }
        return SparseRecordOption.NONE;
    }

    void checkLastLeapSecondId(GenericReader genericReader) throws CDFException.WriterError {
        if (this.lastLeapSecondId == -1) {
            this.lastLeapSecondId = genericReader.getLastLeapSecondId();
        } else if (this.lastLeapSecondId != genericReader.getLastLeapSecondId()) {
            throw new CDFException.WriterError("LastLeapSecondId " + genericReader.getLastLeapSecondId() + " does not match previously found " + this.lastLeapSecondId);
        }
    }

    static {
        logger = anonymousLogger = Logger.getAnonymousLogger();
        doNotCheckListGlobal = new ArrayList<String>();
        doNotCheckListGlobal.add("Logical_file_id");
        doNotCheckListGlobal.add("Generation_date");
        doNotCheckListGlobal.add("Software_version");
    }

    static class Selector
    implements SelectedVariableCollection {
        HashMap<String, Boolean> map = new HashMap();
        HashMap<String, SparseRecordOption> smap = new HashMap();

        Selector() {
        }

        @Override
        public void add(String string, boolean bl) {
            this.map.put(string, new Boolean(bl));
        }

        @Override
        public void add(String string, boolean bl, SparseRecordOption sparseRecordOption) {
            this.add(string, bl);
            this.smap.put(string, sparseRecordOption);
        }

        @Override
        public boolean isCompressed(String string) {
            return this.map.get(string);
        }

        @Override
        public SparseRecordOption getSparseRecordOption(String string) {
            if (this.smap.get(string) == null) {
                return SparseRecordOption.PADDED;
            }
            return this.smap.get(string);
        }

        @Override
        public String[] getNames() {
            String[] stringArray = new String[this.map.size()];
            Set<String> set = this.map.keySet();
            set.toArray(stringArray);
            return stringArray;
        }

        @Override
        public boolean hasVariable(String string) {
            return this.map.get(string) != null;
        }
    }
}

