#!/usr/bin/perl -w

use strict;
use Math::BigInt;
use Data::Dumper;

BEGIN { unshift @INC,'/home/liu/PerlCDF38_0/blib/arch',
                     '/home/liu/PerlCDF38_0/blib/lib'; }
use CDF;

print "last index # of input: $#ARGV\n";

my $id;
my $status;
my %info;
my @values;
$status = CDF::CDFlib (&OPEN_, &CDF_, $ARGV[0], \$id,
		       &NULL_);
QuitCDF ("4.0", $status) if ($status < &CDF_OK);

#print "get varinfo 1...\n";
#($status, %info) = CDF::CDFgetVarInfo($ARGV[0], $ARGV[1]);

#if ($status == &CDF_OK) {
#  print Dumper(\%info);
#} else {
#  QuitCDF ("28.0", $status);
#}
print "get varinfo 2...\n";
($status, %info) = CDF::CDFgetVarInfo($id, $ARGV[1]);

if ($status == &CDF_OK) {
  print Dumper(\%info);
} else {
  QuitCDF ("28.1", $status);
}

print "Trying vector 1...\n";
($status, @values) = CDF::CDFgetVarAllData($id, $ARGV[1]);

if ($status >= &CDF_OK) {
  print Dumper(\@values);
} else {
  QuitCDF ("28.2", $status);
}
print "Trying vector 2...\n";
#($status, @values) = CDF::CDFgetVarAllData($ARGV[0], $ARGV[1]);

#if ($status >= &CDF_OK) {
#  print Dumper(\@values);
#} else {
#  QuitCDF ("28.3", $status);
#}
#
if ($#ARGV == 2) {
print "\nTrying dataEncoding...\n";
my @values2 = ();
($status, @values2) = CDF::CDFgetVarAllData($id, $ARGV[1], $ARGV[2]);
print Dumper(\@values2);
}

if ($#ARGV == 3) {
print "\nTrying matrix...\n";
my @values2 = ();
($status, @values2) = CDF::CDFgetVarAllData($id, $ARGV[1], $ARGV[2], $ARGV[3]);
print Dumper(\@values2);
}

$status = CDF::CDFlib (&CLOSE_, &CDF_,
		       &NULL_);
QuitCDF ("28.4", $status) if ($status < &CDF_OK) ;

exit;

#############################################################################
# QuitCDF.
#############################################################################
sub QuitCDF {
	my ($where, $status)=@_;

  print "Aborting at $where ...\n";
  if ($status < &CDF_OK) {
    my $text;
    CDF::CDFlib (&SELECT_, &CDF_STATUS_, $status,
		   &GET_, &STATUS_TEXT_, \$text,
		   &NULL_);
    print $text;
  }
  CDF::CDFlib (&CLOSE_, &CDF_,
	  &NULL_);
  print "...test aborted.\n";
  exit;
	
}#endsub QuitCDF

