#!/usr/bin/perl -w

use strict;
use Math::BigInt;
use Data::Dumper;

BEGIN { unshift @INC,'/home/liu/PerlCDF38_0/blib/arch',
                     '/home/liu/PerlCDF38_0/blib/lib'; }
use CDF;

my $id;
my $status;
$status = CDF::CDFlib (&OPEN_, &CDF_, $ARGV[0], \$id,
		       &NULL_);
QuitCDF ("4.0", $status) if ($status < &CDF_OK) ;

my $md5;
$status = CDF::CDFgetChecksum ($id, \$md5);

print "status=$status checksum = $md5\n";
my %meta;

print "global 1....\n";
($status, %meta) = CDF::CDFgetGlobalMetaData($id);

if ($status == &CDF_OK && %meta ) {
  print Dumper(\%meta);
} else {
  if ($status != 0) {
    QuitCDF ("8.1", $status);
  }
}
print "global 2....\n";
($status, %meta) = CDF::CDFgetGlobalMetaData($ARGV[0]);

if ($status == &CDF_OK && %meta ) {
  print Dumper(\%meta);
} else {
  if ($status != 0) {
    QuitCDF ("8.1", $status);
  }
}

if ($#ARGV == 1) {
print "variable .....\n";

($status, %meta) = CDF::CDFgetVarMetaData($id, $ARGV[1]);

if ($status == &CDF_OK && %meta) {
  print Dumper(\%meta);
} else {
  if ($status != 0) {
    QuitCDF ("8.2", $status);
  }
}
}
if ($#ARGV == 2) {
print "variable with encoding....\n";
($status, %meta) = CDF::CDFgetVarMetaData($id, $ARGV[1], $ARGV[2]);

if ($status == &CDF_OK && %meta) {
  print Dumper(\%meta);
} else {
  if ($status != 0) {
    QuitCDF ("8.2", $status);
  }
}
}
$status = CDF::CDFlib (&CLOSE_, &CDF_,
		       &NULL_);
QuitCDF ("28.2", $status) if ($status < &CDF_OK) ;

exit;

#############################################################################
# QuitCDF.
#############################################################################
sub QuitCDF {
	my ($where, $status)=@_;

  print "Aborting at $where ...\n";
  if ($status < &CDF_OK) {
    my $text;
    CDF::CDFlib (&SELECT_, &CDF_STATUS_, $status,
		   &GET_, &STATUS_TEXT_, \$text,
		   &NULL_);
    print $text;
  }
  CDF::CDFlib (&CLOSE_, &CDF_,
	  &NULL_);
  print "...test aborted.\n";
  exit;
	
}#endsub QuitCDF

