#! /bin/sh
search="<cdf_install_dir>"
replace=$1   # Current working directory

for file in `ls $replace/bin/definitions.*`
do
       echo "Modifying the definition file $file .."
       if `type ed > /dev/null 2>&1`
       then
         ed - $file << editend
         1,\$s:$search:$replace:g
         w
         q
editend
       elif `type sed > /dev/null 2>&1`
         then
           sed -e "s,$search,$replace,g" < $file > $file.new
           mv $file.new $file
       else
           echo Not modified... as both "ed" and "sed" line editor not installed.
           echo Use any available text editor to manually modify "$search" to "$replace".
       fi
done

