/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MYEditor
extends JDialog
implements CDFConstants {
    public static int WIDTH = 800;
    public static int HEIGHT = 640;
    public static int INITIAL_WIDTH = 300;
    public static int INITIAL_HEIGHT = 100;
    public static final Insets insets0 = new Insets(0, 0, 0, 0);
    public static final Insets insets2 = new Insets(2, 2, 2, 2);
    public static final Insets insets5 = new Insets(5, 5, 5, 5);
    public static final Insets insets10 = new Insets(10, 10, 10, 10);
    public static final Insets insets15 = new Insets(15, 15, 15, 15);
    public static final Insets insets20 = new Insets(20, 20, 20, 20);
    public static final Border emptyBorder0 = new EmptyBorder(0, 0, 0, 0);
    public static final Border emptyBorder2 = new EmptyBorder(2, 2, 2, 2);
    public static final Border emptyBorder5 = new EmptyBorder(5, 5, 5, 5);
    public static final Border emptyBorder10 = new EmptyBorder(10, 10, 10, 10);
    public static final Border emptyBorder15 = new EmptyBorder(15, 15, 15, 15);
    public static final Border emptyBorder20 = new EmptyBorder(20, 20, 20, 20);
    public static final Border etchedBorder2 = new CompoundBorder(new EtchedBorder(), emptyBorder2);
    public static final Border etchedBorder5 = new CompoundBorder(new EtchedBorder(), emptyBorder5);
    public static final Border etchedBorder10 = new CompoundBorder(new EtchedBorder(), emptyBorder10);
    public static final Border raisedBorder = new BevelBorder(0);
    public static final Border lightLoweredBorder = new BevelBorder(1, Color.white, Color.gray);
    public static final Border loweredBorder = new SoftBevelBorder(1);
    private static Dimension screenSize;
    static boolean defaultModal;
    public CDF theCDF;
    protected CDFEdit cdfedit;
    protected File theFile;
    private String filename;
    private String rootfilename;
    private String cdfspec;
    private String logicalFilename;
    protected String ext;
    private boolean saveAsOnClose;
    private File workingDirectory;
    public JDialog frame;
    public Font defaultFont;
    public Font boldFont;
    public Font bigFont;
    public Font bigBoldFont;
    public Font reallyBigFont;
    public Font reallyBigBoldFont;
    public AttributePanel gAttrPanel;
    public AttributePanel vAttrPanel;
    public VariablePanel variablePanel;
    private JPanel jp;
    public JTabbedPane tabbedPane;
    private JFileChooser chooser;
    protected EditCDFSpecAction editCDFAction;
    protected EditVariableAction editVarAction;
    protected EditAttrEntriesAction editgAttrEntriesAction;
    protected EditAttrEntriesAction editvAttrEntriesAction;
    private JMenuItem save;
    private JMenuItem saveAs;
    private JMenuItem close;
    private JMenu fileMenu;
    private JMenu variableMenu;
    private JMenu gAttributeMenu;
    private JMenu vAttributeMenu;
    protected MYEditor instance;

    JMenuBar buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = jMenuBar.add(new JMenu("File"));
        this.fileMenu.setMnemonic('F');
        this.save = this.fileMenu.add(new SaveAction(this));
        this.save.setToolTipText("Save the file and stay current file editing");
        this.save.setMnemonic(83);
        this.save.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.save.setEnabled(true);
        this.saveAs = this.fileMenu.add(new SaveAsAction(this));
        this.saveAs.setToolTipText("Save the file with a new name");
        this.saveAs.setMnemonic('A');
        this.saveAs.setEnabled(true);
        this.fileMenu.add(new JSeparator());
        this.editCDFAction = new EditCDFSpecAction(this);
        JMenuItem jMenuItem = this.fileMenu.add(this.editCDFAction);
        jMenuItem.setToolTipText("Edit the CDF specification");
        jMenuItem.setMnemonic(69);
        jMenuItem.setEnabled(true);
        jMenuItem = this.fileMenu.add(new ExitAction(this));
        jMenuItem.setToolTipText("Save changes and exit the current file editing");
        jMenuItem.setMnemonic(88);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.fileMenu.setEnabled(true);
        this.gAttributeMenu = jMenuBar.add(new JMenu("gAttributes"));
        this.gAttributeMenu.setMnemonic('G');
        jMenuItem = this.gAttributeMenu.add(new NewAttributeAction(this.gAttrPanel, 'g'));
        jMenuItem.setMnemonic('N');
        jMenuItem.setEnabled(true);
        jMenuItem = this.gAttributeMenu.add(new DeleteAttributeAction(this.gAttrPanel, 'g'));
        jMenuItem.setMnemonic('D');
        jMenuItem.setEnabled(false);
        jMenuItem = this.gAttributeMenu.add(new RenameAttributeAction(this.gAttrPanel, 'g'));
        jMenuItem.setMnemonic('R');
        jMenuItem.setEnabled(false);
        this.gAttributeMenu.add(new JSeparator());
        this.editgAttrEntriesAction = new EditAttrEntriesAction(this.gAttrPanel, 'g');
        jMenuItem = this.gAttributeMenu.add(this.editgAttrEntriesAction);
        jMenuItem.setMnemonic('E');
        jMenuItem.setEnabled(false);
        this.gAttributeMenu.setEnabled(true);
        this.vAttributeMenu = jMenuBar.add(new JMenu("vAttributes"));
        this.vAttributeMenu.setMnemonic('V');
        jMenuItem = this.vAttributeMenu.add(new NewAttributeAction(this.vAttrPanel, 'v'));
        jMenuItem.setMnemonic('N');
        jMenuItem.setEnabled(true);
        jMenuItem = this.vAttributeMenu.add(new DeleteAttributeAction(this.vAttrPanel, 'v'));
        jMenuItem.setMnemonic('D');
        jMenuItem.setEnabled(false);
        jMenuItem = this.vAttributeMenu.add(new RenameAttributeAction(this.vAttrPanel, 'v'));
        jMenuItem.setMnemonic('R');
        jMenuItem.setEnabled(false);
        this.vAttributeMenu.add(new JSeparator());
        this.editvAttrEntriesAction = new EditAttrEntriesAction(this.vAttrPanel, 'v');
        jMenuItem = this.vAttributeMenu.add(this.editvAttrEntriesAction);
        jMenuItem.setMnemonic('E');
        jMenuItem.setEnabled(false);
        this.vAttributeMenu.setEnabled(false);
        this.variableMenu = jMenuBar.add(new JMenu("zVariables"));
        this.variableMenu.setMnemonic('Z');
        jMenuItem = this.variableMenu.add(new NewVariableAction(this));
        jMenuItem.setMnemonic('N');
        jMenuItem.setEnabled(true);
        jMenuItem = this.variableMenu.add(new CopyVariableAction(this));
        jMenuItem.setMnemonic('C');
        jMenuItem.setEnabled(false);
        jMenuItem = this.variableMenu.add(new DeleteVariableAction(this));
        jMenuItem.setMnemonic('D');
        jMenuItem.setEnabled(false);
        jMenuItem = this.variableMenu.add(new RenameVariableAction(this));
        jMenuItem.setMnemonic('R');
        jMenuItem.setEnabled(false);
        this.variableMenu.add(new JSeparator());
        this.editVarAction = new EditVariableAction(this);
        jMenuItem = this.variableMenu.add(this.editVarAction);
        jMenuItem.setMnemonic('E');
        jMenuItem.setEnabled(false);
        this.variableMenu.setEnabled(false);
        return jMenuBar;
    }

    public void buildEditFrame() {
        this.frame.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.frame.setSize(WIDTH, HEIGHT);
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation(MYEditor.screenSize.width / 2 - WIDTH / 2, MYEditor.screenSize.height / 2 - HEIGHT / 2);
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)this.jp, "Center");
        this.frame.pack();
        ((CDFEdit)this.getFrame()).getDialog().setVisible(false);
        this.frame.setVisible(true);
        this.jp.requestDefaultFocus();
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
    }

    public MYEditor sharedInstance() {
        return this.instance;
    }

    public Container getRootComponent() {
        return this.cdfedit;
    }

    public JFrame getFrame() {
        return this.cdfedit;
    }

    public void saveFile(String string) throws CDFException, IOException, InterruptedException {
        this.variablePanel.saveVariableChanges();
        if (string != null) {
            this.filename = string;
            this.theFile = new File(this.filename);
            if (string.toLowerCase().indexOf(".cdf") != -1) {
                this.rootfilename = string.substring(0, string.length() - 4);
                this.ext = string.toLowerCase().substring(string.length() - 4);
            } else {
                this.rootfilename = string;
                this.ext = ".cdf";
            }
            this.getFrame().setTitle("MYEditor: " + this.theFile.getName());
        }
        this.theCDF.save();
        if (!this.rootfilename.equals(this.cdfspec)) {
            this.copyFile(this.cdfspec + ".cdf", this.rootfilename + ".cdf");
        }
        this.save.setEnabled(true);
        this.saveAsOnClose = false;
    }

    public void closeFile() throws CDFException, IOException, InterruptedException {
        this.theCDF.close();
        this.theCDF = null;
    }

    private final void copyFile(String string, String string2) throws IOException {
        int n;
        File file = new File(string);
        File file2 = new File(string2);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        byte[] byArray = new byte[4096];
        while ((n = bufferedInputStream.read(byArray, 0, 4096)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }

    public void setWorkingDir(File file) {
        this.workingDirectory = file;
    }

    public File getWorkingDir() {
        return this.workingDirectory;
    }

    public boolean shouldSaveAs() {
        return this.saveAsOnClose;
    }

    public String getLogicalFilename() {
        return this.logicalFilename;
    }

    private final void createTabListener() {
        ChangeListener changeListener = new ChangeListener(){

            public final void stateChanged(ChangeEvent changeEvent) {
                if (MYEditor.this.gAttributeMenu.isPopupMenuVisible()) {
                    MYEditor.this.gAttributeMenu.setPopupMenuVisible(false);
                } else if (MYEditor.this.vAttributeMenu.isPopupMenuVisible()) {
                    MYEditor.this.vAttributeMenu.setPopupMenuVisible(false);
                } else if (MYEditor.this.variableMenu.isPopupMenuVisible()) {
                    MYEditor.this.variableMenu.setPopupMenuVisible(false);
                }
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                if (n == 0) {
                    MYEditor.this.gAttributeMenu.setEnabled(true);
                    MYEditor.this.vAttributeMenu.setEnabled(false);
                    MYEditor.this.variableMenu.setEnabled(false);
                } else if (n == 1) {
                    MYEditor.this.vAttributeMenu.setEnabled(true);
                    MYEditor.this.gAttributeMenu.setEnabled(false);
                    MYEditor.this.variableMenu.setEnabled(false);
                } else {
                    MYEditor.this.variableMenu.setEnabled(true);
                    MYEditor.this.gAttributeMenu.setEnabled(false);
                    MYEditor.this.vAttributeMenu.setEnabled(false);
                }
                Component component = jTabbedPane.getComponentAt(n);
            }
        };
        this.tabbedPane.addChangeListener(changeListener);
    }

    public void setWaitCursor() {
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setDefaultCursor() {
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
    }

    public JFileChooser getFileChooser() {
        return this.chooser;
    }

    public File getFile() {
        return this.theFile;
    }

    public void enableSaving(boolean bl) {
        this.save.setEnabled(bl ^ true);
        this.saveAs.setEnabled(true);
        this.close.setEnabled(true);
    }

    public void enableVarMenu() {
        Component[] componentArray = this.variableMenu.getMenuComponents();
        int n = 1;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(true);
            ++n;
        }
    }

    public void enablegAttrMenu() {
        Component[] componentArray = this.gAttributeMenu.getMenuComponents();
        int n = 1;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(true);
            ++n;
        }
    }

    public void enablevAttrMenu() {
        Component[] componentArray = this.vAttributeMenu.getMenuComponents();
        int n = 1;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(true);
            ++n;
        }
    }

    public void disableSaving() {
        this.save.setEnabled(false);
        this.saveAs.setEnabled(false);
        this.close.setEnabled(false);
    }

    public void disableVarMenu() {
        Component[] componentArray = this.variableMenu.getMenuComponents();
        int n = 1;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(false);
            ++n;
        }
    }

    public void disablegAttrMenu() {
        Component[] componentArray = this.gAttributeMenu.getMenuComponents();
        int n = 1;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(false);
            ++n;
        }
    }

    public void disablevAttrMenu() {
        Component[] componentArray = this.vAttributeMenu.getMenuComponents();
        int n = 1;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(false);
            ++n;
        }
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    private final /* synthetic */ void this() {
        this.saveAsOnClose = false;
        this.defaultFont = new Font("Dialog", 0, 12);
        this.boldFont = new Font("Dialog", 1, 12);
        this.bigFont = new Font("Dialog", 0, 18);
        this.bigBoldFont = new Font("Dialog", 1, 18);
        this.reallyBigFont = new Font("Dialog", 0, 18);
        this.reallyBigBoldFont = new Font("Dialog", 1, 24);
    }

    public MYEditor(CDFEdit cDFEdit, String string) {
        this(cDFEdit, string, defaultModal);
    }

    public MYEditor(CDFEdit cDFEdit, String string, boolean bl) {
        super((Frame)cDFEdit, bl);
        this.this();
        this.setTitle("CDF: " + string);
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        this.instance = this;
        this.cdfedit = cDFEdit;
        this.cdfspec = string;
        this.frame = this;
        this.theCDF = cDFEdit.sourceCDF;
        this.theFile = new File(string);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.jp = new JPanel(true);
        this.jp.setName("Main MYEditor Panel");
        this.jp.setFont(this.bigFont);
        this.jp.setLayout(new BorderLayout());
        this.workingDirectory = new File(System.getProperty("user.dir").toString());
        this.chooser = new JFileChooser();
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter("cdf", "Common Data Format Files");
        this.chooser.setDialogType(0);
        this.chooser.setFileSelectionMode(0);
        this.chooser.setFileHidingEnabled(true);
        this.chooser.addChoosableFileFilter(simpleFileFilter);
        this.chooser.setFileFilter(simpleFileFilter);
        this.chooser.setCurrentDirectory(this.getWorkingDir());
        this.tabbedPane = new JTabbedPane();
        this.jp.add((Component)this.tabbedPane, "Center");
        this.gAttrPanel = new AttributePanel(this, 1L);
        this.tabbedPane.addTab("Global Attributes", null, this.gAttrPanel, "Global Attributes display/editing");
        this.vAttrPanel = new AttributePanel(this, 2);
        this.tabbedPane.addTab("Variable Attributes", null, this.vAttrPanel, "Variable Attributes display/editing");
        this.variablePanel = new VariablePanel(this);
        this.tabbedPane.addTab("Variables", null, this.variablePanel, "Variable data display/editing");
        this.createTabListener();
        this.setJMenuBar(this.buildMenuBar());
        this.buildEditFrame();
    }

    static {
        defaultModal = true;
    }
}

