# NOTE: Derived from blib/lib/CDF.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package CDF;

#line 2030 "blib/lib/CDF.pm (autosplit into blib/lib/auto/CDF/CDFgetVarMetaData.al)"
sub CDFgetVarMetaData {
        use strict;
        my @args = @_;
        my $cdf = $args[0];
        my $var = $args[1];
        my $metaEncoding = 1;
        if (scalar(@_) > 2) { 
          $metaEncoding = $args[2];
          if ($metaEncoding != 0) {
            $metaEncoding = 1;
          }
        }
        my $id;
        my ($toClose, $varNum, $varName, $status, $numAttrs,$zMode);
        my %metax = ();
        $toClose = 0;
        if ($cdf =~ /^\d+$/) {
          $status = CDFlib(&SELECT_, &CDF_, $cdf,
                           &NULL_);
          if ($status != &CDF_OK) {
            $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                             &NULL_);
            $toClose = 1;
          }
        } else {
          $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                           &NULL_);
          $toClose = 1;
        }
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        $status = CDFlib(&CONFIRM_, &CDF_zMODE_, \$zMode,
                         &GET_, &CDF_NUMATTRS_, \$numAttrs,
                         &SELECT_, &CDF_zMODE_, &zMODEon2,
                         &NULL_);
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        my $check = 0;
        if ($var =~ /^\d+$/) {
          $varNum = $var;
          $status = CDFlib(&SELECT_, &zVAR_, $varNum,
                           &GET_, &zVAR_NAME_, \$varName,
                           &NULL_);
          if ($status == &CDF_OK) {
            $check++;
          }
        }
        if ($check == 0) {
          $varName = $var;
          $status = CDFlib(&GET_, &zVAR_NUMBER_, $varName, \$varNum,
                           &NULL_);
          if ($status != &CDF_OK) {
            if ($toClose == 1) {
              $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
            }
            return (&BAD_VAR_NAME, ());
          }
        }
        my ($i, $scope, $attrName, $entry, $dataType, $numElems);
        for ($i = 0; $i < $numAttrs; $i++) {
          my @entry2 = ();
          $status = CDFlib(&SELECT_, &ATTR_, $i,
                           &GET_, &ATTR_SCOPE_, \$scope,
                                  &ATTR_NAME_, \$attrName,
                           &NULL_);
          if ($scope == &GLOBAL_SCOPE) {
            next;
          } else {
            $status = CDFlib(&SELECT_, &zENTRY_, $varNum,
                             &GET_, &zENTRY_DATATYPE_, \$dataType,
                                    &zENTRY_NUMELEMS_, \$numElems,
                             &NULL_);
            if ($status != &CDF_OK) {
              next;
            }
            if ($dataType == &CDF_EPOCH16 || ($dataType != &CDF_CHAR &&
                                              $dataType != &CDF_UCHAR &&
                                              $numElems > 1)) {
              $status = CDFlib(&GET_, &zENTRY_DATA_, \@entry2,
                               &NULL_);
            } else {
              $status = CDFlib(&GET_, &zENTRY_DATA_, \$entry,
                               &NULL_);
            }
            if ($metaEncoding == 1) {
              if ($dataType == &CDF_EPOCH) {
                if ($numElems == 1) {
                  my $epoch;
                  toEncodeEPOCH ($entry, 4, $epoch);
                  $metax{$attrName} = $epoch;
                } else {
                  my @epoch;
                  toEncodeEPOCH (\@entry2, 4, \@epoch);
                  $metax{$attrName} = \@epoch;
                }
              } elsif ($dataType == &CDF_EPOCH16) {
                if ($numElems == 1) {
                  my $epoch2;
                  toEncodeEPOCH16 (\@entry2, 4, $epoch2);
                  $metax{$attrName} = $epoch2;
                } else {
                  my @epoch2;
                  toEncodeEPOCH16 (\@entry2, 4, \@epoch2);
                  $metax{$attrName} = \@epoch2;
                }
              } elsif ($dataType == &CDF_TIME_TT2000) {
                if ($numElems == 1) {
                  my $epoch;
                  toEncodeTT2000 ($entry, 3, $epoch);
                  $metax{$attrName} = $epoch;
                } else {
                  my @epoch;
                  toEncodeTT2000 (\@entry2, 3, \@epoch);
                  $metax{$attrName} = \@epoch;
                }
              } else {
                if ($numElems == 1 || ($dataType == &CDF_CHAR ||
                                       $dataType == &CDF_UCHAR)) {
                  $metax{$attrName} = $entry;
                } else {
                  $metax{$attrName} = \@entry2;
                }
              }
            } else {
              if ($dataType == &CDF_EPOCH16 || ($dataType != &CDF_CHAR &&
                                                $dataType != &CDF_UCHAR &&
                                                $numElems > 1)) {
                $metax{$attrName} = \@entry2;
              } else { 
                $metax{$attrName} = $entry;
              }
            }
          }
        }
        if ($toClose == 1) {
          $status = CDFlib (&CLOSE_, &CDF_, &NULL_);
        } else {
          $status = CDFlib (&SELECT_, &CDF_zMODE_, $zMode,
                            &NULL_);
        }
        return (&CDF_OK, %metax);
}#end sub CDFgetVarMetaData

# end of CDF::CDFgetVarMetaData
1;
