# NOTE: Derived from blib/lib/CDF.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package CDF;

#line 2682 "blib/lib/CDF.pm (autosplit into blib/lib/auto/CDF/CDFgetVarAllData.al)"
sub CDFgetVarAllData {
        use strict;
        my @args = @_;
        my $cdf = $args[0];
        my $var = $args[1];
        my ($toClose, $matrix, $dataEncoding);
        $toClose = 0;
        $matrix = 0;
        $dataEncoding = 0;
        if (scalar(@_) > 2) { 
          $dataEncoding = $args[2];
        }
        if (scalar(@_) > 3) {
          $matrix = $args[3];
        }

        my $id;
        my ($varNum, $status, $maxRec, $numDims, $varName, $dataType);
        my (@dimSizes, @dimIndices, @dimIntervals);
        my $zMode;
        my (@values, @outData);
        if ($cdf =~ /^\d+$/) {
          $status = CDFlib(&SELECT_, &CDF_, $cdf,
                           &NULL_);
          if ($status != &CDF_OK) {
            $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                             &NULL_);
            $toClose = 1;
          }
        } else {
          $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                           &NULL_);
          $toClose = 1;
        }
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        $status = CDFlib(&CONFIRM_, &CDF_zMODE_, \$zMode,
                         &SELECT_, &CDF_zMODE_, &zMODEon2,
                         &NULL_);
        if ($status != &CDF_OK) {
          if ($toClose == 1) {
            $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
          }
          return ($status, ());
        }
        my $check = 0;
        if ($var =~ /^\d+$/) {
          $varNum = $var;
          $status = CDFlib(&SELECT_, &zVAR_, $varNum,
                           &GET_, &zVAR_NAME_, $varName,
                           &NULL_);
          if ($status == &CDF_OK) {
            $check++;
          }
        }
        if ($check == 0) {
          $varName = $var;
          $status = CDFlib(&GET_, &zVAR_NUMBER_, $varName, \$varNum,
                           &NULL_);
          if ($status != &CDF_OK) {
            if ($toClose == 1) {
              $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
            }
            return (&BAD_VAR_NAME, ());
          }
        }
        $status = CDFlib (&SELECT_, &zVAR_, $varNum,
                          &GET_, &zVAR_DIMSIZES_, \@dimSizes,
                                 &zVAR_MAXREC_, \$maxRec,
                                 &zVAR_NUMDIMS_, \$numDims,
                                 &zVAR_DATATYPE_, \$dataType,
                          &NULL_);
        if ($status == &CDF_OK && $maxRec > -1) {
          my $i;
          if ($numDims > 0) {
            for ($i = 0; $i < $numDims; ++$i) {
              $dimIndices[$i] = 0;
              $dimIntervals[$i] = 1;
            }
          } else {
              $dimIndices[0] = 0;
              $dimIntervals[0] = 1;
          }
          $status = CDFlib (&SELECT_, &zVAR_RECNUMBER_, 0,
                                      &zVAR_RECCOUNT_, ($maxRec + 1),
                                      &zVAR_RECINTERVAL_, 1,
                                      &zVAR_DIMINDICES_, \@dimIndices,
                                      &zVAR_DIMCOUNTS_, \@dimSizes,
                                      &zVAR_DIMINTERVALS_, \@dimIntervals,
                            &NULL_);
          $status = CDFlib2(&GET_, &zVAR_HYPERDATA_,\@values);
          if ($dataType == &CDF_EPOCH) {
            toEncodeEPOCH(\@values, 4, \@outData);
          } elsif ($dataType == &CDF_TIME_TT2000) {
            toEncodeTT2000(\@values, 3, \@outData);
          } elsif ($dataType == &CDF_EPOCH16) {
            toEncodeEPOCH16(\@values, 4, \@outData);
          } else {
            @outData = @values;
          }
          if ($status >= &CDF_OK && $matrix == 1) {
            if ($dataType == &CDF_EPOCH16 && $dataEncoding != 1) {
              if ($numDims == 0) {
                $dimSizes[0] = 2;
              } else {
                push @dimSizes, 2;
              }
              $numDims++;
            }
            my $numRecs = $maxRec + 1;
            if ($numDims > 0) {
              if ($numRecs > 1) {
                unshift @dimSizes, $numRecs;
              }
              my $matrixOut = make_matrix(\@dimSizes, \@outData);
              @outData = @$matrixOut;
            }
          }
        } else {
          @outData = ();
        }
        if ($toClose == 1) {
          $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
        } else {
          $status = CDFlib (&SELECT_, &CDF_zMODE_, $zMode,
                            &NULL_);
        }
        return ($status, @outData);
}#end sub CDFgetVarAllData

# end of CDF::CDFgetVarAllData
1;
