//$Id: NewAttributeAction.java,v 1.1.1.1 2023/08/01 12:28:28 mhliu Exp $
/******************************************************************************
* Copyright 1996-2014 United States Government as represented by the
* Administrator of the National Aeronautics and Space Administration.
* All Rights Reserved.
******************************************************************************/

import javax.swing.*;

import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.util.Vector;
import java.util.Enumeration;

import gsfc.nssdc.cdf.*;

/**
 * Create a new attribute.
 *
 * @author Phil Williams 
 * @version $Revision: 1.1.1.1 $
 */
public class NewAttributeAction extends AbstractAction implements CDFConstants {
    
    static final long serialVersionUID = 1L;

    private static final String DEFAULT_NAME = "New Attribute";

    private MYEditor myEditor;
    private AttributePanel attrPanel;
    private char gORv;

    public NewAttributeAction(AttributePanel attrPanel, char gORv) {
	this(attrPanel, "New "+gORv+"Attribute");
	this.gORv = gORv;
    }

    public NewAttributeAction(AttributePanel attrPanel, String name) {
	super(name);
	this.attrPanel = attrPanel;
	myEditor = attrPanel.getMyEditor();
    }

    public void putValue(String key, Object value) {
	if (value != null)
	    super.putValue(key, value);
    }

    public void actionPerformed(ActionEvent event) {
	myEditor.setWaitCursor();
	if (myEditor.theCDF == null) {
	    Toolkit.getDefaultToolkit().beep();
	    JOptionPane.showMessageDialog(myEditor.sharedInstance(), 
					  "Must open a CDF before "+
					  "creating attributes.",
					  "MYEditor: Error",
					  JOptionPane.ERROR_MESSAGE);
	} else {
	    Attribute attr = 
		NewAttributeDialog.createAttribute((JFrame)myEditor.getFrame(),
					       	   myEditor.theCDF, "Create "+gORv+"Attribute",
						   attrPanel.getScope());
	    if (attr != null) {
		attrPanel.getCDFSpecPanel().set(myEditor.theCDF);
		attrPanel.updateAttrPanel(attr, true);
		attrPanel.updateListOfAttributes();
                if (attrPanel.getScope() == VARIABLE_SCOPE) {
		  myEditor.gAttrPanel.getCDFSpecPanel().set(myEditor.theCDF);
		  myEditor.gAttrPanel.getRightPanel().revalidate();
		  myEditor.gAttrPanel.getRightPanel().repaint();
		} else {
		  myEditor.vAttrPanel.getCDFSpecPanel().set(myEditor.theCDF);
		  myEditor.vAttrPanel.getRightPanel().revalidate();
		  myEditor.vAttrPanel.getRightPanel().repaint();
		}

                if (myEditor.variablePanel.getSelectedVar() != null) {
                  Variable selectedVar = myEditor.variablePanel.getSelectedVar();
                  myEditor.variablePanel.getvVarEntryTableScrollPane().buildTable(selectedVar);
                  myEditor.variablePanel.getRightPanel().revalidate();
                }

		attrPanel.reselectCurrentAttribute();
	    }
	}
	myEditor.setDefaultCursor();
    }

} // NewAttributeAction
