#!/usr/bin/perl -w

#
# testUTF8
#
#   This program writes/reads global attribute that has UTF8 strings.
#
#  Usage:
#     perl testUTF8.pl
#
#############################################################################

use strict;

BEGIN { unshift @INC,$ENV{"HOME"}.'/PerlCDF39_2/blib/arch',
                     $ENV{"HOME"}.'/PerlCDF39_2/blib/lib'; }
use CDF;

#############################################################################
# Display title.
#############################################################################

print "\nTesting UTF8 strings in Perl-CDF \n\n";

#############################################################################
# Create CDF. 
#############################################################################
# Uncomment the following line if you want to create a V2.7 CDF file.
#CDF::CDFsetFileBackward(1);

my $id; my $status;
my $numDims = 0;
my @dimSizes = (0);
$status = CDF::CDFlib(&CREATE_, &CDF_, "TUTF8",$numDims,\@dimSizes,\$id,
 		      &NULL_);
if ($status < &CDF_OK) {
  if ($status == &CDF_EXISTS) {
    $status = CDF::CDFlib (&OPEN_, &CDF_, "TUTF8", \$id,
			   &NULL_);
    QuitCDF("1.0", $status) if ($status < &CDF_OK) ;

    $status = CDF::CDFlib (&DELETE_, &CDF_,
			   &NULL_);
    QuitCDF ("1.1", $status) if ($status < &CDF_OK) ;

    $status = CDF::CDFlib (&CREATE_, &CDF_, "TUTF8", $numDims, \@dimSizes, \$id,
		    	   &NULL_);
    QuitCDF ("1.2", $status) if ($status < &CDF_OK) ;
  }
  else {
    QuitCDF ("1.3", $status);
    }
}

#############################################################################
# Create a global attribute.
#############################################################################

my $attrNum;
$status = CDF::CDFlib (&CREATE_, &ATTR_, "UTF8", &GLOBAL_SCOPE, \$attrNum,
		       &NULL_);
QuitCDF ("2.0", $status) if ($status < &CDF_OK) ;

#############################################################################
# Write the UTF8 string entries.
#############################################################################

my ($spdf1, $spdf2, $spdf3, $spdf1o, $spdf2o, $spdf3o);
my ($len1, $len2, $len3);

$spdf1 = "ASCII: ABCDEFG";
$spdf2 = "Latin1: © æ ê ü ÷ Æ ¼ ® ¢ ¥";
$spdf3 = "Chinese: 社安";

$len1 = length $spdf1;
$len2 = length $spdf2;
$len3 = length $spdf3;

print " spdf1=\"$spdf1\" byte_len=$len1 \n";
print " spdf2=\"$spdf2\" byte_len=$len2 \n";
print " spdf3=\"$spdf3\" byte_len=$len3 \n";

$status = CDF::CDFlib (&SELECT_, &ATTR_, $attrNum,
				 &gENTRY_, 0,
		       &PUT_, &gENTRY_DATA_, &CDF_CHAR, $len1, \$spdf1,
		       &SELECT_, &gENTRY_, 1,
		       &PUT_, &gENTRY_DATA_, &CDF_CHAR, $len2, \$spdf2,
		       &SELECT_, &gENTRY_, 2,
		       &PUT_, &gENTRY_DATA_, &CDF_CHAR, $len3, \$spdf3,
		       &NULL_);
QuitCDF ("2.1", $status) if ($status < &CDF_OK) ;

#############################################################################
# Close CDF.
#############################################################################

$status = CDF::CDFlib (&CLOSE_, &CDF_,
		       &NULL_);
QuitCDF ("3.0", $status) if ($status < &CDF_OK) ;

#############################################################################
# Reopen CDF.
#############################################################################

$status = CDF::CDFlib (&OPEN_, &CDF_, "TUTF8", \$id,
		       &NULL_);
QuitCDF ("4.0", $status) if ($status < &CDF_OK) ;

$status = CDF::CDFlib (&SELECT_, &ATTR_NAME_, "UTF8",
				 &gENTRY_, 0,
		       &GET_, &gENTRY_DATA_, \$spdf1o,
		       &SELECT_, &gENTRY_, 1,
		       &GET_, &gENTRY_DATA_, \$spdf2o,
		       &SELECT_, &gENTRY_, 2,
		       &GET_, &gENTRY_DATA_, \$spdf3o,
		       &NULL_);
QuitCDF ("5.0", $status) if ($status < &CDF_OK) ;

QuitCDF ("5.1", $status) if ($spdf1 ne $spdf1o) ;
QuitCDF ("5.2", $status) if ($spdf2 ne $spdf2o) ;
QuitCDF ("5.3", $status) if ($spdf3 ne $spdf3o) ;

#############################################################################
# Close CDF.
#############################################################################

$status = CDF::CDFlib (&CLOSE_, &CDF_,
		       &NULL_);
QuitCDF ("6.0", $status) if ($status < &CDF_OK) ;

#############################################################################
# Successful completion.
#############################################################################
print "All tests completed successfully\n";
exit;

#############################################################################
# QuitCDF.
#############################################################################
sub QuitCDF {
	my ($where, $status)=@_;

  print "Aborting at $where ...\n";
  if ($status < &CDF_OK) {
    my $text;
    CDF::CDFlib (&SELECT_, &CDF_STATUS_, $status,
		   &GET_, &STATUS_TEXT_, \$text,
		   &NULL_);
    print $text;
  }
  CDF::CDFlib (&CLOSE_, &CDF_,
	  &NULL_);
  print "...test aborted.\n";
  exit;
	
}#endsub QuitCDF
