#!/usr/bin/perl -w

use strict;
use Math::BigInt;
use Data::Dumper;

BEGIN { unshift @INC,$ENV{"HOME"}.'/PerlCDF39_2/blib/arch',
                     $ENV{"HOME"}.'/PerlCDF39_2/blib/lib'; }
use CDF;

my $id;
my $status;
my %info;
my @values;
$status = CDF::CDFlib (&OPEN_, &CDF_, $ARGV[0], \$id,
		       &NULL_);
QuitCDF ("1.0", $status) if ($status < &CDF_OK);

print "get varinfo 1...\n";
($status, %info) = CDF::CDFgetVarInfo($ARGV[0], $ARGV[1]);

if ($status == &CDF_OK) {
  print Dumper(\%info);
} else {
  QuitCDF ("2.0", $status);
}
print "get varinfo 2...\n";
($status, %info) = CDF::CDFgetVarInfo($id, $ARGV[1]);

if ($status == &CDF_OK) {
  print Dumper(\%info);
} else {
  QuitCDF ("3.0", $status);
}

print "Trying vector 1...  no metaencoding\n";
($status, @values) = CDF::CDFgetVarAllData($id, $ARGV[1]);

if ($status >= &CDF_OK) {
  print Dumper(\@values);
} else {
  QuitCDF ("4.0", $status);
}
print "Trying vector 2...  with metaencoding\n";
($status, @values) = CDF::CDFgetVarAllData($ARGV[0], $ARGV[1], 0, 1);

if ($status >= &CDF_OK) {
  print Dumper(\@values);
} else {
  QuitCDF ("5.0", $status);
}

print "\nTrying matrix...  no metaencoding\n";
my @values2 = ();
($status, @values2) = CDF::CDFgetVarAllData($id, $ARGV[1], 1);
print Dumper(\@values2);

$status = CDF::CDFlib (&CLOSE_, &CDF_,
		       &NULL_);
QuitCDF ("6.0", $status) if ($status < &CDF_OK) ;

exit;

#############################################################################
# QuitCDF.
#############################################################################
sub QuitCDF {
	my ($where, $status)=@_;

  print "Aborting at $where ...\n";
  if ($status < &CDF_OK) {
    my $text;
    CDF::CDFlib (&SELECT_, &CDF_STATUS_, $status,
		   &GET_, &STATUS_TEXT_, \$text,
		   &NULL_);
    print $text;
  }
  CDF::CDFlib (&CLOSE_, &CDF_,
	  &NULL_);
  print "...test aborted.\n";
  exit;
	
}#endsub QuitCDF

