'*****************************************************************************e
'
'  NSSDC/CDF                      Quick Start Test Program(VB interface).
'
'  Version 1.0,15-Jun-21,Mike Liu
'
'  Modification history:
'
'   V1.0   15-Jun-21,M Liu     Original version(for CDF V3.8).
'                              Create a global attribute to write 3 UTF8 
'                              strings:
'                                1. simple ASCII string
'                                2. Latin1i string
'                                3. A Chinese string
'
'*****************************************************************************/

Imports System
Imports System.Text
Imports System.Runtime.InteropServices
Imports CDF

public Class QstUTF8vb 
	Inherits CDFAPIs

 Public Shared Sub Main()
  Dim id As Long
  Dim status As Integer

  Dim attrNum, len1, len2, len3 As Integer
  Dim sb As StringBuilder = new StringBuilder()
  Dim t As byte

  Dim spdf1 As string = "ASCII: ABCDEFG"
  Dim spdf2 As string = "Latin1: ©æêü÷Æ¼®¢¥"
  Dim spdf3 As string = "Chinese: 社安"

  Dim spdf1o As string
  Dim spdf2o As string
  Dim spdf3o As string
  Dim args() As String = Environment.GetCommandLineArgs()
  Dim argn as Integer = args.Length

  len1 = Encoding.UTF8.GetByteCount(spdf1)
  len2 = Encoding.UTF8.GetByteCount(spdf2)
  len3 = Encoding.UTF8.GetByteCount(spdf3)

'******************************************************************************
' Display title.
'*****************************************************************************/

Console.WriteLine("Testing UTF8 in VB-CDF...")

'******************************************************************************
' Create CDF.
'*****************************************************************************/
Console.WriteLine("spdf1='{0}'   len={1} byte_len={2}",spdf1,spdf1.Length,len1)
Dim byte1s As byte() = Encoding.UTF8.getBytes(spdf1)
for each t in byte1s
  sb.Append(t.ToString("X2"))
Next
Console.WriteLine(" Hex value: "+sb.ToString())
sb.Length = 0
Console.WriteLine("spdf2='{0}'   len={1} byte_len={2}",spdf2,spdf2.Length,len2)
Dim byte2s As byte() = Encoding.UTF8.getBytes(spdf2)
for each t in byte2s
  sb.Append(t.ToString("X2"))
Next
Console.WriteLine(" Hex value: "+sb.ToString())
sb.Length = 0
' Need to chcp 936 to correctly show the Chinese
Console.WriteLine("spdf3='{0}'   len={1} byte_len={2}",spdf3,spdf3.Length,len3)
Dim byte3s As byte() = Encoding.UTF8.getBytes(spdf3)
for each t in byte3s
  sb.Append(t.ToString("X2"))
Next
Console.WriteLine(" Hex value: "+sb.ToString())
sb.Length = 0
id = 0
try
 status = CDFcreateCDF(if(argn=2,args(1),"TUTF8"),id)
catch ex As CDFException
  Dim stat As Integer
  stat = ex.CDFgetCurrentStatus()
  if stat < CDF_OK Then
    id = 0
    if stat = CDF_EXISTS Then
      status = CDFopen(if(argn=2,args(1),"TUTF8"),id)
      if status < CDF_OK Then
	QuitCDF("1.0",status,id)
      End if
      status = CDFdeleteCDF(id)
      if status < CDF_OK Then
	QuitCDF("1.1",status,id)
      End if
      status = CDFcreateCDF(if(argn=2,args(1),"TUTF8"),id)
      if status < CDF_OK Then
	QuitCDF("1.2",status,id)
      End if
    else
      QuitCDF("1.4",stat,id)
    End if
  End if
End Try

try

'******************************************************************************
' Create a global attribute.
'*****************************************************************************/

status = CDFattrCreate(id,"UTF8",GLOBAL_SCOPE,attrNum)

'******************************************************************************
' Add entries.
'*****************************************************************************/

status = CDFputAttrgEntry(id,attrNum,0,CDF_CHAR,len1,spdf1)
status = CDFputAttrgEntry(id,attrNum,1,CDF_CHAR,len2,spdf2)
status = CDFputAttrgEntry(id,attrNum,2,CDF_CHAR,len3,spdf3)

'******************************************************************************
' Close CDF.
'*****************************************************************************/

status = CDFcloseCDF(id)

'******************************************************************************
' Reopen CDF.
'*****************************************************************************/

status = CDFopen(if(argn=2,args(1),"TUTF8"),id)

'******************************************************************************
' Get global attribute entries.
'*****************************************************************************/
attrNum = CDFgetAttrNum(id,"UTF8")
status = CDFgetAttrgEntry(id,attrNum,0,spdf1o)
status = CDFgetAttrgEntry(id,attrNum,1,spdf2o)
status = CDFgetAttrgEntry(id,attrNum,2,spdf3o)

if spdf1<>spdf1o Then
  QuitCDF("26.1",status,id)
End if
if spdf2<>spdf2o Then
  QuitCDF("26.2",status,id)
End if
if spdf3<>spdf3o Then
  QuitCDF("26.3",status,id)
End if

'******************************************************************************
' Close CDF.
'*****************************************************************************/

status = CDFcloseCDF(id)  

'******************************************************************************
' Successful completion.
'*****************************************************************************/
catch ex As CDFException
  Console.WriteLine("Error...2 ")
finally
  try
    status = CDFselect(id)
    status = CDFcloseCDF(id)
  catch ey As CDFException
  End Try
End Try

End Sub


'******************************************************************************
' QuitCDF.
'*****************************************************************************/

Private Shared Sub QuitCDF(where As string, status as Integer, id As Long)
  Dim text As string
  Console.WriteLine("Aborting at "+where)
  if status < 0 Then
    status = CDFgetStatusText(status,text) 
    Console.WriteLine(" "+text)
  End if
  status = CDFcloseCDF(id)
  Console.WriteLine("...test aborted.")
  System.Environment.Exit(1)
End Sub

End Class

