using System;
using System.Runtime.InteropServices;
using CDF;

public class Qst2cEpoch16 : CDFAPIs {

unsafe public static void Main() {
int     year=2001,month=10,day=1,hour=12,minute=10,second=20,
	msec=100,usec=200,nsec=300,psec=400;
int     yearOut,monthOut,dayOut,hourOut,minuteOut,secondOut,msecOut,
	usecOut,nsecOut,psecOut;
double  mmm;
double[] epoch16 = new double[2],
         epoch16Save = new double[2];
string  encodeText;

/******************************************************************************
* Display title.
******************************************************************************/

Console.WriteLine("Testing C# interface for CDF_EPOCH16 ...");
try {
fixed(double* ptr = epoch16) {
  mmm = computeEPOCH16(year,month,day,hour,minute,second,msec,
                       usec,nsec,psec,ptr);
}
epoch16Save[0] = epoch16[0];
epoch16Save[1] = epoch16[1];

encodeEPOCH16(epoch16, out encodeText);
Console.WriteLine("encodeEPOCH16: "+encodeText);
encodeEPOCH16_x(epoch16,"<dom.02>-<month>-<year> <hour>:<min>:<sec>.<fos>",
                out encodeText);
Console.WriteLine("encodeEPOCH16_x: "+encodeText);
encodeEPOCH16_x(epoch16,
           "<dom.02>-<month>-<year> <hour>:<min>:<sec>.<msc>:<usc>:<nsc>:<psc>",
                out encodeText);
Console.WriteLine("encodeEPOCH16_x: "+encodeText);
encodeEPOCH16_1(epoch16,out encodeText);
Console.WriteLine("1. encodeEPOCH16_1: "+encodeText);
fixed(double* ptr = epoch16) {
  mmm = parseEPOCH16_1(encodeText,ptr);
}
encodeEPOCH16_1(epoch16,out encodeText);
Console.WriteLine("2. parseEPOCH16_1:  "+encodeText);

epoch16[0] = epoch16Save[0];
epoch16[1] = epoch16Save[1];
encodeEPOCH16_2(epoch16,out encodeText);
Console.WriteLine("3. encodeEPOCH16_2: "+encodeText);
fixed(double* ptr = epoch16) {
  mmm = parseEPOCH16_2(encodeText,ptr);
}
encodeEPOCH16_2(epoch16,out encodeText);
Console.WriteLine("4. parseEPOCH16_2:  "+encodeText);

epoch16[0] = epoch16Save[0];
epoch16[1] = epoch16Save[1];
encodeEPOCH16_3(epoch16,out encodeText);
Console.WriteLine("5. encodeEPOCH16_3: "+encodeText);
fixed(double* ptr = epoch16) {
  mmm = parseEPOCH16_3(encodeText,ptr);
}
encodeEPOCH16_3(epoch16,out encodeText);
Console.WriteLine("6. parseEPOCH16_3:  "+encodeText);

epoch16[0] = epoch16Save[0];
epoch16[1] = epoch16Save[1];
encodeEPOCH16_4(epoch16,out encodeText);
Console.WriteLine("7. encodeEPOCH16_4: "+encodeText);
fixed(double* ptr = epoch16) {
  mmm = parseEPOCH16_4(encodeText,ptr);
}
encodeEPOCH16_4(epoch16,out encodeText);
Console.WriteLine("8. parseEPOCH16_4:  "+encodeText);

epoch16[0] = epoch16Save[0];
epoch16[1] = epoch16Save[1];

EPOCH16breakdown(epoch16,&yearOut,&monthOut,&dayOut,&hourOut,
		 &minuteOut,&secondOut,&msecOut,&usecOut,&nsecOut,&psecOut);
if(year != yearOut) Quit("9.2a");
if(month != monthOut) Quit("9.3a");
if(day != dayOut) Quit("9.4a");
if(hour != hourOut) Quit("9.5a");
if(minute != minuteOut) Quit("9.6a");
if(second != secondOut) Quit("9.7a");
if(msec != msecOut) Quit("9.8a");
if(usec != usecOut) Quit("9.9a");
if(nsec != nsecOut) Quit("9.10a");
if(psec != psecOut) Quit("9.11a");

int yearOuto, monthOuto, dayOuto, hourOuto, minuteOuto, secondOuto, msecOuto,
       usecOuto, nsecOuto, psecOuto;
EPOCH16breakdown(epoch16,out yearOuto,out monthOuto,out dayOuto,out hourOuto,
		 out minuteOuto,out secondOuto,out msecOuto,out usecOuto,out nsecOuto,out psecOuto);
if(year != (int) yearOuto) Quit("10.2a");
if(month != (int) monthOuto) Quit("10.3a");
if(day != (int) dayOuto) Quit("10.4a");
if(hour != (int) hourOuto) Quit("10.5a");
if(minute != (int) minuteOuto) Quit("10.6a");
if(second != (int) secondOuto) Quit("10.7a");
if(msec != (int) msecOuto) Quit("10.8a");
if(usec != (int) usecOuto) Quit("10.9a");
if(nsec != (int) nsecOuto) Quit("10.10a");
if(psec != (int) psecOuto) Quit("10.11a");

} catch (CDFException ex) {
  Console.WriteLine("Error: "+ex);
}
}


/******************************************************************************
* Quit
******************************************************************************/

unsafe static void Quit(string where)
{
  Console.WriteLine("Aborting at "+where);
}

}


