/*****************************************************************************e
*
*  NSSDC/CDF                      Quick Start Test Program(C# interface).
*
*  Version 1.0,15-Oct-09,Mike Liu
*
*  Modification history:
*
*   V1.0   15-Oct-09,M Liu     Original version(for CDF V3.3).
*                              Using pointers (&) to pass arguments for 
*                              retrieving data fields and values to C# APIs.
*
******************************************************************************/

using System;
using System.Runtime.InteropServices;
using CDF;

public class Qst : CDFAPIs {

unsafe public static void Main(string[] args) {
  void* id;
  int status;

  int[]  indices = new int[1] {0};
  int[]  counts = new int[1] { 3 };
  int[]  intervals = new int[1] { 1 };
  string[] strings;
  string[] strings2;
  string entry1, entry2;

id = (void *) 0;
try {
status = CDFopen(args[0],&id);

/******************************************************************************
* HyperGET from variables.
******************************************************************************/
status = CDFhyperGetzVarData(id,0,0,1,1,
                             indices,counts,intervals,out strings);
Console.WriteLine("length="+strings.Length+" rank="+strings.Rank);
int x0;
for(x0 = 0; x0 < 3; x0++)
Console.WriteLine(""+x0+": "+((string[])strings)[x0]);
counts[0] =1;
status = CDFhyperGetzVarData(id,1,0,3,1,
                             indices,counts,intervals,out strings2);
Console.WriteLine("length="+strings2.Length+" rank="+strings2.Rank);
for(x0 = 0; x0 < 3; x0++)
Console.WriteLine(""+x0+": "+((string[])strings2)[x0]);;

status = CDFgetAttrzEntry(id,0,0, out entry1);
Console.WriteLine(" 0 0: "+entry1);

status = CDFgetAttrzEntry(id,1,1, out entry2);
Console.WriteLine(" 1 1: "+entry2);

status = CDFcloseCDF(id);  


/******************************************************************************
* Successful completion.
******************************************************************************/
} catch(CDFException ex) {
  Console.WriteLine("Error... "+ex);
} finally {
  try {
    status = CDFselect(id);
    status = CDFcloseCDF(id);
  } catch(CDFException ex) {}
}

}


/******************************************************************************
* QuitCDF.
******************************************************************************/

unsafe static void QuitCDF(string where, int status, void* id)
{
  string text;
  Console.WriteLine("Aborting at "+where);
  if(status < 0) {
    status = CDFgetStatusText(status,out text); 
    Console.WriteLine(" "+text);
  }
  status = CDFcloseCDF(id);
  Console.WriteLine("...test aborted.");
}

}

