## CDF

**Common Data Format (CDF)**

Maintained by Space Physics Data  Facility (SPDF) at
              Goddard Space Flight Center (GSFC), NASA
          (https://cdf.gsfc.nasa.gov)

### About

The Common Data Format (**CDF**) is an interface for
scientific data access and a freely-distributed software library that
provides an implementation of the interface.  The CDF library also
defines a machine-independent format for representing scientific data.
Together, the interface, library, and format support the creation,
access, and sharing of scientific data.  The current CDF software
provides C, FORTRAN, Java, Perl, C# and Python interfaces for applications
and data. They have been tested on various common platforms.

#### Properties

CDF files are 

* Self-Describing: Contains embedded metadata for context and semantics.
* Platform and Discipline Independent: Supports data from various disciplines and platforms.
* Compression Support: Includes built-in support for data compression (RLE, gZip, Huffman).
* Transparent Access: Provides an Application Programming Interface (API) for seamless access to data and metadata.
* Wide Software Support: Supported by various commercial and open-source data analysis and visualization software, including IDL, MATLAB, and Python libraries like CDFlib and SpacePy.
* Efficiency in Data Handling: The CDF library helps manage and manipulate multi-dimensional data arrays efficiently. 

#### Use

CDF is useful for supporting access to diverse kinds of scientific
data, especially space physics fields, in heterogeneous networking 
environments and for writing
application software that does not depend on application-specific
formats.  For information about a variety of analysis and display
packages that have been developed to analyze and display data in
CDF form, see

* [Software for Manipulating or Displaying CDF Data](https://spdf.gsfc.nasa.gov)

##### More information

For more information about CDF, see

* [Common Data Format (CDF)](https://cdf.gsfc.nasa.gov "CDF")

### Latest releases

You can obtain a copy of the latest released version of CDF
software for various languages:

* [C, FORTRAN, Java, Perl, C# library and utilities]
  (https://cdf.gsfc.nasa.gov "CDF latest release")

### Copyright

Copyright and licensing information can be found [here]
(https://cdf.gsfc.nasa.gov/html/cdf_copyright.html "CDF copyright"). 

### Download and Installation

To download the CDF software, please see the page in the 
CDF home page, or the (usually more its up-to-date) documents:

* [Building CDF](https://cdf.gsfc.nasa.gov/html/sw_and_docs.html)

To build the CDF, download the source package. For Mac OS X and windows 
ports, there are pre-built packages that users can choose to download.
These packages include the self-installer(s) to guide the installation.

Build
-----

There are **three** ways to build CDF:

* ## make (Makefile) for Unix-based or batch files for Windows

```
For Unix-based systems, 
follows the original cross-platform Makefiles used by any previous CDF
versions (V3.9.1 and earlier). The Makefiles have been renamed, each one
is appended with "-classic". This method uses the original zlib package.
This is mainly for Unix-based system.


```

Move into the top of the CDF source code distribution.

```
mkdir tomake
cd tomake
```

To get help information for available options,
  make -f ../Makefile-classic 

```
To build, test and install
  make -f ../Makefile-classic OS=.. ENV=.. [CURSES=..] [JNI=..]
                                           [JDK_HOME=..]
                                           [FORTRAN=..] .. all
  For
     Linux: OS=linux ENV=gnu
     Mac OS X: OS=macosx ENV=arm64 or x86_64 for Intel x86_64
     Cygwin: OS=cygwin ENV=gnu

  make -f ../Makefile-classic test
  make -f ../Makefile-classic [INSTALLDIR=...] installi
```

**Note**:

1. `make` variables, e.g., OS, ENV, etc, shall all be in upper case.  
2.  JDK\_HOME value needs to be double-quoted if its pathname contains a
    space(s). For example, for windows-based Cygwin, 
     JDK\_HOME="/cygdrive/c/Program Files/Eclipse Adoptium/jdk-8.0.462.8-hotspot"
3.  JDK\_HOME can be provided as an environment variable on Linux systems. For 
    Cygwin, please use the environment variable: ENV\_JDK\_HOME, instead.
    If INSTALLDIR is not specified, it will go into the current working 
    directory. Otherwise, provide a directory, e.g., ~/cdf39\_2-dist.  
4.  For debian/ubuntu linux, if (n)curses library is not installed. Use the 
    following command to install it (required system access privilege):
   
       sudo apt install libncurses5-dev
5.  For debian/ubuntu linux, if JNI (Java-Native Interface) is to be build, 
    jdk (not java) is needed. Use the following command to install it (for 
    version 21 or any other available version) if it is not installed (required 
    system access privilege) :
   
       sudo apt install openjdk-21-jdk

```
For windows, there are three (3) batch files that are for building,
testing and installing the CDF, respectively. While it is possible to
create 32-bit libraries, making 64-bit is strongely encoraged. 
```

Move into the **win32** directory from the top of the CDF source code 
distrobution. The build .bat files need to use Microsoft Visual Studio's
compiler, cl.exe, and linker, link.exe and lib.exe. To make them available
for the batch files: 

```
From MS VS 2002, 
  for 64-bit: run
    `"c:\Program Files\Microsoft visual studio\2022\Community\VC\Auxiliary\Build\vcvarsall.bat" amd64`
  for 32-bit: run
    `"c:\Program Files\Microsoft visual studio\2022\Community\VC\Auxiliary\Build\vcvarsall.bat" x86`
From MS VC 2015,
  for 64-bit: run
    `"c:\Program Files (x86)\Microsoft Visual Studio 14.0\VC\vcvarsall.bat" amd64`
  for 32-bit: run
    `"c:\Program Files (x86)\Microsoft Visual Studio 14.0\VC\vcvarsall.bat" x86`
```

```
mkdir tobuild
cd tobuild
```

```
To build:

   ..\win32\run\_build.bat [csharp] [jni [jdk=....]]

   Build the basic CDF libraries, tool and test programs. Optionally, use 
   the option(s) to add others:

   csharp: to build C#-CDF APIs
   jni: to build Java-CDF's Java Native Interface
   jdk: specify the JDK location. Use double-quote if there is a 
        space(s) in the name. Alternatively, an environment variable.
        "java\_jdk" can be defined within the command prompt Windows
        before calling the batch file.

To test:

   ..\win32\run\_tests.bat

To install:

   ..\win32\run\_install.bat [installdir=...]

   installdir: specify the location where the built CDF is to be installed.
               Use double-quote if there is any space(s) in the directory. 
               The default is to the current, working directory.
```

* ## Cmake
  
  ```
  To build CDF using the cross-platform makefile generator: cmake. Make sure 
  both cmake and C compiler are installed.
  ```
  
  Move into the top of the CDF source code distribution.

```
mkdir tocmake 
cd tocmake
```

To clean up the old stuff if they exist (when rebuild):
  rm -R -f * (Linux-like)
  del /f /s /Q * (Windows)

```
cmake [-DCMAKE\_INSTALL\_PREFIX=....] [-DJNI=[0|1]] [-DJDK\_HOME=...]
      [-DZLIB=[orig|ng] [-DABI=[x86_64|m32]] [-DFORTRAN=[0|1]] 
      [-DCsharp=[0|1]] .. [-G ...]

cmake --build . [--config Release for Windows]
ctest [--verbose] [-C Release for Windows]
cmake --install .
```

### cmake Options

    CMAKE\_INSTALL\_PREFIX - the location of the installation. The default is
                            /usr/local for non-Windows and 
                            c:\Program Files\CDF for Windows, 
                           which needs to have elevated privilege to 
                           create/write. It is recommended that a location 
                           that contains CDF version number, e.g., cdf39_2-dist,
                           is used.
    
    JNI - Whether to build CDF's Java Native Interface. 
          If 0 (or no), as the default, not to build. 
          If 1 (or yes), it tries to build JNI, provided a proper JDK_HOME is
                         also defined.
    
    JDK_HOME - the JDK package location (may have to double-quoted the pathname
               if there is a space(s) in it). For examples
          Linux: /usr/lib/jvm/java-openjdk
          Cygwin: "/cygdrive/c/Program Files/Eclipse Adoptium/jdk-8.0.462.8-hotspot"
          Mac OS X: /Library/Java/JavaVirtualMachines/zulu-8.jdk
          Windows: "c:\program files\eclipse adoptium\jdk-8.0.372.7-hotspot"
          Alternatively, it can be defined as an environment variable. No
          double-quote is needed for the pathname for Windows. 
    
    Csharp - Whether to build C#-CDF interface for Windows. 
             If 0 (or no), the default, not to build.
             If 1 (or yes), it tries to build the interface.
    
    FORTRAN -  Whether test FORTRAN programs in cdf_tests directory will be
               built.
               If 0 (or no), no build. 
               If 1 (or yes), the default. It will try to build if FORTRAN 
                              compiler is found.
    
    ABI - to build a specified code-based from a UNIX-based system
          non-Mac: m32 - to build 32-bit code from [cc] 64-bit system
          Mac: x86_64 - to build 64-bit Intel code on an arm-based Mac
                        Original zlib is used, instead of zlib-ng.  
    
    ZLIB - to choose the Zlib package
           if orig, the default. The original zlib package is used.
           if ng, the next-generation zlib is used. Refer the Contribution.
    
    G - For Windows to specify the build generator. 
        For MS VC 2022, use '-G "Visual Studio 17 2022" for 64-bit, or
                            '-G "Visual Studio 17 2022 -A "Win32"' for 32-bit
        For MS VC 2015, use '-G "Visual Studio 14 2015" -A x64' for 64-bit, or
                            '-G "Visual Studio 14 2015"' for 32-bit
    
       Alternatively, run: vcvarsall.bat from MS VS installation on a Windows 
       command line to specify the generator/C compiler. For examples, 
       From MS VC 2022, 
        for 64-bit: run
         `"c:\Program Files\Microsoft visual studio\2022\Community\VC\Auxiliary\Build\vcvarsall.bat" amd64`
        for 32-bit: run
         `"c:\Program Files\Microsoft visual studio\2022\Community\VC\Auxiliary\Build\vcvarsall.bat" x86`
       From MS VC 2015,
        for 64-bit: run
         `"c:\Program Files (x86)\Microsoft Visual Studio 14.0\VC\vcvarsall.bat" amd64`
        for 32-bit: run
         `"c:\Program Files (x86)\Microsoft Visual Studio 14.0\VC\vcvarsall.bat" x86`

* ## Configure

```
To build CDF using the bash configure script. This is mainly for 
Unix-based systems.
```

Move into the top of the CDF source code distribution.

```
mkdir toconf
cd toconf

../configure [...]
make
make test
make install
```

### Configure Options

    --MAKE=make        Specified the make utility to build the CDF.
                       Use GNU make (gmake) if the default make does not
                       work properly.
    --CC=cc            Specified the c compiler.
                       Default is gcc or cc if it can be found.
                       Can be set by CC environment variable.
    --FC=fc            Specified the FORTRAN compiler
                       Can be set by FC environment variable.
    --CFLAGS=cflags    Specified the c compiler option(s)
                       For default 64-bit, use "-m32" to compile into 
                       32-bit code.
                       Can be set by CFLAGS environment variable.
    --FFLAGS=fflags    Specified the FORTRAN compiler option(s)
                       Can be set by FFLAGS environment variable.
    --LDFLAGS=ldflags  Specified the linking option(s)
                       For default 64-bit, use "-m32" to build into
                       32-bit library/executables.
                       Can be set by LDFLAGS environment variable.
    --prefix=prefix    Install build files in prefix directory.
                       Default is to the current working directory.
    --32 | --64        Build into 32 or 64-bit compilation mode.
                       Used to build a different mode from the default,
                       if it is available.
    --arch=arch        Build the cross-compilation for Mac M* processor.
                       Used "x86_64" for making x86 code from Mac M* 
                       processors.
    --zlib=[orig | ng]
                       Choose the zlib fork: original or next-generation.
                       original zlib is the default.
    --jni              Build JNI (Java Native Interface) for Java-CDF APIs.
    --with_jdk=jdk_home
                       Home of the JDK kit to be used for JNI build.
                       Can be set by JDK_HOME environment variable.
    --with_ccurses=ccurses_home
                       configure will serach for (n)curses in the system.
                       Provided the include directory if it is not 
                       at the default search path (e.g., /usr/include).
                       No need for Mac OS and windows as curses is included
                       in the source package.
                       Can be set by CCURSES_HOME environment variable.
    --with_lcurses=lcurses_home
                       Provided the library directory where (n)curses
                       located its file is not in the default
                       search path (e.g., /lib64 or /usr/lib on Linux).
                       Can be set by LCURSES_HOME environment variable.
                       No need for Mac OS and windows as curses is included
                       in the source package.
    --warn             Enables extra compiler warnings.

## Contribution

* zlib-ng, the next generation (ng) version of zlib, a replacement with 
  optimization for "next generation" systems. It is 
  [zlib-ng](https://github.com/zlib-ng "zlib-ng"). This package uses native
  machine's available CPU intrinsics. Its compiled code might not be 
  suitable for a different machine. 

* zlib was originally created by Jean-loup Gailly (compression) and Mark Adler
  (decompression). Its home page is here: [zlib](https://www.zlib.net "zlib").
