/******************************************************************************
*
*  NSSDC/CDF				CDF Header file for C/C++ applications.
*
*  Version 3.5d, 14-Dec-97, Hughes STX.
*
*  Modification history:
*
*   V1.0  22-Jan-91, R Kulkarni	Original version (for CDF V2.0).
*		     J Love
*   V2.0   3-Jun-91, J Love     Modified for CDF V2.1 enhancements,
*				namely the INTERNAL interface and the
*				MULTI/SINGLE file option.  Added
*				macros to replace C i/f functions.
*   V2.1  20-Jun-91, J Love	Added function prototypes.
*   V2.2   8-Aug-91, J Love	Increment for CDF V2.1.2.  Use
*				'CDFlib'.  Renamed a few items.
*   V3.0  19-May-92, J Love	IBM PC & HP-UX port.  CDF V2.2.
*   V3.1  23-Sep-92, J Love	CDF V2.3 (shareable/NeXT/zVar).
*   V3.1a  5-Oct-92, J Love	CDF V2.3.0a (NeXT/encoding).
*   V3.1b  6-Oct-92, J Love	CDF V2.3.0b (CDFcompare).
*   V3.1c 27-Oct-92, J Love	CDF V2.3.0c (pad values).
*   V3.2  12-Jan-94, J Love	CDF V2.4.
*   V3.2a  4-Feb-94, J Love	DEC Alpha/OpenVMS port.
*   V3.2b 22-Feb-94, J Love	Spelling lesson.
*   V3.3   8-Dec-94, J Love	CDF V2.5.
*   V3.3a  3-Mar-95, J Love	Solaris 2.3 IDL i/f.
*   V3.4  28-Mar-95, J Love	POSIX.
*   V3.4a  8-May-95, J Love	ILLEGAL_EPOCH_VALUE.
*   V3.4b  9-Jun-95, J Love	EPOCH custom format.
*   V3.4c 20-Jul-95, J Love	CDFexport-related changes.
*   V3.5  12-Sep-96, J Love	CDF V2.6.
*   V3.5a 21-Feb-97, J Love	Removed RICE.
*   V3.5b  9-Mar-97, J Love	Windows NT for MS Visual C++ 4.0 on an IBM PC.
*   V3.5c  2-Sep-97, J Love	`__STDC__' not defined for all AIX compilers.
*   V3.5d 14-Dec-97, J Love	Added ALPHAVMSi encoding.
*   V3.6  08-Apr-04, M Liu      Added  new data type CDF_EPOCH16 and some
*                               epoch functions related to the new type.
*   V3.7  28-Apr-09, M Liu      Modified MAC_ENCODING/DECODEING to PPC_ENCODING
*                               /DECODING as Mac and Linux can run on PPC box.
*   V3.13 20-Oct-16, M Liu      Added a new set CDFread functions with CDFdata
*                               type. Moved a few functions from cdfdist.h to
*                               here.
******************************************************************************/

#if !defined(CDFh_INCLUDEd__)
#define CDFh_INCLUDEd__

/******************************************************************************
* CDF defined types
******************************************************************************/

typedef void *CDFid;
typedef void *CDFdata;
typedef long CDFstatus;
typedef int Logical; 

/******************************************************************************
* CDF defined variables
******************************************************************************/

static double *TT2000NULL = 0;

/******************************************************************************
* Limits
******************************************************************************/

#define CDF_MIN_DIMS    0               /* Min number of dimensions a CDF
					   variable may have */
#define CDF_MAX_DIMS    10              /* Max number of dimensions a CDF
					   variable may have */

/******************************************************************************
* Lengths
******************************************************************************/

#define CDF_VAR_NAME_LEN        64
#define CDF_ATTR_NAME_LEN       64

#define CDF_VAR_NAME_LEN256     256
#define CDF_ATTR_NAME_LEN256    256

#define CDF_COPYRIGHT_LEN       256
#define CDF_STATUSTEXT_LEN      120
#define CDF_PATHNAME_LEN        512

#define EPOCH_STRING_LEN	24
#define EPOCH1_STRING_LEN	16
#define EPOCH2_STRING_LEN	14
#define EPOCH3_STRING_LEN	24
#define EPOCH4_STRING_LEN	23

#define EPOCH16_STRING_LEN      36
#define EPOCH16_1_STRING_LEN    24
#define EPOCH16_2_STRING_LEN    14
#define EPOCH16_3_STRING_LEN    36
#define EPOCH16_4_STRING_LEN    32

#define EPOCHx_STRING_MAX	50
#define EPOCHx_FORMAT_MAX	68

#define TT2000_0_STRING_LEN	30
#define TT2000_1_STRING_LEN	19
#define TT2000_2_STRING_LEN	14
#define TT2000_3_STRING_LEN	29
#define TT2000_4_STRING_LEN	30

/******************************************************************************
* Data types.
******************************************************************************/

#define CDF_INT1		1L
#define CDF_INT2		2L
#define CDF_INT4		4L
#define CDF_INT8		8L
#define CDF_UINT1		11L
#define CDF_UINT2		12L
#define CDF_UINT4		14L
#define CDF_REAL4		21L
#define CDF_REAL8		22L
#define CDF_EPOCH		31L	/* Standard style. */
#define CDF_EPOCH16		32L	/* Extended style. */
#define CDF_TIME_TT2000		33L	/* One more style with leap seconds
					   and J2000 base time. */
#define CDF_BYTE		41L     /* same as CDF_INT1 (signed) */
#define CDF_FLOAT		44L     /* same as CDF_REAL4 */
#define CDF_DOUBLE		45L     /* same as CDF_REAL8 */
#define CDF_CHAR		51L     /* a "string" data type */
#define CDF_UCHAR		52L     /* a "string" data type */

/******************************************************************************
* Encoding (for data only, everything else is network encoding).
******************************************************************************/

#define NETWORK_ENCODING        1L
#define SUN_ENCODING            2L
#define VAX_ENCODING            3L
#define DECSTATION_ENCODING     4L
#define SGi_ENCODING            5L
#define IBMPC_ENCODING          6L
#define IBMRS_ENCODING          7L
#define HOST_ENCODING           8L
#define PPC_ENCODING            9L
#define HP_ENCODING             11L
#define NeXT_ENCODING           12L
#define ALPHAOSF1_ENCODING      13L
#define ALPHAVMSd_ENCODING      14L
#define ALPHAVMSg_ENCODING      15L
#define ALPHAVMSi_ENCODING      16L
#define ARM_LITTLE_ENCODING     17L
#define ARM_BIG_ENCODING        18L
#define IA64VMSi_ENCODING       19L
#define IA64VMSd_ENCODING       20L
#define IA64VMSg_ENCODING       21L

/******************************************************************************
* Decodings.
******************************************************************************/

#define NETWORK_DECODING        NETWORK_ENCODING
#define SUN_DECODING            SUN_ENCODING
#define VAX_DECODING            VAX_ENCODING
#define DECSTATION_DECODING     DECSTATION_ENCODING
#define SGi_DECODING            SGi_ENCODING
#define IBMPC_DECODING          IBMPC_ENCODING
#define IBMRS_DECODING          IBMRS_ENCODING
#define HOST_DECODING           HOST_ENCODING
#define PPC_DECODING            PPC_ENCODING
#define MAC_ENCODING            PPC_ENCODING
#define MAC_DECODING            PPC_ENCODING
#define HP_DECODING             HP_ENCODING
#define NeXT_DECODING           NeXT_ENCODING
#define ALPHAOSF1_DECODING      ALPHAOSF1_ENCODING
#define ALPHAVMSd_DECODING      ALPHAVMSd_ENCODING
#define ALPHAVMSg_DECODING      ALPHAVMSg_ENCODING
#define ALPHAVMSi_DECODING      ALPHAVMSi_ENCODING
#define ARM_LITTLE_DECODING     ARM_LITTLE_ENCODING
#define ARM_BIG_DECODING        ARM_BIG_ENCODING
#define IA64VMSi_DECODING       IA64VMSi_ENCODING
#define IA64VMSd_DECODING       IA64VMSd_ENCODING
#define IA64VMSg_DECODING       IA64VMSg_ENCODING

/******************************************************************************
* TT2000 macros define'd
******************************************************************************/
/*
#define parseTT2000 CDF_TT2000_from_UTC_string
#define encodeTT2000 CDF_TT2000_to_UTC_string
#define computeTT2000 CDF_TT2000_from_UTC_parts
#define breakdownTT2000 CDF_TT2000_to_UTC_parts
#define TT2000breakdown CDF_TT2000_to_UTC_parts
*/
#define CDF_TT2000_from_UTC_string parseTT2000
#define CDF_TT2000_to_UTC_string encodeTT2000
#define CDF_TT2000_from_UTC_parts computeTT2000
#define CDF_TT2000_to_UTC_parts breakdownTT2000

#define TT2000breakdown breakdownTT2000

/******************************************************************************
* UTF8 macros define'd
******************************************************************************/
#define UTF8StrLength UTF8StrChars
#define UTF8CharLength UTF8CharBytes
#define UTF8CharAtLength UTF8CharAtBytes
#define UTF8StrLengthFromCharAt UTF8StrCharsFromCharAt

/******************************************************************************
* Others
******************************************************************************/

#define CDFgetzVarAllRecordsByVarID(id,varNum,buffer) \
	CDFgetVarAllRecordsByVarID(id,1,varNum,buffer)

/******************************************************************************
* Variance flags
******************************************************************************/

#define VARY   (-1L)        /* TRUE record or dimension variance flag */
#define NOVARY 0L           /* FALSE record or dimension variance flag */

/******************************************************************************
* Majorities
******************************************************************************/

#define ROW_MAJOR       1L
#define COLUMN_MAJOR    2L

/******************************************************************************
* Formats.
******************************************************************************/

#define SINGLE_FILE     1L
#define MULTI_FILE      2L

/******************************************************************************
* Checksum
******************************************************************************/

#define NO_CHECKSUM     0L
#define MD5_CHECKSUM    1L
#define OTHER_CHECKSUM  2L

/******************************************************************************
* Attribute scopes
******************************************************************************/

#define GLOBAL_SCOPE            1L
#define VARIABLE_SCOPE          2L

/******************************************************************************
* Readonly modes.
******************************************************************************/

#define READONLYon              (-1L)
#define READONLYoff             0L

/******************************************************************************
* Validate data modes.
******************************************************************************/

#define VALIDATEFILEon          (-1L)
#define VALIDATEFILEoff         0L

/******************************************************************************
* zModes.
******************************************************************************/

#define zMODEoff                0L
#define zMODEon1                1L
#define zMODEon2                2L

/******************************************************************************
* Negative to positive floating point zero modes.
******************************************************************************/

#define NEGtoPOSfp0on           (-1L)
#define NEGtoPOSfp0off          0L

/******************************************************************************
* Backward file mode. 
******************************************************************************/

#define BACKWARDFILEon          1
#define BACKWARDFILEoff         0

/******************************************************************************
* Compression/sparseness constants.
******************************************************************************/

#define CDF_MAX_PARMS			5
#define NO_COMPRESSION			0L
#define RLE_COMPRESSION			1L
#define HUFF_COMPRESSION		2L
#define AHUFF_COMPRESSION		3L
/**************************************************
* Compression `4' used to be RICE.  Do not reuse! *
**************************************************/
#define GZIP_COMPRESSION		5L

#define RLE_OF_ZEROs			0L
#define OPTIMAL_ENCODING_TREES		0L
#define NO_SPARSEARRAYS			0L
#define NO_SPARSERECORDS		0L
#define PAD_SPARSERECORDS		1L
#define PREV_SPARSERECORDS		2L

/*****************************************************************************
* Invalid/reserved constants.
*****************************************************************************/

#define RESERVED_CDFID      ((CDFid) NULL)      /* Indicates that a CDF hasn't
						   been selected yet. */
#define RESERVED_CDFSTATUS  ((CDFstatus) (-1))  /* Indicates that a CDFstatus
						   hasn't been selected yet. */

#define ILLEGAL_EPOCH_VALUE	(-1.0)

#define ILLEGAL_TT2000_VALUE    (-9223372036854775805LL)
#define FILLED_TT2000_VALUE     (-9223372036854775807LL-1)

/******************************************************************************
* Status codes (CDFstatus)
*  - informatory codes are greater than CDF_OK
******************************************************************************/

#define VIRTUAL_RECORD_DATA             ((CDFstatus) 1001)
#define DID_NOT_COMPRESS		((CDFstatus) 1002)
#define VAR_ALREADY_CLOSED              ((CDFstatus) 1003)
#define SINGLE_FILE_FORMAT              ((CDFstatus) 1004)
#define NO_PADVALUE_SPECIFIED           ((CDFstatus) 1005)
#define NO_VARS_IN_CDF                  ((CDFstatus) 1006)
#define MULTI_FILE_FORMAT		((CDFstatus) 1007)
#define SOME_ALREADY_ALLOCATED		((CDFstatus) 1008)
#define PRECEEDING_RECORDS_ALLOCATED	((CDFstatus) 1009)
#define TT2000_CDF_MAYNEEDUPDATE        ((CDFstatus) 1010)
#define BLOCKINGFACTOR_TOO_SMALL        ((CDFstatus) 1011)
#define BLOCKINGFACTOR_TOO_SMALL2       ((CDFstatus) 1012)
#define STRING_NOT_UTF8_ENCODING        ((CDFstatus) 1013)
#define BLOCKINGFACTOR_TOO_LARGE        ((CDFstatus) 1014)
#define CACHESIZE_TOO_SMALL             ((CDFstatus) 1015)

#define CDF_OK                          ((CDFstatus) 0)

#define ATTR_NAME_TRUNC                 ((CDFstatus) (-1001))
#define CDF_NAME_TRUNC                  ((CDFstatus) (-1002))
#define VAR_NAME_TRUNC                  ((CDFstatus) (-1003))
#define NEGATIVE_FP_ZERO		((CDFstatus) (-1004))
					/* -1005 unused. */
#define FORCED_PARAMETER		((CDFstatus) (-1006))
#define NA_FOR_VARIABLE			((CDFstatus) (-1007))

#define CDF_WARN                        ((CDFstatus) (-2000))

#define ATTR_EXISTS                     ((CDFstatus) (-2001))
#define BAD_CDF_ID                      ((CDFstatus) (-2002))
#define BAD_DATA_TYPE                   ((CDFstatus) (-2003))
#define BAD_DIM_SIZE                    ((CDFstatus) (-2004))
#define BAD_DIM_INDEX                   ((CDFstatus) (-2005))
#define BAD_ENCODING                    ((CDFstatus) (-2006))
#define BAD_MAJORITY                    ((CDFstatus) (-2007))
#define BAD_NUM_DIMS                    ((CDFstatus) (-2008))
#define BAD_REC_NUM                     ((CDFstatus) (-2009))
#define BAD_SCOPE                       ((CDFstatus) (-2010))
#define BAD_NUM_ELEMS                   ((CDFstatus) (-2011))
#define CDF_OPEN_ERROR                  ((CDFstatus) (-2012))
#define CDF_EXISTS                      ((CDFstatus) (-2013))
#define BAD_FORMAT                      ((CDFstatus) (-2014))
#define BAD_ALLOCATE_RECS		((CDFstatus) (-2015))
#define BAD_CDF_EXTENSION		((CDFstatus) (-2016))
#define NO_SUCH_ATTR                    ((CDFstatus) (-2017))
#define NO_SUCH_ENTRY                   ((CDFstatus) (-2018))
#define NO_SUCH_VAR                     ((CDFstatus) (-2019))
#define VAR_READ_ERROR                  ((CDFstatus) (-2020))
#define VAR_WRITE_ERROR                 ((CDFstatus) (-2021))
#define BAD_ARGUMENT                    ((CDFstatus) (-2022))
#define IBM_PC_OVERFLOW                 ((CDFstatus) (-2023))
#define TOO_MANY_VARS                   ((CDFstatus) (-2024))
#define VAR_EXISTS                      ((CDFstatus) (-2025))
#define BAD_MALLOC                      ((CDFstatus) (-2026))
#define NOT_A_CDF                       ((CDFstatus) (-2027))
#define CORRUPTED_V2_CDF                ((CDFstatus) (-2028))
#define VAR_OPEN_ERROR                  ((CDFstatus) (-2029))
#define BAD_INITIAL_RECS                ((CDFstatus) (-2030))
#define BAD_BLOCKING_FACTOR             ((CDFstatus) (-2031))
#define END_OF_VAR                      ((CDFstatus) (-2032))
					/* -2033 unused. */
#define BAD_CDFSTATUS                   ((CDFstatus) (-2034))
#define CDF_INTERNAL_ERROR		((CDFstatus) (-2035))
#define BAD_NUM_VARS			((CDFstatus) (-2036))
#define BAD_REC_COUNT                   ((CDFstatus) (-2037))
#define BAD_REC_INTERVAL                ((CDFstatus) (-2038))
#define BAD_DIM_COUNT                   ((CDFstatus) (-2039))
#define BAD_DIM_INTERVAL                ((CDFstatus) (-2040))
#define BAD_VAR_NUM                     ((CDFstatus) (-2041))
#define BAD_ATTR_NUM                    ((CDFstatus) (-2042))
#define BAD_ENTRY_NUM                   ((CDFstatus) (-2043))
#define BAD_ATTR_NAME                   ((CDFstatus) (-2044))
#define BAD_VAR_NAME                    ((CDFstatus) (-2045))
#define NO_ATTR_SELECTED                ((CDFstatus) (-2046))
#define NO_ENTRY_SELECTED               ((CDFstatus) (-2047))
#define NO_VAR_SELECTED                 ((CDFstatus) (-2048))
#define BAD_CDF_NAME                    ((CDFstatus) (-2049))
					/* -2050 unused. */
#define CANNOT_CHANGE                   ((CDFstatus) (-2051))
#define NO_STATUS_SELECTED              ((CDFstatus) (-2052))
#define NO_CDF_SELECTED                 ((CDFstatus) (-2053))
#define READ_ONLY_DISTRIBUTION          ((CDFstatus) (-2054))
#define CDF_CLOSE_ERROR                 ((CDFstatus) (-2055))
#define VAR_CLOSE_ERROR                 ((CDFstatus) (-2056))
					/* -2057 unused. */
#define BAD_FNC_OR_ITEM                 ((CDFstatus) (-2058))
					/* -2059 unused. */
#define ILLEGAL_ON_V1_CDF               ((CDFstatus) (-2060))
					/* -2061 unused. */
					/* -2062 unused. */
#define BAD_CACHE_SIZE                  ((CDFstatus) (-2063))
					/* -2064 unused. */
					/* -2065 unused. */
#define CDF_CREATE_ERROR                ((CDFstatus) (-2066))
#define NO_SUCH_CDF                     ((CDFstatus) (-2067))
#define VAR_CREATE_ERROR                ((CDFstatus) (-2068))
					/* -2069 unused. */
#define READ_ONLY_MODE                  ((CDFstatus) (-2070))
#define ILLEGAL_IN_zMODE                ((CDFstatus) (-2071))
#define BAD_zMODE                       ((CDFstatus) (-2072))
#define BAD_READONLY_MODE               ((CDFstatus) (-2073))
#define CDF_READ_ERROR                  ((CDFstatus) (-2074))
#define CDF_WRITE_ERROR                 ((CDFstatus) (-2075))
#define ILLEGAL_FOR_SCOPE               ((CDFstatus) (-2076))
#define NO_MORE_ACCESS                  ((CDFstatus) (-2077))
					/* -2078 unused. */
#define BAD_DECODING		        ((CDFstatus) (-2079))
					/* -2080 unused. */
#define BAD_NEGtoPOSfp0_MODE		((CDFstatus) (-2081))
#define UNSUPPORTED_OPERATION		((CDFstatus) (-2082))
#define CDF_SAVE_ERROR			((CDFstatus) (-2083))
#define VAR_SAVE_ERROR			((CDFstatus) (-2084))
					/* -2085 unused. */
#define NO_WRITE_ACCESS                 ((CDFstatus) (-2086))
#define NO_DELETE_ACCESS                ((CDFstatus) (-2087))
#define CDF_DELETE_ERROR		((CDFstatus) (-2088))
#define VAR_DELETE_ERROR		((CDFstatus) (-2089))
#define UNKNOWN_COMPRESSION		((CDFstatus) (-2090))
#define CANNOT_COMPRESS			((CDFstatus) (-2091))
#define DECOMPRESSION_ERROR		((CDFstatus) (-2092))
#define COMPRESSION_ERROR		((CDFstatus) (-2093))
					/* -2094 unused. */
					/* -2095 unused. */
#define EMPTY_COMPRESSED_CDF		((CDFstatus) (-2096))
#define BAD_COMPRESSION_PARM		((CDFstatus) (-2097))
#define UNKNOWN_SPARSENESS		((CDFstatus) (-2098))
#define CANNOT_SPARSERECORDS		((CDFstatus) (-2099))
#define CANNOT_SPARSEARRAYS		((CDFstatus) (-2100))
#define TOO_MANY_PARMS			((CDFstatus) (-2101))
#define NO_SUCH_RECORD			((CDFstatus) (-2102))
#define CANNOT_ALLOCATE_RECORDS		((CDFstatus) (-2103))
					/* -2104 unused. */
					/* -2105 unused. */
#define SCRATCH_DELETE_ERROR		((CDFstatus) (-2106))
#define SCRATCH_CREATE_ERROR		((CDFstatus) (-2107))
#define SCRATCH_READ_ERROR		((CDFstatus) (-2108))
#define SCRATCH_WRITE_ERROR		((CDFstatus) (-2109))
#define BAD_SPARSEARRAYS_PARM		((CDFstatus) (-2110))
#define BAD_SCRATCH_DIR			((CDFstatus) (-2111))
#define NOT_A_CDF_OR_NOT_SUPPORTED      ((CDFstatus) (-2113))
#define CORRUPTED_V3_CDF                ((CDFstatus) (-2223))
#define ILLEGAL_EPOCH_FIELD             ((CDFstatus) (-2224))
#define BAD_CHECKSUM                    ((CDFstatus) (-2225)) 
#define CHECKSUM_ERROR                  ((CDFstatus) (-2226))
#define CHECKSUM_NOT_ALLOWED            ((CDFstatus) (-2227))
#define IS_A_NETCDF                     ((CDFstatus) (-2228))
#define TT2000_TIME_ERROR               ((CDFstatus) (-2229))
#define UNABLE_TO_PROCESS_CDF           ((CDFstatus) (-2230))
#define ZLIB_COMPRESS_ERROR             ((CDFstatus) (-2231))
#define ZLIB_UNCOMPRESS_ERROR           ((CDFstatus) (-2232))
#define CANNOT_INSERT_RECORDS           ((CDFstatus) (-2233))
#define TT2000_USED_OUTDATED_TABLE      ((CDFstatus) (-2234))
#define BADDATE_LEAPSECOND_UPDATED      ((CDFstatus) (-2235))
#define FUNCTION_NOT_SUPPORTED          ((CDFstatus) (-2236))
#define TRY_TO_READ_NONSTRING_DATA      ((CDFstatus) (-2237))
#define BAD_NUM_STRINGS                 ((CDFstatus) (-2238))
#define CANNOT_CONVERT_WIDECHAR         ((CDFstatus) (-2239))

/******************************************************************************
* Functions (for INTERNAL interface).
* NOTE: These values must be different from those of the items.
******************************************************************************/

#define CREATE_			1001L
#define OPEN_			1002L
#define DELETE_			1003L
#define CLOSE_			1004L
#define SELECT_			1005L
#define CONFIRM_		1006L
#define GET_			1007L
#define PUT_			1008L

#define SAVE_                   1009L
#define BACKWARD_               1010L
#define GETCDFFILEBACKWARD_     1011L
#define CHECKSUM_               1012L
#define GETCDFCHECKSUM_         1013L
#define VALIDATE_               1014L
#define GETCDFVALIDATE_         1015L

#define NULL_			1000L

/******************************************************************************
* Items on which functions are performed (for INTERNAL interface).
* NOTE: These values must be different from those of the functions.
******************************************************************************/

#define CDF_                    1L
#define CDF_NAME_               2L
#define CDF_ENCODING_           3L
#define CDF_DECODING_		4L
#define CDF_MAJORITY_           5L
#define CDF_FORMAT_             6L
#define CDF_COPYRIGHT_          7L
#define CDF_NUMrVARS_           8L
#define CDF_NUMzVARS_           9L
#define CDF_NUMATTRS_           10L
#define CDF_NUMgATTRS_          11L
#define CDF_NUMvATTRS_          12L
#define CDF_VERSION_            13L
#define CDF_RELEASE_            14L
#define CDF_INCREMENT_          15L
#define CDF_STATUS_             16L
#define CDF_READONLY_MODE_      17L
#define CDF_zMODE_              18L
#define CDF_NEGtoPOSfp0_MODE_	19L
#define LIB_COPYRIGHT_          20L
#define LIB_VERSION_            21L
#define LIB_RELEASE_            22L
#define LIB_INCREMENT_          23L
#define LIB_subINCREMENT_       24L
#define rVARs_NUMDIMS_          25L
#define rVARs_DIMSIZES_         26L
#define rVARs_MAXREC_           27L
#define rVARs_RECDATA_		28L
#define rVARs_RECNUMBER_        29L
#define rVARs_RECCOUNT_         30L
#define rVARs_RECINTERVAL_      31L
#define rVARs_DIMINDICES_       32L
#define rVARs_DIMCOUNTS_        33L
#define rVARs_DIMINTERVALS_     34L
#define rVAR_                   35L
#define rVAR_NAME_              36L
#define rVAR_DATATYPE_          37L
#define rVAR_NUMELEMS_          38L
#define rVAR_RECVARY_           39L
#define rVAR_DIMVARYS_          40L
#define rVAR_NUMBER_            41L
#define rVAR_DATA_              42L
#define rVAR_HYPERDATA_         43L
#define rVAR_SEQDATA_           44L
#define rVAR_SEQPOS_            45L
#define rVAR_MAXREC_            46L
#define rVAR_MAXallocREC_       47L
#define rVAR_DATASPEC_          48L
#define rVAR_PADVALUE_          49L
#define rVAR_INITIALRECS_       50L
#define rVAR_BLOCKINGFACTOR_    51L
#define rVAR_nINDEXRECORDS_	52L
#define rVAR_nINDEXENTRIES_	53L
#define rVAR_EXISTENCE_		54L
#define zVARs_MAXREC_		55L
#define zVARs_RECDATA_		56L
#define zVAR_                   57L
#define zVAR_NAME_              58L
#define zVAR_DATATYPE_          59L
#define zVAR_NUMELEMS_          60L
#define zVAR_NUMDIMS_           61L
#define zVAR_DIMSIZES_          62L
#define zVAR_RECVARY_           63L
#define zVAR_DIMVARYS_          64L
#define zVAR_NUMBER_            65L
#define zVAR_DATA_              66L
#define zVAR_HYPERDATA_         67L
#define zVAR_SEQDATA_           68L
#define zVAR_SEQPOS_            69L
#define zVAR_MAXREC_            70L
#define zVAR_MAXallocREC_       71L
#define zVAR_DATASPEC_          72L
#define zVAR_PADVALUE_          73L
#define zVAR_INITIALRECS_       74L
#define zVAR_BLOCKINGFACTOR_    75L
#define zVAR_nINDEXRECORDS_	76L
#define zVAR_nINDEXENTRIES_	77L
#define zVAR_EXISTENCE_		78L
#define zVAR_RECNUMBER_         79L
#define zVAR_RECCOUNT_          80L
#define zVAR_RECINTERVAL_       81L
#define zVAR_DIMINDICES_        82L
#define zVAR_DIMCOUNTS_         83L
#define zVAR_DIMINTERVALS_      84L
#define ATTR_                   85L
#define ATTR_SCOPE_             86L
#define ATTR_NAME_              87L
#define ATTR_NUMBER_            88L
#define ATTR_MAXgENTRY_         89L
#define ATTR_NUMgENTRIES_       90L
#define ATTR_MAXrENTRY_         91L
#define ATTR_NUMrENTRIES_       92L
#define ATTR_MAXzENTRY_         93L
#define ATTR_NUMzENTRIES_       94L
#define ATTR_EXISTENCE_		95L
#define gENTRY_                 96L
#define gENTRY_EXISTENCE_       97L
#define gENTRY_DATATYPE_        98L
#define gENTRY_NUMELEMS_        99L
#define gENTRY_DATASPEC_        100L
#define gENTRY_DATA_            101L
#define rENTRY_                 102L
#define rENTRY_NAME_		103L
#define rENTRY_EXISTENCE_       104L
#define rENTRY_DATATYPE_        105L
#define rENTRY_NUMELEMS_        106L
#define rENTRY_DATASPEC_        107L
#define rENTRY_DATA_            108L
#define zENTRY_                 109L
#define zENTRY_NAME_		110L
#define zENTRY_EXISTENCE_       111L
#define zENTRY_DATATYPE_        112L
#define zENTRY_NUMELEMS_        113L
#define zENTRY_DATASPEC_        114L
#define zENTRY_DATA_            115L
#define STATUS_TEXT_            116L
#define CDF_CACHESIZE_		117L
#define rVARs_CACHESIZE_	118L
#define zVARs_CACHESIZE_	119L
#define rVAR_CACHESIZE_		120L
#define zVAR_CACHESIZE_		121L
#define zVARs_RECNUMBER_	122L
#define rVAR_ALLOCATERECS_	123L
#define zVAR_ALLOCATERECS_	124L
#define DATATYPE_SIZE_		125L
#define CURgENTRY_EXISTENCE_	126L
#define CURrENTRY_EXISTENCE_	127L
#define CURzENTRY_EXISTENCE_	128L
#define CDF_INFO_		129L
#define CDF_COMPRESSION_	130L
#define zVAR_COMPRESSION_	131L
#define zVAR_SPARSERECORDS_	132L
#define zVAR_SPARSEARRAYS_	133L
#define zVAR_ALLOCATEBLOCK_	134L
#define zVAR_NUMRECS_		135L
#define zVAR_NUMallocRECS_	136L
#define rVAR_COMPRESSION_	137L
#define rVAR_SPARSERECORDS_	138L
#define rVAR_SPARSEARRAYS_	139L
#define rVAR_ALLOCATEBLOCK_	140L
#define rVAR_NUMRECS_		141L
#define rVAR_NUMallocRECS_	142L
#define rVAR_ALLOCATEDFROM_	143L
#define rVAR_ALLOCATEDTO_	144L
#define zVAR_ALLOCATEDFROM_	145L
#define zVAR_ALLOCATEDTO_	146L
#define zVAR_nINDEXLEVELS_	147L
#define rVAR_nINDEXLEVELS_	148L
#define CDF_SCRATCHDIR_		149L
#define rVAR_RESERVEPERCENT_	150L
#define zVAR_RESERVEPERCENT_	151L
#define rVAR_RECORDS_		152L
#define zVAR_RECORDS_		153L
#define STAGE_CACHESIZE_	154L
#define COMPRESS_CACHESIZE_	155L
#define CDF_CHECKSUM_           156L
#define rVAR_RECORDS_RENUMBER_  157L
#define zVAR_RECORDS_RENUMBER_  158L
#define CDF_LEAPSECONDLASTUPDATED_ 159L
#define rENTRY_STRINGSDATA_     160L
#define zENTRY_STRINGSDATA_     161L
#define rENTRY_NUMSTRINGS_      162L
#define zENTRY_NUMSTRINGS_      163L


#define CDFwithSTATS_		200L	/* For CDF internal use only! */
#define CDF_ACCESS_		201L	/* For CDF internal use only! */
#define TT2000END		-99999.999
#define STRINGDELIMITER         "\\N "

/******************************************************************************
* Synonyms for compatibility with older releases.
******************************************************************************/

#define CDF_DOCUMENT_LEN	        CDF_COPYRIGHT_LEN
#define CDF_ERRTEXT_LEN         	CDF_STATUSTEXT_LEN
#define CDF_NUMDIMS_            	rVARs_NUMDIMS_
#define CDF_DIMSIZES_           	rVARs_DIMSIZES_
#define CDF_MAXREC_             	rVARs_MAXREC_
#define CDF_RECNUMBER_          	rVARs_RECNUMBER_
#define CDF_RECCOUNT_           	rVARs_RECCOUNT_
#define CDF_RECINTERVAL_        	rVARs_RECINTERVAL_
#define CDF_DIMINDICES_         	rVARs_DIMINDICES_
#define CDF_DIMCOUNTS_          	rVARs_DIMCOUNTS_
#define CDF_DIMINTERVALS_       	rVARs_DIMINTERVALS_
#define CDF_NUMVARS_            	CDF_NUMrVARS_
#define VAR_                    	rVAR_
#define VAR_NAME_               	rVAR_NAME_
#define VAR_DATATYPE_           	rVAR_DATATYPE_
#define VAR_NUMELEMS_           	rVAR_NUMELEMS_
#define VAR_RECVARY_            	rVAR_RECVARY_
#define VAR_DIMVARYS_           	rVAR_DIMVARYS_
#define VAR_NUMBER_             	rVAR_NUMBER_
#define VAR_DATA_               	rVAR_DATA_
#define VAR_HYPERDATA_          	rVAR_HYPERDATA_
#define VAR_SEQDATA_            	rVAR_SEQDATA_
#define VAR_SEQPOS_             	rVAR_SEQPOS_
#define VAR_MAXREC_             	rVAR_MAXREC_
#define VAR_DATASPEC_           	rVAR_DATASPEC_
#define VAR_FILLVALUE_          	rVAR_PADVALUE_
#define VAR_INITIALRECS_        	rVAR_INITIALRECS_
#define VAR_EXTENDRECS_         	rVAR_BLOCKINGFACTOR_
#define ATTR_MAXENTRY_          	ATTR_MAXrENTRY_
#define ATTR_NUMENTRIES_        	ATTR_NUMrENTRIES_
#define ENTRY_                  	rENTRY_
#define ENTRY_DATATYPE_         	rENTRY_DATATYPE_
#define ENTRY_NUMELEMS_         	rENTRY_NUMELEMS_
#define ENTRY_DATA_             	rENTRY_DATA_
#define MIPSEL_ENCODING			DECSTATION_ENCODING
#define MIPSEB_ENCODING			SGi_ENCODING
#define rVAR_EXISTANCE_			rVAR_EXISTENCE_
#define zVAR_EXISTANCE_			zVAR_EXISTENCE_
#define ATTR_EXISTANCE_			ATTR_EXISTENCE_
#define gENTRY_EXISTANCE_		gENTRY_EXISTENCE_
#define rENTRY_EXISTANCE_		rENTRY_EXISTENCE_
#define zENTRY_EXISTANCE_		zENTRY_EXISTENCE_
#define GLOBAL_SCOPE_ASSUMED		GLOBAL_SCOPE
#define VARIABLE_SCOPE_ASSUMED		VARIABLE_SCOPE
#define BAD_EXTEND_RECS			BAD_BLOCKING_FACTOR
#define rVAR_EXTENDRECS_		rVAR_BLOCKINGFACTOR_
#define zVAR_EXTENDRECS_		zVAR_BLOCKINGFACTOR_
#define COL_MAJOR			COLUMN_MAJOR
#define NONE_CHECKSUM			NO_CHECKSUM

#define StrlaststrIgCase		StrLaststrIgCase     
#define Strlaststr                      StrLaststr

/******************************************************************************
* Function prototypes.
*     It is assumed that `__cplusplus' is defined for ALL C++ compilers.  If
* ANSI function prototypes are not desired (for whatever reason), define
* noPROTOs on the compile command line.  Otherwise, ANSI function prototypes
* will be used where appropriate.
******************************************************************************/

#if !defined(noPROTOs)
#  if defined(__STDC__)
#    define PROTOs_
#  else
#    if defined(vms)
#      define PROTOs_
#    endif
#    if defined(__MSDOS__) || defined(MSDOS)
#      define PROTOs_
#    endif
#    if defined(macintosh) || defined(THINK_C)
#      define PROTOs_
#    endif
#    if defined(WIN32)
#      define PROTOs_
#    endif
#    if defined(AIX)
#      define PROTOs_
#    endif
#  endif
#endif

#if defined(PROTOs_)
#  define PROTOARGs(args) args
#else
#  define PROTOARGs(args) ()
#endif

#if defined(BUILDINGforIDL)
#  define STATICforIDL static
#  define VISIBLE_PREFIX static
#else
#  if defined(WIN32) && defined(BUILDINGforDLL)
#    if defined(LIBCDF_SOURCE_)
#      define VISIBLE_PREFIX _declspec(dllexport)
#      define STD_CALL __stdcall
#    else
#      define VISIBLE_PREFIX _declspec(dllimport)
#      define STD_CALL \

#    endif
#  else
#    define VISIBLE_PREFIX \

#    define STD_CALL \

#  endif
#  define STATICforIDL \

#endif

#if (_FILE_OFFSET_BITS == 64) || defined(_LARGEFILE_SOURCE) || \
    defined(_LARGEFILE64_SOURCE) || defined(_LARGEFILE)
#  if defined(WIN32)
     typedef __int64 OFF_T;
#  else
#    if defined(__MINGW32__) || defined(AIX)
       typedef off64_t OFF_T;
#    else
       typedef off_t OFF_T;
#    endif
#  endif
#else
   typedef long OFF_T;
#endif

#if defined(__cplusplus)
extern "C" {
#endif

#if !defined(__CFM68K__) || defined(__USING_STATIC_LIBS__) || !defined(CFM68KDLL)
VISIBLE_PREFIX CDFstatus CDFlib PROTOARGs((long op1, ...));
#endif
VISIBLE_PREFIX CDFstatus CDFcreateCDF PROTOARGs((
  char *name, CDFid *id
));
VISIBLE_PREFIX CDFstatus CDFattrInquire PROTOARGs((
  CDFid id, long attrNum, char *attrName, long *attrScope,
  long *maxgrEntry
)); 
VISIBLE_PREFIX CDFstatus CDFinquireAttr PROTOARGs((
  CDFid id, long attrNum, char *attrName, long *attrScope,
  long *maxgEntry, long *maxrEntry, long *maxzEntry
));
VISIBLE_PREFIX CDFstatus CDFinquireAttrEntry PROTOARGs((
  CDFid id, int grzEntry, long attrNum, long entryNum, long *dataType,
  long *numElems
));
VISIBLE_PREFIX CDFstatus CDFinquireAttrInfo PROTOARGs((
  CDFid id, int zEntry, long attrNum, char *attrName, long *attrScope,
  long *maxEntry
));
VISIBLE_PREFIX CDFstatus CDFputAttrEntry PROTOARGs((
  CDFid id, int grzEntry, long attrNum, long entryNum, long dataType,
  long numElems, void *value
));
VISIBLE_PREFIX CDFstatus CDFputAttrEntryStrings PROTOARGs((
  CDFid id, int rzEntry, long attrNum, long entryNum, long numStrings,
  char **strings
));
VISIBLE_PREFIX CDFstatus CDFgetAttrEntry PROTOARGs((
  CDFid id, int grzEntry, long attrNum, long entryNum, void *value
));
VISIBLE_PREFIX CDFstatus CDFgetAttrEntryStrings PROTOARGs((
  CDFid id, int rzEntry, long attrNum, long entryNum, long *numStrings,
  char ***string
));
VISIBLE_PREFIX CDFstatus CDFdeleteAttrEntry PROTOARGs((
  CDFid id, int grzEntry, long attrNum, long entryNum
));
VISIBLE_PREFIX CDFstatus CDFsetAttrEntryDataSpec PROTOARGs((
  CDFid id, int grzEntry, long attrNum, long entryNum, long dataType,
  long numElems
));
VISIBLE_PREFIX long CDFgetAttrNum PROTOARGs((CDFid id, char *attrName));
VISIBLE_PREFIX long CDFgetVarNum PROTOARGs((CDFid id, char *varName));
VISIBLE_PREFIX CDFstatus CDFgetNumAttrEntries PROTOARGs((
  CDFid id, int grzEntry, long attrNum, long *numEntries
));
VISIBLE_PREFIX CDFstatus CDFgetAttrMaxEntry PROTOARGs((
  CDFid id, int grzEntry, long attrNum, long *maxEntry
));
VISIBLE_PREFIX CDFstatus CDFgetAttrEntryDataType PROTOARGs((
  CDFid id, int grzEntry, long attrNum, long entryNum, long *dataType
));
VISIBLE_PREFIX CDFstatus CDFgetAttrEntryDataType PROTOARGs((
  CDFid id, int grzEntry, long attrNum, long entryNum, long *dataType
));
VISIBLE_PREFIX CDFstatus CDFgetAttrEntryNumStrings PROTOARGs((
  CDFid id, int rzEntry, long attrNum, long entryNum, long *numStrings
));
VISIBLE_PREFIX CDFstatus CDFgetVarRecordData PROTOARGs((
  CDFid id, int zVar, long varNum, long recNum, void *buffer
));
VISIBLE_PREFIX CDFstatus CDFputVarRecordData PROTOARGs((
  CDFid id, int zVar, long varNum, long recNum, void *buffer
));
VISIBLE_PREFIX CDFstatus CDFgetVarsRecordDatabyNames PROTOARGs((
  CDFid id, int zVar, long numVars, char *varNames[], long recNum,
  void *buffer[]
));
VISIBLE_PREFIX CDFstatus CDFputVarsRecordDatabyNames PROTOARGs((
  CDFid id, int zVar, long numVars, char *varNames[], long recNum,
  void *buffer[]
));
VISIBLE_PREFIX CDFstatus CDFgetVarAllRecordsByVarID PROTOARGs((
  CDFid id, int zVar, long varNum, void *buffer
));
VISIBLE_PREFIX CDFstatus CDFputVarAllRecordsByVarID PROTOARGs((
  CDFid id, int zVar, long varNum, long numRec, void *buffer
));
VISIBLE_PREFIX CDFstatus CDFgetVarRangeRecordsByVarID PROTOARGs((
  CDFid id, int zVar, long varNum, long startRec, long stopRec,
  void *buffer
));
VISIBLE_PREFIX CDFstatus CDFputVarRangeRecordsByVarID PROTOARGs((
  CDFid id, int zVar, long varNum, long startRec, long stopRec,
  void *buffer
));
VISIBLE_PREFIX CDFstatus CDFgetVarAllRecordsByVarName PROTOARGs((
  CDFid id, char *varName, void *buffer
));
VISIBLE_PREFIX CDFstatus CDFputVarAllRecordsByVarName PROTOARGs((
  CDFid id, char *varName, long numRecs, void *buffer
));
VISIBLE_PREFIX CDFstatus CDFgetVarRangeRecordsByVarName PROTOARGs((
  CDFid id, char *varName, long startRec, long stopRec, void *buffer
));
VISIBLE_PREFIX CDFstatus CDFputVarRangeRecordsByVarName PROTOARGs((
  CDFid id, char *varName, long startRec,long stopRec, void *buffer
));
VISIBLE_PREFIX void CDFsetFileBackward PROTOARGs((
  int flag
));
VISIBLE_PREFIX void CDFsetFileBackwardFlag PROTOARGs((
  int flag
));
VISIBLE_PREFIX int CDFgetFileBackward PROTOARGs(());
VISIBLE_PREFIX int CDFgetFileBackwardFlag PROTOARGs(());
VISIBLE_PREFIX void CDFsetChecksumMode PROTOARGs((
  long flag
));
VISIBLE_PREFIX long CDFgetChecksumMode PROTOARGs(());
VISIBLE_PREFIX int CDFgetFileBackwardEnvVar PROTOARGs(());
VISIBLE_PREFIX void CDFsetValidate PROTOARGs((long mode));
VISIBLE_PREFIX int CDFgetValidate PROTOARGs(());
VISIBLE_PREFIX int CDFgetValidateDebug PROTOARGs(());
VISIBLE_PREFIX void ROWtoCOL PROTOARGs((
  void *iBuffer, void *oBuffer, long numDims, long dimSizes[], long nValueBytes
));
VISIBLE_PREFIX void COLtoROW PROTOARGs((
  void *iBuffer, void *oBuffer, long numDims, long dimSizes[], long nValueBytes
));
VISIBLE_PREFIX int CDFstrcmpIgCase PROTOARGs((char *string1, char *string2));
VISIBLE_PREFIX char *CDFstrstrIgCase PROTOARGs((char *string1, char *string2));

/*
 * CLOSE_  *
 *         */

VISIBLE_PREFIX CDFstatus CDFclose(CDFid id);
VISIBLE_PREFIX CDFstatus CDFcloseVar(CDFid id,Logical zVar,long varNum);

/*
 * CONFIRM_  *
 *           */

VISIBLE_PREFIX CDFstatus CDFconfirmAttrExistence(CDFid id,char *attrName);
VISIBLE_PREFIX CDFstatus CDFconfirmgEntryExistence(CDFid id,long attrNum,long entryNum);
VISIBLE_PREFIX CDFstatus CDFconfirmrEntryExistence(CDFid id,long attrNum,long entryNum);
VISIBLE_PREFIX CDFstatus CDFconfirmVarExistence(CDFid id,Logical zVar,char *varName);
VISIBLE_PREFIX CDFstatus CDFconfirmVarPadValueExistence(CDFid id,Logical zVar,long varNum);
VISIBLE_PREFIX CDFstatus CDFconfirmzEntryExistence(CDFid id,long attrNum,long entryNum);
VISIBLE_PREFIX CDFstatus CDFconfirmChecksum(CDFid id);

/*
 * CREATE_ *
 *         */

VISIBLE_PREFIX CDFstatus CDFcreate(char *CDFname,long numDims,long *dimSizes,long encoding,long majority,CDFid *id);
VISIBLE_PREFIX CDFstatus CDFcreateAttr(CDFid id,char *attrName,long attrScope,long *attrNum);
VISIBLE_PREFIX CDFstatus CDFcreaterVar(CDFid id,char *varName,long dataType,long numElements,long recVary,long *dimVarys,long *varNum);
VISIBLE_PREFIX CDFstatus CDFcreatezVar(CDFid id,char *varName,long dataType,long numElements,long numDims,long *dimSizes,long recVary,long *dimVarys,long *varNum);

/*
 * DELETE_ *
 *         */

VISIBLE_PREFIX CDFstatus CDFdelete(CDFid id);
VISIBLE_PREFIX CDFstatus CDFdeleteAttr(CDFid id,long attrNum);
VISIBLE_PREFIX CDFstatus CDFdeleteVar(CDFid id,Logical zVar,long varNum);
VISIBLE_PREFIX CDFstatus CDFdeleteVarRecords(CDFid id,Logical zVar,long varNum,long firstRec,long lastRec);

/*
 * GET_ *
 *      */

VISIBLE_PREFIX CDFstatus CDFgetAttrName(CDFid id,long attrNum,char *attrName);
VISIBLE_PREFIX CDFstatus CDFgetAttrScope(CDFid id,long attrNum,long *attrScope);
VISIBLE_PREFIX CDFstatus CDFgetCacheSize(CDFid id,long *numBuffers);
VISIBLE_PREFIX CDFstatus CDFgetCompression(CDFid id,long *cType, long *cParms, long *cPercent);
VISIBLE_PREFIX CDFstatus CDFgetCompressionCacheSize(CDFid id,long *numBuffers);
VISIBLE_PREFIX CDFstatus CDFgetCopyright(CDFid id,char *copyright);
VISIBLE_PREFIX CDFstatus CDFgetDataTypeSize(long dataType,long *numBytes);
VISIBLE_PREFIX CDFstatus CDFgetDecoding(CDFid id,long *decoding);
VISIBLE_PREFIX CDFstatus CDFgetEncoding(CDFid id,long *encoding);
VISIBLE_PREFIX CDFstatus CDFgetFormat(CDFid id,long *format);
VISIBLE_PREFIX CDFstatus CDFgetCompressionInfo(char *name,long *cType,long *cParms,OFF_T *cSize,OFF_T *uSize);
VISIBLE_PREFIX CDFstatus CDFgetMajority(CDFid id,long *majority);
VISIBLE_PREFIX CDFstatus CDFgetName(CDFid id,char *cdfName);
VISIBLE_PREFIX CDFstatus CDFgetNegtoPosfp0Mode(CDFid id,long *negtoPosfp0);
VISIBLE_PREFIX CDFstatus CDFgetNumAttributes(CDFid id,long *numAttrs);
VISIBLE_PREFIX CDFstatus CDFgetNumgAttributes(CDFid id,long *numgAttrs);
VISIBLE_PREFIX CDFstatus CDFgetNumVars(CDFid id,Logical zVar,long *numVars);
VISIBLE_PREFIX CDFstatus CDFgetNumvAttributes(CDFid id,long *numvAttrs);
VISIBLE_PREFIX CDFstatus CDFdoc(CDFid id,long *version,long *release,char *copyright);
VISIBLE_PREFIX CDFstatus CDFgetLibraryCopyright(char *copyright);
VISIBLE_PREFIX CDFstatus CDFgetLibraryVersion(long *version,long *release,long *increment,char *subincrement);
VISIBLE_PREFIX CDFstatus CDFgetReadOnlyMode(CDFid id,long *readOnlyMode);
VISIBLE_PREFIX CDFstatus CDFgetStageCacheSize(CDFid id,long *numBuffers);
VISIBLE_PREFIX CDFstatus CDFgetVersion(CDFid id,long *version,long *release,long *increment);
VISIBLE_PREFIX CDFstatus CDFgetVarBlockingFactor(CDFid id,Logical zVar,long varNum,long *bf);
VISIBLE_PREFIX CDFstatus CDFgetVarCacheSize(CDFid id,Logical zVar,long varNum,long *numBuffers);
VISIBLE_PREFIX CDFstatus CDFgetVarCompression(CDFid id,Logical zVar,long varNum,long *cType,long *cParms,long *cPct);
VISIBLE_PREFIX CDFstatus CDFgetzVarData(CDFid id,long varNum,long recNum,long *indices,void *value);
VISIBLE_PREFIX CDFstatus CDFgetVarData(CDFid id,Logical zVar,long varNum,long recNum,long *indices,void *value);
VISIBLE_PREFIX CDFstatus CDFgetVarDataType(CDFid id,Logical zVar,long varNum,long *dataType);
VISIBLE_PREFIX CDFstatus CDFgetVarDimVariances(CDFid id,Logical zVar,long varNum,long *dimVarys);
VISIBLE_PREFIX CDFstatus CDFgetVarMaxAllocRecNum(CDFid id,Logical zVar,long varNum,long *maxAllocRec);
VISIBLE_PREFIX CDFstatus CDFgetVarMaxWrittenRecNum(CDFid id,Logical zVar,long varNum,long *maxRec);
VISIBLE_PREFIX CDFstatus CDFgetVarAllocRecords(CDFid id,Logical zVar,long varNum,long *numAllocRecs);
VISIBLE_PREFIX CDFstatus CDFgetVarNumElements(CDFid id,Logical zVar,long varNum,long *numElements);
VISIBLE_PREFIX CDFstatus CDFgetVarNumRecsWritten(CDFid id,Logical zVar,long varNum,long *numRecs);
VISIBLE_PREFIX CDFstatus CDFgetVarPadValue(CDFid id,Logical zVar,long varNum,void *padValue);
VISIBLE_PREFIX CDFstatus CDFgetVarRecVariance(CDFid id,Logical zVar,long varNum,long *recVary);
VISIBLE_PREFIX CDFstatus CDFgetVarReservePercent(CDFid id,Logical zVar,long varNum,long *percent);
VISIBLE_PREFIX CDFstatus CDFgetVarSeqData(CDFid id,Logical zVar,long varNum,void *seqData);
VISIBLE_PREFIX CDFstatus CDFgetVarSeqPos(CDFid id,Logical zVar,long varNum,long *recNum,long *indices);
VISIBLE_PREFIX CDFstatus CDFgetVarsRecordDatabyNumbers(CDFid id,Logical zVar,long numVars,long *varNums,long recNum,void *buffer);
VISIBLE_PREFIX CDFstatus CDFgetVarSparseRecords(CDFid id,Logical zVar,long varNum,long *sparseRecs);
VISIBLE_PREFIX CDFstatus CDFgetVarInfo(CDFid id,Logical zVar,long varNum,long *dataType,long *numElems,long *numDims,long *dimSizes);
VISIBLE_PREFIX CDFstatus CDFgetrVarsDimSizes(CDFid id,long *dimSizes);
VISIBLE_PREFIX CDFstatus CDFgetzMode(CDFid id,long *zMode);
VISIBLE_PREFIX CDFstatus CDFgetzVarDimSizes(CDFid id,long varNum,long *dimSizes);
VISIBLE_PREFIX CDFstatus CDFgetzVarDimVariances(CDFid id,long varNum,long *dimSizes);
VISIBLE_PREFIX CDFstatus CDFgetVarName(CDFid id,Logical zVar,long varNum,char *varName);
VISIBLE_PREFIX CDFstatus CDFgetzVarNumDims(CDFid id,long varNum,long *numDims);
VISIBLE_PREFIX CDFstatus CDFgetzVarSpec(CDFid id, long varNum, long *dataType, long *numElems, long *numDims, long *dimSizes, long *recVary, long *dimsVary);
VISIBLE_PREFIX CDFstatus CDFgetrVarsNumDims(CDFid id,long *numDims);
VISIBLE_PREFIX CDFstatus CDFgetStatusText(CDFstatus status,char *text);
VISIBLE_PREFIX CDFstatus CDFhyperGetVarData(CDFid id,Logical zVar,long varN,long recS,long recC,long recI,long *indices,long *counts,long *intervals,void *buff);
VISIBLE_PREFIX CDFstatus CDFgetMaxWrittenRecNums(CDFid id,long *maxRecrVars,long *maxReczVars);
VISIBLE_PREFIX CDFstatus CDFgetVarsMaxWrittenRecNum(CDFid id,Logical zVar,long *maxRecVar);
VISIBLE_PREFIX CDFstatus CDFinquireVar(CDFid id,Logical zVar,long varN,char *varName,long *dataType,long *numElements,long *numDims,long *dimSizes,long *recVary,long *dimVarys);
VISIBLE_PREFIX CDFstatus CDFvarInquire(CDFid id,long varN,char *varName,long *dataType,long *numElements,long *recVary,long *dimVarys);
VISIBLE_PREFIX CDFstatus CDFinquire(CDFid id,long *numDims,long *dimSizes,long *encoding,long *majority,long *maxRec,long *nVars,long *nAttrs);
VISIBLE_PREFIX CDFstatus CDFinquireCDF(CDFid id,long *numDims,long *dimSizes,long *encoding,long *majority,long *maxrRec,long *nrVars,long *maxzRec,long *nzVars,long *nAttrs);
VISIBLE_PREFIX CDFstatus CDFgetChecksum(CDFid id,long *checksum);

/*
 * READ_ *
 *       */

VISIBLE_PREFIX CDFstatus CDFreadgAttrEntry (CDFid id, long attrNum, long entryNum, long *dataType, long *numElms, CDFdata *value);
VISIBLE_PREFIX CDFstatus CDFreadzAttrEntry (CDFid id, long attrNum, long entryNum, long *dataType, long *numElms, CDFdata *value);
VISIBLE_PREFIX CDFstatus CDFreadAttrEntry (CDFid id, int grzEntry, long attrNum, long entryNum, long *dataType, long *numElms, CDFdata *value);
VISIBLE_PREFIX CDFstatus CDFreadzVarPadValue (CDFid id, long varNum, long *dataType, long *numElms, CDFdata *buffer);
VISIBLE_PREFIX CDFstatus CDFreadzVarAllByVarID (CDFid id, long varNum, long *numRecs, long *dataType, long *numElems, long *numDims, long *dimSizes, long *recVary, long *dimsVary, CDFdata *buffer);
VISIBLE_PREFIX CDFstatus CDFreadzVarDataByVarID (CDFid id, long varNum, long *numRecs, CDFdata *buffer);
VISIBLE_PREFIX CDFstatus CDFreadzVarRangeDataByVarID (CDFid id, long varNum, long strNum, long stpNum, CDFdata *buffer);
VISIBLE_PREFIX CDFstatus CDFreadzVarAllByVarName (CDFid id, char *varName, long *numRecs, long *dataType, long *numElems, long *numDims, long *dimSizes, long *recVary, long *dimsVary, CDFdata *buffer);
VISIBLE_PREFIX CDFstatus CDFreadzVarDataByVarName (CDFid id, char *varName, long *numRecs, CDFdata *buffer);
VISIBLE_PREFIX CDFstatus CDFreadzVarRangeDataByVarName (CDFid id, char *varName, long strNum, long stpNum, CDFdata *buffer);

/*
 * OPEN_ *
 *       */

VISIBLE_PREFIX CDFstatus CDFopen(char *CDFname,CDFid *id);

/*
 * PUT_ *
 *      */

VISIBLE_PREFIX CDFstatus CDFsetAttrScope(CDFid id,long attrNum,long attrScope);
VISIBLE_PREFIX CDFstatus CDFsetCompression(CDFid id,long cType, long *cParms);
VISIBLE_PREFIX CDFstatus CDFsetEncoding(CDFid id,long encoding);
VISIBLE_PREFIX CDFstatus CDFsetFormat(CDFid id,long format);
VISIBLE_PREFIX CDFstatus CDFsetMajority(CDFid id,long majority);
VISIBLE_PREFIX CDFstatus CDFrenameAttr(CDFid id,long attrNum,char *attrName);
VISIBLE_PREFIX CDFstatus CDFrenameVar(CDFid id,Logical zVar,long varNum,char *varName);
VISIBLE_PREFIX CDFstatus CDFsetVarAllocRecords(CDFid id,Logical zVar,long varNum,long allocRecs);
VISIBLE_PREFIX CDFstatus CDFsetVarAllocBlockRecords(CDFid id,Logical zVar,long varNum,long firstRec, long lastRec);
VISIBLE_PREFIX CDFstatus CDFsetVarBlockingFactor(CDFid id,Logical zVar,long varNum,long bf);
VISIBLE_PREFIX CDFstatus CDFsetVarCompression(CDFid id,Logical zVar,long varNum,long cType,long *cParms);
VISIBLE_PREFIX CDFstatus CDFsetVarDataSpec(CDFid id,Logical zVar,long varNum,long dataType,long numElems);
VISIBLE_PREFIX CDFstatus CDFsetVarDimVariances(CDFid id,Logical zVar,long varNum,long *dimVarys);
VISIBLE_PREFIX CDFstatus CDFsetVarInitialRecs(CDFid id,Logical zVar,long varNum,long numRecs);
VISIBLE_PREFIX CDFstatus CDFsetVarPadValue(CDFid id,Logical zVar,long varNum,void *padValue);
VISIBLE_PREFIX CDFstatus CDFsetVarRecVariance(CDFid id,Logical zVar,long varNum,long recVary);
VISIBLE_PREFIX CDFstatus CDFputVarSeqData(CDFid id,Logical zVar,long varNum,void *seqData);
VISIBLE_PREFIX CDFstatus CDFsetVarSparseRecords(CDFid id,Logical zVar,long varNum,long sparseRecs);
VISIBLE_PREFIX CDFstatus CDFputVarData(CDFid id,Logical zVar,long varNum,long recNum,long *indices,void *value);
VISIBLE_PREFIX CDFstatus CDFinsertVarRecordsByVarID(CDFid id,Logical zVar,long varNum,long recNum,long numRecs,void *values);
VISIBLE_PREFIX CDFstatus CDFputVarsRecordDatabyNumbers(CDFid id,Logical zVar,long numVars,long *varNums,long recNum,void *buffer);
VISIBLE_PREFIX CDFstatus CDFhyperPutVarData(CDFid id,Logical zVar,long varN,long recS,long recC,long recI,long *indices,long *counts,long *intervals,void *buff);
VISIBLE_PREFIX CDFstatus CDFsetChecksum(CDFid id,long checksum);

/*
 * SELECT_ *
 *         */

VISIBLE_PREFIX CDFstatus CDFselect(CDFid id);
VISIBLE_PREFIX CDFstatus CDFsetDecoding(CDFid id,long decoding);
VISIBLE_PREFIX CDFstatus CDFsetCacheSize(CDFid id,long numBuffers);
VISIBLE_PREFIX CDFstatus CDFsetVarCacheSize(CDFid id,Logical zVar,long varNum,long numBuffers);
VISIBLE_PREFIX CDFstatus CDFsetVarsCacheSize(CDFid id,Logical zVar,long numBuffers);
VISIBLE_PREFIX CDFstatus CDFsetVarSeqPos(CDFid id,Logical zVar,long varNum,long recNum,long *indices);
VISIBLE_PREFIX CDFstatus CDFsetNegtoPosfp0Mode(CDFid id,long negtoPosfp0);
VISIBLE_PREFIX CDFstatus CDFsetReadOnlyMode(CDFid id,long readOnlyMode);
VISIBLE_PREFIX CDFstatus CDFsetVarReservePercent(CDFid id,Logical zVar,long varNum,long percent);

/*
 * EPOCH_ *
 *        */

VISIBLE_PREFIX void EPOCHbreakdown PROTOARGs((
  double epoch, long *year, long *month, long *day, long *hour, long *minute,
  long *second, long *msec
));
VISIBLE_PREFIX double computeEPOCH PROTOARGs((
  long year, long month, long day, long hour, long minute, long second,
  long msec
));
VISIBLE_PREFIX double toParseEPOCH PROTOARGs((char *inString));
VISIBLE_PREFIX double parseEPOCH PROTOARGs((char *inString));
VISIBLE_PREFIX double parseEPOCH1 PROTOARGs((char *inString));
VISIBLE_PREFIX double parseEPOCH2 PROTOARGs((char *inString));
VISIBLE_PREFIX double parseEPOCH3 PROTOARGs((char *inString));
VISIBLE_PREFIX double parseEPOCH4 PROTOARGs((char *inString));
VISIBLE_PREFIX void toEncodeEPOCH PROTOARGs((
  double epoch, int style, char *epString
));
VISIBLE_PREFIX void encodeEPOCH PROTOARGs((
  double epoch, char epString[EPOCH_STRING_LEN+1]
));
VISIBLE_PREFIX void encodeEPOCH1 PROTOARGs((
  double epoch, char epString[EPOCH1_STRING_LEN+1]
));
VISIBLE_PREFIX void encodeEPOCH2 PROTOARGs((
  double epoch, char epString[EPOCH2_STRING_LEN+1]
));
VISIBLE_PREFIX void encodeEPOCH3 PROTOARGs((
  double epoch, char epString[EPOCH3_STRING_LEN+1]
));
VISIBLE_PREFIX void encodeEPOCH4 PROTOARGs((
  double epoch, char epString[EPOCH4_STRING_LEN+1]
));
VISIBLE_PREFIX void encodeEPOCHx PROTOARGs((
  double epoch, char format[EPOCHx_FORMAT_MAX],
  char encoded[EPOCHx_STRING_MAX]
));
VISIBLE_PREFIX void EPOCH16breakdown PROTOARGs((
  double epoch[], long *year, long *month, long *day, long *hour,
  long *minute, long *second, long *msec, long *usec, long *nsec, long *psec
));
VISIBLE_PREFIX double computeEPOCH16 PROTOARGs((
  long year, long month, long day, long hour, long minute, long second,
  long msec, long usec, long nsec, long psec, double epoch[]
));
VISIBLE_PREFIX double toParseEPOCH16 PROTOARGs((char *inString,
  double epoch[]
));
VISIBLE_PREFIX double parseEPOCH16 PROTOARGs((char *inString,
  double epoch[]
));
VISIBLE_PREFIX double parseEPOCH16_1 PROTOARGs((char *inStringch,
  double epoch[]
));
VISIBLE_PREFIX double parseEPOCH16_2 PROTOARGs((char *inStringch,
  double epoch[]
));
VISIBLE_PREFIX double parseEPOCH16_3 PROTOARGs((char *inStringch,
  double epoch[]
));
VISIBLE_PREFIX double parseEPOCH16_4 PROTOARGs((char *inStringch,
  double epoch[]
));
VISIBLE_PREFIX void toEncodeEPOCH16 PROTOARGs((
  double epoch[], int style, char *epString
));
VISIBLE_PREFIX void encodeEPOCH16 PROTOARGs((
  double epoch[], char epString[EPOCH16_STRING_LEN+1]
));
VISIBLE_PREFIX void encodeEPOCH16_1 PROTOARGs((
  double epoch[], char epString[EPOCH16_1_STRING_LEN+1]
));
VISIBLE_PREFIX void encodeEPOCH16_2 PROTOARGs((
  double epoch[], char epString[EPOCH16_2_STRING_LEN+1]
));
VISIBLE_PREFIX void encodeEPOCH16_3 PROTOARGs((
  double epoch[], char epString[EPOCH16_3_STRING_LEN+1]
));
VISIBLE_PREFIX void encodeEPOCH16_4 PROTOARGs((
  double epoch[], char epString[EPOCH16_4_STRING_LEN+1]
));
VISIBLE_PREFIX void encodeEPOCH16_x PROTOARGs((
  double epoch[], char format[EPOCHx_FORMAT_MAX], char encoded[EPOCHx_STRING_MAX]
));

/*
 * UTF8_ *
 *       */

VISIBLE_PREFIX int UTF8StrChars PROTOARGs((const char *, int));
VISIBLE_PREFIX int UTF8CharBytes PROTOARGs((const char *));
VISIBLE_PREFIX int UTF8CharAtOffset PROTOARGs((const char *, int));
VISIBLE_PREFIX char *UTF8CharAtString PROTOARGs((const char *, int));
VISIBLE_PREFIX int UTF8CharAtBytes PROTOARGs((const char *, int));
VISIBLE_PREFIX int UTF8StrCharFromCharAt PROTOARGs((const char *, int));
VISIBLE_PREFIX int UTF8ByteLengthFromCharAt PROTOARGs((const char *, int));
VISIBLE_PREFIX int UTF8toUnicode PROTOARGs((int *, const char *, int));
VISIBLE_PREFIX int UnicodetoUTF8 PROTOARGs((char *, int *, int));
VISIBLE_PREFIX unsigned char *UTF8Check PROTOARGs((unsigned char *, int, int *));
VISIBLE_PREFIX int IsUTF8Char(const char *s);

/*
 * TT2000_ *
 *         */

VISIBLE_PREFIX void breakdownTT2000 PROTOARGs((
  long long tt2000, double *year, double *month, double *day, ...
));
VISIBLE_PREFIX long long computeTT2000 PROTOARGs((
  double year, double month, double day, ...
));
VISIBLE_PREFIX double CDF_TT2000_to_UTC_EPOCH PROTOARGs((
  long long time
));
VISIBLE_PREFIX long long CDF_TT2000_from_UTC_EPOCH PROTOARGs((
  double epoch
));
VISIBLE_PREFIX double CDF_TT2000_to_UTC_EPOCH16 PROTOARGs((
  long long time, double *epoch16
));
VISIBLE_PREFIX long long CDF_TT2000_from_UTC_EPOCH16 PROTOARGs((
  double *epoch16
));
VISIBLE_PREFIX void toEncodeTT2000 PROTOARGs((
  long long time, int style, char *string
));
VISIBLE_PREFIX void encodeTT2000 PROTOARGs((
  long long time, char *string, ...
));
VISIBLE_PREFIX long long toParseTT2000 PROTOARGs((
  char *string
));
VISIBLE_PREFIX long long parseTT2000 PROTOARGs((
  char *string
));
VISIBLE_PREFIX void CDFClearLeapSecondsTable PROTOARGs(());
VISIBLE_PREFIX void CDFfillLeapSecondsTable PROTOARGs((
  double **table
));
VISIBLE_PREFIX int CDFgetRowsinLeapSecondsTable PROTOARGs(());
VISIBLE_PREFIX int CDFgetLeapSecondsTableStatus PROTOARGs(());

/*****************************************************************************  
 C#-CDF functions
 *****************************************************************************/

/*
 * CLOSE_  *
 *         */

VISIBLE_PREFIX CDFstatus STD_CALL CDFcloseCS(CDFid id);
VISIBLE_PREFIX CDFstatus STD_CALL CDFcloseVarCS(CDFid id,Logical zVar,long varNum);

/*
 * CONFIRM_  *
 *           */

VISIBLE_PREFIX CDFstatus STD_CALL CDFconfirmAttrExistenceCS(CDFid id,char *attrName);
VISIBLE_PREFIX CDFstatus STD_CALL CDFconfirmgEntryExistenceCS(CDFid id,long attrNum,long entryNum);
VISIBLE_PREFIX CDFstatus STD_CALL CDFconfirmrEntryExistenceCS(CDFid id,long attrNum,long entryNum);
VISIBLE_PREFIX CDFstatus STD_CALL CDFconfirmVarExistenceCS(CDFid id,Logical zVar,char *varName);
VISIBLE_PREFIX CDFstatus STD_CALL CDFconfirmVarPadValueExistenceCS(CDFid id,Logical zVar,long varNum);
VISIBLE_PREFIX CDFstatus STD_CALL CDFconfirmzEntryExistenceCS(CDFid id,long attrNum,long entryNum);
VISIBLE_PREFIX CDFstatus STD_CALL CDFconfirmChecksumCS(CDFid id);

/*
 * CREATE_ *
 *         */

VISIBLE_PREFIX CDFstatus STD_CALL CDFcreateCS(char *CDFname,long numDims,long *dimSizes,long encoding,long majority,CDFid *id);
VISIBLE_PREFIX CDFstatus STD_CALL CDFcreateAttrCS(CDFid id,char *attrName,long attrScope,long *attrNum);
VISIBLE_PREFIX CDFstatus STD_CALL CDFcreaterVarCS(CDFid id,char *varName,long dataType,long numElements,long recVary,long *dimVarys,long *varNum);
VISIBLE_PREFIX CDFstatus STD_CALL CDFcreatezVarCS(CDFid id,char *varName,long dataType,long numElements,long numDims,long *dimSizes,long recVary,long *dimVarys,long *varNum);
VISIBLE_PREFIX CDFstatus STD_CALL CDFcreateCDFCS(char *name, CDFid *id);

/*
 * DELETE_ *
 *         */

VISIBLE_PREFIX CDFstatus STD_CALL CDFdeleteCS(CDFid id);
VISIBLE_PREFIX CDFstatus STD_CALL CDFdeleteAttrCS(CDFid id,long attrNum);
VISIBLE_PREFIX CDFstatus STD_CALL CDFdeleteVarCS(CDFid id,Logical zVar,long varNum);
VISIBLE_PREFIX CDFstatus STD_CALL CDFdeleteVarRecordsCS(CDFid id,Logical zVar,long varNum,long firstRec,long lastRec);
VISIBLE_PREFIX CDFstatus STD_CALL CDFdeleteAttrEntryCS(CDFid id, int grzEntry, long attrNum, long entryNum);

/*
 * GET_ *
 *      */

VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarReservePercentCS(CDFid id,Logical zVar,long varNum,long *percent);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetAttrNameCS(CDFid id,long attrNum,char *attrName);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetAttrScopeCS(CDFid id,long attrNum,long *attrScope);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetCacheSizeCS(CDFid id,long *numBuffers);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetCompressionCS(CDFid id,long *cType, long *cParms, long *cPercent);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetCompressionCacheSizeCS(CDFid id,long *numBuffers);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetCopyrightCS(CDFid id,char *copyright);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetDataTypeSizeCS(long dataType,long *numBytes);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetDecodingCS(CDFid id,long *decoding);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetEncodingCS(CDFid id,long *encoding);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetFormatCS(CDFid id,long *format);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetCompressionInfoCS(char *name,long *cType,long *cParms,OFF_T *cSize,OFF_T *uSize);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetMajorityCS(CDFid id,long *majority);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetNameCS(CDFid id,char *cdfName);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetNegtoPosfp0ModeCS(CDFid id,long *negtoPosfp0);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetNumAttributesCS(CDFid id,long *numAttrs);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetNumgAttributesCS(CDFid id,long *numgAttrs);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetNumVarsCS(CDFid id,Logical zVar,long *numVars);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetNumvAttributesCS(CDFid id,long *numvAttrs);
VISIBLE_PREFIX CDFstatus STD_CALL CDFdocCS(CDFid id,long *version,long *release,char *copyright);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetLibraryCopyrightCS(char *copyright);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetLibraryVersionCS(long *version,long *release,long *increment,char *subincrement);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetReadOnlyModeCS(CDFid id,long *readOnlyMode);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetStageCacheSizeCS(CDFid id,long *numBuffers);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVersionCS(CDFid id,long *version,long *release,long *increment);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarBlockingFactorCS(CDFid id,Logical zVar,long varNum,long *bf);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarCacheSizeCS(CDFid id,Logical zVar,long varNum,long *numBuffers);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarCompressionCS(CDFid id,Logical zVar,long varNum,long *cType,long *cParms,long *cPct);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarDataCS(CDFid id,Logical zVar,long varNum,long recNum,long *indices,void *value);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarDataTypeCS(CDFid id,Logical zVar,long varNum,long *dataType);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarDimVariancesCS(CDFid id,Logical zVar,long varNum,long *dimVarys);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarMaxAllocRecNumCS(CDFid id,Logical zVar,long varNum,long *maxAllocRec);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarMaxWrittenRecNumCS(CDFid id,Logical zVar,long varNum,long *maxRec);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarAllocRecordsCS(CDFid id,Logical zVar,long varNum,long *numAllocRecs);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarNumElementsCS(CDFid id,Logical zVar,long varNum,long *numElements);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarNumRecsWrittenCS(CDFid id,Logical zVar,long varNum,long *numRecs);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarPadValueCS(CDFid id,Logical zVar,long varNum,void *padValue);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarRecVarianceCS(CDFid id,Logical zVar,long varNum,long *recVary);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarSeqDataCS(CDFid id,Logical zVar,long varNum,void *seqData);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarSeqPosCS(CDFid id,Logical zVar,long varNum,long *recNum,long *indices);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarsRecordDatabyNumbersCS(CDFid id,Logical zVar,long numVars,long *varNums,long recNum,void *buffer);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarSparseRecordsCS(CDFid id,Logical zVar,long varNum,long *sparseRecs);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetrVarsDimSizesCS(CDFid id,long *dimSizes);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetzModeCS(CDFid id,long *zMode);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetzVarDimSizesCS(CDFid id,long varNum,long *dimSizes);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarNameCS(CDFid id,Logical zVar,long varNum,char *varName);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetzVarNumDimsCS(CDFid id,long varNum,long *numDims);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetrVarsNumDimsCS(CDFid id,long *numDims);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetStatusTextCS(CDFstatus status,char *text);
VISIBLE_PREFIX CDFstatus STD_CALL CDFhyperGetVarDataCS(CDFid id,Logical zVar,long varN,long recS,long recC,long recI,long *indices,long *counts,long *intervals,void *buff);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetMaxWrittenRecNumsCS(CDFid id,long *maxRecrVars,long *maxReczVars);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarsMaxWrittenRecNumCS(CDFid id,Logical zVar,long *maxRecVar);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetChecksumCS(CDFid id,long *checksum);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarInfoCS(CDFid id,Logical zVar,long varNum,long *dataType,long *numElems,long *numDims,long *dimSizes);
VISIBLE_PREFIX int STD_CALL CDFgetFileBackwardCS ();
VISIBLE_PREFIX long STD_CALL CDFgetChecksumModeCS ();
VISIBLE_PREFIX int STD_CALL CDFgetFileBackwardFlagCS ();
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetAttrEntryCS(CDFid id, int grzEntry, long attrNum, long entryNum, void *value);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetAttrEntryStringsCS(CDFid id, int rzEntry, long attrNum, long entryNum, long *numStrings, char ***strings);
VISIBLE_PREFIX long STD_CALL CDFgetAttrNumCS(CDFid id, char *attrName);
VISIBLE_PREFIX long STD_CALL CDFgetVarNumCS(CDFid id, char *varName);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetNumAttrEntriesCS(CDFid id, int grzEntry, long attrNum, long *numEntries);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetAttrMaxEntryCS(CDFid id, int grzEntry, long attrNum, long *maxEntry);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetAttrEntryDataTypeCS(CDFid id, int grzEntry, long attrNum, long entryNum, long *dataType);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetAttrEntryNumElementsCS(CDFid id, int grzEntry, long attrNum, long entryNum, long *numElements);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetAttrEntryNumStringsCS(CDFid id, int rzEntry, long attrNum, long entryNum, long *numStrings);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarRecordDataCS(CDFid id, int zVar, long varNum, long recNum, void *buffer);
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetVarsRecordDatabyNamesCS(CDFid id, int zVar, long numVars, char *varNames[], long recNum, void *buffer[]);
VISIBLE_PREFIX void STD_CALL CDFgetLeapSecondsTableEnvVarCS (char *table);
VISIBLE_PREFIX int STD_CALL CDFgetLeapSecondsTableStatusCS ();
VISIBLE_PREFIX int STD_CALL CDFgetRowsinLeapSecondsTableCS ();
VISIBLE_PREFIX void STD_CALL CDFgetLastDateinLeapSecondsTableCS (long *year, long *month, long *day);
VISIBLE_PREFIX void STD_CALL CDFgetLeapSecondsTableCS (double *table);
VISIBLE_PREFIX char* CDFgetLeapSecondsTableEnvVar ();
VISIBLE_PREFIX int CDFgetLeapSecondsTableStatus ();
VISIBLE_PREFIX int CDFgetRowsinLeapSecondsTable ();
VISIBLE_PREFIX void CDFgetLastDateinLeapSecondsTable (long *year, long *month, long *day);
VISIBLE_PREFIX int STD_CALL CDFgetFileBackwardEnvVarCS ();
VISIBLE_PREFIX int STD_CALL CDFgetChecksumEnvVarCS ();
VISIBLE_PREFIX int STD_CALL CDFgetValidateCS ();
VISIBLE_PREFIX int STD_CALL CDFgetValidateDebugCS ();
VISIBLE_PREFIX CDFstatus STD_CALL CDFgetLeapSecondLastUpdatedCS (CDFid id, long *lastUpdated);
VISIBLE_PREFIX CDFstatus CDFgetLeapSecondLastUpdated (CDFid id, long *lastUpdated);

/*
 * OPEN_ *
 *       */

VISIBLE_PREFIX CDFstatus STD_CALL CDFopenCS(char *CDFname,CDFid *id);

/*
 * RENAME_ *
 *         */

VISIBLE_PREFIX CDFstatus STD_CALL CDFrenameAttrCS(CDFid id,long attrNum,char *attrName);
VISIBLE_PREFIX CDFstatus STD_CALL CDFrenameVarCS(CDFid id,Logical zVar,long varNum,char *varName);

/*
 * PUT_ *
 *      */

VISIBLE_PREFIX CDFstatus STD_CALL CDFputVarSeqDataCS(CDFid id,Logical zVar,long varNum,void *seqData);
VISIBLE_PREFIX CDFstatus STD_CALL CDFputVarDataCS(CDFid id,Logical zVar,long varNum,long recNum,long *indices,void *value);
VISIBLE_PREFIX CDFstatus STD_CALL CDFputVarsRecordDatabyNumbersCS(CDFid id,Logical zVar,long numVars,long *varNums,long recNum,void *buffer);
VISIBLE_PREFIX CDFstatus STD_CALL CDFhyperPutVarDataCS(CDFid id,Logical zVar,long varN,long recS,long recC,long recI,long *indices,long *counts,long *intervals,void *buff);
VISIBLE_PREFIX CDFstatus STD_CALL CDFputAttrEntryCS(CDFid id, int grzEntry, long attrNum, long entryNum, long dataType, long numElems, void *value);
VISIBLE_PREFIX CDFstatus STD_CALL CDFputAttrEntryStringsCS(CDFid id, int rzEntry, long attrNum, long entryNum, long numStrings, char **strings);
VISIBLE_PREFIX CDFstatus STD_CALL CDFputVarRecordDataCS(CDFid id, int zVar, long varNum, long recNum, void *buffer);
VISIBLE_PREFIX CDFstatus STD_CALL CDFputVarsRecordDatabyNamesCS(CDFid id, int zVar, long numVars, char *varNames[], long recNum, void *buffer[]);
VISIBLE_PREFIX CDFstatus STD_CALL CDFputVarSeqDataCS(CDFid id,Logical zVar,long varNum,void *seqData);

/*
 * SELECT_  *
 *          */

VISIBLE_PREFIX CDFstatus STD_CALL CDFselectCS(CDFid id);

/*
 * SET_    *
 *         */

VISIBLE_PREFIX CDFstatus STD_CALL CDFsetChecksumCS(CDFid id,long checksum);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetDecodingCS(CDFid id,long decoding);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetCacheSizeCS(CDFid id,long numBuffers);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetVarCacheSizeCS(CDFid id,Logical zVar,long varNum,long numBuffers);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetVarsCacheSizeCS(CDFid id,Logical zVar,long numBuffers);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetVarSeqPosCS(CDFid id,Logical zVar,long varNum,long recNum,long *indices);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetNegtoPosfp0ModeCS(CDFid id,long negtoPosfp0);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetReadOnlyModeCS(CDFid id,long readOnlyMode);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetVarReservePercentCS(CDFid id,Logical zVar,long varNum,long percent);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetCompressionCacheSizeCS(CDFid id,long numBuffers);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetStageCacheSizeCS(CDFid id,long numBuffers);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetzModeCS(CDFid id,long zMode);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetAttrEntryDataSpecCS(CDFid id, int grzEntry, long attrNum, long entryNum, long dataType, long numElems);
VISIBLE_PREFIX void STD_CALL CDFsetFileBackwardCS (int flag);
VISIBLE_PREFIX void STD_CALL CDFsetChecksumModeCS (long flag);
VISIBLE_PREFIX void STD_CALL CDFsetFileBackwardFlagCS (int flag);
VISIBLE_PREFIX void STD_CALL CDFsetValidateCS (long validate);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetLeapSecondLastUpdatedCS (CDFid id, long lastUpdated);
VISIBLE_PREFIX CDFstatus CDFsetLeapSecondLastUpdated (CDFid id, long lastUpdated);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetAttrScopeCS(CDFid id,long attrNum,long attrScope);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetCompressionCS(CDFid id,long cType, long *cParms);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetEncodingCS(CDFid id,long encoding);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetFormatCS(CDFid id,long format);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetMajorityCS(CDFid id,long majority);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetVarAllocRecordsCS(CDFid id,Logical zVar,long varNum,long allocRecs);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetVarAllocBlockRecordsCS(CDFid id,Logical zVar,long varNum,long firstRec, long lastRec);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetVarBlockingFactorCS(CDFid id,Logical zVar,long varNum,long bf);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetVarCompressionCS(CDFid id,Logical zVar,long varNum,long cType,long *cParms);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetVarDataSpecCS(CDFid id,Logical zVar,long varNum,long dataType,long numElems);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetVarDimVariancesCS(CDFid id,Logical zVar,long varNum,long *dimVarys);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetVarInitialRecsCS(CDFid id,Logical zVar,long varNum,long numRecs);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetVarPadValueCS(CDFid id,Logical zVar,long varNum,void *padValue);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetVarRecVarianceCS(CDFid id,Logical zVar,long varNum,long recVary);
VISIBLE_PREFIX CDFstatus STD_CALL CDFsetVarSparseRecordsCS(CDFid id,Logical zVar,long varNum,long sparseRecs);

/*
 * INQUIRE_  *
 *           */

VISIBLE_PREFIX CDFstatus STD_CALL CDFattrInquireCS(CDFid id, long attrNum, char *attrName, long *attrScope, long *maxgrEntry); 
VISIBLE_PREFIX CDFstatus STD_CALL CDFinquireAttrCS(CDFid id, long attrNum, char *attrName, long *attrScope, long *maxgEntry, long *maxrEntry, long *maxzEntry);
VISIBLE_PREFIX CDFstatus STD_CALL CDFinquireAttrEntryCS(CDFid id, int grzEntry, long attrNum, long entryNum, long *dataType, long *numElems);
VISIBLE_PREFIX CDFstatus STD_CALL CDFinquireAttrInfoCS(CDFid id, int zEntry, long attrNum, char *attrName, long *attrScope, long *maxEntry);
VISIBLE_PREFIX CDFstatus STD_CALL CDFinquireVarCS(CDFid id,Logical zVar,long varN,char *varName,long *dataType,long *numElements,long *numDims,long *dimSizes,long *recVary,long *dimVarys);
VISIBLE_PREFIX CDFstatus STD_CALL CDFvarInquireCS(CDFid id,long varN,char *varName,long *dataType,long *numElements,long *recVary,long *dimVarys);
VISIBLE_PREFIX CDFstatus STD_CALL CDFinquireCS(CDFid id,long *numDims,long *dimSizes,long *encoding,long *majority,long *maxRec,long *nVars,long *nAttrs);
VISIBLE_PREFIX CDFstatus STD_CALL CDFinquireCDFCS(CDFid id,long *numDims,long *dimSizes,long *encoding,long *majority,long *maxrRec,long *nrVars,long *maxzRec,long *nzVars,long *nAttrs);


/*
 * EPOCH_ *
 *        */

VISIBLE_PREFIX double STD_CALL toParseEPOCHCS (char *inString);
VISIBLE_PREFIX double STD_CALL parseEPOCHCS (char *inString);
VISIBLE_PREFIX double STD_CALL toParseEPOCH16CS (char *inString, double *epoch);
VISIBLE_PREFIX double STD_CALL parseEPOCH16CS (char *inString, double *epoch);
VISIBLE_PREFIX double STD_CALL parseEPOCH1CS (char *inString);
VISIBLE_PREFIX double STD_CALL parseEPOCH16_1CS (char *inString, double *epoch);
VISIBLE_PREFIX double STD_CALL parseEPOCH2CS (char *inString);
VISIBLE_PREFIX double STD_CALL parseEPOCH16_2CS (char *inString, double *epoch);
VISIBLE_PREFIX double STD_CALL parseEPOCH3CS (char *inString);
VISIBLE_PREFIX double STD_CALL parseEPOCH16_3CS (char *inString, double *epoch);
VISIBLE_PREFIX double STD_CALL parseEPOCH4CS (char *inString);
VISIBLE_PREFIX double STD_CALL parseEPOCH16_4CS (char *inString, double *epoch);
VISIBLE_PREFIX void STD_CALL EPOCHtoUnixTimeCS (double *epoch, double *unixtime, int num);
VISIBLE_PREFIX void STD_CALL UnixTimetoEPOCHCS (double *unixtime, double *epoch, int num);
VISIBLE_PREFIX void STD_CALL EPOCH16toUnixTimeCS (double *epoch, double *unixtime, int num);
VISIBLE_PREFIX void STD_CALL UnixTimetoEPOCH16CS (double *unixtime, double *epoch, int num);
VISIBLE_PREFIX void STD_CALL encodeEPOCHCS (double epoch, char *epString);
VISIBLE_PREFIX void STD_CALL encodeEPOCH16CS (double *epoch, char *epString);
VISIBLE_PREFIX void STD_CALL encodeEPOCH1CS (double epoch, char *epString);
VISIBLE_PREFIX void STD_CALL encodeEPOCH16_1CS (double *epoch, char *epString);
VISIBLE_PREFIX void STD_CALL encodeEPOCH2CS (double epoch, char *epString);
VISIBLE_PREFIX void STD_CALL encodeEPOCH16_2CS (double *epoch, char *epString);
VISIBLE_PREFIX void STD_CALL encodeEPOCH3CS (double epoch, char *epString);
VISIBLE_PREFIX void STD_CALL encodeEPOCH16_3CS (double *epoch, char *epString);
VISIBLE_PREFIX void STD_CALL encodeEPOCH4CS (double epoch, char *epString);
VISIBLE_PREFIX void STD_CALL encodeEPOCH16_4CS (double *epoch, char *epString);
VISIBLE_PREFIX void STD_CALL encodeEPOCHxCS (double epoch, char *format, char *encoded);
VISIBLE_PREFIX void STD_CALL encodeEPOCH16_xCS (double *epoch, char *format, char *encoded);
VISIBLE_PREFIX double STD_CALL computeEPOCHCS (long year, long month, long day, long hour, long minute, long second, long msec);
VISIBLE_PREFIX double STD_CALL computeEPOCH16CS (long year, long month, long day, long hour, long minute, long second, long msec, long usec, long nsec, long psec, double *epoch);
VISIBLE_PREFIX void STD_CALL EPOCHbreakdownCS (double epoch, long *year, long *month, long *day, long *hour, long *minute, long *second, long *msec);
VISIBLE_PREFIX void STD_CALL EPOCH16breakdownCS (double *epoch, long *year, long *month, long *day, long *hour, long *minute, long *second, long *msec, long *usec, long *nsec, long *psec);

/*
 * TT2000_ *
 *         */

VISIBLE_PREFIX long long STD_CALL toParseTT2000CS (char *inString);
VISIBLE_PREFIX long long STD_CALL parseTT2000CS (char *inString);
VISIBLE_PREFIX long long STD_CALL computeTT2000CS (double year, double month, double day, double hour, double minute, double second, double msec, double usec, double nsec);
VISIBLE_PREFIX void STD_CALL TT2000breakdownCS (long long epoch, double *year, double *month, double *day, double *hour, double *minute, double *second, double *msec, double *usec, double *nsec);
VISIBLE_PREFIX void STD_CALL TT2000toUnixTimeCS (long long *epoch, double *unixtime, int num);
VISIBLE_PREFIX void STD_CALL UnixTimetoTT2000CS (double *unixtime, long long *epoch, int num);
VISIBLE_PREFIX void STD_CALL encodeTT2000CS (long long epoch, char *epStringi, int format);

/*
 * Others *
 *        */

VISIBLE_PREFIX long STD_CALL CDFChecksumMethodCS (int flags);

#if defined(__cplusplus)
}
#endif

#endif
