Imports System
Imports System.Runtime.InteropServices
Imports CDF

Public Class Qst2cEpoch16
	Inherits CDFAPIs

	Public Shared Sub Main()
		Dim year As Integer = 2001, month As Integer = 10, _
		    day As Integer = 1, hour As Integer = 12, _
		    minute As Integer = 10, second As Integer = 20, _
		    msec As Integer = 100, usec As Integer = 200, _
		    nsec As Integer = 300, psec As Integer = 400
		Dim yearOut As Integer, monthOut As Integer, _
		    dayOut As Integer, hourOut As Integer, _
		    minuteOut As Integer, secondOut As Integer, _
		    msecOut As Integer, usecOut As Integer, _
		    nsecOut As Integer, psecOut As Integer
		Dim mmm As Double
		Dim epoch16 As Double() = New Double(2) {}, _
		    epoch16Save As Double() = New Double(2) {}
		Dim encodeText As String

		'
		' Display title.
		'


		Console.WriteLine("Testing VB interface for CDF_EPOCH16 ...")
		Try
			mmm = computeEPOCH16(year, month, day, hour, minute, _
					     second, msec, usec, nsec, psec, _
					     epoch16)

			epoch16Save(0) = epoch16(0)
			epoch16Save(1) = epoch16(1)

			encodeEPOCH16(epoch16, encodeText)
			Console.WriteLine("encodeEPOCH16: " + encodeText)
			encodeEPOCH16_x(epoch16, _
					"<dom.02>-<month>-<year> <hour>:<min>:<sec>.<fos>", _
					encodeText)
			Console.WriteLine("encodeEPOCH16_x: " + encodeText)

			encodeEPOCH16_x(epoch16, "<dom.02>-<month>-<year> <hour>:<min>:<sec>.<msc>:<usc>:<nsc>:<psc>", encodeText)
			Console.WriteLine("encodeEPOCH16_x: " + encodeText)
			encodeEPOCH16_1(epoch16, encodeText)
			Console.WriteLine("1. encodeEPOCH16_1: " + encodeText)
			mmm = parseEPOCH16_1(encodeText, epoch16)

			encodeEPOCH16_1(epoch16, encodeText)
			Console.WriteLine("2. parseEPOCH16_1:  " + encodeText)

			epoch16(0) = epoch16Save(0)
			epoch16(1) = epoch16Save(1)
			encodeEPOCH16_2(epoch16, encodeText)
			Console.WriteLine("3. encodeEPOCH16_2: " + encodeText)
			mmm = parseEPOCH16_2(encodeText, epoch16)

			encodeEPOCH16_2(epoch16, encodeText)
			Console.WriteLine("4. parseEPOCH16_2:  " + encodeText)

			epoch16(0) = epoch16Save(0)
			epoch16(1) = epoch16Save(1)
			encodeEPOCH16_3(epoch16, encodeText)
			Console.WriteLine("5. encodeEPOCH16_3: " + encodeText)
						mmm = parseEPOCH16_3(encodeText, epoch16)

			encodeEPOCH16_3(epoch16, encodeText)
			Console.WriteLine("6. parseEPOCH16_3:  " + encodeText)

			epoch16(0) = epoch16Save(0)
			epoch16(1) = epoch16Save(1)
			encodeEPOCH16_4(epoch16, encodeText)
			Console.WriteLine("7. encodeEPOCH16_4: " + encodeText)
						mmm = parseEPOCH16_4(encodeText, epoch16)

			encodeEPOCH16_4(epoch16, encodeText)
			Console.WriteLine("8. parseEPOCH16_4:  " + encodeText)

			epoch16(0) = epoch16Save(0)
			epoch16(1) = epoch16Save(1)

			EPOCH16breakdown(epoch16, yearOut, monthOut, dayOut, hourOut, minuteOut, _
				secondOut, msecOut, usecOut, nsecOut, psecOut)
			If year <> yearOut Then
				Quit("9.2a")
			End If
			If month <> monthOut Then
				Quit("9.3a")
			End If
			If day <> dayOut Then
				Quit("9.4a")
			End If
			If hour <> hourOut Then
				Quit("9.5a")
			End If
			If minute <> minuteOut Then
				Quit("9.6a")
			End If
			If second <> secondOut Then
				Quit("9.7a")
			End If
			If msec <> msecOut Then
				Quit("9.8a")
			End If
			If usec <> usecOut Then
				Quit("9.9a")
			End If
			If nsec <> nsecOut Then
				Quit("9.10a")
			End If
			If psec <> psecOut Then
				Quit("9.11a")
			End If

			Dim yearOuto As Integer, monthOuto As Integer, _
			    dayOuto As Integer, hourOuto As Integer, _
			    minuteOuto As Integer, secondOuto As Integer, _
			    msecOuto As Integer, usecOuto As Integer, _
			    nsecOuto As Integer, psecOuto As Integer
			EPOCH16breakdown(epoch16, yearOuto, monthOuto, dayOuto, hourOuto, minuteOuto, _
				secondOuto, msecOuto, usecOuto, nsecOuto, psecOuto)
			If year <> CInt(yearOuto) Then
				Quit("10.2a")
			End If
			If month <> CInt(monthOuto) Then
				Quit("10.3a")
			End If
			If day <> CInt(dayOuto) Then
				Quit("10.4a")
			End If
			If hour <> CInt(hourOuto) Then
				Quit("10.5a")
			End If
			If minute <> CInt(minuteOuto) Then
				Quit("10.6a")
			End If
			If second <> CInt(secondOuto) Then
				Quit("10.7a")
			End If
			If msec <> CInt(msecOuto) Then
				Quit("10.8a")
			End If
			If usec <> CInt(usecOuto) Then
				Quit("10.9a")
			End If
			If nsec <> CInt(nsecOuto) Then
				Quit("10.10a")
			End If
			If psec <> CInt(psecOuto) Then
				Quit("10.11a")

			End If
		Catch ex As CDFException
			Console.WriteLine("Error: " + ex.toString())
		End Try
	End Sub


	'
	' Quit
	'


	Private Shared Sub Quit(where As String)
		Console.WriteLine("Aborting at " + where)
	End Sub

End Class

