@echo off
set mydir=%~dp0
set mysrc=%mydir%..\src\lib
set mytool=%mydir%..\src\tools
set mycurses=%mydir%..\win32\pdcurses
set zip=%mysrc%\zlib
set mytests=%mydir%..\cdf_tests

echo.
echo Building CDF library...
echo.
echo cl /O2 /c /utf-8 /I . /I %mysrc%\..\include /I %zip% /D"_FILE_OFFSET_BITS=64" /D"_LARGEFILE64_SOURCE" /D"_LARGEFILE_SOURCE" /D"WIN32" /D "double_underscore" /D "_USRDLL" /D"DLLCDF_EXPORTS" /D "BUILDINGforDLL" /D"_LIB" /D"Z_PREFIX" /D"MALLOC_CHECK=0" /MT /EHsc %mysrc%\cdfed.c %mysrc%\cdflib.c %mysrc%\cdfput2_64.c %mysrc%\cdfvalidator.c %mysrc%\cdfalloc.c %mysrc%\cdffii.c %mysrc%\cdfmd5.c %mysrc%\cdfread.c %mysrc%\cdfvalidator64.c %mysrc%\cdfalloc64.c %mysrc%\cdffsi.c %mysrc%\cdfmem.c %mysrc%\cdfread64.c %mysrc%\cdfwrite.c %mysrc%\cdfcks.c %mysrc%\cdffsi2.c %mysrc%\cdfmisc1.c %mysrc%\cdfrle.c %mysrc%\cdfwrite64.c %mysrc%\cdfclo.c %mysrc%\cdffsi3.c %mysrc%\cdfmisc1_64.c %mysrc%\cdfrle64.c %mysrc%\dirutils.c %mysrc%\cdfclo64.c %mysrc%\cdfget.c %mysrc%\cdfmisc2.c %mysrc%\cdfsav.c %mysrc%\epochu.c %mysrc%\cdfcon.c %mysrc%\cdfget64.c %mysrc%\cdfmisc2_64.c %mysrc%\cdfsel.c %mysrc%\epochuf.c %mysrc%\cdfcon64.c %mysrc%\cdfgzip.c %mysrc%\cdfmisc3.c %mysrc%\cdfsel64.c %mysrc%\libmain.c %mysrc%\cdfcre.c %mysrc%\cdfgzip64.c %mysrc%\cdfmisc3_64.c %mysrc%\cdfstr.c %mysrc%\vstream.c %mysrc%\cdfcre64.c %mysrc%\cdfhuff.c %mysrc%\cdfope.c %mysrc%\cdftext.c %mysrc%\vstream64.c %mysrc%\cdfcsi.c %mysrc%\cdfhuff64.c %mysrc%\cdfput1.c %mysrc%\cdftt2000.c %mysrc%\cdfdel.c %mysrc%\cdfhyper.c %mysrc%\cdfput1_64.c %mysrc%\cdftt2000f.c %mysrc%\cdfdel64.c %mysrc%\cdfhyper64.c  %mysrc%\cdfput2.c %mysrc%\cdfvalid.c %zip%\adler32.c %zip%\deflate.c %zip%\inffast.c %zip%\trees.c %zip%\inflate.c %zip%\crc32.c %zip%\infback.c %zip%\inftrees.c %zip%\zutil.c
cl /O2 /c /utf-8 /I . /I %mysrc%\..\include /I %zip% /D"_FILE_OFFSET_BITS=64" /D"_LARGEFILE64_SOURCE" /D"_LARGEFILE_SOURCE" /D"WIN32" /D "double_underscore" /D "_USRDLL" /D"DLLCDF_EXPORTS" /D "BUILDINGforDLL" /D"_LIB" /D"Z_PREFIX" /D"MALLOC_CHECK=0" /MT /EHsc %mysrc%\cdfed.c %mysrc%\cdflib.c %mysrc%\cdfput2_64.c %mysrc%\cdfvalidator.c %mysrc%\cdfalloc.c %mysrc%\cdffii.c %mysrc%\cdfmd5.c %mysrc%\cdfread.c %mysrc%\cdfvalidator64.c %mysrc%\cdfalloc64.c %mysrc%\cdffsi.c %mysrc%\cdfmem.c %mysrc%\cdfread64.c %mysrc%\cdfwrite.c %mysrc%\cdfcks.c %mysrc%\cdffsi2.c %mysrc%\cdfmisc1.c %mysrc%\cdfrle.c %mysrc%\cdfwrite64.c %mysrc%\cdfclo.c %mysrc%\cdffsi3.c %mysrc%\cdfmisc1_64.c %mysrc%\cdfrle64.c %mysrc%\dirutils.c %mysrc%\cdfclo64.c %mysrc%\cdfget.c %mysrc%\cdfmisc2.c %mysrc%\cdfsav.c %mysrc%\epochu.c %mysrc%\cdfcon.c %mysrc%\cdfget64.c %mysrc%\cdfmisc2_64.c %mysrc%\cdfsel.c %mysrc%\epochuf.c %mysrc%\cdfcon64.c %mysrc%\cdfgzip.c %mysrc%\cdfmisc3.c %mysrc%\cdfsel64.c %mysrc%\libmain.c %mysrc%\cdfcre.c %mysrc%\cdfgzip64.c %mysrc%\cdfmisc3_64.c %mysrc%\cdfstr.c %mysrc%\vstream.c %mysrc%\cdfcre64.c %mysrc%\cdfhuff.c %mysrc%\cdfope.c %mysrc%\cdftext.c %mysrc%\vstream64.c %mysrc%\cdfcsi.c %mysrc%\cdfhuff64.c %mysrc%\cdfput1.c %mysrc%\cdftt2000.c %mysrc%\cdfdel.c %mysrc%\cdfhyper.c %mysrc%\cdfput1_64.c %mysrc%\cdftt2000f.c %mysrc%\cdfdel64.c %mysrc%\cdfhyper64.c  %mysrc%\cdfput2.c %mysrc%\cdfvalid.c %zip%\adler32.c %zip%\deflate.c %zip%\inffast.c %zip%\trees.c %zip%\inflate.c %zip%\crc32.c %zip%\infback.c %zip%\inftrees.c %zip%\zutil.c

echo lib /out:libcdf.lib /MACHINE:X64 cdfed.obj cdflib.obj cdfput2_64.obj cdfvalidator.obj cdfalloc.obj cdffii.obj cdfmd5.obj cdfread.obj cdfvalidator64.obj cdfalloc64.obj cdffsi.obj cdfmem.obj cdfread64.obj cdfwrite.obj cdfcks.obj cdffsi2.obj cdfmisc1.obj cdfrle.obj cdfwrite64.obj cdfclo.obj cdffsi3.obj cdfmisc1_64.obj cdfrle64.obj dirutils.obj cdfclo64.obj cdfget.obj cdfmisc2.obj cdfsav.obj epochu.obj cdfcon.obj cdfget64.obj cdfmisc2_64.obj cdfsel.obj epochuf.obj cdfcon64.obj cdfgzip.obj cdfmisc3.obj cdfsel64.obj libmain.obj cdfcre.obj cdfgzip64.obj cdfmisc3_64.obj cdfstr.obj vstream.obj cdfcre64.obj cdfhuff.obj cdfope.obj cdftext.obj vstream64.obj cdfcsi.obj cdfhuff64.obj cdfput1.obj cdftt2000.obj cdfdel.obj cdfhyper.obj cdfput1_64.obj cdftt2000f.obj cdfdel64.obj cdfhyper64.obj  cdfput2.obj cdfvalid.obj adler32.obj deflate.obj inffast.obj trees.obj inflate.obj crc32.obj infback.obj inftrees.obj zutil.obj
lib /out:libcdf.lib /MACHINE:X64 cdfed.obj cdflib.obj cdfput2_64.obj cdfvalidator.obj cdfalloc.obj cdffii.obj cdfmd5.obj cdfread.obj cdfvalidator64.obj cdfalloc64.obj cdffsi.obj cdfmem.obj cdfread64.obj cdfwrite.obj cdfcks.obj cdffsi2.obj cdfmisc1.obj cdfrle.obj cdfwrite64.obj cdfclo.obj cdffsi3.obj cdfmisc1_64.obj cdfrle64.obj dirutils.obj cdfclo64.obj cdfget.obj cdfmisc2.obj cdfsav.obj epochu.obj cdfcon.obj cdfget64.obj cdfmisc2_64.obj cdfsel.obj epochuf.obj cdfcon64.obj cdfgzip.obj cdfmisc3.obj cdfsel64.obj libmain.obj cdfcre.obj cdfgzip64.obj cdfmisc3_64.obj cdfstr.obj vstream.obj cdfcre64.obj cdfhuff.obj cdfope.obj cdftext.obj vstream64.obj cdfcsi.obj cdfhuff64.obj cdfput1.obj cdftt2000.obj cdfdel.obj cdfhyper.obj cdfput1_64.obj cdftt2000f.obj cdfdel64.obj cdfhyper64.obj  cdfput2.obj cdfvalid.obj adler32.obj deflate.obj inffast.obj trees.obj inflate.obj crc32.obj infback.obj inftrees.obj zutil.obj

echo link /ignore:4217 /out:dllcdf.dll /MANIFEST /PDB:".\Release/dllcdf.pdb" /DYNAMICBASE:NO "kernel32.lib" "user32.lib" "gdi32.lib" "winspool.lib" "comdlg32.lib" "advapi32.lib" "shell32.lib" "ole32.lib" "oleaut32.lib" "uuid.lib" "odbc32.lib" "odbccp32.lib" /IMPLIB:"dllcdf.lib" /VERSION:"3.9" /DLL /MACHINE:X64 /INCREMENTAL:NO /MANIFESTUAC:"level='asInvoker' uiAccess='false'" /ERRORREPORT:PROMPT /NOLOGO /TLBID:1 cdfed.obj cdflib.obj cdfput2_64.obj cdfvalidator.obj cdfalloc.obj cdffii.obj cdfmd5.obj cdfread.obj cdfvalidator64.obj cdfalloc64.obj cdffsi.obj cdfmem.obj cdfread64.obj cdfwrite.obj cdfcks.obj cdffsi2.obj cdfmisc1.obj cdfrle.obj cdfwrite64.obj cdfclo.obj cdffsi3.obj cdfmisc1_64.obj cdfrle64.obj dirutils.obj cdfclo64.obj cdfget.obj cdfmisc2.obj cdfsav.obj epochu.obj cdfcon.obj cdfget64.obj cdfmisc2_64.obj cdfsel.obj epochuf.obj cdfcon64.obj cdfgzip.obj cdfmisc3.obj cdfsel64.obj libmain.obj cdfcre.obj cdfgzip64.obj cdfmisc3_64.obj cdfstr.obj vstream.obj cdfcre64.obj cdfhuff.obj cdfope.obj cdftext.obj vstream64.obj cdfcsi.obj cdfhuff64.obj cdfput1.obj cdftt2000.obj cdfdel.obj cdfhyper.obj cdfput1_64.obj cdftt2000f.obj cdfdel64.obj cdfhyper64.obj  cdfput2.obj cdfvalid.obj adler32.obj deflate.obj inffast.obj trees.obj inflate.obj crc32.obj infback.obj inftrees.obj zutil.obj
link /ignore:4217 /out:dllcdf.dll /MANIFEST /PDB:".\Release/dllcdf.pdb" /DYNAMICBASE:NO "kernel32.lib" "user32.lib" "gdi32.lib" "winspool.lib" "comdlg32.lib" "advapi32.lib" "shell32.lib" "ole32.lib" "oleaut32.lib" "uuid.lib" "odbc32.lib" "odbccp32.lib" /IMPLIB:"dllcdf.lib" /VERSION:"3.9" /DLL /MACHINE:X64 /INCREMENTAL:NO /MANIFESTUAC:"level='asInvoker' uiAccess='false'" /ERRORREPORT:PROMPT /NOLOGO /TLBID:1 cdfed.obj cdflib.obj cdfput2_64.obj cdfvalidator.obj cdfalloc.obj cdffii.obj cdfmd5.obj cdfread.obj cdfvalidator64.obj cdfalloc64.obj cdffsi.obj cdfmem.obj cdfread64.obj cdfwrite.obj cdfcks.obj cdffsi2.obj cdfmisc1.obj cdfrle.obj cdfwrite64.obj cdfclo.obj cdffsi3.obj cdfmisc1_64.obj cdfrle64.obj dirutils.obj cdfclo64.obj cdfget.obj cdfmisc2.obj cdfsav.obj epochu.obj cdfcon.obj cdfget64.obj cdfmisc2_64.obj cdfsel.obj epochuf.obj cdfcon64.obj cdfgzip.obj cdfmisc3.obj cdfsel64.obj libmain.obj cdfcre.obj cdfgzip64.obj cdfmisc3_64.obj cdfstr.obj vstream.obj cdfcre64.obj cdfhuff.obj cdfope.obj cdftext.obj vstream64.obj cdfcsi.obj cdfhuff64.obj cdfput1.obj cdftt2000.obj cdfdel.obj cdfhyper.obj cdfput1_64.obj cdftt2000f.obj cdfdel64.obj cdfhyper64.obj  cdfput2.obj cdfvalid.obj adler32.obj deflate.obj inffast.obj trees.obj inflate.obj crc32.obj infback.obj inftrees.obj zutil.obj

echo.
echo Building tools...
echo.
echo cl /O2 /c /utf-8 /I . /I %mysrc%\..\include /I %mycurses%\include /D"_FILE_OFFSET_BITS=64" /D"_LARGEFILE64_SOURCE" /D"_LARGEFILE_SOURCE" /D"WIN32" /D"ALONE" /D"PDCURSES" /D"PDC_WIDE" /D"PDC_DLL_BUILD" /D"_WINDOWS" /D"_WIN32" /D"PDC_FORCE_UTF8" /MT /EHsc %mytool%\toolbox1.c %mytool%\toolbox3.c %mytool%\toolbox4.cpp %mytool%\cdf2skt.c %mytool%\cdfcmp.c %mytool%\cdfcvt.c %mytool%\cdfdump.c %mytool%\cdfinq.c %mytool%\cdfirsdump.c %mytool%\cdfleapsecondsinfo.c %mytool%\cdfmerge.c %mytool%\cdfstat1.c %mytool%\cdfstat2.c %mytool%\cdfstats.c %mytool%\cdfvalidate.c %mytool%\skt2cdf.c %mytool%\widgets.c %mytool%\windoz.c %mytool%\cdfedit.c %mytool%\cdfedit1.c %mytool%\cdfedit2.c %mytool%\cdfedit3.c %mytool%\cdfxp.c %mytool%\cdfxp1.c %mytool%\cdfxp2.c %mytool%\cdfxp3.c
cl /O2 /c /utf-8 /I . /I %mysrc%\..\include /I %mycurses%\include /D"_FILE_OFFSET_BITS=64" /D"_LARGEFILE64_SOURCE" /D"_LARGEFILE_SOURCE" /D"WIN32" /D"ALONE" /D"PDCURSES" /D"PDC_WIDE" /D"PDC_DLL_BUILD" /D"_WINDOWS" /D"_WIN32" /D"PDC_FORCE_UTF8" /MT /EHsc %mytool%\toolbox1.c %mytool%\toolbox3.c %mytool%\toolbox4.cpp %mytool%\cdf2skt.c %mytool%\cdfcmp.c %mytool%\cdfcvt.c %mytool%\cdfdump.c %mytool%\cdfinq.c %mytool%\cdfirsdump.c %mytool%\cdfleapsecondsinfo.c %mytool%\cdfmerge.c %mytool%\cdfstat1.c %mytool%\cdfstat2.c %mytool%\cdfstats.c %mytool%\cdfvalidate.c %mytool%\skt2cdf.c %mytool%\widgets.c %mytool%\windoz.c %mytool%\cdfedit.c %mytool%\cdfedit1.c %mytool%\cdfedit2.c %mytool%\cdfedit3.c %mytool%\cdfxp.c %mytool%\cdfxp1.c %mytool%\cdfxp2.c %mytool%\cdfxp3.c

echo link /out:cdfcvt.exe cdfcvt.obj toolbox1.obj toolbox3.obj dllcdf.lib
link /out:cdfcvt.exe cdfcvt.obj toolbox1.obj toolbox3.obj dllcdf.lib

echo link /out:cdfcmp.exe cdfcmp.obj toolbox1.obj toolbox3.obj dllcdf.lib
link /out:cdfcmp.exe cdfcmp.obj toolbox1.obj toolbox3.obj dllcdf.lib

echo link /out:cdf2skt.exe cdf2skt.obj toolbox1.obj toolbox3.obj dllcdf.lib
link /out:cdf2skt.exe cdf2skt.obj toolbox1.obj toolbox3.obj dllcdf.lib

echo link /out:cdfdump.exe cdfdump.obj toolbox1.obj toolbox3.obj dllcdf.lib
link /out:cdfdump.exe cdfdump.obj toolbox1.obj toolbox3.obj dllcdf.lib

echo link /out:cdfirsdump.exe cdfirsdump.obj toolbox1.obj toolbox3.obj dllcdf.lib
link /out:cdfirsdump.exe cdfirsdump.obj toolbox1.obj toolbox3.obj dllcdf.lib

echo link /out:cdfvalidate.exe cdfvalidate.obj toolbox1.obj toolbox3.obj dllcdf.lib
link /out:cdfvalidate.exe cdfvalidate.obj toolbox1.obj toolbox3.obj dllcdf.lib

echo link /out:cdfinq.exe cdfinq.obj toolbox1.obj toolbox3.obj dllcdf.lib
link /out:cdfinq.exe cdfinq.obj toolbox1.obj toolbox3.obj dllcdf.lib

echo link /out:cdfleapsecondsinfo.exe cdfleapsecondsinfo.obj toolbox1.obj toolbox3.obj dllcdf.lib
link /out:cdfleapsecondsinfo.exe cdfleapsecondsinfo.obj toolbox1.obj toolbox3.obj dllcdf.lib

echo link /out:skt2cdf.exe skt2cdf.obj toolbox1.obj toolbox3.obj dllcdf.lib
link /out:skt2cdf.exe skt2cdf.obj toolbox1.obj toolbox3.obj dllcdf.lib

echo link /out:cdfstats.exe cdfstats.obj cdfstat1.obj cdfstat2.obj toolbox1.obj toolbox3.obj dllcdf.lib
link /out:cdfstats.exe cdfstats.obj cdfstat1.obj cdfstat2.obj toolbox1.obj toolbox3.obj dllcdf.lib

echo link /out:cdfmerge.exe cdfmerge.obj toolbox1.obj toolbox3.obj dllcdf.lib
link /out:cdfmerge.exe cdfmerge.obj toolbox1.obj toolbox3.obj dllcdf.lib

echo link /out:cdfedit.exe cdfedit.obj cdfedit1.obj cdfedit2.obj cdfedit3.obj toolbox1.obj toolbox3.obj windoz.obj widgets.obj %mycurses%\x64\lib\pdcurses.lib dllcdf.lib ws2_32.lib
link /out:cdfedit.exe cdfedit.obj cdfedit1.obj cdfedit2.obj cdfedit3.obj toolbox1.obj toolbox3.obj windoz.obj widgets.obj %mycurses%\x64\lib\pdcurses.lib dllcdf.lib ws2_32.lib

echo link /out:cdfexport.exe cdfxp.obj cdfxp1.obj cdfxp2.obj cdfxp3.obj toolbox1.obj toolbox3.obj windoz.obj widgets.obj %mycurses%\x64\lib\pdcurses.lib dllcdf.lib ws2_32.lib
link /out:cdfexport.exe cdfxp.obj cdfxp1.obj cdfxp2.obj cdfxp3.obj toolbox1.obj toolbox3.obj windoz.obj widgets.obj %mycurses%\x64\lib\pdcurses.lib dllcdf.lib ws2_32.lib

echo lib /out:cdftool_boxes.lib toolbox1.obj toolbox3.obj
lib /out:cdftool_boxes.lib toolbox1.obj toolbox3.obj

echo.
echo Building tests...
echo.
echo cl /O2 /c /utf-8 /I . /I %mytests% /I %mytests%\..\src\include /D"_FILE_OFFSET_BITS=64" /D"_LARGEFILE64_SOURCE" /D"_LARGEFILE_SOURCE" /D"WIN32" /D"ALONE" /MT /EHsc %mytests%\qst2c.c %mytests%\qst2cOrig.c %mytests%\qst2cutf8.c %mytests%\qst2ic.c %mytests%\qst2icEPOCH16.c %mytests%\qst2icTT2000.c %mytests%\qst2Version.c
cl /O2 /c /utf-8 /I . /I %mytests% /I %mytests%\..\src\include /D"_FILE_OFFSET_BITS=64" /D"_LARGEFILE64_SOURCE" /D"_LARGEFILE_SOURCE" /D"WIN32" /D"ALONE" /MT /EHsc %mytests%\qst2c.c %mytests%\qst2cOrig.c %mytests%\qst2cutf8.c %mytests%\qst2ic.c %mytests%\qst2icEPOCH16.c %mytests%\qst2icTT2000.c %mytests%\qst2Version.c

echo link /out:qst2c.exe qst2c.obj libcdf.lib
link /out:qst2c.exe qst2c.obj libcdf.lib

echo link /out:qst2cS.exe qst2c.obj dllcdf.lib
link /out:qst2cS.exe qst2c.obj dllcdf.lib

echo link /out:qst2cOrig.exe qst2cOrig.obj libcdf.lib
link /out:qst2cOrig.exe qst2cOrig.obj libcdf.lib

echo link /out:qst2cOrigS.exe qst2cOrig.obj dllcdf.lib
link /out:qst2cOrigS.exe qst2cOrig.obj dllcdf.lib

echo link /out:qst2cutf8.exe qst2cutf8.obj libcdf.lib
link /out:qst2cutf8.exe qst2cutf8.obj libcdf.lib

echo link /out:qst2cutf8S.exe qst2cutf8.obj dllcdf.lib
link /out:qst2cutf8S.exe qst2cutf8.obj dllcdf.lib

echo link /out:qst2ic.exe qst2ic.obj libcdf.lib
link /out:qst2ic.exe qst2ic.obj libcdf.lib

echo link /out:qst2icS.exe qst2ic.obj dllcdf.lib
link /out:qst2icS.exe qst2ic.obj dllcdf.lib

echo link /out:qst2icEPOCH16.exe qst2icEPOCH16.obj libcdf.lib
link /out:qst2icEPOCH16.exe qst2icEPOCH16.obj libcdf.lib

echo link /out:qst2icEPOCH16S.exe qst2icEPOCH16.obj dllcdf.lib
link /out:qst2icEPOCH16S.exe qst2icEPOCH16.obj dllcdf.lib

echo link /out:qst2icTT2000.exe qst2icTT2000.obj libcdf.lib
link /out:qst2icTT2000.exe qst2icTT2000.obj libcdf.lib

echo link /out:qst2icTT2000S.exe qst2icTT2000.obj dllcdf.lib
link /out:qst2icTT2000S.exe qst2icTT2000.obj dllcdf.lib

echo link /out:qst2Version.exe qst2Version.obj libcdf.lib
link /out:qst2Version.exe qst2Version.obj libcdf.lib

echo link /out:qst2VersionS.exe qst2Version.obj dllcdf.lib
link /out:qst2VersionS.exe qst2Version.obj dllcdf.lib

del qst*lib qst*.exp

set argC=0
set buildjni=0
set withjdk=0
set buildcsharp=0
for %%x in (%*) do Set /A argC+=1

set myjdkt=
for %%y in (%*) do (
  if %%y==jni (
    set buildjni=1
  ) else (
    if %%y==csharp (
      set buildcsharp=1
    ) else (
      if %%y==jdk (
        set withjdk=1
      ) else (
        set myjdkt=%%y
      )
    )
  )
)

if %withjdk% EQU 1 (
  set firstChar=%myjdkt:~0,1%
  set lastChar=%myjdkt:~-1%
  :: Replace " with +
  set firstChar=%firstChar:"=+%
  set lastChar=%lastChar:"=+%
  if "%firstChar%"=="+" (
    if "%lastChar%"=="+" (
      set myjdk=%myjdkt:"=%
    ) else (
      set myjdk=%myjdkt%
    )
  ) else (
    set myjdk=%myjdkt%
  )
) else (
  set myjdk=%java_jdk%
)

if %buildjni% EQU 1 (
 if "%myjdk%" == "" (
   echo.
   echo jdk is not defined... JNI is not built.
   echo.
 ) else (
   echo.
   echo Building JNI...
   echo.
   set myjni=%mydir%..\cdfjava\jni
:: echo "====== myjni=%myjni%"
   echo cl /O2 /c /utf-8 /I %myjni% /I %mysrc%\..\include /I "%myjdk%\include" /I "%myjdk%\include\win32" /D"_FILE_OFFSET_BITS=64" /D"_LARGEFILE64_SOURCE" /D"_LARGEFILE_SOURCE" /D"WIN32" /D "double_underscore" /D "_USRDLL" /D"DLLCDF_EXPORTS" /D "BUILDINGforDLL" /D"_LIB" /D"Z_PREFIX" /D"MALLOC_CHECK=0" /MT /EHsc %myjni%\cdfNativeLibrary.c
   cl /O2 /c /utf-8 /I %myjni% /I %mysrc%\..\include /I "%myjdk%\include" /I "%myjdk%\include\win32" /D"_FILE_OFFSET_BITS=64" /D"_LARGEFILE64_SOURCE" /D"_LARGEFILE_SOURCE" /D"WIN32" /D "double_underscore" /D "_USRDLL" /D"DLLCDF_EXPORTS" /D "BUILDINGforDLL" /D"_LIB" /D"Z_PREFIX" /D"MALLOC_CHECK=0" /MT /EHsc %myjni%\cdfNativeLibrary.c

   echo link /ignore:4217 /out:cdfNativeLibrary.dll /MANIFEST /PDB:".\Release/cdfNativeLibrary.pdb" /DYNAMICBASE:NO "kernel32.lib" "user32.lib" "gdi32.lib" "winspool.lib" "comdlg32.lib" "advapi32.lib" "shell32.lib" "ole32.lib" "oleaut32.lib" "uuid.lib" "odbc32.lib" "odbccp32.lib" /IMPLIB:"cdfNativeLibrary.lib" /VERSION:"3.9" /DLL /MACHINE:X64 /INCREMENTAL:NO /MANIFESTUAC:"level='asInvoker' uiAccess='false'" /ERRORREPORT:PROMPT /NOLOGO /TLBID:1 cdfed.obj cdflib.obj cdfput2_64.obj cdfvalidator.obj cdfalloc.obj cdffii.obj cdfmd5.obj cdfread.obj cdfvalidator64.obj cdfalloc64.obj cdffsi.obj cdfmem.obj cdfread64.obj cdfwrite.obj cdfcks.obj cdffsi2.obj cdfmisc1.obj cdfrle.obj cdfwrite64.obj cdfclo.obj cdffsi3.obj cdfmisc1_64.obj cdfrle64.obj dirutils.obj cdfclo64.obj cdfget.obj cdfmisc2.obj cdfsav.obj epochu.obj cdfcon.obj cdfget64.obj cdfmisc2_64.obj cdfsel.obj epochuf.obj cdfcon64.obj cdfgzip.obj cdfmisc3.obj cdfsel64.obj libmain.obj cdfcre.obj cdfgzip64.obj cdfmisc3_64.obj cdfstr.obj vstream.obj cdfcre64.obj cdfhuff.obj cdfope.obj cdftext.obj vstream64.obj cdfcsi.obj cdfhuff64.obj cdfput1.obj cdftt2000.obj cdfdel.obj cdfhyper.obj cdfput1_64.obj cdftt2000f.obj cdfdel64.obj cdfhyper64.obj  cdfput2.obj cdfvalid.obj adler32.obj deflate.obj inffast.obj trees.obj inflate.obj crc32.obj infback.obj inftrees.obj zutil.obj cdfNativeLibrary.obj
   link /ignore:4217 /out:cdfNativeLibrary.dll /MANIFEST /PDB:".\Release/cdfNativeLibrary.pdb" /DYNAMICBASE:NO "kernel32.lib" "user32.lib" "gdi32.lib" "winspool.lib" "comdlg32.lib" "advapi32.lib" "shell32.lib" "ole32.lib" "oleaut32.lib" "uuid.lib" "odbc32.lib" "odbccp32.lib" /IMPLIB:"cdfNativeLibrary.lib" /VERSION:"3.9" /DLL /MACHINE:X64 /INCREMENTAL:NO /MANIFESTUAC:"level='asInvoker' uiAccess='false'" /ERRORREPORT:PROMPT /NOLOGO /TLBID:1  cdfed.obj cdflib.obj cdfput2_64.obj cdfvalidator.obj cdfalloc.obj cdffii.obj cdfmd5.obj cdfread.obj cdfvalidator64.obj cdfalloc64.obj cdffsi.obj cdfmem.obj cdfread64.obj cdfwrite.obj cdfcks.obj cdffsi2.obj cdfmisc1.obj cdfrle.obj cdfwrite64.obj cdfclo.obj cdffsi3.obj cdfmisc1_64.obj cdfrle64.obj dirutils.obj cdfclo64.obj cdfget.obj cdfmisc2.obj cdfsav.obj epochu.obj cdfcon.obj cdfget64.obj cdfmisc2_64.obj cdfsel.obj epochuf.obj cdfcon64.obj cdfgzip.obj cdfmisc3.obj cdfsel64.obj libmain.obj cdfcre.obj cdfgzip64.obj cdfmisc3_64.obj cdfstr.obj vstream.obj cdfcre64.obj cdfhuff.obj cdfope.obj cdftext.obj vstream64.obj cdfcsi.obj cdfhuff64.obj cdfput1.obj cdftt2000.obj cdfdel.obj cdfhyper.obj cdfput1_64.obj cdftt2000f.obj cdfdel64.obj cdfhyper64.obj  cdfput2.obj cdfvalid.obj adler32.obj deflate.obj inffast.obj trees.obj inflate.obj crc32.obj infback.obj inftrees.obj zutil.obj cdfNativeLibrary.obj
 )
)

if %buildcsharp% EQU 1 (
  echo.
  echo Building csharp...
  echo.
  set mycsharp=%mydir%..\win32\csharp
  echo cl /O2 /c /utf-8 /I %mycsharp% /D"_FILE_OFFSET_BITS=64" /D"_LARGEFILE64_SOURCE" /D"_LARGEFILE_SOURCE" /D"WIN32" /D "double_underscore" /D "_USRDLL" /D"DLLCDF_EXPORTS" /D "BUILDINGforDLL" /D"_LIB" /D"Z_PREFIX" /D"MALLOC_CHECK=0" /MT /EHsc %mycsharp%\cdfstdi.c
  cl /O2 /c /utf-8 /I %mycsharp% /D"_FILE_OFFSET_BITS=64" /D"_LARGEFILE64_SOURCE" /D"_LARGEFILE_SOURCE" /D"WIN32" /D "double_underscore" /D "_USRDLL" /D"DLLCDF_EXPORTS" /D "BUILDINGforDLL" /D"_LIB" /D"Z_PREFIX" /D"MALLOC_CHECK=0" /MT /EHsc %mycsharp%\cdfstdi.c

  echo link /ignore:4217 /out:dllcdfcsharp.dll /MANIFEST /PDB:".\Release/dllcdfcsharp.pdb" /DYNAMICBASE:NO "kernel32.lib" "user32.lib" "gdi32.lib" "winspool.lib" "comdlg32.lib" "advapi32.lib" "shell32.lib" "ole32.lib" "oleaut32.lib" "uuid.lib" "odbc32.lib" "odbccp32.lib" /IMPLIB:"dllcdfcsharp.lib" /VERSION:"3.9" /DLL /MACHINE:X64 /INCREMENTAL:NO /MANIFESTUAC:"level='asInvoker' uiAccess='false'" /ERRORREPORT:PROMPT /NOLOGO /TLBID:1 cdfed.obj cdflib.obj cdfput2_64.obj cdfvalidator.obj cdfalloc.obj cdffii.obj cdfmd5.obj cdfread.obj cdfvalidator64.obj cdfalloc64.obj cdffsi.obj cdfmem.obj cdfread64.obj cdfwrite.obj cdfcks.obj cdffsi2.obj cdfmisc1.obj cdfrle.obj cdfwrite64.obj cdfclo.obj cdffsi3.obj cdfmisc1_64.obj cdfrle64.obj dirutils.obj cdfclo64.obj cdfget.obj cdfmisc2.obj cdfsav.obj epochu.obj cdfcon.obj cdfget64.obj cdfmisc2_64.obj cdfsel.obj epochuf.obj cdfcon64.obj cdfgzip.obj cdfmisc3.obj cdfsel64.obj libmain.obj cdfcre.obj cdfgzip64.obj cdfmisc3_64.obj cdfstr.obj vstream.obj cdfcre64.obj cdfhuff.obj cdfope.obj cdftext.obj vstream64.obj cdfcsi.obj cdfhuff64.obj cdfput1.obj cdftt2000.obj cdfdel.obj cdfhyper.obj cdfput1_64.obj cdftt2000f.obj cdfdel64.obj cdfhyper64.obj  cdfput2.obj cdfvalid.obj adler32.obj deflate.obj inffast.obj trees.obj inflate.obj crc32.obj infback.obj inftrees.obj zutil.obj cdfstdi.obj
  link /ignore:4217 /out:dllcdfcsharp.dll /MANIFEST /PDB:".\Release/dllcdfcsharp.pdb" /DYNAMICBASE:NO "kernel32.lib" "user32.lib" "gdi32.lib" "winspool.lib" "comdlg32.lib" "advapi32.lib" "shell32.lib" "ole32.lib" "oleaut32.lib" "uuid.lib" "odbc32.lib" "odbccp32.lib" /IMPLIB:"dllcdfcsharp.lib" /VERSION:"3.9" /DLL /MACHINE:X64 /INCREMENTAL:NO /MANIFESTUAC:"level='asInvoker' uiAccess='false'" /ERRORREPORT:PROMPT /NOLOGO /TLBID:1 cdfed.obj cdflib.obj cdfput2_64.obj cdfvalidator.obj cdfalloc.obj cdffii.obj cdfmd5.obj cdfread.obj cdfvalidator64.obj cdfalloc64.obj cdffsi.obj cdfmem.obj cdfread64.obj cdfwrite.obj cdfcks.obj cdffsi2.obj cdfmisc1.obj cdfrle.obj cdfwrite64.obj cdfclo.obj cdffsi3.obj cdfmisc1_64.obj cdfrle64.obj dirutils.obj cdfclo64.obj cdfget.obj cdfmisc2.obj cdfsav.obj epochu.obj cdfcon.obj cdfget64.obj cdfmisc2_64.obj cdfsel.obj epochuf.obj cdfcon64.obj cdfgzip.obj cdfmisc3.obj cdfsel64.obj libmain.obj cdfcre.obj cdfgzip64.obj cdfmisc3_64.obj cdfstr.obj vstream.obj cdfcre64.obj cdfhuff.obj cdfope.obj cdftext.obj vstream64.obj cdfcsi.obj cdfhuff64.obj cdfput1.obj cdftt2000.obj cdfdel.obj cdfhyper.obj cdfput1_64.obj cdftt2000f.obj cdfdel64.obj cdfhyper64.obj  cdfput2.obj cdfvalid.obj adler32.obj deflate.obj inffast.obj trees.obj inflate.obj crc32.obj infback.obj inftrees.obj zutil.obj cdfstdi.obj
)
echo.
