'*****************************************************************************e
'
'  NSSDC/CDF                      Quick Start Test Program(C# interface).
'
'  Version 1.0,15-Oct-09,Mike Liu
'
'  Modification history:
'
'   V1.0   15-Oct-09,M Liu     Original version(for CDF V3.3).
'                              Using pointers (&) to pass arguments for 
'                              retrieving data fields and values to C# APIs.
'
'*****************************************************************************/

imports System
imports System.Runtime.InteropServices
imports System.Collections.Generic
imports System.Linq
imports System.Runtime.Serialization.Json
imports System.IO
imports System.Text

imports CDF

public class QstReadVariablesvb
	     inherits  CDFAPIs

 public Shared Sub Main()
  Dim id As Long = 0
  Dim status As Integer
  Dim args() As String = Environment.GetCommandLineArgs()
  Dim cdf As Dictionary(Of string, object)
 try 
  Console.WriteLine("cdf:" + args(1))
  status = CDFopen(args(1),id)
  cdf = ReadCDFVariables(id)
  CDFUtils.PrintDictionary (cdf)
  status = CDFcloseCDF(id)  


 '*****************************************************************************
 ' Successful completion.
 '****************************************************************************/
 catch ex As CDFException
  Console.WriteLine("Error... "+ex.ToString())
 finally
  try
    status = CDFselect(id)
    status = CDFcloseCDF(id)
  catch ey As CDFException
  end try
 end try

End Sub


'******************************************************************************
' QuitCDF.
'*****************************************************************************/

 Private Shared Sub QuitCDF(where As string, status As integer, id As long)

  Dim text As string
  Console.WriteLine("Aborting at " + where)
  if status < 0 Then
    status = CDFgetStatusText(status, text)
    Console.WriteLine(" " + text)
  End If
  status = CDFcloseCDF(id)
  Console.WriteLine("...test aborted.")
 End Sub

End Class

