/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;

public class Json2CDF
implements CDFConstants {
    private static boolean progress = false;
    private static boolean delete = false;
    private static boolean showfile = false;
    private static boolean toCompress = true;
    private static boolean checksum = false;
    private static String inFile = null;
    private static String assignedFile = null;
    private static String outDir = null;
    private static int numFiles = 0;
    private static long dataType;
    private static long numElements;
    private static boolean varData;
    private static long varDataType;
    private static long varNumElems;
    private static long varNumDims;
    private static long varRecItems;
    private static long varSparseRec;
    private static long varNumWritten;
    private static long varMaxWritten;
    private static long[] varDimSizes;
    private static long[] varDimVariances;
    private static String varName;
    private static Object varPadValue;
    private static Object varFillVal;
    private static long varRecVary;
    private static String separator;
    private static String item1;
    private static String item2;
    private static String item3;
    private static String item4;
    private static String item5;
    private static String item6;
    private static String item7;
    private static String vAttrName;
    private static long dataTypeY;
    private static long compression;
    private static long compLvl;
    private static CDF cdf;
    private static Variable var;
    private static int index;

    public static void main(String[] stringArray) throws IOException {
        try {
            Json2CDF.parseCmdLine(stringArray);
            if (showfile) {
                System.out.println(inFile);
            }
            FileInputStream fileInputStream = new FileInputStream(inFile);
            JsonReader jsonReader = Json.createReader((InputStream)fileInputStream);
            JsonObject jsonObject = jsonReader.readObject();
            jsonReader.close();
            ((InputStream)fileInputStream).close();
            numFiles = jsonObject.keySet().size();
            for (String string : jsonObject.keySet()) {
                Json2CDF.outPutJsonObject(string, jsonObject.getJsonObject(string));
            }
        }
        catch (Exception exception) {
            System.out.println("Exception... " + exception);
        }
    }

    private static void outPutJsonObject(String object, JsonObject jsonObject) {
        long l = -1L;
        long l2 = -1L;
        long l3 = -1L;
        long l4 = 0L;
        cdf = null;
        Object object2 = null;
        try {
            JsonArray jsonArray;
            JsonArray jsonArray2;
            Object object3;
            JsonArray jsonArray3;
            if (progress) {
                System.out.println("Doing CDFFileInfo...");
            }
            if ((jsonArray3 = jsonObject.getJsonArray(item1)) != null) {
                int n;
                if (progress) {
                    System.out.println(item1 + ":");
                }
                for (Object object4 : jsonArray3) {
                    for (Object object5 : ((JsonObject)object4).keySet()) {
                        Object object6 = ((JsonObject)object4).getString((String)object5);
                        if (progress) {
                            System.out.println("  " + (String)object5 + ":" + (String)object6);
                        }
                        if (((String)object5).equalsIgnoreCase("filename")) {
                            object = object6;
                            continue;
                        }
                        if (((String)object5).equalsIgnoreCase("format")) {
                            l = CDFUtils.getLongFormat((String)object6);
                            continue;
                        }
                        if (((String)object5).equalsIgnoreCase("majority")) {
                            l2 = CDFUtils.getLongMajority((String)object6);
                            continue;
                        }
                        if (((String)object5).equalsIgnoreCase("encoding")) {
                            l3 = CDFUtils.getLongEncoding((String)object6);
                            continue;
                        }
                        if (!((String)object5).equalsIgnoreCase("checksum")) continue;
                        l4 = CDFUtils.getLongChecksum((String)object6);
                    }
                }
                object3 = null;
                if (delete) {
                    int n2;
                    Object object4;
                    object3 = outDir == null ? (numFiles == 1 && assignedFile != null ? assignedFile : object) : (numFiles == 1 && assignedFile != null ? outDir + separator + assignedFile : ((n2 = ((String)object).lastIndexOf(separator)) != -1 ? outDir + separator + ((String)object).substring(n2 + 1) : outDir + separator + (String)object));
                    object4 = new File((String)object3);
                    if (((File)object4).exists()) {
                        ((File)object4).delete();
                    }
                }
                object2 = outDir == null ? (numFiles == 1 && assignedFile != null ? assignedFile : object) : (numFiles == 1 && assignedFile != null ? outDir + separator + assignedFile : ((n = ((String)object).lastIndexOf(separator)) != -1 ? outDir + separator + ((String)object).substring(n + 1) : outDir + separator + (String)object));
                cdf = CDF.create((String)object2);
                cdf.setFormat(l);
                cdf.setMajority(l2);
                cdf.setEncoding(l3);
                if (checksum || l4 == 1L) {
                    cdf.setChecksum(1L);
                }
            }
            if (progress) {
                System.out.println("Doing CDFglobalAttributes...");
            }
            if ((object3 = jsonObject.getJsonArray(item2)) != null) {
                if (progress) {
                    System.out.println(item2 + ":");
                }
                Json2CDF.processGlobalAttributes((JsonArray)object3);
            }
            if (progress) {
                System.out.println("Doing CDFVariables...");
            }
            if ((jsonArray2 = jsonObject.getJsonArray(item3)) != null) {
                if (progress) {
                    System.out.println(item3 + ":");
                }
                for (Object object5 : jsonArray2) {
                    for (Object object7 : ((JsonObject)object5).keySet()) {
                        if (progress) {
                            System.out.println("  " + (String)object7 + ":");
                        }
                        Object object8 = ((JsonObject)object5).getJsonArray((String)object7);
                        for (int i = 0; i < object8.size(); ++i) {
                            JsonObject jsonObject2 = object8.getJsonObject(i);
                            for (String string : jsonObject2.keySet()) {
                                Object object9;
                                if (string.equalsIgnoreCase(item4)) {
                                    object9 = jsonObject2.get((Object)string);
                                    if (progress) {
                                        System.out.println("    " + string + ":");
                                    }
                                    var = Json2CDF.processVariableSpec((String)object7, object9);
                                    index = 0;
                                    continue;
                                }
                                if (string.equalsIgnoreCase(item5)) {
                                    if (var == null) continue;
                                    object9 = jsonObject2.get((Object)string);
                                    if (progress) {
                                        System.out.println("    " + string + ":");
                                    }
                                    Json2CDF.processVariableAttributes(object9);
                                    continue;
                                }
                                if (string.equalsIgnoreCase(item6)) {
                                    if (!varData && varRecVary != 0L || var == null) continue;
                                    if (progress) {
                                        System.out.println("    Doing VarData....");
                                    }
                                    if ((object9 = jsonObject2.get((Object)string)) == null) continue;
                                    Json2CDF.processVariableData(object9);
                                    continue;
                                }
                                System.out.println("***** Unknown item...: " + string);
                            }
                        }
                    }
                }
            }
            if (progress) {
                System.out.println("Doing EmptyAttributes...");
            }
            if ((jsonArray = jsonObject.getJsonArray(item7)) != null) {
                if (progress) {
                    System.out.println(item7 + ":");
                }
                for (Object object6 : jsonArray) {
                    for (Object object8 : ((JsonObject)object6).keySet()) {
                        Object object10;
                        int n;
                        JsonArray jsonArray4 = ((JsonObject)object6).getJsonArray((String)object8);
                        if (progress) {
                            System.out.println("  " + (String)object8 + ":" + jsonArray4);
                        }
                        if (((String)object8).equals("GlobalAttributes")) {
                            for (n = 0; n < jsonArray4.size(); ++n) {
                                object10 = jsonArray4.getString(n);
                                Attribute.create((CDF)cdf, (String)object10, (long)1L);
                            }
                            continue;
                        }
                        for (n = 0; n < jsonArray4.size(); ++n) {
                            object10 = jsonArray4.getString(n);
                            Attribute.create((CDF)cdf, (String)object10, (long)2L);
                        }
                    }
                }
            }
            cdf.close();
        }
        catch (Exception exception) {
            System.err.println("***** Error: " + exception + " for file: " + object2);
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            if (stackTraceElementArray.length > 0) {
                int n = stackTraceElementArray[0].getLineNumber();
                System.out.println("Exception occurred at line number: " + n);
            }
            System.out.println("Could not determine the line number of the exception.");
        }
    }

    private static void parseCmdLine(String[] stringArray) {
        Object var1_1 = null;
        if (stringArray.length == 0) {
            Json2CDF.usage();
            Json2CDF.exit("");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == stringArray.length - 1) {
                    inFile = stringArray[i];
                    continue;
                }
                int n = stringArray[i].indexOf(":");
                if (stringArray[i].toLowerCase().startsWith("-output:")) {
                    assignedFile = stringArray[i].substring(n + 1);
                    if (assignedFile.toLowerCase().endsWith(".cdf")) continue;
                    assignedFile = assignedFile + ".cdf";
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("-vardata:")) {
                    String string = stringArray[i].substring(n + 1);
                    if (string.equalsIgnoreCase("yes")) {
                        varData = true;
                        continue;
                    }
                    if (string.equalsIgnoreCase("no")) {
                        varData = false;
                        continue;
                    }
                    Json2CDF.exit("** Error: Invalid option \"-vardata:" + string + "\" entered.\n");
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-showprogress") || stringArray[i].equalsIgnoreCase("-progress")) {
                    progress = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-delete")) {
                    delete = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-showfile")) {
                    showfile = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-checksum")) {
                    checksum = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-nocompress")) {
                    toCompress = false;
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("-outdir:")) {
                    outDir = stringArray[i].substring(n + 1);
                    continue;
                }
                System.out.println("** Error: Invalid/missing option entered for \"" + stringArray[i] + "\"\n   Use \"java CDF2Json\" to read the help information.");
                System.exit(1);
            }
        }
    }

    private static boolean equivalentDataTypes(long l, long l2) {
        long[] lArray = new long[]{0L, 1L, 2L, 0L, 3L, 0L, 0L, 0L, 4L, 0L, 0L, 5L, 6L, 0L, 7L, 0L, 0L, 0L, 0L, 0L, 0L, 8L, 9L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 9L, 0L, 4L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 0L, 0L, 8L, 9L, 0L, 0L, 0L, 0L, 0L, 10L, 10L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        return lArray[(int)l] == lArray[(int)l2];
    }

    private static Object handleSpecial(long l, String string) {
        if (string.equals("-nan")) {
            if (l == 45L || l == 22L) {
                return Double.NaN;
            }
            if (l == 44L || l == 21L) {
                return Float.valueOf(Float.NaN);
            }
            return Double.NaN;
        }
        if (string.equals("nan")) {
            if (l == 45L || l == 22L) {
                return Double.NaN;
            }
            if (l == 44L || l == 21L) {
                return Float.valueOf(Float.NaN);
            }
            return Double.NaN;
        }
        if (string.equals("-inf")) {
            if (l == 45L || l == 22L) {
                return Double.NEGATIVE_INFINITY;
            }
            if (l == 44L || l == 21L) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (string.equals("inf")) {
            if (l == 45L || l == 22L) {
                return Double.POSITIVE_INFINITY;
            }
            if (l == 44L || l == 21L) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            return Double.POSITIVE_INFINITY;
        }
        if (l == 8L) {
            return Long.valueOf(string);
        }
        if (l == 45L) {
            return Double.valueOf(string);
        }
        return string;
    }

    private static Object changeData(long l, long l2, Object object) {
        String string = CDFUtils.getSignature((Object)object);
        if (string.indexOf("String") != -1) {
            if (string.charAt(0) != '[') {
                String string2 = (String)object;
                String string3 = Json2CDF.specialString(string2);
                if (string3 != null) {
                    return Json2CDF.handleSpecial(l2, string3);
                }
                return object;
            }
            int n = ((String[])object).length;
            String string4 = null;
            String string5 = null;
            if (l2 == 21L || l2 == 44L) {
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    string4 = ((String[])object)[i];
                    string5 = Json2CDF.specialString(string4);
                    fArray[i] = string5 != null ? ((Float)Json2CDF.handleSpecial(l2, string5)).floatValue() : Float.valueOf(string4).floatValue();
                }
                return fArray;
            }
            if (l2 == 22L || l2 == 45L) {
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    string4 = ((String[])object)[i];
                    string5 = Json2CDF.specialString(string4);
                    dArray[i] = string5 != null ? ((Double)Json2CDF.handleSpecial(l2, string5)).doubleValue() : Double.valueOf(string4).doubleValue();
                }
                return dArray;
            }
            return object;
        }
        if (Json2CDF.equivalentDataTypes(l, l2)) {
            return object;
        }
        if (object instanceof Double) {
            return Float.valueOf((float)((Double)object).doubleValue());
        }
        if (object instanceof Integer) {
            if (l == 1L || l == 41L) {
                return ((Integer)object).byteValue();
            }
            if (l == 2L || l == 11L) {
                return ((Integer)object).shortValue();
            }
        } else if (string.charAt(0) == '[') {
            if (string.charAt(1) == 'D') {
                int n = ((double[])object).length;
                float[] fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    fArray[i] = (float)((double[])object)[i];
                }
                return fArray;
            }
            if (l == 1L || l == 41L) {
                int n = ((int[])object).length;
                byte[] byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (byte)((int[])object)[i];
                }
                return byArray;
            }
            if (l == 2L || l == 11L) {
                int n = ((int[])object).length;
                short[] sArray = new short[n];
                for (int i = 0; i < n; ++i) {
                    sArray[i] = (short)((int[])object)[i];
                }
                return sArray;
            }
            return object;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object getData(Object object, long l) {
        String string = null;
        if (object instanceof JsonString) {
            string = ((JsonString)object).toString();
            int n = string.length();
            if (n == 0) {
                return new String(new byte[]{0});
            }
            if (string.charAt(0) == '\"' && (n = (string = string.substring(1, string.length() - 1)).length()) == 0) {
                return new String(new byte[]{0});
            }
            if (l != 0L) {
                dataType = l;
                Object object2 = Json2CDF.parseContents(string, dataType);
                if (object2 == null) return string;
                return object2;
            }
            try {
                if (n < 14 || string.charAt(4) != '-' || string.charAt(7) != '-' || string.charAt(10) != 'T' || string.charAt(13) != ':') {
                    dataType = 51L;
                    Object object3 = Json2CDF.parseContents(string, dataType);
                    if (object3 == null) return string;
                    return object3;
                }
                numElements = 1L;
                if (string.length() == 23 || string.length() == 24) {
                    dataType = 31L;
                    return Epoch.toParse((String)string);
                }
                if (string.length() == 29 || string.length() == 30) {
                    dataType = 33L;
                    return CDFTT2000.toParse((String)string);
                }
                if (string.length() != 32 && string.length() != 36) {
                    dataType = 51L;
                    return string;
                }
                dataType = 32L;
                return Epoch16.toParse((String)string);
            }
            catch (Exception exception) {
                numElements = n;
                dataType = 51L;
                return string;
            }
        }
        if (object instanceof JsonNumber) {
            numElements = 1L;
            try {
                Object object4;
                string = ((JsonNumber)object).toString();
                if (l == 0L) {
                    if (((JsonNumber)object).isIntegral()) {
                        if (!Json2CDF.useVarDataType(vAttrName)) {
                            dataType = 4L;
                        }
                        try {
                            Object object5 = Json2CDF.parseContents(string, dataType);
                            if (object5 == null) return string;
                            return object5;
                        }
                        catch (Exception exception) {
                            try {
                                dataType = 8L;
                                Object object6 = Json2CDF.parseContents(string, dataType);
                                if (object6 == null) return string;
                                return object6;
                            }
                            catch (Exception exception2) {
                                System.out.println("1 Error.... Json number... value:" + string + " dt:" + dataType + " " + exception2);
                                return null;
                            }
                        }
                    }
                    if (!Json2CDF.useVarDataType(vAttrName)) {
                        dataType = 45L;
                    }
                } else {
                    dataType = l;
                }
                if ((object4 = Json2CDF.parseContents(string, dataType)) == null) return string;
                return object4;
            }
            catch (Exception exception) {
                System.out.println("2 Error.... Json number... value:" + string + " dt:" + dataType + " " + exception);
                return null;
            }
        }
        if (!(object instanceof JsonArray)) {
            return null;
        }
        Object object7 = ((JsonArray)object).get(0);
        if (object7 instanceof JsonNumber) {
            numElements = ((JsonArray)object).size();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while ((long)n < numElements) {
                stringBuffer.append(((JsonNumber)((JsonArray)object).get(n)).toString());
                if ((long)n < numElements - 1L) {
                    stringBuffer.append(",");
                }
                ++n;
            }
            string = stringBuffer.toString();
            if (l == 0L) {
                if (((JsonNumber)object7).isIntegral()) {
                    if (!Json2CDF.useVarDataType(vAttrName)) {
                        dataType = 4L;
                    }
                    try {
                        Object object8 = Json2CDF.parseContents(string, dataType);
                        if (object8 == null) return string;
                        return object8;
                    }
                    catch (Exception exception) {
                        try {
                            dataType = 8L;
                            Object object9 = Json2CDF.parseContents(string, dataType);
                            if (object9 == null) return string;
                            return object9;
                        }
                        catch (Exception exception3) {
                            System.out.println("3 Error.... Json array integer... value:" + string + " dt:" + dataType + " " + exception3);
                            return null;
                        }
                    }
                }
                if (!Json2CDF.useVarDataType(vAttrName)) {
                    dataType = 45L;
                }
            } else {
                dataType = l;
            }
            try {
                Object object10 = Json2CDF.parseContents(string, dataType);
                if (object10 == null) return string;
                return object10;
            }
            catch (Exception exception) {
                System.out.println("4 Error.... Json array number... value:" + string + " dt:" + dataType + " " + exception);
                return null;
            }
        }
        if (!(object7 instanceof JsonString)) {
            return null;
        }
        if (l == 51L || l == 52L || l == 0L) {
            Object object11 = Json2CDF.parseContents(((JsonString)object7).toString(), 51L);
            if (object11 instanceof String) {
                int n = ((JsonArray)object).size();
                String[] stringArray = new String[n];
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return stringArray;
                    }
                    stringArray[n2] = (String)Json2CDF.getData((JsonString)((JsonArray)object).get(n2), 51L);
                    ++n2;
                }
            }
            Object object12 = Json2CDF.parseContents(string, dataType);
            if (object12 == null) return string;
            return object12;
        }
        int n = ((JsonArray)object).size();
        if (l == 8L || l == 33L) {
            long[] lArray = new long[n];
            int n3 = 0;
            while (true) {
                if (n3 >= n) {
                    return lArray;
                }
                String string2 = ((JsonString)((JsonArray)object).get(n3)).getString();
                String string3 = (String)Json2CDF.parseContents(string2, 51L);
                lArray[n3] = Long.valueOf(string3);
                ++n3;
            }
        }
        if (l != 45L && l != 22L) {
            return null;
        }
        double[] dArray = new double[n];
        int n4 = 0;
        while (n4 < n) {
            String string4 = ((JsonString)((JsonArray)object).get(n4)).getString();
            String string5 = (String)Json2CDF.parseContents(string4, 51L);
            dArray[n4] = Double.valueOf(string5);
            ++n4;
        }
        return dArray;
    }

    private static String specialString(String string) {
        String string2 = string.toLowerCase();
        if (string2.startsWith("\"")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2.equals("nan") || string2.equals("-nan") || string2.equals("inf") || string2.equals("-inf")) {
            return string2;
        }
        return null;
    }

    private static Object setData(Object object, Object object2) throws CDFException {
        Object object3 = object;
        boolean bl = true;
        int n = ((JsonArray)object3).size();
        for (int i = 0; i < n; ++i) {
            Object object4 = ((JsonArray)object3).get(i);
            String string = CDFUtils.getSignature((Object)object4);
            Object object5 = null;
            if (object4 instanceof JsonString) {
                String string2 = ((JsonString)object4).getString();
                String string3 = Json2CDF.specialString(string2);
                object5 = string3 != null ? Json2CDF.handleSpecial(varDataType, string3) : Json2CDF.setData1(object4);
                switch ((int)varDataType) {
                    case 31: {
                        ((double[])object2)[Json2CDF.index++] = (Double)object5;
                        break;
                    }
                    case 8: 
                    case 33: {
                        ((long[])object2)[Json2CDF.index++] = (Long)object5;
                        break;
                    }
                    case 32: {
                        ((double[])object2)[Json2CDF.index++] = ((double[])object5)[0];
                        ((double[])object2)[Json2CDF.index++] = ((double[])object5)[1];
                        break;
                    }
                    case 51: 
                    case 52: {
                        int n2;
                        byte[] byArray = ((String)object5).getBytes();
                        int n3 = ((String)object5).length();
                        for (n2 = 0; n2 < n3; ++n2) {
                            ((byte[])object2)[Json2CDF.index + n2] = byArray[n2];
                        }
                        n2 = n3;
                        while ((long)n2 < varNumElems) {
                            ((byte[])object2)[Json2CDF.index + n2] = 0;
                            ++n2;
                        }
                        index = (int)((long)index + varNumElems);
                        break;
                    }
                }
                continue;
            }
            if (object4 instanceof JsonNumber) {
                object5 = Json2CDF.setData1(object4);
                switch ((int)varDataType) {
                    case 1: 
                    case 41: {
                        ((byte[])object2)[Json2CDF.index++] = (Byte)object5;
                        break;
                    }
                    case 2: 
                    case 11: {
                        ((short[])object2)[Json2CDF.index++] = (short)((JsonNumber)object4).intValue();
                        break;
                    }
                    case 4: 
                    case 12: {
                        ((int[])object2)[Json2CDF.index++] = ((JsonNumber)object4).intValue();
                        break;
                    }
                    case 8: 
                    case 14: 
                    case 33: {
                        ((long[])object2)[Json2CDF.index++] = ((JsonNumber)object4).longValue();
                        break;
                    }
                    case 21: 
                    case 44: {
                        ((float[])object2)[Json2CDF.index++] = (float)((JsonNumber)object4).doubleValue();
                        break;
                    }
                    case 22: 
                    case 31: 
                    case 32: 
                    case 45: {
                        ((double[])object2)[Json2CDF.index++] = ((JsonNumber)object4).doubleValue();
                        break;
                    }
                }
                continue;
            }
            if (object4 instanceof JsonArray) {
                object2 = Json2CDF.setData(object4, object2);
                continue;
            }
            System.out.println("                     ?????");
            return null;
        }
        return object2;
    }

    private static Object setData1(Object object) throws CDFException {
        if (object instanceof JsonString || object instanceof String) {
            String string = object instanceof JsonString ? ((JsonString)object).toString() : (String)object;
            if (string.charAt(0) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            switch ((int)varDataType) {
                case 31: {
                    if (string.indexOf("-") != -1 && string.indexOf(":") != -1) {
                        return Epoch.toParse((String)string);
                    }
                    return Double.valueOf(string);
                }
                case 33: {
                    if (string.indexOf("-") != -1 && string.indexOf(":") != -1) {
                        return CDFTT2000.toParse((String)string);
                    }
                    return Long.valueOf(string);
                }
                case 32: {
                    if (string.indexOf("-") != -1 && string.indexOf(":") != -1) {
                        return Epoch16.toParse((String)string);
                    }
                    System.out.println("????? value" + string + " NOT handled for EPOCH16...");
                    return null;
                }
                case 8: {
                    return Long.valueOf(string);
                }
            }
            return string;
        }
        if (object instanceof JsonNumber) {
            switch ((int)varDataType) {
                case 1: 
                case 41: {
                    return (byte)((JsonNumber)object).intValue();
                }
                case 2: 
                case 11: {
                    return (short)((JsonNumber)object).intValue();
                }
                case 4: 
                case 12: {
                    return ((JsonNumber)object).intValue();
                }
                case 8: 
                case 14: 
                case 33: {
                    return ((JsonNumber)object).longValue();
                }
                case 21: 
                case 44: {
                    return Float.valueOf((float)((JsonNumber)object).doubleValue());
                }
                case 22: 
                case 31: 
                case 45: {
                    return ((JsonNumber)object).doubleValue();
                }
            }
            return null;
        }
        if (object instanceof JsonArray) {
            switch ((int)varDataType) {
                case 32: {
                    double[] dArray = new double[2];
                    for (int i = 0; i < 2; ++i) {
                        JsonNumber jsonNumber = (JsonNumber)((JsonArray)object).get(i);
                        dArray[i] = jsonNumber.doubleValue();
                    }
                    return dArray;
                }
            }
            return null;
        }
        return null;
    }

    private static void assignOne(Object object, Object object2) {
        switch ((int)varDataType) {
            case 1: 
            case 41: {
                ((byte[])object)[Json2CDF.index++] = (Byte)object2;
                break;
            }
            case 2: 
            case 11: {
                ((short[])object)[Json2CDF.index++] = (Short)object2;
                break;
            }
            case 4: 
            case 12: {
                ((int[])object)[Json2CDF.index++] = (Integer)object2;
                break;
            }
            case 8: 
            case 14: {
                ((long[])object)[Json2CDF.index++] = (Long)object2;
                break;
            }
            case 21: 
            case 44: {
                ((float[])object)[Json2CDF.index++] = ((Float)object2).floatValue();
                break;
            }
            case 22: 
            case 45: {
                ((double[])object)[Json2CDF.index++] = (Double)object2;
                break;
            }
        }
    }

    private static void moveOneRecord(Object object, int n, Object object2, int n2, int n3, long l) {
        int n4 = varDataType == 32L ? 2 : 1;
        int n5 = varDataType == 51L || varDataType == 52L ? (int)l : 1;
        block10: for (int i = 0; i < n3 * n4 * n5; ++i) {
            switch ((int)varDataType) {
                case 1: 
                case 41: {
                    ((byte[])object)[i + n] = ((byte[])object2)[i + n2];
                    continue block10;
                }
                case 2: 
                case 11: {
                    ((short[])object)[i + n] = ((short[])object2)[i + n2];
                    continue block10;
                }
                case 4: 
                case 12: {
                    ((int[])object)[i + n] = ((int[])object2)[i + n2];
                    continue block10;
                }
                case 8: 
                case 14: 
                case 33: {
                    ((long[])object)[i + n] = ((long[])object2)[i + n2];
                    continue block10;
                }
                case 21: 
                case 44: {
                    ((float[])object)[i + n] = ((float[])object2)[i + n2];
                    continue block10;
                }
                case 22: 
                case 31: 
                case 45: {
                    ((double[])object)[i + n] = ((double[])object2)[i + n2];
                    continue block10;
                }
                case 32: {
                    ((double[])object)[i + n] = ((double[])object2)[i + n2];
                    continue block10;
                }
                case 51: 
                case 52: {
                    ((double[])object)[i + n] = ((double[])object2)[i + n2];
                    continue block10;
                }
            }
        }
    }

    private static void exit(String string) {
        if (!string.equals("")) {
            System.out.println(string);
        }
        System.exit(1);
    }

    private static void usage() {
        System.out.println("\nDescription:");
        System.out.println("    This program exports the contents of a Json file into a CDF file(s).");
        System.out.println("");
        System.out.println("Usage: java Json2CDF [Options] JsonFileName ");
        System.out.println("    JsonFileName: The name of the Json file used to create a CDF(s).");
        System.out.println(" ");
        System.out.println("Options: ");
        System.out.println(" ");
        System.out.println("   -output:outputFileName");
        System.out.println("      Use this option to specify a different output file name for the CDF.");
        System.out.println("      It is only applicable to a single CDF file output.");
        System.out.println(" ");
        System.out.println("   -outdir:outputDir");
        System.out.println("      Specifies a directory to hold the output CDF file(s). Make sure the");
        System.out.println("      directory exists and is writeable.");
        System.out.println(" ");
        System.out.println("   -vardata:[yes | no].   -vardata:yes is the default.");
        System.out.println("      Whether to extract var data in the Json file if it is there. If \"no\"");
        System.out.println("      is specified, non-record varying variables' data will not be extracted.");
        System.out.println(" ");
        System.out.println("   -[showProgress | Progress]");
        System.out.println("      This option displays the processing progress on the screen.");
        System.out.println("      It shows how many CDF variables are there to process and which");
        System.out.println("      variable is being processed.");
        System.out.println(" ");
        System.out.println("   -checksum");
        System.out.println("      This option adds checksum to the file.");
        System.out.println(" ");
        System.out.println("   -nocompress");
        System.out.println("      This option forces no compression for variable data. By default, a");
        System.out.println("      variable with large enough size (>1K) will be compressed, no matter if");
        System.out.println("      defined by its specification or not.");
        System.out.println(" ");
        System.out.println("   -delete");
        System.out.println("      Over-ride the CDF file(s) if it alreadyexists.");
        System.out.println("");
        System.out.println("   -showfile");
        System.out.println("      Display the Json file being processed.");
        System.out.println("");
        System.out.println("NOTE:");
        System.out.println("  1. If an attribute value's data type is not specified, then its");
        System.out.println("     integral value is converted into 4-byte integer, if it can fill. ");
        System.out.println("     Otherwise, 8-byte long is used. All floating-values are converted into ");
        System.out.println("     8-byte doubles.");
        System.out.println("  2. A varying dimension with size of 1 is considered as non-varying.");
        System.out.println("     Its dimension is removed and NOT shown.");
        System.out.println("  3. Values for variable attributes: VALIDMIN/VALIDMAX/SCALEMIN/SCALEMAX/FILLVAL");
        System.out.println("     will have the same data type as the variable's.");
        System.out.println("  4. All variables are zVariables.");
        System.out.println("  5. All \"NaN\"|\"-NaN\" and \"INF\"|\"-INF\" strings are converted into");
        System.out.println("     floating-point values. ");
        System.out.println("");
        System.out.println("Examples: ");
        System.out.println("   java Json2CDF test.json (same as java Json2CDF -output:test.cdf test.json)");
        System.out.println("");
        System.out.println("The Json file should have the following form: (made from CDF2Json):\n\nCDFname1: \n CDFFileInfo: \n   FileVersion:..... \n   Format:..... \n   Majority:... \n   Encoding:..... \n   Checksum:..... \n CDFglobalAttributes: \n   Gattr_name1: \n    entry#:value \n      ... \n   Gattr_name2: \n    entry#:value \n      ... \n   ... \n   ... \n CDFVariables: \n   VarName1: \n    VarDescription: \n      DataType:.... \n      ... \n      ... \n    VarAttributes: \n      VALIDMIN:.... or VALIDMIN:... DataType:... Value:...\n      VALIDMAX:.... or VALIDMAX:... DataType:... Value:...\n      ... \n      ... \n    VarData: \n      ... \n   VarName2: \n    VarDescription: \n      DataType:.... \n      ... \n      ... \n    VarAttributes: \n      ... \n      ... \n    VarData: \n      ... \n EmptyAttributes:   <== If attribute(s) defined but not assign value(s) \n    GlobalAttributes:    <== If global attribute(s) is not assigned value \n    VariableAttributes:  <== If variable attribute(s) is not assigned value \n  \nCDFname2: \n CDFFileInfo: \n  ..... \n  ..... \n CDFglobalAttributes: \n   Gattr_name1: \n      ... \n   Gattr_name2: \n      ... \n   ... \n   ... \n CDFVariables: \n   VarName1: \n    VarDescription: \n      .... \n ....");
        System.out.println(" ");
    }

    private static void processGlobalAttributes(JsonArray jsonArray) throws CDFException {
        long l = 0L;
        boolean bl = false;
        Object object = null;
        for (JsonValue jsonValue : jsonArray) {
            for (String string : ((JsonObject)jsonValue).keySet()) {
                if (progress) {
                    System.out.println("  " + string);
                }
                Attribute attribute = Attribute.create((CDF)cdf, (String)string, (long)1L);
                JsonArray jsonArray2 = ((JsonObject)jsonValue).getJsonArray(string);
                for (int i = 0; i < jsonArray2.size(); ++i) {
                    JsonObject jsonObject = jsonArray2.getJsonObject(i);
                    for (String string2 : jsonObject.keySet()) {
                        Object object2 = jsonObject.get((Object)string2);
                        if (progress) {
                            System.out.println("      " + string2 + ":" + object2);
                        }
                        if (object2 instanceof JsonArray) {
                            block12: {
                                int n = ((JsonArray)object2).size();
                                Object object3 = ((JsonArray)object2).get(0);
                                if (object3 instanceof JsonObject) {
                                    try {
                                        JsonObject jsonObject2 = null;
                                        JsonObject jsonObject3 = null;
                                        jsonObject2 = (JsonObject)((JsonArray)object2).get(0);
                                        jsonObject3 = (JsonObject)((JsonArray)object2).get(1);
                                        if (jsonObject2 instanceof JsonObject) {
                                            String string3 = jsonObject2.getString("DataType");
                                            l = CDFUtils.getDataTypeValue((String)string3);
                                            Object object4 = jsonObject3.get((Object)"Value");
                                            bl = true;
                                            object = Json2CDF.getData(object4, l);
                                            break block12;
                                        }
                                        object = Json2CDF.getData(object2, 0L);
                                    }
                                    catch (Exception exception) {
                                        l = 0L;
                                        object = Json2CDF.getData(object2, l);
                                    }
                                } else {
                                    object = Json2CDF.getData(object2, 0L);
                                }
                            }
                            Entry.create((Attribute)attribute, (long)Integer.valueOf(string2).intValue(), (long)dataType, (Object)object);
                            continue;
                        }
                        object = Json2CDF.getData(object2, 0L);
                        Entry.create((Attribute)attribute, (long)Integer.valueOf(string2).intValue(), (long)dataType, (Object)object);
                    }
                }
            }
        }
    }

    private static Variable processVariableSpec(String string, Object object) throws CDFException {
        int n;
        Object object2 = null;
        varPadValue = null;
        varSparseRec = 0L;
        long l = -1L;
        int n2 = ((JsonArray)object).size();
        varMaxWritten = -1L;
        varNumDims = -1L;
        varNumElems = -1L;
        varDataType = -1L;
        compression = -1L;
        compLvl = 0L;
        for (n = 0; n < n2; ++n) {
            Object object3 = ((JsonArray)object).get(n);
            if (!(object3 instanceof JsonObject)) continue;
            for (String string2 : ((JsonObject)object3).keySet()) {
                String string3;
                int n3;
                String string4;
                Object object4 = ((JsonObject)object3).get((Object)string2);
                if (progress) {
                    System.out.println("      " + string2 + ":" + object4);
                }
                if (string2.equalsIgnoreCase("varname")) continue;
                if (string2.equalsIgnoreCase("datatype")) {
                    string4 = ((JsonObject)object3).getString(string2);
                    varDataType = CDFUtils.getDataTypeValue((String)string4);
                    continue;
                }
                if (string2.equalsIgnoreCase("numelements")) {
                    varNumElems = ((JsonObject)object3).getInt(string2);
                    continue;
                }
                if (string2.equalsIgnoreCase("numdims")) {
                    varNumDims = ((JsonObject)object3).getInt(string2);
                    continue;
                }
                if (string2.equalsIgnoreCase("dimsizes")) {
                    string4 = ((JsonObject)object3).getJsonArray(string2);
                    for (n3 = 0; n3 < (int)varNumDims; ++n3) {
                        Json2CDF.varDimSizes[n3] = string4.getInt(n3);
                    }
                    continue;
                }
                if (string2.equalsIgnoreCase("recvariance")) {
                    string4 = ((JsonObject)object3).getString(string2);
                    if (string4.equalsIgnoreCase("vary")) {
                        varRecVary = -1L;
                        continue;
                    }
                    varRecVary = 0L;
                    continue;
                }
                if (string2.equalsIgnoreCase("dimvariances")) {
                    string4 = ((JsonObject)object3).getJsonArray(string2);
                    for (n3 = 0; n3 < (int)varNumDims; ++n3) {
                        string3 = string4.getString(n3);
                        Json2CDF.varDimVariances[n3] = string3.equalsIgnoreCase("vary") ? -1L : 0L;
                    }
                    continue;
                }
                if (string2.equalsIgnoreCase("compression")) {
                    string4 = ((JsonObject)object3).getString(string2);
                    n3 = string4.indexOf(46);
                    if (n3 != -1) {
                        string3 = string4.substring(0, string4.indexOf(46));
                        String string5 = string4.substring(string4.indexOf(46) + 1);
                        compression = CDFUtils.getLongCompressionType((String)string3);
                        compLvl = Long.valueOf(string5);
                        continue;
                    }
                    compression = CDFUtils.getLongCompressionType((String)string4);
                    compLvl = 0L;
                    continue;
                }
                if (string2.equalsIgnoreCase("blockingfactor")) {
                    l = ((JsonObject)object3).getInt(string2);
                    continue;
                }
                if (string2.equalsIgnoreCase("sparserecords")) {
                    string4 = ((JsonObject)object3).getString(string2);
                    varSparseRec = CDFUtils.getLongSparseRecord((String)string4);
                    continue;
                }
                if (string2.equalsIgnoreCase("numwrittenrecords")) {
                    varNumWritten = ((JsonObject)object3).getInt(string2);
                    continue;
                }
                if (string2.equalsIgnoreCase("maxwrittenrec")) {
                    varMaxWritten = ((JsonObject)object3).getInt(string2);
                    continue;
                }
                if (string2.equalsIgnoreCase("padvalue")) {
                    object2 = ((JsonObject)object3).get((Object)string2);
                    continue;
                }
                System.out.println("NOT handling... " + string2);
            }
        }
        if (progress) {
            System.out.print("***** Creating... var:" + string + "  type:" + CDFUtils.getStringDataType((long)varDataType) + " numElms=" + varNumElems + " numDims=" + varNumDims + " ");
            if (varNumDims > 0L) {
                System.out.print("dimSize=[");
                for (n = 0; n < (int)varNumDims; ++n) {
                    System.out.print(varDimSizes[n]);
                    if ((long)n < varNumDims - 1L) {
                        System.out.print(",");
                    }
                    if ((long)n != varNumDims - 1L) continue;
                    System.out.print("] ");
                }
            }
            System.out.println("RecVary=" + (varRecVary == -1L ? "T" : "F"));
        }
        if (varDataType == -1L || varNumElems == -1L || varNumDims == -1L) {
            return null;
        }
        var = Variable.create((CDF)cdf, (String)string, (long)varDataType, (long)varNumElems, (long)varNumDims, (long[])varDimSizes, (long)varRecVary, (long[])varDimVariances);
        varFillVal = null;
        if (object2 != null) {
            varPadValue = Json2CDF.setData1(object2);
            var.setPadValue(varPadValue);
        }
        if (l != -1L) {
            var.setBlockingFactor(l);
        }
        if (varSparseRec != 0L) {
            var.setSparseRecords(varSparseRec);
        }
        if (toCompress && compression != -1L) {
            var.setCompression(compression, new long[]{compLvl});
        }
        return var;
    }

    private static void processVariableAttributes(Object object) throws CDFException {
        int n = ((JsonArray)object).size();
        Object object2 = null;
        boolean bl = false;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            Attribute attribute = null;
            JsonObject jsonObject = ((JsonArray)object).getJsonObject(i);
            for (String string : jsonObject.keySet()) {
                Object object3;
                bl = false;
                Object object4 = jsonObject.get((Object)string);
                l = 0L;
                if (progress) {
                    System.out.println("      " + string + ":" + object4);
                }
                try {
                    attribute = Attribute.create((CDF)cdf, (String)string, (long)2L);
                }
                catch (CDFException cDFException) {
                    attribute = cdf.getAttribute(string);
                }
                if (object4 instanceof JsonArray) {
                    int n2 = ((JsonArray)object4).size();
                    object3 = ((JsonArray)object4).get(0);
                    if (object3 instanceof JsonObject) {
                        Object object5;
                        Object object6;
                        try {
                            object6 = null;
                            object5 = null;
                            object6 = (JsonObject)((JsonArray)object4).get(0);
                            object5 = (JsonObject)((JsonArray)object4).get(1);
                            if (object6 instanceof JsonObject) {
                                String string2 = object6.getString("DataType");
                                l = CDFUtils.getDataTypeValue((String)string2);
                                object4 = object5.get((Object)"Value");
                                bl = true;
                            }
                        }
                        catch (Exception exception) {
                            l = 0L;
                        }
                        dataType = varDataType;
                        vAttrName = string;
                        object2 = Json2CDF.getData(object4, l);
                        if (!bl && Json2CDF.useVarDataType(string)) {
                            object6 = Json2CDF.changeData(dataType, varDataType, object2);
                            if (string.equalsIgnoreCase("fillval")) {
                                varFillVal = object6;
                            }
                        }
                        if (object2 instanceof String[]) {
                            int n3 = ((String[])object2).length;
                            object5 = new StringBuffer();
                            for (int j = 0; j < n3; ++j) {
                                ((StringBuffer)object5).append(((String[])object2)[j]);
                                if (j >= n3 - 1) continue;
                                ((StringBuffer)object5).append(STRINGDELIMITER);
                            }
                            var.putEntry(attribute, bl ? l : 51L, (Object)((StringBuffer)object5).toString());
                            continue;
                        }
                        var.putEntry(attribute, bl ? l : dataType, object2);
                        continue;
                    }
                    dataTypeY = Json2CDF.useVarDataType(string) ? var.getDataType() : -1L;
                    Object object7 = Json2CDF.buildDataObject(dataTypeY, object4);
                    var.putEntry(attribute, dataTypeY, object7);
                    continue;
                }
                if (object4 instanceof JsonString) {
                    String string3 = (String)Json2CDF.getData(object4, 51L);
                    if (Json2CDF.useVarDataType(string)) {
                        object3 = Json2CDF.parseContents(string3, varDataType);
                        if (object3 != null) {
                            var.putEntry(attribute, varDataType, object3);
                            continue;
                        }
                        var.putEntry(attribute, 51L, (Object)string3);
                        continue;
                    }
                    var.putEntry(attribute, 51L, (Object)string3);
                    continue;
                }
                dataType = varDataType;
                vAttrName = string;
                object2 = Json2CDF.getData(object4, 0L);
                if (!bl && Json2CDF.useVarDataType(string)) {
                    object2 = Json2CDF.changeData(dataType, varDataType, object2);
                    if (string.equalsIgnoreCase("fillval")) {
                        varFillVal = object2;
                    }
                }
                var.putEntry(attribute, dataType, object2);
            }
        }
    }

    private static void processVariableData(Object object) throws CDFException {
        try {
            int n;
            int n2 = (int)(varMaxWritten == -1L ? (varNumWritten == -1L ? -1L : varNumWritten) : varMaxWritten + 1L);
            if (n2 <= 0) {
                n2 = object instanceof JsonArray ? ((JsonArray)object).size() : 1;
            }
            if (!var.getRecVariance()) {
                n2 = 1;
            }
            int n3 = 1;
            Object object2 = null;
            Object object3 = null;
            varRecItems = 1L;
            int n4 = 0;
            while ((long)n4 < varNumDims) {
                varRecItems *= varDimSizes[n4];
                ++n4;
            }
            if (varDataType == 51L || varDataType == 52L) {
                n3 = (int)varRecItems * (int)varNumElems * n2;
            }
            int n5 = (int)(varRecItems * (long)n2);
            if (progress) {
                System.out.println("      recNum=" + n2 + " total values=" + n5);
            }
            if (varDataType == 1L || varDataType == 41L) {
                object3 = new byte[n5];
                if (varSparseRec != 0L) {
                    object2 = new byte[(int)varRecItems];
                }
            } else if (varDataType == 2L || varDataType == 11L) {
                object3 = new short[n5];
                if (varSparseRec != 0L) {
                    object2 = new short[(int)varRecItems];
                }
            } else if (varDataType == 4L || varDataType == 12L) {
                object3 = new int[n5];
                if (varSparseRec != 0L) {
                    object2 = new int[(int)varRecItems];
                }
            } else if (varDataType == 8L || varDataType == 14L || varDataType == 33L) {
                object3 = new long[n5];
                if (varSparseRec != 0L) {
                    object2 = new long[(int)varRecItems];
                }
            } else if (varDataType == 21L || varDataType == 44L) {
                object3 = new float[n5];
                if (varSparseRec != 0L) {
                    object2 = new float[(int)varRecItems];
                }
            } else if (varDataType == 22L || varDataType == 45L || varDataType == 31L) {
                object3 = new double[n5];
                if (varSparseRec != 0L) {
                    object2 = new double[(int)varRecItems];
                }
            } else if (varDataType == 32L) {
                object3 = new double[n5 * 2];
                if (varSparseRec != 0L) {
                    object2 = new double[(int)varRecItems * 2];
                }
            } else if (varDataType == 51L || varDataType == 52L) {
                object3 = new byte[n3];
                if (varSparseRec != 0L) {
                    object2 = new byte[(int)(varRecItems * varNumElems)];
                }
            }
            if (toCompress && compression == -1L) {
                n = 0;
                if (varDataType == 32L) {
                    n = 1;
                }
                long l = varRecItems * varNumElems * (long)(n != 0 ? 2 : 1);
                if ((l *= (long)Json2CDF.getDataTypeSize(varDataType)) > 1000L) {
                    compression = 5L;
                    compLvl = 6L;
                    var.setCompression(compression, new long[]{compLvl});
                }
            }
            if (varSparseRec == 0L) {
                object2 = object instanceof JsonArray ? (Object)Json2CDF.setData(object, object3) : (Object)Json2CDF.setData1(object);
                var.putRecords(0L, (long)n2, object2);
            } else {
                Object object4 = null;
                if (varSparseRec == 1L) {
                    object4 = varFillVal != null ? varFillVal : varPadValue;
                }
                if (object instanceof JsonArray) {
                    for (n = 0; n < n2; ++n) {
                        Object object5 = ((JsonArray)object).get(n);
                        if (object5 instanceof JsonArray) {
                            object3 = Json2CDF.setData(object5, object3);
                            Json2CDF.moveOneRecord(object2, 0, object3, (int)((long)index - varRecItems), (int)varRecItems, varNumElems);
                        } else {
                            object2 = Json2CDF.setData1(object5);
                        }
                        boolean bl = Json2CDF.checkForVirtual(object2, object4);
                        if (bl) continue;
                        var.putRecord((long)n, object2);
                        if (varSparseRec != 2L) continue;
                        object4 = object2;
                    }
                } else {
                    object2 = Json2CDF.setData1(object);
                    boolean bl = Json2CDF.checkForVirtual(object2, object4);
                    if (!bl) {
                        var.putRecord(0L, object2);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("*** Error: " + exception);
        }
    }

    private static boolean checkForVirtual(Object object, Object object2) {
        if (object2 == null) {
            return false;
        }
        String string = CDFUtils.getSignature((Object)object);
        String string2 = CDFUtils.getSignature((Object)object2);
        if (string.charAt(0) == '[') {
            if (varDataType == 1L || varDataType == 41L) {
                int n = ((byte[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (!(string2.charAt(0) == '[' ? ((byte[])object)[i] != ((byte[])object2)[i] : ((byte[])object)[i] != (Byte)object2)) continue;
                    return false;
                }
                return true;
            }
            if (varDataType == 2L || varDataType == 11L) {
                int n = ((short[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (!(string2.charAt(0) == '[' ? ((short[])object)[i] != ((short[])object2)[i] : ((short[])object)[i] != (Short)object2)) continue;
                    return false;
                }
                return true;
            }
            if (varDataType == 4L || varDataType == 12L) {
                int n = ((int[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (!(string2.charAt(0) == '[' ? ((int[])object)[i] != ((int[])object2)[i] : ((int[])object)[i] != (Integer)object2)) continue;
                    return false;
                }
                return true;
            }
            if (varDataType == 8L || varDataType == 14L || varDataType == 33L) {
                int n = ((long[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (!(string2.charAt(0) == '[' ? ((long[])object)[i] != ((long[])object2)[i] : ((long[])object)[i] != (Long)object2)) continue;
                    return false;
                }
                return true;
            }
            if (varDataType == 21L || varDataType == 44L) {
                int n = ((float[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (!(string2.charAt(0) == '[' ? ((float[])object)[i] != ((float[])object2)[i] : ((float[])object)[i] != ((Float)object2).floatValue())) continue;
                    return false;
                }
                return true;
            }
            if (varDataType == 22L || varDataType == 45L || varDataType == 31L) {
                int n = ((double[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (!(string2.charAt(0) == '[' ? ((double[])object)[i] != ((double[])object2)[i] : ((double[])object)[i] != (Double)object2)) continue;
                    return false;
                }
                return true;
            }
        } else {
            if (varDataType == 1L || varDataType == 41L) {
                return ((Byte)object).byteValue() == ((Byte)object2).byteValue();
            }
            if (varDataType == 2L || varDataType == 11L) {
                return ((Short)object).shortValue() == ((Short)object2).shortValue();
            }
            if (varDataType == 4L || varDataType == 12L) {
                return ((Integer)object).intValue() == ((Integer)object2).intValue();
            }
            if (varDataType != 8L && varDataType != 14L && varDataType != 33L) {
                if (varDataType == 21L || varDataType == 44L) {
                    return (Float)object == (Float)object2;
                }
                if (varDataType == 22L || varDataType == 45L || varDataType == 31L) {
                    return (Double)object == (Double)object2;
                }
                return false;
            }
        }
        return false;
    }

    private static int getDimSize(Object object) {
        String string = CDFUtils.getSignature((Object)object);
        String string2 = string.substring(0, 2);
        if (string2.equals("[I")) {
            return ((int[])object).length;
        }
        if (string2.equals("[B")) {
            return ((byte[])object).length;
        }
        if (string2.equals("[J")) {
            return ((long[])object).length;
        }
        if (string2.equals("[S")) {
            return ((short[])object).length;
        }
        if (string2.equals("[F")) {
            return ((float[])object).length;
        }
        if (string2.equals("[D")) {
            return ((double[])object).length;
        }
        return 1;
    }

    private static int getDataTypeSize(long l) {
        int n;
        switch ((int)l) {
            case 1: 
            case 11: 
            case 41: 
            case 51: 
            case 52: {
                n = 1;
                break;
            }
            case 2: 
            case 12: {
                n = 2;
                break;
            }
            case 4: 
            case 14: 
            case 21: 
            case 44: {
                n = 4;
                break;
            }
            case 8: 
            case 22: 
            case 31: 
            case 33: 
            case 45: {
                n = 8;
                break;
            }
            case 32: {
                n = 16;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    public static Object parseContents(String string, long l) {
        if (string.charAt(0) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == -1) {
            return null;
        }
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        int n = vector.size();
        if (l == 51L || l == 52L) {
            String string2 = string;
            if (string.indexOf("\\\"") != -1) {
                string2 = string.replaceAll("\\\\\"", "\"");
            }
            if (string2.indexOf("\\n") != -1) {
                string2 = string2.replace("\\n", "\n");
            }
            return string2;
        }
        if (l == 41L || l == 1L) {
            byte[] byArray = new byte[n];
            if (n == 1) {
                try {
                    byArray[0] = Byte.valueOf(string);
                }
                catch (Exception exception) {
                    if (progress) {
                        System.out.println("***** Invalid INT1: " + string + " => out of range");
                    }
                    return null;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    String string3 = ((String)vector.elementAt(i)).trim();
                    try {
                        byArray[i] = Byte.valueOf(string3);
                        continue;
                    }
                    catch (Exception exception) {
                        if (progress) {
                            System.out.println("***** Invalid INT1: " + string3 + " => out of range");
                        }
                        return null;
                    }
                }
            }
            return byArray;
        }
        if (l == 11L || l == 2L) {
            short[] sArray;
            block101: {
                sArray = new short[n];
                if (n == 1) {
                    try {
                        sArray[0] = Short.valueOf(string);
                        if (l == 11L && (sArray[0] < 0 || sArray[0] > 255)) {
                            if (progress) {
                                System.out.println("***** Invalid UINT1: " + sArray[0] + " => out of range");
                            }
                            return null;
                        }
                        break block101;
                    }
                    catch (Exception exception) {
                        if (progress) {
                            System.out.println("***** Invalid INT2: " + string);
                        }
                        return null;
                    }
                }
                for (int i = 0; i < n; ++i) {
                    String string4 = ((String)vector.elementAt(i)).trim();
                    try {
                        sArray[i] = Short.valueOf(string4);
                        if (l != 11L || sArray[i] >= 0 && sArray[i] <= 255) continue;
                        if (progress) {
                            System.out.println("***** Invalid UINT1: " + sArray[i] + " => out of range");
                        }
                        return null;
                    }
                    catch (Exception exception) {
                        if (progress) {
                            System.out.println("***** Invalid INT2: " + string4);
                        }
                        return null;
                    }
                }
            }
            return sArray;
        }
        if (l == 12L || l == 4L) {
            int[] nArray;
            block102: {
                nArray = new int[n];
                if (n == 1) {
                    try {
                        nArray[0] = Integer.valueOf(string);
                        if (l == 12L && (nArray[0] < 0 || nArray[0] > 65535)) {
                            if (progress) {
                                System.out.println("***** Invalid UINT2: " + nArray[0] + " => out of range");
                            }
                            return null;
                        }
                        break block102;
                    }
                    catch (Exception exception) {
                        if (progress) {
                            System.out.println("***** Invalid INT4: " + string);
                        }
                        return null;
                    }
                }
                for (int i = 0; i < n; ++i) {
                    String string5 = ((String)vector.elementAt(i)).trim();
                    try {
                        nArray[i] = Integer.valueOf(string5);
                        if (l != 12L || nArray[i] >= 0 && nArray[i] <= 65535) continue;
                        if (progress) {
                            System.out.println("***** Invalid UINT2: " + nArray[i] + " => out of range");
                        }
                        return null;
                    }
                    catch (Exception exception) {
                        if (progress) {
                            System.out.println("***** Invalid INT4: " + string5);
                        }
                        return null;
                    }
                }
            }
            return nArray;
        }
        if (l == 14L || l == 8L) {
            long[] lArray;
            block103: {
                lArray = new long[n];
                if (n == 1) {
                    try {
                        lArray[0] = Long.valueOf(string);
                        if (l == 14L && (lArray[0] < 0L || lArray[0] > 0xFFFFFFFFL)) {
                            if (progress) {
                                System.out.println("***** Invalid UINT4: " + lArray[0] + " => out of range");
                            }
                            return null;
                        }
                        break block103;
                    }
                    catch (Exception exception) {
                        if (progress) {
                            System.out.println("***** Invalid INT8: " + string);
                        }
                        return null;
                    }
                }
                for (int i = 0; i < n; ++i) {
                    String string6 = ((String)vector.elementAt(i)).trim();
                    try {
                        lArray[i] = Long.valueOf(string6);
                        if (l != 14L || lArray[i] >= 0L && lArray[i] <= 0xFFFFFFFFL) continue;
                        if (progress) {
                            System.out.println("***** Invalid UINT4: " + lArray[i] + " => out of range");
                        }
                        return null;
                    }
                    catch (Exception exception) {
                        if (progress) {
                            System.out.println("***** Invalid INT8: " + string6);
                        }
                        return null;
                    }
                }
            }
            return lArray;
        }
        if (l == 44L || l == 21L) {
            float[] fArray = new float[n];
            if (n == 1) {
                fArray[0] = Float.valueOf(string).floatValue();
            } else {
                for (int i = 0; i < n; ++i) {
                    fArray[i] = Float.valueOf(((String)vector.elementAt(i)).trim()).floatValue();
                }
            }
            return fArray;
        }
        if (l == 22L || l == 45L) {
            double[] dArray = new double[n];
            if (n == 1) {
                dArray[0] = Double.valueOf(string);
            } else {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = Double.valueOf(((String)vector.elementAt(i)).trim());
                }
            }
            return dArray;
        }
        if (l == 31L) {
            double[] dArray = new double[n];
            if (n == 1) {
                try {
                    Double.parseDouble(string);
                    dArray[0] = Double.valueOf(string);
                }
                catch (Exception exception) {
                    try {
                        dArray[0] = Epoch.toParse((String)string);
                    }
                    catch (CDFException cDFException) {
                        if (progress) {
                            System.out.println("***** Invalid Epoch: " + string + " => Format?");
                        }
                        return null;
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    String string7 = ((String)vector.elementAt(i)).trim();
                    if (string7.indexOf(":") != -1) continue;
                    try {
                        Double.parseDouble(string7);
                        dArray[i] = Double.valueOf(string7);
                        continue;
                    }
                    catch (Exception exception) {
                        try {
                            dArray[i] = Epoch.toParse((String)string7);
                            continue;
                        }
                        catch (CDFException cDFException) {
                            if (progress) {
                                System.out.println("***** Invalid Epoch: " + string7 + " => Format?");
                            }
                            return null;
                        }
                    }
                }
            }
            return dArray;
        }
        if (l == 32L) {
            if (n == 1) {
                double[] dArray = new double[2];
                try {
                    Double.parseDouble(string);
                    dArray[0] = Double.valueOf(string);
                    dArray[1] = 0.0;
                }
                catch (Exception exception) {
                    try {
                        dArray = Epoch16.toParse((String)string);
                    }
                    catch (CDFException cDFException) {
                        if (progress) {
                            System.out.println("***** Invalid Epoch16: " + string + " => Format?");
                        }
                        return null;
                    }
                }
                return dArray;
            }
            double[][] dArray = new double[n][2];
            double[] dArray2 = new double[2];
            for (int i = 0; i < n; ++i) {
                String string8 = ((String)vector.elementAt(i)).trim();
                try {
                    Double.parseDouble(string8);
                    dArray[i][0] = Double.valueOf(string8);
                    dArray[i][1] = 0.0;
                    continue;
                }
                catch (Exception exception) {
                    try {
                        dArray2 = Epoch16.toParse((String)string8);
                        dArray[i][0] = dArray2[0];
                        dArray[i][1] = dArray2[1];
                        continue;
                    }
                    catch (CDFException cDFException) {
                        if (progress) {
                            System.out.println("***** Invalid Epoch16: " + string8 + " => Format?");
                        }
                        return null;
                    }
                }
            }
            return dArray;
        }
        if (l == 33L) {
            long[] lArray = new long[n];
            if (n == 1) {
                try {
                    Long.parseLong(string);
                    lArray[0] = Long.valueOf(string);
                }
                catch (Exception exception) {
                    try {
                        lArray[0] = CDFTT2000.toParse((String)string);
                    }
                    catch (CDFException cDFException) {
                        if (progress) {
                            System.out.println("***** Invalid tt2000: " + string + " => Format?");
                        }
                        return null;
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    String string9 = ((String)vector.elementAt(i)).trim();
                    try {
                        Long.parseLong(string9);
                        lArray[i] = Long.valueOf(string9);
                        continue;
                    }
                    catch (Exception exception) {
                        try {
                            lArray[i] = CDFTT2000.toParse((String)string9);
                            continue;
                        }
                        catch (CDFException cDFException) {
                            if (progress) {
                                System.out.println("***** Invalid tt2000: " + string9 + " => Format?");
                            }
                            return null;
                        }
                    }
                }
            }
            return lArray;
        }
        return null;
    }

    private static boolean useVarDataType(String string) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("validmin") || string.equalsIgnoreCase("validmax") || string.equalsIgnoreCase("scalemin") || string.equalsIgnoreCase("scalemax") || string.equalsIgnoreCase("fillval");
    }

    private static Object buildDataObject(long l, Object object) {
        Object object2 = null;
        int n = ((JsonArray)object).size();
        Object object3 = null;
        switch ((int)l) {
            case 1: 
            case 41: {
                if (n > 1) {
                    object2 = new byte[n];
                    for (int i = 0; i < n; ++i) {
                        String string = ((JsonNumber)((JsonArray)object).get(i)).toString();
                        object2[i] = Byte.valueOf(string);
                    }
                    break;
                }
                object2 = new byte[1];
                String string = ((JsonNumber)object).toString();
                object2[0] = Byte.valueOf(string);
                break;
            }
            case 2: 
            case 11: {
                if (n > 1) {
                    object2 = new short[n];
                    for (int i = 0; i < n; ++i) {
                        String string = ((JsonNumber)((JsonArray)object).get(i)).toString();
                        ((short[])object2)[i] = Short.valueOf(string);
                    }
                    break;
                }
                object2 = new short[1];
                String string = ((JsonNumber)object).toString();
                ((short[])object2)[0] = Short.valueOf(string);
                break;
            }
            case 4: 
            case 12: {
                if (n > 1) {
                    object2 = new int[n];
                    for (int i = 0; i < n; ++i) {
                        String string = ((JsonNumber)((JsonArray)object).get(i)).toString();
                        ((int[])object2)[i] = Integer.valueOf(string);
                    }
                    break;
                }
                object2 = new int[1];
                String string = ((JsonNumber)object).toString();
                ((int[])object2)[0] = Integer.valueOf(string);
                break;
            }
            case 8: 
            case 14: {
                if (n > 1) {
                    object2 = new long[n];
                    for (int i = 0; i < n; ++i) {
                        String string = ((JsonNumber)((JsonArray)object).get(i)).toString();
                        ((long[])object2)[i] = Long.valueOf(string);
                    }
                    break;
                }
                object2 = new long[1];
                String string = ((JsonNumber)object).toString();
                ((long[])object2)[0] = Long.valueOf(string);
                break;
            }
            case 33: {
                if (n > 1) {
                    object2 = new long[n];
                    for (int i = 0; i < n; ++i) {
                        String string;
                        object3 = ((JsonArray)object).get(i);
                        if (object3 instanceof JsonNumber) {
                            string = ((JsonNumber)object3).toString();
                            ((long[])object2)[i] = Long.valueOf(string);
                        }
                        if (!(object3 instanceof JsonString)) continue;
                        string = ((JsonString)object3).toString();
                        try {
                            ((long[])object2)[i] = CDFTT2000.toParse((String)string);
                            continue;
                        }
                        catch (Exception exception) {
                            ((long[])object2)[i] = -9223372036854775805L;
                        }
                    }
                    break;
                }
                object2 = new long[1];
                if (object instanceof JsonNumber) {
                    String string = ((JsonNumber)object).toString();
                    ((long[])object2)[0] = Long.valueOf(string);
                    break;
                }
                if (!(object instanceof JsonString)) break;
                String string = ((JsonString)object).toString();
                try {
                    ((long[])object2)[0] = CDFTT2000.toParse((String)string);
                }
                catch (Exception exception) {
                    ((long[])object2)[0] = -9223372036854775805L;
                }
            }
            case 21: 
            case 44: {
                if (n > 1) {
                    object2 = new float[n];
                    for (int i = 0; i < n; ++i) {
                        String string = ((JsonNumber)((JsonArray)object).get(i)).toString();
                        ((float[])object2)[i] = Float.valueOf(string).floatValue();
                    }
                    break;
                }
                object2 = new float[1];
                String string = ((JsonNumber)object).toString();
                ((float[])object2)[0] = Float.valueOf(string).floatValue();
                break;
            }
            case 22: 
            case 45: {
                if (n > 1) {
                    object2 = new double[n];
                    for (int i = 0; i < n; ++i) {
                        String string = ((JsonNumber)((JsonArray)object).get(i)).toString();
                        ((double[])object2)[i] = Double.valueOf(string);
                    }
                    break;
                }
                object2 = new double[1];
                String string = ((JsonNumber)object).toString();
                ((double[])object2)[0] = Double.valueOf(string);
                break;
            }
            case 31: {
                if (n > 1) {
                    object2 = new double[n];
                    for (int i = 0; i < n; ++i) {
                        String string;
                        object3 = ((JsonArray)object).get(i);
                        if (object3 instanceof JsonNumber) {
                            string = ((JsonNumber)object3).toString();
                            ((double[])object2)[i] = Double.valueOf(string);
                            continue;
                        }
                        if (!(object3 instanceof JsonString)) continue;
                        string = ((JsonString)object3).toString();
                        try {
                            ((double[])object2)[i] = Epoch.toParse((String)string);
                            continue;
                        }
                        catch (Exception exception) {
                            ((double[])object2)[i] = -1.0;
                        }
                    }
                    break;
                }
                object2 = new double[1];
                if (object instanceof JsonNumber) {
                    String string = ((JsonNumber)object).toString();
                    ((double[])object2)[0] = Double.valueOf(string);
                    break;
                }
                if (!(object instanceof JsonString)) break;
                String string = ((JsonString)object).toString();
                try {
                    ((double[])object2)[0] = Epoch.toParse((String)string);
                }
                catch (Exception exception) {
                    ((double[])object2)[0] = -1.0;
                }
            }
            case 32: {
                double[] dArray = new double[2];
                object3 = ((JsonArray)object).get(0);
                if (object3 instanceof JsonNumber) {
                    object2 = new double[n];
                    for (int i = 0; i < n / 2; ++i) {
                        String string = ((JsonNumber)((JsonArray)object).get(2 * i)).toString();
                        String string2 = ((JsonNumber)((JsonArray)object).get(2 * i + 1)).toString();
                        ((double[])object2)[2 * i] = Double.valueOf(string);
                        ((double[])object2)[2 * i + 1] = Double.valueOf(string2);
                    }
                    break;
                }
                if (!(object3 instanceof JsonString)) break;
                object2 = new double[2 * n];
                for (int i = 0; i < n; ++i) {
                    String string = ((JsonString)((JsonArray)object).get(i)).toString();
                    try {
                        dArray = Epoch16.toParse((String)string);
                    }
                    catch (Exception exception) {
                        dArray[0] = -1.0;
                        dArray[1] = -1.0;
                    }
                    ((double[])object2)[2 * i] = dArray[0];
                    ((double[])object2)[2 * i + 1] = dArray[1];
                }
                break;
            }
            default: {
                if (n > 1) {
                    Object object4 = ((JsonArray)object).get(0);
                    if (object4 instanceof JsonNumber) {
                        if (((JsonNumber)object4).isIntegral()) {
                            try {
                                object2 = new int[n];
                                for (int i = 0; i < n; ++i) {
                                    object3 = ((JsonArray)object).get(i);
                                    String string = ((JsonNumber)object3).toString();
                                    ((int[])object2)[i] = Integer.valueOf(string);
                                }
                                dataTypeY = 4L;
                                break;
                            }
                            catch (Exception exception) {
                                try {
                                    object2 = new long[n];
                                    for (int i = 0; i < n; ++i) {
                                        object3 = ((JsonArray)object).get(i);
                                        String string = ((JsonNumber)object3).toString();
                                        ((long[])object2)[i] = Long.valueOf(string);
                                    }
                                    dataTypeY = 8L;
                                    break;
                                }
                                catch (Exception exception2) {
                                    System.out.println("Invalid Json integer... value:" + object + " dt:" + dataTypeY + " " + exception2);
                                    return null;
                                }
                            }
                        }
                        object2 = new double[n];
                        for (int i = 0; i < n; ++i) {
                            object3 = ((JsonArray)object).get(i);
                            String string = ((JsonNumber)object3).toString();
                            ((double[])object2)[i] = Double.valueOf(string);
                        }
                        dataTypeY = 45L;
                        break;
                    }
                    if (!(object4 instanceof JsonString)) break;
                    object2 = new String();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < n; ++i) {
                        object3 = ((JsonArray)object).get(i);
                        String string = ((JsonString)object3).toString();
                        if (string.startsWith("\"") && string.endsWith("\"")) {
                            string = string.substring(1, string.length() - 1);
                        }
                        stringBuffer = stringBuffer.append(string);
                        if (i == n - 1) continue;
                        stringBuffer = stringBuffer.append(" ");
                    }
                    object2 = new String(stringBuffer.toString());
                    dataTypeY = 51L;
                    break;
                }
                if (object instanceof JsonNumber) {
                    String string = ((JsonNumber)object).toString();
                    if (((JsonNumber)object).isIntegral()) {
                        try {
                            object2 = new int[1];
                            dataTypeY = 4L;
                            object2 = Json2CDF.parseContents(string, dataTypeY);
                            break;
                        }
                        catch (Exception exception) {
                            try {
                                object2 = new long[1];
                                dataTypeY = 8L;
                                object2 = Json2CDF.parseContents(string, dataTypeY);
                                break;
                            }
                            catch (Exception exception3) {
                                System.out.println("Invalid Json integer... value:" + string + " dt:" + dataTypeY + " " + exception3);
                                return null;
                            }
                        }
                    }
                    object2 = new double[1];
                    dataTypeY = 45L;
                    object2 = Json2CDF.parseContents(string, dataTypeY);
                    break;
                }
                if (!(object instanceof JsonString)) break;
                object2 = new String();
                String string = ((JsonString)object).toString();
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                object2 = new String(string);
                dataTypeY = 51L;
            }
        }
        return object2;
    }

    static {
        varData = true;
        varSparseRec = 0L;
        varNumWritten = 0L;
        varMaxWritten = -1L;
        varDimSizes = new long[10];
        varDimVariances = new long[10];
        varName = null;
        varPadValue = null;
        varFillVal = null;
        varRecVary = -1L;
        separator = System.getProperty("file.separator");
        item1 = "CDFFileInfo";
        item2 = "CDFglobalAttributes";
        item3 = "CDFVariables";
        item4 = "VarDescription";
        item5 = "VarAttributes";
        item6 = "VarData";
        item7 = "EmptyAttributes";
        vAttrName = null;
        dataTypeY = -1L;
        compression = -1L;
        compLvl = 0L;
        cdf = null;
        var = null;
        index = 0;
    }
}

