'*****************************************************************************e
'
'  NSSDC/CDF                      Quick Start Test Program(C# interface).
'
'  Version 1.0,15-Oct-09,Mike Liu
'
'  Modification history:
'
'   V1.0   15-Oct-09,M Liu     Original version(for CDF V3.3).
'                              Using pointers (&) to pass arguments for 
'                              retrieving data fields and values to C# APIs.
'
'*****************************************************************************/

imports System
imports System.Runtime.InteropServices
imports System.Collections.Generic
imports System.Linq
imports System.Runtime.Serialization.Json
imports System.IO
imports System.Text

imports CDF

public class QstReadCDFvb
       Inherits CDFAPIs 

 Public Shared Sub Main() 
  Dim id As Long  = 0
  Dim status As Integer
  Dim dataType As Integer
  Dim args() As String = Environment.GetCommandLineArgs()
  Dim cdf As Dictionary(Of string, object)
  Try
Console.WriteLine("cdf:" + args(1))
   status = CDFopen(args(1),id)
   cdf = ReadCDF(id)
   For Each pair As KeyValuePair(Of string, object) In cdf
    ' Console.WriteLine("key="+pair.Key)
    '  May contain 3 key/value pairs: keys include "CDFinfo",
    '  "GlobalAttributes" and "Variables".
    ' 
    '  Get key: "Variables"'s value -- a Dictionary
    If [String].Compare(pair.Key,"Variables") = 0 Then
	Dim vars As Dictionary(Of string, object)
	Console.WriteLine("Variables:")
        vars = pair.Value
        If vars Is Nothing Then
		Continue For
	End If
        For Each pair1 As KeyValuePair(Of string, object) In vars
        ' Each key-value pair is variable name and its info
            Console.WriteLine(" ** Variable: "+pair1.Key)
	    Dim varx As Dictionary(Of string, object)
            varx = pair1.Value
            ' Each variable's info includes upto 3 key/value mappings:
            ' "VarInfo", "VarMetaData" and "VarData".
            For Each pair2 As KeyValuePair(Of string, object) In varx
                If [String].Compare(pair2.Key,"VarInfo") = 0 Then
		    Console.WriteLine("  ===> VarInfo:")
                    ' Key: "VarInfo" has Variable specification
		    Dim specs As Dictionary(Of string, object)
                    specs = pair2.Value
                    For Each pair3 As KeyValuePair(Of string, object) In specs
                        'Console.WriteLine(pair3.Key+" => "+pair3.Value)
			If [String].Compare(pair3.Key, "datatype", true) = 0 Then
                          dataType = pair3.Value
			End If
                        Console.Write("    "+pair3.Key+" => ")
			CDFUtils.PrintValue(pair3.Value)
		    Next
                ElseIf [String].Compare(pair2.Key,"VarMetaData") = 0 Then
		    Console.WriteLine("  ===> VarMetaData:")
                    ' Key: "VarMeataData" has variable metadata
		    Dim meta As Dictionary(Of string, object)
                    meta = pair2.Value
                    For Each pair3 As KeyValuePair(Of string, object) In meta
                        'Console.WriteLine(pair3.Key+" => "+pair3.Value)
                        Console.Write("    "+pair3.Key+" => ")
			CDFUtils.PrintValue(pair3.Value)
		    Next
                ElseIf [String].Compare(pair2.Key,"VarData") = 0 Then
		    Console.WriteLine("  ===> VarData:")
                    ' Key: "VarData" has variable data
                    Dim data As Object = pair2.Value
		    If (dataType = CDF_EPOCH)
                      CDFUtils.PrintValue(toEncodeEPOCH(data))
                    Else If (dataType = CDF_TIME_TT2000)
                      CDFUtils.PrintValue(toEncodeTT2000(data))
                    Else If (dataType = CDF_EPOCH16)
                      CDFUtils.PrintValue(toEncodeEPOCH16(data))
                    Else
                      CDFUtils.PrintValue(data)
		    End If
                Else
                    Console.WriteLine("error.... for key: "+pair2.Key)
	        End If
	    Next
        Next
    ElseIf [String].Compare(pair.Key,"CDFInfo") = 0 Then
	Console.WriteLine("CDFInfo:")
	Dim info As Dictionary(Of string, object)
        info = pair.Value
        If info Is Nothing Then
	   Continue For
	End If
        For Each pair1 As KeyValuePair(Of string, object) In info
           ' Each key-value pair is variable name and its info
           Console.Write("    "+pair1.Key+" => ")
	   CDFUtils.PrintValue(pair1.Value)
        Next
    ElseIf [String].Compare(pair.Key,"GlobalAttributes") = 0 Then
	Console.WriteLine("GlobalAttributes:")
	Dim attrs As Dictionary(Of string, object)
        attrs = pair.Value
        If attrs Is Nothing Then
	   Continue For
	End If
        For Each pair1 As KeyValuePair(Of string, object) In attrs
        ' Each key-value pair is global attribute name and its entries
            Console.WriteLine(" ** Attribute: "+pair1.Key)
	    Dim vary As Dictionary(Of integer, object)
            vary = pair1.Value
            For Each pair2 As KeyValuePair(Of integer, object) In vary
               Console.Write("    "+pair2.Key+" => ")
	       CDFUtils.PrintValue(pair2.Value)
            Next
        Next
    ElseIf [String].Compare(pair.Key,"NoEntryAttributes") = 0 Then
	Console.WriteLine("NoEntryAttributes:")
	Dim attrs As Dictionary(Of string, object)
        attrs = pair.Value
        If attrs Is Nothing Then
	   Continue For
	End If
        For Each pair1 As KeyValuePair(Of string, object) In attrs
        ' Each key-value pair is a global attributes or variable attributes
	    Console.WriteLine("  ===> "+pair1.Key+":")
	    Dim noattrs As List(Of string)
            noattrs = pair1.Value
	    Console.Write("        ")
	    Dim yy As Integer
	    yy = 0
            For Each name As string In noattrs
	       yy = yy + 1
	       If yy > 1 Then Console.Write(", ")
               Console.Write(name)
       	    Next
	    Console.WriteLine("")
        Next
    End If
   Next

   status = CDFcloseCDF(id)

  '
  ' Successful completion.
  '
  Catch ex As CDFException
   Console.WriteLine("Error... " + ex.ToString())
  Finally
   Try
    status = CDFselect(id)
    status = CDFcloseCDF(id)
   Catch ex As CDFException
   End Try
  End Try

 End Sub


'
' QuitCDF.
'

 Private Shared Sub QuitCDF(where As string, status As Integer, id As Long)

  Dim text As string
  Console.WriteLine("Aborting at " + where)
  If status < 0 Then
    status = CDFgetStatusText(status,text) 
    Console.WriteLine(" " + text)
  End If
  status = CDFcloseCDF(id)
  Console.WriteLine("...test aborted.")
 End Sub

End Class

