/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.PrintWriter;
import java.lang.reflect.Array;

public class GetMyCDFData
implements CDFConstants {
    private Variable _myVar;
    private Object _data;
    private Object _dataArray;
    private long id;
    private long numValues;
    private long numElements;
    private String dataSignature;
    private long dataType;
    private int nDims = 0;
    private int[] dimSizes;
    private long recStart;
    private long recCount;
    private long recInterval;
    private long[] dimIndices;
    private long[] dimCounts;
    private long[] dimIntervals;
    private static final String CDATA_BEGIN = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String[] special1 = new String[]{"<"};
    private static final String[] special2 = new String[]{"&lt;"};
    private static final String[] special3 = new String[]{"&", "<", ">", "\"", "'"};
    private static final String[] special4 = new String[]{"&amp;", "&lt;", "&gt;", "&quot;", "&apos;"};

    public long[] getDimIndices() {
        return this.dimIndices;
    }

    public static boolean checkStringData(Object object) {
        boolean bl = false;
        String string = CDFUtils.getSignature((Object)object);
        if (string.charAt(0) == '[') {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = Array.get(object, i);
                if (CDFUtils.getSignature((Object)object2).charAt(0) == '[') {
                    bl = GetMyCDFData.checkStringData(object2);
                    if (!bl) continue;
                    return true;
                }
                boolean bl2 = bl = ((String)object2).indexOf("<") > -1;
                if (!bl) continue;
                return bl;
            }
            return bl;
        }
        bl = ((String)object).indexOf("<") > -1;
        return bl;
    }

    public static Object replaceStringDataToXML(Object object) {
        boolean bl = false;
        String string = CDFUtils.getSignature((Object)object);
        if (string.charAt(0) == '[') {
            int n = Array.getLength(object);
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((String[])object)[i];
                for (int j = 0; j < Array.getLength(special3); ++j) {
                    if (stringArray[i].indexOf(special4[i]) != -1) continue;
                    stringArray[i] = stringArray[i].replaceAll(special3[j], special4[j]);
                }
            }
            return stringArray;
        }
        String string2 = (String)object;
        for (int i = 0; i < Array.getLength(special3); ++i) {
            if (string2.indexOf(special4[i]) != -1) continue;
            string2 = string2.replaceAll(special3[i], special4[i]);
        }
        return string2;
    }

    public static Object replaceStringNameToXML(Object object) {
        boolean bl = false;
        String string = CDFUtils.getSignature((Object)object);
        if (string.charAt(0) == '[') {
            int n = Array.getLength(object);
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((String[])object)[i];
                for (int j = 0; j < Array.getLength(special3); ++j) {
                    if (stringArray[i].indexOf(special4[i]) != -1) continue;
                    stringArray[i] = stringArray[i].replaceAll(special3[j], special4[j]);
                }
            }
            return stringArray;
        }
        String string2 = (String)object;
        for (int i = 0; i < Array.getLength(special3); ++i) {
            if (string2.indexOf(special4[i]) != -1) continue;
            string2 = string2.replaceAll(special3[i], special4[i]);
        }
        return string2;
    }

    public static Object replaceFromXMLStringData(Object object) {
        boolean bl = false;
        String string = CDFUtils.getSignature((Object)object);
        if (string.charAt(0) == '[') {
            int n = Array.getLength(object);
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((String[])object)[i];
                for (int j = 0; j < Array.getLength(special3); ++j) {
                    stringArray[i] = stringArray[i].replaceAll(special4[j], special3[j]);
                }
            }
            return stringArray;
        }
        String string2 = (String)object;
        for (int i = 0; i < Array.getLength(special3); ++i) {
            string2 = string2.replaceAll(special4[i], special3[i]);
        }
        return string2;
    }

    public static Object replaceFromXMLStringName(Object object) {
        boolean bl = false;
        String string = CDFUtils.getSignature((Object)object);
        if (string.charAt(0) == '[') {
            int n = Array.getLength(object);
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((String[])object)[i];
                for (int j = 0; j < Array.getLength(special3); ++j) {
                    stringArray[i] = stringArray[i].replaceAll(special4[j], special3[j]);
                }
            }
            return stringArray;
        }
        String string2 = (String)object;
        for (int i = 0; i < Array.getLength(special3); ++i) {
            string2 = string2.replaceAll(special4[i], special3[i]);
        }
        return string2;
    }

    public static String getDataTypeElement(long l) {
        if (l == 31L || l == 32L || l == 33L) {
            return "dateTime";
        }
        if (l == 51L || l == 52L) {
            return "string";
        }
        if (l == 21L || l == 44L) {
            return "float";
        }
        if (l == 22L || l == 45L) {
            return "double";
        }
        if (l == 1L) {
            return "byte";
        }
        if (l == 11L) {
            return "unsignedByte";
        }
        if (l == 2L) {
            return "short";
        }
        if (l == 12L) {
            return "unsignedShort";
        }
        if (l == 4L) {
            return "int";
        }
        if (l == 14L) {
            return "unsignedInt";
        }
        if (l == 8L) {
            return "long";
        }
        return "unknown";
    }

    public static long xsdTypeToCDFType(String string) {
        if (string == null) {
            return -1L;
        }
        String string2 = string.toLowerCase();
        if (string2.equals("datetime")) {
            return 100L;
        }
        if (string2.equals("string")) {
            return 51L;
        }
        if (string2.equals("float")) {
            return 44L;
        }
        if (string2.equals("double")) {
            return 45L;
        }
        if (string2.equals("byte")) {
            return 1L;
        }
        if (string2.equals("unsignedbyte")) {
            return 11L;
        }
        if (string2.equals("short")) {
            return 2L;
        }
        if (string2.equals("unsignedshort")) {
            return 12L;
        }
        if (string2.equals("int")) {
            return 4L;
        }
        if (string2.equals("unsignedint")) {
            return 14L;
        }
        if (string2.equals("long")) {
            return 8L;
        }
        return -1L;
    }

    private GetMyCDFData(Object object, long l, long l2, long[] lArray, long l3) {
        this._dataArray = object;
        this.dataType = l;
        this.numElements = l3;
        this.dimSizes = new int[(int)l2];
        this.nDims = 0;
        int n = 0;
        while ((long)n < l2) {
            if (lArray[n] > 1L) {
                this.dimSizes[this.nDims++] = (int)lArray[n];
            }
            ++n;
        }
    }

    public int getDims() {
        return this.nDims;
    }

    public static GetMyCDFData create(Object object, long l, long l2, long[] lArray, long l3) {
        GetMyCDFData getMyCDFData = new GetMyCDFData(object, l, l2, lArray, l3);
        return getMyCDFData;
    }

    private long product(int[] nArray, int n, int n2) {
        long l = 1L;
        for (int i = n; i < n2; ++i) {
            if (nArray[i] <= 1) continue;
            l *= (long)nArray[i];
        }
        return l;
    }

    public static void outputIndentation(PrintWriter printWriter, int n, String string) {
        for (int i = 0; i < n; ++i) {
            printWriter.print(string);
        }
    }

    public void dumpData(PrintWriter printWriter, String string, String string2, String string3, boolean bl, int n, String string4, boolean bl2, boolean bl3) {
        this.dumpData(printWriter, string, string2, string3, bl, n, string4, bl2, bl3, true);
    }

    public void dumpData(PrintWriter printWriter, String string, String string2, String string3, boolean bl, int n, String string4, boolean bl2, boolean bl3, boolean bl4) {
        ++n;
        boolean bl5 = false;
        if ((this.dataType == 51L || this.dataType == 52L) && bl4) {
            bl5 = GetMyCDFData.checkStringData(this._dataArray);
        }
        GetMyCDFData.outputIndentation(printWriter, n, string4);
        if (this.nDims <= 1) {
            printWriter.print(string);
            if (this.nDims == 0) {
                if (this.dataType == 31L) {
                    if (!this._dataArray.getClass().isArray()) {
                        Double d = (Double)this._dataArray;
                        printWriter.print(!bl2 ? Epoch.encode((double)d) : Epoch.encode4((double)d) + (bl3 ? "Z" : ""));
                    } else {
                        double d = ((double[])this._dataArray)[0];
                        printWriter.print(!bl2 ? Epoch.encode((double)d) : Epoch.encode4((double)d) + (bl3 ? "Z" : ""));
                    }
                } else if (this.dataType == 32L) {
                    double[] dArray = (double[])this._dataArray;
                    printWriter.print(!bl2 ? Epoch16.encode((Object)dArray) : Epoch16.encode4((Object)dArray) + (bl3 ? "Z" : ""));
                } else if (this.dataType == 33L) {
                    if (!this._dataArray.getClass().isArray()) {
                        Long l = (Long)this._dataArray;
                        printWriter.print(CDFTT2000.encode((long)l) + (bl3 ? "Z" : ""));
                    } else {
                        long l = ((long[])this._dataArray)[0];
                        printWriter.print(CDFTT2000.encode((long)l) + (bl3 ? "Z" : ""));
                    }
                } else if (bl5) {
                    printWriter.print(CDATA_BEGIN);
                    if (!this._dataArray.getClass().isArray()) {
                        printWriter.print(this._dataArray.toString());
                    } else {
                        Object object = Array.get(this._dataArray, 0);
                        printWriter.print(object.toString());
                    }
                    printWriter.print(CDATA_END);
                } else if (!this._dataArray.getClass().isArray()) {
                    if (this.dataType != 51L && this.dataType != 52L) {
                        printWriter.print(this._dataArray);
                    } else {
                        printWriter.print(GetMyCDFData.replaceStringDataToXML(this._dataArray));
                    }
                } else {
                    Object object = Array.get(this._dataArray, 0);
                    if (this.dataType != 51L && this.dataType != 52L) {
                        printWriter.println(object);
                    } else {
                        printWriter.println(GetMyCDFData.replaceStringDataToXML(object));
                    }
                }
            } else {
                if (this.dataType == 51L || this.dataType == 52L) {
                    printWriter.println("");
                }
                switch ((int)this.dataType) {
                    case 51: 
                    case 52: {
                        ++n;
                        int n2 = this.dimSizes[this.nDims - 1];
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (n != -99) {
                                GetMyCDFData.outputIndentation(printWriter, n, string4);
                            }
                            if (bl) {
                                printWriter.print("<element index=\"" + i + "\">");
                            } else {
                                printWriter.print(string3);
                            }
                            if (bl5) {
                                printWriter.print(CDATA_BEGIN);
                                printWriter.print(((String[])this._dataArray)[i]);
                                printWriter.print(CDATA_END);
                            } else {
                                printWriter.print(GetMyCDFData.replaceStringDataToXML(((String[])this._dataArray)[i]));
                            }
                            if (bl) {
                                printWriter.print("</element>");
                            } else {
                                printWriter.print(string3);
                            }
                            if (i == n2) continue;
                            printWriter.println("");
                        }
                        if (--n == -99) break;
                        GetMyCDFData.outputIndentation(printWriter, n, string4);
                        break;
                    }
                    case 1: 
                    case 41: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                printWriter.print(string3);
                            }
                            printWriter.print(((byte[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                printWriter.print(string3);
                            }
                            printWriter.print(((short[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 11: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                printWriter.print(string3);
                            }
                            if (((short[])this._dataArray)[i] >= 0) {
                                printWriter.print(((short[])this._dataArray)[i]);
                                continue;
                            }
                            short s = (short)(((short[])this._dataArray)[i] + 256);
                            printWriter.print(s);
                        }
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                printWriter.print(string3);
                            }
                            printWriter.print(((int[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 12: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                printWriter.print(string3);
                            }
                            if (((int[])this._dataArray)[i] >= 0) {
                                printWriter.print(((int[])this._dataArray)[i]);
                                continue;
                            }
                            int n3 = ((int[])this._dataArray)[i] + 65536;
                            printWriter.print(n3);
                        }
                        break;
                    }
                    case 14: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                printWriter.print(string3);
                            }
                            if (((long[])this._dataArray)[i] >= 0L) {
                                printWriter.print(((long[])this._dataArray)[i]);
                                continue;
                            }
                            long l = ((long[])this._dataArray)[i] + 0x100000000L;
                            printWriter.print(l);
                        }
                        break;
                    }
                    case 8: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                printWriter.print(string3);
                            }
                            printWriter.print(((long[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 21: 
                    case 44: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                printWriter.print(string3);
                            }
                            printWriter.print(((float[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 22: 
                    case 45: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                printWriter.print(string3);
                            }
                            printWriter.print(((double[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 31: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                printWriter.print(string3);
                            }
                            printWriter.print(!bl2 ? Epoch.encode((double)((double[])this._dataArray)[i]) : Epoch.encode4((double)((double[])this._dataArray)[i]) + (bl3 ? "Z" : ""));
                        }
                        break;
                    }
                    case 32: {
                        double[] dArray = new double[2];
                        int n4 = 0;
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                printWriter.print(string3);
                            }
                            dArray[0] = ((double[])this._dataArray)[n4++];
                            dArray[1] = ((double[])this._dataArray)[n4++];
                            printWriter.print(!bl2 ? Epoch16.encode((Object)dArray) : Epoch16.encode4((Object)dArray) + (bl3 ? "Z" : ""));
                        }
                        break;
                    }
                    case 33: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                printWriter.print(string3);
                            }
                            printWriter.print(CDFTT2000.encode((long)((long[])this._dataArray)[i]) + (bl3 ? "Z" : ""));
                        }
                        break;
                    }
                }
                if (this.dataType == 51L || this.dataType == 52L) {
                    // empty if block
                }
            }
            printWriter.println(string2);
        } else {
            int n5;
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[this.nDims - 1];
            int[] nArray = new int[this.nDims - 1];
            long[] lArray = new long[this.nDims - 1];
            int n6 = 0;
            objectArray2[0] = this._dataArray;
            nArray[0] = 0;
            lArray[0] = this.product(this.dimSizes, 0, this.nDims);
            for (n5 = 1; n5 < this.nDims - 1; ++n5) {
                objectArray2[n5] = Array.get(objectArray2[n5 - 1], 0);
                lArray[n5] = this.product(this.dimSizes, n5, this.nDims);
                nArray[n5] = 0;
            }
            n5 = 0;
            Object object = this._dataArray;
            printWriter.print(string);
            if (this.dataType == 51L || this.dataType == 52L) {
                if (bl) {
                    printWriter.println("");
                } else if (bl5) {
                    printWriter.println(CDATA_BEGIN);
                }
            }
            while ((long)n5 < lArray[0]) {
                int n7;
                int n8;
                if (n5 != 0) {
                    ++n6;
                    if (this.dataType != 51L && this.dataType != 52L) {
                        printWriter.print(string3);
                    }
                    for (n8 = 0; n8 < this.nDims - 1; ++n8) {
                        boolean bl6;
                        boolean bl7 = bl6 = (long)n5 % lArray[n8] == 0L;
                        if (bl6) {
                            int n9 = n8;
                            nArray[n9] = nArray[n9] + 1;
                            objectArray2[n8] = object = Array.get(object, nArray[n8]);
                            for (n7 = n8 + 1; n7 < this.nDims - 1; ++n7) {
                                nArray[n7] = 0;
                                objectArray2[n7] = Array.get(objectArray2[n7 - 1], nArray[n7]);
                            }
                            break;
                        }
                        object = objectArray2[n8];
                    }
                }
                for (n8 = 0; n8 < this.dimSizes[this.nDims - 2]; ++n8) {
                    if (n8 > 0) {
                        if (this.dataType == 51L || this.dataType == 52L) {
                            --n;
                        } else {
                            printWriter.print(string3);
                        }
                    }
                    switch ((int)this.dataType) {
                        case 51: 
                        case 52: {
                            objectArray = (String[])Array.get(objectArray2[this.nDims - 2], n8);
                            ++n;
                            for (n7 = 0; n7 < this.dimSizes[this.nDims - 1]; ++n7) {
                                if (n != -99) {
                                    GetMyCDFData.outputIndentation(printWriter, n, string4);
                                }
                                if (bl) {
                                    if (this.nDims == 2) {
                                        printWriter.print("<element index=\"" + n8 + "," + n7 + "\">");
                                    } else {
                                        printWriter.print("<element index=\"" + n6 + "," + n8 + "," + n7 + "\">");
                                    }
                                } else {
                                    printWriter.print(string3);
                                }
                                if (bl5) {
                                    printWriter.print(CDATA_BEGIN);
                                    printWriter.print(objectArray[n7]);
                                    if (bl5) {
                                        printWriter.print(CDATA_END);
                                    }
                                } else {
                                    printWriter.print(GetMyCDFData.replaceStringDataToXML(objectArray[n7]));
                                }
                                if (bl) {
                                    printWriter.println("</element>");
                                    continue;
                                }
                                printWriter.println(string3);
                            }
                            break;
                        }
                        case 1: 
                        case 41: {
                            objectArray = (byte[])Array.get(objectArray2[this.nDims - 2], n8);
                            for (n7 = 0; n7 < this.dimSizes[this.nDims - 1]; ++n7) {
                                if (n7 > 0) {
                                    printWriter.print(string3);
                                }
                                printWriter.print(((byte[])objectArray)[n7]);
                            }
                            break;
                        }
                        case 2: {
                            objectArray = (short[])Array.get(objectArray2[this.nDims - 2], n8);
                            for (n7 = 0; n7 < this.dimSizes[this.nDims - 1]; ++n7) {
                                if (n7 > 0) {
                                    printWriter.print(string3);
                                }
                                printWriter.print(((short[])objectArray)[n7]);
                            }
                            break;
                        }
                        case 11: {
                            objectArray = (short[])Array.get(objectArray2[this.nDims - 2], n8);
                            for (n7 = 0; n7 < this.dimSizes[this.nDims - 1]; ++n7) {
                                if (n7 > 0) {
                                    printWriter.print(string3);
                                }
                                if (((short[])objectArray)[n7] >= 0) {
                                    printWriter.print(((short[])objectArray)[n7]);
                                    continue;
                                }
                                short s = (short)(((short[])objectArray)[n7] + 256);
                                printWriter.print(s);
                            }
                            break;
                        }
                        case 4: {
                            objectArray = (int[])Array.get(objectArray2[this.nDims - 2], n8);
                            for (n7 = 0; n7 < this.dimSizes[this.nDims - 1]; ++n7) {
                                if (n7 > 0) {
                                    printWriter.print(string3);
                                }
                                printWriter.print(((int[])objectArray)[n7]);
                            }
                            break;
                        }
                        case 12: {
                            objectArray = (int[])Array.get(objectArray2[this.nDims - 2], n8);
                            for (n7 = 0; n7 < this.dimSizes[this.nDims - 1]; ++n7) {
                                if (n7 > 0) {
                                    printWriter.print(string3);
                                }
                                if (((int[])objectArray)[n7] >= 0) {
                                    printWriter.print(((int[])objectArray)[n7]);
                                    continue;
                                }
                                int n10 = ((int[])objectArray)[n7] + 65536;
                                printWriter.print(n10);
                            }
                            break;
                        }
                        case 14: {
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n8);
                            for (n7 = 0; n7 < this.dimSizes[this.nDims - 1]; ++n7) {
                                if (n7 > 0) {
                                    printWriter.print(string3);
                                }
                                if (((long[])objectArray)[n7] >= 0L) {
                                    printWriter.print(((long[])objectArray)[n7]);
                                    continue;
                                }
                                long l = ((long[])objectArray)[n7] + 0x100000000L;
                                printWriter.print(l);
                            }
                            break;
                        }
                        case 8: {
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n8);
                            for (n7 = 0; n7 < this.dimSizes[this.nDims - 1]; ++n7) {
                                if (n7 > 0) {
                                    printWriter.print(string3);
                                }
                                printWriter.print(((long[])objectArray)[n7]);
                            }
                            break;
                        }
                        case 21: 
                        case 44: {
                            objectArray = (float[])Array.get(objectArray2[this.nDims - 2], n8);
                            for (n7 = 0; n7 < this.dimSizes[this.nDims - 1]; ++n7) {
                                if (n7 > 0) {
                                    printWriter.print(string3);
                                }
                                printWriter.print(((float[])objectArray)[n7]);
                            }
                            break;
                        }
                        case 22: 
                        case 45: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n8);
                            for (n7 = 0; n7 < this.dimSizes[this.nDims - 1]; ++n7) {
                                if (n7 > 0) {
                                    printWriter.print(string3);
                                }
                                printWriter.print(((double[])objectArray)[n7]);
                            }
                            break;
                        }
                        case 31: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n8);
                            for (n7 = 0; n7 < this.dimSizes[this.nDims - 1]; ++n7) {
                                if (n7 > 0) {
                                    printWriter.print(string3);
                                }
                                printWriter.print(!bl2 ? Epoch.encode((double)((double[])objectArray)[n7]) : Epoch.encode4((double)((double[])objectArray)[n7]) + (bl3 ? "Z" : ""));
                            }
                            break;
                        }
                        case 32: {
                            int n11;
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n8);
                            double[] dArray = new double[2];
                            int n12 = 0;
                            for (n11 = 0; n11 < this.dimSizes[this.nDims - 1]; ++n11) {
                                if (n11 > 0) {
                                    printWriter.print(string3);
                                }
                                dArray[0] = ((double[])objectArray)[n12++];
                                dArray[1] = ((double[])objectArray)[n12++];
                                printWriter.print(!bl2 ? Epoch16.encode((Object)dArray) : Epoch16.encode4((Object)dArray) + (bl3 ? "Z" : ""));
                            }
                            break;
                        }
                        case 33: {
                            int n11;
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n8);
                            for (n11 = 0; n11 < this.dimSizes[this.nDims - 1]; ++n11) {
                                if (n11 > 0) {
                                    printWriter.print(string3);
                                }
                                printWriter.print(CDFTT2000.encode((long)((long[])objectArray)[n11]) + (bl3 ? "Z" : ""));
                            }
                            break;
                        }
                    }
                    n5 += this.dimSizes[this.nDims - 1];
                }
                if (this.dataType != 51L && this.dataType != 52L) continue;
                --n;
            }
            if (this.dataType == 51L || this.dataType == 52L) {
                GetMyCDFData.outputIndentation(printWriter, n, string4);
                if (!bl && bl5) {
                    printWriter.print(CDATA_END);
                }
            }
            printWriter.println(string2);
        }
    }

    public void dumpData2(PrintWriter printWriter, long l, String string, String string2, int n, String string3, boolean bl) {
        this.dumpData2(printWriter, l, string, string2, n, string3, bl, true);
    }

    public void dumpData2(PrintWriter printWriter, long l, String string, String string2, int n, String string3, boolean bl, boolean bl2) {
        String string4 = GetMyCDFData.getDataTypeElement(l);
        ++n;
        if (this.nDims <= 1) {
            if (this.nDims == 0) {
                if (l == 31L) {
                    if (!this._dataArray.getClass().isArray()) {
                        Double d = (Double)this._dataArray;
                        GetMyCDFData.outputIndentation(printWriter, n, string3);
                        String string5 = Epoch.encode4((double)d);
                        String string6 = new StringBuffer(string5).append(bl ? "Z" : "").toString();
                        printWriter.println(string + string4 + "\">" + string6 + string2);
                    } else {
                        double d = ((double[])this._dataArray)[0];
                        GetMyCDFData.outputIndentation(printWriter, n, string3);
                        String string7 = Epoch.encode4((double)d);
                        String string8 = new StringBuffer(string7).append(bl ? "Z" : "").toString();
                        printWriter.println(string + string4 + "\">" + string8 + string2);
                    }
                } else if (l == 32L) {
                    double[] dArray = (double[])this._dataArray;
                    GetMyCDFData.outputIndentation(printWriter, n, string3);
                    String string9 = Epoch16.encode4((Object)dArray);
                    String string10 = new StringBuffer(string9).append(bl ? "Z" : "").toString();
                    printWriter.println(string + string4 + "\">" + string10 + string2);
                } else if (l == 33L) {
                    if (!this._dataArray.getClass().isArray()) {
                        Long l2 = (Long)this._dataArray;
                        GetMyCDFData.outputIndentation(printWriter, n, string3);
                        String string11 = CDFTT2000.encode((long)l2);
                        String string12 = new StringBuffer(string11).append(bl ? "Z" : "").toString();
                        printWriter.println(string + string4 + "\">" + string12 + string2);
                    } else {
                        long l3 = ((long[])this._dataArray)[0];
                        GetMyCDFData.outputIndentation(printWriter, n, string3);
                        String string13 = CDFTT2000.encode((long)l3);
                        String string14 = new StringBuffer(string13).append(bl ? "Z" : "").toString();
                        printWriter.println(string + string4 + "\">" + string14 + string2);
                    }
                } else {
                    GetMyCDFData.outputIndentation(printWriter, n, string3);
                    if (!this._dataArray.getClass().isArray()) {
                        if (l != 51L && l != 52L) {
                            printWriter.println(string + string4 + "\">" + this._dataArray + string2);
                        } else {
                            printWriter.println(string + string4 + "\">" + GetMyCDFData.replaceStringDataToXML(this._dataArray) + string2);
                        }
                    } else {
                        Object object = Array.get(this._dataArray, 0);
                        if (l != 51L && l != 52L) {
                            printWriter.println(string + string4 + "\">" + object + string2);
                        } else {
                            printWriter.println(string + string4 + "\">" + GetMyCDFData.replaceStringDataToXML(object) + string2);
                        }
                    }
                }
            } else {
                GetMyCDFData.outputIndentation(printWriter, n, string3);
                printWriter.println("<array>");
                switch ((int)l) {
                    case 51: 
                    case 52: {
                        int n2 = this.dimSizes[this.nDims - 1];
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (n != -99) {
                                GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                            }
                            Object object = GetMyCDFData.replaceStringDataToXML(((String[])this._dataArray)[i]);
                            printWriter.println(string + string4 + "\">" + object + string2);
                        }
                        break;
                    }
                    case 1: 
                    case 41: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                            byte by = ((byte[])this._dataArray)[i];
                            printWriter.println(string + string4 + "\">" + by + string2);
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                            short s = ((short[])this._dataArray)[i];
                            printWriter.println(string + string4 + "\">" + s + string2);
                        }
                        break;
                    }
                    case 11: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                            short s = ((short[])this._dataArray)[i] >= 0 ? ((short[])this._dataArray)[i] : (short)(((short[])this._dataArray)[i] + 256);
                            printWriter.println(string + string4 + "\">" + s + string2);
                        }
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                            int n3 = ((int[])this._dataArray)[i];
                            printWriter.println(string + string4 + "\">" + n3 + string2);
                        }
                        break;
                    }
                    case 12: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                            int n4 = ((int[])this._dataArray)[i] >= 0 ? ((int[])this._dataArray)[i] : ((int[])this._dataArray)[i] + 65536;
                            printWriter.println(string + string4 + "\">" + n4 + string2);
                        }
                        break;
                    }
                    case 14: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                            long l4 = ((long[])this._dataArray)[i] >= 0L ? ((long[])this._dataArray)[i] : ((long[])this._dataArray)[i] + 0x100000000L;
                            printWriter.println(string + string4 + "\">" + l4 + string2);
                        }
                        break;
                    }
                    case 8: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                            long l5 = ((long[])this._dataArray)[i];
                            printWriter.println(string + string4 + "\">" + l5 + string2);
                        }
                        break;
                    }
                    case 21: 
                    case 44: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                            float f = ((float[])this._dataArray)[i];
                            printWriter.println(string + string4 + "\">" + f + string2);
                        }
                        break;
                    }
                    case 22: 
                    case 45: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                            double d = ((double[])this._dataArray)[i];
                            printWriter.println(string + string4 + "\">" + d + string2);
                        }
                        break;
                    }
                    case 31: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                            String string15 = Epoch.encode4((double)((double[])this._dataArray)[i]);
                            String string16 = new StringBuffer(string15).append(bl ? "Z" : "").toString();
                            printWriter.println(string + string4 + "\">" + string16 + string2);
                        }
                        break;
                    }
                    case 32: {
                        double[] dArray = new double[2];
                        int n5 = 0;
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            dArray[0] = ((double[])this._dataArray)[n5++];
                            dArray[1] = ((double[])this._dataArray)[n5++];
                            GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                            String string17 = Epoch16.encode4((Object)dArray);
                            String string18 = new StringBuffer(string17).append(bl ? "Z" : "").toString();
                            printWriter.println(string + string4 + "\">" + string18 + string2);
                        }
                        break;
                    }
                    case 33: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                            String string19 = CDFTT2000.encode((long)((long[])this._dataArray)[i]);
                            String string20 = new StringBuffer(string19).append(bl ? "Z" : "").toString();
                            printWriter.println(string + string4 + "\">" + string20 + string2);
                        }
                        break;
                    }
                }
            }
            if (this.nDims > 0) {
                GetMyCDFData.outputIndentation(printWriter, n, string3);
                printWriter.println("</array>");
            }
        } else {
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[this.nDims - 1];
            int[] nArray = new int[this.nDims - 1];
            long[] lArray = new long[this.nDims - 1];
            int n6 = 0;
            int n7 = 0;
            objectArray2[0] = this._dataArray;
            nArray[0] = 0;
            lArray[0] = this.product(this.dimSizes, 0, this.nDims);
            for (int i = 1; i < this.nDims - 1; ++i) {
                objectArray2[i] = Array.get(objectArray2[i - 1], 0);
                lArray[i] = this.product(this.dimSizes, i, this.nDims);
                nArray[i] = 0;
            }
            String string21 = this._dataArray.getClass().getName();
            int n8 = 0;
            Object object = this._dataArray;
            int n9 = 0;
            boolean bl3 = true;
            while ((long)n8 < lArray[0]) {
                int n10;
                int n11;
                if (n8 != 0) {
                    ++n6;
                    for (n11 = 0; n11 < this.nDims - 1; ++n11) {
                        boolean bl4;
                        boolean bl5 = bl4 = (long)n8 % lArray[n11] == 0L;
                        if (bl4) {
                            int n12 = n11;
                            nArray[n12] = nArray[n12] + 1;
                            objectArray2[n11] = object = Array.get(object, nArray[n11]);
                            for (n10 = n11 + 1; n10 < this.nDims - 1; ++n10) {
                                nArray[n10] = 0;
                                objectArray2[n10] = Array.get(objectArray2[n10 - 1], nArray[n10]);
                            }
                            break;
                        }
                        object = objectArray2[n11];
                    }
                }
                if (this.nDims > 2) {
                    n9 = this.nDims - 1;
                    if (bl3) {
                        for (n6 = 0; n6 < n9; ++n6) {
                            GetMyCDFData.outputIndentation(printWriter, n + n6, string3);
                            printWriter.println("<array>");
                        }
                        bl3 = false;
                        n7 = n = n + n9 - 1;
                    } else {
                        n = n7;
                        GetMyCDFData.outputIndentation(printWriter, n, string3);
                        printWriter.println("<array>");
                    }
                } else {
                    GetMyCDFData.outputIndentation(printWriter, n, string3);
                    printWriter.println("<array>");
                }
                for (n11 = 0; n11 < this.dimSizes[this.nDims - 2]; ++n11) {
                    GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                    printWriter.println("<array>");
                    if (n11 > 0 && (l == 51L || l == 52L)) {
                        --n;
                    }
                    switch ((int)l) {
                        case 51: 
                        case 52: {
                            objectArray = (String[])Array.get(objectArray2[this.nDims - 2], n11);
                            ++n;
                            for (n10 = 0; n10 < this.dimSizes[this.nDims - 1]; ++n10) {
                                if (n != -99) {
                                    GetMyCDFData.outputIndentation(printWriter, n + 2, string3);
                                }
                                Object object2 = GetMyCDFData.replaceStringDataToXML(objectArray[n10]);
                                printWriter.println(string + string4 + "\">" + object2 + string2);
                            }
                            break;
                        }
                        case 1: 
                        case 41: {
                            objectArray = (byte[])Array.get(objectArray2[this.nDims - 2], n11);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                GetMyCDFData.outputIndentation(printWriter, n + 2, string3);
                                n10 = ((byte[])objectArray)[i];
                                printWriter.println(string + string4 + "\">" + n10 + string2);
                            }
                            break;
                        }
                        case 2: {
                            objectArray = (short[])Array.get(objectArray2[this.nDims - 2], n11);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                GetMyCDFData.outputIndentation(printWriter, n + 2, string3);
                                n10 = ((short[])objectArray)[i];
                                printWriter.println(string + string4 + "\">" + n10 + string2);
                            }
                            break;
                        }
                        case 11: {
                            objectArray = (short[])Array.get(objectArray2[this.nDims - 2], n11);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                GetMyCDFData.outputIndentation(printWriter, n + 2, string3);
                                n10 = ((short[])objectArray)[i] >= 0 ? ((short[])objectArray)[i] : (int)((short)(((short[])objectArray)[i] + 256));
                                printWriter.println(string + string4 + "\">" + n10 + string2);
                            }
                            break;
                        }
                        case 4: {
                            objectArray = (int[])Array.get(objectArray2[this.nDims - 2], n11);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                GetMyCDFData.outputIndentation(printWriter, n + 2, string3);
                                n10 = ((int[])objectArray)[i];
                                printWriter.println(string + string4 + "\">" + n10 + string2);
                            }
                            break;
                        }
                        case 12: {
                            objectArray = (int[])Array.get(objectArray2[this.nDims - 2], n11);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                GetMyCDFData.outputIndentation(printWriter, n + 2, string3);
                                n10 = ((int[])objectArray)[i] >= 0 ? ((int[])objectArray)[i] : ((int[])objectArray)[i] + 65536;
                                printWriter.println(string + string4 + "\">" + n10 + string2);
                            }
                            break;
                        }
                        case 14: {
                            int n13;
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n11);
                            for (n13 = 0; n13 < this.dimSizes[this.nDims - 1]; ++n13) {
                                GetMyCDFData.outputIndentation(printWriter, n + 2, string3);
                                long l6 = ((long[])objectArray)[n13] >= 0L ? ((long[])objectArray)[n13] : ((long[])objectArray)[n13] + 0x100000000L;
                                printWriter.println(string + string4 + "\">" + l6 + string2);
                            }
                            break;
                        }
                        case 8: {
                            int n13;
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n11);
                            for (n13 = 0; n13 < this.dimSizes[this.nDims - 1]; ++n13) {
                                GetMyCDFData.outputIndentation(printWriter, n + 2, string3);
                                long l7 = ((long[])objectArray)[n13];
                                printWriter.println(string + string4 + "\">" + l7 + string2);
                            }
                            break;
                        }
                        case 21: 
                        case 44: {
                            objectArray = (float[])Array.get(objectArray2[this.nDims - 2], n11);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                GetMyCDFData.outputIndentation(printWriter, n + 2, string3);
                                float f = ((float[])objectArray)[i];
                                printWriter.println(string + string4 + "\">" + f + string2);
                            }
                            break;
                        }
                        case 22: 
                        case 45: {
                            int n13;
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n11);
                            for (n13 = 0; n13 < this.dimSizes[this.nDims - 1]; ++n13) {
                                GetMyCDFData.outputIndentation(printWriter, n + 2, string3);
                                double d = ((double[])objectArray)[n13];
                                printWriter.println(string + string4 + "\">" + d + string2);
                            }
                            break;
                        }
                        case 31: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n11);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                GetMyCDFData.outputIndentation(printWriter, n + 2, string3);
                                String string22 = Epoch.encode4((double)((double[])objectArray)[i]);
                                String string23 = new StringBuffer(string22).append(bl ? "Z" : "").toString();
                                printWriter.println(string + string4 + "\">" + string23 + string2);
                            }
                            break;
                        }
                        case 32: {
                            int n13;
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n11);
                            double[] dArray = new double[2];
                            int n14 = 0;
                            for (n13 = 0; n13 < this.dimSizes[this.nDims - 1]; ++n13) {
                                dArray[0] = ((double[])objectArray)[n14++];
                                dArray[1] = ((double[])objectArray)[n14++];
                                GetMyCDFData.outputIndentation(printWriter, n + 2, string3);
                                String string24 = Epoch16.encode4((Object)dArray);
                                String string25 = new StringBuffer(string24).append(bl ? "Z" : "").toString();
                                printWriter.println(string + string4 + "\">" + string25 + string2);
                            }
                            break;
                        }
                        case 33: {
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n11);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                GetMyCDFData.outputIndentation(printWriter, n + 2, string3);
                                String string26 = CDFTT2000.encode((long)((long[])objectArray)[i]);
                                String string27 = new StringBuffer(string26).append(bl ? "Z" : "").toString();
                                printWriter.println(string + string4 + "\">" + string27 + string2);
                            }
                            break;
                        }
                    }
                    n8 += this.dimSizes[this.nDims - 1];
                    GetMyCDFData.outputIndentation(printWriter, n + 1, string3);
                    printWriter.println("</array>");
                }
                GetMyCDFData.outputIndentation(printWriter, n, string3);
                printWriter.println("</array>");
            }
            n = n - n9 + 1;
            if (n9 > 0) {
                for (n6 = n9 - 1; n6 > 0; --n6) {
                    GetMyCDFData.outputIndentation(printWriter, n + n6 - 1, string3);
                    printWriter.println("</array>");
                }
            }
        }
    }
}

