/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class EditvAttributeTableScrollPane
extends JScrollPane
implements TableModelListener,
CDFConstants {
    private Attribute attr;
    private EditvAttributeTableScrollPane aTableScrollPane = this;
    private MYEditor myEditor;
    private JLabeledDataTable myTable;
    private CDFEdit myCDFEdit;
    private CDF cdf;
    private Vector entries;
    private JTable table;
    private MyTableModel myModel;
    private Object[][] dataObject = null;
    private static String[] headcol = new String[]{"Var Name", "Data Type", "Entry Data"};
    private static String na = "N/A";
    static final long serialVersionUID = 1L;

    EditvAttributeTableScrollPane(AttributePanel attributePanel) {
        super(20, 30);
        this.myEditor = attributePanel.getMyEditor();
        this.cdf = this.myEditor.theCDF;
        this.setVisible(false);
    }

    public void buildTable(Attribute attribute) {
        this.attr = attribute;
        this.table = null;
        this.myModel = null;
        if (attribute != null) {
            this.buildDataTable();
        } else {
            this.aTableScrollPane.setVisible(false);
            this.aTableScrollPane.validate();
        }
        if (this.dataObject != null) {
            this.myModel = new MyTableModel();
            this.table = new JTable(this.myModel);
            this.table.setPreferredScrollableViewportSize(new Dimension(660, 500));
            this.table.setRowSelectionAllowed(false);
            this.table.setAutoResizeMode(4);
            TableColumn tableColumn = null;
            for (int i = 0; i < headcol.length; ++i) {
                tableColumn = this.table.getColumnModel().getColumn(i);
                tableColumn.setResizable(true);
                if (i == 0) {
                    tableColumn.setPreferredWidth(130);
                }
                if (i == 1) {
                    tableColumn.setPreferredWidth(120);
                }
                if (i != 2) continue;
                tableColumn.setPreferredWidth(410);
            }
            this.aTableScrollPane.setVisible(true);
            this.aTableScrollPane.setViewportView(this.table);
            this.aTableScrollPane.revalidate();
        } else {
            this.aTableScrollPane.setVisible(false);
            this.aTableScrollPane.revalidate();
        }
    }

    public void setTable(Object[][] objectArray) {
        this.dataObject = objectArray;
        this.myModel.fireTableDataChanged();
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setColumnNames(String[] stringArray) {
        headcol = stringArray;
    }

    public String[] getColumnNames() {
        return headcol;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    public void setUpDataTypeColumn(TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("CDF_BYTE");
        jComboBox.addItem("CDF_INT1");
        jComboBox.addItem("CDF_UINT1");
        jComboBox.addItem("CDF_INT2");
        jComboBox.addItem("CDF_UINT2");
        jComboBox.addItem("CDF_INT4");
        jComboBox.addItem("CDF_UINT4");
        jComboBox.addItem("CDF_INT8");
        jComboBox.addItem("CDF_REAL4");
        jComboBox.addItem("CDF_FLOAT");
        jComboBox.addItem("CDF_REAL8");
        jComboBox.addItem("CDF_DOUBLE");
        jComboBox.addItem("CDF_EPOCH");
        jComboBox.addItem("CDF_EPOCH16");
        jComboBox.addItem("CDF_TIME_TT2000");
        jComboBox.addItem("CDF_CHAR");
        jComboBox.addItem("CDF_UCHAR");
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText("Click for valid data types");
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Click the dataType to see a list of choices");
        }
    }

    private void buildDataTable() {
        this.dataObject = null;
        int n = (int)this.cdf.getNumVars();
        if (n > 0) {
            int n2 = 0;
            Entry[] entryArray = new Entry[n];
            for (int i = 0; i < n; ++i) {
                try {
                    entryArray[i] = this.attr.getEntry(i);
                    ++n2;
                    continue;
                }
                catch (CDFException cDFException) {
                    entryArray[i] = null;
                }
            }
            if (n2 > 0) {
                this.dataObject = new Object[n2][headcol.length];
                Object object = null;
                int n3 = -1;
                for (int i = 0; i < n; ++i) {
                    if (entryArray[i] == null) continue;
                    try {
                        CharSequence charSequence;
                        String string = this.cdf.getVariable(i).getName();
                        long l = entryArray[i].getDataType();
                        object = entryArray[i].getData();
                        long l2 = entryArray[i].getNumElements();
                        this.dataObject[++n3][0] = string;
                        this.dataObject[n3][1] = CDFUtils.getStringDataType(l) + "/" + l2;
                        if (l == 31L) {
                            if (object.getClass().getName().indexOf(91) == 0) {
                                charSequence = new StringBuffer();
                                for (int j = 0; j < ((double[])object).length; ++j) {
                                    if (j > 0) {
                                        ((StringBuffer)charSequence).append(", ");
                                    }
                                    String string2 = Epoch.encode4(((double[])object)[j]);
                                    ((StringBuffer)charSequence).append(string2);
                                }
                                this.dataObject[n3][2] = ((StringBuffer)charSequence).toString();
                                continue;
                            }
                            this.dataObject[n3][2] = Epoch.encode4((Double)object);
                            continue;
                        }
                        if (l == 32L) {
                            if (object.getClass().getName().indexOf(91) != 0) continue;
                            charSequence = new StringBuffer();
                            double[] dArray = new double[2];
                            for (int j = 0; j < ((double[])object).length; j += 2) {
                                if (j > 0) {
                                    ((StringBuffer)charSequence).append(", ");
                                }
                                dArray[0] = ((double[])object)[j];
                                dArray[1] = ((double[])object)[j + 1];
                                String string3 = Epoch16.encode4(dArray);
                                ((StringBuffer)charSequence).append(string3);
                            }
                            this.dataObject[n3][2] = ((StringBuffer)charSequence).toString();
                            continue;
                        }
                        if (l == 33L) {
                            if (object.getClass().getName().indexOf(91) == 0) {
                                charSequence = new StringBuffer();
                                for (int j = 0; j < ((long[])object).length; ++j) {
                                    if (j > 0) {
                                        ((StringBuffer)charSequence).append(", ");
                                    }
                                    String string4 = CDFTT2000.toUTCstring(((long[])object)[j]);
                                    ((StringBuffer)charSequence).append(string4);
                                }
                                this.dataObject[n3][2] = ((StringBuffer)charSequence).toString();
                                continue;
                            }
                            this.dataObject[n3][2] = CDFTT2000.toUTCstring((long)((Long)object));
                            continue;
                        }
                        if (l == 21L || l == 22L || l == 44L || l == 45L) {
                            try {
                                charSequence = (String)this.cdf.getVariable(string).getEntryData("FORMAT");
                            }
                            catch (CDFException cDFException) {
                                charSequence = null;
                            }
                            this.dataObject[n3][2] = CDFUtils.getStringFloatingData(object, (String)charSequence, ", ").trim();
                            continue;
                        }
                        this.dataObject[n3][2] = CDFUtils.getStringData(object, ", ");
                        continue;
                    }
                    catch (CDFException cDFException) {
                        System.out.println("error..." + cDFException);
                    }
                }
            }
        }
    }

    public void reset() {
        this.dataObject = null;
        this.aTableScrollPane.setVisible(false);
    }

    class MyTableModel
    extends AbstractTableModel {
        static final long serialVersionUID = 1L;

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return headcol.length;
        }

        @Override
        public int getRowCount() {
            if (EditvAttributeTableScrollPane.this.dataObject != null) {
                return EditvAttributeTableScrollPane.this.dataObject.length;
            }
            return 0;
        }

        @Override
        public String getColumnName(int n) {
            return headcol[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (EditvAttributeTableScrollPane.this.dataObject != null) {
                return EditvAttributeTableScrollPane.this.dataObject[n][n2];
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 >= 2;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object object2;
            int n3;
            boolean bl;
            Object object3 = this.getValueAt(n, n2);
            ((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).dataObject[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
            String string = (String)this.getValueAt(n, 0);
            String string2 = (String)this.getValueAt(n, 1);
            int n4 = string2.indexOf("/");
            String string3 = string2.substring(0, n4);
            String string4 = string2.substring(n4 + 1);
            long l = CDFUtils.getDataTypeValue(string3);
            Object object4 = null;
            if (string2.indexOf("CHAR") != -1) {
                bl = true;
                n3 = ((String)object).length();
            } else {
                object2 = ((String)object).split(",");
                n3 = ((String[])object2).length;
                bl = false;
                object4 = CDFToolUtils.parseContents((String)object, l);
            }
            ((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).dataObject[n][1] = object2 = new StringBuffer(string3).append("/").append(n3).toString();
            this.fireTableCellUpdated(n, 1);
            try {
                long l2 = EditvAttributeTableScrollPane.this.cdf.getVariableID(string);
                EditvAttributeTableScrollPane.this.attr.deleteEntry(l2);
                Entry.create(EditvAttributeTableScrollPane.this.attr, l2, l, bl ? object : object4);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).myEditor.frame, "The change failed... " + exception);
            }
        }

        void applyValue(Object object, Object object2, int n, int n2) {
            if (!((String)object).equals((String)object2) && (((String)object2).equals("CDF_CHAR") || ((String)object2).equals("CDF_UCHAR"))) {
                JOptionPane.showMessageDialog(((EditvAttributeTableScrollPane)EditvAttributeTableScrollPane.this).myEditor.frame, "The data type changed from " + object + " to " + object2 + ". Please change entry value accordingly.");
            }
        }
    }
}

