/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class EditgAttributeTableScrollPane
extends JScrollPane
implements CDFConstants {
    private CDF cdf;
    private EditgAttributeTableScrollPane aTableScrollPane = this;
    private MYEditor myEditor;
    private CDFEdit cdfedit;
    private JTable table;
    private MyTableModel myModel;
    private JLabeledPanel aPanel;
    private Object[][] dataObject = null;
    private static String[] headcol = new String[]{"Name", "Entry", "Data Type", "Value"};
    private static String na = "N/A";
    static final long serialVersionUID = 1L;

    EditgAttributeTableScrollPane(AttributePanel attributePanel) {
        super(20, 30);
        this.myEditor = attributePanel.getMyEditor();
        this.cdf = this.myEditor.theCDF;
        this.buildTable();
    }

    public void setTable(Object[][] objectArray) {
        if (objectArray != null) {
            this.dataObject = objectArray;
            this.myModel.fireTableChanged(new TableModelEvent(this.myModel));
        }
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setColumnNames(String[] stringArray) {
        headcol = stringArray;
    }

    public String[] getColumnNames() {
        return headcol;
    }

    public void setUpDataTypeColumn(TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("CDF_BYTE");
        jComboBox.addItem("CDF_INT1");
        jComboBox.addItem("CDF_UINT1");
        jComboBox.addItem("CDF_INT2");
        jComboBox.addItem("CDF_UINT2");
        jComboBox.addItem("CDF_INT4");
        jComboBox.addItem("CDF_UINT4");
        jComboBox.addItem("CDF_INT8");
        jComboBox.addItem("CDF_REAL4");
        jComboBox.addItem("CDF_FLOAT");
        jComboBox.addItem("CDF_REAL8");
        jComboBox.addItem("CDF_DOUBLE");
        jComboBox.addItem("CDF_EPOCH");
        jComboBox.addItem("CDF_EPOCH16");
        jComboBox.addItem("CDF_TIME_TT2000");
        jComboBox.addItem("CDF_CHAR");
        jComboBox.addItem("CDF_UCHAR");
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText("Click for valid data types");
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Click the dataType to see a list of choices");
        }
    }

    protected void buildTable() {
        this.dataObject = null;
        this.table = null;
        Vector vector = this.cdf.getAttributes();
        int n = vector.size();
        int n2 = 0;
        if (n < 1) {
            return;
        }
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            Attribute attribute = (Attribute)object.nextElement();
            if (attribute.getScope() != 1L) continue;
            n2 += (int)attribute.getNumEntries();
        }
        if (n2 == 0) {
            return;
        }
        this.dataObject = new Object[n2][headcol.length];
        int n3 = 0;
        Attribute attribute = null;
        Entry entry = null;
        Object object2 = null;
        Object object3 = vector.elements();
        while (object3.hasMoreElements()) {
            attribute = (Attribute)object3.nextElement();
            if (attribute.getScope() != 1L) continue;
            object = attribute.getName();
            try {
                Vector vector2 = attribute.getEntries();
                if (vector2.size() == 0) continue;
                if (n3 == n2) break;
                this.dataObject[n3][0] = object;
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    int n4;
                    StringBuffer stringBuffer;
                    entry = (Entry)enumeration.nextElement();
                    if (entry == null) continue;
                    long l = entry.getID();
                    long l2 = entry.getDataType();
                    object2 = entry.getData();
                    long l3 = entry.getNumElements();
                    this.dataObject[n3][1] = "" + (l + 1L);
                    this.dataObject[n3][2] = CDFUtils.getStringDataType(l2) + "/" + l3;
                    if (l2 == 31L) {
                        if (object2.getClass().getName().indexOf(91) == 0) {
                            stringBuffer = new StringBuffer();
                            for (n4 = 0; n4 < ((double[])object2).length; ++n4) {
                                if (n4 > 0) {
                                    stringBuffer.append(", ");
                                }
                                String string = Epoch.encode4(((double[])object2)[n4]);
                                stringBuffer.append(string);
                            }
                            this.dataObject[n3][3] = stringBuffer.toString();
                        } else {
                            this.dataObject[n3][3] = Epoch.encode4((Double)object2);
                        }
                    } else if (l2 == 32L) {
                        if (object2.getClass().getName().indexOf(91) == 0) {
                            stringBuffer = new StringBuffer();
                            double[] dArray = new double[2];
                            for (int i = 0; i < ((double[])object2).length; i += 2) {
                                if (i > 0) {
                                    stringBuffer.append(", ");
                                }
                                dArray[0] = ((double[])object2)[i];
                                dArray[1] = ((double[])object2)[i + 1];
                                String string = Epoch16.encode4(dArray);
                                stringBuffer.append(string);
                            }
                            this.dataObject[n3][3] = stringBuffer.toString();
                        }
                    } else if (l2 == 33L) {
                        if (object2.getClass().getName().indexOf(91) == 0) {
                            stringBuffer = new StringBuffer();
                            for (n4 = 0; n4 < ((long[])object2).length; ++n4) {
                                if (n4 > 0) {
                                    stringBuffer.append(", ");
                                }
                                String string = CDFTT2000.toUTCstring(((long[])object2)[n4]);
                                stringBuffer.append(string);
                            }
                            this.dataObject[n3][3] = stringBuffer.toString();
                        } else {
                            this.dataObject[n3][3] = CDFTT2000.toUTCstring((long)((Long)object2));
                        }
                    } else {
                        this.dataObject[n3][3] = CDFUtils.getStringData(object2, ", ");
                    }
                    ++n3;
                }
            }
            catch (CDFException cDFException) {
            }
        }
        this.table = null;
        if (this.dataObject != null) {
            this.myModel = new MyTableModel();
            this.table = new JTable(this.myModel);
            this.table.setRowSelectionAllowed(false);
            this.table.sizeColumnsToFit(4);
            object3 = null;
            for (int i = 0; i < headcol.length; ++i) {
                object3 = this.table.getColumnModel().getColumn(i);
                ((TableColumn)object3).setResizable(true);
                if (i == 0) {
                    ((TableColumn)object3).setPreferredWidth(100);
                }
                if (i == 1) {
                    ((TableColumn)object3).setPreferredWidth(35);
                }
                if (i == 2) {
                    ((TableColumn)object3).setPreferredWidth(105);
                }
                if (i != 3) continue;
                ((TableColumn)object3).setPreferredWidth(420);
            }
            this.table.setPreferredScrollableViewportSize(new Dimension(660, 500));
            this.table.setSelectionMode(0);
            this.aTableScrollPane.setViewportView(this.table);
            this.aTableScrollPane.setVisible(true);
        } else {
            this.aTableScrollPane.setVisible(false);
            this.aTableScrollPane.revalidate();
            this.aTableScrollPane.repaint();
        }
    }

    public void reset() {
        this.aTableScrollPane.setVisible(true);
        this.setTable(this.dataObject);
    }

    class MyTableModel
    extends AbstractTableModel {
        static final long serialVersionUID = 1L;

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return headcol.length;
        }

        @Override
        public int getRowCount() {
            if (EditgAttributeTableScrollPane.this.dataObject != null) {
                return EditgAttributeTableScrollPane.this.dataObject.length;
            }
            return 0;
        }

        @Override
        public String getColumnName(int n) {
            return headcol[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (EditgAttributeTableScrollPane.this.dataObject != null) {
                return EditgAttributeTableScrollPane.this.dataObject[n][n2];
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            long l = 1L;
            return n2 >= 3;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object object2;
            boolean bl;
            int n3;
            Object object3 = this.getValueAt(n, n2);
            ((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).dataObject[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
            String string = (String)this.getValueAt(n, 0);
            String string2 = (String)this.getValueAt(n, 2);
            int n4 = string2.indexOf("/");
            String string3 = string2.substring(0, n4);
            String string4 = string2.substring(n4 + 1);
            if (string == null || string.length() == 0) {
                for (n3 = n - 1; n3 > -1 && ((string = (String)this.getValueAt(n3, 0)) == null || string.length() <= 0); --n3) {
                }
            }
            long l = CDFUtils.getDataTypeValue(string3);
            Object object4 = null;
            if (string2.indexOf("CHAR") != -1) {
                bl = true;
                n3 = ((String)object).length();
            } else {
                object2 = ((String)object).split(",");
                n3 = ((String[])object2).length;
                bl = false;
                object4 = CDFToolUtils.parseContents((String)object, l);
            }
            ((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).dataObject[n][2] = object2 = new StringBuffer(string3).append("/").append(n3).toString();
            this.fireTableCellUpdated(n, 2);
            long l2 = new Long((String)EditgAttributeTableScrollPane.this.dataObject[n][1]) - 1L;
            try {
                Attribute attribute = EditgAttributeTableScrollPane.this.cdf.getAttribute(string);
                attribute.deleteEntry(l2);
                Entry.create(attribute, l2, l, bl ? object : object4);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).myEditor.frame, "The change failed... " + exception);
            }
        }

        void applyValue(Object object, Object object2, int n, int n2) {
            if (!((String)object).equals((String)object2) && (((String)object2).equals("CDF_CHAR") || ((String)object2).equals("CDF_UCHAR"))) {
                JOptionPane.showMessageDialog(((EditgAttributeTableScrollPane)EditgAttributeTableScrollPane.this).myEditor.frame, "The data type changed from " + object + " to " + object2 + ". Please change entry value accordingly.");
            }
        }
    }
}

