/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDF;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.Entry;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFTT2000;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class EditvEntryTablePanel
extends JPanel
implements CDFConstants {
    static final long serialVersionUID = 1L;
    private Attribute attr;
    private EditvEntryTablePanel aTablePanel = this;
    private MYEditor myEditor;
    private CDF cdf;
    private JTable table;
    private MyTableModel myModel;
    private JScrollPane scrollPane;
    private Object[][] dataObject = null;
    private static String[] headcol = new String[]{"Var Name", "Data Type", "Entry Data"};

    EditvEntryTablePanel(EditAttrEntryPanel editAttrEntryPanel) {
        this.myEditor = editAttrEntryPanel.getMyEditor();
        this.cdf = this.myEditor.theCDF;
        this.scrollPane = new JScrollPane(21, 30);
    }

    public void buildTable(Attribute attribute) {
        this.attr = attribute;
        if (attribute != null) {
            this.buildDataTable();
        } else {
            this.aTablePanel.setVisible(false);
            this.aTablePanel.validate();
        }
        if (this.dataObject != null) {
            this.myModel = new MyTableModel();
            this.table = new JTable(this.myModel);
            this.table.setPreferredScrollableViewportSize(new Dimension(530, 210));
            this.table.setRowSelectionAllowed(false);
            this.table.sizeColumnsToFit(4);
            TableColumn tableColumn = null;
            for (int i = 0; i < headcol.length; ++i) {
                tableColumn = this.table.getColumnModel().getColumn(i);
                tableColumn.setResizable(true);
                if (i == 0) {
                    tableColumn.setPreferredWidth(110);
                }
                if (i == 1) {
                    tableColumn.setPreferredWidth(110);
                }
                if (i != 2) continue;
                tableColumn.setPreferredWidth(300);
            }
            this.table.setCellSelectionEnabled(false);
            this.scrollPane.setViewportView(this.table);
            this.aTablePanel.removeAll();
            this.aTablePanel.revalidate();
            this.aTablePanel.repaint();
            this.aTablePanel.add((Component)this.scrollPane, "Center");
        }
    }

    public void setTable(Object[][] objectArray) {
        this.dataObject = objectArray;
        this.myModel.fireTableChanged(new TableModelEvent(this.myModel));
    }

    public Object[][] getTable() {
        return this.dataObject;
    }

    public void setColumnNames(String[] stringArray) {
        headcol = stringArray;
    }

    public String[] getColumnNames() {
        return headcol;
    }

    public void setUpDataTypeColumn(TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("CDF_BYTE");
        jComboBox.addItem("CDF_INT1");
        jComboBox.addItem("CDF_UINT1");
        jComboBox.addItem("CDF_INT2");
        jComboBox.addItem("CDF_UINT2");
        jComboBox.addItem("CDF_INT4");
        jComboBox.addItem("CDF_UINT4");
        jComboBox.addItem("CDF_INT8");
        jComboBox.addItem("CDF_REAL4");
        jComboBox.addItem("CDF_FLOAT");
        jComboBox.addItem("CDF_REAL8");
        jComboBox.addItem("CDF_DOUBLE");
        jComboBox.addItem("CDF_EPOCH");
        jComboBox.addItem("CDF_EPOCH16");
        jComboBox.addItem("CDF_TIME_TT2000");
        jComboBox.addItem("CDF_CHAR");
        jComboBox.addItem("CDF_UCHAR");
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText("Click for valid data types");
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Click the dataType to see a list of choices");
        }
    }

    private void buildDataTable() {
        int n;
        Vector vector = this.cdf.getVariables();
        this.dataObject = null;
        if (vector != null && (n = vector.size()) > 0) {
            Variable variable;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                variable = (Variable)vector.elementAt(i);
                try {
                    Entry entry = this.attr.getEntry(variable);
                    ++n2;
                    continue;
                }
                catch (CDFException cDFException) {
                    // empty catch block
                }
            }
            if (n2 > 0) {
                this.dataObject = new Object[n2][headcol.length];
                Entry entry = null;
                Object object = null;
                int n3 = -1;
                for (int i = 0; i < n; ++i) {
                    CharSequence charSequence;
                    try {
                        variable = (Variable)vector.elementAt(i);
                        entry = this.attr.getEntry(variable);
                    }
                    catch (CDFException cDFException) {
                        entry = null;
                    }
                    if (entry == null) continue;
                    ++n3;
                    variable = (Variable)vector.elementAt(i);
                    long l = entry.getDataType();
                    try {
                        object = entry.getData();
                    }
                    catch (CDFException cDFException) {
                        // empty catch block
                    }
                    long l2 = entry.getNumElements();
                    this.dataObject[n3][0] = variable.getName();
                    this.dataObject[n3][1] = CDFUtils.getStringDataType((long)l) + "/" + l2;
                    if (l == 31L) {
                        if (object.getClass().getName().indexOf(91) == 0) {
                            charSequence = new StringBuffer();
                            for (int j = 0; j < ((double[])object).length; ++j) {
                                if (j > 0) {
                                    ((StringBuffer)charSequence).append(", ");
                                }
                                String string = Epoch.encode4((double)((double[])object)[j]);
                                ((StringBuffer)charSequence).append(string);
                            }
                            this.dataObject[n3][2] = ((StringBuffer)charSequence).toString();
                            continue;
                        }
                        this.dataObject[n3][2] = Epoch.encode4((double)((Double)object));
                        continue;
                    }
                    if (l == 32L) {
                        if (object.getClass().getName().indexOf(91) != 0) continue;
                        charSequence = new StringBuffer();
                        double[] dArray = new double[2];
                        for (int j = 0; j < ((double[])object).length; j += 2) {
                            if (j > 0) {
                                ((StringBuffer)charSequence).append(", ");
                            }
                            dArray[0] = ((double[])object)[j];
                            dArray[1] = ((double[])object)[j + 1];
                            String string = Epoch16.encode4((Object)dArray);
                            ((StringBuffer)charSequence).append(string);
                        }
                        this.dataObject[n3][2] = ((StringBuffer)charSequence).toString();
                        continue;
                    }
                    if (l == 33L) {
                        if (object.getClass().getName().indexOf(91) == 0) {
                            charSequence = new StringBuffer();
                            for (int j = 0; j < ((long[])object).length; ++j) {
                                if (j > 0) {
                                    ((StringBuffer)charSequence).append(", ");
                                }
                                String string = CDFTT2000.toUTCstring((long)((long[])object)[j]);
                                ((StringBuffer)charSequence).append(string);
                            }
                            this.dataObject[n3][2] = ((StringBuffer)charSequence).toString();
                            continue;
                        }
                        this.dataObject[n3][2] = CDFTT2000.toUTCstring((long)((Long)object));
                        continue;
                    }
                    if (l == 21L || l == 22L || l == 44L || l == 45L) {
                        try {
                            charSequence = (String)this.attr.getEntry(variable).getData();
                        }
                        catch (CDFException cDFException) {
                            charSequence = null;
                        }
                        this.dataObject[n3][2] = CDFUtils.getStringFloatingData((Object)object, (String)charSequence, (String)", ").trim();
                        continue;
                    }
                    this.dataObject[n3][2] = CDFUtils.getStringData((Object)object, (String)", ");
                }
            }
        }
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void reset() {
        if (this.dataObject != null) {
            this.aTablePanel.setVisible(true);
            this.setTable(this.dataObject);
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        static final long serialVersionUID = 1L;

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return headcol.length;
        }

        @Override
        public int getRowCount() {
            if (EditvEntryTablePanel.this.dataObject != null) {
                return EditvEntryTablePanel.this.dataObject.length;
            }
            return 0;
        }

        @Override
        public String getColumnName(int n) {
            return headcol[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (EditvEntryTablePanel.this.dataObject != null) {
                return EditvEntryTablePanel.this.dataObject[n][n2];
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            long l = 1L;
            return n2 >= 2;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object object2;
            boolean bl;
            int n3;
            Object object3 = this.getValueAt(n, n2);
            ((EditvEntryTablePanel)EditvEntryTablePanel.this).dataObject[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
            String string = (String)this.getValueAt(n, 0);
            String string2 = (String)this.getValueAt(n, 1);
            int n4 = string2.indexOf("/");
            String string3 = string2.substring(0, n4);
            String string4 = string2.substring(n4 + 1);
            long l = CDFUtils.getDataTypeValue((String)string3);
            Object object4 = null;
            if (string2.indexOf("CHAR") != -1) {
                n3 = ((String)object).length();
                bl = true;
            } else {
                object2 = ((String)object).split(",");
                n3 = ((String[])object2).length;
                bl = false;
                object4 = CDFToolUtils.parseContents((String)object, l);
            }
            ((EditvEntryTablePanel)EditvEntryTablePanel.this).dataObject[n][1] = object2 = new StringBuffer(string3).append("/").append(n3).toString();
            this.fireTableCellUpdated(n, 1);
            try {
                long l2 = EditvEntryTablePanel.this.cdf.getVariableID(string);
                EditvEntryTablePanel.this.attr.deleteEntry(l2);
                Entry.create((Attribute)EditvEntryTablePanel.this.attr, (long)l2, (long)l, (Object)(bl ? object : object4));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(((EditvEntryTablePanel)EditvEntryTablePanel.this).myEditor.frame, "The change failed... " + exception);
            }
        }

        void applyValue(Object object, Object object2, int n, int n2) {
            if (!((String)object).equals((String)object2) && (((String)object2).equals("CDF_CHAR") || ((String)object2).equals("CDF_UCHAR"))) {
                JOptionPane.showMessageDialog(((EditvEntryTablePanel)EditvEntryTablePanel.this).myEditor.frame, "The data type changed from " + object + " to " + object2 + ". Please change entry value accordingly.");
            }
        }
    }
}

