/******************************************************************************
* Copyright 1996-2013 United States Government as represented by the
* Administrator of the National Aeronautics and Space Administration.
* All Rights Reserved.
******************************************************************************/

import java.io.*;
import java.text.*;
import java.util.*;
import java.lang.reflect.*;
import gsfc.nssdc.cdf.*;
import gsfc.nssdc.cdf.util.*;
import javax.json.*;

/**
 *  This program demonstrates how to read the contents of test.cdf created 
 *  by CreateCDF.java in this directory.
 */

public class ReadCDFO implements CDFConstants{
  private static boolean encodeEp = true;
    public static void main(String[] args) {
      String  fileName = "test";
      int     maxVarNameLength = 22;
      int ii, jj;
      CDF cdf;

      jj = args.length;
      if (jj == 0) jj = 1;

      try {

        System.out.println("CDF Library version: "+CDF.getLibraryVersion()+"\n");
      } catch (CDFException vax) {
        System.out.println("*** Error... "+vax);
        System.exit(1);
      }

      for (ii = 0; ii < jj; ++ii) {
	if (args.length != 0) fileName = args[ii];
        if (ii > 0) 
          System.out.println("");
        System.out.println("Reading " + fileName + "...:\n");
        try {
	  cdf = null;
          cdf = CDF.open(fileName, READONLYon);
          if (cdf.getStatus() != CDF_OK)
          {
            if (cdf.getStatus() == CHECKSUM_ERROR)
              System.out.println("*** Checksum failed... the cdf file is corrupted...\n");
              if (cdf != null) cdf.close();
          } else {
              long n = cdf.getNumVars();
JsonArrayBuilder records = Json.createArrayBuilder();
              int i;
              for (i = 0; i < n; ++i) {
                Variable v = cdf.getVariable(i);
                long    maxRec, numDims, numElements, numValuesToRead, dataType;
                long    recCount;
                boolean recVary;
                long[]  dimSizes = {1L}, dimVariances;
                long[]  dimIndices   = {0L};
                long[]  dimIntervals = {1L};
                long numDimsN = 0;
                long[] dimSizesN = null;
                maxRec = v.getMaxWrittenRecord();
                if (maxRec < 0) continue;

                recVary      = v.getRecVariance();
                numDims      = v.getNumDims();
                dimSizes     = v.getDimSizes();
                numElements  = v.getNumElements();
                dataType     = v.getDataType();
                dimVariances = v.getDimVariances();
                numValuesToRead = 1;
                if (numDims > 0) {
                    dimIntervals = new long[dimSizes.length];
                    dimIndices   = new long[dimSizes.length];
                    dimSizesN    = new long[dimSizes.length];
                    int j = 0;
                    numDimsN = 0;
                    for (int x=0; x < dimSizes.length; x++) {
                      if (dimVariances[x] == VARY) {
                        ++numDimsN;
                        dimSizesN[j] = dimSizes[x];
                        ++j;
                      }
                      dimIntervals[x] = 1;
                      dimIndices[x]   = 0;
                      numValuesToRead *= dimSizes[x];
                    }
                }
System.out.println("reading var:"+v.getName()+" num records:"+(maxRec+1));
                long incrementCounter, numRecordsToRead, recNo;
                long sparseRecord = v.getSparseRecords();

                if (sparseRecord == NO_SPARSERECORDS)
                    incrementCounter = (numDimsN == 0 ? 2000 : 1200);
                else
                    incrementCounter = 1;
                CDFData cdfdata;
                int k;
                for (k=0; k <= maxRec; k+=incrementCounter) {

                  if ((k+incrementCounter) > maxRec)
                      numRecordsToRead = maxRec - k + 1;
                  else
                      numRecordsToRead = incrementCounter;
//System.out.println("     starting rec:"+k+" recs:"+numRecordsToRead);
                  if (numDimsN > 0)
                      cdfdata = v.getHyperDataObject((long) k,
                                                    numRecordsToRead, 1L,
                                                    dimIndices,
                                                    dimSizes,
                                                    dimIntervals);
                  else
                      cdfdata = v.getRecordsObject((long) k,
                                                   numRecordsToRead);
                  long status = cdf.getStatus();
                  Object dataArray = cdfdata.getData();
                  Object datum;
                  for (int ij=0; ij < numRecordsToRead; ij++) {
                      if (numRecordsToRead > 1) {
                          if (dataType != CDF_EPOCH16)
                            datum = Array.get(dataArray, ij);
                          else {
                            double[] epoch16 = new double[2];
                            epoch16[0] = ((Double) Array.get(dataArray, 2*ij)).
                                          doubleValue();
                            epoch16[1] = ((Double) Array.get(dataArray, 2*ij+1)).
                                          doubleValue();
                            datum = (Object) epoch16;
                          }
                      } else
                          datum = dataArray;

                      if (numDims != numDimsN) {
                        long iz;
                        iz = numDims;
                        while (iz != numDimsN) {
                          datum = Array.get(datum, 0);
                          --iz;
                        }
                      }
                      if (numDimsN < 2) {
                        boolean single = false;
                        if (!recVary || maxRec == 0) single = true;
//System.out.println("111111");
                         records = (JsonArrayBuilder) printSingleData (
                                                    (Object)records, null,
                                                    datum, dataType, numDimsN,
                                                    -1, "", null, null, single);
                      } else {
//System.out.println("222222");
//                         JsonArrayBuilder oData = printMultipleData (datum,
//                                                    dataType, (int)numDimsN,
//                                                    dimSizes,
//                                                    "", null,
//                                                    null);
//                         if (!recVary || maxRec == 0) return oData;
//                         else records.add (oData);
                      }
                  }
//            try {
//            Thread.sleep(500);
//            } catch(InterruptedException e) {
//            e.printStackTrace();
//            return;
//            }

                }
              }
          }
        } catch (Exception e) {
            System.out.println ("** Error occurred in printVarData");
//            System.out.println ("variable: "+v.getName());
            System.out.println (e);
            System.exit (1);
        }
      }
    }

    private static Object printSingleData (Object jsonObject, String name,
                                           Object data, long dataType,
                                           long numDims, long dataType2,
                                           String addZ, String formatT,
                                           Object fillVal, boolean single) {

        int iflag;
        boolean isArray = false;
        if (dataType == CDF_EPOCH) iflag = 1;
        else if (dataType == CDF_EPOCH16) iflag = 2;
        else if (dataType == CDF_TIME_TT2000) iflag = 3;
        else iflag = 0;
        int  i, arrayLength, jj = 1;
        if (iflag == 2) jj = 2;
        boolean multi = false;

        String signature = CDFUtils.getSignature(data);
        JsonObjectBuilder jObject = Json.createObjectBuilder();
        JsonArrayBuilder  jArray = Json.createArrayBuilder();
        if (jsonObject instanceof JsonObjectBuilder)
          jObject = (JsonObjectBuilder) jsonObject;
        else
          jArray = (JsonArrayBuilder) jsonObject;
        if (signature.charAt(0) == '[') {
          arrayLength = Array.getLength(data);
          if (iflag == 2) arrayLength = arrayLength / 2;
          if (arrayLength > 1) multi = true;
          if (iflag != 2) isArray = true;
        }
        if (multi) {
            JsonArrayBuilder  jArray2 = Json.createArrayBuilder();
            arrayLength = Array.getLength(data);
            for (i=0; i < arrayLength; i=i+jj) {
                 if (signature.charAt(1) == 'B')
                     jArray2.add (Array.getByte(data,i));

                 else if (signature.charAt(1) == 'S')
                     jArray2.add (Array.getShort(data,i));

                 else if (signature.charAt(1) == 'I')
                     jArray2.add (Array.getInt(data,i));

                 else if (signature.charAt(1) == 'J')
                     if (iflag == 3 || (isEpochDataType(dataType2) &&
                                        validORscaleORfill(name))) {
                       if (encodeEp)
                         jArray2.add (CDFTT2000.encode(Array.getLong(data,i))+
                                      addZ);
                       else
                         jArray2.add (Array.getLong(data,i));
                     } else
                       jArray2.add (Array.getLong(data,i));

                 else if (signature.charAt(1) == 'F') {
                     float ff = Array.getFloat(data,i);
                     double dd;
                     if (Float.isNaN(ff))
                       jArray2.add ("NaN"); // jArray2.add (Float.NaN);
                     else if (Float.isNaN(-ff))
                       jArray2.add ("-NaN"); // jArray2.add (-Float.NaN);
                     else if (Float.isInfinite(ff))
                       jArray2.add ("INF"); // jArray2.add (Float.POSITIVE_INFINITY);
                     else if (Float.isInfinite(-ff))
                       jArray2.add ("-INF"); // jArray2.add (Float.NEGATIVE_INFINITY);
                     else {
                       if (ff == -1.0E30f) dd = -1.0E30;
                       else if (ff == -1.0E31f) dd = -1.0E31;
                       else if (ff == 1.0E30f) dd = 1.0E30;
                       else if (ff == 1.0E31f) dd = 1.0E31;
                       else dd = (double) ff;
                       if (formatT == null)
                         jArray2.add (dd);
                       else {
                         try {
                           String sd = String.format(formatT, dd);
                           jArray2.add (new Double(sd).doubleValue());
                         } catch (Exception ex) {
                           jArray2.add (dd);
                         }
                       }
                     }
                 } else if (signature.charAt(1) == 'D') {
                     double dd = Array.getDouble(data,i);
                     if (iflag == 1 || (isEpochDataType(dataType2) &&
                                        validORscaleORfill(name))) {
                       if (encodeEp)
                         jArray2.add (Epoch.encode4(dd)+addZ);
                       else
                         jArray2.add (dd);
                     } else if (iflag == 2 || (isEpochDataType(dataType2) &&
                                               validORscaleORfill(name))) {
                       double[] mmm = new double[2];
                       mmm[0] = Array.getDouble(data,i);
                       mmm[1] = Array.getDouble(data,i+1);
                       if (encodeEp)
                         jArray2.add (Epoch16.encode4(mmm)+addZ);
                       else {
                         JsonArrayBuilder epoch16 = Json.createArrayBuilder();
                         epoch16.add (mmm[0]);
                         epoch16.add (mmm[1]);
                         jArray2.add (epoch16.build());
                       }
                     } else {
                       if (Double.isNaN(dd))
                         jArray2.add ("NaN"); // jArray2.add (Double.NaN);
                       else if (Double.isNaN(-dd))
                         jArray2.add ("-NaN"); // jArray2.add (-Double.NaN);
                       else if (Double.isInfinite(dd))
                         jArray2.add ("INF"); // jArray2.add (Double.POSITIVE_INFINITY);
                       else if (Double.isInfinite(-dd))
                         jArray2.add ("-INF"); // jArray2.add (Double.NEGATIVE_INFINITY);
                       else {
                         if (formatT == null) {
                           jArray2.add (dd);
                         } else {
                           try {
                             String sd = String.format(formatT, dd);
                             jArray2.add (new Double(sd).doubleValue());
                           } catch (Exception ex) {
                             jArray2.add (dd);
                           }
                         }
                       }
                     }
                 }
                 else if (signature.indexOf("String") != -1)
                     jArray2.add (((String[])data)[i]);
            }
            if (name != null)
              return jObject.add(name, jArray2);
            else {
              if (single) return jArray2;
              else  return jArray.add(jArray2);
            }
        } else {
          if (signature.charAt(0) == '[' && iflag != 2)
            data = Array.get(data, 0);
          if (iflag == 1) {
            if (name != null) {
              if (encodeEp)
                return jObject.add(name,
                                   Epoch.encode4(((Double)data).doubleValue())+
                                   addZ);
              else
                return jObject.add(name, ((Double)data).doubleValue());
            } else {
              if (encodeEp)
                return jArray.add(Epoch.encode4(((Double)data).doubleValue())+
                                  addZ);
              else
                return jArray.add(((Double)data).doubleValue());
            }
          } else if (iflag == 2) {
            if (name != null) {
              if (encodeEp)
                return jObject.add(name, Epoch16.encode4((double[])data)+addZ);
              else {
                JsonArrayBuilder epoch16 = Json.createArrayBuilder();
                epoch16.add(((double[])data)[0]);
                epoch16.add(((double[])data)[1]);
                return jObject.add(name, epoch16.build());
              }
            } else {
              if (encodeEp)
                return jArray.add(Epoch16.encode4(((double[])data))+addZ);
              else {
                JsonArrayBuilder epoch16 = Json.createArrayBuilder();
                epoch16.add(((double[])data)[0]);
                epoch16.add(((double[])data)[1]);
                return jArray.add(epoch16.build());
              }
            }
          } else if (iflag == 3) {
            if (name != null) {
              if (encodeEp)
                return jObject.add(name,
                                   CDFTT2000.encode(((Long)data).longValue())+
                                   addZ);
              else
                return jObject.add(name, ((Long)data).longValue());
            } else {
              if (encodeEp)
                return jArray.add(CDFTT2000.encode(((Long)data).longValue())+
                                  addZ);
              else
                return jArray.add(((Long)data).longValue());
            }
          } else {
            if (signature.indexOf("Byte") != -1) {
              int value;
              value = ((Byte)data).intValue();
              if (name != null)
                return jObject.add(name, value);
              else
                return jArray.add(value);
            } else if (signature.indexOf("Short") != -1) {
              int value;
              value = ((Short)data).intValue();
              if (name != null)
                return jObject.add(name, value);
              else
                return jArray.add(value);
            } else if (signature.indexOf("Int") != -1) {
              int value;
              value = ((Integer)data).intValue();
              if (name != null)
                return jObject.add(name, value);
              else
                return jArray.add(value);
            } else if (signature.indexOf("Long") != -1) {
              long value;
              value = ((Long)data).longValue();
              if (name != null) {
                if (isEpochDataType(dataType2) && validORscaleORfill(name))
                  return jObject.add(name, CDFTT2000.encode(value)+addZ);
                else
                  return jObject.add(name, value);
              } else {
                if (isEpochDataType(dataType2) && validORscaleORfill(name))
                  return jArray.add(CDFTT2000.encode(value)+addZ);
                else
                  return jArray.add(value);
              }
            } else if (signature.indexOf("Float") != -1) {
              float ff;
              ff = ((Float)data).floatValue();
              if (Float.isNaN(ff)) {
                if (name != null)
                  return jObject.add (name, "NaN"); // jObject.add (name, Float.NaN);
                else
                  return jArray.add ("NaN"); // jArray.add (Float.NaN);
              } else if (Float.isNaN(-ff)) {
                if (name != null)
                  return jObject.add (name, "-NaN"); // jObject.add (name, -Float.NaN);
                else
                  return jArray.add ("-NaN"); // jArray.add (-Float.NaN);
              } else if (Float.isInfinite(ff)) {
                if (name != null)
                  return jObject.add (name, "INF"); // jObject.add (name, Float.POSITIVE_INFINITY);
                else
                  return jArray.add ("INF"); // jArray.add (Float.POSITIVE_INFINITY);
              } else if (Float.isInfinite(-ff)) {
                if (name != null)
                  return jObject.add (name, "-INF"); // jObject.add (name, Float.NEGATIVE_INFINITY);
                else
                  return jArray.add ("-INF"); // jArray.add (Float.NEGATIVE_INFINITY);
              } else {
                double dd;
                if (ff == -1.0E30f) dd = -1.0E30;
                else if (ff == -1.0E31f) dd = -1.0E31;
                else if (ff == 1.0E30f) dd = 1.0E30;
                else if (ff == 1.0E31f) dd = 1.0E31;
                else dd = (double) ff;
                if (name != null) {
                  if (formatT == null) {
                    return jObject.add(name, dd);
                  } else {
                    try {
                      String sd = String.format(formatT, dd);
                      return jObject.add(name, new Double(sd).doubleValue());
                    } catch (Exception ex) {
                      return jObject.add (name, dd);
                    }
                  }
                } else {
                  if (formatT == null) {
                    return jArray.add(dd);
                  } else {
                    try {
                      String sd = String.format(formatT, dd);
                      return jArray.add(new Double(sd).doubleValue());
                    } catch (Exception ex) {
                      return jArray.add (dd);
                    }
                  }
                }
              }
            } else if (signature.indexOf("Double") != -1) {
              double dd;
              dd = ((Double)data).doubleValue();
              if (Double.isNaN(dd)) {
                if (name != null)
                  return jObject.add (name, "NaN"); // jObject.add (name, Double.NaN);
                else
                  return jArray.add ("NaN"); // jArray.add (Double.NaN);
              } else if (Double.isNaN(-dd)) {
                if (name != null)
                  return jObject.add (name, "NaN"); // jObject.add (name, -Double.NaN);
                else
                  return jArray.add ("-NaN"); // jArray.add (-Double.NaN);
              } else if (Double.isInfinite(dd)) {
                if (name != null)
                  return jObject.add (name, "INF"); // jObject.add (name, Double.POSITIVE_INFINITY);
                else
                  return jArray.add ("INF"); // jArray.add (Double.POSITIVE_INFINITY);
              } else if (Double.isInfinite(-dd)) {
                if (name != null)
                  return jObject.add (name, "-INF"); // jObject.add (name, Double.NEGATIVE_INFINITY);
                else
                  return jArray.add ("-INF"); // jArray.add (Double.NEGATIVE_INFINITY);
              } else {
                if (name != null) {
                  if (formatT == null) {
                    if (isEpochDataType(dataType2) && validORscaleORfill(name))
                      return jObject.add(name, Epoch.encode4(dd)+addZ);
                    else
                      return jObject.add(name, dd);
                  } else {
                    try {
                      String sd = String.format(formatT, dd);
                      if (isEpochDataType(dataType2) && validORscaleORfill(name))
                        return jObject.add(name, Epoch.encode4(
                                                 new Double(sd).doubleValue())+
                                                 addZ);
                      else
                        return jObject.add(name, new Double(sd).doubleValue());
                    } catch (Exception ec) {
                      if (isEpochDataType(dataType2) && validORscaleORfill(name))
                        return jObject.add(name, Epoch.encode4(dd)+addZ);
                      else
                        return jObject.add(name, dd);
                    }
                  }
                } else {
                  if (formatT == null) {
                    return jArray.add(dd);
                  } else {
                    try {
                      String sd = String.format(formatT, dd);
                      return jArray.add(new Double(sd).doubleValue());
                    } catch (Exception es) {
                      return jArray.add(dd);
                    }
                  }
                }
              }
            } else if (signature.indexOf("String") != -1) {
              if (name != null)
                return jObject.add(name, (String)data);
              else
                return jArray.add((String)data);
            }
          }
        }
        return null;
    }

    private static long product (int [] array, int start, int stop) {

        long product = 1;
        for (int i=start; i<stop; i++)
        if (array[i] > 1) product *= array[i];

        return product;
    }

    private static boolean validORscaleORfill (String name) {

        if (name == null) return false;
        name = name.toLowerCase();
        if (name.equals("validmin") || name.equals("validmax") ||
            name.equals("scalemin") || name.equals("scalemax") ||
            name.equals("fillval")) return true;
        else return false;
    }

    private static boolean isEpochDataType (long dataType) {

        if (dataType == CDF_EPOCH || dataType == CDF_EPOCH ||
            dataType == CDF_TIME_TT2000) return true;
        else return false;
    }

}
