echo "Checking for the leap seconds table..."
$from = 0
if (-not (Test-Path ENV:CDF_LEAPSECONDSTABLE)) {
  $Has_CDFBASE = Test-Path ENV:CDF_BASE
  if ($HAS_CDFBASE) {
    echo "  CDF_LEAPSECONDSTABLE environment variable is not defined..."
    echo "  Internal hard-coded leap seconds table is used..."
    $leapinfo = $ENV:CDF_BASE + '\bin\cdfleapsecondsinfo.exe'
    $script:PATH = $ENV:CDF_BASE + '\bin;'+$ENV:CDF_BASE + '\lib;' + $ENV:path
    $out1 = Invoke-Expression "$leapinfo -nodump"
    $length = $out1[3].length
    $date1 = $out1[3].substring($length-10, 10)
    $lyear = $date1.substring(0,4)
    $lmonth = $date1.substring(5,2)
    $lday = $date1.substring(8,2)
    $from  = 1
  } else {
    $ls_folder = Read-Host -Prompt 'Enter the latest installed CDF directory'
    $leapinfo = $ls_folder + '\bin\cdfleapsecondsinfo.exe'
    $info_exe = Test-Path $leapinfo
    if ($info_exe) {
      echo "  CDF_LEAPSECONDSTABLE environment variable is not defined..."
      echo "  Internal hard-coded leap seconds table is used..."
      $script:PATH = $ls_folder + '\bin;' + $ls_folder + '\lib;' + $ENV:path
      $out1 = Invoke-Expression "$leapinfo -nodump"
      $length = $out1[3].length
      $date1 = $out1[3].substring($length-10, 10)
      $lyear = $date1.substring(0,4)
      $lmonth = $date1.substring(5,2)
      $lday = $date1.substring(8,2)
      $from = 2
    } else {
      echo "  Error... CDF installation not found in $ls_folder"
      exit 1
    }
  }
} else {
  $table1 = $ENV:CDF_LEAPSECONDSTABLE
  $gottail = cat $table1 -tail 1
  $lyear = $gottail.substring(2,4)
  $lmonth = $gottail.substring(8,2)
  $lday = $gottail.substring(14,1)
  $from = 3
}

$LSfile = $ENV:TEMP + "\CDFLeapSeconds.txt"
$ls_table = "https://cdf.gsfc.nasa.gov/html/CDFLeapSeconds.txt"
$client = New-Object System.Net.WebClient
$client.DownloadFile($ls_table, $LSfile)
if (-not (test-path $LSfile)) {
  echo "  Error... Unable to get the remote $ls_table"
  exit 1
} else {
  $gottail = cat $LSfile -tail 1
  $ryear = $gottail.substring(2,4)
  $rmonth = $gottail.substring(8,2)
  $rday = $gottail.substring(14,1)
}

$localdate = [int]$lyear * 10000 + [int]$lmonth * 100 + [int]$lday
$remotedate = [int]$ryear * 10000 + [int]$rmonth * 100 + [int]$rday
if ($localdate -eq $remotedate) {
  if ($from -eq 1) {
    echo "  Hard-coded leap second table in the library in $ENV:CDF_BASE is up-to-date."
  } else {
    if ($from -eq 2) {
      echo "  Hard-coded leap second table in CDF installation: $ls_folder is up-to-date."
    } else {
      if ($from -eq 3) {
        echo "  Leap second table: $ENV:CDF_LEAPSECONDSTABLE defined by environment variable:" 
        echo "  CDF_LEAPSECONDSTABLE is up-to-date."
      }
    }
  }
} else {
  if ($localdate -gt $remotedate) {
    echo "  Local CDFLeapSeconds.txt has a newer leap second (s) than the"
    echo "  one at the CDF home page."
  } else {
    if ($localdate -lt $remotedate) {
      echo "  A newer leap second(s) had been added to CDFLeapSeconds.txt at the CDF"
      echo "  home page. Please update your CDF installation that includes the latest"
      echo "  CDFLeapSeconds.txt from https://cdf.gsfc.nasa.gov."
    }
  }
}

