/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.CDFConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;

public class CDFJsonReader
implements CDFConstants {
    private static boolean toGlobal = true;
    private static boolean toVarAttrs = true;
    private static boolean toVarDesc = true;
    private static boolean toVarData = false;
    private static String[] varNames = null;
    private static String inFile = null;
    private static int varCount = 0;
    private static boolean toShow = true;
    private static String item1 = "CDFFileInfo";
    private static String item2 = "CDFglobalAttributes";
    private static String item3 = "CDFVariables";
    private static String item4 = "VarDescription";
    private static String item5 = "VarAttributes";
    private static String item6 = "VarData";
    private static String item7 = "EmptyAttributes";

    public static void main(String[] stringArray) throws IOException {
        CDFJsonReader.parseCmdLine(stringArray);
        FileInputStream fileInputStream = new FileInputStream(inFile);
        JsonReader jsonReader = Json.createReader((InputStream)fileInputStream);
        JsonObject jsonObject = jsonReader.readObject();
        jsonReader.close();
        ((InputStream)fileInputStream).close();
        JsonArray jsonArray = jsonObject.getJsonArray(item1);
        if (jsonArray != null) {
            CDFJsonReader.printJsonObject(jsonObject);
        } else {
            for (String string : jsonObject.keySet()) {
                JsonObject jsonObject2 = jsonObject.getJsonObject(string);
                System.out.println(string + ":");
                CDFJsonReader.printJsonObject(jsonObject.getJsonObject(string));
            }
        }
    }

    private static void printJsonObject(JsonObject jsonObject) {
        JsonObject jsonObject2;
        JsonValue jsonValue;
        Object object;
        Object object2;
        JsonArray jsonArray = jsonObject.getJsonArray(item1);
        if (jsonArray != null) {
            System.out.println("  " + item1 + ":");
            object2 = jsonArray.iterator();
            while (object2.hasNext()) {
                object = (JsonValue)object2.next();
                for (Object object3 : ((JsonObject)object).keySet()) {
                    System.out.println("    " + (String)object3 + ":" + ((JsonObject)object).getString((String)object3));
                }
            }
        }
        if (toGlobal && (object2 = jsonObject.getJsonArray(item2)) != null) {
            System.out.println("  " + item2 + ":");
            object = object2.iterator();
            while (object.hasNext()) {
                jsonValue = (JsonValue)object.next();
                for (Object object4 : ((JsonObject)jsonValue).keySet()) {
                    System.out.println("    " + (String)object4 + ":");
                    Object object5 = ((JsonObject)jsonValue).getJsonArray((String)object4);
                    for (int i = 0; i < object5.size(); ++i) {
                        jsonObject2 = object5.getJsonObject(i);
                        for (Object object6 : jsonObject2.keySet()) {
                            Object object7 = jsonObject2.get(object6);
                            System.out.println("      " + (String)object6 + ":" + object7);
                        }
                    }
                }
            }
        }
        boolean bl = false;
        object = jsonObject.getJsonArray(item3);
        if (object != null) {
            System.out.println("  " + item3 + ":");
            jsonValue = object.iterator();
            while (jsonValue.hasNext()) {
                Object object3;
                object3 = (JsonValue)jsonValue.next();
                for (Object object5 : ((JsonObject)object3).keySet()) {
                    JsonArray jsonArray2 = ((JsonObject)object3).getJsonArray((String)object5);
                    jsonObject2 = jsonArray2.getJsonObject(0);
                    if (varCount > 0) {
                        toShow = CDFJsonReader.checkVar(jsonObject2);
                    }
                    if (!toShow) continue;
                    System.out.println("    " + (String)object5 + ":");
                    block8: for (int i = 0; i < jsonArray2.size(); ++i) {
                        jsonObject2 = jsonArray2.getJsonObject(i);
                        block9: for (Object object7 : jsonObject2.keySet()) {
                            if (((String)object7).equals("VarDescription")) {
                                bl = false;
                            }
                            if (((String)object7).equals(item5) && !toVarAttrs || ((String)object7).equals(item6) && !toVarData && !bl) continue block8;
                            Object object8 = jsonObject2.get(object7);
                            if (object8 instanceof JsonString) {
                                System.out.println("      " + (String)object7 + ":" + object8);
                                continue;
                            }
                            if (object8 instanceof JsonArray) {
                                System.out.println("      " + (String)object7 + ":");
                                int n = ((JsonArray)object8).size();
                                boolean bl2 = false;
                                for (int j = 0; j < n; ++j) {
                                    Object object9;
                                    Object object10 = ((JsonArray)object8).get(j);
                                    if (object10 instanceof JsonObject) {
                                        for (String string : ((JsonObject)object10).keySet()) {
                                            object9 = ((JsonObject)object10).get((Object)string);
                                            System.out.println("        " + string + ":" + object9);
                                            if (!toVarDesc && string.equalsIgnoreCase("varname")) {
                                                bl2 = true;
                                            }
                                            if (!string.equals("RecVariance") || !object9.toString().equals("\"NOVARY\"")) continue;
                                            bl = true;
                                        }
                                    } else if (object10 instanceof JsonArray) {
                                        System.out.print("        [");
                                        int n2 = ((JsonArray)object10).size();
                                        for (int k = 0; k < n2; ++k) {
                                            object9 = ((JsonArray)object10).get(k);
                                            System.out.print(object9 + (k < n2 - 1 ? ", " : "]"));
                                        }
                                        System.out.println("");
                                    } else if (object10 instanceof JsonNumber || object10 instanceof JsonString) {
                                        if (j == 0) {
                                            System.out.print("      [");
                                        }
                                        System.out.print(object10 + (j < n - 1 ? ", " : ""));
                                        if (j == n - 1) {
                                            System.out.println("]");
                                        }
                                    } else {
                                        System.out.println("        " + object10);
                                    }
                                    if (bl2) continue block9;
                                }
                                continue;
                            }
                            if (object8 instanceof JsonObject) {
                                System.out.println("  :a jsonObject: " + object8);
                                continue;
                            }
                            System.out.println("  :unknown");
                        }
                    }
                }
            }
            jsonValue = jsonObject.getJsonArray(item7);
            if (jsonValue != null) {
                System.out.println("  " + item7 + ":");
                for (Object object4 : jsonValue) {
                    for (String string : ((JsonObject)object4).keySet()) {
                        System.out.println("    " + string + ":" + ((JsonObject)object4).get((Object)string));
                    }
                }
            }
        }
    }

    private static void parseCmdLine(String[] stringArray) {
        Object var1_1 = null;
        if (stringArray.length == 0) {
            CDFJsonReader.exit("");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                String string;
                if (i == stringArray.length - 1) {
                    inFile = stringArray[i];
                    if (new File(inFile).exists()) continue;
                    System.out.println("** Error: file '" + inFile + "' does not exist **");
                    System.exit(1);
                    continue;
                }
                int n2 = stringArray[i].indexOf(":");
                if (stringArray[i].toLowerCase().startsWith("-vardata:")) {
                    string = stringArray[i].substring(n2 + 1);
                    if (!string.equalsIgnoreCase("yes") && !string.equalsIgnoreCase("no")) {
                        CDFJsonReader.exit("** Error: Invalid -vardata entered **");
                    }
                    if (!string.equalsIgnoreCase("yes")) continue;
                    toVarData = true;
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("-globalmetadata:")) {
                    string = stringArray[i].substring(n2 + 1);
                    if (!string.equalsIgnoreCase("yes") && !string.equalsIgnoreCase("no")) {
                        CDFJsonReader.exit("** Error: Invalid -globalmetadata entered **");
                    }
                    if (!string.equalsIgnoreCase("no")) continue;
                    toGlobal = false;
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("-vardesc:")) {
                    string = stringArray[i].substring(n2 + 1);
                    if (!string.equalsIgnoreCase("yes") && !string.equalsIgnoreCase("no")) {
                        CDFJsonReader.exit("** Error: Invalid -vardesc entered **");
                    }
                    if (!string.equalsIgnoreCase("no")) continue;
                    toVarDesc = false;
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("-varmetadata:")) {
                    string = stringArray[i].substring(n2 + 1);
                    if (!string.equalsIgnoreCase("yes") && !string.equalsIgnoreCase("no")) {
                        CDFJsonReader.exit("** Error: Invalid -varmetadata entered **");
                    }
                    if (!string.equalsIgnoreCase("no")) continue;
                    toVarAttrs = false;
                    continue;
                }
                if (!stringArray[i].toLowerCase().startsWith("-vars:")) continue;
                string = stringArray[i].substring(6);
                varCount = 1;
                for (n = 0; n < string.length(); ++n) {
                    if (string.charAt(n) != ',') continue;
                    ++varCount;
                }
                varNames = new String[varCount];
                StringBuffer stringBuffer = new StringBuffer(string);
                for (n = 0; n < varCount; ++n) {
                    int n3 = stringBuffer.indexOf(",");
                    if (n3 != -1) {
                        CDFJsonReader.varNames[n] = stringBuffer.substring(0, n3).toString();
                        stringBuffer = new StringBuffer(stringBuffer.substring(n3 + 1));
                        continue;
                    }
                    CDFJsonReader.varNames[n] = new String(stringBuffer);
                }
            }
        }
    }

    private static boolean checkVar(JsonObject jsonObject) {
        for (String string : jsonObject.keySet()) {
            JsonArray jsonArray = jsonObject.getJsonArray(string);
            JsonObject jsonObject2 = jsonArray.getJsonObject(0);
            block1: for (String string2 : jsonObject2.keySet()) {
                Object object = jsonObject2.get((Object)string2);
                if (!string2.equalsIgnoreCase("varname")) continue;
                toShow = false;
                String string3 = ((JsonString)object).getString();
                for (int i = 0; i < varCount; ++i) {
                    if (!string3.equals(varNames[i])) continue;
                    toShow = true;
                    continue block1;
                }
            }
        }
        return toShow;
    }

    private static void exit(String string) {
        if (!string.equals("")) {
            System.out.println(string);
        }
        CDFJsonReader.usage();
        System.exit(1);
    }

    private static void usage() {
        System.out.println("\nDescription:");
        System.out.println("    This program displays the contents of a Json file.");
        System.out.println("");
        System.out.println("Usage: java CDFJsonReader [Options] JsonFileName ");
        System.out.println(" ");
        System.out.println("Options: ");
        System.out.println(" ");
        System.out.println("   -globalmetadata:[yes | no].  -globalmetadata:yesis the default.");
        System.out.println("      -globalmetadata:yes shows all global attributes.");
        System.out.println("      -globalmetadata:no doesn't show all global attributes.");
        System.out.println(" ");
        System.out.println("   -vardesc:[yes | no].  -vardesc:yes is the default.");
        System.out.println("      -vardesc:yes shows each variable's name and its specification.");
        System.out.println("      -vardesc:no shows the variable name only.");
        System.out.println(" ");
        System.out.println("   -varmetadata:[yes | no].  -varmetadata:yes is the default.");
        System.out.println("      -varmetadata:yes shows each variable's attributes.");
        System.out.println("      -varmetadata:no doesn't show each variable's attributes.");
        System.out.println(" ");
        System.out.println("   -vars:var1,var2,....   shows only the specified variables with");
        System.out.println("                          variable names separated by a single ','.");
        System.out.println("                          Otherwise, all variables are shown.");
        System.out.println(" ");
        System.out.println("   -vardata:[yes | no].  -vardata:no is the default.");
        System.out.println("      -vardata:yes shows the variable data");
        System.out.println("      -vardata:no doesn't show any record varying variable data");
        System.out.println(" ");
    }
}

