// $Id: CDFDelegate.java,v 1.1.1.1 2020/05/08 13:29:58 mhliu Exp $
/*
 * Copyright 1996-2014 United States Government as represented by the
 * Administrator of the National Aeronautics and Space Administration.
 * All Rights Reserved.
 */

package gsfc.nssdc.cdf;

import java.util.Vector;

/**
 * This class defines the method that is responsible for acting as the 
 * gateway between the CDF Java code and the CDF library. 
 * The CDFNativeLibrary class that implementing this interface will
 * cause the JNI to be loaded.
 * This class is available only to the CDF object that uses the CDFDelegate
 * to make requests to JNI. All CDF's other objects, i.e., Attribute, Entry,
 * Variable (and its CDFData), need to refer to the containing CDF 
 * object to make requests. 
 *
 * @author Phil Williams, QSS Group Inc/RITSS
 * @version 1.0 
 *
 * @see gsfc.nssdc.cdf.CDFNativeLibrary
 */
public interface CDFDelegate {

   /**
    * Defines the method that is responsible for acting as the gateway 
    * between the CDF Java code and the CDF library.  This method is
    * responsible for sending Java's request to the CDF library and
    * returning the results from the CDF library to the Java side. <P>
    *
    * @param theCDF the current CDF to be processed
    * @param cdfObject the calling CDF object (e.g. Attribute, variable, etc.) 
    * @param cmds a Vector that contains the CDF internal interface
    *             library commands to be executed 
    *
    * @exception CDFException if an error occurs processing the requested
    *                         commands in JNI
    */
    public void cdflib(CDF theCDF, CDFObject cdfObject, Vector cmds) 
        throws CDFException;

}
