# NOTE: Derived from blib/lib/CDF.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package CDF;

#line 2193 "blib/lib/CDF.pm (autosplit into blib/lib/auto/CDF/CDFreadCDF.al)"
sub CDFreadCDF {

        use strict;
        my @args = @_;
        my $cdf = $args[0];
        my @vars = ();
        my $enteredVars = -1;
        my ($toClose, $metaEncoding, $dataEncoding, $matrix);

        if (scalar(@_) > 1) {
          my $haveVars = $args[1];
          if (ref($haveVars) eq "ARRAY") {
            if ($#$haveVars == -1) {
              $enteredVars = -1;
            } else {
              @vars = @$haveVars;
              $enteredVars = $#vars + 1;
            }
          } else {
            if (!$haveVars) {
              $enteredVars = -1;
            } else {
              if ($haveVars ne "ALL") {
                @vars = split(',', $haveVars);
                $enteredVars = $#vars + 1;
              } else {
                $enteredVars = -1;
              }
            }
          }
        }

        $toClose = 0;
        $metaEncoding = 1;
        $dataEncoding = 0;
        $matrix = 0;
        if (scalar(@_) > 2) {
          $metaEncoding = $args[2];
          if ($metaEncoding != 0) {
            $metaEncoding = 1;
          }
        }
        if (scalar(@_) > 3) {
          $dataEncoding = $args[3];
          if ($dataEncoding != 0) {
            $dataEncoding = 1;
          }
        }
        if (scalar(@_) > 4) {
          $matrix = $args[4];
          if ($matrix != 0) {
            $matrix = 1;
          }
        }
        my $id;
        my $status;
        my %cdfInfo;
        if ($cdf =~ /^\d+$/) {
          $status = CDFlib(&SELECT_, &CDF_, $cdf,
                           &NULL_);
          if ($status != &CDF_OK) {
            $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                             &NULL_);
            $toClose = 1;
          } else {
            $id = $cdf;
          }
        } else {
          $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                           &NULL_);
          $toClose = 1;
        }
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        my $zmodeO;
        $status = CDFlib(&CONFIRM_, &CDF_zMODE_, \$zmodeO,
                         &SELECT_, &CDF_zMODE_, &zMODEon2,
                         &NULL_);
        my (%cdfinfo, %globalAttrs, %cdfTotal, %noEntry);
        %globalAttrs = ();
        %noEntry = ();
        ($status, %cdfinfo) = CDFgetCDFInfo($id);
        if ($status == &CDF_OK) {
          $cdfTotal{"CDFInfo"} = \%cdfinfo;
        } else {
          return ($status, ());
        }
        my ($i, $j);
        my @dummy = ();
        ($status, %globalAttrs) = CDFgetGlobalMetaData($id, \@dummy,
                                                       $metaEncoding);
        if ($status == &CDF_OK) {
          if (%globalAttrs) {
            $cdfTotal{"GlobalAttritbues"} = \%globalAttrs;
          }
        } else {
          return ($status, ());
        }
        my %variables = ();
        my $numVars;
        $status = CDFlib(&GET_, &CDF_NUMzVARS_, \$numVars,
                         &NULL_);
        my $found;
        if ($enteredVars == -1) {
          $enteredVars = $numVars;
          for ($i = 0; $i < $numVars; $i++) {
            $vars[$i] = $i;
          }
        }
        my ($k, $varNum, $varName);
        for ($k = 0; $k < $enteredVars; $k++) {
          my %varInfo = ();
          my $varInfoP;
          if (!($vars[$k] =~ /^\d+$/)) {
             $varName = $vars[$k];
             $status = CDFlib(&SELECT_, &zVAR_NAME_, $varName,
                              &GET_, &zVAR_NUMBER_, $varName, \$varNum,
                              &NULL_);
             if ($status == &CDF_OK) {
               ($status,  %varInfo) = CDFreadVar($id, $varNum, $metaEncoding,
                                                 $dataEncoding, $matrix);
               if ($status == &CDF_OK) {
                 $variables{$varName} = \%varInfo;
               } else {
                 return ($status, ());
               }
             }
          } else {
             $varNum = $vars[$k];
             $status = CDFlib(&SELECT_, &zVAR_, $varNum,
                              &GET_, &zVAR_NAME_, \$varName,
                              &NULL_);
             if ($status == &CDF_OK) {
               ($status,  %varInfo) = CDFreadVar($id, $varNum, $metaEncoding,
                                                 $dataEncoding, $matrix);
               if ($status == &CDF_OK) {
                 $variables{$varName} = \%varInfo;
               } else { 
                 return ($status, ());
               }
             } else {
               return ($status, ());
             } 
          }
        }
        if (%variables) {
          $cdfTotal{"Variables"} = \%variables;
        }

        ($status,  %noEntry) = CDFgetNoEntryAttrs($id);
        if ($status == &CDF_OK && %noEntry) {
          $cdfTotal{"NoEntryAttrs"} = \%noEntry;
        }

        if ($zmodeO != &zMODEon2) {
          $status = CDFlib(&SELECT_, &CDF_zMODE_, $zmodeO,
                           &NULL_);
        }
        if ($toClose == 1) {
          $status = CDFlib(&CLOSE_, &CDF_, 
                           &NULL_);
        }
        return (&CDF_OK, %cdfTotal); 
} # end sub CDFreadCDF

# end of CDF::CDFreadCDF
1;
