# NOTE: Derived from blib/lib/CDF.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package CDF;

#line 1646 "blib/lib/CDF.pm (autosplit into blib/lib/auto/CDF/computeTT2000.al)"
sub computeTT2000 {
        use strict;
        use Math::BigInt;
        my $year = shift;
        my $month = shift;
        my $day = shift;
        my $hour = shift;
        my $minute = shift;
        my $second = shift;
        my $milsec = shift;
        my $micsec = shift;
        my $nansec = shift;
	if (ref($year) ne "ARRAY") {
          my $tt2000Str;
          computeTT2000X ($year, $month, $day, $hour, $minute, $second, $milsec,
                          $micsec, $nansec, $tt2000Str); 
          return Math::BigInt->new($tt2000Str);
	} else {
	  my @values;
	  my @years = @$year;
	  my @months = @$month;
	  my @days = @$day;
	  my @hours = @$hour;
	  my @minutes = @$minute;
	  my @seconds = @$second;
	  my @milsecs = @$milsec;
	  my @micsecs = @$micsec;
	  my @nansecs = @$nansec;
	  $#values = $#years;
	  my $value;
	  for (my $i = 0; $i <= $#years; $i++) {
            computeTT2000X ($years[$i], $months[$i], $days[$i], $hours[$i],
			    $minutes[$i], $seconds[$i], $milsecs[$i],
                            $micsecs[$i], $nansecs[$i], $value); 
            $values[$i] = Math::BigInt->new($value);
	  }
          return @values;
	}
}#end sub computeTT2000

# end of CDF::computeTT2000
1;
