# NOTE: Derived from blib/lib/CDF.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package CDF;

#line 2431 "blib/lib/CDF.pm (autosplit into blib/lib/auto/CDF/CDFgetCDFInfo.al)"
sub CDFgetCDFInfo {
        use strict;
        my $cdf = shift;
        my $id;
        my ($numrVars, $numzVars, $status, $numgAttrs, $numvAttrs);
        my ($majority, $format, $encoding, $release, $version, $increment);
        my ($toClose, $lastleap, $cdfName);
        my %cdfInfo;
        $toClose = 0;
        if ($cdf =~ /^\d+$/) {
          $status = CDFlib(&SELECT_, &CDF_, $cdf,
                           &NULL_);
          if ($status != &CDF_OK) {
            $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                             &NULL_);
            $toClose = 1;
          }
        } else {
          $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                           &NULL_);
          $toClose = 1;
        }
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        $status = CDFlib(&GET_, &CDF_NUMrVARS_, \$numrVars,
                                &CDF_NUMzVARS_, \$numzVars,
                                &CDF_NUMgATTRS_, \$numgAttrs,
                                &CDF_NUMvATTRS_, \$numvAttrs,
                                &CDF_ENCODING_, \$encoding,
                                &CDF_FORMAT_, \$format,
                                &CDF_MAJORITY_, \$majority,
                                &CDF_RELEASE_, \$release,
                                &CDF_VERSION_, \$version,
                                &CDF_INCREMENT_, \$increment,
                                &CDF_LEAPSECONDLASTUPDATED_, \$lastleap,
                          &NULL_);
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        if ($toClose == 1) {
          $cdfInfo{"NAME"} = $cdf;
        }
#       $cdfInfo{"FORMAT"} = getFormat($format);
        $cdfInfo{"FORMAT"} = $format;
#       $cdfInfo{"MAJORITY"} = getMajority($majority);
        $cdfInfo{"MAJORITY"} = $majority;
#       $cdfInfo{"ENCODING"} = getEncoding($encoding);
        $cdfInfo{"ENCODING"} = $encoding;
        $cdfInfo{"CDF_VERSION"} = $version.".".$release.".".$increment;
        $cdfInfo{"BASED_LEAPSECOND_LAST_UPDATED"} = $lastleap;
#        $cdfInfo{"NUMrVARS"} = $numrVars;
        $cdfInfo{"NUMzVARS"} = $numzVars;
        $cdfInfo{"NUMgATTRS"} = $numgAttrs;
        $cdfInfo{"NUMvATTRS"} = $numvAttrs;
        if ($toClose == 1) {
          $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
        }
        return (&CDF_OK, %cdfInfo);
}#end sub CDFgetCDFInfo

# end of CDF::CDFgetCDFInfo
1;
