# NOTE: Derived from blib/lib/CDF.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package CDF;

#line 515 "blib/lib/CDF.pm (autosplit into blib/lib/auto/CDF/CDFlib.al)"
#############################################################################
#
#  Perl interface to CDF's internal interface CDFlib
#
#  Usage:
#     $status = CDFlib(&CREATE_, &CDF_, $CDFpath, ..., &NULL_);
#
#   Translation from the C internal interface:
#  	All variables passed by value are Perl Scalars
#              $status = CDFlib(&PUT_, &CDF_MAJORITY_, $majorty, &NULL_);
#  	All variables passed as Perl Reference to Scalars are to have values 
#       	returned
#              $status = CDFlib(&GET_, &CDF_MAJORITY_, \$majority, &NULL_);
#  	All arrays are passed by reference, regardless of whether they are 
#		returned
#  	All macro constants defined in cdf.h need to have a & prepended
#
#############################################################################
#
#   The names of the XSUB are based on the number of and datatype of the 
#   calling arguments, except for a few special cases. Used in the CDF 
#   interface is specified
#   data 
#   type  input output description 
#   ----- ----- ------ ---------------------------------------
#   array   a     1    used for long array (passed by reference) as long 
#                      varname[];
#   void 1  b     2    used for reference to an array of values as void *buffer;
#   char    c     3    used for single char as char varname; or char *varname;
#   CDFid   d     4    used for type CDFid as CDFid id; or CDFid *id; 
#                      (actually a type of void *)  
#   long    l     5    used for type long as long varname; or long *varname;
#   string  s     6    used for multiple chars as char *varname; 
#   void 2  v     7    used for reference to a single value passed as 
#                      void *value;
#
#  The letters are used for input paraneters and numbers for output
#  (The reason for doing this is to eliminate conflicts on platforms that
#   only use all upper or lower cases letters, eg PC and VMS.)
#  Parameters expecting returned values are scalar references from a Perl 
#  script calling to this package. They are dereferenced in this package
#
#############################################################################

sub CDFlib {
	use strict;
	my $operation = shift;
	my $status;

#operation (Function) block  Labelled to avoid messy elsif construct	
FCN: {
	return &CDF_OK if ($operation == &NULL_);
	
#############################################################################
# CLOSE
#############################################################################

	if ($operation == &CLOSE_) {
	  for (;;) {
	    my $item = shift;
	    if ($item == &CDF_ || $item == &rVAR_ || $item == &zVAR_) {
	 	 $status = CDFlibnone($operation, $item);
	    } else {
	      unshift (@_, $item);
	      last FCN;
	    } #end if
	    return $status if ($status != &CDF_OK);
	  } #end for
	} #end if CLOSE_
	
#############################################################################
# CONFIRM
#############################################################################

	if ($operation == &CONFIRM_) {
	  for (;;) {
	    my $item = shift;
	    if ($item == &ATTR_ || $item == &CDF_CACHESIZE_ || 
		$item == &CDF_DECODING_ ||
		$item == &CDF_NEGtoPOSfp0_MODE_ || 
		$item == &CDF_READONLY_MODE_ || $item == &CDF_STATUS_ || 
		$item == &CDF_zMODE_ || $item == &COMPRESS_CACHESIZE_ || 
		$item == &gENTRY_ || $item == &rENTRY_ || 
		$item == &rVAR_ || $item == &rVAR_CACHESIZE_ || 
		$item == &rVAR_RESERVEPERCENT_ || 
		$item == &rVARs_RECCOUNT_ || $item == &rVARs_RECINTERVAL_ || 
		$item == &rVARs_RECNUMBER_ || $item == &STAGE_CACHESIZE_ || 
		$item == &zENTRY_ || $item == &zVAR_ || 
		$item == &zVAR_CACHESIZE_ || $item == &zVAR_RECCOUNT_ || 
		$item == &zVAR_RECINTERVAL_ || $item == &zVAR_RECNUMBER_ || 
                $item == &rVARs_CACHESIZE_ || $item == &zVARs_CACHESIZE_ || 
		$item == &zVAR_RESERVEPERCENT_ ) {
		   my $LongRef = shift;
		   $status = CDFlib5($operation, $item, $$LongRef);

	    } elsif ($item == &ATTR_EXISTENCE_ || $item == &zVAR_EXISTENCE_ ||
		     $item == &rVAR_EXISTENCE_) {
			my $String = shift;
			$status = CDFlibs($operation, $item, $String);

	    } elsif ($item == &CDF_NAME_) {
			my $StringRef = shift;
			$status = CDFlib6($operation, $item, $$StringRef);

	    } elsif ($item == &CDF_ACCESS_ || $item == &CURgENTRY_EXISTENCE_ || 
		     $item == &CURrENTRY_EXISTENCE_ || 
		     $item == &CURzENTRY_EXISTENCE_ || 
		     $item == &rVAR_PADVALUE_ || $item == &zVAR_PADVALUE_ ||
		     $item == &CDF_CHECKSUM_) {
			$status = CDFlibnone($operation, $item);

	    } elsif ($item == &gENTRY_EXISTENCE_ || 
		     $item == &rENTRY_EXISTENCE_ || 
		     $item == &zENTRY_EXISTENCE_) {
			my $Long = shift;
			$status = CDFlibl($operation, $item, $Long);

	    } elsif ($item == &rVAR_SEQPOS_ || $item == &zVAR_SEQPOS_) {
			my $LongRef = shift;
			my $LongArrayRef = shift;
			$status = CDFlib51($operation, $item, $$LongRef, 
					   $LongArrayRef);
	    } elsif ($item == &rVARs_DIMCOUNTS_ || 
		     $item == &rVARs_DIMINDICES_ || 
		     $item == &rVARs_DIMINTERVALS_ || 
		     $item == &zVAR_DIMCOUNTS_ || 
		     $item == &zVAR_DIMINDICES_ || 
		     $item == &zVAR_DIMINTERVALS_) {
			my $LongArrayRef = shift;
			$status = CDFlib1($operation, $item, $LongArrayRef);

	    } elsif ($item == &CDF_) {
			my $CDFidRef = shift;
			$status = CDFlib4($operation, $item, $$CDFidRef);

	    } else {
			unshift (@_, $item);
			last FCN;
	  	   } #end if
	    return $status if ($status != &CDF_OK);
	  } #end for
	} #end if CONFIRM_
	
#############################################################################
# CREATE
#############################################################################

	if ($operation == &CREATE_) {
	  for (;;) {
		my $item = shift;
		if ($item == &ATTR_) {
			my $String = shift;
			my $Long = shift;
			my $LongRef = shift;
			$status = CDFCreateAttr($operation, $item, $String, 
						$Long, $$LongRef);
		} elsif ($item == &CDF_) {
			my $String = shift;
			my $Long = shift;
			my $ArrayRef = shift;
			my $CDFidRef = shift;
			$status = CDFCreateCDF($operation, $item, $String, 
					       $Long, $ArrayRef, $$CDFidRef);
		} elsif ($item == &rVAR_) {
			my $String = shift;
			my $Long = shift;
			my $Long1 = shift;
			my $Long2 = shift;
			my $ArrayRef = shift;
			my $LongRef = shift;
			$status = CDFCreateRvar($operation, $item, $String, 
						$Long, $Long1, $Long2, 
						$ArrayRef, $$LongRef);
		} elsif ($item == &zVAR_) {
			my $String = shift;
			my $Long = shift;
			my $Long1 = shift;
			my $Long2 = shift;
			my $ArrayRef = shift;
			my $Long3 = shift;
			my $ArrayRef1 = shift;
			my $LongRef = shift;
			$status = CDFCreateZvar($operation, $item, $String, 
						$Long, $Long1, $Long2, 
						$ArrayRef, $Long3, $ArrayRef1, 
						$$LongRef);
		} else {
			unshift (@_, $item);
			last FCN;
		} #end if
		return $status if ($status != &CDF_OK);
	   } #end for
	} #end if CREATE_
	
#############################################################################
# DELETE
#############################################################################
	
	if ($operation == &DELETE_) {
	   for (;;) {
		my $item = shift;
		if ($item == &ATTR_ || $item == &CDF_ || $item == &gENTRY_ || 
		    $item == &rENTRY_ || $item == &rVAR_ || 
		    $item == &zENTRY_ || $item == &zVAR_) {
			$status = CDFlibnone($operation, $item);

		} elsif ($item == &rVAR_RECORDS_ || $item == &zVAR_RECORDS_ ||
                         $item == &rVAR_RECORDS_RENUMBER_ ||
                         $item == &zVAR_RECORDS_RENUMBER_) {
			my $Long1 = shift;
			my $Long2 = shift;
			$status = CDFlibll($operation, $item, $Long1, $Long2);
 
		} else {
			unshift (@_, $item);
			last FCN;
		} #end if
		return $status if ($status != &CDF_OK);
	   } #end for
	} #end if DELETE_

#############################################################################
# GET
#############################################################################
	
	if ($operation == &GET_) {
	   for (;;) {
		my $item = shift;
		if ($item == &ATTR_MAXgENTRY_ || $item == &ATTR_MAXrENTRY_ || 
		    $item == &ATTR_MAXzENTRY_ || $item == &ATTR_NUMgENTRIES_ || 
		    $item == &ATTR_NUMrENTRIES_ || 
		    $item == &ATTR_NUMzENTRIES_ ||
		    $item == &ATTR_SCOPE_ || $item == &CDF_ENCODING_ || 
		    $item == &CDF_FORMAT_ || $item == &CDF_INCREMENT_ || 
		    $item == &CDF_MAJORITY_ || $item == &CDF_NUMATTRS_ ||
		    $item == &CDF_NUMgATTRS_ ||
		    $item == &CDF_NUMrVARS_ || $item == &CDF_NUMvATTRS_ || 
		    $item == &CDF_NUMzVARS_ || $item == &CDF_RELEASE_ || 
		    $item == &CDF_VERSION_ || $item == &gENTRY_DATATYPE_ ||
		    $item == &gENTRY_NUMELEMS_ || $item == &LIB_INCREMENT_ || 
		    $item == &LIB_RELEASE_ || $item == &LIB_VERSION_ || 
		    $item == &rENTRY_DATATYPE_ || $item == &rENTRY_NUMELEMS_ ||
		    $item == &rENTRY_NUMSTRINGS_ ||
		    $item == &rVAR_BLOCKINGFACTOR_ || 
		    $item == &rVAR_DATATYPE_ ||
		    $item == &rVAR_MAXallocREC_ || $item == &rVAR_MAXREC_ || 
		    $item == &rVAR_nINDEXENTRIES_ || 
		    $item == &rVAR_nINDEXLEVELS_ ||
		    $item == &rVAR_nINDEXRECORDS_ || 
		    $item == &rVAR_NUMallocRECS_ ||
		    $item == &rVAR_NUMELEMS_ || $item == &rVAR_NUMRECS_ ||
		    $item == &rVAR_RECVARY_ || $item == &rVAR_SPARSERECORDS_ || 
		    $item == &rVARs_MAXREC_ || $item == &rVARs_NUMDIMS_ || 
		    $item == &zENTRY_DATATYPE_ || $item == &zENTRY_NUMELEMS_ ||
		    $item == &zENTRY_NUMSTRINGS_ ||
		    $item == &zVAR_BLOCKINGFACTOR_ || 
		    $item == &zVAR_DATATYPE_ || 
		    $item == &zVAR_MAXallocREC_ || $item == &zVAR_MAXREC_ || 
		    $item == &zVAR_nINDEXENTRIES_ || 
		    $item == &zVAR_nINDEXLEVELS_ ||
		    $item == &zVAR_nINDEXRECORDS_ || 
		    $item == &zVAR_NUMallocRECS_ ||
		    $item == &zVAR_NUMDIMS_ || $item == &zVAR_NUMELEMS_ || 
		    $item == &zVAR_NUMRECS_ ||
		    $item == &CDF_LEAPSECONDLASTUPDATED_ ||
		    $item == &zVAR_RECVARY_ || $item == &zVAR_SPARSERECORDS_ ||
		    $item == &zVARs_MAXREC_ || $item == &CDF_CHECKSUM_) {
			my $LongRef = shift;
			$status = CDFlib5($operation, $item, $$LongRef);

		} elsif ($item == &ATTR_NAME_ || $item == &CDF_COPYRIGHT_ || 
		         $item == &LIB_COPYRIGHT_ || 
		         $item == &rVAR_NAME_ || $item == &STATUS_TEXT_ ||
		         $item == &zVAR_NAME_) {
			my $StringRef = shift;
			$status = CDFlib6($operation, $item, $$StringRef);

		} elsif ($item == &LIB_subINCREMENT_) {
			my $CharRef = shift;
			$status = CDFlib3($operation, $item, $$CharRef);

		} elsif ($item == &ATTR_NUMBER_ || $item == &rVAR_NUMBER_ || 
		         $item == &zVAR_NUMBER_) {
			my $String = shift;
			my $LongRef = shift;
			$status = CDFlibs5($operation, $item, $String, 
					   $$LongRef);

		} elsif ($item == &DATATYPE_SIZE_ || 
			 $item == &rVAR_ALLOCATEDFROM_ ||
			 $item == &rVAR_ALLOCATEDTO_ || 
			 $item == &zVAR_ALLOCATEDFROM_ ||
			 $item == &zVAR_ALLOCATEDTO_) {
			my $Long = shift;
			my $LongRef = shift;
			$status = CDFlibl5($operation, $item, $Long, $$LongRef);

		} elsif ($item == &gENTRY_DATA_ || $item == &rENTRY_DATA_ || 
		         $item == &rVAR_DATA_ || $item == &rVAR_PADVALUE_ || 
		         $item == &rVAR_SEQDATA_ || $item == &zENTRY_DATA_ ||
		         $item == &zVAR_DATA_ || $item == &zVAR_PADVALUE_ || 
			 $item == &zVAR_SEQDATA_) { 
                        my $VoidRef = shift;
			if (ref($VoidRef) eq "SCALAR") {
                          $status = CDFlib7($operation, $item, $VoidRef);
			} else {
			  $status = CDFlib7A($operation, $item, $VoidRef);
			}

		} elsif ($item == &rENTRY_STRINGSDATA_ || 
		         $item == &zENTRY_STRINGSDATA_) {
                        my $VoidRef = shift;
			$status = CDFlib8A($operation, $item, $VoidRef);

		} elsif ($item == &rVAR_HYPERDATA_ || 
			 $item == &zVAR_HYPERDATA_) {
			my $VoidArrayRef = shift;
			$status = CDFlib2($operation, $item, $VoidArrayRef);

		} elsif ($item == &rVAR_DIMVARYS_ || 
			 $item == &rVARs_DIMSIZES_ || 
		         $item == &zVAR_DIMSIZES_ || $item == &zVAR_DIMVARYS_) {
#if called for a 0 dimension z variable, a 0 is returned
# to be more Perlish, an undef would be more appropriate
			my $LongArrayRef = shift;
			$status = CDFlib1($operation, $item, $LongArrayRef);

		} elsif ($item == &rVARs_RECDATA_ || $item == &zVARs_RECDATA_) {
			my $Long = shift;
			my $LongArrayRef = shift;
			my $VoidArrayRef = shift;
			$status = CDFlibla2($operation, $item, $Long, 
					    $LongArrayRef, $VoidArrayRef);

		} elsif ($item == &CDF_COMPRESSION_ || 
			 $item == &rVAR_COMPRESSION_ ||
			 $item == &rVAR_SPARSEARRAYS_ || 
			 $item == &zVAR_COMPRESSION_ ||
			 $item == &zVAR_SPARSEARRAYS_) {
			my $Long1Ref = shift;
			my $LongArrayRef = shift;
			my $Long2Ref = shift;
			$status = CDFlib515($operation, $item, $$Long1Ref, 
					    $LongArrayRef, $$Long2Ref);

		} elsif ($item == &CDF_INFO_) {
			my $String = shift;
			my $Long1Ref = shift;
			my $LongArrayRef = shift;
			my $Long2Ref = shift;
			my $Long3Ref = shift;
			$status = CDFlibs5155($operation, $item, $String, 
					      $$Long1Ref, $LongArrayRef, 
					      $$Long2Ref, $$Long3Ref);

		} else {
			unshift (@_, $item);
			last FCN;
		} #end if
		return $status if ($status != &CDF_OK);
	   } #end for
	} #end if GET_

	
#############################################################################
# OPEN
#############################################################################
	
	if ($operation == &OPEN_) {
	   for (;;) {
		my $item = shift;
		if ($item == &CDF_) {
		  my $String = shift;
		  my $CDFidRef = shift;
		  $status = CDFlibs4($operation, $item, $String, $$CDFidRef);
		} else {
		  unshift (@_, $item);
		  last FCN;
		} #end if
		return $status if ($status != &CDF_OK);
	   } #end for
	} #end if OPEN_

#############################################################################
# PUT
#############################################################################
	
	if ($operation == &PUT_) {
	   for (;;) {
		my $item = shift;
		if ($item == &ATTR_NAME_ || $item == &rVAR_NAME_ || 
		    $item == &zVAR_NAME_) {
			my $String = shift;
			$status = CDFlibs($operation, $item, $String);

		} elsif ($item == &ATTR_SCOPE_ || $item == &CDF_ENCODING_ || 
		         $item == &CDF_FORMAT_ || $item == &CDF_MAJORITY_ || 
		         $item == &rVAR_ALLOCATERECS_ || 
			 $item == &rVAR_BLOCKINGFACTOR_ ||
		         $item == &rVAR_INITIALRECS_ || 
			 $item == &rVAR_RECVARY_ || 
			 $item == &rVAR_SPARSERECORDS_ ||
		         $item == &zVAR_ALLOCATERECS_ || 
			 $item == &zVAR_BLOCKINGFACTOR_ || 
		         $item == &zVAR_INITIALRECS_ || 
			 $item == &zVAR_RECVARY_ ||
			 $item == &zVAR_SPARSERECORDS_ || 
			 $item == &CDF_LEAPSECONDLASTUPDATED_ ||
			 $item == &CDF_CHECKSUM_) {
			my $Long = shift;
			$status = CDFlibl($operation, $item, $Long);

		} elsif ($item == &gENTRY_DATA_ || $item == &rENTRY_DATA_  || 
		         $item == &zENTRY_DATA_) {
			my $Long1 = shift;
			my $Long2 = shift;
			my $VoidData = shift;
			if ((($Long1 != &CDF_CHAR && $Long1 != &CDF_UCHAR) &&
			    ($Long2 != 1)) || ref($VoidData) eq "ARRAY") {
			  $status = CDFliblla($operation, $item, $Long1,
					      $Long2, $VoidData);
			} else {
			  $status = CDFlibllv($operation, $item, $Long1, 
					      $Long2, $VoidData);
			}

		} elsif ($item == &rENTRY_STRINGSDATA_  ||
                         $item == &zENTRY_STRINGSDATA_) {
			my $VoidData = shift;
                        my $Long1;
                        $Long1 = scalar(@$VoidData);
			$status = CDFlib8B($operation, $item, $Long1,
					   $VoidData);

		} elsif ($item == &gENTRY_DATASPEC_ || 
			 $item == &rENTRY_DATASPEC_ ||
		         $item == &rVAR_DATASPEC_ || 
			 $item == &zENTRY_DATASPEC_ || 
		         $item == &zVAR_DATASPEC_ || 
			 $item == &rVAR_ALLOCATEBLOCK_ ||
			 $item == &zVAR_ALLOCATEBLOCK_) {
			my $Long = shift;
			my $Long1 = shift;
			$status = CDFlibll($operation, $item, $Long, $Long1);

		} elsif ($item == &rVAR_DATA_ || $item == &rVAR_PADVALUE_ || 
			 $item == &rVAR_SEQDATA_ || $item == &zVAR_DATA_ ||
			 $item == &zVAR_PADVALUE_ || $item == &zVAR_SEQDATA_) {
			my $VoidRef = shift;
			if (ref($VoidRef) eq "ARRAY") {
			  $status = CDFliba($operation, $item, $VoidRef);
			} else {
			  $status = CDFlibv($operation, $item, $VoidRef);
			}
                } elsif ($item == &rVAR_HYPERDATA_ ||
                         $item == &zVAR_HYPERDATA_ ) {
                        my $VoidArrayRef = shift;
                        $status = CDFlibb($operation, $item, $VoidArrayRef);

		} elsif ($item == &rVAR_DIMVARYS_ || $item == &zVAR_DIMVARYS_) {
			my $LongArrayRef = shift;
			$status = CDFliba($operation, $item, $LongArrayRef);

		} elsif ($item == &rVARs_RECDATA_ || $item == &zVARs_RECDATA_) {
			my $Long = shift;
			my $LongArrayRef = shift;
			my $VoidArrayRef= shift;
			$status = CDFliblab($operation, $item, $Long, 
					    $LongArrayRef, $VoidArrayRef);

		} elsif ($item == &CDF_COMPRESSION_ || 
			 $item == &rVAR_COMPRESSION_ ||
			 $item == &zVAR_COMPRESSION_ || 
			 $item == &rVAR_SPARSEARRAYS_ ||
			 $item == &zVAR_SPARSEARRAYS_) {
			my $Long = shift;
			my $LongArrayRef = shift;
			$status = CDFlibla($operation, $item, $Long, 
					   $LongArrayRef);

		} else {
			unshift (@_, $item);
			last FCN;
		} #end if
		return $status if ($status != &CDF_OK);
	   } #end for
	} #end if PUT_

#############################################################################
# SELECT
#############################################################################

	if ($operation == &SELECT_) {
	   for (;;) {
		my $item = shift;
		if ($item == &ATTR_ || $item == &CDF_CACHESIZE_ || 
		    $item == &CDF_DECODING_ ||
		    $item == &CDF_NEGtoPOSfp0_MODE_ || 
		    $item == &CDF_READONLY_MODE_ || 
		    $item == &CDF_STATUS_ || $item == &CDF_zMODE_ || 
		    $item == &COMPRESS_CACHESIZE_ || $item == &gENTRY_ || 
		    $item == &rENTRY_ || $item == &rVAR_ || 
		    $item == &rVAR_CACHESIZE_ || 
		    $item == &rVAR_RESERVEPERCENT_ || 
		    $item == &rVARs_CACHESIZE_ ||
		    $item == &rVARs_RECCOUNT_ || 
		    $item == &rVARs_RECINTERVAL_ || 
		    $item == &rVARs_RECNUMBER_ ||
		    $item == &STAGE_CACHESIZE_ || 
		    $item == &zENTRY_ || $item == &zVAR_ || 
		    $item == &zVAR_CACHESIZE_ || 
		    $item == &zVAR_RECCOUNT_ || $item == &zVAR_RECINTERVAL_ || 
		    $item == &zVAR_RECNUMBER_ || 
		    $item == &zVAR_RESERVEPERCENT_ ||
		    $item == &zVARs_CACHESIZE_ || $item == &zVARs_RECNUMBER_) {
			my $Long = shift;
			$status = CDFlibl($operation, $item, $Long);

		} elsif ($item == &ATTR_NAME_ || $item == &CDF_SCRATCHDIR_ || 
			 $item == &rENTRY_NAME_ || $item == &rVAR_NAME_ || 
			 $item == &zENTRY_NAME_ || $item == &zVAR_NAME_) {
			my $String = shift;
			$status = CDFlibs($operation, $item, $String);

		} elsif ($item == &CDF_) {
#the CDFid datatype is void *. It becomes an IV in the XSUB 
			my $CDFid = shift;
			$status = CDFlibd($operation, $item, $CDFid);

		} elsif ($item == &rVAR_SEQPOS_ || $item == &zVAR_SEQPOS_) {
			my $Long = shift;
			my $LongArrayRef = shift;
			$status = CDFlibla($operation, $item, $Long, 
					   $LongArrayRef);

		} elsif ($item == &rVARs_DIMCOUNTS_ || 
			 $item == &rVARs_DIMINDICES_ || 
		         $item == &rVARs_DIMINTERVALS_ || 
			 $item == &zVAR_DIMCOUNTS_ || 
		         $item == &zVAR_DIMINDICES_ || 
			 $item == &zVAR_DIMINTERVALS_) {
			my $LongArrayRef = shift;
			$status = CDFliba($operation, $item, $LongArrayRef);

		} else {
			unshift (@_, $item);
			last FCN;
		} #end if
		return $status if ($status != &CDF_OK);
	   } #end for
	} #end if SELECT_
	
#unknown operation 
	return &BAD_FNC_OR_ITEM;
}#end FCN

#continue with next command
$status = CDF::CDFlib (@_);

} #end sub CDFlib

# end of CDF::CDFlib
1;
