# NOTE: Derived from blib/lib/CDF.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package CDF;

#line 1772 "blib/lib/CDF.pm (autosplit into blib/lib/auto/CDF/CDFgetGlobalMetaData.al)"
sub CDFgetGlobalMetaData {
        use strict;
        my @args = @_;
        my $cdf = $args[0];
        my @globals = ();
        my $enteredGlobals = -1;
        my $metaEncoding = 1;
        if (scalar(@_) > 1) {
          my $haveGlobals = $args[1];
          if ($haveGlobals) {
            if (ref($haveGlobals) eq "ARRAY") {
              if ($#$haveGlobals == -1) {
                $enteredGlobals = -1;
              } else {
                @globals = @$haveGlobals;
                $enteredGlobals = $#globals + 1;
              }
            } else {
              if (!$haveGlobals) {
                $enteredGlobals = -1;
              } else {
                if ($haveGlobals ne "ALL") {
                  @globals = split(',', $haveGlobals);
                  $enteredGlobals = $#globals + 1;
                } else {
                  $enteredGlobals = -1;
                }
              }
            }
          }
        }
        if (scalar(@_) > 2) {
          $metaEncoding = $args[2];
          if ($metaEncoding != 0) {
            $metaEncoding = 1;
          }
        }
        my $id;
        my ($toClose, $status, $cdfName, $numAttrs, $i, $scope, $attrName);
        $toClose = 0;
        my %metax = ();
        if ($cdf =~ /^\d+$/) {
          $status = CDFlib(&SELECT_, &CDF_, $cdf,
                           &NULL_);
          if ($status != &CDF_OK) {
            $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                             &NULL_);
            $toClose = 1;
          } else {
            $id = $cdf;
          }
        } else {
          $status = CDFlib(&OPEN_, &CDF_, $cdf, \$id,
                           &NULL_);
          $toClose = 1;
        }
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        $status = CDFlib (&GET_, &CDF_NUMATTRS_, \$numAttrs,
                          &NULL_);
        if ($status != &CDF_OK) {
          return ($status, ());
        }
        my $found;
        for ($i = 0; $i < $numAttrs; $i++) {
          $status = CDFlib(&SELECT_, &ATTR_, $i,
                           &GET_, &ATTR_SCOPE_, \$scope,
                                  &ATTR_NAME_, \$attrName,
                           &NULL_);
          if ($scope != &GLOBAL_SCOPE) {
            next;
          } else {
            $found = 1;
            if ($enteredGlobals != -1) {
              $found = 0;
              my $l;
              for ($l = 0; $l < $enteredGlobals; $l++) {
                if ($globals[$l] =~ /^\d+$/) {
                  if ($i == $globals[$l]) {
                    $found = 1;
                    last;
                  }
                } else {
                  if ($attrName eq $globals[$l]) {
                    $found = 1;
                    last;
                  }
                }
              }
            }
          }
          if ($found == 0) {
            next;
          } else {
            my $maxEntry;
            $status = CDFlib(&GET_, &ATTR_MAXgENTRY_, \$maxEntry,
                             &NULL_);
            if ($status != &CDF_OK || $maxEntry < 0) {
              next;
            } else {
              my ($j, $dataType, $numElems, $entry);
              my %meta2 = ();
              for ($j = 0; $j <= $maxEntry; $j++) {
                my @entry2 = ();
                $status = CDFlib(&SELECT_, &gENTRY_, $j,
                                 &GET_, &gENTRY_DATATYPE_, \$dataType,
                                        &gENTRY_NUMELEMS_, \$numElems,
                                 &NULL_);
                if ($status != &CDF_OK) {
                  next;
                }
                if ($dataType == &CDF_EPOCH16 || ($numElems > 1 &&
                                                  ($dataType != &CDF_CHAR &&
                                                   $dataType != &CDF_UCHAR))) {
                  $status = CDFlib(&GET_, &gENTRY_DATA_, \@entry2,
                                   &NULL_);
                } else {
                  $status = CDFlib(&GET_, &gENTRY_DATA_, \$entry,
                                   &NULL_);
                }
                if ($metaEncoding == 1) {
                  if ($dataType == &CDF_EPOCH) {
                    if ($numElems == 1) {
                      my $epoch;
                      toEncodeEPOCH ($entry, 4, $epoch);
                      $meta2{$j} = $epoch;
                    } else {
                      my @epoch;
                      toEncodeEPOCH (@entry2, 4, \@epoch);
                      $meta2{$j} = \@epoch;
                    }
                  } elsif ($dataType == &CDF_EPOCH16) {
                    if ($numElems == 1) {
                      my $epoch2;
                      toEncodeEPOCH16 (\@entry2, 4, $epoch2);
                      $meta2{$j} = $epoch2;
                    } else {
                      my @epoch2;
                      toEncodeEPOCH16 (\@entry2, 4, \@epoch2);
                      $meta2{$j} = \@epoch2;
                    }
                  } elsif ($dataType == &CDF_TIME_TT2000) {
                    if ($numElems == 1) {
                      my $epoch;
                      toEncodeTT2000 ($entry, 3, $epoch);
                      $meta2{$j} = $epoch;
                    } else {
                      my @epoch2;
                      toEncodeTT2000 (\@entry2, 3, \@epoch2);
                      $meta2{$j} = \@epoch2;
                    }
                  } else {
                    if ($dataType == &CDF_CHAR || $dataType == &CDF_UCHAR ||
                        $numElems == 1) { 
                      $meta2{$j} = $entry;
                    } else {
                      $meta2{$j} = \@entry2;
                    }
                  }
                } else {
                  if ($dataType == &CDF_EPOCH16 || ($dataType != &CDF_CHAR &&
                                                    $dataType != &CDF_UCHAR &&
                                                    $numElems > 1)) {
                    $meta2{$j} = \@entry2;
                  } else {
                    $meta2{$j} = $entry;
                  }
                }
              }
              $metax{$attrName} = {%meta2};
            }
          }
        }
        if ($toClose == 1) {
          $status = CDFlib(&CLOSE_, &CDF_, &NULL_);
        }
        $status = &CDF_OK;
        if (%metax) {
          return ($status, %metax);
        } else {
          return ($status, ());
        }
}#end sub CDFgetGlobalMetaData

# end of CDF::CDFgetGlobalMetaData
1;
