#!/usr/bin/perl -w

use strict;
use Math::BigInt;

BEGIN { unshift @INC,'/home/mhliu/PerlCDF38_1/blib/arch',
                     '/home/mhliu/PerlCDF38_1/blib/lib'; }
use CDF;

my $id;
my $status;

$status = CDF::CDFlib (&OPEN_, &CDF_, $ARGV[0], \$id,
		       &NULL_);
QuitCDF ("4.0", $status) if ($status < &CDF_OK) ;

my (@indices, @counts, @intervals);
my @values;
my $i;
my $dt;

$status = CDF::CDFlib (&SELECT_, &zVAR_NAME_, $ARGV[1],
                       &GET_, &zVAR_DATATYPE_, \$dt,
                       &NULL_);

QuitCDF ("28.1", $status) if ($status < &CDF_OK) ;

$indices[0] = 0;
$counts[0] = 1;
$intervals[0] = 1;
$status = CDF::CDFlib (&SELECT_, &zVAR_RECNUMBER_, 0,
                                &zVAR_RECCOUNT_, 25,
                                &zVAR_RECINTERVAL_, 1,
                                &zVAR_DIMINDICES_, \@indices,
                                &zVAR_DIMCOUNTS_, \@counts,
                                &zVAR_DIMINTERVALS_, \@intervals,
                       &GET_, &zVAR_HYPERDATA_, \@values,
		       &NULL_);

if ($status >= &CDF_OK) {
  my $num;
  my $time;
  $num = scalar(@values);
  my $add;
  my @epoch16;
  $add = 1;
if ($dt == &CDF_EPOCH16) {
  $add = 2;
}
print "num=$num vs $#values\n";
  for ($i = 0; $i < $num; $i=$i+$add) {
    if ($dt == &CDF_EPOCH) {
      CDF::encodeEPOCH4($values[$i], $time);
      print "$i: $time \n";
    } elsif ($dt == &CDF_EPOCH16) {
      $epoch16[0] = $values[$i];
      $epoch16[1] = $values[$i+1]; 
     CDF::encodeEPOCH16_4(\@epoch16, $time);
     print "$i: $time \n";
    } elsif ($dt == &CDF_TIME_TT2000) {
      CDF::encodeTT2000($values[$i], $time);
      print "$i: $time \n";
    } else {
      print "$i: $values[$i] \n";
    }
  }
}

$status = CDF::CDFlib (&CLOSE_, &CDF_,
		       &NULL_);
QuitCDF ("28.2", $status) if ($status < &CDF_OK) ;

exit;

#############################################################################
# QuitCDF.
#############################################################################
sub QuitCDF {
	my ($where, $status)=@_;

  print "Aborting at $where ...\n";
  if ($status < &CDF_OK) {
    my $text;
    CDF::CDFlib (&SELECT_, &CDF_STATUS_, $status,
		   &GET_, &STATUS_TEXT_, \$text,
		   &NULL_);
    print $text;
  }
  CDF::CDFlib (&CLOSE_, &CDF_,
	  &NULL_);
  print "...test aborted.\n";
  exit;
	
}#endsub QuitCDF

