#!/usr/bin/perl -w

use strict;
use Math::BigInt;

BEGIN { unshift @INC,'/home/mhliu/PerlCDF38_1/blib/arch',
                     '/home/mhliu/PerlCDF38_1/blib/lib'; }
use CDF;

my $N_DIMS = 2;
my $DIM_0_SIZE = 2;
my $DIM_1_SIZE = 3;

my $zN_DIMSa = 1;
my $zDIM_0_SIZEa = 5;
my $zNUM_ELEMSa = 8;

my $encoding = &NETWORK_ENCODING;
my $actual_encoding = &NETWORK_ENCODING;
my $majority = &ROW_MAJOR;
my $compression = &GZIP_COMPRESSION;
my @compressionLevel = (6);
my $numDims = $N_DIMS;
my @dimSizes = ( $DIM_0_SIZE, $DIM_1_SIZE );
my $zNumDimsA = $zN_DIMSa;
my @zDimSizesA = ( $zDIM_0_SIZEa );
my $var1DataType = &CDF_INT2;
my $var1DataTypeNew = &CDF_UINT2 ;
my $var2DataType = &CDF_REAL8 ;
my $zVarAdataType = &CDF_CHAR ;
my $zVarAdataTypeNew = &CDF_UCHAR ;
my $var1NumElements = 1 ;
my $var1NumElementsNew = 1 ;
my $var2NumElements = 1 ;
my $zVarAnumElements = $zNUM_ELEMSa ;
my $zVarAnumElementsNew = $zNUM_ELEMSa ;
my @var1Values = (1,2,3,4,5,6);
my @var2Values = (1.,2.,3.,4.,5.,6.);
my @zVarAvalues = (
  '11111111',
  '2222222',
  '333333',
  '44444',
  '5555'
);
my @entry1Values = (1,2,3,4,5,6);
my $recNum = 0 ;
my $recStart = 0 ;
my $recCount = 1 ;
my $recInterval = 1 ;
my @counts = ( $DIM_0_SIZE, $DIM_1_SIZE );
my @intervals = ( 1, 1 );
my $zRecNum =  0;
my $zRecStart =  0;
my $zRecCount =  1;
my $zRecInterval = 1 ;
my @zCounts = ( $zDIM_0_SIZEa );
my @zIntervals = ( 1 );
my $entryNum = 2 ;
my $attrScope = &GLOBAL_SCOPE ;
my $attrScope2 = &VARIABLE_SCOPE ;
my $attrScope3 = &VARIABLE_SCOPE ;
my $attrScope4 = &VARIABLE_SCOPE ;
my $entryDataType = &CDF_INT2 ;
my $entryDataTypeNew = &CDF_UINT2 ;
my $entryNumElems = 1 ;
my $entryValue = 1 ;
my $var1RecVariance = &VARY ;
my $var1RecVarianceNew = &NOVARY ;
my $var2RecVariance = &VARY ;
my $zVarArecVariance = &VARY ;
my $zVarArecVarianceNew = &NOVARY ;
my @var1DimVariances = ( &VARY, &VARY );
my @var1DimVariancesNew = ( &NOVARY, &NOVARY );
my @var2DimVariances = ( &VARY, &VARY );
my @zVarAdimVariances = ( &VARY );
my @zVarAdimVariancesNew = ( &NOVARY );
my $var1Name = "VAR1a";
my $var2Name = "VAR2a";
my $zVarAname = "zVARa1";
my $new_var1Name = "VAR1b";
my $new_var2Name = "VAR2b";
my $new_zVarAname = "zVARa2";
my $attrName = "ATTR1";
my $attrName2 = "ATTR2";
my $attrName3 = "ATTR3";
my $attrName4 = "ATTR4";
my $new_attrName = "ATTR1a";
my $rEntryValue =  4 ;
my $zEntryValue = 4.0 ;
my $pad1 = -999 ;
my $pad2 = -8.0 ;
my $pad3 =  "********" ;
my $extendRecs1 = 3;
my $extendRecs2 = 4;
my $extendRecs3 = 5;
my $allocRecs1 = 10 ;
my $allocRecs2 = 15 ;
my $allocRecs3 = 8 ;
my $nRvars = 2 ;
my @rVarNs = ( 0, 1 );
my @rVarsRecBuffer = (
  1,2,3,4,5,6,2.2,4.2,6.2,8.2,10.2,12.2
);
my $nZvars = 1 ;
my @zVarNs = ( 0 );
my @zVarsRecBuffer = (
  'aaaaaaa',
  'bbbbbb',
  'ccccc',
  'dddd',
  'eee'
);

#############################################################################
# Display title.
#############################################################################

print "\nTesting Perl-CDF Internal/C interface\n\n";

#############################################################################
# Create CDF again (previous delete will allow this).
#############################################################################
my $status;
my $x0;
my $temp1;
my $id;
my $zVarAnum_out;

$status = CDF::CDFlib (&CREATE_, &CDF_, "TESTz", $numDims, \@dimSizes, \$id,
#		       &PUT_, &CDF_ENCODING_, $encoding,
#			     &CDF_MAJORITY_, $majority,
# 			     &CDF_COMPRESSION_, $compression, \@compressionLevel,
		       &NULL_);
QuitCDF ("6.0", $status) if ($status < &CDF_OK) ;

$status = CDF::CDFlib (CREATE_, zVAR_, $zVarAname, $zVarAdataType, $zVarAnumElements,
				$zNumDimsA, \@zDimSizesA, $zVarArecVariance,
				\@zVarAdimVariances, \$zVarAnum_out,
#	       	       &PUT_, &zVAR_ALLOCATERECS_, $allocRecs3,
#			     &zVAR_BLOCKINGFACTOR_, $extendRecs3,
		       &NULL_);
QuitCDF ("7.0c", $status) if ($status < &CDF_OK) ;

$status = CDF::CDFlib (&SELECT_, &zVAR_, $zVarAnum_out,
				&zVAR_RECNUMBER_, $zRecNum,
		       &NULL_);
QuitCDF ("8.0z", $status) if ($status < &CDF_OK) ;

#my @zIndicesA;
#for ($x0 = 0; $x0 < $zDIM_0_SIZEa; $x0++) {
#   $zIndicesA[0] = $x0;
#   $temp1 = $zVarAvalues[$x0];
#print "zindice=",$zIndicesA[0], " value=", $temp1,"\n";
#   $status = CDF::CDFlib (&SELECT_, &zVAR_DIMINDICES_, \@zIndicesA,
#			  &PUT_, &zVAR_DATA_, \$temp1,
#			  &NULL_);
#   QuitCDF ("8.1z", $status) if ($status < &CDF_OK) ;
#}

my @zIndicesA;
$zIndicesA[0] = 0;
$status = CDF::CDFlib (&SELECT_, &zVAR_RECNUMBER_, $zRecStart,
                                &zVAR_RECCOUNT_, $zRecCount,
                                &zVAR_RECINTERVAL_, $zRecInterval,
                                &zVAR_DIMINDICES_, \@zIndicesA,
                                &zVAR_DIMCOUNTS_, \@zCounts,
                                &zVAR_DIMINTERVALS_, \@zIntervals,
                       &PUT_, &zVAR_HYPERDATA_, \@zVarAvalues,
                       &NULL_);
QuitCDF ("10.0z", $status) if ($status < &CDF_OK) ;

$status = CDF::CDFlib (&CLOSE_, &CDF_,
		       &NULL_);
QuitCDF ("28.2", $status) if ($status < &CDF_OK) ;

#############################################################################
# Successful completion.
#############################################################################
print "All tests completed successfully\n";
exit;

#############################################################################
# QuitCDF.
#############################################################################
sub QuitCDF {
	my ($where, $status)=@_;

  print "Aborting at $where ...\n";
  if ($status < &CDF_OK) {
    my $text;
    CDF::CDFlib (&SELECT_, &CDF_STATUS_, $status,
		   &GET_, &STATUS_TEXT_, \$text,
		   &NULL_);
    print $text;
  }
  CDF::CDFlib (&CLOSE_, &CDF_,
	  &NULL_);
  print "...test aborted.\n";
  exit;
	
}#endsub QuitCDF

#############################################################################
#  QuitEPOCH
#############################################################################
sub QuitEPOCH {
  my ($where) = @_;
  print "Aborting at $where...test aborted.\n";
  exit;

}#endsub QuitEPOCH
