/******************************************************************************
* Copyright 1996-2013 United States Government as represented by the
* Administrator of the National Aeronautics and Space Administration.
* All Rights Reserved.
******************************************************************************/

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "cdf.h"

static double
constant(name)
char *name;
{
    errno = 0;
    switch (*name) {
    case 'A':
	if (strEQ(name, "AHUFF_COMPRESSION"))
#ifdef AHUFF_COMPRESSION
	    return AHUFF_COMPRESSION;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ALPHAOSF1_DECODING"))
#ifdef ALPHAOSF1_DECODING
	    return ALPHAOSF1_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ALPHAOSF1_ENCODING"))
#ifdef ALPHAOSF1_ENCODING
	    return ALPHAOSF1_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ALPHAVMSd_DECODING"))
#ifdef ALPHAVMSd_DECODING
	    return ALPHAVMSd_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ALPHAVMSd_ENCODING"))
#ifdef ALPHAVMSd_ENCODING
	    return ALPHAVMSd_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ALPHAVMSg_DECODING"))
#ifdef ALPHAVMSg_DECODING
	    return ALPHAVMSg_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ALPHAVMSg_ENCODING"))
#ifdef ALPHAVMSg_ENCODING
	    return ALPHAVMSg_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ALPHAVMSi_DECODING"))
#ifdef ALPHAVMSi_DECODING
	    return ALPHAVMSi_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ALPHAVMSi_ENCODING"))
#ifdef ALPHAVMSi_ENCODING
	    return ALPHAVMSi_ENCODING;
#else
	    goto not_there;
#endif
        if (strEQ(name, "ARM_BIG_DECODING"))
#ifdef ARM_BIG_DECODING
            return ARM_BIG_DECODING;
#else
            goto not_there;
#endif
        if (strEQ(name, "ARM_BIG_ENCODING"))
#ifdef ARM_BIG_ENCODING
            return ARM_BIG_ENCODING;
#else
            goto not_there;
#endif
        if (strEQ(name, "ARM_LITTLE_DECODING"))
#ifdef ARM_LITTLE_DECODING
            return ARM_LITTLE_DECODING;
#else
            goto not_there;
#endif
        if (strEQ(name, "ARM_LITTLE_ENCODING"))
#ifdef ARM_LITTLE_ENCODING
            return ARM_LITTLE_ENCODING;
#else
            goto not_there;
#endif
	if (strEQ(name, "ATTR_"))
#ifdef ATTR_
	    return ATTR_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_EXISTANCE_"))
#ifdef ATTR_EXISTANCE_
	    return ATTR_EXISTANCE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_EXISTENCE_"))
#ifdef ATTR_EXISTENCE_
	    return ATTR_EXISTENCE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_EXISTS"))
#ifdef ATTR_EXISTS
	    return ATTR_EXISTS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_MAXENTRY_"))
#ifdef ATTR_MAXENTRY_
	    return ATTR_MAXENTRY_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_MAXgENTRY_"))
#ifdef ATTR_MAXgENTRY_
	    return ATTR_MAXgENTRY_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_MAXrENTRY_"))
#ifdef ATTR_MAXrENTRY_
	    return ATTR_MAXrENTRY_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_MAXzENTRY_"))
#ifdef ATTR_MAXzENTRY_
	    return ATTR_MAXzENTRY_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_NAME_"))
#ifdef ATTR_NAME_
	    return ATTR_NAME_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_NAME_TRUNC"))
#ifdef ATTR_NAME_TRUNC
	    return ATTR_NAME_TRUNC;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_NUMBER_"))
#ifdef ATTR_NUMBER_
	    return ATTR_NUMBER_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_NUMENTRIES_"))
#ifdef ATTR_NUMENTRIES_
	    return ATTR_NUMENTRIES_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_NUMgENTRIES_"))
#ifdef ATTR_NUMgENTRIES_
	    return ATTR_NUMgENTRIES_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_NUMrENTRIES_"))
#ifdef ATTR_NUMrENTRIES_
	    return ATTR_NUMrENTRIES_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_NUMzENTRIES_"))
#ifdef ATTR_NUMzENTRIES_
	    return ATTR_NUMzENTRIES_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ATTR_SCOPE_"))
#ifdef ATTR_SCOPE_
	    return ATTR_SCOPE_;
#else
	    goto not_there;
#endif
	break;
    case 'B':
	if (strEQ(name, "BADDATE_LEAPSECOND_UPDATED"))
#ifdef BADDATE_LEAPSECOND_UPDATED
	    return BADDATE_LEAPSECOND_UPDATED;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_ALLOCATE_RECS"))
#ifdef BAD_ALLOCATE_RECS
	    return BAD_ALLOCATE_RECS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_ARGUMENT"))
#ifdef BAD_ARGUMENT
	    return BAD_ARGUMENT;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_ATTR_NAME"))
#ifdef BAD_ATTR_NAME
	    return BAD_ATTR_NAME;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_ATTR_NUM"))
#ifdef BAD_ATTR_NUM
	    return BAD_ATTR_NUM;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_BLOCKING_FACTOR"))
#ifdef BAD_BLOCKING_FACTOR
	    return BAD_BLOCKING_FACTOR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_CACHE_SIZE"))
#ifdef BAD_CACHE_SIZE
	    return BAD_CACHE_SIZE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_CDFSTATUS"))
#ifdef BAD_CDFSTATUS
	    return BAD_CDFSTATUS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_CDF_EXTENSION"))
#ifdef BAD_CDF_EXTENSION
	    return BAD_CDF_EXTENSION;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_CDF_ID"))
#ifdef BAD_CDF_ID
	    return BAD_CDF_ID;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_CDF_NAME"))
#ifdef BAD_CDF_NAME
	    return BAD_CDF_NAME;
#else
	    goto not_there;
#endif
        if (strEQ(name, "BAD_CHECKSUM"))
#ifdef BAD_CHECKSUM
            return BAD_CHECKSUM;
#else
            goto not_there;
#endif
	if (strEQ(name, "BAD_COMPRESSION_PARM"))
#ifdef BAD_COMPRESSION_PARM
	    return BAD_COMPRESSION_PARM;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_DATA_TYPE"))
#ifdef BAD_DATA_TYPE
	    return BAD_DATA_TYPE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_DECODING"))
#ifdef BAD_DECODING
	    return BAD_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_DIM_COUNT"))
#ifdef BAD_DIM_COUNT
	    return BAD_DIM_COUNT;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_DIM_INDEX"))
#ifdef BAD_DIM_INDEX
	    return BAD_DIM_INDEX;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_DIM_INTERVAL"))
#ifdef BAD_DIM_INTERVAL
	    return BAD_DIM_INTERVAL;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_DIM_SIZE"))
#ifdef BAD_DIM_SIZE
	    return BAD_DIM_SIZE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_ENCODING"))
#ifdef BAD_ENCODING
	    return BAD_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_ENTRY_NUM"))
#ifdef BAD_ENTRY_NUM
	    return BAD_ENTRY_NUM;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_EXTEND_RECS"))
#ifdef BAD_EXTEND_RECS
	    return BAD_EXTEND_RECS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_FNC_OR_ITEM"))
#ifdef BAD_FNC_OR_ITEM
	    return BAD_FNC_OR_ITEM;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_FORMAT"))
#ifdef BAD_FORMAT
	    return BAD_FORMAT;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_INITIAL_RECS"))
#ifdef BAD_INITIAL_RECS
	    return BAD_INITIAL_RECS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_MAJORITY"))
#ifdef BAD_MAJORITY
	    return BAD_MAJORITY;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_MALLOC"))
#ifdef BAD_MALLOC
	    return BAD_MALLOC;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_NEGtoPOSfp0_MODE"))
#ifdef BAD_NEGtoPOSfp0_MODE
	    return BAD_NEGtoPOSfp0_MODE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_NUM_DIMS"))
#ifdef BAD_NUM_DIMS
	    return BAD_NUM_DIMS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_NUM_ELEMS"))
#ifdef BAD_NUM_ELEMS
	    return BAD_NUM_ELEMS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_NUM_STRINGS"))
#ifdef BAD_NUM_STRINGS
	    return BAD_NUM_STRINGS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_NUM_VARS"))
#ifdef BAD_NUM_VARS
	    return BAD_NUM_VARS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_READONLY_MODE"))
#ifdef BAD_READONLY_MODE
	    return BAD_READONLY_MODE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_REC_COUNT"))
#ifdef BAD_REC_COUNT
	    return BAD_REC_COUNT;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_REC_INTERVAL"))
#ifdef BAD_REC_INTERVAL
	    return BAD_REC_INTERVAL;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_REC_NUM"))
#ifdef BAD_REC_NUM
	    return BAD_REC_NUM;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_SCOPE"))
#ifdef BAD_SCOPE
	    return BAD_SCOPE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_SCRATCH_DIR"))
#ifdef BAD_SCRATCH_DIR
	    return BAD_SCRATCH_DIR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_SPARSEARRAYS_PARM"))
#ifdef BAD_SPARSEARRAYS_PARM
	    return BAD_SPARSEARRAYS_PARM;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_VAR_NAME"))
#ifdef BAD_VAR_NAME
	    return BAD_VAR_NAME;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_VAR_NUM"))
#ifdef BAD_VAR_NUM
	    return BAD_VAR_NUM;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BAD_zMODE"))
#ifdef BAD_zMODE
	    return BAD_zMODE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BLOCKINGFACTOR_TOO_SMALL"))
#ifdef BLOCKINGFACTOR_TOO_SMALL
	    return BLOCKINGFACTOR_TOO_SMALL;
#else
	    goto not_there;
#endif
	if (strEQ(name, "BLOCKINGFACTOR_TOO_SMALL2"))
#ifdef BLOCKINGFACTOR_TOO_SMALL2
	    return BLOCKINGFACTOR_TOO_SMALL2;
#else
	    goto not_there;
#endif
	break;
    case 'C':
	if (strEQ(name, "CANNOT_ALLOCATE_RECORDS"))
#ifdef CANNOT_ALLOCATE_RECORDS
	    return CANNOT_ALLOCATE_RECORDS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CANNOT_CHANGE"))
#ifdef CANNOT_CHANGE
	    return CANNOT_CHANGE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CANNOT_COMPRESS"))
#ifdef CANNOT_COMPRESS
	    return CANNOT_COMPRESS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CANNOT_INSERT_RECORDS"))
#ifdef CANNOT_INSERT_RECORDS
	    return CANNOT_INSERT_RECORDS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CANNOT_SPARSEARRAYS"))
#ifdef CANNOT_SPARSEARRAYS
	    return CANNOT_SPARSEARRAYS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CANNOT_SPARSERECORDS"))
#ifdef CANNOT_SPARSERECORDS
	    return CANNOT_SPARSERECORDS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_"))
#ifdef CDF_
	    return CDF_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_ACCESS_"))
#ifdef CDF_ACCESS_
	    return CDF_ACCESS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_BYTE"))
#ifdef CDF_BYTE
	    return CDF_BYTE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_CACHESIZE_"))
#ifdef CDF_CACHESIZE_
	    return CDF_CACHESIZE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_CHAR"))
#ifdef CDF_CHAR
	    return CDF_CHAR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_CHECKSUM_"))
#ifdef CDF_CHECKSUM_
	    return CDF_CHECKSUM_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_CLOSE_ERROR"))
#ifdef CDF_CLOSE_ERROR
	    return CDF_CLOSE_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_COMPRESSION_"))
#ifdef CDF_COMPRESSION_
	    return CDF_COMPRESSION_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_COPYRIGHT_"))
#ifdef CDF_COPYRIGHT_
	    return CDF_COPYRIGHT_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_CREATE_ERROR"))
#ifdef CDF_CREATE_ERROR
	    return CDF_CREATE_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_DECODING_"))
#ifdef CDF_DECODING_
	    return CDF_DECODING_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_DELETE_ERROR"))
#ifdef CDF_DELETE_ERROR
	    return CDF_DELETE_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_DIMCOUNTS_"))
#ifdef CDF_DIMCOUNTS_
	    return CDF_DIMCOUNTS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_DIMINDICES_"))
#ifdef CDF_DIMINDICES_
	    return CDF_DIMINDICES_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_DIMINTERVALS_"))
#ifdef CDF_DIMINTERVALS_
	    return CDF_DIMINTERVALS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_DIMSIZES_"))
#ifdef CDF_DIMSIZES_
	    return CDF_DIMSIZES_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_DOUBLE"))
#ifdef CDF_DOUBLE
	    return CDF_DOUBLE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_ENCODING_"))
#ifdef CDF_ENCODING_
	    return CDF_ENCODING_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_EPOCH"))
#ifdef CDF_EPOCH
	    return CDF_EPOCH;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_EPOCH16"))
#ifdef CDF_EPOCH16
	    return CDF_EPOCH16;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_EXISTS"))
#ifdef CDF_EXISTS
	    return CDF_EXISTS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_FLOAT"))
#ifdef CDF_FLOAT
	    return CDF_FLOAT;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_FORMAT_"))
#ifdef CDF_FORMAT_
	    return CDF_FORMAT_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_INCREMENT_"))
#ifdef CDF_INCREMENT_
	    return CDF_INCREMENT_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "CDF_INFO_"))
#ifdef CDF_INFO_
            return CDF_INFO_;
#else
            goto not_there;
#endif
	if (strEQ(name, "CDF_INT1"))
#ifdef CDF_INT1
	    return CDF_INT1;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_INT2"))
#ifdef CDF_INT2
	    return CDF_INT2;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_INT4"))
#ifdef CDF_INT4
	    return CDF_INT4;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_INT8"))
#ifdef CDF_INT8
	    return CDF_INT8;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_INTERNAL_ERROR"))
#ifdef CDF_INTERNAL_ERROR
	    return CDF_INTERNAL_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_LEAPSECONDLASTUPDATED_"))
#ifdef CDF_LEAPSECONDLASTUPDATED_
	    return CDF_LEAPSECONDLASTUPDATED_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_MAJORITY_"))
#ifdef CDF_MAJORITY_
	    return CDF_MAJORITY_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_MAXREC_"))
#ifdef CDF_MAXREC_
	    return CDF_MAXREC_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_MAX_DIMS"))
#ifdef CDF_MAX_DIMS
	    return CDF_MAX_DIMS;
#else
	    goto not_there;
#endif
        if (strEQ(name, "CDF_MAX_PARMS"))
#ifdef CDF_MAX_PARMS
            return CDF_MAX_PARMS;
#else
            goto not_there;
#endif
	if (strEQ(name, "CDF_MIN_DIMS"))
#ifdef CDF_MIN_DIMS
	    return CDF_MIN_DIMS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_NAME_"))
#ifdef CDF_NAME_
	    return CDF_NAME_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_NAME_TRUNC"))
#ifdef CDF_NAME_TRUNC
	    return CDF_NAME_TRUNC;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_NEGtoPOSfp0_MODE_"))
#ifdef CDF_NEGtoPOSfp0_MODE_
	    return CDF_NEGtoPOSfp0_MODE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_NUMATTRS_"))
#ifdef CDF_NUMATTRS_
	    return CDF_NUMATTRS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_NUMDIMS_"))
#ifdef CDF_NUMDIMS_
	    return CDF_NUMDIMS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_NUMVARS_"))
#ifdef CDF_NUMVARS_
	    return CDF_NUMVARS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_NUMgATTRS_"))
#ifdef CDF_NUMgATTRS_
	    return CDF_NUMgATTRS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_NUMrVARS_"))
#ifdef CDF_NUMrVARS_
	    return CDF_NUMrVARS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_NUMvATTRS_"))
#ifdef CDF_NUMvATTRS_
	    return CDF_NUMvATTRS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_NUMzVARS_"))
#ifdef CDF_NUMzVARS_
	    return CDF_NUMzVARS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_OK"))
#ifdef CDF_OK
	    return CDF_OK;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_OPEN_ERROR"))
#ifdef CDF_OPEN_ERROR
	    return CDF_OPEN_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_READONLY_MODE_"))
#ifdef CDF_READONLY_MODE_
	    return CDF_READONLY_MODE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_READ_ERROR"))
#ifdef CDF_READ_ERROR
	    return CDF_READ_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_REAL4"))
#ifdef CDF_REAL4
	    return CDF_REAL4;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_REAL8"))
#ifdef CDF_REAL8
	    return CDF_REAL8;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_RECCOUNT_"))
#ifdef CDF_RECCOUNT_
	    return CDF_RECCOUNT_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_RECINTERVAL_"))
#ifdef CDF_RECINTERVAL_
	    return CDF_RECINTERVAL_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_RECNUMBER_"))
#ifdef CDF_RECNUMBER_
	    return CDF_RECNUMBER_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_RELEASE_"))
#ifdef CDF_RELEASE_
	    return CDF_RELEASE_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "CDF_SCRATCHDIR_"))
#ifdef CDF_SCRATCHDIR_
            return CDF_SCRATCHDIR_;
#else
            goto not_there;
#endif
	if (strEQ(name, "CDF_STATUS_"))
#ifdef CDF_STATUS_
	    return CDF_STATUS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_TIME_TT2000"))
#ifdef CDF_TIME_TT2000
	    return CDF_TIME_TT2000;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_UCHAR"))
#ifdef CDF_UCHAR
	    return CDF_UCHAR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_UINT1"))
#ifdef CDF_UINT1
	    return CDF_UINT1;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_UINT2"))
#ifdef CDF_UINT2
	    return CDF_UINT2;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_UINT4"))
#ifdef CDF_UINT4
	    return CDF_UINT4;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_VERSION_"))
#ifdef CDF_VERSION_
	    return CDF_VERSION_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_WARN"))
#ifdef CDF_WARN
	    return CDF_WARN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_WRITE_ERROR"))
#ifdef CDF_WRITE_ERROR
	    return CDF_WRITE_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDF_zMODE_"))
#ifdef CDF_zMODE_
	    return CDF_zMODE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CDFwithSTATS_"))
#ifdef CDFwithSTATS_
	    return CDFwithSTATS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CHECKSUM_ERROR"))
#ifdef CHECKSUM_ERROR
	    return CHECKSUM_ERROR;
#else
	    goto not_there;
#endif
        if (strEQ(name, "CHECKSUM_"))
#ifdef CHECKSUM_
            return CHECKSUM_;
#else   
            goto not_there;
#endif      
        if (strEQ(name, "CHECKSUM_NOT_ALLOWED"))
#ifdef CHECKSUM_NOT_ALLOWED
            return CHECKSUM_NOT_ALLOWED;
#else
            goto not_there;
#endif
	if (strEQ(name, "CLOSE_"))
#ifdef CLOSE_
	    return CLOSE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "COLUMN_MAJOR"))
#ifdef COLUMN_MAJOR
	    return COLUMN_MAJOR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "COL_MAJOR"))
#ifdef COL_MAJOR
	    return COL_MAJOR;
#else
	    goto not_there;
#endif
        if (strEQ(name, "COMPRESSION_ERROR"))
#ifdef COMPRESSION_ERROR
            return COMPRESSION_ERROR;
#else
            goto not_there;
#endif
        if (strEQ(name, "COMPRESS_CACHESIZE_"))
#ifdef COMPRESS_CACHESIZE_
            return COMPRESS_CACHESIZE_;
#else
            goto not_there;
#endif
	if (strEQ(name, "CONFIRM_"))
#ifdef CONFIRM_
	    return CONFIRM_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CORRUPTED_V2_CDF"))
#ifdef CORRUPTED_V2_CDF
	    return CORRUPTED_V2_CDF;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CREATE_"))
#ifdef CREATE_
	    return CREATE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CURgENTRY_EXISTENCE_"))
#ifdef CURgENTRY_EXISTENCE_
	    return CURgENTRY_EXISTENCE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CURrENTRY_EXISTENCE_"))
#ifdef CURrENTRY_EXISTENCE_
	    return CURrENTRY_EXISTENCE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "CURzENTRY_EXISTENCE_"))
#ifdef CURzENTRY_EXISTENCE_
	    return CURzENTRY_EXISTENCE_;
#else
	    goto not_there;
#endif
	break;
    case 'D':
	if (strEQ(name, "DATATYPE_SIZE_"))
#ifdef DATATYPE_SIZE_
	    return DATATYPE_SIZE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "DECOMPRESSION_ERROR"))
#ifdef DECOMPRESSION_ERROR
	    return DECOMPRESSION_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "DECSTATION_DECODING"))
#ifdef DECSTATION_DECODING
	    return DECSTATION_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "DECSTATION_ENCODING"))
#ifdef DECSTATION_ENCODING
	    return DECSTATION_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "DELETE_"))
#ifdef DELETE_
	    return DELETE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "DID_NOT_COMPRESS"))
#ifdef DID_NOT_COMPRESS
	    return DID_NOT_COMPRESS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "EMPTY_COMPRESSED_CDF"))
#ifdef EMPTY_COMPRESSED_CDF
	    return EMPTY_COMPRESSED_CDF;
#else
	    goto not_there;
#endif
	break;
    case 'E':
	if (strEQ(name, "END_OF_VAR"))
#ifdef END_OF_VAR
	    return END_OF_VAR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ENTRY_"))
#ifdef ENTRY_
	    return ENTRY_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ENTRY_DATATYPE_"))
#ifdef ENTRY_DATATYPE_
	    return ENTRY_DATATYPE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ENTRY_DATA_"))
#ifdef ENTRY_DATA_
	    return ENTRY_DATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ENTRY_NUMELEMS_"))
#ifdef ENTRY_NUMELEMS_
	    return ENTRY_NUMELEMS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "EPOCH_STRING_LEN"))
#ifdef EPOCH_STRING_LEN
	    return EPOCH_STRING_LEN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "EPOCH1_STRING_LEN"))
#ifdef EPOCH1_STRING_LEN
	    return EPOCH1_STRING_LEN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "EPOCH2_STRING_LEN"))
#ifdef EPOCH2_STRING_LEN
	    return EPOCH2_STRING_LEN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "EPOCH3_STRING_LEN"))
#ifdef EPOCH3_STRING_LEN
	    return EPOCH3_STRING_LEN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "EPOCH4_STRING_LEN"))
#ifdef EPOCH4_STRING_LEN
	    return EPOCH4_STRING_LEN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "EPOCH16_STRING_LEN"))
#ifdef EPOCH16_STRING_LEN
	    return EPOCH16_STRING_LEN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "EPOCH16_1_STRING_LEN"))
#ifdef EPOCH16_1_STRING_LEN
	    return EPOCH16_1_STRING_LEN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "EPOCH16_2_STRING_LEN"))
#ifdef EPOCH16_2_STRING_LEN
	    return EPOCH16_2_STRING_LEN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "EPOCH16_3_STRING_LEN"))
#ifdef EPOCH16_3_STRING_LEN
	    return EPOCH16_3_STRING_LEN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "EPOCH16_4_STRING_LEN"))
#ifdef EPOCH16_4_STRING_LEN
	    return EPOCH16_4_STRING_LEN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "EPOCHx_FORMAT_MAX"))
#ifdef EPOCHx_FORMAT_MAX
	    return EPOCHx_FORMAT_MAX;
#else
	    goto not_there;
#endif
	if (strEQ(name, "EPOCHx_STRING_MAX"))
#ifdef EPOCHx_STRING_MAX
	    return EPOCHx_STRING_MAX;
#else
	    goto not_there;
#endif
	break;
    case 'F':
	if (strEQ(name, "FORCED_PARAMETER"))
#ifdef FORCED_PARAMETER
	    return FORCED_PARAMETER;
#else
	    goto not_there;
#endif
	if (strEQ(name, "FUNCTION_NOT_SUPPORTED"))
#ifdef FUNCTION_NOT_SUPPORTED
	    return FUNCTION_NOT_SUPPORTED;
#else
	    goto not_there;
#endif
	break;
    case 'G':
	if (strEQ(name, "GET_"))
#ifdef GET_
	    return GET_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "GLOBAL_SCOPE"))
#ifdef GLOBAL_SCOPE
	    return GLOBAL_SCOPE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "GLOBAL_SCOPE_ASSUMED"))
#ifdef GLOBAL_SCOPE_ASSUMED
	    return GLOBAL_SCOPE_ASSUMED;
#else
	    goto not_there;
#endif
	if (strEQ(name, "GZIP_COMPRESSION"))
#ifdef GZIP_COMPRESSION
	    return GZIP_COMPRESSION;
#else
	    goto not_there;
#endif
	break;
    case 'H':
	if (strEQ(name, "HOST_DECODING"))
#ifdef HOST_DECODING
	    return HOST_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "HOST_ENCODING"))
#ifdef HOST_ENCODING
	    return HOST_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "HP_DECODING"))
#ifdef HP_DECODING
	    return HP_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "HP_ENCODING"))
#ifdef HP_ENCODING
	    return HP_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "HUFF_COMPRESSION"))
#ifdef HUFF_COMPRESSION
	    return HUFF_COMPRESSION;
#else
	    goto not_there;
#endif
	break;
    case 'I':
        if (strEQ(name, "IA64VMSd_DECODING"))
#ifdef IA64VMSd_DECODING
            return IA64VMSd_DECODING;
#else
            goto not_there;
#endif
        if (strEQ(name, "IA64VMSd_ENCODING"))
#ifdef IA64VMSd_ENCODING
            return IA64VMSd_ENCODING;
#else
            goto not_there;
#endif
        if (strEQ(name, "IA64VMSg_DECODING"))
#ifdef IA64VMSg_DECODING
            return IA64VMSg_DECODING;
#else
            goto not_there;
#endif
        if (strEQ(name, "IA64VMSg_ENCODING"))
#ifdef IA64VMSg_ENCODING
            return IA64VMSg_ENCODING;
#else
            goto not_there;
#endif
        if (strEQ(name, "IA64VMSi_DECODING"))
#ifdef IA64VMSi_DECODING
            return IA64VMSi_DECODING;
#else
            goto not_there;
#endif
        if (strEQ(name, "IA64VMSi_ENCODING"))
#ifdef IA64VMSi_ENCODING
            return IA64VMSi_ENCODING;
#else
            goto not_there;
#endif
	if (strEQ(name, "IBMPC_DECODING"))
#ifdef IBMPC_DECODING
	    return IBMPC_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "IBMPC_ENCODING"))
#ifdef IBMPC_ENCODING
	    return IBMPC_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "IBMRS_DECODING"))
#ifdef IBMRS_DECODING
	    return IBMRS_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "IBMRS_ENCODING"))
#ifdef IBMRS_ENCODING
	    return IBMRS_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "IBM_PC_OVERFLOW"))
#ifdef IBM_PC_OVERFLOW
	    return IBM_PC_OVERFLOW;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ILLEGAL_EPOCH_VALUE"))
#ifdef ILLEGAL_EPOCH_VALUE
	    return ILLEGAL_EPOCH_VALUE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ILLEGAL_FOR_SCOPE"))
#ifdef ILLEGAL_FOR_SCOPE
	    return ILLEGAL_FOR_SCOPE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ILLEGAL_IN_zMODE"))
#ifdef ILLEGAL_IN_zMODE
	    return ILLEGAL_IN_zMODE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ILLEGAL_ON_V1_CDF"))
#ifdef ILLEGAL_ON_V1_CDF
	    return ILLEGAL_ON_V1_CDF;
#else
	    goto not_there;
#endif
	if (strEQ(name, "IS_A_NETCDF"))
#ifdef IS_A_NETCDF
	    return IS_A_NETCDF;
#else
	    goto not_there;
#endif
	break;
    case 'J':
	break;
    case 'K':
	break;
    case 'L':
	if (strEQ(name, "LIB_COPYRIGHT_"))
#ifdef LIB_COPYRIGHT_
	    return LIB_COPYRIGHT_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "LIB_INCREMENT_"))
#ifdef LIB_INCREMENT_
	    return LIB_INCREMENT_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "LIB_RELEASE_"))
#ifdef LIB_RELEASE_
	    return LIB_RELEASE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "LIB_VERSION_"))
#ifdef LIB_VERSION_
	    return LIB_VERSION_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "LIB_subINCREMENT_"))
#ifdef LIB_subINCREMENT_
	    return LIB_subINCREMENT_;
#else
	    goto not_there;
#endif
	break;
    case 'M':
	if (strEQ(name, "MAC_DECODING"))
#ifdef MAC_DECODING
	    return MAC_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "MAC_ENCODING"))
#ifdef MAC_ENCODING
	    return MAC_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "MD5_CHECKSUM"))
#ifdef MD5_CHECKSUM
	    return MD5_CHECKSUM;
#else
	    goto not_there;
#endif
	if (strEQ(name, "MIPSEB_ENCODING"))
#ifdef MIPSEB_ENCODING
	    return MIPSEB_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "MIPSEL_ENCODING"))
#ifdef MIPSEL_ENCODING
	    return MIPSEL_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "MULTI_FILE"))
#ifdef MULTI_FILE
	    return MULTI_FILE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "MULTI_FILE_FORMAT"))
#ifdef MULTI_FILE_FORMAT
	    return MULTI_FILE_FORMAT;
#else
	    goto not_there;
#endif
	break;
    case 'N':
	if (strEQ(name, "NA_FOR_VARIABLE"))
#ifdef NA_FOR_VARIABLE
	    return NA_FOR_VARIABLE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NEGATIVE_FP_ZERO"))
#ifdef NEGATIVE_FP_ZERO
	    return NEGATIVE_FP_ZERO;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NEGtoPOSfp0off"))
#ifdef NEGtoPOSfp0off
	    return NEGtoPOSfp0off;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NEGtoPOSfp0on"))
#ifdef NEGtoPOSfp0on
	    return NEGtoPOSfp0on;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NETWORK_DECODING"))
#ifdef NETWORK_DECODING
	    return NETWORK_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NETWORK_ENCODING"))
#ifdef NETWORK_ENCODING
	    return NETWORK_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NOT_A_CDF"))
#ifdef NOT_A_CDF
	    return NOT_A_CDF;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NOT_SUPPORT_ENCODING"))
#ifdef NOT_SUPPORT_ENCODING
	    return NOT_SUPPORT_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NOVARY"))
#ifdef NOVARY
	    return NOVARY;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_ATTR_SELECTED"))
#ifdef NO_ATTR_SELECTED
	    return NO_ATTR_SELECTED;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_CDF_SELECTED"))
#ifdef NO_CDF_SELECTED
	    return NO_CDF_SELECTED;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_CHECKSUM"))
#ifdef NO_CHECKSUM
	    return NO_CHECKSUM;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_COMPRESSION"))
#ifdef NO_COMPRESSION
	    return NO_COMPRESSION;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_DELETE_ACCESS"))
#ifdef NO_DELETE_ACCESS
	    return NO_DELETE_ACCESS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_ENTRY_SELECTED"))
#ifdef NO_ENTRY_SELECTED
	    return NO_ENTRY_SELECTED;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_MORE_ACCESS"))
#ifdef NO_MORE_ACCESS
	    return NO_MORE_ACCESS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_PADVALUE_SPECIFIED"))
#ifdef NO_PADVALUE_SPECIFIED
	    return NO_PADVALUE_SPECIFIED;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_SPARSEARRAYS"))
#ifdef NO_SPARSEARRAYS
	    return NO_SPARSEARRAYS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_SPARSERECORDS"))
#ifdef NO_SPARSERECORDS
	    return NO_SPARSERECORDS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_STATUS_SELECTED"))
#ifdef NO_STATUS_SELECTED
	    return NO_STATUS_SELECTED;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_SUCH_ATTR"))
#ifdef NO_SUCH_ATTR
	    return NO_SUCH_ATTR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_SUCH_CDF"))
#ifdef NO_SUCH_CDF
	    return NO_SUCH_CDF;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_SUCH_ENTRY"))
#ifdef NO_SUCH_ENTRY
	    return NO_SUCH_ENTRY;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_SUCH_RECORD"))
#ifdef NO_SUCH_RECORD
	    return NO_SUCH_RECORD;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_SUCH_VAR"))
#ifdef NO_SUCH_VAR
	    return NO_SUCH_VAR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_VARS_IN_CDF"))
#ifdef NO_VARS_IN_CDF
	    return NO_VARS_IN_CDF;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_VAR_SELECTED"))
#ifdef NO_VAR_SELECTED
	    return NO_VAR_SELECTED;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NO_WRITE_ACCESS"))
#ifdef NO_WRITE_ACCESS
	    return NO_WRITE_ACCESS;
#else
	    goto not_there;
#endif
        if (strEQ(name, "NONE_CHECKSUM"))
#ifdef NONE_CHECKSUM
            return NONE_CHECKSUM;
#else
            goto not_there;
#endif
	if (strEQ(name, "NULL_"))
#ifdef NULL_
	    return NULL_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NeXT_DECODING"))
#ifdef NeXT_DECODING
	    return NeXT_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "NeXT_ENCODING"))
#ifdef NeXT_ENCODING
	    return NeXT_ENCODING;
#else
	    goto not_there;
#endif
	break;
    case 'O':
	if (strEQ(name, "OPEN_"))
#ifdef OPEN_
	    return OPEN_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "OPTIMAL_ENCODING_TREES"))
#ifdef OPTIMAL_ENCODING_TREES
	    return OPTIMAL_ENCODING_TREES;
#else
	    goto not_there;
#endif
	break;
    case 'P':
        if (strEQ(name, "PAD_SPARSERECORDS"))
#ifdef PAD_SPARSERECORDS
            return PAD_SPARSERECORDS;
#else
            goto not_there;
#endif
        if (strEQ(name, "PRECEEDING_RECORDS_ALLOCATED"))
#ifdef PRECEEDING_RECORDS_ALLOCATED
            return PRECEEDING_RECORDS_ALLOCATED;
#else
            goto not_there;
#endif
        if (strEQ(name, "PREV_SPARSERECORDS"))
#ifdef PREV_SPARSERECORDS
            return PREV_SPARSERECORDS;
#else
            goto not_there;
#endif
	if (strEQ(name, "PUT_"))
#ifdef PUT_
	    return PUT_;
#else
	    goto not_there;
#endif
	break;
    case 'Q':
	break;
    case 'R':
	if (strEQ(name, "READONLYoff"))
#ifdef READONLYoff
	    return READONLYoff;
#else
	    goto not_there;
#endif
	if (strEQ(name, "READONLYon"))
#ifdef READONLYon
	    return READONLYon;
#else
	    goto not_there;
#endif
	if (strEQ(name, "READ_ONLY_DISTRIBUTION"))
#ifdef READ_ONLY_DISTRIBUTION
	    return READ_ONLY_DISTRIBUTION;
#else
	    goto not_there;
#endif
	if (strEQ(name, "READ_ONLY_MODE"))
#ifdef READ_ONLY_MODE
	    return READ_ONLY_MODE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "RESERVED_CDFSTATUS"))
#ifdef RESERVED_CDFSTATUS
	    return RESERVED_CDFSTATUS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "RLE_COMPRESSION"))
#ifdef RLE_COMPRESSION
	    return RLE_COMPRESSION;
#else
	    goto not_there;
#endif
	if (strEQ(name, "RLE_OF_ZEROs"))
#ifdef RLE_OF_ZEROs
	    return RLE_OF_ZEROs;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ROW_MAJOR"))
#ifdef ROW_MAJOR
	    return ROW_MAJOR;
#else
	    goto not_there;
#endif
        break;
    case 'S':
        if (strEQ(name, "SCRATCH_CREATE_ERROR"))
#ifdef SCRATCH_CREATE_ERROR
            return SCRATCH_CREATE_ERROR;
#else
            goto not_there;
#endif
        if (strEQ(name, "SCRATCH_DELETE_ERROR"))
#ifdef SCRATCH_DELETE_ERROR
            return SCRATCH_DELETE_ERROR;
#else
            goto not_there;
#endif
        if (strEQ(name, "SCRATCH_READ_ERROR"))
#ifdef DASCRATCH_READ_ERROR
            return SCRATCH_READ_ERROR;
#else
            goto not_there;
#endif
        if (strEQ(name, "SCRATCH_WRITE_ERROR"))
#ifdef SCRATCH_WRITE_ERROR
            return SCRATCH_WRITE_ERROR;
#else
            goto not_there;
#endif
	if (strEQ(name, "SELECT_"))
#ifdef SELECT_
	    return SELECT_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SGi_DECODING"))
#ifdef SGi_DECODING
	    return SGi_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SGi_ENCODING"))
#ifdef SGi_ENCODING
	    return SGi_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SINGLE_FILE"))
#ifdef SINGLE_FILE
	    return SINGLE_FILE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SINGLE_FILE_FORMAT"))
#ifdef SINGLE_FILE_FORMAT
	    return SINGLE_FILE_FORMAT;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SOME_ALREADY_ALLOCATED"))
#ifdef SOME_ALREADY_ALLOCATED
	    return SOME_ALREADY_ALLOCATED;
#else
	    goto not_there;
#endif
	if (strEQ(name, "STAGE_CACHESIZE_"))
#ifdef STAGE_CACHESIZE_
	    return STAGE_CACHESIZE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "STATUS_TEXT_"))
#ifdef STATUS_TEXT_
	    return STATUS_TEXT_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "STRING_NOT_UTF8_ENCODING"))
#ifdef STATUS_TEXT_
	    return STRING_NOT_UTF8_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SUN_DECODING"))
#ifdef SUN_DECODING
	    return SUN_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "SUN_ENCODING"))
#ifdef SUN_ENCODING
	    return SUN_ENCODING;
#else
	    goto not_there;
#endif
	break;
    case 'T':
	if (strEQ(name, "TRY_TO_READ_NONSTRING_DATA"))
#ifdef TRY_TO_READ_NONSTRING_DATA
	    return TRY_TO_READ_NONSTRING_DATA;
#else
	    goto not_there;
	if (strEQ(name, "TOO_MANY_PARMS"))
#ifdef TOO_MANY_PARMS
	    return TOO_MANY_PARMS;
#else
	    goto not_there;
#endif
#endif
	if (strEQ(name, "TOO_MANY_VARS"))
#ifdef TOO_MANY_VARS
	    return TOO_MANY_VARS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "TT2000_0_STRING_LEN"))
#ifdef TT2000_0_STRING_LEN
	    return TT2000_0_STRING_LEN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "TT2000_1_STRING_LEN"))
#ifdef TT2000_1_STRING_LEN
	    return TT2000_1_STRING_LEN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "TT2000_2_STRING_LEN"))
#ifdef TT2000_2_STRING_LEN
	    return TT2000_2_STRING_LEN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "TT2000_3_STRING_LEN"))
#ifdef TT2000_3_STRING_LEN
	    return TT2000_3_STRING_LEN;
#else
	    goto not_there;
#endif
	if (strEQ(name, "TT2000_CDF_MAYNEEDUPDATE"))
#ifdef TT2000_CDF_MAYNEEDUPDATE
	    return TT2000_CDF_MAYNEEDUPDATE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "TT2000_TIME_ERROR"))
#ifdef TT2000_TIME_ERROR
	    return TT2000_TIME_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "TT2000_USED_OUTDATED_TABLE"))
#ifdef TT2000_USED_OUTDATED_TABLE
	    return TT2000_USED_OUTDATED_TABLE;
#else
	    goto not_there;
#endif
	break;
    case 'U':
	if (strEQ(name, "UNABLE_TO_PROCESS_CDF"))
#ifdef UNABLE_TO_PROCESS_CDF
	    return UNABLE_TO_PROCESS_CDF;
#else
	    goto not_there;
#endif
	if (strEQ(name, "UNICODE_ENCODING_NOT_DEFINED"))
#ifdef UNICODE_ENCODING_NOT_DEFINED
	    return UNICODE_ENCODING_NOT_DEFINED;
#else
	    goto not_there;
#endif
	if (strEQ(name, "UNKNOWN_COMPRESSION"))
#ifdef UNKNOWN_COMPRESSION
	    return UNKNOWN_COMPRESSION;
#else
	    goto not_there;
#endif
        if (strEQ(name, "UNKNOWN_SPARSENESS"))
#ifdef UNKNOWN_SPARSENESS
            return UNKNOWN_SPARSENESS;
#else
            goto not_there;
#endif
        if (strEQ(name, "UNSUPPORTED_OPERATION"))
#ifdef UNSUPPORTED_OPERATION
            return UNSUPPORTED_OPERATION;
#else
            goto not_there;
#endif
	break;
    case 'V':
	if (strEQ(name, "VALIDATEFILEoff"))
#ifdef VALIDATEFILEoff
	    return VALIDATEFILEoff;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VALIDATEFILEon"))
#ifdef VALIDATEFILEon
	    return VALIDATEFILEon;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VARIABLE_SCOPE"))
#ifdef VARIABLE_SCOPE
	    return VARIABLE_SCOPE;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VARIABLE_SCOPE_ASSUMED"))
#ifdef VARIABLE_SCOPE_ASSUMED
	    return VARIABLE_SCOPE_ASSUMED;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VARY"))
#ifdef VARY
	    return VARY;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_"))
#ifdef VAR_
	    return VAR_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_ALREADY_CLOSED"))
#ifdef VAR_ALREADY_CLOSED
	    return VAR_ALREADY_CLOSED;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_CLOSE_ERROR"))
#ifdef VAR_CLOSE_ERROR
	    return VAR_CLOSE_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_CREATE_ERROR"))
#ifdef VAR_CREATE_ERROR
	    return VAR_CREATE_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_DATASPEC_"))
#ifdef VAR_DATASPEC_
	    return VAR_DATASPEC_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_DATATYPE_"))
#ifdef VAR_DATATYPE_
	    return VAR_DATATYPE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_DATA_"))
#ifdef VAR_DATA_
	    return VAR_DATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_DELETE_ERROR"))
#ifdef VAR_DELETE_ERROR
	    return VAR_DELETE_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_DIMVARYS_"))
#ifdef VAR_DIMVARYS_
	    return VAR_DIMVARYS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_EXISTS"))
#ifdef VAR_EXISTS
	    return VAR_EXISTS;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_EXTENDRECS_"))
#ifdef VAR_EXTENDRECS_
	    return VAR_EXTENDRECS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_FILLVALUE_"))
#ifdef VAR_FILLVALUE_
	    return VAR_FILLVALUE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_HYPERDATA_"))
#ifdef VAR_HYPERDATA_
	    return VAR_HYPERDATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_INITIALRECS_"))
#ifdef VAR_INITIALRECS_
	    return VAR_INITIALRECS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_MAXREC_"))
#ifdef VAR_MAXREC_
	    return VAR_MAXREC_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_NAME_"))
#ifdef VAR_NAME_
	    return VAR_NAME_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_NAME_TRUNC"))
#ifdef VAR_NAME_TRUNC
	    return VAR_NAME_TRUNC;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_NUMBER_"))
#ifdef VAR_NUMBER_
	    return VAR_NUMBER_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_NUMELEMS_"))
#ifdef VAR_NUMELEMS_
	    return VAR_NUMELEMS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_OPEN_ERROR"))
#ifdef VAR_OPEN_ERROR
	    return VAR_OPEN_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_READ_ERROR"))
#ifdef VAR_READ_ERROR
	    return VAR_READ_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_RECVARY_"))
#ifdef VAR_RECVARY_
	    return VAR_RECVARY_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_SEQDATA_"))
#ifdef VAR_SEQDATA_
	    return VAR_SEQDATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_SEQPOS_"))
#ifdef VAR_SEQPOS_
	    return VAR_SEQPOS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAR_WRITE_ERROR"))
#ifdef VAR_WRITE_ERROR
	    return VAR_WRITE_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAX_DECODING"))
#ifdef VAX_DECODING
	    return VAX_DECODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VAX_ENCODING"))
#ifdef VAX_ENCODING
	    return VAX_ENCODING;
#else
	    goto not_there;
#endif
	if (strEQ(name, "VIRTUAL_RECORD_DATA"))
#ifdef VIRTUAL_RECORD_DATA
	    return VIRTUAL_RECORD_DATA;
#else
	    goto not_there;
#endif
	break;
    case 'W':
	break;
    case 'X':
	break;
    case 'Y':
	break;
    case 'Z':
	if (strEQ(name, "ZLIB_COMPRESS_ERROR"))
#ifdef ZLIB_COMPRESS_ERROR
	    return ZLIB_COMPRESS_ERROR;
#else
	    goto not_there;
#endif
	if (strEQ(name, "ZLIB_UNCOMPRESS_ERROR"))
#ifdef ZLIB_UNCOMPRESS_ERROR
	    return ZLIB_UNCOMPRESS_ERROR;
#else
	    goto not_there;
#endif
	break;
    case 'a':
	break;
    case 'b':
	break;
    case 'c':
	break;
    case 'd':
	break;
    case 'e':
	break;
    case 'f':
	break;
    case 'g':
	if (strEQ(name, "gENTRY_"))
#ifdef gENTRY_
	    return gENTRY_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "gENTRY_DATASPEC_"))
#ifdef gENTRY_DATASPEC_
	    return gENTRY_DATASPEC_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "gENTRY_DATATYPE_"))
#ifdef gENTRY_DATATYPE_
	    return gENTRY_DATATYPE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "gENTRY_DATA_"))
#ifdef gENTRY_DATA_
	    return gENTRY_DATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "gENTRY_EXISTANCE_"))
#ifdef gENTRY_EXISTANCE_
	    return gENTRY_EXISTANCE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "gENTRY_EXISTENCE_"))
#ifdef gENTRY_EXISTENCE_
	    return gENTRY_EXISTENCE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "gENTRY_NUMELEMS_"))
#ifdef gENTRY_NUMELEMS_
	    return gENTRY_NUMELEMS_;
#else
	    goto not_there;
#endif
	break;
    case 'h':
	break;
    case 'i':
	break;
    case 'j':
	break;
    case 'k':
	break;
    case 'l':
	break;
    case 'm':
	break;
    case 'n':
	break;
    case 'o':
	break;
    case 'p':
	break;
    case 'q':
	break;
    case 'r':
	if (strEQ(name, "rENTRY_"))
#ifdef rENTRY_
	    return rENTRY_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rENTRY_DATASPEC_"))
#ifdef rENTRY_DATASPEC_
	    return rENTRY_DATASPEC_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rENTRY_DATATYPE_"))
#ifdef rENTRY_DATATYPE_
	    return rENTRY_DATATYPE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rENTRY_DATA_"))
#ifdef rENTRY_DATA_
	    return rENTRY_DATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rENTRY_EXISTANCE_"))
#ifdef rENTRY_EXISTANCE_
	    return rENTRY_EXISTANCE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rENTRY_EXISTENCE_"))
#ifdef rENTRY_EXISTENCE_
	    return rENTRY_EXISTENCE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rENTRY_NAME_"))
#ifdef rENTRY_NAME_
	    return rENTRY_NAME_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rENTRY_NUMELEMS_"))
#ifdef rENTRY_NUMELEMS_
	    return rENTRY_NUMELEMS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rENTRY_NUMSTRINGS_"))
#ifdef rENTRY_NUMSTRINGS_
	    return rENTRY_NUMSTRINGS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rENTRY_STRINGSDATA_"))
#ifdef rENTRY_STRINGSDATA_
	    return rENTRY_STRINGSDATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_"))
#ifdef rVAR_
	    return rVAR_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "rVAR_ALLOCATEBLOCK_"))
#ifdef rVAR_ALLOCATEBLOCK_
            return rVAR_ALLOCATEBLOCK_;
#else
            goto not_there;
#endif
        if (strEQ(name, "rVAR_ALLOCATEDFROM_"))
#ifdef rVAR_ALLOCATEDFROM_
            return rVAR_ALLOCATEDFROM_;
#else
            goto not_there;
#endif
        if (strEQ(name, "rVAR_ALLOCATEDTO_"))
#ifdef rVAR_ALLOCATEDTO_
            return rVAR_ALLOCATEDTO_;
#else
            goto not_there;
#endif
	if (strEQ(name, "rVAR_ALLOCATERECS_"))
#ifdef rVAR_ALLOCATERECS_
	    return rVAR_ALLOCATERECS_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "rVAR_BLOCKINGFACTOR_"))
#ifdef rVAR_BLOCKINGFACTOR_
            return rVAR_BLOCKINGFACTOR_;
#else
            goto not_there;
#endif
	if (strEQ(name, "rVAR_CACHESIZE_"))
#ifdef rVAR_CACHESIZE_
	    return rVAR_CACHESIZE_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "rVAR_COMPRESSION_"))
#ifdef rVAR_COMPRESSION_
            return rVAR_COMPRESSION_;
#else
            goto not_there;
#endif
	if (strEQ(name, "rVAR_DATASPEC_"))
#ifdef rVAR_DATASPEC_
	    return rVAR_DATASPEC_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_DATATYPE_"))
#ifdef rVAR_DATATYPE_
	    return rVAR_DATATYPE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_DATA_"))
#ifdef rVAR_DATA_
	    return rVAR_DATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_DIMVARYS_"))
#ifdef rVAR_DIMVARYS_
	    return rVAR_DIMVARYS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_EXISTANCE_"))
#ifdef rVAR_EXISTANCE_
	    return rVAR_EXISTANCE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_EXISTENCE_"))
#ifdef rVAR_EXISTENCE_
	    return rVAR_EXISTENCE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_EXTENDRECS_"))
#ifdef rVAR_EXTENDRECS_
	    return rVAR_EXTENDRECS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_HYPERDATA_"))
#ifdef rVAR_HYPERDATA_
	    return rVAR_HYPERDATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_INITIALRECS_"))
#ifdef rVAR_INITIALRECS_
	    return rVAR_INITIALRECS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_MAXREC_"))
#ifdef rVAR_MAXREC_
	    return rVAR_MAXREC_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_MAXallocREC_"))
#ifdef rVAR_MAXallocREC_
	    return rVAR_MAXallocREC_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_NAME_"))
#ifdef rVAR_NAME_
	    return rVAR_NAME_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_NUMBER_"))
#ifdef rVAR_NUMBER_
	    return rVAR_NUMBER_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_NUMELEMS_"))
#ifdef rVAR_NUMELEMS_
	    return rVAR_NUMELEMS_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "rVAR_NUMRECS_"))
#ifdef rVAR_NUMRECS_
            return rVAR_NUMRECS_;
#else
            goto not_there;
#endif
        if (strEQ(name, "rVAR_NUMallocRECS_"))
#ifdef rVAR_NUMallocRECS_
            return rVAR_NUMallocRECS_;
#else
            goto not_there;
#endif
	if (strEQ(name, "rVAR_PADVALUE_"))
#ifdef rVAR_PADVALUE_
	    return rVAR_PADVALUE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_RECORDS_"))
#ifdef rVAR_RECORDS_
	    return rVAR_RECORDS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_RECORDS_RENUMBER_"))
#ifdef rVAR_RECORDS_RENUMBER_
	    return rVAR_RECORDS_RENUMBER_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "rVAR_RECVARY_"))
#ifdef rVAR_RECVARY_
            return rVAR_RECVARY_;
#else
            goto not_there;
#endif
        if (strEQ(name, "rVAR_RESERVEPERCENT_"))
#ifdef rVAR_RESERVEPERCENT_
            return rVAR_RESERVEPERCENT_;
#else
            goto not_there;
#endif
    	if (strEQ(name, "rVAR_SEQDATA_"))
#ifdef rVAR_SEQDATA_
	    return rVAR_SEQDATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_SEQPOS_"))
#ifdef rVAR_SEQPOS_
	    return rVAR_SEQPOS_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "rVAR_SPARSEARRAYS_"))
#ifdef rVAR_SPARSEARRAYS_
            return rVAR_SPARSEARRAYS_;
#else
            goto not_there;
#endif
        if (strEQ(name, "rVAR_SPARSERECORDS_"))
#ifdef rVAR_SPARSERECORDS_
            return rVAR_SPARSERECORDS_;
#else
            goto not_there;
#endif
	if (strEQ(name, "rVAR_nINDEXENTRIES_"))
#ifdef rVAR_nINDEXENTRIES_
	    return rVAR_nINDEXENTRIES_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVAR_nINDEXLEVELS_"))
#ifdef rVAR_nINDEXLEVELS_
	    return rVAR_nINDEXLEVELS_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "rVAR_nINDEXRECORDS_"))
#ifdef rVAR_nINDEXRECORDS_
            return rVAR_nINDEXRECORDS_;
#else
            goto not_there;
#endif
	if (strEQ(name, "rVARs_CACHESIZE_"))
#ifdef rVARs_CACHESIZE_
	    return rVARs_CACHESIZE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVARs_DIMCOUNTS_"))
#ifdef rVARs_DIMCOUNTS_
	    return rVARs_DIMCOUNTS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVARs_DIMINDICES_"))
#ifdef rVARs_DIMINDICES_
	    return rVARs_DIMINDICES_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVARs_DIMINTERVALS_"))
#ifdef rVARs_DIMINTERVALS_
	    return rVARs_DIMINTERVALS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVARs_DIMSIZES_"))
#ifdef rVARs_DIMSIZES_
	    return rVARs_DIMSIZES_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVARs_MAXREC_"))
#ifdef rVARs_MAXREC_
	    return rVARs_MAXREC_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVARs_NUMDIMS_"))
#ifdef rVARs_NUMDIMS_
	    return rVARs_NUMDIMS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVARs_RECCOUNT_"))
#ifdef rVARs_RECCOUNT_
	    return rVARs_RECCOUNT_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVARs_RECDATA_"))
#ifdef rVARs_RECDATA_
	    return rVARs_RECDATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVARs_RECINTERVAL_"))
#ifdef rVARs_RECINTERVAL_
	    return rVARs_RECINTERVAL_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "rVARs_RECNUMBER_"))
#ifdef rVARs_RECNUMBER_
	    return rVARs_RECNUMBER_;
#else
	    goto not_there;
#endif
	break;
    case 's':
	break;
    case 't':
	break;
    case 'u':
	break;
    case 'v':
	break;
    case 'w':
	break;
    case 'x':
	break;
    case 'y':
	break;
    case 'z':
	if (strEQ(name, "zENTRY_"))
#ifdef zENTRY_
	    return zENTRY_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zENTRY_DATASPEC_"))
#ifdef zENTRY_DATASPEC_
	    return zENTRY_DATASPEC_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zENTRY_DATATYPE_"))
#ifdef zENTRY_DATATYPE_
	    return zENTRY_DATATYPE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zENTRY_DATA_"))
#ifdef zENTRY_DATA_
	    return zENTRY_DATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zENTRY_EXISTANCE_"))
#ifdef zENTRY_EXISTANCE_
	    return zENTRY_EXISTANCE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zENTRY_EXISTENCE_"))
#ifdef zENTRY_EXISTENCE_
	    return zENTRY_EXISTENCE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zENTRY_NAME_"))
#ifdef zENTRY_NAME_
	    return zENTRY_NAME_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zENTRY_NUMELEMS_"))
#ifdef zENTRY_NUMELEMS_
	    return zENTRY_NUMELEMS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zENTRY_NUMSTRINGS_"))
#ifdef zENTRY_NUMSTRINGS_
	    return zENTRY_NUMSTRINGS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zENTRY_STRINGSDATA_"))
#ifdef zENTRY_STRINGSDATA_
	    return zENTRY_STRINGSDATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zMODEoff"))
#ifdef zMODEoff
	    return zMODEoff;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zMODEon1"))
#ifdef zMODEon1
	    return zMODEon1;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zMODEon2"))
#ifdef zMODEon2
	    return zMODEon2;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_"))
#ifdef zVAR_
	    return zVAR_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "zVAR_ALLOCATEBLOCK_"))
#ifdef zVAR_ALLOCATEBLOCK_
            return zVAR_ALLOCATEBLOCK_;
#else
            goto not_there;
#endif
        if (strEQ(name, "zVAR_ALLOCATEDFROM_"))
#ifdef zVAR_ALLOCATEDFROM_
            return zVAR_ALLOCATEDFROM_;
#else
            goto not_there;
#endif
        if (strEQ(name, "zVAR_ALLOCATEDTO_"))
#ifdef zVAR_ALLOCATEDTO_
            return zVAR_ALLOCATEDTO_;
#else
            goto not_there;
#endif
	if (strEQ(name, "zVAR_ALLOCATERECS_"))
#ifdef zVAR_ALLOCATERECS_
	    return zVAR_ALLOCATERECS_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "zVAR_BLOCKINGFACTOR_"))
#ifdef zVAR_BLOCKINGFACTOR_
            return zVAR_BLOCKINGFACTOR_;
#else
            goto not_there;
#endif
	if (strEQ(name, "zVAR_CACHESIZE_"))
#ifdef zVAR_CACHESIZE_
	    return zVAR_CACHESIZE_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "zVAR_COMPRESSION_"))
#ifdef zVAR_COMPRESSION_
            return zVAR_COMPRESSION_;
#else
            goto not_there;
#endif
	if (strEQ(name, "zVAR_DATASPEC_"))
#ifdef zVAR_DATASPEC_
	    return zVAR_DATASPEC_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_DATATYPE_"))
#ifdef zVAR_DATATYPE_
	    return zVAR_DATATYPE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_DATA_"))
#ifdef zVAR_DATA_
	    return zVAR_DATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_DIMCOUNTS_"))
#ifdef zVAR_DIMCOUNTS_
	    return zVAR_DIMCOUNTS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_DIMINDICES_"))
#ifdef zVAR_DIMINDICES_
	    return zVAR_DIMINDICES_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_DIMINTERVALS_"))
#ifdef zVAR_DIMINTERVALS_
	    return zVAR_DIMINTERVALS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_DIMSIZES_"))
#ifdef zVAR_DIMSIZES_
	    return zVAR_DIMSIZES_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_DIMVARYS_"))
#ifdef zVAR_DIMVARYS_
	    return zVAR_DIMVARYS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_EXISTANCE_"))
#ifdef zVAR_EXISTANCE_
	    return zVAR_EXISTANCE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_EXISTENCE_"))
#ifdef zVAR_EXISTENCE_
	    return zVAR_EXISTENCE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_EXTENDRECS_"))
#ifdef zVAR_EXTENDRECS_
	    return zVAR_EXTENDRECS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_HYPERDATA_"))
#ifdef zVAR_HYPERDATA_
	    return zVAR_HYPERDATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_INITIALRECS_"))
#ifdef zVAR_INITIALRECS_
	    return zVAR_INITIALRECS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_MAXREC_"))
#ifdef zVAR_MAXREC_
	    return zVAR_MAXREC_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_MAXallocREC_"))
#ifdef zVAR_MAXallocREC_
	    return zVAR_MAXallocREC_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_NAME_"))
#ifdef zVAR_NAME_
	    return zVAR_NAME_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_NUMBER_"))
#ifdef zVAR_NUMBER_
	    return zVAR_NUMBER_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_NUMDIMS_"))
#ifdef zVAR_NUMDIMS_
	    return zVAR_NUMDIMS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_NUMELEMS_"))
#ifdef zVAR_NUMELEMS_
	    return zVAR_NUMELEMS_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "zVAR_NUMRECS_"))
#ifdef zVAR_NUMRECS_
            return zVAR_NUMRECS_;
#else
            goto not_there;
#endif
        if (strEQ(name, "zVAR_NUMallocRECS_"))
#ifdef zVAR_NUMallocRECS_
            return zVAR_NUMallocRECS_;
#else
            goto not_there;
#endif
	if (strEQ(name, "zVAR_PADVALUE_"))
#ifdef zVAR_PADVALUE_
	    return zVAR_PADVALUE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_RECCOUNT_"))
#ifdef zVAR_RECCOUNT_
	    return zVAR_RECCOUNT_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_RECINTERVAL_"))
#ifdef zVAR_RECINTERVAL_
	    return zVAR_RECINTERVAL_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_RECNUMBER_"))
#ifdef zVAR_RECNUMBER_
	    return zVAR_RECNUMBER_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "zVAR_RECORDS_"))
#ifdef zVAR_RECORDS_
            return zVAR_RECORDS_;
#else
            goto not_there;
#endif
        if (strEQ(name, "zVAR_RECORDS_RENUMBER_"))
#ifdef zVAR_RECORDS_RENUMBER_
            return zVAR_RECORDS_RENUMBER_;
#else
            goto not_there;
#endif
	if (strEQ(name, "zVAR_RECVARY_"))
#ifdef zVAR_RECVARY_
	    return zVAR_RECVARY_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "zVAR_RESERVEPERCENT_"))
#ifdef zVAR_RESERVEPERCENT_
            return zVAR_RESERVEPERCENT_;
#else
            goto not_there;
#endif
	if (strEQ(name, "zVAR_SEQDATA_"))
#ifdef zVAR_SEQDATA_
	    return zVAR_SEQDATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_SEQPOS_"))
#ifdef zVAR_SEQPOS_
	    return zVAR_SEQPOS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVAR_SPARSEARRAYS_"))
#ifdef zVAR_SPARSEARRAYS_
	    return zVAR_SPARSEARRAYS_;
#else
	    goto not_there;
#endif
        if (strEQ(name, "zVAR_SPARSERECORDS_"))
#ifdef zVAR_SPARSERECORDS_
            return zVAR_SPARSERECORDS_;
#else
            goto not_there;
#endif
        if (strEQ(name, "zVAR_nINDEXENTRIES_"))
#ifdef zVAR_nINDEXENTRIES_
            return zVAR_nINDEXENTRIES_;
#else
            goto not_there;
#endif
        if (strEQ(name, "zVAR_nINDEXLEVELS_"))
#ifdef zVAR_nINDEXLEVELS_
            return zVAR_nINDEXLEVELS_;
#else
            goto not_there;
#endif
	if (strEQ(name, "zVAR_nINDEXRECORDS_"))
#ifdef zVAR_nINDEXRECORDS_
	    return zVAR_nINDEXRECORDS_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVARs_CACHESIZE_"))
#ifdef zVARs_CACHESIZE_
	    return zVARs_CACHESIZE_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVARs_MAXREC_"))
#ifdef zVARs_MAXREC_
	    return zVARs_MAXREC_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVARs_RECDATA_"))
#ifdef zVARs_RECDATA_
	    return zVARs_RECDATA_;
#else
	    goto not_there;
#endif
	if (strEQ(name, "zVARs_RECNUMBER_"))
#ifdef zVARs_RECNUMBER_
	    return zVARs_RECNUMBER_;
#else
	    goto not_there;
#endif
	break;
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;   
    return 0;
}

MODULE = CDF		PACKAGE = CDF

double
constant(name)
	char *	name

CDFstatus
CDFlibnone(operation, item)
	long	operation
	long	item
	CODE:
		RETVAL = CDFlib(operation, item, NULL_);
	OUTPUT:
	RETVAL
	
CDFstatus
CDFlibs(operation, item, AnyString)
	long	operation
	long	item
	char *	AnyString
  	CODE:
 		RETVAL = CDFlib(operation, item, AnyString, NULL_);
	OUTPUT:
	RETVAL
	
CDFstatus
CDFlib6(operation, item, AnyString)
	long	operation
	long	item
	char *	AnyString = NO_INIT
  	CODE:
	{
	  	char temp[CDF_COPYRIGHT_LEN+1]; 
	  	AnyString = temp;
		RETVAL = CDFlib(operation, item, AnyString, NULL_);
	}	  
	OUTPUT:
	AnyString
	RETVAL

CDFstatus
CDFlib3(operation, item, AnyChar)
	long	operation
	long	item
	char 	AnyChar = NO_INIT
  	CODE:
		RETVAL = CDFlib(operation, item, &AnyChar, NULL_);
	OUTPUT:
	AnyChar
	RETVAL

CDFstatus
CDFlibs5(operation, item, AnyString, AnyLong)
	long	operation
	long	item
	char *	AnyString
	long	AnyLong = NO_INIT
	CODE:
 		RETVAL = CDFlib(operation, item, AnyString, &AnyLong, NULL_);
	OUTPUT:
	AnyLong
	RETVAL

CDFstatus
CDFlibs4(operation, item, CDFpath, AnyId)
	long	operation
	long	item
	char *	CDFpath
	CDFid	AnyId = NO_INIT
  	CODE:
 		RETVAL = CDFlib(operation, item, CDFpath, &AnyId, NULL_);
	OUTPUT:
	AnyId
	RETVAL
	
CDFstatus
CDFlibd(operation, item, AnyId)
	long	operation
	long	item
	CDFid	AnyId
  	CODE:
 		RETVAL = CDFlib(operation, item, AnyId, NULL_);
	OUTPUT:
	RETVAL

CDFstatus		
CDFlib4(operation, item, AnyId)
        long    operation
        long    item
        CDFid   AnyId = NO_INIT
        CODE:
                RETVAL = CDFlib(operation, item, &AnyId, NULL_);
        OUTPUT:
	AnyId
        RETVAL

CDFstatus
CDFlibl(operation, item, AnyLong)
	long	operation
	long	item
	long	AnyLong
  	CODE:
 		RETVAL = CDFlib(operation, item, AnyLong, NULL_);
	OUTPUT:
	RETVAL
	
CDFstatus
CDFlibl5(operation, item, AnyLong, AnotherLong)
	long	operation
	long	item
	long	AnyLong
	long	AnotherLong = NO_INIT
  	CODE:
 		RETVAL = CDFlib(operation, item, AnyLong, &AnotherLong, NULL_);
	OUTPUT:
	AnotherLong
	RETVAL
	
CDFstatus
CDFlibll(operation, item, AnyLong, AnotherLong)
	long	operation
	long	item
	long	AnyLong
	long	AnotherLong
  	CODE:
 		RETVAL = CDFlib(operation, item, AnyLong, AnotherLong, NULL_);
	OUTPUT:
	RETVAL
	
CDFstatus
CDFlibla(operation, item, AnyLong, ArrayRef)
	long	operation
	long	item
	long	AnyLong
	AV *	ArrayRef
	CODE:
	{
	  	long LongArray[CDF_MAX_DIMS]; 
		I32 count, i;
		count = (int) av_len(ArrayRef); 
		if (count < 0) 
		  printf(" Put compression/sparsearray: No values specified\n");
		else {
		  for ( i=0 ; i<=count ; i++) 
		    LongArray[i] = (long)SvIV(*(av_fetch(ArrayRef, i, 0)));
		}
		RETVAL = CDFlib(operation, item, AnyLong, LongArray, NULL_);
	}
	OUTPUT:
	RETVAL
	
CDFstatus
CDFlibllv(operation, item, DataType, numElems, DataRef)
	long	operation
	long	item
	long	DataType
	long	numElems
	SV *	DataRef = NO_INIT
	CODE:
	{
	  I32 i;
	  STRLEN len;
          RETVAL = 0;
	  DataRef = (SV *) SvRV(ST(4));
	  switch (DataType) {
  	    case CDF_UCHAR:
  	    case CDF_CHAR:  {
  	    	char * buffer;
  	    	New(42, buffer, numElems+1, char); 
                strncpy(buffer, SvPV(DataRef, len), numElems);
                *(buffer+numElems) = '\0';
		if ((int) strlen(buffer) < (int) numElems) {
		  for (i=(int)strlen(buffer); i<(int)numElems; i++)
                    buffer[i] = '\0';
		}
		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer); 
	  	break;
  	    }
/*
  	    case CDF_UCHAR:  {
  	    	void * buffer;
  	    	New(42, buffer, numElems+1, unsigned char);
                strncpy((char *)buffer, SvPV(DataRef, len), numElems);
                if ((int) strlen((char *)buffer) < (int) numElems) {
                  for (i=(int)strlen((char *)buffer); i<(int)numElems; i++) 
			*(((char *)buffer)+i) = '\0';
                  *(((char *)buffer)+numElems) = '\0';
                }
		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer);
	  	break;
  	    }
*/
  	    case CDF_BYTE:
  	    case CDF_INT1:  {
  	    	I8 buffer;
	  	buffer = (I8) SvIV(DataRef);
		RETVAL = CDFlib(operation, item, DataType, numElems, &buffer, 
				NULL_);
	  	break;
  	    }
  	    case CDF_UINT1: { 
  	    	U8 buffer;
	  	buffer = (U8) SvIV(DataRef);
		RETVAL = CDFlib(operation, item, DataType, numElems, &buffer, 
				NULL_);
	  	break;
  	    }
  	    case CDF_EPOCH:
  	    case CDF_DOUBLE:
  	    case CDF_REAL8: {
  	 	double buffer;
 	  	buffer = (double) SvNV(DataRef);
		RETVAL = CDFlib(operation, item, DataType, numElems, &buffer, 
				NULL_);
	 	break; 
  	    }
/*
  	    case CDF_EPOCH16: {
  	 	double buffer[2];
                buffer[0] = (double) SvNV(*(av_fetch(DataRef, 0, 0)));
                buffer[1] = (double) SvNV(*(av_fetch(DataRef, 1, 0)));
		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer);
	 	break; 
  	    }
*/
  	    case CDF_REAL4:
  	    case CDF_FLOAT: {
  	 	float buffer;
 	  	buffer = (float) SvNV(DataRef);
		RETVAL = CDFlib(operation, item, DataType, numElems, &buffer, 
				NULL_);
  	 	break;
  	    }
   	    case CDF_INT4:  {
  	 	I32 buffer;
 	   	buffer = (I32) SvIV(DataRef);
		RETVAL = CDFlib(operation, item, DataType, numElems, &buffer, 
				NULL_);
  	 	break;
   	    }
   	    case CDF_INT8:
   	    case CDF_TIME_TT2000:  {
  	 	long long buffer;
                if (SvIOK(DataRef)) {
                  buffer = (long long) SvIV(DataRef);
                } else if (SvNOK(DataRef)) {
                  buffer = (long long) SvNV(DataRef);
                } else {
                  sscanf(SvPV_nolen(DataRef),"%lld",&buffer);
                }
		RETVAL = CDFlib(operation, item, DataType, numElems, &buffer, 
				NULL_);
  	 	break;
   	    }
   	    case CDF_UINT4:  {
  	 	U32 buffer;
 	  	buffer = (U32) SvIV(DataRef);
		RETVAL = CDFlib(operation, item, DataType, numElems, &buffer, 
				NULL_);
  	 	break;
   	    }
  	    case CDF_INT2:  {
  	 	I16 buffer;
 	   	buffer = (I16) SvIV(DataRef);
		RETVAL = CDFlib(operation, item, DataType, numElems, &buffer, 
				NULL_);
  	 	break;
  	    }
  	    case CDF_UINT2:  {
  	 	U16 buffer;
 	   	buffer = (U16) SvIV(DataRef);
		RETVAL = CDFlib(operation, item, DataType, numElems, &buffer, 
				NULL_);
  	 	break;
  	    }
  	    default: {
  	 	printf ("PUT attribute information: Bad Datatype = %ld \n", 
			DataType);
  	    }
  	  }
 	}
	OUTPUT:
	RETVAL
	
CDFstatus
CDFliblla(operation, item, DataType, numElems, ArrayRef)
	long	operation
	long	item
	long	DataType
	long	numElems
	AV *    ArrayRef
	CODE:
	{
	  I32 count, i, j;
          RETVAL = 0;
	  count = (int) av_len(ArrayRef)+1;
	  if (count < 1)
	    printf(" Put Entry data: No values specified\n");
	  switch (DataType) {
  	    case CDF_UCHAR:
  	    case CDF_CHAR:  {
		char * buffer;
		char * temp;
		STRLEN len;
		New(42, buffer, numElems*count+1, char); 
		New(42, temp, numElems+1, char);
	        for (i=0 ; i < count; i++) {
	           strncpy(temp, SvPV(*(av_fetch(ArrayRef, i, 0)), len),
	                   numElems+1);
                   *(temp+numElems) = '\0';
	           if ((int) strlen(temp) < (int) numElems) {
	             for (j=(int)strlen(temp); j<(int)numElems; j++)
                       temp[j] = '\0';
	           }
	           strncpy(buffer+i*numElems, temp, numElems);
	        }

		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer); 
		Safefree(temp); 
	  	break;
	    }
/*
	    case CDF_UCHAR:  {
  	    	void * buffer;
		void * temp;
		STRLEN len;
  	    	New(42, buffer, numElems*count+1, unsigned char);
		New(42, temp, numElems+1, unsigned char);
                for (i=0 ; i < count; i++) {
                   strncpy((char *)temp, SvPV(*(av_fetch(ArrayRef, i, 0)), len),
                           numElems+1);
                   if ((int) strlen((char *)temp) < (int) numElems) {
                     for (j=(int)strlen((char *)temp); j<(int)numElems; j++)
                        *(((char *)temp)+j) = '\0';
                     *(((char *)temp)+numElems) = '\0';
                   }
                   strncpy((char *)buffer+i*numElems, temp, numElems+1);
                }

		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer);
		Safefree(temp); 
	  	break;
  	    }
*/
  	    case CDF_BYTE:
  	    case CDF_INT1:  {
  	    	I8 * buffer;
  	    	New(42, buffer, count, I8); 
                for (i=0 ; i < count; i++)
                   buffer[i] = (I8) SvIV(*(av_fetch(ArrayRef, i, 0)));

		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer); 
	  	break;
  	    }
  	    case CDF_UINT1: { 
  	    	U8 * buffer;
  	    	New(42, buffer, count, U8); 
                for (i=0 ; i < count; i++)
                   buffer[i] = (U8) SvIV(*(av_fetch(ArrayRef, i, 0)));

		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer); 
	  	break;
  	    }
  	    case CDF_EPOCH:
  	    case CDF_DOUBLE:
  	    case CDF_REAL8: {
  	 	double * buffer;
  	 	New(42, buffer, count, double);
                for (i=0 ; i < count; i++)
                   buffer[i] = (double) SvNV(*(av_fetch(ArrayRef, i, 0)));

		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer);
	 	break; 
  	    }
  	    case CDF_EPOCH16: {
  	 	double * buffer;
  	 	New(42, buffer, 2*count, double);
                for (i=0 ; i < 2*count; i++)
		   buffer[i] = (double) SvNV(*(av_fetch(ArrayRef, i, 0)));	

		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer);
	 	break; 
  	    }
  	    case CDF_REAL4:
  	    case CDF_FLOAT: {
  	 	float * buffer;
  	 	New(42, buffer, count, float);
                for (i=0 ; i < count; i++)
                   buffer[i] = (float) SvNV(*(av_fetch(ArrayRef, i, 0)));

		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer);
  	 	break;
  	    }
   	    case CDF_INT4:  {
  	 	I32 * buffer;
  	 	New(42, buffer, count, I32);
                for (i=0 ; i < count; i++)
                   buffer[i] = (I32) SvIV(*(av_fetch(ArrayRef, i, 0)));

		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer);
  	 	break;
   	    }
   	    case CDF_INT8:
   	    case CDF_TIME_TT2000:  {
  	 	double * buffer;
                SV **value;
                long long tmp;
  	 	New(42, buffer, count, double);
                for (i=0 ; i < count; i++) {
                  value = av_fetch(ArrayRef, i, 0);
                  if (SvIOK(*value)) {
                    tmp = (long long) SvIV(*value);
                  } else if (SvNOK(*value)) {
                    tmp = (long long) SvNV(*value);
                  } else {
                    sscanf(SvPV_nolen(*value),"%lld",&tmp);
                  }
                  memcpy (buffer+i, &tmp, 8);
                }
		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer);
  	 	break;
   	    }
   	    case CDF_UINT4:  {
  	 	U32 * buffer;
  	 	New(42, buffer, count, U32);
                for (i=0 ; i < count; i++)
                   buffer[i] = (U32) SvIV(*(av_fetch(ArrayRef, i, 0)));

		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer);
  	 	break;
   	    }
  	    case CDF_INT2:  {
  	 	I16 * buffer;
  	 	New(42, buffer, count, I16);
                for (i=0 ; i < count; i++) {
                   buffer[i] = (I16) SvIV(*(av_fetch(ArrayRef, i, 0)));
		}

		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer);
  	 	break;
  	    }
  	    case CDF_UINT2:  {
  	 	U16 * buffer;
  	 	New(42, buffer, count, U16);
                for (i=0 ; i < count; i++)
                   buffer[i] = (U16) SvIV(*(av_fetch(ArrayRef, i, 0)));

		RETVAL = CDFlib(operation, item, DataType, numElems, buffer, 
				NULL_);
	 	Safefree(buffer);
  	 	break;
  	    }
  	    default: {
  	 	printf ("PUT attribute information: Bad Datatype = %ld \n", 
			DataType);
  	    }
  	  }
	}
	OUTPUT:
	RETVAL
	
CDFstatus
CDFliblab(operation, item, AnyLong, ArrayRef, DataRef)
	long	operation
	long	item
	long	AnyLong
	AV *	ArrayRef
	AV *	DataRef
  	CODE:
	{
	  long Varnum[1];
	  long dimsizes[CDF_MAX_DIMS], numdims, DataType, numElems;
          long dimVarys[CDF_MAX_DIMS]; 
	  CDFstatus status = CDF_OK;
	  I32 i, j, idx;
	  I32 numValues=1;
          RETVAL = 0;
	  idx = 0;
	  for ( i=0; i<AnyLong; i++) {
	    Varnum[0] = (long) SvIV(*(av_fetch(ArrayRef, i, 0)));
	    if (item == rVARs_RECDATA_) 
		status = CDFlib(SELECT_, rVAR_, Varnum[0], 
				GET_, rVAR_DATATYPE_, &DataType,
				      rVAR_NUMELEMS_, &numElems,
                                      rVAR_DIMVARYS_, dimVarys,
				      rVARs_NUMDIMS_, &numdims,
				      rVARs_DIMSIZES_, dimsizes, NULL_);
	    else
                status = CDFlib(SELECT_, zVAR_, Varnum[0],
				GET_, zVAR_DATATYPE_, &DataType,
                                      zVAR_NUMELEMS_, &numElems,
                                      zVAR_DIMVARYS_, dimVarys,
                                      zVAR_NUMDIMS_, &numdims,
                                      zVAR_DIMSIZES_, dimsizes, NULL_);
            if (status == CDF_OK) {
	      numValues = 1;
	      for (j=0; j < numdims; j++) 
		if (dimVarys[j]) numValues *=dimsizes[j];
	      switch (DataType) {
               case CDF_UCHAR:
  	       case CDF_CHAR:  {
  	    	 char * buffer; char * temp;
		 STRLEN len;
  	    	 New(42, buffer, numElems*numValues+1, char);
  	    	 New(42, temp, numElems+1, char);
                 for (j=0; j<numValues; j++) {
	  	   strncpy(temp, SvPV(*(av_fetch(DataRef, idx+j, 0)), len),
			   numElems);
                   *(temp+numElems) = '\0';
		   if ((int) strlen(temp) < (int) numElems) {
		     int ix;
		     for (ix=(int)strlen(temp); ix<(int)numElems; ix++)
                       temp[ix] = '\0';
		   }
		   strncpy(buffer+j*numElems, temp, numElems);
		 }
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
		 idx += numValues;
	 	 Safefree(buffer);
	 	 Safefree(temp);
	  	 break;
  	       }
/*
  	       case CDF_UCHAR:  {
  	    	 void * buffer; 
		 void * temp;
		 STRLEN len;
  	    	 New(42, buffer, numElems*numValues+1, U8);
  	    	 New(42, temp, numElems+1, U8);
                 for (j=0; j<numValues; j++) {
	  	   strncpy((char *)temp, SvPV(*(av_fetch(DataRef, idx+j, 0)), len),
		 	   numElems+1);
                   if ((int) strlen((char *)temp) < (int) numElems) {
                     int ix;
                     for (ix=(int)strlen((char *)temp); ix<(int)numElems; ix++) 
			 *(((char *)temp)+ix) = '\0';
                     *(((char *) temp)+numElems) = '\0';
                   }
                   strncpy((char *)buffer+j*numElems, (char *)temp, numElems+1);
		 }
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
		 idx += numValues;
	 	 Safefree(buffer);
	 	 Safefree(temp);
	  	 break;
  	       }
*/
  	       case CDF_BYTE:
  	       case CDF_INT1:  {
  	    	 I8 * buffer;
  	    	 New(42, buffer, numValues, I8);
                 for (j=0; j<numValues; j++) 
	  	   buffer[j] = (I8) SvIV(*(av_fetch(DataRef, idx+j, 0))); 
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
                 idx += numValues;
	 	 Safefree(buffer);
	  	 break;
  	       }
  	       case CDF_UINT1: {
  	    	 U8 * buffer;
  	    	 New(42, buffer, numValues, U8);
                 for (j=0; j<numValues; j++) 
	  	   buffer[j] = (U8) SvIV(*(av_fetch(DataRef, idx+j, 0))); 
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
                 idx += numValues;
	 	 Safefree(buffer);
	  	 break;
  	       }
  	       case CDF_DOUBLE:
  	       case CDF_REAL8: {
  	 	 double * buffer;
  	 	 New(42, buffer, numValues, double);
  	 	 for (j=0; j<numValues; j++) 
 	  	   buffer[j] = (double) SvNV(*(av_fetch(DataRef, idx+j, 0)));
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
                 idx += numValues;
	 	 Safefree(buffer);
	 	 break; 
  	       } 
  	       case CDF_REAL4:
  	       case CDF_FLOAT: {
  	 	 float * buffer; 
  	 	 New(42, buffer, numValues, float);
  	 	 for (j=0; j<numValues; j++) 
 	   	   buffer[j] = (float) SvNV(*(av_fetch(DataRef, idx+j, 0)));
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
                 idx += numValues;
	 	 Safefree(buffer);
  	 	 break;
  	       }
   	       case CDF_INT4:  {
  	 	 I32 * buffer;
  	 	 New(42, buffer, numValues, I32);
  	 	 for (j=0; j<numValues; j++) 
 	   	   buffer[j] = (I32) SvIV(*(av_fetch(DataRef, idx+j, 0)));
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
                 idx += numValues;
	 	 Safefree(buffer);
  	 	 break;
   	       }
   	       case CDF_INT8:
   	       case CDF_TIME_TT2000:  {
                 double * buffer;
                 SV **value;
                 long long tmp;
                 New(42, buffer, numValues, double);
                 for (j=0 ; j < numValues; j++) {
                   value = av_fetch(ArrayRef, idx+j, 0);
                   if (SvIOK(*value)) {
                     tmp = (long long) SvIV(*value);
                   } else if (SvNOK(*value)) {
                     tmp = (long long) SvNV(*value);
                   } else {
                     sscanf(SvPV_nolen(*value),"%lld",&tmp);
                   }
                   memcpy (buffer+j, &tmp, 8);
                 }
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
                 idx += numValues;
	 	 Safefree(buffer);
  	 	 break;
   	       }
   	       case CDF_UINT4:  {
  	 	 U32 * buffer;
  	 	 New(42, buffer, numValues, U32);
  	 	 for (j=0; j<numValues; j++) 
 	   	   buffer[j] = (U32) SvIV(*(av_fetch(DataRef, idx+j, 0)));
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
                 idx += numValues;
	 	 Safefree(buffer);
  	 	 break;
   	       }
  	       case CDF_INT2:  {
  	 	 I16 * buffer;
  	 	 New(42, buffer, numValues, I16);
  	 	 for (j=0; j<numValues; j++) 
 	   	   buffer[j] = (I16) SvIV(*(av_fetch(DataRef, idx+j, 0)));
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
                 idx += numValues;
	 	 Safefree(buffer);
  	 	 break;
  	       }
  	       case CDF_UINT2:  {
  	 	 U16 * buffer;
  	 	 New(42, buffer, numValues, U16);
  	 	 for (j=0; j<numValues; j++) 
 	   	   buffer[j] = (U16) SvIV(*(av_fetch(DataRef, idx+j, 0)));
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
		 idx += numValues;
	 	 Safefree(buffer);
  	 	 break;
  	       }
  	       default:
  	 	 printf ("PUT RECDATA: Bad Datatype = %ld \n", DataType);
	      }
	    } else {
              RETVAL = status;
              break;
            }
          }
	}
	OUTPUT:
	RETVAL	
	
CDFstatus
CDFlibla2(operation, item, AnyLong, ArrayRef, DataRef)
	long	operation
	long	item
	long	AnyLong
	AV *	ArrayRef
	AV *	DataRef
  	CODE:
	{
	  long Varnum[1];
	  CDFstatus status = CDF_OK;
	  I32 i, j; 
	  long DataType, numElems, numDims, dimSizes[CDF_MAX_DIMS];
	  long numValues, dimVarys[CDF_MAX_DIMS];
          RETVAL = 0;
	  for ( i=0 ; i<AnyLong ; i++) {
	    Varnum[0] = (long)SvIV(*(av_fetch(ArrayRef, i, 0)));
	    if (item == rVARs_RECDATA_) 
		status = CDFlib(SELECT_, rVAR_, Varnum[0], 
				GET_, rVAR_DATATYPE_, &DataType,
				      rVAR_NUMELEMS_, &numElems, 
                                      rVAR_DIMVARYS_, dimVarys,
                                      rVARs_NUMDIMS_, &numDims,
                                      rVARs_DIMSIZES_, dimSizes,
				NULL_);
	    else
                status = CDFlib(SELECT_, zVAR_, Varnum[0],
				GET_, zVAR_DATATYPE_, &DataType,
                                      zVAR_NUMELEMS_, &numElems, 
                                      zVAR_DIMVARYS_, dimVarys,
                                      zVAR_NUMDIMS_, &numDims,
                                      zVAR_DIMSIZES_, dimSizes,
 				NULL_);
            if (status == CDF_OK) {
	      numValues = 1;  
	      for (j=0; j<numDims; j++) 
		if (dimVarys[j]) numValues *= dimSizes[j]; 
	      switch (DataType) {
  	       case CDF_UCHAR:
  	       case CDF_CHAR:  {
                 int x, iend;
  	    	 char * buffer, *temp;
  	    	 New(42, buffer, numElems*numValues+1, char);
  	    	 New(42, temp, numElems+1, char);
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
                 *(buffer+numElems*numValues) = '\0';
		 for (j=0; j<numValues; j++) {
                   memcpy(temp, buffer+j*numElems, numElems);
                   *(temp+numElems) = '\0';
                   iend = numElems;
                   for (x = 0; x < numElems; ++x) {
                     if (*(temp+x) == '\0') {
                       iend = x;
                       break;
                     }
                   }
                   av_push(DataRef, newSVpv((char *) temp, iend));
                 }
	 	 Safefree(buffer);
	 	 Safefree(temp);
	  	 break;
  	       }
/*
  	       case CDF_UCHAR:  {
  	    	 void * buffer;
  	    	 New(42, buffer, numElems*numValues+1, U8);
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
                 for (j=0; j<numValues; j++)
                   av_push(DataRef, newSVpv((char *)buffer+j*numElems,
				 	     numElems));
	 	 Safefree(buffer);
	  	 break;
  	       }
*/
  	       case CDF_BYTE:
  	       case CDF_INT1:  {
  	    	 I8 * buffer;
  	    	 New(42, buffer, numValues, I8);
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
                 for (j=0; j<numValues; j++)
                   av_push(DataRef, newSViv((I8) buffer[j]));
	 	 Safefree(buffer);
	  	 break;
  	       }
  	       case CDF_UINT1: {
  	    	 U8 * buffer;
  	    	 New(42, buffer, numValues, U8);
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
                 for (j=0; j<numValues; j++)
                   av_push(DataRef, newSViv((U8) buffer[j]));
	 	 Safefree(buffer);
	  	 break;
  	       }
  	       case CDF_EPOCH:
  	       case CDF_DOUBLE:
  	       case CDF_REAL8: {
  	 	 double * buffer;
  	 	 New(42, buffer, numValues, double);
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
  	 	 for (j=0; j<numValues; j++) 
                   av_push(DataRef, newSVnv(buffer[j]));
	 	 Safefree(buffer);
	 	 break; 
  	       }
  	       case CDF_EPOCH16: {
  	 	 double * buffer;
  	 	 New(42, buffer, 2*numValues, double);
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
  	 	 for (j=0; j<2*numValues; j++) 
                   av_push(DataRef, newSVnv(buffer[j]));
	 	 Safefree(buffer);
	 	 break; 
  	       }
  	       case CDF_REAL4:
  	       case CDF_FLOAT: {
  	 	 float * buffer;
  	 	 New(42, buffer, numValues, float);
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
  	 	 for (j=0; j<numValues; j++) 
                   av_push(DataRef, newSVnv((double)buffer[j]));
	 	 Safefree(buffer);
  	 	 break;
  	       }
   	       case CDF_INT4:  {
  	 	 I32 * buffer;
  	 	 New(42, buffer, numValues, I32);
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
  	 	 for (j=0; j<numValues; j++) 
                   av_push(DataRef, newSViv((IV)buffer[j]));
	 	 Safefree(buffer);
  	 	 break;
   	       }
   	       case CDF_INT8:
   	       case CDF_TIME_TT2000:  {
  	 	 double * buffer;
                 long long tmp;
                 char str[25];
  	 	 New(42, buffer, numValues, double);
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
                 for (j=0 ; j < numValues; j++) {
                   memcpy (&tmp, buffer+j, 8);
                   snprintf(str, 24, "%lld", tmp);
                   av_push(DataRef, newSVpv(str, strlen(str)));
                 }
	 	 Safefree(buffer);
  	 	 break;
   	       }
   	       case CDF_UINT4:  {
  	 	 U32 * buffer;
  	 	 New(42, buffer, numValues, U32);
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
  	 	 for (j=0; j<numValues; j++) 
                   av_push(DataRef, newSViv((IV)buffer[j]));
	 	 Safefree(buffer);
  	 	 break;
   	       }
  	       case CDF_INT2:  {
  	 	 I16 * buffer;
  	 	 New(42, buffer, numValues, I16);
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
  	 	 for (j=0; j<numValues; j++) 
                   av_push(DataRef, newSViv((IV)buffer[j]));
	 	 Safefree(buffer);
  	 	 break;
  	       }
  	       case CDF_UINT2:  {
  	 	 U16 * buffer;
  	 	 New(42, buffer, numValues, U16);
		 RETVAL = CDFlib(operation, item, 1, Varnum, buffer, NULL_);
  	 	 for (j=0; j<numValues; j++) 
		   av_push(DataRef, newSViv((IV)buffer[j]));
	 	 Safefree(buffer);
  	 	 break;
  	       }
  	       default:
  	 	 printf ("GET RECDATA: Bad Datatype = %ld \n", DataType);
  	      }
            } else {
              RETVAL = status;
              break;
            }
	  }
	}
	OUTPUT:
	DataRef
	RETVAL	
	
CDFstatus
CDFlib5(operation, item, AnyLong)
	long	operation
	long	item
	long	AnyLong = NO_INIT
	CODE:
		RETVAL = CDFlib(operation, item, &AnyLong, NULL_);
	OUTPUT:
	AnyLong
	RETVAL
	
CDFstatus
CDFlib51(operation, item, recNumber, ArrayRef)
	long	operation
	long	item
	long	recNumber = NO_INIT
	AV *	ArrayRef
 	CODE:
	{
	  long LongArray[CDF_MAX_DIMS];
	  long count;
	  int i;
	  CDFstatus status = CDF_OK;
	  RETVAL = CDFlib(operation, item, &recNumber, LongArray, NULL_);
	  if (item == rVAR_SEQPOS_) 
		status = CDFlib(GET_, rVARs_NUMDIMS_, &count, NULL_);
	  else 
		status = CDFlib(GET_, zVAR_NUMDIMS_, &count, NULL_);
          if (status == CDF_OK) {
	    ArrayRef = (AV *)SvRV(ST(3)); 
	    av_clear(ArrayRef); 
	    if (count == 0)  
		av_push(ArrayRef, newSViv((IV)0));
	    else {
		  for ( i=0 ; i<(int)count ; i++) 
			av_push(ArrayRef, newSViv((IV)LongArray[i]));
	    }
          } else
            RETVAL = status;
	}
	OUTPUT:
	recNumber
	ArrayRef
	RETVAL
	
CDFstatus
CDFlib1(operation, item, ArrayRef)
	long	operation
	long	item
	AV *	ArrayRef
  	CODE:
	{
	   int i;
	   long count;
	   CDFstatus status = CDF_OK;
 	   long LongArray[CDF_MAX_DIMS];
	   RETVAL = CDFlib(operation, item, LongArray, NULL_);
 	   if (item == rVARs_DIMCOUNTS_ || item == rVARs_DIMINDICES_ ||
 	       item == rVARs_DIMINTERVALS_ || item == rVAR_DIMVARYS_ ||
 	       item == rVARs_DIMSIZES_) 
 		status = CDFlib(GET_, rVARs_NUMDIMS_, &count, NULL_);
 	   else 
 		status = CDFlib(GET_, zVAR_NUMDIMS_, &count, NULL_);
           if (status == CDF_OK) {
 	     ArrayRef = (AV *)SvRV(ST(2)); 
 	     av_clear(ArrayRef); 
 	     if (count == 0) 
 		av_push(ArrayRef, newSViv((IV)0)); 
 	     else {
 		for (i=0; i < (int)count ; i++) 
 			av_push(ArrayRef, newSViv((IV)LongArray[i]));
 	     }
          } else
            RETVAL = status;
	}
	OUTPUT:
   	ArrayRef
   	RETVAL
	
CDFstatus
CDFliba(operation, item, ArrayRef)
	long	operation
	long	item
	AV *	ArrayRef
  	CODE:
	{
	   I32 count, i;
	   long LongArray[CDF_MAX_DIMS];
	   count = (int) av_len(ArrayRef); 
	   if (count < 0) 
		printf ("Input Long Array: No values specified\n");
	   else {
		for ( i=0 ; i<=count ; i++) 
			LongArray[i] = (long)SvIV(*(av_fetch(ArrayRef, i, 0)));
	   }
	   RETVAL = CDFlib(operation, item, LongArray, NULL_);
	}	   
	OUTPUT:
	RETVAL
	
CDFstatus
CDFlib8B(operation, item, numStrings, ArrayRef)
	long	operation
	long	item
	long	numStrings
	AV *	ArrayRef
  	CODE:
	{
	   long count = numStrings;
	   if (count < 0) { 
		printf ("Input string Array: No values specified\n");
                RETVAL = BAD_NUM_STRINGS;
	   } else {
                I32  i;
                char **buffer = NULL;
                STRLEN len2;
                buffer = (char **) malloc (sizeof(char *) * count);
		for ( i=0 ; i<count ; i++) {
                   buffer[i] = malloc(strlen(SvPV(*(av_fetch(ArrayRef, i, 0)),
                                                  len2))+1);
                   strcpy (buffer[i], SvPV(*(av_fetch(ArrayRef, i, 0)), len2));
                }
	        RETVAL = CDFlib(operation, item, numStrings, buffer, NULL_);
                CDF_Free_String (count, buffer);
           }
	}	   
	OUTPUT:
	RETVAL
	
CDFstatus
CDFlibv(operation, item, DataRef)
	long	operation
	long	item
	SV *	DataRef = NO_INIT
	CODE:
	{
	   I32 j;
  	   CDFstatus status = CDF_OK;
  	   long DataType, numElems;
           RETVAL = 0;
	   DataRef = (SV *) SvRV(ST(2));
  	   if (item == rVAR_DATA_ || item == rVAR_PADVALUE_ ||
  	       item == rVAR_SEQDATA_)
	  	 status = CDFlib(GET_, rVAR_DATATYPE_, &DataType,
  	  	                       rVAR_NUMELEMS_, &numElems,
  	  		         NULL_);
	   else 
		status = CDFlib(GET_, zVAR_DATATYPE_, &DataType,
  	  	                      zVAR_NUMELEMS_, &numElems,
  	  		        NULL_);
           if (status == CDF_OK) {
  	     switch (DataType) {
  	      case CDF_UCHAR:
  	      case CDF_CHAR:  {
		char *	buffer;
		STRLEN len;
	  	New(42, buffer, numElems+1, char); 
 		strncpy(buffer, SvPV(DataRef, len), numElems);
                *(buffer+numElems) = '\0';
		if ((int) strlen(buffer) < (int) numElems) { 
		  for (j=(int)strlen(buffer); j<(int)numElems; j++)
                    buffer[j] = '\0';
		}
		RETVAL = CDFlib(operation, item, buffer, NULL_);
	 	Safefree(buffer);
	  	break;
  	      }
/*
  	      case CDF_UCHAR:  {
  	    	void *	buffer;
		STRLEN len;
	  	New(42, buffer, numElems+1, unsigned char);
                strncpy((char *)buffer, SvPV(DataRef, len), numElems);
                if ((int) strlen((char *)buffer) < (int) numElems) {
                  for (j=(int)strlen((char *)buffer); j<(int)numElems; j++) 
			*(((char *)buffer)+j) = '\0';
                 *(((char *) buffer)+numElems) = '\0';
                }
		RETVAL = CDFlib(operation, item, buffer, NULL_);
	 	Safefree(buffer);
	  	break;
  	      }
*/
  	      case CDF_BYTE:
  	      case CDF_INT1:  {
                I8    buffer;
                buffer = (I8) SvIV(DataRef);
                RETVAL = CDFlib(operation, item, &buffer, NULL_);
                break;
              }
              case CDF_UINT1: {
                U8    buffer;
                buffer = (U8) SvIV(DataRef);
                RETVAL = CDFlib(operation, item, &buffer, NULL_);
                break;
              }
              case CDF_EPOCH:
              case CDF_DOUBLE:
              case CDF_REAL8: {
                double buffer;
                buffer = (double) SvNV(DataRef);
                RETVAL = CDFlib(operation, item, &buffer, NULL_);
                break;
              }
/*
              case CDF_EPOCH16: {
                double buffer[2];
                buffer[0] = (double) SvNV(*(av_fetch(DataRef, 0, 0)));
                buffer[1] = (double) SvNV(*(av_fetch(DataRef, 1, 0)));
                RETVAL = CDFlib(operation, item, buffer, NULL_);
                break;
              }
*/
              case CDF_REAL4:
              case CDF_FLOAT: {
                float buffer;
                buffer = (float) SvNV(DataRef);
                RETVAL = CDFlib(operation, item, &buffer, NULL_);
                break;
              }
              case CDF_INT4: { 
                I32 buffer;
                buffer = (I32) SvIV(DataRef);
                RETVAL = CDFlib(operation, item, &buffer, NULL_);
                break;
              }
              case CDF_INT8:
              case CDF_TIME_TT2000: { 
                long long buffer;
                if (SvIOK(DataRef)) {
                  buffer = (long long) SvIV(DataRef);
                } else if (SvNOK(DataRef)) {
                  buffer = (long long) SvNV(DataRef);
                } else {
                  sscanf(SvPV_nolen(DataRef),"%lld",&buffer);
                }
                RETVAL = CDFlib(operation, item, &buffer, NULL_);
                break;
              }
              case CDF_UINT4: { 
                U32 buffer;
                buffer = (U32) SvIV(DataRef);
                RETVAL = CDFlib(operation, item, &buffer, NULL_);
                break;
              }
              case CDF_INT2: {
                I16 buffer;
                buffer = (I16) SvIV(DataRef);
                RETVAL = CDFlib(operation, item, &buffer, NULL_);
                break;
              }
              case CDF_UINT2: {
                U16 buffer;
                buffer = (U16) SvIV(DataRef);
                RETVAL = CDFlib(operation, item, &buffer, NULL_);
                break;
  	      }
  	      default:
  	 	printf ("Put value: Bad Datatype = %ld \n", DataType);
 	     }
 	   } else
             RETVAL = status;
 	}
	OUTPUT:
	RETVAL

CDFstatus		
CDFlibb(operation, item, DataRef)
	long	operation
	long	item
	AV *	DataRef
	CODE:
	{
	   I32 i, j;
  	   CDFstatus status = CDF_OK;
  	   long DataType, numElems;
	   long recCount, dimCounts[CDF_MAX_DIMS], numDims;
  	   long numValues; 
           RETVAL = 0;
  	   if (item == rVAR_HYPERDATA_)
	   	status = CDFlib(GET_, rVAR_DATATYPE_, &DataType,
  	  	                      rVAR_NUMELEMS_, &numElems,
                                      rVARs_NUMDIMS_, &numDims,
                  		CONFIRM_, rVARs_RECCOUNT_, &recCount,
                                          rVARs_DIMCOUNTS_, dimCounts,
  	  		        NULL_);
	   else 
		status = CDFlib(GET_, zVAR_DATATYPE_, &DataType,
  	  	                      zVAR_NUMELEMS_, &numElems,
                                      zVAR_NUMDIMS_, &numDims,
                  		CONFIRM_, zVAR_RECCOUNT_, &recCount,
                                          zVAR_DIMCOUNTS_, dimCounts,
  	  		        NULL_);
           if (status == CDF_OK) {
	     numValues = recCount;
	     for (i = 0; i<numDims ; i++) numValues *= dimCounts[i];
  	     switch (DataType) {
              case CDF_UCHAR:
  	      case CDF_CHAR:  {
  	    	char *	buffer; 
		char *	temp;
		STRLEN len;
	  	New(42, buffer, numElems*numValues+1, char); 
	  	New(42, temp, numElems+1, char); 
		for (i=0 ; i < numValues; i++) {
		   strncpy(temp, SvPV(*(av_fetch(DataRef, i, 0)), len), 
			   numElems);
                   *(temp+numElems) = '\0';
		   if ((int) strlen(temp) < (int) numElems) { 
		     for (j=(int)strlen(temp); j<(int)numElems; j++)
                       temp[j] = '\0';
		   }
 		   strncpy(buffer+i*numElems, temp, numElems);
		}
		RETVAL = CDFlib(operation, item, buffer, NULL_);
	 	Safefree(buffer);
 	 	Safefree(temp);
	  	break;
  	      }
/*
  	      case CDF_UCHAR:  {
  	    	void *	buffer;
  	    	void *	temp;
		STRLEN len;
	  	New(42, buffer, numElems*numValues+1, unsigned char);
                New(42, temp, numElems+1, U8);
		for (i=0 ; i < numValues; i++) {
                   strncpy((char *)temp, SvPV(*(av_fetch(DataRef, i, 0)), len),
			   numElems+1);
                   if ((int) strlen((char *)temp) < (int) numElems) {
                     for (j=(int)strlen((char *)temp); j<(int)numElems; j++) 
			*(((char *)temp)+j) = '\0';
                     *(((char *)temp)+numElems) = '\0';
                   }
                   strncpy((char *)buffer+i*numElems, temp, numElems+1);
                }
		RETVAL = CDFlib(operation, item, buffer, NULL_);
	 	Safefree(buffer);
                Safefree(temp);
	  	break;
  	      }
*/
  	      case CDF_BYTE:
  	      case CDF_INT1:  {
  	    	I8 *	buffer;
	  	New(42, buffer, numValues, I8); 
		for (i=0 ; i < numValues; i++) 
		   buffer[i] = (I8) SvIV(*(av_fetch(DataRef, i, 0)));
		RETVAL = CDFlib(operation, item, buffer, NULL_);
	 	Safefree(buffer);
	  	break;
  	      }
  	      case CDF_UINT1: {
  	    	U8 *	buffer;
	  	New(42, buffer, numValues, U8); 
		for (i=0 ; i < numValues; i++) 
		   buffer[i] = (U8) SvIV(*(av_fetch(DataRef, i, 0)));
		RETVAL = CDFlib(operation, item, buffer, NULL_);
	 	Safefree(buffer);
	  	break;
  	      }
  	      case CDF_EPOCH:
  	      case CDF_DOUBLE:
  	      case CDF_REAL8: {
  	 	double * buffer;
  	 	New(42, buffer, numValues, double);
  	 	for (i=0; i<numValues; i++) 
  	 	  buffer[i] = (double) SvNV(*(av_fetch(DataRef, i, 0)));
		RETVAL = CDFlib(operation, item, buffer, NULL_);
	 	Safefree(buffer);
	 	break; 
  	      }
  	      case CDF_EPOCH16: {
  	 	double * buffer;
  	 	New(42, buffer, 2*numValues, double);
  	 	for (i=0; i<2*numValues; i++) 
  	 	  buffer[i] = (double) SvNV(*(av_fetch(DataRef, i, 0)));
		RETVAL = CDFlib(operation, item, buffer, NULL_);
	 	Safefree(buffer);
	 	break; 
  	      }
  	      case CDF_REAL4:
  	      case CDF_FLOAT: {
  	 	float * buffer;
  	 	New(42, buffer, numValues, float);
  	 	for (i=0; i<numValues; i++) 
  	 	  buffer[i] = (float) SvNV(*(av_fetch(DataRef, i, 0)));
		RETVAL = CDFlib(operation, item, buffer, NULL_);
	 	Safefree(buffer);
  	 	break;
  	      }
   	      case CDF_INT4:  {
  	 	I32 * buffer;
  	 	New(42, buffer, numValues, I32);
  	 	for (i=0; i<numValues; i++) 
  	 	  buffer[i] = (I32) SvIV(*(av_fetch(DataRef, i, 0)));
		RETVAL = CDFlib(operation, item, buffer, NULL_);
	 	Safefree(buffer);
  	 	break;
   	      }
   	      case CDF_INT8:
   	      case CDF_TIME_TT2000:  {
                double * buffer;
                SV **value;
                long long tmp;
                New(42, buffer, numValues, double);
                for (i=0 ; i < numValues; i++) {
                  value = av_fetch(DataRef, i, 0);
                  if (SvIOK(*value)) {
                    tmp = (long long) SvIV(*value);
                  } else if (SvNOK(*value)) {
                    tmp = (long long) SvNV(*value);
                  } else {
                    sscanf(SvPV_nolen(*value),"%lld",&tmp);
                  }
                  memcpy (buffer+i, &tmp, 8);
                }
		RETVAL = CDFlib(operation, item, buffer, NULL_);
	 	Safefree(buffer);
  	 	break;
   	      }
   	      case CDF_UINT4:  {
  	 	U32 * buffer;
  	 	New(42, buffer, numValues, U32);
  	 	for (i=0; i<numValues; i++) 
  	 	  buffer[i] = (U32) SvIV(*(av_fetch(DataRef, i, 0)));
		RETVAL = CDFlib(operation, item, buffer, NULL_);
	 	Safefree(buffer);
  	 	break;
   	      }
  	      case CDF_INT2:  {
  	 	I16 * buffer;
  	 	New(42, buffer, numValues, I16);
  	 	for (i=0; i<numValues; i++) 
  	 	  buffer[i] = (I16) SvIV(*(av_fetch(DataRef, i, 0)));
		RETVAL = CDFlib(operation, item, buffer, NULL_);
	 	Safefree(buffer);
  	 	break;
  	      }
  	      case CDF_UINT2:  {
  	 	U16 * buffer;
  	 	New(42, buffer, numElems, U16);
  	 	for (i=0; i<numValues; i++) 
  	 	  buffer[i] = (U16) SvIV(*(av_fetch(DataRef, i, 0)));
		RETVAL = CDFlib(operation, item, buffer, NULL_);
	 	Safefree(buffer);
  	 	break;
  	      }
  	      default:
  	 	printf ("Put Buffer: Bad Datatype = %ld \n", DataType);
  	     }
  	   } else
             RETVAL = status;
 	}
	OUTPUT:
	RETVAL
		
CDFstatus
CDFlib7(operation, item, DataRef)
	long	operation
	long	item
	SV * 	DataRef = NO_INIT
  	CODE:
  	{
  	  CDFstatus status = CDF_OK;
  	  long DataType, numElems;

          RETVAL = 0;
          DataRef = (SV *)SvRV(ST(2));
   	  if (item == gENTRY_DATA_) 
  	  	status = CDFlib(GET_, gENTRY_DATATYPE_, &DataType,
  	  		              gENTRY_NUMELEMS_, &numElems,
  	  		        NULL_);
  	  else if (item == zENTRY_DATA_)
  	  	status = CDFlib(GET_, zENTRY_DATATYPE_, &DataType,
  	  		              zENTRY_NUMELEMS_, &numElems,
  	  		        NULL_);
  	  else if (item == rENTRY_DATA_)
  	  	status = CDFlib(GET_, rENTRY_DATATYPE_, &DataType,
  	  		              rENTRY_NUMELEMS_, &numElems,
  	  		        NULL_);
	  else if (item == rVAR_DATA_ || item == rVAR_PADVALUE_ ||
	 	   item == rVAR_SEQDATA_)
			status = CDFlib(GET_, rVAR_DATATYPE_, &DataType, 
			                      rVAR_NUMELEMS_, &numElems, 
					NULL_);
	  else if (item == zVAR_DATA_ || item == zVAR_PADVALUE_ ||
		   item == zVAR_SEQDATA_)
			status = CDFlib(GET_, zVAR_DATATYPE_, &DataType, 
			                      zVAR_NUMELEMS_, &numElems, 
					NULL_);
          if (status == CDF_OK) {
   	    switch (DataType) {
              case CDF_UCHAR:
  	      case CDF_CHAR:  { 
  	    	char * buffer;
                int x, iend;
	  	New(42, buffer, numElems+1, char);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                *(buffer+numElems) = '\0';
                iend = numElems;
                for (x = 0; x < numElems; ++x) {
                  if (*(buffer+x) == '\0') {
                    iend = x;
                    break;
                  }
                } 
 		sv_setpvn(DataRef, buffer, iend);
	 	Safefree(buffer);
	  	break;
  	      }
/*
  	      case CDF_UCHAR:  {
  	    	void *	buffer;
	  	New(42, buffer, numElems, unsigned char);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                sv_setpvn(DataRef, (char *)buffer, numElems);
	 	Safefree(buffer);
	  	break;
  	      }
*/
  	      case CDF_BYTE:
  	      case CDF_INT1:  {
  	    	I8 	buffer;
		RETVAL = CDFlib(operation, item, &buffer, NULL_);
		sv_setiv(DataRef, (IV) buffer); 
	  	break;
  	      }
  	      case CDF_UINT1: {
  	    	U8 	buffer;
		RETVAL = CDFlib(operation, item, &buffer, NULL_);
                sv_setiv(DataRef, (IV) buffer); 
	  	break;
  	      }
  	      case CDF_EPOCH:
  	      case CDF_DOUBLE:
  	      case CDF_REAL8: {
  	 	double buffer;
		RETVAL = CDFlib(operation, item, &buffer, NULL_);
                sv_setnv(DataRef, (double) buffer); 
	 	break; 
  	      }
/*
  	      case CDF_EPOCH16: {
  	 	double buffer[2];
  	 	int j;
		RETVAL = CDFlib(operation, item, buffer, NULL_);
  	 	for (j=0; j<2; j++) 
                  av_push(DataRef, newSVnv(buffer[j]));
	 	break; 
  	      }
*/
  	      case CDF_REAL4:
  	      case CDF_FLOAT: {
  	 	float buffer;
		RETVAL = CDFlib(operation, item, &buffer, NULL_);
                sv_setnv(DataRef, (double) buffer); 
  	 	break;
  	      }
   	      case CDF_INT4:  {
  	 	I32 buffer;
		RETVAL = CDFlib(operation, item, &buffer, NULL_);
                sv_setiv(DataRef, (IV) buffer); 
  	 	break;
   	      }
   	      case CDF_INT8:
   	      case CDF_TIME_TT2000:  {
                long long buffer;
                char tmp[25];
		RETVAL = CDFlib(operation, item, &buffer, NULL_);
                snprintf(tmp, 24, "%lld", buffer);
                sv_setpvn(DataRef, tmp, strlen(tmp)); 
  	 	break;
   	      }
   	      case CDF_UINT4:  {
  	 	U32 buffer;
		RETVAL = CDFlib(operation, item, &buffer, NULL_);
                sv_setiv(DataRef, (IV) buffer); 
  	 	break;
   	      }
  	      case CDF_INT2:  {
  	 	I16 buffer;
		RETVAL = CDFlib(operation, item, &buffer, NULL_);
                sv_setiv(DataRef, (IV) buffer); 
  	 	break;
  	      }
  	      case CDF_UINT2:  {
  	 	U16 buffer;
		RETVAL = CDFlib(operation, item, &buffer, NULL_);
		sv_setiv(DataRef, (IV) buffer); 
  	 	break;
  	      }
  	      default:
  	 	printf ("GET value: Bad Datatype = %ld \n", DataType);
  	    }
 	  } else
            RETVAL = status;
        }
 	OUTPUT:
 	DataRef
 	RETVAL
		
CDFstatus
CDFlib7A(operation, item, DataRef)
	long	operation
	long	item
	AV * 	DataRef = NO_INIT
  	CODE:
  	{
  	  CDFstatus status = CDF_OK;
  	  long DataType, numElems;
  	  int i;

	  RETVAL = 0;

          DataRef = (AV *)SvRV(ST(2));
   	  if (item == gENTRY_DATA_) 
  	  	status = CDFlib(GET_, gENTRY_DATATYPE_, &DataType,
  	  		              gENTRY_NUMELEMS_, &numElems,
  	  		        NULL_);
  	  else if (item == zENTRY_DATA_)
  	  	status = CDFlib(GET_, zENTRY_DATATYPE_, &DataType,
  	  		              zENTRY_NUMELEMS_, &numElems,
  	  		        NULL_);
  	  else if (item == rENTRY_DATA_)
  	  	status = CDFlib(GET_, rENTRY_DATATYPE_, &DataType,
  	  		              rENTRY_NUMELEMS_, &numElems,
  	  		        NULL_);
	  else if (item == rVAR_DATA_ || item == rVAR_PADVALUE_ ||
	 	   item == rVAR_SEQDATA_)
			status = CDFlib(GET_, rVAR_DATATYPE_, &DataType, 
			                      rVAR_NUMELEMS_, &numElems, 
					NULL_);
	  else if (item == zVAR_DATA_ || item == zVAR_PADVALUE_ ||
		   item == zVAR_SEQDATA_)
			status = CDFlib(GET_, zVAR_DATATYPE_, &DataType, 
			                      zVAR_NUMELEMS_, &numElems, 
					NULL_);
          if (status == CDF_OK) {
  	    switch (DataType) {
  	      case CDF_UCHAR:
  	      case CDF_CHAR:  { 
  	    	char * buffer;
                int x, iend;
	  	New(42, buffer, numElems+1, char);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                *(buffer+numElems) = '\0';
                iend = numElems;
                for (x = 0; x < numElems; ++x) {
                  if (*(buffer+x) == '\0') {
                    iend = x;
                    break;
                  }
                }
                av_push(DataRef, newSVpv((char*)buffer, iend));
	 	Safefree(buffer);
	  	break;
  	      }
/*
  	      case CDF_UCHAR:  {
  	    	void *	buffer;
	  	New(42, buffer, numElems, unsigned char);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                av_push(DataRef, newSVpv((char *)buffer, numElems));
	 	Safefree(buffer);
	  	break;
  	      }
*/
  	      case CDF_BYTE:
  	      case CDF_INT1:  {
  	    	I8 * 	buffer;
                New(42, buffer, numElems, I8);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSViv((I8)buffer[i]));
                Safefree(buffer);
	  	break;
  	      }
  	      case CDF_UINT1: {
  	    	U8 * 	buffer;
                New(42, buffer, numElems, U8);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSViv((U8)buffer[i]));
                Safefree(buffer);
	  	break;
  	      }
  	      case CDF_EPOCH:
  	      case CDF_DOUBLE:
  	      case CDF_REAL8: {
  	 	double *  buffer;
                New(42, buffer, numElems, double);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSVnv((double)buffer[i]));
                Safefree(buffer);
	 	break; 
  	      }
  	      case CDF_EPOCH16: {
  	 	double *  buffer;
                New(42, buffer, 2*numElems, double);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                for (i=0 ; i < 2*numElems; i++)
                  av_push(DataRef, newSVnv((double)buffer[i]));
                Safefree(buffer);
	 	break; 
  	      }
  	      case CDF_REAL4:
  	      case CDF_FLOAT: {
  	 	float * buffer;
                New(42, buffer, numElems, float);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSVnv((float)buffer[i]));
                Safefree(buffer);
  	 	break;
  	      }
   	      case CDF_INT4:  {
  	 	I32 * buffer;
                New(42, buffer, numElems, I32);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSViv((I32)buffer[i]));
                Safefree(buffer);
  	 	break;
   	      }
   	      case CDF_INT8:
   	      case CDF_TIME_TT2000:  {
  	 	double * buffer;
                long long tmp;
                char str[25];
                New(42, buffer, numElems, double);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++) {
                  memcpy (&tmp, buffer+i, 8);
                  snprintf(str, 24, "%lld", tmp);
                  av_push(DataRef, newSVpvn(str, strlen(str)));
                }
                Safefree(buffer);
  	 	break;
   	      }
   	      case CDF_UINT4:  {
  	 	U32 * buffer;
                New(42, buffer, numElems, U32);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSViv((U32)buffer[i]));
                Safefree(buffer);
  	 	break;
   	      }
  	      case CDF_INT2:  {
  	 	I16 * buffer;
                New(42, buffer, numElems, I16);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSViv((I16)buffer[i]));
                Safefree(buffer);
  	 	break;
  	      }
  	      case CDF_UINT2:  {
  	 	U16 * buffer;
                New(42, buffer, numElems, U16);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSViv((U16)buffer[i]));
		Safefree(buffer);
  	 	break;
  	     }
  	     default:
  	 	printf ("GET value: Bad Datatype = %ld \n", DataType);
  	    }
 	  } else
            RETVAL = status;
        }
 	OUTPUT:
 	DataRef
 	RETVAL
		
CDFstatus
CDFlib8A(operation, item, ArrayRef)
	long	operation
	long	item
	AV * 	ArrayRef
  	CODE:
  	{
  	  CDFstatus status = CDF_OK;
  	  long numStrings, DataType;
          char **buffer;
  	  int i;

	  RETVAL = 0;

  	  if (item == zENTRY_STRINGSDATA_) {
  	  	status = CDFlib(GET_, zENTRY_DATATYPE_, &DataType,
  	  		              zENTRY_NUMSTRINGS_, &numStrings,
  	  		        NULL_);
	  } else {
  	  	status = CDFlib(GET_, rENTRY_DATATYPE_, &DataType,
  	  		              rENTRY_NUMSTRINGS_, &numStrings,
  	  		        NULL_);
          }
          if (status == CDF_OK) {
            if (DataType != CDF_CHAR && DataType != CDF_UCHAR)
              RETVAL = TRY_TO_READ_NONSTRING_DATA;
            else {
              ArrayRef = (AV *)SvRV(ST(2));
              av_clear(ArrayRef);
	      RETVAL = CDFlib(operation, item, &numStrings, &buffer, NULL_);
              for (i = 0; i < numStrings; ++i)
                av_store(ArrayRef, i, newSVpv((char*)buffer[i],
                                              strlen(buffer[i])));
	      CDF_Free_String (numStrings, buffer);
            }
          } else
            RETVAL = status;
        }
 	OUTPUT:
 	ArrayRef
 	RETVAL
		
CDFstatus
CDFlib2(operation, item, DataRef)
	long	operation
	long	item
	AV *	DataRef = NO_INIT
  	CODE:
  	{
  	  CDFstatus status = CDF_OK;
  	  long DataType, numElems;
          long recCount;
          long dimCounts[CDF_MAX_DIMS];
          long numDims;
  	  long numValues; 
  	  int i;
          RETVAL = 0;
  	  DataRef = (AV *)SvRV(ST(2)); 
 	  av_clear(DataRef); 
	  if (item == rVAR_HYPERDATA_ )
               	status = CDFlib(CONFIRM_, rVARs_RECCOUNT_, &recCount,
                       	                  rVARs_DIMCOUNTS_, dimCounts,
                             	GET_, rVARs_NUMDIMS_, &numDims,
                        	      rVAR_DATATYPE_, &DataType,
                                      rVAR_NUMELEMS_, &numElems,
                       	        NULL_);
	  else
		status = CDFlib(CONFIRM_, zVAR_RECCOUNT_, &recCount,
		       	                  zVAR_DIMCOUNTS_, dimCounts,
		               	GET_, zVAR_NUMDIMS_, &numDims,
                        	      zVAR_DATATYPE_, &DataType,
                                      zVAR_NUMELEMS_, &numElems,
		       	        NULL_);
	  if (status == CDF_OK) {	
	    numValues = recCount;
	    for (i = 0; i < numDims ; i++) numValues *= dimCounts[i];
  	    switch (DataType) {
              case CDF_UCHAR:
  	      case CDF_CHAR:  { 
  	    	char * buffer;
  	    	char * temp;
                int x, iend;
	  	New(42, buffer, numElems*numValues+1, char);
	  	New(42, temp, numElems+1, char);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
		for (i=0; i < numValues; i++) {
                  memcpy (temp, buffer+i*numElems, numElems);
                  *(temp+numElems) = '\0';
                  iend = numElems;
                  for (x=0; x < numElems; x++) {
                    if (*(temp+x) == '\0') {
                      iend = x;
                      break;
                    }
                  }
		  av_push(DataRef, newSVpv(temp, iend)); 
                }
	 	Safefree(buffer);
 	 	Safefree(temp);
	  	break;
  	      }
/*
  	      case CDF_UCHAR:  {
  	    	void *	buffer;
  	    	void * temp;
	  	New(42, buffer, numElems*numValues+1, unsigned char);
	  	New(42, temp, numElems+1, unsigned char);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
		for (i=0 ; i < numValues; i++) 
		  av_push(DataRef, newSVpv(strncpy((char *)temp, 
						   (char *)buffer+i*numElems, 
						   numElems), numElems)); 
	 	Safefree(buffer);
	 	Safefree(temp);
	  	break;
  	      }
*/
  	      case CDF_BYTE:
  	      case CDF_INT1:  {
  	    	I8 *	buffer;
	  	New(42, buffer, numValues, I8);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
		for (i=0 ; i < numValues; i++)  
		  av_push(DataRef, newSViv((I8)buffer[i]));
	 	Safefree(buffer);
	  	break;
  	      }
  	      case CDF_UINT1: {
  	    	U8 *	buffer;
	  	New(42, buffer, numValues, U8);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
		for (i=0 ; i < numValues; i++)  
		  av_push(DataRef, newSViv((U8)buffer[i]));
	 	Safefree(buffer);
	  	break;
  	      }
  	      case CDF_EPOCH:
  	      case CDF_DOUBLE:
  	      case CDF_REAL8: {
  	 	double * buffer;
  	 	New(42, buffer, numValues, double);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
 		for (i=0; i < numValues ; i++) 
		  av_push(DataRef, newSVnv((double)buffer[i]));
	 	Safefree(buffer);
	 	break; 
  	      }
  	      case CDF_EPOCH16: {
  	 	double * buffer;
  	 	New(42, buffer, 2*numValues, double);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
 		for (i=0; i < 2*numValues ; i++) 
		  av_push(DataRef, newSVnv((double)buffer[i]));
	 	Safefree(buffer);
	 	break; 
  	      }
  	      case CDF_REAL4:
  	      case CDF_FLOAT: {
  	 	float * buffer;
  	 	New(42, buffer, numValues, float);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
 		for (i=0; i < numValues ; i++)
 		  av_push(DataRef, newSVnv((float)buffer[i]));
	 	Safefree(buffer);
  	 	break;
  	      }
   	      case CDF_INT4:  {
  	 	I32 * buffer;
  	 	New(42, buffer, numValues, I32);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
 		for (i=0; i < numValues ; i++) 
 		  av_push(DataRef, newSViv((IV)buffer[i]));
	 	Safefree(buffer);
  	 	break;
   	      }
   	      case CDF_INT8:
   	      case CDF_TIME_TT2000:  {
  	 	double * buffer;
                long long tmp;
                char str[25];
  	 	New(42, buffer, numValues, double);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
 		for (i=0; i < numValues ; i++) {
                  memcpy(&tmp, buffer+i, 8);
                  snprintf(str, 24, "%lld", tmp);
 		  av_push(DataRef, newSVpvn(str, strlen(str)));
                }
	 	Safefree(buffer);
  	 	break;
   	      }
   	      case CDF_UINT4:  {
  	 	U32 * buffer;
  	 	New(42, buffer, numValues, U32);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
                for (i=0; i < numValues ; i++)
 		  av_push(DataRef, newSViv((IV)buffer[i]));
	 	Safefree(buffer);
  	 	break;
   	      }
  	      case CDF_INT2:  {
  	 	I16 * buffer;
  	 	New(42, buffer, numValues, I16);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
 		for (i=0; i < numValues ; i++) 
 		  av_push(DataRef, newSViv((IV)buffer[i]));
	 	Safefree(buffer);
  	 	break;
  	      }
  	      case CDF_UINT2:  {
  	 	U16 * buffer;
  	 	New(42, buffer, numValues, U16);
		RETVAL = CDFlib(operation, item, buffer, NULL_);
 		for (i=0; i < numValues ; i++) 
 		  av_push(DataRef, newSViv((IV)buffer[i]));
	 	Safefree(buffer);
  	 	break;
  	      }
  	      default:
  	 	printf ("GET buffer: Bad Datatype = %ld \n", DataType);
  	    }
 	  } else
            RETVAL = status;
        }
 	OUTPUT:
 	DataRef
 	RETVAL
		
CDFstatus
CDFlib515(operation, item, Type, ArrayRef, Pct)
	long	operation
	long	item
	long	Type = NO_INIT
	AV *	ArrayRef = NO_INIT
	long	Pct = NO_INIT
 	CODE:
	{
	  long LongArray[CDF_MAX_DIMS];
	  RETVAL = CDFlib(operation, item, &Type, LongArray, &Pct, 
			  NULL_);
	  ArrayRef = (AV *)SvRV(ST(3)); 
	  av_clear(ArrayRef); 
	  if (item == CDF_COMPRESSION_ || item == rVAR_COMPRESSION_ ||
	      item == zVAR_COMPRESSION_) { 
	    if (Type != NO_COMPRESSION) 
		av_push(ArrayRef, newSViv((IV)LongArray[0]));
	    else
                av_push(ArrayRef, newSViv((IV) 0 ));
	  }
	}
	OUTPUT:
	Type
	ArrayRef
	Pct
	RETVAL
	
CDFstatus
CDFlibs5155(operation, item, path, Type, ArrayRef, cSize, uSize)
	long	operation
	long	item
	char *	path
	long	Type = NO_INIT
	AV *	ArrayRef = NO_INIT
	long	cSize = NO_INIT
	long	uSize = NO_INIT
 	CODE:
	{
	  long LongArray[CDF_MAX_DIMS];
	  RETVAL = CDFlib(operation, item, path, &Type, LongArray,  
			  &cSize, &uSize, NULL_);
	  ArrayRef = (AV *)SvRV(ST(4)); 
	  av_clear(ArrayRef); 
	  if (Type != NO_COMPRESSION) 
		av_push(ArrayRef, newSViv((IV)LongArray[0]));
            else
                av_push(ArrayRef, newSViv((IV) 0 ));
	}
	OUTPUT:
	Type
	ArrayRef
	cSize
	uSize
	RETVAL
	
CDFstatus
CDFCreateAttr(operation, item, AnyString, AnyLong, AnotherLong)
	long	operation
	long	item
	char *	AnyString
	long	AnyLong
	long	AnotherLong = NO_INIT
	CODE:
		RETVAL = CDFlib(operation, item, AnyString, AnyLong, 
				&AnotherLong, NULL_);
	OUTPUT:
	AnotherLong
	RETVAL
	
CDFstatus
CDFCreateCDF(operation, item, AnyString, numDims, ArrayRef, AnyId)
	long	operation
	long	item
	char *	AnyString
	long	numDims
	AV *	ArrayRef
	CDFid	AnyId = NO_INIT
  	CODE:
	{
	  long LongArray[CDF_MAX_DIMS];
	  I32 count, i;
	  count = (int) av_len(ArrayRef);
	  if (count < 0)
		printf ("Create CDF: No dimension values specified\n");
	  else {
		for ( i=0 ; i<=count ; i++) 
		  LongArray[i] = (long)SvIV(*(av_fetch(ArrayRef, i, 0)));
	  }
	  RETVAL = CDFlib(operation, item, AnyString, numDims, LongArray, 
			  &AnyId, NULL_);
	}
  	OUTPUT:
	AnyId
	RETVAL
	
CDFstatus
CDFCreateRvar(operation, item, AnyString, AnyLong, AnotherLong, FurtherLong, ArrayRef, FinalLong)
	long	operation
	long	item
	char *	AnyString
	long	AnyLong
	long	AnotherLong
	long	FurtherLong
	AV *	ArrayRef
	long	FinalLong = NO_INIT
  	CODE:
	{
	  long LongArray[CDF_MAX_DIMS];
	  I32 count, i;
	  count = (int) av_len(ArrayRef);
	  if (count < 0)
		printf (" Create R Variable: No dimension sizes specified\n");
	  else {
		for ( i=0 ; i<=count; i++) 
		  LongArray[i] = (long)SvIV(*(av_fetch(ArrayRef, i, 0)));
	  }
	  RETVAL = CDFlib(operation, item, AnyString, AnyLong, AnotherLong, 
			  FurtherLong, LongArray, &FinalLong, NULL_);
	}
	OUTPUT:
	FinalLong
	RETVAL
	
CDFstatus
CDFCreateZvar(operation, item, varName, dataType, numElems, numDims, ArrayRef, recVary, AnotherArrayRef, varNum)
	long	operation
	long	item
	char *	varName
	long	dataType
	long	numElems
	long	numDims
	AV *	ArrayRef
	long	recVary
	AV *	AnotherArrayRef
	long	varNum = NO_INIT
  	CODE:
	{
	  I32 count, i;
	  long dimSizes[CDF_MAX_DIMS];
	  long dimVarys[CDF_MAX_DIMS];
	  count = (int) av_len(ArrayRef);
	  if (count < 0) {
	  	dimSizes[0] = 1;
	  	dimVarys[0] = VARY;
	  } else {
	  	for (i=0;i<=count;i++) {
	  	  dimSizes[i] = (long)SvIV(*(av_fetch(ArrayRef, i, 0)));
	  	  dimVarys[i] = (long)SvIV(*(av_fetch(AnotherArrayRef, i, 0)));
	  	}
	  }
	  RETVAL = CDFlib(operation, item, varName, dataType, numElems, 
			  numDims, dimSizes, recVary, dimVarys, &varNum, NULL_);
	}
	OUTPUT:
	varNum
	RETVAL

CDFstatus
CDFcreateX(AnyString, numDims, ArrayRef, encoding, majority, AnyId)
        char *  AnyString
        long    numDims
        AV *    ArrayRef
	long	encoding
	long	majority
        CDFid   AnyId = NO_INIT
        CODE:
        {
          long LongArray[CDF_MAX_DIMS];
          I32 count, i;
          count = (int) av_len(ArrayRef);
          if (count < 0)
                printf ("Create CDF: No dimension values specified\n");
          else {
                for ( i=0 ; i<=count ; i++)
                  LongArray[i] = (long)SvIV(*(av_fetch(ArrayRef, i, 0)));
          }
          RETVAL = CDFlib(CREATE_, CDF_, AnyString, numDims, LongArray, &AnyId,
			  PUT_, CDF_ENCODING_, encoding,
			        CDF_MAJORITY_, majority,
			  NULL_);
        }
        OUTPUT:
        AnyId
        RETVAL

CDFstatus
CDFopenX(AnyString, AnyId)
        char *  AnyString
        CDFid   AnyId = NO_INIT
        CODE:
        {
          RETVAL = CDFlib(OPEN_, CDF_, AnyString, &AnyId, 
			  NULL_);
        }
        OUTPUT:
        AnyId
        RETVAL

CDFstatus
CDFdocX(AnyId, version, release, AnyString)
        CDFid   AnyId
	long	version = NO_INIT
	long	release = NO_INIT
        char *  AnyString = NO_INIT
        CODE:
        {
	  char temp[CDF_COPYRIGHT_LEN+1];
	  AnyString = temp;
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
			  GET_, CDF_VERSION_, &version,
				CDF_RELEASE_, &release,
				CDF_COPYRIGHT_, AnyString,
                          NULL_);
        }
        OUTPUT:
        version
	release
	AnyString
        RETVAL

CDFstatus
CDFinquireX(AnyId, numDims, dimSizesRef, encoding, majority, maxRec, numVars, numAttrs)
        CDFid   AnyId
        long    numDims = NO_INIT
        AV *    dimSizesRef = NO_INIT
        long    encoding = NO_INIT
        long    majority = NO_INIT
        long    maxRec = NO_INIT
        long    numVars = NO_INIT
        long    numAttrs = NO_INIT
        CODE:
        {
          long LongArray[CDF_MAX_DIMS];
          I32 i;
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                          GET_, rVARs_NUMDIMS_, &numDims,
				rVARs_DIMSIZES_, LongArray,
				CDF_ENCODING_, &encoding,
                                CDF_MAJORITY_, &majority,
                                rVARs_MAXREC_, &maxRec,
				CDF_NUMrVARS_, &numVars,
				CDF_NUMATTRS_, &numAttrs,
                          NULL_);
          dimSizesRef = (AV *)SvRV(ST(2));
          av_clear(dimSizesRef);
          if (numDims == 0)
                av_push(dimSizesRef, newSViv((IV)0));
          else {
                  for ( i=0 ; i<numDims ; i++)
                        av_push(dimSizesRef, newSViv((IV)LongArray[i]));
          }
        }
        OUTPUT:
	numDims
	dimSizesRef 
	encoding 
	majority 
	maxRec 
	numVars 
	numAttrs
        RETVAL

CDFstatus
CDFcloseX(AnyId)
        CDFid   AnyId
        CODE:
        {
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                          CLOSE_, CDF_,
                          NULL_);
        }
        OUTPUT:
        RETVAL

CDFstatus
CDFdeleteX(AnyId)
        CDFid   AnyId
        CODE:
        {
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                          DELETE_, CDF_,
                          NULL_);
        }
        OUTPUT:
        RETVAL

CDFstatus
CDFerrorX(stat, AnyString)
        CDFstatus   stat
	char *	AnyString = NO_INIT
        CODE:
        {
          char temp[CDF_STATUSTEXT_LEN+1];
          AnyString = temp;
          RETVAL = CDFlib(SELECT_, CDF_STATUS_, stat,
                          GET_, STATUS_TEXT_, AnyString,
                          NULL_);
        }
        OUTPUT:
	AnyString
        RETVAL

CDFstatus
CDFattrCreateX(AnyId, AnyString, attrScope, attrNum)
        CDFid	AnyId
        char *  AnyString 
	long	attrScope
	long	attrNum = NO_INIT
        CODE:
        {
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                          CREATE_, ATTR_, AnyString, attrScope, &attrNum,
                          NULL_);
        }
        OUTPUT:
	attrNum
        RETVAL

long
CDFattrNumX(AnyId, AnyString)
        CDFid   AnyId
        char *  AnyString
        CODE:
        {
	  long	attrNum;
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                          GET_, ATTR_NUMBER_, AnyString, &attrNum, 
                          NULL_);
	  if (RETVAL == CDF_OK) RETVAL = attrNum;
        }
        OUTPUT:
        RETVAL

CDFstatus
CDFattrRenameX(AnyId, attrNum, AnyString)
        CDFid   AnyId
	long	attrNum
        char *  AnyString
        CODE:
        {
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
				   ATTR_, attrNum,
                          PUT_, ATTR_NAME_, AnyString, 
                          NULL_);
        }
        OUTPUT:
        RETVAL

CDFstatus
CDFattrInquireX(AnyId, attrNum, AnyString, attrScope, maxEntry)
        CDFid   AnyId
        long    attrNum
        char *  AnyString = NO_INIT
	long	attrScope = NO_INIT
	long	maxEntry = NO_INIT
        CODE:
        {
	  char temp[CDF_ATTR_NAME_LEN +1];
	  AnyString = temp;
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                                   ATTR_, attrNum,
			  GET_, ATTR_SCOPE_, &attrScope,
			  GET_, ATTR_NAME_, AnyString,
			  NULL_);
	  if (attrScope == GLOBAL_SCOPE) 
		RETVAL = CDFlib(GET_, ATTR_MAXgENTRY_, &maxEntry,
				NULL_);
	  else
                RETVAL = CDFlib(GET_, ATTR_MAXrENTRY_, &maxEntry,
                                NULL_);
        }
        OUTPUT:
	AnyString
	attrScope
	maxEntry
        RETVAL

CDFstatus
CDFattrEntryInquireX(AnyId, attrNum, entryNum, dataType, numElements)
        CDFid   AnyId
        long    attrNum
        long    entryNum
        long    dataType = NO_INIT
        long    numElements = NO_INIT
        CODE:
        {
	  long attrScope;
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                                   ATTR_, attrNum,
                          GET_, ATTR_SCOPE_, &attrScope,
                          NULL_);
          if (attrScope == GLOBAL_SCOPE)
                RETVAL = CDFlib(SELECT_, gENTRY_, entryNum,
				GET_, gENTRY_DATATYPE_, &dataType,
				      gENTRY_NUMELEMS_, &numElements, 
                                NULL_);
          else
                RETVAL = CDFlib(SELECT_, rENTRY_, entryNum,
                                GET_, rENTRY_DATATYPE_, &dataType,
                                      rENTRY_NUMELEMS_, &numElements,
                                NULL_);
        }
        OUTPUT:
        dataType
        numElements
        RETVAL

CDFstatus
CDFattrPutX(AnyId, attrNum, entryNum, DataType, numElems, DataRef)
        CDFid   AnyId
        long    attrNum
        long    entryNum
        long    DataType
        long    numElems 
	SV *	DataRef = NO_INIT
        CODE:
        {
          long attrScope, item;
	  I32 j;
	  DataRef = (SV *) SvRV(ST(5));
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                                   ATTR_, attrNum,
                          GET_, ATTR_SCOPE_, &attrScope,
                          NULL_);
          if (attrScope == GLOBAL_SCOPE) {
                RETVAL = CDFlib(SELECT_, gENTRY_, entryNum,
                                NULL_);
		item = gENTRY_DATA_;
	  }
          else {
                RETVAL = CDFlib(SELECT_, rENTRY_, entryNum,
                                NULL_);
		item = rENTRY_DATA_;
	  }
          switch (DataType) {
            case CDF_UCHAR:
            case CDF_CHAR:  {
                char *  buffer;
		STRLEN len;
                New(42, buffer, numElems+1, char);
                strncpy(buffer, SvPV(DataRef, len), numElems);
                *(buffer+numElems) = '\0';
                if ((int) strlen(buffer) < (int) numElems) {
                  for (j=(int)strlen(buffer); j<(int)numElems; j++)
                    buffer[j] = '\0';
                }
                RETVAL = CDFlib(PUT_, item, DataType, numElems, buffer, NULL_);
                Safefree(buffer);
                break;
            }
/*
            case CDF_UCHAR:  {
                void * buffer;
		STRLEN len;
                New(42, buffer, numElems+1, unsigned char);
                strncpy((char *)buffer, SvPV(DataRef, len), numElems);
                if ((int) strlen((char *)buffer) < (int) numElems) {
                  for (j=(int)strlen((char *)buffer); j<(int)numElems; j++) 
			*(((char *)buffer)+j) = '\0';
                  *(((char *)buffer)+numElems) = '\0';
                }
                RETVAL = CDFlib(PUT_, item, DataType, numElems, buffer, NULL_);
                Safefree(buffer);
                break;
            }
*/
            case CDF_BYTE:
            case CDF_INT1:  {
                I8    buffer;
                buffer = (I8) SvIV(DataRef);
                RETVAL = CDFlib(PUT_, item, DataType, numElems, &buffer, NULL_);
                break;
            }
            case CDF_UINT1: {
                U8    buffer;
                buffer = (U8) SvIV(DataRef);
                RETVAL = CDFlib(PUT_, item, DataType, numElems, &buffer, NULL_);
                break;
            }
            case CDF_EPOCH:
            case CDF_DOUBLE:
            case CDF_REAL8: {
                double buffer;
                buffer = (double) SvNV(DataRef);
                RETVAL = CDFlib(PUT_, item, DataType, numElems, &buffer, NULL_);
                break;
            }
/*
            case CDF_EPOCH16: {
                double buffer[2];
                buffer[0] = (double) SvNV(*(av_fetch(DataRef, 0, 0)));
                buffer[1] = (double) SvNV(*(av_fetch(DataRef, 1, 0)));
                RETVAL = CDFlib(PUT_, item, DataType, numElems, buffer, NULL_);
                break;
            }
*/
            case CDF_REAL4:
            case CDF_FLOAT: {
                float buffer;
                buffer = (float) SvNV(DataRef);
                RETVAL = CDFlib(PUT_, item, DataType, numElems, &buffer, NULL_);
                break;
            }
            case CDF_INT4: {
                I32 buffer;
                buffer = (I32) SvIV(DataRef);
                RETVAL = CDFlib(PUT_, item, DataType, numElems, &buffer, NULL_);
                break;
            }
            case CDF_INT8:
            case CDF_TIME_TT2000: {
                long long buffer;
                if (SvIOK(DataRef)) {
                  buffer = (long long) SvIV(DataRef);
                } else if (SvNOK(DataRef)) {
                  buffer = (long long) SvNV(DataRef);
                } else {
                  sscanf(SvPV_nolen(DataRef),"%lld",&buffer);
                }
                RETVAL = CDFlib(PUT_, item, DataType, numElems, &buffer, NULL_);
                break;
            }
            case CDF_UINT4: {
                U32 buffer;
                buffer = (U32) SvIV(DataRef);
                RETVAL = CDFlib(PUT_, item, DataType, numElems, &buffer, NULL_);
                break;
            }
            case CDF_INT2: {
                I16 buffer;
                buffer = (I16) SvIV(DataRef);
                RETVAL = CDFlib(PUT_, item, DataType, numElems, &buffer, NULL_);
                break;
            }
            case CDF_UINT2: {
                U16 buffer;
                buffer = (U16) SvIV(DataRef);
                RETVAL = CDFlib(PUT_, item, DataType, numElems, &buffer, NULL_);
                break;
            }
            default:        {
                printf ("AttrPut Data: Bad Datatype = %ld \n", DataType);
            }
          }
        }
        OUTPUT:
        RETVAL

CDFstatus
CDFattrPutXA(AnyId, attrNum, entryNum, DataType, numElems, DataRef)
        CDFid   AnyId
        long    attrNum
        long    entryNum
        long    DataType
        long    numElems 
	AV *	DataRef
        CODE:
        {
          long attrScope, item;
	  I32 i, count;
	  DataRef = (AV *) SvRV(ST(5));
	  count = (int) av_len(DataRef);
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                                   ATTR_, attrNum,
                          GET_, ATTR_SCOPE_, &attrScope,
                          NULL_);
          if (attrScope == GLOBAL_SCOPE) {
                RETVAL = CDFlib(SELECT_, gENTRY_, entryNum,
                                NULL_);
		item = gENTRY_DATA_;
	  }
          else {
                RETVAL = CDFlib(SELECT_, rENTRY_, entryNum,
                                NULL_);
		item = rENTRY_DATA_;
	  }
          switch (DataType) {
            case CDF_CHAR:  
	    case CDF_UCHAR: {
                break;
            }
            case CDF_BYTE:
            case CDF_INT1:  {
                I8 *    buffer;
                New(42, buffer, count+1, I8);
                for (i=0 ; i<=count ; i++)
                  buffer[i] = (I8)SvIV(*(av_fetch(DataRef, i, 0)));
                RETVAL = CDFlib(PUT_, item, DataType, numElems, buffer, NULL_);
                Safefree(buffer);
                break;
            }
            case CDF_UINT1: {
                U8 *    buffer;
                New(42, buffer, count+1, U8);
                for (i=0 ; i<=count ; i++)
                  buffer[i] = (U8)SvIV(*(av_fetch(DataRef, i, 0)));
                RETVAL = CDFlib(PUT_, item, DataType, numElems, buffer, NULL_);
                Safefree(buffer);
                break;
            }
            case CDF_EPOCH:
            case CDF_DOUBLE:
            case CDF_REAL8: {
                double * buffer;
                New(42, buffer, count+1, double);
                for (i=0 ; i<=count ; i++)
                  buffer[i] = (double)SvNV(*(av_fetch(DataRef, i, 0)));
                RETVAL = CDFlib(PUT_, item, DataType, numElems, buffer, NULL_);
                Safefree(buffer);
                break;
            }
            case CDF_EPOCH16: {
                double * buffer;
                New(42, buffer, 2*(count+1), double);
                for (i=0 ; i<2*(count+1) ; i++)
                  buffer[i] = (double)SvNV(*(av_fetch(DataRef, i, 0)));
                RETVAL = CDFlib(PUT_, item, DataType, numElems, buffer, NULL_);
                Safefree(buffer);
                break;
            }
            case CDF_REAL4:
            case CDF_FLOAT: {
                float * buffer;
                New(42, buffer, count+1, float);
                for (i=0 ; i<=count ; i++)
                  buffer[i] = (float)SvNV(*(av_fetch(DataRef, i, 0)));
                RETVAL = CDFlib(PUT_, item, DataType, numElems, buffer, NULL_);
                Safefree(buffer);
                break;
            }
            case CDF_INT4: {
                I32 * buffer;
                New(42, buffer, count+1, I32);
                for (i=0 ; i<=count ; i++)
                  buffer[i] = (I32)SvIV(*(av_fetch(DataRef, i, 0)));
                RETVAL = CDFlib(PUT_, item, DataType, numElems, buffer, NULL_);
                Safefree(buffer);
                break;
            }
            case CDF_INT8:
            case CDF_TIME_TT2000: {
                double * buffer;
                SV **value;
                long long tmp;
                New(42, buffer, count+1, double);
                for (i=0 ; i <= count; i++) {
                  value = av_fetch(DataRef, i, 0);
                  if (SvIOK(*value)) {
                    tmp = (long long) SvIV(*value);
                  } else if (SvNOK(*value)) {
                    tmp = (long long) SvNV(*value);
                  } else {
                    sscanf(SvPV_nolen(*value),"%lld",&tmp);
                  }
                  memcpy (buffer+i, &tmp, 8);
                }
                RETVAL = CDFlib(PUT_, item, DataType, numElems, buffer, NULL_);
                Safefree(buffer);
                break;
            }
            case CDF_UINT4: {
                U32 * buffer;
                New(42, buffer, count+1, U32);
                for (i=0 ; i<=count ; i++)
                  buffer[i] = (U32)SvIV(*(av_fetch(DataRef, i, 0)));
                RETVAL = CDFlib(PUT_, item, DataType, numElems, buffer, NULL_);
                Safefree(buffer);
                break;
            }
            case CDF_INT2: {
                I16 * buffer;
                New(42, buffer, count+1, I16);
                for (i=0 ; i<=count ; i++)
                  buffer[i] = (I16)SvIV(*(av_fetch(DataRef, i, 0)));
                RETVAL = CDFlib(PUT_, item, DataType, numElems, buffer, NULL_);
                Safefree(buffer);
                break;
            }
            case CDF_UINT2: {
                U16 * buffer;
                New(42, buffer, count+1, U16);
                for (i=0 ; i<=count ; i++)
                  buffer[i] = (U16)SvIV(*(av_fetch(DataRef, i, 0)));
                RETVAL = CDFlib(PUT_, item, DataType, numElems, buffer, NULL_);
                Safefree(buffer);
                break;
            }
            default:        {
                printf ("AttrPut Data: Bad Datatype = %ld \n", DataType);
            }
          }
        }
        OUTPUT:
        RETVAL

CDFstatus
CDFattrGetX(AnyId, attrNum, entryNum, DataRef)
        CDFid   AnyId
        long    attrNum
        long    entryNum
	SV *	DataRef = NO_INIT
        CODE:
        {
          long attrScope, item, DataType, numElems;
	  DataRef = (SV *) SvRV(ST(3));
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                                   ATTR_, attrNum,
                          GET_, ATTR_SCOPE_, &attrScope,
                          NULL_);
          if (attrScope == GLOBAL_SCOPE) {
                RETVAL = CDFlib(SELECT_, gENTRY_, entryNum,
				GET_, gENTRY_DATATYPE_, &DataType,
                                      gENTRY_NUMELEMS_, &numElems,
                                NULL_);
		item = gENTRY_DATA_;
	  }
          else {
                RETVAL = CDFlib(SELECT_, rENTRY_, entryNum,
                                GET_, rENTRY_DATATYPE_, &DataType,
                                      rENTRY_NUMELEMS_, &numElems,
                                NULL_);
		item = rENTRY_DATA_;
	  }
          switch (DataType) {
            case CDF_UCHAR:
            case CDF_CHAR:  {
                char *  buffer;
                int x, iend;
                New(42, buffer, numElems+1, char);
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
                *(buffer+numElems) = '\0';
                iend = numElems;
                for (x = 0; x < numElems; ++x) {
                  if (*(buffer+x) == '\0') {
                    iend = x;
                    break;
                  }
                }
               	sv_setpvn(DataRef, buffer, iend); 
                Safefree(buffer);
                break;
            }
/*
            case CDF_UCHAR:  {
                void * buffer;
                New(42, buffer, numElems+1, unsigned char);
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
               	sv_setpvn(DataRef, buffer, numElems); 
                Safefree(buffer);
                break;
            }
*/
            case CDF_BYTE:
            case CDF_INT1:  {
                I8    buffer;
                RETVAL = CDFlib(GET_, item, &buffer, NULL_);
                sv_setiv(DataRef, (IV) buffer); 
                break;
            }
            case CDF_UINT1: {
                U8    buffer;
                RETVAL = CDFlib(GET_, item, &buffer, NULL_);
                sv_setiv(DataRef, (IV) buffer); 
                break;
            }
            case CDF_EPOCH:
            case CDF_DOUBLE:
            case CDF_REAL8: {
                double buffer;
                RETVAL = CDFlib(GET_, item, &buffer, NULL_);
                sv_setnv(DataRef, (double) buffer); 
                break;
            }
/*
            case CDF_EPOCH16: {
                double buffer[2];
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
                for (i=0 ; i < 2; i++)
                  av_push(DataRef, newSVnv((double)buffer[i]));
                break;
            }
*/
            case CDF_REAL4:
            case CDF_FLOAT: {
                float buffer;
                RETVAL = CDFlib(GET_, item, &buffer, NULL_);
                sv_setnv(DataRef, (double) buffer); 
                break;
            }
            case CDF_INT4: {
                I32 buffer;
                RETVAL = CDFlib(GET_, item, &buffer, NULL_);
                sv_setiv(DataRef, (IV) buffer); 
                break;
            }
            case CDF_INT8:
            case CDF_TIME_TT2000: {
                long long buffer;
                char tmp[25];
                RETVAL = CDFlib(GET_, item, &buffer, NULL_);
                snprintf(tmp, 24, "%lld", buffer);
                sv_setpvn(DataRef, tmp, strlen(tmp)); 
                break;
            }
            case CDF_UINT4: {
                U32 buffer;
                RETVAL = CDFlib(GET_, item, &buffer, NULL_);
                sv_setiv(DataRef, (IV) buffer); 
                break;
            }
            case CDF_INT2: {
                I16 buffer;
                RETVAL = CDFlib(GET_, item, &buffer, NULL_);
                sv_setiv(DataRef, (IV) buffer); 
                break;
            }
            case CDF_UINT2: {
                U16 buffer;
                RETVAL = CDFlib(GET_, item, &buffer, NULL_);
                sv_setiv(DataRef, (IV) buffer); 
                break;
            }
            default:        {
                printf ("AttrGet Data: Bad Datatype = %ld \n", DataType);
            }
          }
        }
        OUTPUT:
	DataRef
        RETVAL

CDFstatus
CDFattrGetXA(AnyId, attrNum, entryNum, DataRef)
        CDFid   AnyId
        long    attrNum
        long    entryNum
	AV *	DataRef = NO_INIT
        CODE:
        {
          long attrScope, item, DataType, numElems, i;
	  DataRef = (AV *) SvRV(ST(3));
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                                   ATTR_, attrNum,
                          GET_, ATTR_SCOPE_, &attrScope,
                          NULL_);
          if (attrScope == GLOBAL_SCOPE) {
                RETVAL = CDFlib(SELECT_, gENTRY_, entryNum,
				GET_, gENTRY_DATATYPE_, &DataType,
                                      gENTRY_NUMELEMS_, &numElems,
                                NULL_);
		item = gENTRY_DATA_;
	  }
          else {
                RETVAL = CDFlib(SELECT_, rENTRY_, entryNum,
                                GET_, rENTRY_DATATYPE_, &DataType,
                                      rENTRY_NUMELEMS_, &numElems,
                                NULL_);
		item = rENTRY_DATA_;
	  }
          switch (DataType) {
            case CDF_UCHAR:
            case CDF_CHAR:  {
                char *  buffer;
                int x, iend;
                New(42, buffer, numElems+1, char);
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
                *(buffer+numElems) = '\0';
                iend = numElems;
                for (x = 0; x < numElems; ++x) {
                  if (*(buffer+x) == '\0') {
                    iend = x;
                    break;
                  }
                }
                av_push(DataRef, newSVpv((char*)buffer, iend));
                Safefree(buffer);
                break;
            }
/*
            case CDF_UCHAR:  {
                void * buffer;
                New(42, buffer, numElems+1, unsigned char);
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
                av_push(DataRef, newSVpv((char*)buffer, numElems));
                Safefree(buffer);
                break;
            }
*/
            case CDF_BYTE:
            case CDF_INT1:  {
                I8 *    buffer;
                New(42, buffer, numElems, I8);
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSViv((I8)buffer[i]));
                Safefree(buffer);
                break;
            }
            case CDF_UINT1: {
                U8 *    buffer;
                New(42, buffer, numElems, U8);
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSViv((U8)buffer[i]));
                Safefree(buffer);
                break;
            }
            case CDF_EPOCH:
            case CDF_DOUBLE:
            case CDF_REAL8: {
                double * buffer;
                New(42, buffer, numElems, double);
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSVnv((double)buffer[i]));
                Safefree(buffer);
                break;
            }
            case CDF_EPOCH16: {
                double * buffer;
                New(42, buffer, 2*numElems, double);
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
                for (i=0 ; i < 2*numElems; i++)
                  av_push(DataRef, newSVnv((double)buffer[i]));
                Safefree(buffer);
                break;
            }
            case CDF_REAL4:
            case CDF_FLOAT: {
                float * buffer;
                New(42, buffer, numElems, float);
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSVnv((float)buffer[i]));
                Safefree(buffer);
                break;
            }
            case CDF_INT4: {
                I32 * buffer;
                New(42, buffer, numElems, I32);
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSViv((I32)buffer[i]));
                Safefree(buffer);
                break;
            }
            case CDF_INT8:
            case CDF_TIME_TT2000: {
                double * buffer;
                long long tmp;
                char str[25];
                New(42, buffer, numElems, double);
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++) {
                  memcpy (&tmp, buffer+i, 8);
                  snprintf(str, 24, "%lld", tmp); 
                  av_push(DataRef, newSVpvn(str, strlen(str)));
                }
                Safefree(buffer);
                break;
            }
            case CDF_UINT4: {
                U32 * buffer;
                New(42, buffer, numElems, U32);
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSViv((U32)buffer[i]));
                Safefree(buffer);
                break;
            }
            case CDF_INT2: {
                I16 * buffer;
                New(42, buffer, numElems, I16);
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSViv((I16)buffer[i]));
                Safefree(buffer);
                break;
            }
            case CDF_UINT2: {
                U16 * buffer;
                New(42, buffer, numElems, U16);
                RETVAL = CDFlib(GET_, item, buffer, NULL_);
                for (i=0 ; i < (int) numElems; i++)
                  av_push(DataRef, newSViv((U16)buffer[i]));
                Safefree(buffer);
                break;
            }
            default:        {
                printf ("AttrGet Data: Bad Datatype = %ld \n", DataType);
            }
          }
        }
        OUTPUT:
	DataRef
        RETVAL

CDFstatus
CDFvarCreateX(AnyId, AnyString, dataType, numElements, recVary, dimVaryRef, varNum)
        CDFid   AnyId
        char *	AnyString
        long    dataType 
        long    numElements 
	long	recVary
	AV *	dimVaryRef
	long	varNum = NO_INIT
        CODE:
        {
          long LongArray[CDF_MAX_DIMS];
          I32 count, i;
          count = (int) av_len(dimVaryRef);
          if (count < 0)
                printf ("Create rVar: No dimension values specified\n");
          else {
                for ( i=0 ; i<=count ; i++)
                  LongArray[i] = (long)SvIV(*(av_fetch(dimVaryRef, i, 0)));
          }
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                          CREATE_, rVAR_, AnyString, dataType, numElements,
					  recVary, LongArray, &varNum,
			  NULL_);
        }
        OUTPUT:
        varNum
        RETVAL

long
CDFvarNumX(AnyId, AnyString)
        CDFid   AnyId
        char *  AnyString
        CODE:
        {
          long varNum;
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                          GET_, rVAR_NUMBER_, AnyString, &varNum,
                          NULL_);
	  if (RETVAL == CDF_OK) RETVAL = varNum;
        }
        OUTPUT:
        RETVAL

CDFstatus
CDFvarRenameX(AnyId, varNum, AnyString)
        CDFid   AnyId
	long	varNum
        char *  AnyString
        CODE:
        {
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
				   rVAR_, varNum,
                          PUT_, rVAR_NAME_, AnyString, 
                          NULL_);
        }
        OUTPUT:
        RETVAL

CDFstatus
CDFvarInquireX(AnyId, varNum, AnyString, dataType, numElements, recVary, dimVaryRef)
        CDFid   AnyId
        long    varNum
        char *  AnyString = NO_INIT
	long	dataType = NO_INIT
	long	numElements = NO_INIT
	long	recVary = NO_INIT
	AV *	dimVaryRef = NO_INIT
        CODE:
        {
	  long	LongArray[CDF_MAX_DIMS], numDims;
	  I32 	i;
	  char	temp[CDF_VAR_NAME_LEN+1];
	  AnyString = temp;
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                                   rVAR_, varNum,
                          GET_, rVAR_NAME_, AnyString,
			        rVAR_DATATYPE_, &dataType,
                                rVAR_NUMELEMS_, &numElements,
                                rVAR_RECVARY_, &recVary,
                                rVAR_DIMVARYS_, &LongArray,
			        rVARs_NUMDIMS_, &numDims,
                          NULL_);
          dimVaryRef = (AV *)SvRV(ST(6));
          av_clear(dimVaryRef);
          if (numDims == 0)
                av_push(dimVaryRef, newSViv((IV)0));
          else {
                  for ( i=0 ; i<numDims ; i++)
                        av_push(dimVaryRef, newSViv((IV)LongArray[i]));
          }

        }
        OUTPUT:
	AnyString
	dataType
	numElements
	recVary
	dimVaryRef
        RETVAL

CDFstatus
CDFvarPutX(AnyId, varNum, recNum, ArrayRef, DataRef)
        CDFid   AnyId
        long    varNum
        long    recNum
        AV *	ArrayRef
        SV *    DataRef = NO_INIT
        CODE:
        {
          long LongArray[CDF_MAX_DIMS], DataType, numElems;
          I32 count, i, j;
          count = (int) av_len(ArrayRef);
          if (count < 0)
            printf(" Put Variable: No indices specified\n");
          else {
            for ( i=0 ; i<=count ; i++)
              LongArray[i] = (long)SvIV(*(av_fetch(ArrayRef, i, 0)));
          }
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                                   rVAR_, varNum,
                                   rVARs_RECNUMBER_, recNum,
                                   rVARs_DIMINDICES_, LongArray,
			  GET_, rVAR_DATATYPE_, &DataType,
				rVAR_NUMELEMS_, &numElems,
			  NULL_);
          DataRef = (SV *) SvRV(ST(4));
          switch (DataType) {
           case CDF_UCHAR:
           case CDF_CHAR:  {
              char *  buffer;
	      STRLEN len;
              New(42, buffer, numElems+1, char);
              strncpy(buffer, SvPV(DataRef, len), numElems);
              *(buffer+numElems) = '\0';
              if ((int) strlen(buffer) < (int) numElems) {
                for (j=(int)strlen(buffer); j<(int)numElems; j++)
                  buffer[j] = '\0';
              }
              RETVAL = CDFlib(PUT_, rVAR_DATA_, buffer, NULL_);
              Safefree(buffer);
              break;
           }
/*
           case CDF_UCHAR:  {
              void * buffer;
	      STRLEN len;
              New(42, buffer, numElems+1, unsigned char);
              strncpy((char *)buffer, SvPV(DataRef, len), numElems);
              if ((int) strlen((char *)buffer) < (int) numElems) {
                for (j=(int)strlen((char *)buffer); j<(int)numElems; j++) 
			*(((char *)buffer)+j) = '\0';
                *(((char *)buffer)+numElems) = '\0';
              }
              RETVAL = CDFlib(PUT_, rVAR_DATA_, buffer, NULL_);
              Safefree(buffer);
              break;
           }
*/
           case CDF_BYTE:
           case CDF_INT1:  {
              I8    buffer;
              buffer = (I8) SvIV(DataRef);
              RETVAL = CDFlib(PUT_, rVAR_DATA_, &buffer, NULL_);
              break;
           }
           case CDF_UINT1: {
              U8    buffer;
              buffer = (U8) SvIV(DataRef);
              RETVAL = CDFlib(PUT_, rVAR_DATA_, &buffer, NULL_);
              break;
           }
           case CDF_EPOCH:
           case CDF_DOUBLE:
           case CDF_REAL8: {
              double buffer;
              buffer = (double) SvNV(DataRef);
              RETVAL = CDFlib(PUT_, rVAR_DATA_, &buffer, NULL_);
              break;
           }
/*
           case CDF_EPOCH16: {
              double buffer[2];
              buffer[0] = (double) SvNV(*(av_fetch(DataRef, 0, 0)));
              buffer[1] = (double) SvNV(*(av_fetch(DataRef, 1, 0))); 
              RETVAL = CDFlib(PUT_, rVAR_DATA_, buffer, NULL_);
              break;
           }
*/
           case CDF_REAL4:
           case CDF_FLOAT: {
              float buffer;
              buffer = (float) SvNV(DataRef);
              RETVAL = CDFlib(PUT_, rVAR_DATA_, &buffer, NULL_);
              break;
           }
           case CDF_INT4: {
              I32 buffer;
              buffer = (I32) SvIV(DataRef);
              RETVAL = CDFlib(PUT_, rVAR_DATA_, &buffer, NULL_);
              break;
           }
           case CDF_INT8:
           case CDF_TIME_TT2000: {
              long long buffer;
              if (SvIOK(DataRef)) {
                buffer = (long long) SvIV(DataRef);
              } else if (SvNOK(DataRef)) {
                buffer = (long long) SvNV(DataRef);
              } else {
                sscanf(SvPV_nolen(DataRef),"%lld",&buffer);
              }
              RETVAL = CDFlib(PUT_, rVAR_DATA_, &buffer, NULL_);
              break;
           }
           case CDF_UINT4: {
              U32 buffer;
              buffer = (U32) SvIV(DataRef);
              RETVAL = CDFlib(PUT_, rVAR_DATA_, &buffer, NULL_);
              break;
           }
           case CDF_INT2: {
              I16 buffer;
              buffer = (I16) SvIV(DataRef);
              RETVAL = CDFlib(PUT_, rVAR_DATA_, &buffer, NULL_);
              break;
           }
           case CDF_UINT2: {
              U16 buffer;
              buffer = (U16) SvIV(DataRef);
              RETVAL = CDFlib(PUT_, rVAR_DATA_, &buffer, NULL_);
              break;
           }
           default:        {
              printf ("Put variable: Bad Datatype = %ld \n", DataType);
           }
          }
        }
        OUTPUT:
        RETVAL

CDFstatus
CDFvarPutXA(AnyId, varNum, recNum, ArrayRef, DataRef)
        CDFid   AnyId
        long    varNum
        long    recNum
        AV *	ArrayRef
        AV *    DataRef
        CODE:
        {
          long LongArray[CDF_MAX_DIMS], DataType, numElems;
          I32 count, i;
          count = (int) av_len(ArrayRef);
          if (count < 0)
            printf(" Put Variable: No indices specified\n");
          else {
            for ( i=0 ; i<=count ; i++)
              LongArray[i] = (long)SvIV(*(av_fetch(ArrayRef, i, 0)));
          }
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                                   rVAR_, varNum,
                                   rVARs_RECNUMBER_, recNum,
                                   rVARs_DIMINDICES_, LongArray,
			  GET_, rVAR_DATATYPE_, &DataType,
				rVAR_NUMELEMS_, &numElems,
			  NULL_);
          switch (DataType) {
           case CDF_EPOCH16: {
              double * buffer;
              New(42, buffer, 2, double);
/*              *buffer = (double) SvNV(DataRef); */
              buffer[0] = (double) SvNV(*(av_fetch(DataRef, 0, 0)));
              buffer[1] = (double) SvNV(*(av_fetch(DataRef, 1, 0))); 
              RETVAL = CDFlib(PUT_, rVAR_DATA_, buffer, NULL_);
              Safefree(buffer);
              break;
           }
           default:        {
              printf ("Put variable: Bad Datatype = %ld \n", DataType);
           }
          }
        }
        OUTPUT:
        RETVAL

CDFstatus
CDFvarGetX(AnyId, varNum, recNum, ArrayRef, DataRef)
        CDFid   AnyId
        long    varNum
        long    recNum
        AV *	ArrayRef
        SV *    DataRef = NO_INIT
        CODE:
        {
          long LongArray[CDF_MAX_DIMS], DataType, numElems;
          I32 count, i;
          count = (int) av_len(ArrayRef);
          if (count < 0)
            printf(" Get Variable: No indices specified\n");
          else {
            for ( i=0 ; i<=count ; i++)
              LongArray[i] = (long)SvIV(*(av_fetch(ArrayRef, i, 0)));
          }
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                                   rVAR_, varNum,
                                   rVARs_RECNUMBER_, recNum,
                                   rVARs_DIMINDICES_, LongArray,
			  GET_, rVAR_DATATYPE_, &DataType,
				rVAR_NUMELEMS_, &numElems,
			  NULL_);
          DataRef = (SV *) SvRV(ST(4));
          switch (DataType) {
           case CDF_UCHAR:
           case CDF_CHAR:  {
              char *  buffer;
              int x, iend;
              New(42, buffer, numElems+1, char);
              RETVAL = CDFlib(GET_, rVAR_DATA_, buffer, NULL_);
              *(buffer+numElems) = '\0';
              iend = numElems;
              for (x = 0; x < numElems; ++x) {
                if (*(buffer+x) == '\0') {
                  iend = x;
                  break;
                }
              }
              sv_setpvn(DataRef, buffer, iend);
              Safefree(buffer);
              break;
           }
/*
           case CDF_UCHAR:  {
              void * buffer;
              New(42, buffer, numElems+1, unsigned char);
              RETVAL = CDFlib(GET_, rVAR_DATA_, buffer, NULL_);
              sv_setpvn(DataRef, (char *)buffer, numElems);
              Safefree(buffer);
              break;
           }
*/
           case CDF_BYTE:
           case CDF_INT1:  {
              I8    buffer;
              RETVAL = CDFlib(GET_, rVAR_DATA_, &buffer, NULL_);
              sv_setiv(DataRef, (IV) buffer);
              break;
           }
           case CDF_UINT1: {
              U8    buffer;
              RETVAL = CDFlib(GET_, rVAR_DATA_, &buffer, NULL_);
              sv_setiv(DataRef, (IV) buffer);
              break;
           }
           case CDF_EPOCH:
           case CDF_DOUBLE:
           case CDF_REAL8: {
              double buffer;
              RETVAL = CDFlib(GET_, rVAR_DATA_, &buffer, NULL_);
              sv_setnv(DataRef, (double) buffer);
              break;
           }
/*
           case CDF_EPOCH16: {
              double buffer[2];
              RETVAL = CDFlib(GET_, rVAR_DATA_, buffer, NULL_);
              for (i=0 ; i < 2; i++)
                av_push(DataRef, newSVnv((double)buffer[i]));
              break;
           }
*/
           case CDF_REAL4:
           case CDF_FLOAT: {
              float buffer;
              RETVAL = CDFlib(GET_, rVAR_DATA_, &buffer, NULL_);
              sv_setnv(DataRef, (double) buffer);
              break;
           }
           case CDF_INT4: {
              I32 buffer;
              RETVAL = CDFlib(GET_, rVAR_DATA_, &buffer, NULL_);
              sv_setiv(DataRef, (IV) buffer);
              break;
           }
           case CDF_INT8:
           case CDF_TIME_TT2000: {
              long long buffer;
              char str[25];
              RETVAL = CDFlib(GET_, rVAR_DATA_, &buffer, NULL_);
              snprintf(str, 24, "%lld", buffer);
              sv_setpvn(DataRef, str, strlen(str));
              break;
           }
           case CDF_UINT4: {
              U32 buffer;
              RETVAL = CDFlib(GET_, rVAR_DATA_, &buffer, NULL_);
              sv_setiv(DataRef, (IV) buffer);
              break;
           }
           case CDF_INT2: {
              I16 buffer;
              RETVAL = CDFlib(GET_, rVAR_DATA_, &buffer, NULL_);
              sv_setiv(DataRef, (IV) buffer);
              break;
           }
           case CDF_UINT2: {
              U16 buffer;
              RETVAL = CDFlib(GET_, rVAR_DATA_, &buffer, NULL_);
              sv_setiv(DataRef, (IV) buffer);
              break;
           }
           default:        {
              printf ("Get Variable: Bad Datatype = %ld \n", DataType);
           }
          }
        }
        OUTPUT:
	DataRef
        RETVAL

CDFstatus
CDFvarGetXA(AnyId, varNum, recNum, ArrayRef, DataRef)
        CDFid   AnyId
        long    varNum
        long    recNum
        AV *	ArrayRef
        AV *    DataRef
        CODE:
        {
          long LongArray[CDF_MAX_DIMS], DataType, numElems;
          I32 count, i;
          count = (int) av_len(ArrayRef);
          if (count < 0)
            printf(" Get Variable: No indices specified\n");
          else {
            for ( i=0 ; i<=count ; i++)
              LongArray[i] = (long)SvIV(*(av_fetch(ArrayRef, i, 0)));
          }
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                                   rVAR_, varNum,
                                   rVARs_RECNUMBER_, recNum,
                                   rVARs_DIMINDICES_, LongArray,
			  GET_, rVAR_DATATYPE_, &DataType,
				rVAR_NUMELEMS_, &numElems,
			  NULL_);
          switch (DataType) {
           case CDF_EPOCH16: {
              double buffer[2];
              RETVAL = CDFlib(GET_, rVAR_DATA_, buffer, NULL_);
              for (i=0 ; i < 2; i++)
                av_push(DataRef, newSVnv((double)buffer[i]));
              break;
           }
           default:        {
              printf ("Get Variable: Bad Datatype = %ld \n", DataType);
           }
          }
        }
        OUTPUT:
	DataRef
        RETVAL

CDFstatus
CDFvHpGetX(AnyId, varNum, recStart, recCount, recInterval, indicesRef, countsRef, intervalsRef, DataRef)
        CDFid   AnyId
        long    varNum
        long    recStart
        long    recCount
        long    recInterval
        AV *	indicesRef
	AV *	countsRef
	AV *	intervalsRef
        AV *    DataRef = NO_INIT
        CODE:
        {
          long LongArray1[CDF_MAX_DIMS], LongArray2[CDF_MAX_DIMS];
	  long LongArray3[CDF_MAX_DIMS], DataType, numElems, numDims;
          I32 count, i, numValues;
          count = (int) av_len(indicesRef);
          if (count < 0)
            printf(" HyperGet Variable: No indices specified\n");
          else {
            for ( i=0 ; i<=count ; i++) {
              LongArray1[i] = (long)SvIV(*(av_fetch(indicesRef, i, 0)));
              LongArray2[i] = (long)SvIV(*(av_fetch(countsRef, i, 0)));
              LongArray3[i] = (long)SvIV(*(av_fetch(intervalsRef, i, 0)));
	    }
          }
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                                   rVAR_, varNum,
                                   rVARs_RECNUMBER_, recStart,
                                   rVARs_RECCOUNT_, recCount,
                                   rVARs_RECINTERVAL_, recInterval,
                                   rVARs_DIMINDICES_, LongArray1,
                                   rVARs_DIMCOUNTS_, LongArray2,
                                   rVARs_DIMINTERVALS_, LongArray3,
			  GET_, rVAR_DATATYPE_, &DataType,
				rVAR_NUMELEMS_, &numElems,
				rVARs_NUMDIMS_, &numDims,
			  NULL_);
	  numValues = recCount;
          for (i = 0; i<numDims ; i++) numValues *= LongArray2[i];
          DataRef = (AV *) SvRV(ST(8));
	  av_clear(DataRef);
          switch (DataType) {
           case CDF_UCHAR:
           case CDF_CHAR:  {
              char *  buffer;
              char *  temp;
              int x, iend;
              New(42, buffer, numValues*numElems+1, char);
              New(42, temp, numElems+1, char);
              RETVAL = CDFlib(GET_, rVAR_HYPERDATA_, buffer, NULL_);
              *(buffer+numValues*numElems) = '\0';
              for (i=0; i < numValues; i++) {
                memcpy (temp, buffer+i*numElems, numElems);
                *(temp+numElems) = '\0';
                iend = numElems;
                for (x = 0; x < numElems; ++x) {
                  if (*(temp+x) == '\0') {
                    iend = x;
                    break;
                  }
                }
                av_push(DataRef, newSVpv(temp, iend));
              }
              Safefree(buffer); 
              Safefree(temp);
              break;
           }
/*
           case CDF_UCHAR:  {
              void * buffer;
              void * temp;
              New(42, buffer, numValues*numElems+1, unsigned char);
              New(42, temp, numElems+1, unsigned char);
              RETVAL = CDFlib(GET_, rVAR_HYPERDATA_, buffer, NULL_);
              for (i=0 ; i < numValues; i++)
                av_push(DataRef, newSVpv(strncpy((char *)temp, 
						 (char *)buffer+i*numElems,
                                                 numElems), numElems));
              Safefree(buffer);
              Safefree(temp);
              break;
           }
*/
           case CDF_BYTE:
           case CDF_INT1:  {
              I8 *    buffer;
              New(42, buffer, numValues, I8);
              RETVAL = CDFlib(GET_, rVAR_HYPERDATA_, buffer, NULL_);
              for (i=0 ; i < numValues; i++)
                av_push(DataRef, newSViv((I8)buffer[i]));
              Safefree(buffer);
              break;
           }
           case CDF_UINT1: {
              U8 *    buffer;
              New(42, buffer, numValues, U8);
              RETVAL = CDFlib(GET_, rVAR_HYPERDATA_, buffer, NULL_);
              for (i=0 ; i < numValues; i++)
                av_push(DataRef, newSViv((U8)buffer[i]));
              Safefree(buffer);
              break;
           }
           case CDF_EPOCH:
           case CDF_DOUBLE:
           case CDF_REAL8: {
              double * buffer;
              New(42, buffer, numValues, double);
              RETVAL = CDFlib(GET_, rVAR_HYPERDATA_, buffer, NULL_);
              for (i=0; i < numValues ; i++)
                av_push(DataRef, newSVnv((double)buffer[i]));
              Safefree(buffer);
              break;
           }
           case CDF_EPOCH16: {
              double * buffer;
              New(42, buffer, 2*numValues, double);
              RETVAL = CDFlib(GET_, rVAR_HYPERDATA_, buffer, NULL_);
              for (i=0; i < 2*numValues ; i++)
                av_push(DataRef, newSVnv((double)buffer[i]));
              Safefree(buffer);
              break;
           }
           case CDF_REAL4:
           case CDF_FLOAT: {
              float * buffer;
              New(42, buffer, numValues, float);
              RETVAL = CDFlib(GET_, rVAR_HYPERDATA_, buffer, NULL_);
              for (i=0; i < numValues ; i++)
                av_push(DataRef, newSVnv((float)buffer[i]));
              Safefree(buffer);
              break;
           }
           case CDF_INT4: {
              I32 * buffer;
              New(42, buffer, numValues, I32);
              RETVAL = CDFlib(GET_, rVAR_HYPERDATA_, buffer, NULL_);
              for (i=0; i < numValues ; i++)
                av_push(DataRef, newSViv((IV)buffer[i]));
	      Safefree(buffer);
              break;
           }
           case CDF_INT8:
           case CDF_TIME_TT2000: {
              double * buffer;
              long long tmp;
              char str[25];
              New(42, buffer, numValues, double);
              RETVAL = CDFlib(GET_, rVAR_HYPERDATA_, buffer, NULL_);
              for (i=0; i < numValues ; i++) {
                memcpy(&tmp, buffer+i, 8);
                snprintf(str, 24, "%lld", tmp);
                av_push(DataRef, newSVpvn(str, strlen(str)));
	      }
              Safefree(buffer);
              break;
           }
           case CDF_UINT4: {
              U32 * buffer;
              New(42, buffer, numValues, U32);
              RETVAL = CDFlib(GET_, rVAR_HYPERDATA_, buffer, NULL_);
              for (i=0; i < numValues ; i++)
                av_push(DataRef, newSViv((IV)buffer[i]));
              Safefree(buffer);
              break;
           }
           case CDF_INT2: {
              I16 * buffer;
              New(42, buffer, numValues, I16);
              RETVAL = CDFlib(GET_, rVAR_HYPERDATA_, buffer, NULL_);
              for (i=0; i < numValues ; i++)
                av_push(DataRef, newSViv((IV)buffer[i]));
              Safefree(buffer);
              break;
           }
           case CDF_UINT2: {
              U16 * buffer;
              New(42, buffer, numValues, U16);
              RETVAL = CDFlib(GET_, rVAR_HYPERDATA_, buffer, NULL_);
              for (i=0; i < numValues ; i++)
                av_push(DataRef, newSViv((IV)buffer[i]));
              Safefree(buffer);
              break;
           }
           default:        {
              printf ("HyperGet Data: Bad Datatype = %ld \n", DataType);
           }
          }
        }
        OUTPUT:
	DataRef
        RETVAL

CDFstatus
CDFvHpPutX(AnyId, varNum, recStart, recCount, recInterval, indicesRef, countsRef, intervalsRef, DataRef)
        CDFid   AnyId
        long    varNum
        long    recStart
        long    recCount
        long    recInterval
        AV *	indicesRef
	AV *	countsRef
	AV *	intervalsRef
        AV *    DataRef 
        CODE:
        {
          long LongArray1[CDF_MAX_DIMS], LongArray2[CDF_MAX_DIMS];
	  long LongArray3[CDF_MAX_DIMS], DataType, numElems, numDims;
          I32 count, i, numValues, j;
          count = (int) av_len(indicesRef);
          if (count < 0)
            printf(" HyperPut Variable: No indices specified\n");
          else {
            for ( i=0 ; i<=count ; i++) {
              LongArray1[i] = (long)SvIV(*(av_fetch(indicesRef, i, 0)));
              LongArray2[i] = (long)SvIV(*(av_fetch(countsRef, i, 0)));
              LongArray3[i] = (long)SvIV(*(av_fetch(intervalsRef, i, 0)));
	    }
          }
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                                   rVAR_, varNum,
                                   rVARs_RECNUMBER_, recStart,
                                   rVARs_RECCOUNT_, recCount,
                                   rVARs_RECINTERVAL_, recInterval,
                                   rVARs_DIMINDICES_, LongArray1,
                                   rVARs_DIMCOUNTS_, LongArray2,
                                   rVARs_DIMINTERVALS_, LongArray3,
			  GET_, rVAR_DATATYPE_, &DataType,
				rVAR_NUMELEMS_, &numElems,
				rVARs_NUMDIMS_, &numDims,
			  NULL_);
	  numValues = recCount;
          for (i = 0; i<numDims ; i++) numValues *= LongArray2[i];
          switch (DataType) {
           case CDF_UCHAR:
           case CDF_CHAR:  {
              char *  buffer;
              char *  temp;
	      STRLEN len;
              New(42, buffer, numValues*numElems+1, char);
              New(42, temp, numElems+1, char);
              for (i=0 ; i < numValues; i++) {
                 strncpy(temp, SvPV(*(av_fetch(DataRef, i, 0)), len),
			 numElems);
                 *(temp+numElems) = '\0';
                 if ((int) strlen(temp) < (int) numElems) {
                   for (j=(int)strlen(temp); j<(int)numElems; j++)
                     temp[j] = '\0';
                 }
                 strncpy(buffer+i*numElems, temp, numElems);
              }
              RETVAL = CDFlib(PUT_, rVAR_HYPERDATA_, buffer, NULL_);
              Safefree(buffer); 
              Safefree(temp);
              break;
           }
/*
           case CDF_UCHAR:  {
              void * buffer;
              void * temp;
	      STRLEN len;
              New(42, buffer, numValues*numElems+1, unsigned char);
              New(42, temp, numElems+1, unsigned char);
              for (i=0 ; i < numValues; i++) {
                 strncpy((char *)temp, SvPV(*(av_fetch(DataRef, i, 0)), len),
			 numElems+1);
                 if ((int) strlen((char *)temp) < (int) numElems) {
                   for (j=(int)strlen((char *)temp); j<(int)numElems; j++) 
			*(((char *)temp)+j) = '\0';
                   *(((char *)temp)+numElems) = '\0';
                 }
                 strncpy((char *)buffer+i*numElems, (char *)temp, numElems+1);
              }
              RETVAL = CDFlib(PUT_, rVAR_HYPERDATA_, buffer, NULL_);
              Safefree(buffer);
              Safefree(temp);
              break;
           }
*/
           case CDF_BYTE:
           case CDF_INT1:  {
              I8 *    buffer;
              New(42, buffer, numValues, I8);
              for (i=0 ; i < numValues; i++)
                 buffer[i] = (I8) SvIV(*(av_fetch(DataRef, i, 0)));
              RETVAL = CDFlib(PUT_, rVAR_HYPERDATA_, buffer, NULL_);
              Safefree(buffer);
              break;
           }
           case CDF_UINT1: {
              U8 *    buffer;
              New(42, buffer, numValues, U8);
              for (i=0 ; i < numValues; i++)
                 buffer[i] = (U8) SvIV(*(av_fetch(DataRef, i, 0)));
              RETVAL = CDFlib(PUT_, rVAR_HYPERDATA_, buffer, NULL_);
              Safefree(buffer);
              break;
           }
           case CDF_EPOCH:
           case CDF_DOUBLE:
           case CDF_REAL8: {
              double * buffer;
              New(42, buffer, numValues, double);
              for (i=0; i<numValues; i++)
                buffer[i] = (double) SvNV(*(av_fetch(DataRef, i, 0)));
              RETVAL = CDFlib(PUT_, rVAR_HYPERDATA_, buffer, NULL_);
              Safefree(buffer);
              break;
           }
           case CDF_EPOCH16: {
              double * buffer;
              New(42, buffer, 2*numValues, double);
              for (i=0; i<2*numValues; i++)
                buffer[i] = (double) SvNV(*(av_fetch(DataRef, i, 0)));
              RETVAL = CDFlib(PUT_, rVAR_HYPERDATA_, buffer, NULL_);
              Safefree(buffer);
              break;
           }
           case CDF_REAL4:
           case CDF_FLOAT: {
              float * buffer;
              New(42, buffer, numValues, float);
              for (i=0; i<numValues; i++)
                buffer[i] = (float) SvNV(*(av_fetch(DataRef, i, 0)));
              RETVAL = CDFlib(PUT_, rVAR_HYPERDATA_, buffer, NULL_);
              Safefree(buffer);
              break;
           }
           case CDF_INT4: {
              I32 * buffer;
              New(42, buffer, numValues, I32);
              for (i=0; i<numValues; i++)
                buffer[i] = (I32) SvIV(*(av_fetch(DataRef, i, 0)));
              RETVAL = CDFlib(PUT_, rVAR_HYPERDATA_, buffer, NULL_);
	      Safefree(buffer);
              break;
           }
           case CDF_INT8:
           case CDF_TIME_TT2000: {
              double * buffer;
              SV **value;
              long long tmp;
              New(42, buffer, numValues, double);
              for (i=0 ; i < numValues; i++) {
                value = av_fetch(DataRef, i, 0);
                if (SvIOK(*value)) {
                  tmp = (long long) SvIV(*value);
                } else if (SvNOK(*value)) {
                  tmp = (long long) SvNV(*value);
                } else {
                  sscanf(SvPV_nolen(*value),"%lld",&tmp);
                }
                memcpy (buffer+i, &tmp, 8);
              }
              RETVAL = CDFlib(PUT_, rVAR_HYPERDATA_, buffer, NULL_);
	      Safefree(buffer);
              break;
           }
           case CDF_UINT4: {
              U32 * buffer;
              New(42, buffer, numValues, U32);
              for (i=0; i<numValues; i++)
                buffer[i] = (U32) SvIV(*(av_fetch(DataRef, i, 0)));
              RETVAL = CDFlib(PUT_, rVAR_HYPERDATA_, buffer, NULL_);
              Safefree(buffer);
              break;
           }
           case CDF_INT2: {
              I16 * buffer;
              New(42, buffer, numValues, I16);
              for (i=0; i<numValues; i++)
                buffer[i] = (I16) SvIV(*(av_fetch(DataRef, i, 0)));
              RETVAL = CDFlib(PUT_, rVAR_HYPERDATA_, buffer, NULL_);
              Safefree(buffer);
              break;
           }
           case CDF_UINT2: {
              U16 * buffer;
              New(42, buffer, numValues, U16);
              for (i=0; i<numValues; i++)
                buffer[i] = (U16) SvIV(*(av_fetch(DataRef, i, 0)));
              RETVAL = CDFlib(PUT_, rVAR_HYPERDATA_, buffer, NULL_);
              Safefree(buffer);
              break;
           }
           default:        {
              printf ("HyperPut Data: Bad Datatype = %ld \n", DataType);
           }
          }
        }
        OUTPUT:
        RETVAL

CDFstatus
CDFvarCloseX(AnyId, varNum)
        CDFid   AnyId
        long    varNum
        CODE:
        {
          RETVAL = CDFlib(SELECT_, CDF_, AnyId, 
                                   rVAR_, varNum,
			  CLOSE_, rVAR_,
                          NULL_);
	}
        OUTPUT:
        RETVAL


void
CDFsetFileBackwardX(flag)
        int    flag
        CODE:
        {
          CDFsetFileBackward(flag);
        }

int
CDFgetFileBackwardX()
        CODE:
        {
          RETVAL = CDFgetFileBackward();
        }
        OUTPUT:
        RETVAL

CDFstatus
CDFsetChecksumX(AnyId, chksum)
        CDFid   AnyId
        long    chksum
        CODE:
        {
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                          PUT_, CDF_CHECKSUM_, chksum,
                          NULL_);
        }
        OUTPUT:
        RETVAL
        
CDFstatus 
CDFgetChecksumX(AnyId, checksum)
        CDFid   AnyId
        long    checksum = NO_INIT
        CODE:
        {
          RETVAL = CDFlib(SELECT_, CDF_, AnyId,
                          GET_, CDF_CHECKSUM_, &checksum,
                          NULL_);
        }
        OUTPUT:
        checksum
        RETVAL

void
CDFsetValidateX(validate)
        long     validate
        CODE:
        {
          CDFsetValidate(validate);
        }
        
int 
CDFgetValidateX()
        CODE:
        {
          RETVAL = CDFgetValidate();
        }
        OUTPUT:
        RETVAL

double
computeEPOCHX(year, month, day, hour, minute, second, msec)
	long year
	long month
	long day
	long hour
	long minute
	long second
	long msec
        CODE:
        {
          RETVAL = computeEPOCH(year, month, day, hour, minute, second,
                                msec);
        }
        OUTPUT:
        RETVAL
	
void
computeTT2000X(year, month, day, hour, minute, second, msec, asec, nsec, tt2000Str)
	double year
	double month
	double day
	double hour
	double minute
	double second
	double msec
        double asec
        double nsec
        char * tt2000Str = NO_INIT
        CODE:
                long long tt2000;
                char str[100];
                tt2000 = computeTT2000(year, month, day, hour, minute,
                                       second, msec, asec, nsec);
                tt2000Str = str;
                snprintf(tt2000Str, 24, "%lld", tt2000);
        OUTPUT:
        tt2000Str
	
void
EPOCHbreakdown(epoch, year, month, day, hour, minute, second, msec)
	double	epoch
	long	year = NO_INIT
	long	month = NO_INIT
	long	day = NO_INIT
	long	hour = NO_INIT
	long	minute = NO_INIT
	long	second = NO_INIT
	long	msec = NO_INIT
  	CODE:
		EPOCHbreakdown(epoch, &year, &month, &day, &hour, &minute, 
			       &second, &msec);
	OUTPUT:	
	year
	month
	day
	hour
	minute
	second
	msec
	
void
TT2000breakdown(tt2000, year, month, day, hour, minute, second, msec, asec, nsec)
	SV *	tt2000
	double	year = NO_INIT
	double	month = NO_INIT
	double	day = NO_INIT
	double	hour = NO_INIT
	double	minute = NO_INIT
	double	second = NO_INIT
	double	msec = NO_INIT
	double	asec = NO_INIT
	double	nsec = NO_INIT
  	CODE:
            long long tt2000n = 0LL;
            if (SvIOK(tt2000)) {
              tt2000n = (long long) SvIV(tt2000);
            } else if (SvNOK(tt2000)) {
              tt2000n = (long long) SvNV(tt2000);
            } else {
              sscanf(SvPV_nolen(tt2000),"%lld",&tt2000n);
            }
		TT2000breakdown(tt2000n, &year, &month, &day, &hour, &minute, 
			        &second, &msec, &asec, &nsec);
	OUTPUT:	
	year
	month
	day
	hour
	minute
	second
	msec
	asec
	nsec
	
double
parseEPOCHX(EpochString)
	char *	EpochString
        CODE:
          RETVAL = toParseEPOCH(EpochString);
        OUTPUT:
        RETVAL

	
void
parseTT2000X(TT2000String, tt2000Str)
	char *	TT2000String
        char *  tt2000Str = NO_INIT
        CODE:
                long long tt2000;
                char tmp[25];
                tt2000 = toParseTT2000(TT2000String);
                tt2000Str = tmp;
                snprintf(tt2000Str, 24, "%lld", tt2000);
        OUTPUT:
        tt2000Str

double
parseEPOCH1(EpochString)
	char *	EpochString
	
double
parseEPOCH2(EpochString)
	char *	EpochString
	
double
parseEPOCH3(EpochString)
	char *	EpochString
	
double
parseEPOCH4(EpochString)
	char *	EpochString
	
void
EPOCH16toUnixTimeX(EpochRef, unixTimeRef)
	AV * EpochRef
        AV * unixTimeRef = NO_INIT
	CODE:
	{
          I32 i, count;
          double *data0, *data;
          unixTimeRef = (AV *) SvRV(ST(1));
          count = (int) av_len(EpochRef);
          ++count;
          count = count / 2;
          New(42, data0, 2*count, double);
          New(42, data, count, double);
          for (i=0 ; i<2*count ; i++) {
            data0[i] = (double)SvNV(*(av_fetch(EpochRef, i, 0)));
          }
	  EPOCH16toUnixTime(data0, data, count);
          for (i=0 ; i < count; i++)
            av_push(unixTimeRef, newSVnv(data[i]));
          Safefree(data0);
          Safefree(data);
	}
  	OUTPUT:
	unixTimeRef

void
TT2000toUnixTimeX(EpochRef, unixTimeRef)
	AV * EpochRef
        AV * unixTimeRef = NO_INIT
	CODE:
	{
          I32 i, count;
          double *data0, *data;
          SV **value;
          long long tmp;
          unixTimeRef = (AV *) SvRV(ST(1));
          count = (int) av_len(EpochRef);
          New(42, data0, count+1, double);
          New(42, data, count+1, double);
          for (i=0 ; i <= count; i++) {
            value = av_fetch(EpochRef, i, 0);
            if (SvIOK(*value)) {
              tmp = (long long) SvIV(*value);
            } else if (SvNOK(*value)) {
              tmp = (long long) SvNV(*value);
            } else {
              sscanf(SvPV_nolen(*value),"%lld",&tmp);
            }
            memcpy (data0+i, &tmp, 8);
          }
	  TT2000toUnixTime((long long *)data0, data, count+1);
          for (i=0 ; i <= count; i++) {
            av_push(unixTimeRef, newSVnv(data[i]));
          }
          Safefree(data0);
          Safefree(data);
	}
  	OUTPUT:
	unixTimeRef

void
EPOCHtoUnixTimeX(EpochRef, unixTimeRef)
	AV * EpochRef
        AV * unixTimeRef = NO_INIT
	CODE:
	{
          I32 i, count;
          double *data0, *data;
          unixTimeRef = (AV *) SvRV(ST(1));
          count = (int) av_len(EpochRef);
          New(42, data0, count+1, double);
          New(42, data, count+1, double);
          for (i=0 ; i<=count ; i++) {
            data0[i] = (double)SvNV(*(av_fetch(EpochRef, i, 0)));
          }
	  EPOCHtoUnixTime(data0, data, count+1);
          for (i=0 ; i <= count; i++)
            av_push(unixTimeRef, newSVnv(data[i]));
          Safefree(data0);
          Safefree(data);
	}
  	OUTPUT:
	unixTimeRef

void
UnixTimetoEPOCHX(unixTimeRef, epochRef)
	AV * unixTimeRef
        AV * epochRef = NO_INIT
	CODE:
	{
          I32 i, count;
          double *data0, *data;
          epochRef = (AV *) SvRV(ST(1));
          count = (int) av_len(unixTimeRef);
          New(42, data0, count+1, double);
          New(42, data, count+1, double);
          for (i=0 ; i<=count ; i++) {
            data0[i] = (double)SvNV(*(av_fetch(unixTimeRef, i, 0)));
          }
	  UnixTimetoEPOCH(data0, data, count+1);
          for (i=0 ; i <= count; i++)
            av_push(epochRef, newSVnv(data[i]));
          Safefree(data0);
          Safefree(data);
	}
  	OUTPUT:
	epochRef

void
UnixTimetoEPOCH16X(unixTimeRef, epochRef)
	AV * unixTimeRef
        AV * epochRef = NO_INIT
	CODE:
	{
          I32 i, count;
          double *data0, *data;
          epochRef = (AV *) SvRV(ST(1));
          count = (int) av_len(unixTimeRef);
          ++count;
          New(42, data0, count, double);
          New(42, data, 2*count, double);
          for (i=0 ; i<count ; i++) {
            data0[i] = (double)SvNV(*(av_fetch(unixTimeRef, i, 0)));
          }
	  UnixTimetoEPOCH16(data0, data, count);
          for (i=0 ; i < count*2; i++)
            av_push(epochRef, newSVnv(data[i]));
          Safefree(data0);
          Safefree(data);
	}
  	OUTPUT:
	epochRef

void
UnixTimetoTT2000X(unixTimeRef, epochRef)
	AV * unixTimeRef
        AV * epochRef = NO_INIT
	CODE:
	{
          I32 i, count;
          double *data0, *data;
          long long tmp;
          char   str[25];
          epochRef = (AV *) SvRV(ST(1));
          count = (int) av_len(unixTimeRef);
          New(42, data0, count+1, double);
          New(42, data, count+1, double);
          for (i=0 ; i<=count ; i++) {
            data0[i] = (double)SvNV(*(av_fetch(unixTimeRef, i, 0)));
          }
	  UnixTimetoTT2000(data0, (long long *)data, count+1);
          for (i=0 ; i <= (int) count; i++) {
            memcpy (&tmp, data+i, 8);
            snprintf(str, 24, "%lld", tmp);
            av_push(epochRef, newSVpvn(str, strlen(str)));
          }
          Safefree(data0);
          Safefree(data);
	}
  	OUTPUT:
	epochRef

void
encodeEPOCHX(Epoch, EpochString)
	double Epoch
	char *	EpochString = NO_INIT
	CODE:
	{
	  char temp[EPOCH_STRING_LEN+1];
	  EpochString = temp;
	  encodeEPOCH(Epoch, EpochString);
	}
  	OUTPUT:
	EpochString
	
void
encodeEPOCH16X(Epoch16Ref, EpochString)
	AV * Epoch16Ref
	char *	EpochString = NO_INIT
	CODE:
	{
          int i;
          char temp[EPOCH16_STRING_LEN+1];
          double epoch[2];
          for (i=0; i<2; i++)
             epoch[i] = (double) SvNV(*(av_fetch(Epoch16Ref, i, 0)));
          EpochString = temp;
          encodeEPOCH16(epoch, EpochString);
        }
        OUTPUT:
        EpochString
	
void
encodeTT2000X(TT2000, TT2000String, style)
	SV *   TT2000
	char *	TT2000String = NO_INIT
        int    style
	CODE:
	{
          char temp[TT2000_0_STRING_LEN+1];
	  long long tt2000n = 0LL;
          if (SvIOK(TT2000)) {
            tt2000n = (long long) SvIV(TT2000);
          } else if (SvNOK(TT2000)) {
            tt2000n = (long long) SvNV(TT2000);
          } else {
            sscanf(SvPV_nolen(TT2000),"%lld",&tt2000n);
          }
          TT2000String = temp;
	  encodeTT2000(tt2000n, TT2000String, style);
	}
  	OUTPUT:
	TT2000String
	
void
encodeEPOCH1(Epoch, EpochString)
	double Epoch
	char *	EpochString = NO_INIT
	CODE:
	{
	  char temp[EPOCH1_STRING_LEN+1];
	  EpochString = temp;
	  encodeEPOCH1(Epoch, EpochString);
	}
  	OUTPUT:
	EpochString
	
void
encodeEPOCH2(Epoch, EpochString)
	double Epoch
	char *	EpochString = NO_INIT
	CODE:
	{
	  char temp[EPOCH2_STRING_LEN+1];
	  EpochString = temp;
	  encodeEPOCH2(Epoch, EpochString);
	}
  	OUTPUT:
	EpochString
	
void
encodeEPOCH3(Epoch, EpochString)
	double Epoch
	char *	EpochString = NO_INIT
	CODE:
	{
	  char temp[EPOCH3_STRING_LEN+1];
	  EpochString = temp;
	  encodeEPOCH3(Epoch, EpochString);
	}
  	OUTPUT:
	EpochString

void
encodeEPOCH4(Epoch, EpochString)
	double Epoch
	char *	EpochString = NO_INIT
	CODE:
	{
	  char temp[EPOCH4_STRING_LEN+1];
	  EpochString = temp;
	  encodeEPOCH4(Epoch, EpochString);
	}
  	OUTPUT:
	EpochString

double
computeEPOCH16(year, month, day, hour, minute, second, msec, usec, nsec, psec, epoch16Ref)
	long year
	long month
	long day
	long hour
	long minute
	long second
	long msec
	long usec
	long nsec
	long psec
	AV * epoch16Ref
	CODE:
        {
	  int i;
	  double epoch[2];
          RETVAL = computeEPOCH16(year, month, day, hour, minute, second, 
                                  msec, usec, nsec, psec, epoch);
          for (i=0; i < 2 ; i++)
             av_push(epoch16Ref, newSVnv((double)epoch[i]));
        }
	OUTPUT:
	epoch16Ref
	RETVAL
	
void
EPOCH16breakdown(Epoch16Ref, year, month, day, hour, minute, second, msec, usec, nsec, psec)
	AV *    Epoch16Ref
	long	year = NO_INIT
	long	month = NO_INIT
	long	day = NO_INIT
	long	hour = NO_INIT
	long	minute = NO_INIT
	long	second = NO_INIT
	long	msec = NO_INIT
	long	usec = NO_INIT
	long	nsec = NO_INIT
	long	psec = NO_INIT
  	CODE:
	{
	  int i;
          double epoch[2];
          for (i=0; i<2; i++)
             epoch[i] = (double) SvNV(*(av_fetch(Epoch16Ref, i, 0)));
	  EPOCH16breakdown(epoch, &year, &month, &day, &hour, &minute, 
			   &second, &msec, &usec, &nsec, &psec);
	}
	OUTPUT:	
	year
	month
	day
	hour
	minute
	second
	msec
	usec
	nsec
	psec
	
double
parseEPOCH16X(EpochString, Epoch16Ref)
	char *	EpochString
	AV *  Epoch16Ref
        CODE:
        {
	  int i;
          double epoch[2];
          RETVAL = toParseEPOCH16(EpochString, epoch);
          for (i=0; i < 2 ; i++)
             av_push(Epoch16Ref, newSVnv(epoch[i]));
        }
	OUTPUT:
	Epoch16Ref
	RETVAL
	
double
parseEPOCH16(EpochString, Epoch16Ref)
	char *	EpochString
	AV *  Epoch16Ref
        CODE:
        {
	  int i;
          double epoch[2];
          RETVAL = parseEPOCH16(EpochString, epoch);
          for (i=0; i < 2 ; i++)
             av_push(Epoch16Ref, newSVnv(epoch[i]));
        }
	OUTPUT:
	Epoch16Ref
	RETVAL
	
double
parseEPOCH16_1(EpochString, Epoch16Ref)
	char *	EpochString
	AV *  Epoch16Ref
        CODE:
        {
	  int i;
          double epoch[2];
          RETVAL = parseEPOCH16_1(EpochString, epoch);
          for (i=0; i < 2 ; i++)
             av_push(Epoch16Ref, newSVnv(epoch[i]));
        }
	OUTPUT:
	Epoch16Ref
	RETVAL
	
double
parseEPOCH16_2(EpochString, Epoch16Ref)
	char *	EpochString
	AV *  Epoch16Ref
        CODE:
        {
	  int i;
          double epoch[2];
          RETVAL = parseEPOCH16_2(EpochString, epoch);
          for (i=0; i < 2 ; i++)
             av_push(Epoch16Ref, newSVnv(epoch[i]));
        }
	OUTPUT:
	Epoch16Ref
	RETVAL
	
double
parseEPOCH16_3(EpochString, Epoch16Ref)
	char *	EpochString
	AV *  Epoch16Ref
        CODE:
        {
	  int i;
          double epoch[2];
          RETVAL = parseEPOCH16_3(EpochString, epoch);
          for (i=0; i < 2 ; i++)
             av_push(Epoch16Ref, newSVnv(epoch[i]));
        }
	OUTPUT:
	Epoch16Ref
	RETVAL
	
double
parseEPOCH16_4(EpochString, Epoch16Ref)
	char *	EpochString
	AV *  Epoch16Ref
        CODE:
        {
	  int i;
          double epoch[2];
          RETVAL = parseEPOCH16_4(EpochString, epoch);
          for (i=0; i < 2 ; i++)
             av_push(Epoch16Ref, newSVnv(epoch[i]));
        }
	OUTPUT:
	Epoch16Ref
	RETVAL

	
void
encodeEPOCH16(Epoch16Ref, EpochString)
	AV * Epoch16Ref
	char *	EpochString = NO_INIT
	CODE:
	{
	  int i;
	  char temp[EPOCH16_STRING_LEN+1];
          double epoch[2];
          for (i=0; i<2; i++)
             epoch[i] = (double) SvNV(*(av_fetch(Epoch16Ref, i, 0)));
	  EpochString = temp;
	  encodeEPOCH16(epoch, EpochString);
	}
  	OUTPUT:
	EpochString
	
void
encodeEPOCH16_1(Epoch16Ref, EpochString)
	AV *  Epoch16Ref
	char *	EpochString = NO_INIT
	CODE:
	{
	  int i;
	  char temp[EPOCH16_1_STRING_LEN+1];
          double epoch[2]; 
          for (i=0; i<2; i++)
             epoch[i] = (double) SvNV(*(av_fetch(Epoch16Ref, i, 0)));
	  EpochString = temp;
	  encodeEPOCH16_1(epoch, EpochString);
	}
  	OUTPUT:
	EpochString
	
void
encodeEPOCH16_2(Epoch16Ref, EpochString)
	AV * Epoch16Ref
	char *	EpochString = NO_INIT
	CODE:
	{
	  int i;
	  char temp[EPOCH16_2_STRING_LEN+1];
          double epoch[2];
          for (i=0; i<2; i++)
             epoch[i] = (double) SvNV(*(av_fetch(Epoch16Ref, i, 0)));
	  EpochString = temp;
	  encodeEPOCH16_2(epoch, EpochString);
	}
  	OUTPUT:
	EpochString
	
void
encodeEPOCH16_3(Epoch16Ref, EpochString)
	AV *  Epoch16Ref
	char *	EpochString = NO_INIT
	CODE:
	{
	  int i;
	  char temp[EPOCH16_3_STRING_LEN+1];
          double epoch[2];
          for (i=0; i<2; i++)
             epoch[i] = (double) SvNV(*(av_fetch(Epoch16Ref, i, 0)));
	  EpochString = temp;
	  encodeEPOCH16_3(epoch, EpochString);
	}
  	OUTPUT:
	EpochString

void
encodeEPOCH16_4(Epoch16Ref, EpochString)
	AV *  Epoch16Ref
	char *	EpochString = NO_INIT
	CODE:
	{
	  int i;
	  char temp[EPOCH16_4_STRING_LEN+1];
          double epoch[2];
          for (i=0; i<2; i++)
             epoch[i] = (double) SvNV(*(av_fetch(Epoch16Ref, i, 0)));
	  EpochString = temp;
	  encodeEPOCH16_4(epoch, EpochString);
	}
  	OUTPUT:
	EpochString

void
leapsecondsinfoX(dump)
        int dump
        CODE:
        {
          char *table;
          double **lt = NULL;
          int fileStatus, rows, ix;
          long year, month, day;
          printf ("Info for CDF leap second table...\n");
          table = CDFgetLeapSecondsTableEnvVar();
          fileStatus = CDFgetLeapSecondsTableStatus();
          if (table == NULL) {
#if defined(vms)
            printf ("Environment Variable: CDF$LEAPSECONDSTABLE is NOT defined....\n ");
#else
            printf ("Environment Variable: CDF_LEAPSECONDSTABLE is NOT defined....\n ");
#endif
            printf ("Thus, the hard-coded table is used.\n");
          } else {
            if (fileStatus == 0) {
#if defined(vms)
              printf ("Environment Variable: CDF$LEAPSECONDSTABLE is defined as: %s\n", table);
              printf ("                      but the file is invalid....\n");
#else
              printf ("Environment Variable: CDF_LEAPSECONDSTABLE is defined as: %s\n", table);
              printf ("                      but the file is invalid....\n");
#endif
              printf ("Thus, the hard-coded table is used.\n");
            } else
              printf ("CDF's leap seconds table is based on the file: %s\n", table);
          }
#if defined(vms)
          CDFgetLastDateinLeapSecondsTBL (&year, &month, &day);
#else
          CDFgetLastDateinLeapSecondsTable (&year, &month, &day);
#endif
          printf ("The last date a leap second was added to the table is: %ld-%ld-%ld\n",
                  year, month, day);
          if (dump == 1) {
            rows = CDFgetRowsinLeapSecondsTable();
            lt = (double **) malloc (sizeof(double *) * rows);
            if (lt == NULL) {
              printf (" Error space allocation...\n");
            }
            for (ix = 0; ix < rows; ++ix) {
              lt[ix] = (double *) malloc (sizeof(double) * 6);
              if (lt[ix] == NULL) {
                printf (" Error space allocation...\n");
                free (lt);
              }
            }
            CDFfillLeapSecondsTable(lt);
            printf ("    \t     \t     \t  Leap \t\t Drift\t\t Drift\n");
            printf ("Year\tMonth\t  Day\tSeconds\t\t    1 \t\t    2\n");
            for (ix = 0; ix < rows; ++ix) {
              printf ("%lg\t  %lg\t   %lg\t%lg\t\t %lg\t\t %lg\n",lt[ix][0],
                      lt[ix][1], lt[ix][2], lt[ix][3], lt[ix][4], lt[ix][5]);
            }
          }
          CDFClearLeapSecondsTable ();
          if (lt != NULL) {
            for (ix = 0; ix < rows; ++ix) free (lt[ix]);
            free (lt);
          }
        }

void
leapsecondsinfoY(year, month, day)
        long year = NO_INIT
        long month = NO_INIT
        long day = NO_INIT
        CODE:
        {
#if defined(vms)
          CDFgetLastDateinLeapSecondsTBL (&year, &month, &day);
#else
          CDFgetLastDateinLeapSecondsTable (&year, &month, &day);
#endif
        }
        OUTPUT:
        year
        month
        day

