/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class ShortArray
extends AArray {
    public ShortArray(Object object) throws Throwable {
        super(object);
    }

    public ShortArray(Object object, boolean bl) throws Throwable {
        super(object, bl);
    }

    @Override
    public Object array() {
        switch (this.dim) {
            case 1: {
                return (short[])this.o;
            }
            case 2: {
                return (short[][])this.o;
            }
            case 3: {
                return (short[][][])this.o;
            }
            case 4: {
                return (short[][][][])this.o;
            }
        }
        return null;
    }

    @Override
    public ByteBuffer buffer(Class<?> clazz, int n) throws Throwable {
        if (clazz != Short.TYPE && clazz != Byte.TYPE) {
            throw new Throwable("Only byte and short targets supported");
        }
        if (this.dim > 4) {
            throw new Throwable("Rank > 4 not supported");
        }
        int n2 = clazz == Byte.TYPE ? 1 : 2;
        ByteBuffer byteBuffer = this.allocate(n2);
        if (clazz == Byte.TYPE) {
            return this.doByte(byteBuffer);
        }
        return this.doShort(byteBuffer);
    }

    ByteBuffer doByte(ByteBuffer byteBuffer) {
        int[] nArray = this.aa.getDimensions();
        byte[] byArray = null;
        ByteBuffer byteBuffer2 = byteBuffer;
        switch (this.dim) {
            case 1: {
                short[] sArray = (short[])this.o;
                byArray = new byte[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    byArray[i] = (byte)sArray[i];
                }
                byteBuffer2.put(byArray);
                byteBuffer.flip();
                return byteBuffer;
            }
            case 2: {
                short[][] sArray = (short[][])this.o;
                byArray = new byte[nArray[1]];
                for (int i = 0; i < nArray[0]; ++i) {
                    short[] sArray2 = sArray[i];
                    for (int j = 0; j < nArray[1]; ++j) {
                        byArray[j] = (byte)sArray2[j];
                    }
                    byteBuffer2.put(byArray);
                }
                byteBuffer.flip();
                return byteBuffer;
            }
            case 3: {
                short[][][] sArray = (short[][][])this.o;
                if (this.rowMajority) {
                    byArray = new byte[nArray[2]];
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            short[] sArray3 = sArray[i][j];
                            for (int k = 0; k < nArray[2]; ++k) {
                                byArray[k] = (byte)sArray3[k];
                            }
                            byteBuffer2.put(byArray);
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[2]; ++j) {
                            for (int k = 0; k < nArray[1]; ++k) {
                                byteBuffer2.put((byte)sArray[i][k][j]);
                            }
                        }
                    }
                }
                byteBuffer.flip();
                return byteBuffer;
            }
            case 4: {
                short[][][][] sArray = (short[][][][])this.o;
                if (this.rowMajority) {
                    byArray = new byte[nArray[3]];
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                short[] sArray4 = sArray[i][j][k];
                                for (int i2 = 0; i2 < nArray[3]; ++i2) {
                                    byArray[i2] = (byte)sArray4[i2];
                                }
                                byteBuffer2.put(byArray);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[3]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                for (int i3 = 0; i3 < nArray[1]; ++i3) {
                                    byteBuffer2.put((byte)sArray[i][i3][k][j]);
                                }
                            }
                        }
                    }
                }
                byteBuffer.flip();
                return byteBuffer;
            }
        }
        return null;
    }

    ByteBuffer doShort(ByteBuffer byteBuffer) {
        int[] nArray = this.aa.getDimensions();
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        switch (this.dim) {
            case 1: {
                short[] sArray = (short[])this.o;
                shortBuffer.put(sArray);
                return byteBuffer;
            }
            case 2: {
                short[][] sArray = (short[][])this.o;
                for (int i = 0; i < nArray[0]; ++i) {
                    shortBuffer.put(sArray[i]);
                }
                return byteBuffer;
            }
            case 3: {
                short[][][] sArray = (short[][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            shortBuffer.put(sArray[i][j]);
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[2]; ++j) {
                            for (int k = 0; k < nArray[1]; ++k) {
                                shortBuffer.put(sArray[i][k][j]);
                            }
                        }
                    }
                }
                return byteBuffer;
            }
            case 4: {
                short[][][][] sArray = (short[][][][])this.o;
                if (this.rowMajority) {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[1]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                shortBuffer.put(sArray[i][j][k]);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < nArray[0]; ++i) {
                        for (int j = 0; j < nArray[3]; ++j) {
                            for (int k = 0; k < nArray[2]; ++k) {
                                for (int i2 = 0; i2 < nArray[1]; ++i2) {
                                    shortBuffer.put(sArray[i][i2][k][j]);
                                }
                            }
                        }
                    }
                }
                return byteBuffer;
            }
        }
        return null;
    }
}

