/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.BaseVarContainer;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.FloatArray;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.LongBuffer;

public final class FloatVarContainer
extends BaseVarContainer
implements VDataContainer.CFloat {
    final float[] fpad;

    public FloatVarContainer(CDFImpl cDFImpl, Variable variable, int[] nArray, boolean bl, ByteOrder byteOrder) throws IllegalAccessException, InvocationTargetException, Throwable {
        super(cDFImpl, variable, nArray, bl, byteOrder, Float.TYPE);
        Object object = this.thisCDF.getPadValue(variable);
        if (DataTypes.typeCategory[this.type] == 5) {
            long[] lArray = (long[])object;
            this.fpad = new float[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                this.fpad[i] = lArray[i];
            }
        } else {
            double[] dArray = (double[])object;
            this.fpad = new float[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.fpad[i] = (float)dArray[i];
            }
        }
    }

    public FloatVarContainer(CDFImpl cDFImpl, Variable variable, int[] nArray, boolean bl) throws IllegalAccessException, InvocationTargetException, Throwable {
        this(cDFImpl, variable, nArray, bl, ByteOrder.nativeOrder());
    }

    @Override
    ByteBuffer allocateBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4 * n);
        byteBuffer.order(this.order);
        return byteBuffer;
    }

    @Override
    public Object allocateDataArray(int n) {
        return new float[n];
    }

    @Override
    void doMissing(int n, ByteBuffer byteBuffer, Object object, int n2) {
        int n3;
        float[] fArray = (float[])object;
        float[] fArray2 = null;
        try {
            fArray2 = n2 < 0 ? this.fpad : this.var.asFloatArray(new int[]{n2});
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println("Should not see this.");
        }
        int n4 = byteBuffer.position();
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        for (int i = n; i > 0; i -= n3) {
            n3 = i;
            if (n3 * this.elements > fArray.length) {
                n3 = fArray.length / this.elements;
            }
            int n5 = 0;
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < this.elements; ++k) {
                    fArray[n5++] = fArray2[k];
                }
            }
            floatBuffer.put(fArray, 0, n3 * this.elements);
            n4 += 4 * n3 * this.elements;
        }
        byteBuffer.position(n4);
    }

    @Override
    void doData(ByteBuffer byteBuffer, int n, int n2, int n3, ByteBuffer byteBuffer2, Object object) throws IllegalAccessException, InvocationTargetException {
        float[] fArray = (float[])object;
        int n4 = byteBuffer2.position();
        FloatBuffer floatBuffer = byteBuffer2.asFloatBuffer();
        switch (DataTypes.typeCategory[n]) {
            case 0: {
                int n5;
                int n6;
                int n7 = byteBuffer.position();
                FloatBuffer floatBuffer2 = byteBuffer.asFloatBuffer();
                for (n5 = 0; n5 < n3; n5 += n6 / n2) {
                    n6 = (n3 - n5) * n2;
                    if (n6 > fArray.length) {
                        n6 = fArray.length;
                    }
                    floatBuffer2.get(fArray, 0, n6);
                    n7 += 4 * n6;
                    floatBuffer.put(fArray, 0, n6);
                    n4 += 4 * n6;
                }
                byteBuffer.position(n7);
                byteBuffer2.position(n4);
                break;
            }
            case 1: {
                int n5;
                double[] dArray = new double[fArray.length];
                int n8 = byteBuffer.position();
                DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                while (n5 < n3) {
                    int n9 = (n3 - n5) * n2;
                    if (n9 > fArray.length) {
                        n9 = fArray.length;
                    }
                    doubleBuffer.get(dArray, 0, n9);
                    n8 += 8 * n9;
                    for (int i = 0; i < n9; ++i) {
                        fArray[i] = (float)dArray[i];
                    }
                    floatBuffer.put(fArray, 0, n9);
                    n4 += 4 * n9;
                    n5 += n9 / n2;
                }
                byteBuffer.position(n8);
                byteBuffer2.position(n4);
                break;
            }
            case 2: {
                int n5;
                Method method = DataTypes.method[n];
                while (n5 < n3) {
                    int n10 = (n3 - n5) * n2;
                    if (n10 > fArray.length) {
                        n10 = fArray.length;
                    }
                    for (int i = 0; i < n10; ++i) {
                        Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        fArray[i] = number.floatValue();
                    }
                    floatBuffer.put(fArray, 0, n10);
                    n4 += 4 * n10;
                    n5 += n10 / n2;
                }
                byteBuffer2.position(n4);
                break;
            }
            case 3: {
                int n5;
                Method method = DataTypes.method[n];
                long l = DataTypes.longInt[n];
                while (n5 < n3) {
                    int n11 = (n3 - n5) * n2;
                    if (n11 > fArray.length) {
                        n11 = fArray.length;
                    }
                    for (int i = 0; i < n11; ++i) {
                        Number number = (Number)method.invoke((Object)byteBuffer, new Object[0]);
                        int n12 = number.intValue();
                        fArray[i] = n12 >= 0 ? (float)n12 : (float)(l + (long)n12);
                    }
                    floatBuffer.put(fArray, 0, n11);
                    n4 += 4 * n11;
                    n5 += n11 / n2;
                }
                byteBuffer2.position(n4);
                break;
            }
            case 5: {
                int n5;
                int n13 = byteBuffer.position();
                LongBuffer longBuffer = byteBuffer.asLongBuffer();
                long[] lArray = new long[fArray.length];
                while (n5 < n3) {
                    int n14 = (n3 - n5) * n2;
                    if (n14 > fArray.length) {
                        n14 = fArray.length;
                    }
                    longBuffer.get(lArray, 0, n14);
                    n13 += 8 * n14;
                    for (int i = 0; i < n14; ++i) {
                        fArray[i] = lArray[i];
                    }
                    floatBuffer.put(fArray, 0, n14);
                    n4 += 4 * n14;
                    n5 += n14 / n2;
                }
                byteBuffer.position(n13);
                byteBuffer2.position(n4);
            }
        }
    }

    public static boolean isCompatible(int n, boolean bl) {
        return FloatVarContainer.isCompatible(n, bl, Float.TYPE);
    }

    public Object _asArray() throws Throwable {
        int n = this.var.getEffectiveRank();
        if (n > 4) {
            throw new Throwable("Rank > 4 not supported yet.");
        }
        ByteBuffer byteBuffer = this.getBuffer();
        if (byteBuffer == null) {
            return null;
        }
        int n2 = byteBuffer.remaining() / 4;
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        int n3 = -1;
        switch (n) {
            case 0: {
                Object object;
                float[] fArray = new float[n2];
                floatBuffer.get(fArray);
                if (this.singlePoint) {
                    Float f;
                    object = f;
                    f = new Float(fArray[0]);
                } else {
                    object = fArray;
                }
                return object;
            }
            case 1: {
                int n4 = (Integer)this.var.getElementCount().elementAt(0);
                n3 = n2 / n4;
                float[][] fArray = new float[n3][n4];
                for (int i = 0; i < n3; ++i) {
                    floatBuffer.get(fArray[i]);
                }
                return this.singlePoint ? (Object)fArray[0] : fArray;
            }
            case 2: {
                int n5 = (Integer)this.var.getElementCount().elementAt(0);
                int n6 = (Integer)this.var.getElementCount().elementAt(1);
                n3 = n2 / (n5 * n6);
                float[][][] fArray = new float[n3][n5][n6];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n5; ++j) {
                            floatBuffer.get(fArray[i][j]);
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n6; ++j) {
                            for (int k = 0; k < n5; ++k) {
                                fArray[i][k][j] = floatBuffer.get();
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)fArray[0] : fArray;
            }
            case 3: {
                int n7 = (Integer)this.var.getElementCount().elementAt(0);
                int n8 = (Integer)this.var.getElementCount().elementAt(1);
                int n9 = (Integer)this.var.getElementCount().elementAt(2);
                n3 = n2 / (n7 * n8 * n9);
                float[][][][] fArray = new float[n3][n7][n8][n9];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n7; ++j) {
                            for (int k = 0; k < n8; ++k) {
                                floatBuffer.get(fArray[i][j][k]);
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n9; ++j) {
                            for (int k = 0; k < n8; ++k) {
                                for (int i2 = 0; i2 < n7; ++i2) {
                                    fArray[i][i2][k][j] = floatBuffer.get();
                                }
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)fArray[0] : fArray;
            }
            case 4: {
                int n10 = (Integer)this.var.getElementCount().elementAt(0);
                int n11 = (Integer)this.var.getElementCount().elementAt(1);
                int n12 = (Integer)this.var.getElementCount().elementAt(2);
                int n13 = (Integer)this.var.getElementCount().elementAt(3);
                n3 = n2 / (n10 * n11 * n12 * n13);
                float[][][][][] fArray = new float[n3][n10][n11][n12][n13];
                if (this.var.rowMajority()) {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n10; ++j) {
                            for (int k = 0; k < n11; ++k) {
                                for (int i3 = 0; i3 < n12; ++i3) {
                                    floatBuffer.get(fArray[i][j][k][i3]);
                                }
                            }
                        }
                    }
                } else {
                    for (int i = 0; i < n3; ++i) {
                        for (int j = 0; j < n13; ++j) {
                            for (int k = 0; k < n12; ++k) {
                                for (int i4 = 0; i4 < n11; ++i4) {
                                    for (int i5 = 0; i5 < n10; ++i5) {
                                        fArray[i][i5][i4][k][j] = floatBuffer.get();
                                    }
                                }
                            }
                        }
                    }
                }
                return this.singlePoint ? (Object)fArray[0] : fArray;
            }
        }
        throw new Throwable("Internal error");
    }

    public void fillArray(float[] fArray, int n, int n2, int n3) throws Throwable {
        if (this.buffers.size() == 0) {
            throw new Throwable("buffer not available");
        }
        int n4 = (n3 - n2 + 1) * this.elements;
        ByteBuffer byteBuffer = this.getBuffer();
        int n5 = (n2 - this.getRecordRange()[0]) * this.elements * this.getLength();
        byteBuffer.position(n5);
        byteBuffer.asFloatBuffer().get(fArray, n, n4);
    }

    @Override
    public float[] as1DArray() {
        return (float[])super.as1DArray();
    }

    @Override
    public float[] asOneDArray() {
        return (float[])super.asOneDArray(true);
    }

    @Override
    public float[] asOneDArray(boolean bl) {
        return (float[])super.asOneDArray(bl);
    }

    @Override
    public FloatArray asArray() throws Throwable {
        return new FloatArray(this._asArray());
    }
}

